// generated by Fast Light User Interface Designer (fluid) version 1.0100

#include "ObjectEditor.h"
// Quat - A 3D fractal generation program
// Copyright (C) 1997-2000 Dirk Meyer
// (email: dirk.meyer@studserv.uni-stuttgart.de)
// mail:  Dirk Meyer
//        Marbacher Weg 29
//        D-71334 Waiblingen
//        Germany
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
//#include <iostream>
//#include <string.h>
#include <cmath> // fabs
#include "ChildWindow.h"
#define VD(a) (a)->value()
#define VI(a) static_cast<int>((a)->value())
#include "MandelPreview.h"

inline void ObjectEditor::cb_maxiter_i(Fl_Value_Input* o, void*) {
  MP->maxiter(VI(o));
frac.maxiter = VI(o);
o->color(FL_WHITE);
if (VI(o)<=0) o->color(FL_RED);
if (VI(o)>65535) o->color(FL_RED);
o->redraw();
}
void ObjectEditor::cb_maxiter(Fl_Value_Input* o, void* v) {
  ((ObjectEditor*)(o->parent()->user_data()))->cb_maxiter_i(o,v);
}

inline void ObjectEditor::cb_lvalue_i(Fl_Value_Input* o, void*) {
  frac.lvalue = VD(o);
o->color(FL_WHITE);
if (fabs(VD(o))>2.0) o->color(FL_YELLOW);
if (fabs(VD(o))>=1000000.0) o->color(FL_RED);
o->redraw();
}
void ObjectEditor::cb_lvalue(Fl_Value_Input* o, void* v) {
  ((ObjectEditor*)(o->parent()->user_data()))->cb_lvalue_i(o,v);
}

inline void ObjectEditor::cb_bailout_i(Fl_Value_Input* o, void*) {
  MP->bailout(VD(o));
frac.bailout = VD(o);
o->color(FL_WHITE);
if (VD(o) <= 0.0 || VD(o) >= 1E20) o->color(FL_RED);
else if (VD(o) < 4.0) o->color(FL_YELLOW);
else o->color(FL_WHITE);
o->redraw();
}
void ObjectEditor::cb_bailout(Fl_Value_Input* o, void* v) {
  ((ObjectEditor*)(o->parent()->user_data()))->cb_bailout_i(o,v);
}

inline void ObjectEditor::cb_formula_i(Fl_Choice* o, void*) {
  MP->formula(VI(o));
frac.formula = VI(o);
formula_changed();
}
void ObjectEditor::cb_formula(Fl_Choice* o, void* v) {
  ((ObjectEditor*)(o->parent()->user_data()))->cb_formula_i(o,v);
}

Fl_Menu_Item ObjectEditor::menu_formula[] = {
 {"Classical Julia", 0x61,  0, 0, 0, 0, 0, 12, 0},
 {"Lambda Julia", 0x62,  0, 0, 0, 0, 0, 12, 0},
 {"x[n+1] = x[n]*ln(x[n]) - c", 0x63,  0, 0, 0, 0, 0, 12, 0},
 {"Cubic Julia", 0x64,  0, 0, 0, 0, 0, 12, 0},
 {"x[n+1] = x[n]^p1-c", 0x65,  0, 0, 0, 0, 0, 12, 0},
 {0}
};

inline void ObjectEditor::cb_cre_i(Fl_Value_Input* o, void*) {
  MP->SetCX(VD(o));
frac.c[0] = VD(o);
}
void ObjectEditor::cb_cre(Fl_Value_Input* o, void* v) {
  ((ObjectEditor*)(o->parent()->user_data()))->cb_cre_i(o,v);
}

inline void ObjectEditor::cb_ci_i(Fl_Value_Input* o, void*) {
  MP->SetCY(VD(o));
frac.c[1] = VD(o);
}
void ObjectEditor::cb_ci(Fl_Value_Input* o, void* v) {
  ((ObjectEditor*)(o->parent()->user_data()))->cb_ci_i(o,v);
}

inline void ObjectEditor::cb_cj_i(Fl_Value_Input* o, void*) {
  MP->cj(VD(o));
frac.c[2] = VD(o);
}
void ObjectEditor::cb_cj(Fl_Value_Input* o, void* v) {
  ((ObjectEditor*)(o->parent()->user_data()))->cb_cj_i(o,v);
}

inline void ObjectEditor::cb_ck_i(Fl_Value_Input* o, void*) {
  MP->ck(VD(o));
frac.c[3] = VD(o);
}
void ObjectEditor::cb_ck(Fl_Value_Input* o, void* v) {
  ((ObjectEditor*)(o->parent()->user_data()))->cb_ck_i(o,v);
}

inline void ObjectEditor::cb_up_i(Fl_Button*, void*) {
  MP->MoveUp();
}
void ObjectEditor::cb_up(Fl_Button* o, void* v) {
  ((ObjectEditor*)(o->parent()->parent()->user_data()))->cb_up_i(o,v);
}

inline void ObjectEditor::cb__i(Fl_Button*, void*) {
  MP->MoveLeft();
}
void ObjectEditor::cb_(Fl_Button* o, void* v) {
  ((ObjectEditor*)(o->parent()->parent()->user_data()))->cb__i(o,v);
}

inline void ObjectEditor::cb_1_i(Fl_Button*, void*) {
  MP->ZoomIn();
}
void ObjectEditor::cb_1(Fl_Button* o, void* v) {
  ((ObjectEditor*)(o->parent()->parent()->user_data()))->cb_1_i(o,v);
}

inline void ObjectEditor::cb_2_i(Fl_Button*, void*) {
  MP->ZoomOut();
}
void ObjectEditor::cb_2(Fl_Button* o, void* v) {
  ((ObjectEditor*)(o->parent()->parent()->user_data()))->cb_2_i(o,v);
}

inline void ObjectEditor::cb_3_i(Fl_Button*, void*) {
  MP->MoveRight();
}
void ObjectEditor::cb_3(Fl_Button* o, void* v) {
  ((ObjectEditor*)(o->parent()->parent()->user_data()))->cb_3_i(o,v);
}

inline void ObjectEditor::cb_down_i(Fl_Button*, void*) {
  MP->MoveDown();
}
void ObjectEditor::cb_down(Fl_Button* o, void* v) {
  ((ObjectEditor*)(o->parent()->parent()->user_data()))->cb_down_i(o,v);
}

inline void ObjectEditor::cb_redraw_i(Fl_Button*, void*) {
  MP->CalcImage();
MP->redraw();
MP->CheckUpdate();
}
void ObjectEditor::cb_redraw(Fl_Button* o, void* v) {
  ((ObjectEditor*)(o->parent()->user_data()))->cb_redraw_i(o,v);
}

inline void ObjectEditor::cb_p_re_i(Fl_Value_Input* o, void*) {
  MP->p(paramscroll->value()-1, 0, VD(o));
frac.p[paramscroll->value()-1][0] = VD(o);
//cout << paramscroll->value() << endl;
}
void ObjectEditor::cb_p_re(Fl_Value_Input* o, void* v) {
  ((ObjectEditor*)(o->parent()->parent()->user_data()))->cb_p_re_i(o,v);
}

inline void ObjectEditor::cb_p_i_i(Fl_Value_Input* o, void*) {
  MP->p(paramscroll->value()-1, 1, VD(o));
frac.p[paramscroll->value()-1][1] = VD(o);
}
void ObjectEditor::cb_p_i(Fl_Value_Input* o, void* v) {
  ((ObjectEditor*)(o->parent()->parent()->user_data()))->cb_p_i_i(o,v);
}

inline void ObjectEditor::cb_p_j_i(Fl_Value_Input* o, void*) {
  MP->p(paramscroll->value()-1, 2, VD(o));
frac.p[paramscroll->value()-1][2] = VD(o);
}
void ObjectEditor::cb_p_j(Fl_Value_Input* o, void* v) {
  ((ObjectEditor*)(o->parent()->parent()->user_data()))->cb_p_j_i(o,v);
}

inline void ObjectEditor::cb_p_k_i(Fl_Value_Input* o, void*) {
  MP->p(paramscroll->value()-1, 3, VD(o));
frac.p[paramscroll->value()-1][3] = VD(o);
}
void ObjectEditor::cb_p_k(Fl_Value_Input* o, void* v) {
  ((ObjectEditor*)(o->parent()->parent()->user_data()))->cb_p_k_i(o,v);
}

ObjectEditor::ObjectEditor(int X, int Y, int W, int H, const char *label) : Fl_Group(X, Y, W, H, label) {
  ChildWindow* w;
  { ChildWindow* o = win = new ChildWindow(416, 216);
    w = o;
    o->user_data((void*)(this));
    { Fl_Value_Input* o = maxiter = new Fl_Value_Input(10, 35, 60, 20, "Max.\nIteration");
      o->tooltip("Highest number of iterations done.");
      o->labelsize(12);
      o->minimum(1);
      o->maximum(1e+20);
      o->step(1);
      o->textsize(12);
      o->callback((Fl_Callback*)cb_maxiter);
      o->align(FL_ALIGN_TOP_LEFT);
    }
    { Fl_Value_Input* o = lvalue = new Fl_Value_Input(75, 35, 95, 20, "4th-dim.\nIntersection");
      o->tooltip("The constant value for the 4th part of a quaternion.");
      o->labelsize(12);
      o->minimum(-1e+20);
      o->maximum(1e+20);
      o->textsize(12);
      o->callback((Fl_Callback*)cb_lvalue);
      o->align(FL_ALIGN_TOP_LEFT);
    }
    { Fl_Value_Input* o = bailout = new Fl_Value_Input(175, 35, 95, 20, "Bailout");
      o->tooltip("If this value is exceeded, iteration is ready.");
      o->labelsize(12);
      o->maximum(1e+20);
      o->textsize(12);
      o->callback((Fl_Callback*)cb_bailout);
      o->align(FL_ALIGN_TOP_LEFT);
    }
    { Fl_Choice* o = formula = new Fl_Choice(65, 65, 205, 30, "Iteration  \nFormula  ");
      o->tooltip("The formula that gets iterated.");
      o->down_box(FL_BORDER_BOX);
      o->labelsize(12);
      o->textsize(12);
      o->callback((Fl_Callback*)cb_formula);
      o->menu(menu_formula);
    }
    { Fl_Value_Input* o = cre = new Fl_Value_Input(10, 125, 95, 20, "c (1, i, j, k parts)");
      o->tooltip("Real part of c.");
      o->labelsize(12);
      o->minimum(-1e+20);
      o->maximum(1e+20);
      o->textsize(12);
      o->callback((Fl_Callback*)cb_cre);
      o->align(FL_ALIGN_TOP_LEFT);
    }
    { Fl_Value_Input* o = ci = new Fl_Value_Input(10, 145, 95, 20, "value:");
      o->tooltip("1st imaginary (i) part of c.");
      o->labeltype(FL_NO_LABEL);
      o->labelsize(12);
      o->minimum(-1e+20);
      o->maximum(1e+20);
      o->textsize(12);
      o->callback((Fl_Callback*)cb_ci);
    }
    { Fl_Value_Input* o = cj = new Fl_Value_Input(10, 165, 95, 20, "value:");
      o->tooltip("2nd imaginary (j) part of c.");
      o->labeltype(FL_NO_LABEL);
      o->labelsize(12);
      o->minimum(-1e+20);
      o->maximum(1e+20);
      o->textsize(12);
      o->callback((Fl_Callback*)cb_cj);
    }
    { Fl_Value_Input* o = ck = new Fl_Value_Input(10, 185, 95, 19, "value:");
      o->tooltip("3rd imaginary part (k) of c.");
      o->labeltype(FL_NO_LABEL);
      o->labelsize(12);
      o->minimum(-1e+20);
      o->maximum(1e+20);
      o->textsize(12);
      o->callback((Fl_Callback*)cb_ck);
    }
    { Fl_Group* o = paramgroup = new Fl_Group(280, 20, 115, 125);
      { Fl_Box* o = new Fl_Box(285, 20, 105, 125, "Parameter");
        o->box(FL_UP_BOX);
        o->labelsize(12);
        o->align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE);
      }
      { Fl_Scrollbar* o = paramscroll = new Fl_Scrollbar(290, 120, 95, 15);
        o->type(1);
      }
      o->end();
    }
    { Fl_Group* o = new Fl_Group(225, 165, 80, 40);
      { Fl_Button* o = new Fl_Button(225, 165, 40, 20, "up");
        o->tooltip("Navigation in Mandelbrot Preview.");
        o->shortcut(0x80069);
        o->labelsize(12);
        o->callback((Fl_Callback*)cb_up);
      }
      { Fl_Button* o = new Fl_Button(225, 185, 20, 20, "<");
        o->tooltip("Navigation in Mandelbrot Preview: to the left.");
        o->shortcut(0x8006a);
        o->labelsize(12);
        o->callback((Fl_Callback*)cb_);
      }
      { Fl_Button* o = new Fl_Button(245, 185, 20, 20, "+");
        o->tooltip("Zoom In.");
        o->shortcut(0x2b);
        o->labelsize(12);
        o->callback((Fl_Callback*)cb_1);
      }
      { Fl_Button* o = new Fl_Button(265, 185, 20, 20, "-");
        o->tooltip("Zoom out.");
        o->shortcut(0x2d);
        o->labelsize(12);
        o->callback((Fl_Callback*)cb_2);
      }
      { Fl_Button* o = new Fl_Button(285, 185, 20, 20, ">");
        o->tooltip("Navigation in Mandelbrot Preview: to the right.");
        o->shortcut(0x8006c);
        o->labelsize(12);
        o->callback((Fl_Callback*)cb_3);
      }
      { Fl_Button* o = new Fl_Button(265, 165, 40, 20, "down");
        o->tooltip("Navigation in Mandelbrot Preview.");
        o->shortcut(0x8006b);
        o->labelsize(12);
        o->callback((Fl_Callback*)cb_down);
      }
      o->end();
    }
    { Fl_Button* o = redraw = new Fl_Button(225, 125, 45, 20, "&redraw");
      o->tooltip("Redraws the Mandebrot Preview.");
      o->shortcut(0x80072);
      o->labelsize(12);
      o->callback((Fl_Callback*)cb_redraw);
      o->deactivate();
    }
    { MandelPreview* o = MP = new MandelPreview(110, 125, 110, 80, "label");
      o->tooltip("Mandelbrot preview:\nfor easy selection of c (real- and i- part)\nRed frame: \
Redraw required.");
      o->box(FL_EMBOSSED_FRAME);
      o->labeltype(FL_NO_LABEL);
      o->labelsize(12);
    }
    { Fl_Group* o = paramgroup2 = new Fl_Group(290, 20, 95, 100);
      { Fl_Value_Input* o = p_re = new Fl_Value_Input(290, 35, 95, 20, "p1");
        o->tooltip("Real part of p1.");
        o->labelsize(12);
        o->minimum(-1e+20);
        o->maximum(1e+20);
        o->textsize(12);
        o->callback((Fl_Callback*)cb_p_re);
        o->align(FL_ALIGN_TOP_RIGHT);
      }
      { Fl_Value_Input* o = p_i = new Fl_Value_Input(290, 56, 95, 20, "value:");
        o->tooltip("1st imaginary (i) part of p1.");
        o->labeltype(FL_NO_LABEL);
        o->labelsize(12);
        o->minimum(-1e+20);
        o->maximum(1e+20);
        o->textsize(12);
        o->callback((Fl_Callback*)cb_p_i);
      }
      { Fl_Value_Input* o = p_j = new Fl_Value_Input(290, 76, 95, 20, "value:");
        o->tooltip("2nd imaginary (j) part of p1.");
        o->labeltype(FL_NO_LABEL);
        o->labelsize(12);
        o->minimum(-1e+20);
        o->maximum(1e+20);
        o->textsize(12);
        o->callback((Fl_Callback*)cb_p_j);
      }
      { Fl_Value_Input* o = p_k = new Fl_Value_Input(290, 96, 95, 19, "value:");
        o->tooltip("3rd imaginary (k) part of p1.");
        o->labeltype(FL_NO_LABEL);
        o->labelsize(12);
        o->minimum(-1e+20);
        o->maximum(1e+20);
        o->textsize(12);
        o->callback((Fl_Callback*)cb_p_k);
      }
      o->end();
    }
    o->clear_border();
    o->end();
  }
  MP->SetInputs(cre, ci, redraw);
end(); // VERY IMPORTANT!
win->position(X+2, Y+2);
// DON'T delete win in destructor (or elsewhere) 
// it's automatically deleted by Fl_Group
}

void ObjectEditor::set(const frac_cpp& f) {
  frac = f;
maxiter->value(f.maxiter); maxiter->do_callback();
lvalue->value(f.lvalue); lvalue->do_callback();
bailout->value(f.bailout); bailout->do_callback();
formula->value(f.formula); formula->do_callback(); // Also calls formula_changed()
cre->value(f.c[0]); cre->do_callback();
ci->value(f.c[1]); ci->do_callback();
cj->value(f.c[2]); cj->do_callback();
ck->value(f.c[3]); ck->do_callback();
for (int j=0; j<4; j++) for (int i=0; i<4; i++) MP->p(j, i, f.p[j][i]);
MP->CalcImage(); MP->CheckUpdate();
}

void ObjectEditor::get(frac_cpp& f) {
  f = frac;
return;
}

void ObjectEditor::formula_changed() {
  int pno = 0;
switch (frac.formula) {
	case 4: pno = 1; break;
	default: pno = 0; break;
}

if (pno == 0) { 
	paramgroup->hide();
	paramgroup2->hide();
}
else {
	paramgroup->show();
	paramgroup2->show();
}

paramscroll->scrollvalue(1,1,1,pno);
if (pno != 0) paramscroll_changed();
}

void ObjectEditor::paramscroll_changed() {
  int i = paramscroll->value();
p_re->value(frac.p[i-1][0]);
p_i->value(frac.p[i-1][1]);
p_j->value(frac.p[i-1][2]);
p_k->value(frac.p[i-1][3]);
}

void ObjectEditor::deactiv() {
  maxiter->deactivate();
lvalue->deactivate();
bailout->deactivate();
formula->deactivate();
cre->deactivate();
ci->deactivate();
cj->deactivate();
ck->deactivate();
MP->deactivate();
paramgroup2->deactivate();
}
