// generated by Fast Light User Interface Designer (fluid) version 1.0100

#include "OtherEditor.h"
// Quat - A 3D fractal generation program
// Copyright (C) 1997-2000 Dirk Meyer
// (email: dirk.meyer@studserv.uni-stuttgart.de)
// mail:  Dirk Meyer
//        Marbacher Weg 29
//        D-71334 Waiblingen
//        Germany
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#include <cassert>
//#include <cstring>
#include "ChildWindow.h"
#include "ViewSelector.h"

inline void OtherEditor::cb_xres_i(Fl_Value_Input* o, void*) {
  view.xres = static_cast<int>(o->value());
for (int i=0; i<3; i++) vs[i]->xres(view.xres);
checkValidity();
}
void OtherEditor::cb_xres(Fl_Value_Input* o, void* v) {
  ((OtherEditor*)(o->parent()->parent()->user_data()))->cb_xres_i(o,v);
}

inline void OtherEditor::cb_yres_i(Fl_Value_Input* o, void*) {
  view.yres = static_cast<int>(o->value());
for (int i=0; i<3; i++) vs[i]->yres(view.yres);
checkValidity();
}
void OtherEditor::cb_yres(Fl_Value_Input* o, void* v) {
  ((OtherEditor*)(o->parent()->parent()->user_data()))->cb_yres_i(o,v);
}

inline void OtherEditor::cb_zres_i(Fl_Value_Input* o, void*) {
  view.zres = static_cast<int>(o->value());
checkValidity();
}
void OtherEditor::cb_zres(Fl_Value_Input* o, void* v) {
  ((OtherEditor*)(o->parent()->parent()->user_data()))->cb_zres_i(o,v);
}

inline void OtherEditor::cb_phongmax_i(Fl_Value_Input* o, void*) {
  view.phongmax = o->value();
checkValidity();
}
void OtherEditor::cb_phongmax(Fl_Value_Input* o, void* v) {
  ((OtherEditor*)(o->parent()->user_data()))->cb_phongmax_i(o,v);
}

inline void OtherEditor::cb_phongsharp_i(Fl_Value_Input* o, void*) {
  view.phongsharp = o->value();
checkValidity();
}
void OtherEditor::cb_phongsharp(Fl_Value_Input* o, void* v) {
  ((OtherEditor*)(o->parent()->user_data()))->cb_phongsharp_i(o,v);
}

inline void OtherEditor::cb_ambient_i(Fl_Value_Input* o, void*) {
  view.ambient = o->value();
checkValidity();
}
void OtherEditor::cb_ambient(Fl_Value_Input* o, void* v) {
  ((OtherEditor*)(o->parent()->user_data()))->cb_ambient_i(o,v);
}

inline void OtherEditor::cb_antialiasing_i(Fl_Value_Input* o, void*) {
  view.antialiasing = static_cast<int>(o->value());
checkValidity();
}
void OtherEditor::cb_antialiasing(Fl_Value_Input* o, void* v) {
  ((OtherEditor*)(o->parent()->user_data()))->cb_antialiasing_i(o,v);
}

inline void OtherEditor::cb_res1_i(Fl_Button*, void*) {
  xres->value(1170); yres->value(828);
xres->do_callback(); yres->do_callback();
}
void OtherEditor::cb_res1(Fl_Button* o, void* v) {
  ((OtherEditor*)(o->parent()->parent()->user_data()))->cb_res1_i(o,v);
}

inline void OtherEditor::cb_res1b_i(Fl_Button*, void*) {
  xres->value(3511); yres->value(2483);
xres->do_callback(); yres->do_callback();
}
void OtherEditor::cb_res1b(Fl_Button* o, void* v) {
  ((OtherEditor*)(o->parent()->parent()->user_data()))->cb_res1b_i(o,v);
}

inline void OtherEditor::cb_res2_i(Fl_Button*, void*) {
  xres->value(160); yres->value(120); zres->value(120);
xres->do_callback(); yres->do_callback(); zres->do_callback();
}
void OtherEditor::cb_res2(Fl_Button* o, void* v) {
  ((OtherEditor*)(o->parent()->parent()->user_data()))->cb_res2_i(o,v);
}

inline void OtherEditor::cb_res3_i(Fl_Button*, void*) {
  xres->value(320); yres->value(240); zres->value(240);
xres->do_callback(); yres->do_callback(); zres->do_callback();
}
void OtherEditor::cb_res3(Fl_Button* o, void* v) {
  ((OtherEditor*)(o->parent()->parent()->user_data()))->cb_res3_i(o,v);
}

inline void OtherEditor::cb_res4_i(Fl_Button*, void*) {
  xres->value(640); yres->value(480); zres->value(480);
xres->do_callback(); yres->do_callback(); zres->do_callback();
}
void OtherEditor::cb_res4(Fl_Button* o, void* v) {
  ((OtherEditor*)(o->parent()->parent()->user_data()))->cb_res4_i(o,v);
}

OtherEditor::OtherEditor(int X, int Y, int W, int H, const char *label) : Fl_Group(X,Y,W,H,label) {
  ChildWindow* w;
  { ChildWindow* o = win = new ChildWindow(416, 216);
    w = o;
    o->user_data((void*)(this));
    { Fl_Box* o = new Fl_Box(10, 5, 330, 70, "Image Resolution");
      o->box(FL_ENGRAVED_FRAME);
      o->labelsize(12);
      o->align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE);
    }
    { Fl_Group* o = group_res = new Fl_Group(10, 5, 330, 70);
      { Fl_Value_Input* o = xres = new Fl_Value_Input(20, 40, 90, 20, "X Resolution");
        o->tooltip("Horizontal size of the image.");
        o->labelsize(12);
        o->minimum(1);
        o->maximum(32767);
        o->step(1);
        o->textsize(12);
        o->callback((Fl_Callback*)cb_xres);
        o->align(FL_ALIGN_TOP_LEFT);
      }
      { Fl_Value_Input* o = yres = new Fl_Value_Input(130, 40, 90, 20, "Y Resolution");
        o->tooltip("Vertical size of the image.");
        o->labelsize(12);
        o->minimum(1);
        o->maximum(32767);
        o->step(1);
        o->textsize(12);
        o->callback((Fl_Callback*)cb_yres);
        o->align(FL_ALIGN_TOP_LEFT);
      }
      { Fl_Value_Input* o = zres = new Fl_Value_Input(240, 40, 90, 20, "Z Resolution");
        o->tooltip("Describes how exact the object is scanned.");
        o->labelsize(12);
        o->minimum(1);
        o->maximum(32767);
        o->step(1);
        o->textsize(12);
        o->callback((Fl_Callback*)cb_zres);
        o->align(FL_ALIGN_TOP_LEFT);
      }
      o->end();
    }
    { Fl_Box* o = new Fl_Box(10, 85, 240, 70, "Phong Highlight");
      o->box(FL_ENGRAVED_FRAME);
      o->labelsize(12);
      o->align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE);
    }
    { Fl_Value_Input* o = phongmax = new Fl_Value_Input(20, 125, 100, 20, "max.");
      o->tooltip("Maximum brightness of the highlight.");
      o->labelsize(12);
      o->textsize(12);
      o->callback((Fl_Callback*)cb_phongmax);
      o->align(FL_ALIGN_TOP_LEFT);
    }
    { Fl_Value_Input* o = phongsharp = new Fl_Value_Input(140, 125, 100, 20, "sharp");
      o->tooltip("Describes how fast the highlight will fade into usual light.");
      o->labelsize(12);
      o->maximum(1e+20);
      o->textsize(12);
      o->callback((Fl_Callback*)cb_phongsharp);
      o->align(FL_ALIGN_TOP_LEFT);
    }
    { Fl_Value_Input* o = ambient = new Fl_Value_Input(20, 180, 100, 20, "Ambient Light");
      o->tooltip("The brightness that is even in shadowed parts of the object.");
      o->labelsize(12);
      o->maximum(1e+20);
      o->textsize(12);
      o->callback((Fl_Callback*)cb_ambient);
      o->align(FL_ALIGN_TOP_LEFT);
    }
    { Fl_Value_Input* o = antialiasing = new Fl_Value_Input(140, 180, 90, 20, "Antialiasing");
      o->tooltip("Subdivide pixels n*n times. Higher values result in smoother\nimages and long\
er calculation time.");
      o->labelsize(12);
      o->minimum(1);
      o->maximum(5);
      o->step(1);
      o->value(1);
      o->textsize(12);
      o->callback((Fl_Callback*)cb_antialiasing);
      o->align(FL_ALIGN_TOP_LEFT);
    }
    { Fl_Box* o = new Fl_Box(280, 85, 120, 20, "Resolution shortcuts");
      o->labelsize(12);
      o->align(FL_ALIGN_TOP_LEFT|FL_ALIGN_INSIDE);
    }
    { Fl_Group* o = group_buttons = new Fl_Group(280, 85, 110, 115);
      o->tooltip("Clicking on one of those buttons will set a predefined resolution.");
      { Fl_Button* o = res1 = new Fl_Button(280, 100, 110, 20, "DIN A4 (100 dpi)");
        o->tooltip("A whole sheet of paper printed in 100 dpi.");
        o->labelsize(12);
        o->callback((Fl_Callback*)cb_res1);
      }
      { Fl_Button* o = res1b = new Fl_Button(280, 120, 110, 20, "DIN A4 (300 dpi)");
        o->tooltip("A whole sheet of paper printed in 300 dpi.");
        o->labelsize(12);
        o->callback((Fl_Callback*)cb_res1b);
      }
      { Fl_Button* o = res2 = new Fl_Button(280, 140, 110, 20, "160x120x120");
        o->tooltip("A small image for testing.");
        o->labelsize(12);
        o->callback((Fl_Callback*)cb_res2);
      }
      { Fl_Button* o = res3 = new Fl_Button(280, 160, 110, 20, "320x240x240");
        o->tooltip("Medium sized image.");
        o->labelsize(12);
        o->callback((Fl_Callback*)cb_res3);
      }
      { Fl_Button* o = res4 = new Fl_Button(280, 180, 110, 20, "640x480x480");
        o->tooltip("Common resolution.");
        o->labelsize(12);
        o->callback((Fl_Callback*)cb_res4);
      }
      o->end();
    }
    o->clear_border();
    o->end();
  }
  //memset(&view, 0, sizeof(view));
end(); // VERY IMPORTANT!
win->position(X+2, Y+2);
// DON'T delete win in destructor (or elsewhere) 
// it's automatically deleted by Fl_Group
}

void OtherEditor::setSelectors(ViewSelector *vsa, ViewSelector *vsb, ViewSelector *vsf) {
  vs[0] = vsa; vs[1] = vsb; vs[2] = vsf;
}

void OtherEditor::set(const view_struct& v) {
  for (int i=0; i<3; i++) assert(vs[i] != 0);
view = v;
xres->value(v.xres); yres->value(v.yres); zres->value(v.zres);
phongmax->value(v.phongmax); phongsharp->value(v.phongsharp);
ambient->value(v.ambient); antialiasing->value(v.antialiasing);

// Callbacks & checkValidity
xres->do_callback();
yres->do_callback();

return;
}

void OtherEditor::get(view_struct& v) {
  // Don't do v=view, because there are other members
// which aren't in the ViewEditor

v.xres = static_cast<int>(view.xres); 
v.yres = static_cast<int>(view.yres); 
v.zres = static_cast<int>(view.zres);
v.phongmax = view.phongmax; v.phongsharp = view.phongsharp;
v.ambient = view.ambient; 
v.antialiasing = static_cast<int>(view.antialiasing);

return;
}

void OtherEditor::checkValidity() {
  const Fl_Color okc = FL_WHITE;
const Fl_Color ndefc = FL_RED;
Fl_Color xres_c = okc, yres_c = okc, zres_c = okc,
	pm_c = okc, ps_c = okc, amb_c = okc, ant_c = okc;

if (view.xres < 1 || view.xres > 32767) xres_c = ndefc;
if (view.yres < 1 || view.yres > 32767) yres_c = ndefc;
if (view.zres < 1) zres_c = ndefc;

if (view.phongmax < 0.0 || view.phongmax > 1.0) pm_c = ndefc;
if (view.phongsharp < 0.0) ps_c = ndefc;

if (view.ambient < 0.0 || view.ambient >1.0) amb_c = ndefc;
if (view.antialiasing < 1 || view.antialiasing > 5) ant_c = ndefc;

if (xres->color() != xres_c) { xres->color(xres_c); xres->redraw(); }
if (yres->color() != yres_c) { yres->color(yres_c); yres->redraw(); }
if (zres->color() != zres_c) { zres->color(zres_c); zres->redraw(); }
if (phongmax->color() != pm_c) { phongmax->color(pm_c); phongmax->redraw(); }
if (phongsharp->color() != ps_c) { phongsharp->color(ps_c); phongsharp->redraw(); }
if (ambient->color() != amb_c) { ambient->color(amb_c); ambient->redraw(); }
if (antialiasing->color() != ant_c) { antialiasing->color(ant_c); antialiasing->redraw(); }

return;
}
