/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.analysis.TypeCoercion$;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ElementAt$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.GetArrayItemUtil;
import org.apache.spark.sql.catalyst.expressions.GetMapValueUtil;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.IntegralType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.MapType$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(array, index) - Returns element of array at given (1-based) index. If index < 0,\n      accesses elements from the last to the first. The function returns NULL\n      if the index exceeds the length of the array and `spark.sql.ansi.enabled` is set to false.\n      If `spark.sql.ansi.enabled` is set to true, it throws ArrayIndexOutOfBoundsException\n      for invalid indices.\n\n    _FUNC_(map, key) - Returns value for given key. The function returns NULL\n      if the key is not contained in the map and `spark.sql.ansi.enabled` is set to false.\n      If `spark.sql.ansi.enabled` is set to true, it throws NoSuchElementException instead.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(array(1, 2, 3), 2);\n       2\n      > SELECT _FUNC_(map(1, 'a', 2, 'b'), 2);\n       b\n  ", since="2.4.0")
@ScalaSignature(bytes="\u0006\u0001\tec\u0001B\u0015+\u0001^B\u0001B\u0015\u0001\u0003\u0016\u0004%\ta\u0015\u0005\t/\u0002\u0011\t\u0012)A\u0005)\"A\u0001\f\u0001BK\u0002\u0013\u00051\u000b\u0003\u0005Z\u0001\tE\t\u0015!\u0003U\u0011!Q\u0006A!f\u0001\n\u0003Y\u0006\u0002C0\u0001\u0005#\u0005\u000b\u0011\u0002/\t\u000b\u0001\u0004A\u0011A1\t\u000b\u0001\u0004A\u0011\u00014\t\u0011%\u0004\u0001R1A\u0005\n)D\u0001\"\u001e\u0001\t\u0006\u0004%Ia\u0017\u0005\to\u0002A)\u0019!C\u00057\"A\u0011\u0010\u0001EC\u0002\u0013%!\u0010C\u0005\u0002\u0016\u0001A)\u0019!C!U\"9\u0011\u0011\u0004\u0001\u0005B\u0005m\u0001bBA\u0015\u0001\u0011\u0005\u00131\u0006\u0005\b\u0003s\u0001A\u0011BA\u001e\u0011\u0019\ti\u0005\u0001C!7\"9\u0011q\n\u0001\u0005B\u0005E\u0003BCA-\u0001!\u0015\r\u0011\"\u0003\u0002\\!9\u0011Q\r\u0001\u0005B\u0005\u001d\u0004bBAB\u0001\u0011\u0005\u0013Q\u0011\u0005\n\u0003/\u0003\u0011\u0011!C\u0001\u00033C\u0011\"!)\u0001#\u0003%\t!a)\t\u0013\u0005e\u0006!%A\u0005\u0002\u0005\r\u0006\"CA^\u0001E\u0005I\u0011AA_\u0011%\t\t\rAA\u0001\n\u0003\n\u0019\rC\u0005\u0002T\u0002\t\t\u0011\"\u0001\u0002V\"I\u0011q\u001b\u0001\u0002\u0002\u0013\u0005\u0011\u0011\u001c\u0005\n\u0003?\u0004\u0011\u0011!C!\u0003CD\u0011\"a<\u0001\u0003\u0003%\t!!=\t\u0013\u0005U\b!!A\u0005B\u0005]x!\u0003B\u000bU\u0005\u0005\t\u0012\u0001B\f\r!I#&!A\t\u0002\te\u0001B\u00021\"\t\u0003\u00119\u0003C\u0005\u0003*\u0005\n\t\u0011\"\u0012\u0003,!I!QF\u0011\u0002\u0002\u0013\u0005%q\u0006\u0005\n\u0005o\t\u0013\u0013!C\u0001\u0003{C\u0011B!\u000f\"\u0003\u0003%\tIa\u000f\t\u0013\t5\u0013%%A\u0005\u0002\u0005u\u0006\"\u0003B(C\u0005\u0005I\u0011\u0002B)\u0005%)E.Z7f]R\fEO\u0003\u0002,Y\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\tic&\u0001\u0005dCR\fG._:u\u0015\ty\u0003'A\u0002tc2T!!\r\u001a\u0002\u000bM\u0004\u0018M]6\u000b\u0005M\"\u0014AB1qC\u000eDWMC\u00016\u0003\ry'oZ\u0002\u0001'\u001d\u0001\u0001\bP C\u0013>\u0003\"!\u000f\u001e\u000e\u0003)J!a\u000f\u0016\u0003!\tKg.\u0019:z\u000bb\u0004(/Z:tS>t\u0007CA\u001d>\u0013\tq$FA\bHKRl\u0015\r\u001d,bYV,W\u000b^5m!\tI\u0004)\u0003\u0002BU\t\u0001r)\u001a;BeJ\f\u00170\u0013;f[V#\u0018\u000e\u001c\t\u0003\u0007\u001as!!\u000f#\n\u0005\u0015S\u0013a\u00029bG.\fw-Z\u0005\u0003\u000f\"\u0013aBT;mY&sGo\u001c7fe\u0006tGO\u0003\u0002FUA\u0011!*T\u0007\u0002\u0017*\tA*A\u0003tG\u0006d\u0017-\u0003\u0002O\u0017\n9\u0001K]8ek\u000e$\bC\u0001&Q\u0013\t\t6J\u0001\u0007TKJL\u0017\r\\5{C\ndW-\u0001\u0003mK\u001a$X#\u0001+\u0011\u0005e*\u0016B\u0001,+\u0005))\u0005\u0010\u001d:fgNLwN\\\u0001\u0006Y\u00164G\u000fI\u0001\u0006e&<\u0007\u000e^\u0001\u0007e&<\u0007\u000e\u001e\u0011\u0002\u0017\u0019\f\u0017\u000e\\(o\u000bJ\u0014xN]\u000b\u00029B\u0011!*X\u0005\u0003=.\u0013qAQ8pY\u0016\fg.\u0001\u0007gC&dwJ\\#se>\u0014\b%\u0001\u0004=S:LGO\u0010\u000b\u0005E\u000e$W\r\u0005\u0002:\u0001!)!k\u0002a\u0001)\")\u0001l\u0002a\u0001)\"9!l\u0002I\u0001\u0002\u0004aFc\u00012hQ\")!\u000b\u0003a\u0001)\")\u0001\f\u0003a\u0001)\u0006QQ.\u00199LKf$\u0016\u0010]3\u0016\u0003-\u0004\"\u0001\\8\u000e\u00035T!A\u001c\u0018\u0002\u000bQL\b/Z:\n\u0005Al'\u0001\u0003#bi\u0006$\u0016\u0010]3)\u0005%\u0011\bC\u0001&t\u0013\t!8JA\u0005ue\u0006t7/[3oi\u0006!R.\u00199WC2,XmQ8oi\u0006Lgn\u001d(vY2D#A\u0003:\u0002#\u0005\u0014(/Y=D_:$\u0018-\u001b8t\u001dVdG\u000e\u000b\u0002\fe\u0006AqN\u001d3fe&tw-F\u0001|!\u0015a\u0018qAA\u0007\u001d\ri\u0018Q\u0001\b\u0004}\u0006\rQ\"A@\u000b\u0007\u0005\u0005a'\u0001\u0004=e>|GOP\u0005\u0002\u0019&\u0011QiS\u0005\u0005\u0003\u0013\tYA\u0001\u0005Pe\u0012,'/\u001b8h\u0015\t)5\nE\u0002K\u0003\u001fI1!!\u0005L\u0005\r\te.\u001f\u0015\u0003\u0019I\f\u0001\u0002Z1uCRK\b/\u001a\u0015\u0003\u001bI\f!\"\u001b8qkR$\u0016\u0010]3t+\t\ti\u0002E\u0003}\u0003?\t\u0019#\u0003\u0003\u0002\"\u0005-!aA*fcB\u0019A.!\n\n\u0007\u0005\u001dRN\u0001\tBEN$(/Y2u\t\u0006$\u0018\rV=qK\u0006\u00192\r[3dW&s\u0007/\u001e;ECR\fG+\u001f9fgR\u0011\u0011Q\u0006\t\u0005\u0003_\t)$\u0004\u0002\u00022)\u0019\u00111\u0007\u0017\u0002\u0011\u0005t\u0017\r\\=tSNLA!a\u000e\u00022\tyA+\u001f9f\u0007\",7m\u001b*fgVdG/A\u0006ok2d\u0017MY5mSRLH#\u0002/\u0002>\u0005\r\u0003bBA !\u0001\u0007\u0011\u0011I\u0001\tK2,W.\u001a8ugB!A0a\bU\u0011\u001d\t)\u0005\u0005a\u0001\u0003\u000f\nqa\u001c:eS:\fG\u000eE\u0002K\u0003\u0013J1!a\u0013L\u0005\rIe\u000e^\u0001\t]VdG.\u00192mK\u0006aa.\u001e7m'\u00064W-\u0012<bYR1\u0011QBA*\u0003/Bq!!\u0016\u0013\u0001\u0004\ti!A\u0003wC2,X\rC\u0004\u0002FI\u0001\r!!\u0004\u0002\u0017\u0011|W\t\\3nK:$\u0018\t^\u000b\u0003\u0003;\u0002\u0012BSA0\u0003\u001b\ti!!\u0004\n\u0007\u0005\u00054JA\u0005Gk:\u001cG/[8oe!\u00121C]\u0001\nI><UM\\\"pI\u0016$b!!\u001b\u0002v\u0005}\u0004\u0003BA6\u0003cj!!!\u001c\u000b\u0007\u0005=$&A\u0004d_\u0012,w-\u001a8\n\t\u0005M\u0014Q\u000e\u0002\t\u000bb\u0004(oQ8eK\"9\u0011q\u000f\u000bA\u0002\u0005e\u0014aA2uqB!\u00111NA>\u0013\u0011\ti(!\u001c\u0003\u001d\r{G-Z4f]\u000e{g\u000e^3yi\"9\u0011\u0011\u0011\u000bA\u0002\u0005%\u0014AA3w\u0003)\u0001(/\u001a;us:\u000bW.Z\u000b\u0003\u0003\u000f\u0003B!!#\u0002\u0012:!\u00111RAG!\tq8*C\u0002\u0002\u0010.\u000ba\u0001\u0015:fI\u00164\u0017\u0002BAJ\u0003+\u0013aa\u0015;sS:<'bAAH\u0017\u0006!1m\u001c9z)\u001d\u0011\u00171TAO\u0003?CqA\u0015\f\u0011\u0002\u0003\u0007A\u000bC\u0004Y-A\u0005\t\u0019\u0001+\t\u000fi3\u0002\u0013!a\u00019\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAASU\r!\u0016qU\u0016\u0003\u0003S\u0003B!a+\u000266\u0011\u0011Q\u0016\u0006\u0005\u0003_\u000b\t,A\u0005v]\u000eDWmY6fI*\u0019\u00111W&\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u00028\u00065&!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0014AD2paf$C-\u001a4bk2$HeM\u000b\u0003\u0003\u007fS3\u0001XAT\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011Q\u0019\t\u0005\u0003\u000f\f\t.\u0004\u0002\u0002J*!\u00111ZAg\u0003\u0011a\u0017M\\4\u000b\u0005\u0005=\u0017\u0001\u00026bm\u0006LA!a%\u0002J\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011qI\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\ti!a7\t\u0013\u0005uG$!AA\u0002\u0005\u001d\u0013a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002dB1\u0011Q]Av\u0003\u001bi!!a:\u000b\u0007\u0005%8*\u0001\u0006d_2dWm\u0019;j_:LA!!<\u0002h\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\ra\u00161\u001f\u0005\n\u0003;t\u0012\u0011!a\u0001\u0003\u001b\ta!Z9vC2\u001cHc\u0001/\u0002z\"I\u0011Q\\\u0010\u0002\u0002\u0003\u0007\u0011Q\u0002\u0015\u0010\u0001\u0005u(1\u0001B\u0003\u0005\u0013\u0011YAa\u0004\u0003\u0012A\u0019\u0011(a@\n\u0007\t\u0005!FA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\t\u001d\u0011!\"\u0006\u000bA\u0001\u0002\u0003e\u0018$V\u001d\u000e{\u0006&\u0019:sCfd\u0003%\u001b8eKbL\u0003%\f\u0011SKR,(O\\:!K2,W.\u001a8uA=4\u0007%\u0019:sCf\u0004\u0013\r\u001e\u0011hSZ,g\u000e\t\u00152[\t\f7/\u001a3*A%tG-\u001a=/A%3\u0007%\u001b8eKb\u0004C\b\t\u0019-\u0015\u0001\u0002\u0003\u0005\t\u0011!C\u000e\u001cWm]:fg\u0002*G.Z7f]R\u001c\bE\u001a:p[\u0002\"\b.\u001a\u0011mCN$\b\u0005^8!i\",\u0007EZ5sgRt\u0003\u0005\u00165fA\u0019,hn\u0019;j_:\u0004#/\u001a;ve:\u001c\bET+M\u0019*\u0001\u0003\u0005\t\u0011!A%4\u0007\u0005\u001e5fA%tG-\u001a=!Kb\u001cW-\u001a3tAQDW\r\t7f]\u001e$\b\u000eI8gAQDW\rI1se\u0006L\b%\u00198eA\u0001\u001c\b/\u0019:l]M\fHNL1og&tSM\\1cY\u0016$\u0007\rI5tAM,G\u000f\t;pA\u0019\fGn]3/\u0015\u0001\u0002\u0003\u0005\t\u0011!\u0013\u001a\u0004\u0003m\u001d9be.t3/\u001d7/C:\u001c\u0018NL3oC\ndW\r\u001a1!SN\u00043/\u001a;!i>\u0004CO];fY\u0001JG\u000f\t;ie><8\u000fI!se\u0006L\u0018J\u001c3fq>+Ho\u00144C_VtGm]#yG\u0016\u0004H/[8o\u0015\u0001\u0002\u0003\u0005\t\u0011!M>\u0014\b%\u001b8wC2LG\rI5oI&\u001cWm\u001d\u0018\u000b\u0015\u0001\u0002\u0003\u0005I0G+:\u001bu\fK7ba2\u00023.Z=*A5\u0002#+\u001a;ve:\u001c\bE^1mk\u0016\u0004cm\u001c:!O&4XM\u001c\u0011lKft\u0003\u0005\u00165fA\u0019,hn\u0019;j_:\u0004#/\u001a;ve:\u001c\bET+M\u0019*\u0001\u0003\u0005\t\u0011!A%4\u0007\u0005\u001e5fA-,\u0017\u0010I5tA9|G\u000fI2p]R\f\u0017N\\3eA%t\u0007\u0005\u001e5fA5\f\u0007\u000fI1oI\u0002\u00027\u000f]1sW:\u001a\u0018\u000f\u001c\u0018b]NLg&\u001a8bE2,G\r\u0019\u0011jg\u0002\u001aX\r\u001e\u0011u_\u00022\u0017\r\\:f])\u0001\u0003\u0005\t\u0011!A%3\u0007\u0005Y:qCJ\\gf]9m]\u0005t7/\u001b\u0018f]\u0006\u0014G.\u001a3aA%\u001c\be]3uAQ|\u0007\u0005\u001e:vK2\u0002\u0013\u000e\u001e\u0011uQJ|wo\u001d\u0011O_N+8\r[#mK6,g\u000e^#yG\u0016\u0004H/[8oA%t7\u000f^3bI:R\u0001\u0005I\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012!QB\u0001}\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\n'O]1zQEb\u0003E\r\u0017!g%b\u0003EM\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AIR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006&\\1qQEb\u0003eJ1(Y\u0001\u0012D\u0006I\u0014cO%b\u0003EM\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!A\tT\u0001\u0005I\u0001\u0006g&t7-Z\u0011\u0003\u0005'\tQA\r\u00185]A\n\u0011\"\u00127f[\u0016tG/\u0011;\u0011\u0005e\n3\u0003B\u0011\u0003\u001c=\u0003\u0002B!\b\u0003$Q#FLY\u0007\u0003\u0005?Q1A!\tL\u0003\u001d\u0011XO\u001c;j[\u0016LAA!\n\u0003 \t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u001a\u0015\u0005\t]\u0011\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005\u0015\u0017!B1qa2LHc\u00022\u00032\tM\"Q\u0007\u0005\u0006%\u0012\u0002\r\u0001\u0016\u0005\u00061\u0012\u0002\r\u0001\u0016\u0005\b5\u0012\u0002\n\u00111\u0001]\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\u001a\u0014aB;oCB\u0004H.\u001f\u000b\u0005\u0005{\u0011I\u0005E\u0003K\u0005\u007f\u0011\u0019%C\u0002\u0003B-\u0013aa\u00149uS>t\u0007C\u0002&\u0003FQ#F,C\u0002\u0003H-\u0013a\u0001V;qY\u0016\u001c\u0004\u0002\u0003B&M\u0005\u0005\t\u0019\u00012\u0002\u0007a$\u0003'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HeM\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0003TA!\u0011q\u0019B+\u0013\u0011\u00119&!3\u0003\r=\u0013'.Z2u\u0001")
public class ElementAt
extends BinaryExpression
implements GetMapValueUtil,
GetArrayItemUtil,
package.NullIntolerant,
scala.Serializable {
    private transient DataType mapKeyType;
    private transient boolean mapValueContainsNull;
    private transient boolean arrayContainsNull;
    private transient Ordering<Object> ordering;
    private transient DataType dataType;
    private transient Function2<Object, Object, Object> doElementAt;
    private final Expression left;
    private final Expression right;
    private final boolean failOnError;
    private volatile transient byte bitmap$trans$0;

    public static boolean $lessinit$greater$default$3() {
        return ElementAt$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple3<Expression, Expression, Object>> unapply(ElementAt elementAt) {
        return ElementAt$.MODULE$.unapply(elementAt);
    }

    public static boolean apply$default$3() {
        return ElementAt$.MODULE$.apply$default$3();
    }

    public static Function1<Tuple3<Expression, Expression, Object>, ElementAt> tupled() {
        return ElementAt$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Object, ElementAt>>> curried() {
        return ElementAt$.MODULE$.curried();
    }

    @Override
    public boolean computeNullabilityFromArray(Expression child, Expression ordinal, boolean failOnError, Function2<Seq<Expression>, Object, Object> nullability) {
        return GetArrayItemUtil.computeNullabilityFromArray$(this, child, ordinal, failOnError, nullability);
    }

    @Override
    public Object getValueEval(Object value, Object ordinal, DataType keyType, Ordering<Object> ordering, boolean failOnError) {
        return GetMapValueUtil.getValueEval$(this, value, ordinal, keyType, ordering, failOnError);
    }

    @Override
    public ExprCode doGetValueGenCode(CodegenContext ctx, ExprCode ev, MapType mapType, boolean failOnError) {
        return GetMapValueUtil.doGetValueGenCode$(this, ctx, ev, mapType, failOnError);
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    public boolean failOnError() {
        return this.failOnError;
    }

    private DataType mapKeyType$lzycompute() {
        ElementAt elementAt = this;
        synchronized (elementAt) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.mapKeyType = ((MapType)this.left().dataType()).keyType();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.mapKeyType;
    }

    private DataType mapKeyType() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.mapKeyType$lzycompute() : this.mapKeyType;
    }

    private boolean mapValueContainsNull$lzycompute() {
        ElementAt elementAt = this;
        synchronized (elementAt) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.mapValueContainsNull = ((MapType)this.left().dataType()).valueContainsNull();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.mapValueContainsNull;
    }

    private boolean mapValueContainsNull() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.mapValueContainsNull$lzycompute() : this.mapValueContainsNull;
    }

    private boolean arrayContainsNull$lzycompute() {
        ElementAt elementAt = this;
        synchronized (elementAt) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.arrayContainsNull = ((ArrayType)this.left().dataType()).containsNull();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.arrayContainsNull;
    }

    private boolean arrayContainsNull() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.arrayContainsNull$lzycompute() : this.arrayContainsNull;
    }

    private Ordering<Object> ordering$lzycompute() {
        ElementAt elementAt = this;
        synchronized (elementAt) {
            if ((byte)(this.bitmap$trans$0 & 8) == 0) {
                this.ordering = TypeUtils$.MODULE$.getInterpretedOrdering(this.mapKeyType());
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 8);
            }
        }
        return this.ordering;
    }

    private Ordering<Object> ordering() {
        return (byte)(this.bitmap$trans$0 & 8) == 0 ? this.ordering$lzycompute() : this.ordering;
    }

    private DataType dataType$lzycompute() {
        ElementAt elementAt = this;
        synchronized (elementAt) {
            if ((byte)(this.bitmap$trans$0 & 0x10) == 0) {
                DataType dataType;
                DataType dataType2 = this.left().dataType();
                if (dataType2 instanceof ArrayType) {
                    DataType elementType;
                    ArrayType arrayType = (ArrayType)dataType2;
                    dataType = elementType = arrayType.elementType();
                } else if (dataType2 instanceof MapType) {
                    DataType valueType;
                    MapType mapType = (MapType)dataType2;
                    dataType = valueType = mapType.valueType();
                } else {
                    throw new MatchError((Object)dataType2);
                }
                this.dataType = dataType;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 0x10);
            }
        }
        return this.dataType;
    }

    @Override
    public DataType dataType() {
        return (byte)(this.bitmap$trans$0 & 0x10) == 0 ? this.dataType$lzycompute() : this.dataType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Seq<AbstractDataType> inputTypes() {
        Tuple2 tuple2 = new Tuple2((Object)this.left().dataType(), (Object)this.right().dataType());
        if (tuple2 != null) {
            DataType arr = (DataType)tuple2._1();
            DataType e2 = (DataType)tuple2._2();
            if (arr instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)arr;
                if (e2 instanceof IntegralType) {
                    IntegralType integralType;
                    IntegralType integralType2 = integralType = (IntegralType)e2;
                    LongType$ longType$ = LongType$.MODULE$;
                    if (integralType2 == null ? longType$ != null : !integralType2.equals(longType$)) {
                        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DataType[]{arrayType, IntegerType$.MODULE$}));
                    }
                }
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            DataType e2 = (DataType)tuple2._2();
            if (dataType instanceof MapType) {
                Seq seq;
                MapType mapType = (MapType)dataType;
                DataType keyType = mapType.keyType();
                DataType valueType = mapType.valueType();
                boolean hasNull = mapType.valueContainsNull();
                Option option = (Option)TypeCoercion$.MODULE$.findTightestCommonType().apply((Object)keyType, (Object)e2);
                if (option instanceof Some) {
                    Some some = (Some)option;
                    DataType dt = (DataType)some.value();
                    seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DataType[]{new MapType(dt, valueType, hasNull), dt}));
                    return seq;
                } else {
                    seq = (Seq)Seq$.MODULE$.empty();
                }
                return seq;
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        return (Seq)Seq$.MODULE$.empty();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    public TypeCheckResult checkInputDataTypes() {
        DataType e1;
        void var1_8;
        Tuple2 tuple2 = new Tuple2((Object)this.left().dataType(), (Object)this.right().dataType());
        if (tuple2 != null) {
            DataType e2 = (DataType)tuple2._2();
            if (tuple2._1() instanceof ArrayType) {
                DataType dataType = e2;
                IntegerType$ integerType$ = IntegerType$.MODULE$;
                if (dataType == null ? integerType$ != null : !dataType.equals(integerType$)) {
                    TypeCheckResult.TypeCheckFailure typeCheckFailure = new TypeCheckResult.TypeCheckFailure(new StringBuilder(67).append("Input to function ").append(this.prettyName()).append(" should have ").append("been ").append(ArrayType$.MODULE$.simpleString()).append(" followed by a ").append(IntegerType$.MODULE$.simpleString()).append(", but it's ").append("[").append(this.left().dataType().catalogString()).append(", ").append(this.right().dataType().catalogString()).append("].").toString());
                    return var1_8;
                }
            }
        }
        if (tuple2 != null) {
            MapType mapType;
            DataType e12;
            DataType dataType = (DataType)tuple2._1();
            DataType e2 = (DataType)tuple2._2();
            if (dataType instanceof MapType && !e2.sameType(e12 = (mapType = (MapType)dataType).keyType())) {
                TypeCheckResult.TypeCheckFailure typeCheckFailure = new TypeCheckResult.TypeCheckFailure(new StringBuilder(89).append("Input to function ").append(this.prettyName()).append(" should have ").append("been ").append(MapType$.MODULE$.simpleString()).append(" followed by a value of same key type, but it's ").append("[").append(this.left().dataType().catalogString()).append(", ").append(this.right().dataType().catalogString()).append("].").toString());
                return var1_8;
            }
        }
        if (tuple2 != null && !((e1 = (DataType)tuple2._1()) instanceof MapType) && !(e1 instanceof ArrayType)) {
            TypeCheckResult.TypeCheckFailure typeCheckFailure = new TypeCheckResult.TypeCheckFailure(new StringBuilder(74).append("The first argument to function ").append(this.prettyName()).append(" should ").append("have been ").append(ArrayType$.MODULE$.simpleString()).append(" or ").append(MapType$.MODULE$.simpleString()).append(" type, but its ").append(this.left().dataType().catalogString()).append(" type.").toString());
            return var1_8;
        }
        TypeCheckResult$TypeCheckSuccess$ typeCheckResult$TypeCheckSuccess$ = TypeCheckResult$TypeCheckSuccess$.MODULE$;
        return var1_8;
    }

    private boolean nullability(Seq<Expression> elements, int ordinal) {
        return ordinal == 0 ? false : (elements.length() < package$.MODULE$.abs(ordinal) ? !this.failOnError() : (ordinal < 0 ? ((Expression)elements.apply(elements.length() + ordinal)).nullable() : ((Expression)elements.apply(ordinal - 1)).nullable()));
    }

    @Override
    public boolean nullable() {
        boolean bl;
        DataType dataType = this.left().dataType();
        if (dataType instanceof ArrayType) {
            bl = this.computeNullabilityFromArray(this.left(), this.right(), this.failOnError(), (Function2<Seq<Expression>, Object, Object>)(Function2 & Serializable & scala.Serializable)(elements, ordinal) -> BoxesRunTime.boxToBoolean((boolean)this.nullability((Seq<Expression>)elements, BoxesRunTime.unboxToInt((Object)ordinal))));
        } else if (dataType instanceof MapType) {
            bl = this.failOnError() ? this.mapValueContainsNull() : true;
        } else {
            throw new MatchError((Object)dataType);
        }
        return bl;
    }

    @Override
    public Object nullSafeEval(Object value, Object ordinal) {
        return this.doElementAt().apply(value, ordinal);
    }

    private Function2<Object, Object, Object> doElementAt$lzycompute() {
        ElementAt elementAt = this;
        synchronized (elementAt) {
            if ((byte)(this.bitmap$trans$0 & 0x20) == 0) {
                Function2 & Serializable & scala.Serializable intersect;
                DataType dataType = this.left().dataType();
                if (dataType instanceof ArrayType) {
                    intersect = (Function2 & Serializable & scala.Serializable)(value, ordinal) -> {
                        Object object;
                        ArrayData array = (ArrayData)value;
                        int index = BoxesRunTime.unboxToInt((Object)ordinal);
                        if (array.numElements() < package$.MODULE$.abs(index)) {
                            if (this.failOnError()) {
                                throw new ArrayIndexOutOfBoundsException(new StringBuilder(30).append("Invalid index: ").append(index).append(", numElements: ").append(array.numElements()).toString());
                            }
                            object = null;
                        } else {
                            if (index == 0) {
                                throw new ArrayIndexOutOfBoundsException("SQL array indices start at 1");
                            }
                            int idx = index > 0 ? index - 1 : array.numElements() + index;
                            object = this.arrayContainsNull() && array.isNullAt(idx) ? null : array.get(idx, this.dataType());
                        }
                        return object;
                    };
                } else if (dataType instanceof MapType) {
                    intersect = (Function2 & Serializable & scala.Serializable)(value, ordinal) -> this.getValueEval(value, ordinal, this.mapKeyType(), this.ordering(), this.failOnError());
                } else {
                    throw new MatchError((Object)dataType);
                }
                this.doElementAt = intersect;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 0x20);
            }
        }
        return this.doElementAt;
    }

    private Function2<Object, Object, Object> doElementAt() {
        return (byte)(this.bitmap$trans$0 & 0x20) == 0 ? this.doElementAt$lzycompute() : this.doElementAt;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode exprCode;
        DataType dataType = this.left().dataType();
        if (dataType instanceof ArrayType) {
            exprCode = this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(eval1, eval2) -> {
                String index = ctx.freshName("elementAtIndex");
                String nullCheck = this.arrayContainsNull() ? new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(99).append("\n               |if (").append((String)eval1).append(".isNullAt(").append(index).append(")) {\n               |  ").append(ev.isNull()).append(" = true;\n               |} else\n             ").toString())).stripMargin() : "";
                String indexOutOfBoundBranch = this.failOnError() ? new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(150).append("throw new ArrayIndexOutOfBoundsException(\n               |  \"Invalid index: \" + ").append(index).append(" + \", numElements: \" + ").append((String)eval1).append(".numElements()\n               |);\n             ").toString())).stripMargin() : new StringBuilder(8).append(ev.isNull()).append(" = true;").toString();
                return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(481).append("\n             |int ").append(index).append(" = (int) ").append((String)eval2).append(";\n             |if (").append((String)eval1).append(".numElements() < Math.abs(").append(index).append(")) {\n             |  ").append(indexOutOfBoundBranch).append("\n             |} else {\n             |  if (").append(index).append(" == 0) {\n             |    throw new ArrayIndexOutOfBoundsException(\"SQL array indices start at 1\");\n             |  } else if (").append(index).append(" > 0) {\n             |    ").append(index).append("--;\n             |  } else {\n             |    ").append(index).append(" += ").append((String)eval1).append(".numElements();\n             |  }\n             |  ").append(nullCheck).append("\n             |  {\n             |    ").append(ev.value()).append(" = ").append(CodeGenerator$.MODULE$.getValue((String)eval1, this.dataType(), index)).append(";\n             |  }\n             |}\n           ").toString())).stripMargin();
            });
        } else if (dataType instanceof MapType) {
            exprCode = this.doGetValueGenCode(ctx, ev, (MapType)this.left().dataType(), this.failOnError());
        } else {
            throw new MatchError((Object)dataType);
        }
        return exprCode;
    }

    @Override
    public String prettyName() {
        return "element_at";
    }

    public ElementAt copy(Expression left, Expression right, boolean failOnError) {
        return new ElementAt(left, right, failOnError);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    public boolean copy$default$3() {
        return this.failOnError();
    }

    @Override
    public String productPrefix() {
        return "ElementAt";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.left();
                break;
            }
            case 1: {
                object = this.right();
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToBoolean((boolean)this.failOnError());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ElementAt;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ElementAt)) return false;
        boolean bl = true;
        if (!bl) return false;
        ElementAt elementAt = (ElementAt)x$1;
        Expression expression = this.left();
        Expression expression2 = elementAt.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = elementAt.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (this.failOnError() != elementAt.failOnError()) return false;
        if (!elementAt.canEqual(this)) return false;
        return true;
    }

    public ElementAt(Expression left, Expression right, boolean failOnError) {
        this.left = left;
        this.right = right;
        this.failOnError = failOnError;
        ExpectsInputTypes.$init$(this);
        GetMapValueUtil.$init$(this);
        GetArrayItemUtil.$init$(this);
    }

    public ElementAt(Expression left, Expression right) {
        this(left, right, SQLConf$.MODULE$.get().ansiEnabled());
    }
}

