/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite;

import java.util.List;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.rel.RelDistribution;
import org.apache.calcite.rel.RelDistributionTraitDef;
import org.apache.calcite.util.mapping.Mappings;

public class HiveRelDistribution
implements RelDistribution {
    List<Integer> keys;
    RelDistribution.Type type;

    public HiveRelDistribution(RelDistribution.Type type, List<Integer> keys) {
        this.type = type;
        this.keys = keys;
    }

    public RelTraitDef<?> getTraitDef() {
        return RelDistributionTraitDef.INSTANCE;
    }

    public void register(RelOptPlanner planner) {
    }

    public boolean satisfies(RelTrait trait) {
        if (trait == this) {
            return true;
        }
        switch (((RelDistribution)trait).getType()) {
            case HASH_DISTRIBUTED: {
                return this.getKeys().equals(((RelDistribution)trait).getKeys());
            }
        }
        throw new RuntimeException("Other distributions are not used yet.");
    }

    public RelDistribution apply(Mappings.TargetMapping mapping) {
        if (this.keys.isEmpty()) {
            return this;
        }
        return new HiveRelDistribution(this.type, this.keys);
    }

    public List<Integer> getKeys() {
        return this.keys;
    }

    public RelDistribution.Type getType() {
        return this.type;
    }
}

