/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution;

import java.io.Serializable;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZoneOffset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.catalyst.util.DateFormatter;
import org.apache.spark.sql.catalyst.util.DateFormatter$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.TimestampFormatter;
import org.apache.spark.sql.catalyst.util.TimestampFormatter$;
import org.apache.spark.sql.execution.HiveResult;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.command.DescribeCommandBase;
import org.apache.spark.sql.execution.command.ExecutedCommandExec;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.command.ShowTablesCommand;
import org.apache.spark.sql.execution.command.ShowViewsCommand;
import org.apache.spark.sql.execution.datasources.v2.DescribeTableExec;
import org.apache.spark.sql.execution.datasources.v2.ShowTablesExec;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.unsafe.types.CalendarInterval;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;

public final class HiveResult$ {
    public static HiveResult$ MODULE$;

    static {
        new HiveResult$();
    }

    public HiveResult.TimeFormatters getTimeFormatters() {
        DateFormatter dateFormatter = DateFormatter$.MODULE$.apply((ZoneId)ZoneOffset.UTC);
        TimestampFormatter timestampFormatter = TimestampFormatter$.MODULE$.getFractionFormatter(DateTimeUtils$.MODULE$.getZoneId(SQLConf$.MODULE$.get().sessionLocalTimeZone()));
        return new HiveResult.TimeFormatters(dateFormatter, timestampFormatter);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Seq<String> hiveResultString(SparkPlan executedPlan) {
        ShowTablesCommand showTablesCommand;
        RunnableCommand s;
        boolean bl = false;
        ExecutedCommandExec executedCommandExec = null;
        SparkPlan sparkPlan = executedPlan;
        if (sparkPlan instanceof ExecutedCommandExec) {
            bl = true;
            executedCommandExec = (ExecutedCommandExec)sparkPlan;
            if (executedCommandExec.cmd() instanceof DescribeCommandBase) {
                return this.formatDescribeTableOutput(executedPlan.executeCollectPublic());
            }
        }
        if (sparkPlan instanceof DescribeTableExec) {
            return this.formatDescribeTableOutput(executedPlan.executeCollectPublic());
        }
        if (bl && (s = executedCommandExec.cmd()) instanceof ShowTablesCommand && !(showTablesCommand = (ShowTablesCommand)s).isExtended()) {
            return (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])executedCommandExec.executeCollect())).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getString(1), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
        }
        if (sparkPlan instanceof ShowTablesExec) {
            ShowTablesExec showTablesExec = (ShowTablesExec)sparkPlan;
            return (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])showTablesExec.executeCollect())).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getString(1), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
        }
        if (bl && executedCommandExec.cmd() instanceof ShowViewsCommand) {
            return (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])executedCommandExec.executeCollect())).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getString(1), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
        }
        HiveResult.TimeFormatters timeFormatters = this.getTimeFormatters();
        Seq result = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sparkPlan.executeCollectPublic())).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.toSeq(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Seq.class))))).toSeq();
        Seq types = (Seq)executedPlan.output().map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.dataType(), Seq$.MODULE$.canBuildFrom());
        return (Seq)((TraversableLike)result.map((Function1 & Serializable & scala.Serializable)x$6 -> (Seq)((TraversableLike)x$6.zip((GenIterable)types, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)e -> MODULE$.toHiveString((Tuple2<Object, DataType>)e, false, timeFormatters), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.mkString("\t"), Seq$.MODULE$.canBuildFrom());
    }

    private Seq<String> formatDescribeTableOutput(Row[] rows) {
        return (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rows)).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            String string;
            Object comment;
            Object dataType;
            block3: {
                Row row;
                block2: {
                    row = x0$1;
                    Some some = Row$.MODULE$.unapplySeq(row);
                    if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(3) != 0) break block2;
                    Object name = ((SeqLike)some.get()).apply(0);
                    dataType = ((SeqLike)some.get()).apply(1);
                    comment = ((SeqLike)some.get()).apply(2);
                    if (!(name instanceof String)) break block2;
                    string = (String)name;
                    if (dataType instanceof String) break block3;
                }
                throw new MatchError((Object)row);
            }
            String string2 = (String)dataType;
            String string3 = ((TraversableOnce)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{string, string2, (String)Option$.MODULE$.apply((Object)((String)comment)).getOrElse((Function0 & Serializable & scala.Serializable)() -> "")}))).map((Function1 & Serializable & scala.Serializable)s -> String.format("%-20s", s), Seq$.MODULE$.canBuildFrom())).mkString("\t");
            return string3;
        }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String toHiveString(Tuple2<Object, DataType> a, boolean nested, HiveResult.TimeFormatters formatters) {
        Object object;
        Tuple2<Object, DataType> tuple2 = a;
        if (tuple2 != null && (object = tuple2._1()) == null) {
            if (!nested) return "NULL";
            return "null";
        }
        if (tuple2 != null) {
            Object b = tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (BooleanType$.MODULE$.equals(dataType)) {
                return b.toString();
            }
        }
        if (tuple2 != null) {
            Object d = tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (d instanceof Date) {
                Date date = (Date)d;
                if (DateType$.MODULE$.equals(dataType)) {
                    return formatters.date().format((java.util.Date)date);
                }
            }
        }
        if (tuple2 != null) {
            Object ld = tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (ld instanceof LocalDate) {
                LocalDate localDate = (LocalDate)ld;
                if (DateType$.MODULE$.equals(dataType)) {
                    return formatters.date().format(localDate);
                }
            }
        }
        if (tuple2 != null) {
            Object t = tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (t instanceof Timestamp) {
                Timestamp timestamp = (Timestamp)t;
                if (TimestampType$.MODULE$.equals(dataType)) {
                    return formatters.timestamp().format(timestamp);
                }
            }
        }
        if (tuple2 != null) {
            Object i = tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (i instanceof Instant) {
                Instant instant = (Instant)i;
                if (TimestampType$.MODULE$.equals(dataType)) {
                    return formatters.timestamp().format(instant);
                }
            }
        }
        if (tuple2 != null) {
            Object bin = tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (bin instanceof byte[]) {
                byte[] byArray = (byte[])bin;
                if (BinaryType$.MODULE$.equals(dataType)) {
                    return new String(byArray, StandardCharsets.UTF_8);
                }
            }
        }
        if (tuple2 != null) {
            Object decimal = tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (decimal instanceof BigDecimal) {
                BigDecimal bigDecimal = (BigDecimal)decimal;
                if (DecimalType$.MODULE$.unapply(dataType)) {
                    return bigDecimal.toPlainString();
                }
            }
        }
        if (tuple2 != null) {
            Object n = tuple2._1();
            if (tuple2._2() instanceof NumericType) {
                return n.toString();
            }
        }
        if (tuple2 != null) {
            Object s = tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (s instanceof String) {
                String string = (String)s;
                if (StringType$.MODULE$.equals(dataType)) {
                    return nested ? new StringBuilder(2).append("\"").append(string).append("\"").toString() : string;
                }
            }
        }
        if (tuple2 != null) {
            Object interval = tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (interval instanceof CalendarInterval) {
                CalendarInterval calendarInterval = (CalendarInterval)interval;
                if (CalendarIntervalType$.MODULE$.equals(dataType)) {
                    return calendarInterval.toString();
                }
            }
        }
        if (tuple2 != null) {
            Object seq = tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (seq instanceof Seq) {
                Seq seq2 = (Seq)seq;
                if (dataType instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)dataType;
                    DataType typ = arrayType.elementType();
                    return ((TraversableOnce)((TraversableLike)seq2.map((Function1 & Serializable & scala.Serializable)v -> new Tuple2(v, (Object)typ), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)e -> MODULE$.toHiveString((Tuple2<Object, DataType>)e, true, formatters), Seq$.MODULE$.canBuildFrom())).mkString("[", ",", "]");
                }
            }
        }
        if (tuple2 != null) {
            Object m = tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (m instanceof Map) {
                Map map = (Map)m;
                if (dataType instanceof MapType) {
                    MapType mapType = (MapType)dataType;
                    DataType kType = mapType.keyType();
                    DataType vType = mapType.valueType();
                    return ((TraversableOnce)((TraversableOnce)map.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                        Tuple2 tuple2 = x0$1;
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        Object key = tuple2._1();
                        Object value = tuple2._2();
                        String string = new StringBuilder(1).append(MODULE$.toHiveString((Tuple2<Object, DataType>)new Tuple2(key, (Object)kType), true, formatters)).append(":").append(MODULE$.toHiveString((Tuple2<Object, DataType>)new Tuple2(value, (Object)vType), true, formatters)).toString();
                        return string;
                    }, Iterable$.MODULE$.canBuildFrom())).toSeq().sorted((Ordering)Ordering.String$.MODULE$)).mkString("{", ",", "}");
                }
            }
        }
        if (tuple2 != null) {
            Object struct = tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (struct instanceof Row) {
                Row row = (Row)struct;
                if (dataType instanceof StructType) {
                    StructType structType = (StructType)dataType;
                    StructField[] fields = structType.fields();
                    return ((TraversableOnce)((TraversableLike)row.toSeq().zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])fields), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                        Tuple2 tuple2 = x0$2;
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        Object v = tuple2._1();
                        StructField t = (StructField)tuple2._2();
                        String string = new StringBuilder(3).append("\"").append(t.name()).append("\":").append(MODULE$.toHiveString((Tuple2<Object, DataType>)new Tuple2(v, (Object)t.dataType()), true, formatters)).toString();
                        return string;
                    }, Seq$.MODULE$.canBuildFrom())).mkString("{", ",", "}");
                }
            }
        }
        if (tuple2 == null) throw new MatchError(tuple2);
        Object other = tuple2._1();
        if (!(tuple2._2() instanceof UserDefinedType)) throw new MatchError(tuple2);
        return other.toString();
    }

    private HiveResult$() {
        MODULE$ = this;
    }
}

