/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.adaptive;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.commons.io.FileUtils;
import org.apache.spark.MapOutputStatistics;
import org.apache.spark.MapOutputTrackerMaster;
import org.apache.spark.ShuffleStatus;
import org.apache.spark.SparkEnv$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.SortOrder;
import org.apache.spark.sql.catalyst.plans.Cross$;
import org.apache.spark.sql.catalyst.plans.Inner$;
import org.apache.spark.sql.catalyst.plans.JoinType;
import org.apache.spark.sql.catalyst.plans.LeftAnti$;
import org.apache.spark.sql.catalyst.plans.LeftOuter$;
import org.apache.spark.sql.catalyst.plans.LeftSemi$;
import org.apache.spark.sql.catalyst.plans.RightOuter$;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.execution.CoalescedPartitionSpec;
import org.apache.spark.sql.execution.PartialReducerPartitionSpec;
import org.apache.spark.sql.execution.ShufflePartitionSpec;
import org.apache.spark.sql.execution.SortExec;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.adaptive.CustomShuffleReaderExec;
import org.apache.spark.sql.execution.adaptive.CustomShuffleReaderExec$;
import org.apache.spark.sql.execution.adaptive.CustomShuffleReaderRule;
import org.apache.spark.sql.execution.adaptive.OptimizeSkewedJoin$;
import org.apache.spark.sql.execution.adaptive.ShufflePartitionsUtil$;
import org.apache.spark.sql.execution.adaptive.ShuffleQueryStageExec;
import org.apache.spark.sql.execution.adaptive.ShuffleStage$;
import org.apache.spark.sql.execution.adaptive.ShuffleStageInfo;
import org.apache.spark.sql.execution.exchange.ENSURE_REQUIREMENTS$;
import org.apache.spark.sql.execution.exchange.EnsureRequirements$;
import org.apache.spark.sql.execution.exchange.ShuffleExchangeExec;
import org.apache.spark.sql.execution.exchange.ShuffleOrigin;
import org.apache.spark.sql.execution.joins.SortMergeJoinExec;
import org.apache.spark.sql.internal.SQLConf$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class OptimizeSkewedJoin$
extends Rule<SparkPlan>
implements CustomShuffleReaderRule {
    public static OptimizeSkewedJoin$ MODULE$;
    private final Seq<ShuffleOrigin> supportedShuffleOrigins;
    private final EnsureRequirements$ ensureRequirements;
    private final List<JoinType> org$apache$spark$sql$execution$adaptive$OptimizeSkewedJoin$$supportedJoinTypes;

    static {
        new OptimizeSkewedJoin$();
    }

    @Override
    public Seq<ShuffleOrigin> supportedShuffleOrigins() {
        return this.supportedShuffleOrigins;
    }

    private EnsureRequirements$ ensureRequirements() {
        return this.ensureRequirements;
    }

    public List<JoinType> org$apache$spark$sql$execution$adaptive$OptimizeSkewedJoin$$supportedJoinTypes() {
        return this.org$apache$spark$sql$execution$adaptive$OptimizeSkewedJoin$$supportedJoinTypes;
    }

    public boolean org$apache$spark$sql$execution$adaptive$OptimizeSkewedJoin$$isSkewed(long size, long medianSize) {
        return size > medianSize * (long)BoxesRunTime.unboxToInt((Object)this.conf().getConf(SQLConf$.MODULE$.SKEW_JOIN_SKEWED_PARTITION_FACTOR())) && size > BoxesRunTime.unboxToLong((Object)this.conf().getConf(SQLConf$.MODULE$.SKEW_JOIN_SKEWED_PARTITION_THRESHOLD()));
    }

    public long org$apache$spark$sql$execution$adaptive$OptimizeSkewedJoin$$medianSize(MapOutputStatistics stats) {
        int numPartitions = stats.bytesByPartitionId().length;
        long[] bytes = (long[])new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(stats.bytesByPartitionId())).sorted((Ordering)Ordering.Long$.MODULE$);
        int n = numPartitions;
        switch (n) {
            default: 
        }
        return numPartitions % 2 == 0 ? package$.MODULE$.max((bytes[numPartitions / 2] + bytes[numPartitions / 2 - 1]) / 2L, 1L) : package$.MODULE$.max(bytes[numPartitions / 2], 1L);
    }

    public long org$apache$spark$sql$execution$adaptive$OptimizeSkewedJoin$$targetSize(Seq<Object> sizes, long medianSize) {
        long advisorySize = BoxesRunTime.unboxToLong((Object)this.conf().getConf(SQLConf$.MODULE$.ADVISORY_PARTITION_SIZE_IN_BYTES()));
        Seq nonSkewSizes = (Seq)sizes.filterNot((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$7 -> MODULE$.org$apache$spark$sql$execution$adaptive$OptimizeSkewedJoin$$isSkewed(x$7, medianSize));
        return nonSkewSizes.isEmpty() ? advisorySize : package$.MODULE$.max(advisorySize, BoxesRunTime.unboxToLong((Object)nonSkewSizes.sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) / (long)nonSkewSizes.length());
    }

    private long[] getMapSizesForReduceId(int shuffleId, int partitionId) {
        MapOutputTrackerMaster mapOutputTracker = (MapOutputTrackerMaster)SparkEnv$.MODULE$.get().mapOutputTracker();
        return (long[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((ShuffleStatus)mapOutputTracker.shuffleStatuses().apply((Object)BoxesRunTime.boxToInteger((int)shuffleId))).mapStatuses())).map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToLong((long)x$8.getSizeForBlock(partitionId)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()));
    }

    public Option<Seq<PartialReducerPartitionSpec>> org$apache$spark$sql$execution$adaptive$OptimizeSkewedJoin$$createSkewPartitionSpecs(int shuffleId, int reducerId, long targetSize) {
        long[] mapPartitionSizes = this.getMapSizesForReduceId(shuffleId, reducerId);
        int[] mapStartIndices = ShufflePartitionsUtil$.MODULE$.splitSizeListByTargetSize((Seq<Object>)Predef$.MODULE$.wrapLongArray(mapPartitionSizes), targetSize);
        return mapStartIndices.length > 1 ? new Some(new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(mapStartIndices)).indices().map((Function1 & Serializable & scala.Serializable)i -> OptimizeSkewedJoin$.$anonfun$createSkewPartitionSpecs$1(mapStartIndices, mapPartitionSizes, reducerId, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())) : None$.MODULE$;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean org$apache$spark$sql$execution$adaptive$OptimizeSkewedJoin$$canSplitLeftSide(JoinType joinType) {
        JoinType joinType2 = joinType;
        Inner$ inner$ = Inner$.MODULE$;
        if (joinType2 == null) {
            if (inner$ == null) return true;
        } else if (joinType2.equals(inner$)) return true;
        JoinType joinType3 = joinType;
        Cross$ cross$ = Cross$.MODULE$;
        if (joinType3 == null) {
            if (cross$ == null) return true;
        } else if (joinType3.equals(cross$)) return true;
        JoinType joinType4 = joinType;
        LeftSemi$ leftSemi$ = LeftSemi$.MODULE$;
        if (joinType4 == null) {
            if (leftSemi$ == null) return true;
        } else if (joinType4.equals(leftSemi$)) return true;
        JoinType joinType5 = joinType;
        LeftAnti$ leftAnti$ = LeftAnti$.MODULE$;
        if (joinType5 == null) {
            if (leftAnti$ == null) return true;
        } else if (joinType5.equals(leftAnti$)) return true;
        JoinType joinType6 = joinType;
        LeftOuter$ leftOuter$ = LeftOuter$.MODULE$;
        if (joinType6 != null) {
            if (!joinType6.equals(leftOuter$)) return false;
            return true;
        }
        if (leftOuter$ == null) return true;
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean org$apache$spark$sql$execution$adaptive$OptimizeSkewedJoin$$canSplitRightSide(JoinType joinType) {
        JoinType joinType2 = joinType;
        Inner$ inner$ = Inner$.MODULE$;
        if (joinType2 == null) {
            if (inner$ == null) return true;
        } else if (joinType2.equals(inner$)) return true;
        JoinType joinType3 = joinType;
        Cross$ cross$ = Cross$.MODULE$;
        if (joinType3 == null) {
            if (cross$ == null) return true;
        } else if (joinType3.equals(cross$)) return true;
        JoinType joinType4 = joinType;
        RightOuter$ rightOuter$ = RightOuter$.MODULE$;
        if (joinType4 != null) {
            if (!joinType4.equals(rightOuter$)) return false;
            return true;
        }
        if (rightOuter$ == null) return true;
        return false;
    }

    public String org$apache$spark$sql$execution$adaptive$OptimizeSkewedJoin$$getSizeInfo(long medianSize, Seq<Object> sizes) {
        return new StringBuilder(49).append("median size: ").append(medianSize).append(", max size: ").append(sizes.max((Ordering)Ordering.Long$.MODULE$)).append(", min size: ").append(sizes.min((Ordering)Ordering.Long$.MODULE$)).append(", avg size: ").append(BoxesRunTime.unboxToLong((Object)sizes.sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) / (long)sizes.length()).toString();
    }

    public SparkPlan optimizeSkewJoin(SparkPlan plan) {
        return (SparkPlan)plan.transformUp((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof SortMergeJoinExec) {
                    ShuffleStageInfo left;
                    SortExec sortExec;
                    SparkPlan sparkPlan;
                    Option<ShuffleStageInfo> option;
                    SortMergeJoinExec sortMergeJoinExec = (SortMergeJoinExec)A1;
                    JoinType joinType = sortMergeJoinExec.joinType();
                    SparkPlan s1 = sortMergeJoinExec.left();
                    SparkPlan s2 = sortMergeJoinExec.right();
                    if (s1 instanceof SortExec && !(option = ShuffleStage$.MODULE$.unapply(sparkPlan = (sortExec = (SortExec)s1).child())).isEmpty() && (left = (ShuffleStageInfo)option.get()) != null) {
                        ShuffleStageInfo right;
                        SortExec sortExec2;
                        SparkPlan sparkPlan2;
                        Option<ShuffleStageInfo> option2;
                        ShuffleStageInfo shuffleStageInfo = left;
                        if (s2 instanceof SortExec && !(option2 = ShuffleStage$.MODULE$.unapply(sparkPlan2 = (sortExec2 = (SortExec)s2).child())).isEmpty() && (right = (ShuffleStageInfo)option2.get()) != null) {
                            ShuffleStageInfo shuffleStageInfo2 = right;
                            if (OptimizeSkewedJoin$.MODULE$.org$apache$spark$sql$execution$adaptive$OptimizeSkewedJoin$$supportedJoinTypes().contains((Object)joinType)) {
                                SortMergeJoinExec sortMergeJoinExec2;
                                Predef$.MODULE$.assert(shuffleStageInfo.partitionsWithSizes().length() == shuffleStageInfo2.partitionsWithSizes().length());
                                int numPartitions = shuffleStageInfo.partitionsWithSizes().length();
                                long leftMedSize = OptimizeSkewedJoin$.MODULE$.org$apache$spark$sql$execution$adaptive$OptimizeSkewedJoin$$medianSize(shuffleStageInfo.mapStats());
                                long rightMedSize = OptimizeSkewedJoin$.MODULE$.org$apache$spark$sql$execution$adaptive$OptimizeSkewedJoin$$medianSize(shuffleStageInfo2.mapStats());
                                OptimizeSkewedJoin$.MODULE$.logDebug((Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(155).append("\n          |Optimizing skewed join.\n          |Left side partitions size info:\n          |").append(OptimizeSkewedJoin$.MODULE$.org$apache$spark$sql$execution$adaptive$OptimizeSkewedJoin$$getSizeInfo(leftMedSize, (Seq<Object>)Predef$.MODULE$.wrapLongArray(shuffleStageInfo.mapStats().bytesByPartitionId()))).append("\n          |Right side partitions size info:\n          |").append(OptimizeSkewedJoin$.MODULE$.org$apache$spark$sql$execution$adaptive$OptimizeSkewedJoin$$getSizeInfo(rightMedSize, (Seq<Object>)Predef$.MODULE$.wrapLongArray(shuffleStageInfo2.mapStats().bytesByPartitionId()))).append("\n        ").toString())).stripMargin());
                                boolean canSplitLeft = OptimizeSkewedJoin$.MODULE$.org$apache$spark$sql$execution$adaptive$OptimizeSkewedJoin$$canSplitLeftSide(joinType);
                                boolean canSplitRight = OptimizeSkewedJoin$.MODULE$.org$apache$spark$sql$execution$adaptive$OptimizeSkewedJoin$$canSplitRightSide(joinType);
                                Seq leftActualSizes = (Seq)shuffleStageInfo.partitionsWithSizes().map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToLong((long)anonfun.optimizeSkewJoin.1.$anonfun$applyOrElse$2(x$10)), Seq$.MODULE$.canBuildFrom());
                                Seq rightActualSizes = (Seq)shuffleStageInfo2.partitionsWithSizes().map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToLong((long)anonfun.optimizeSkewJoin.1.$anonfun$applyOrElse$3(x$11)), Seq$.MODULE$.canBuildFrom());
                                long leftTargetSize = OptimizeSkewedJoin$.MODULE$.org$apache$spark$sql$execution$adaptive$OptimizeSkewedJoin$$targetSize((Seq<Object>)leftActualSizes, leftMedSize);
                                long rightTargetSize = OptimizeSkewedJoin$.MODULE$.org$apache$spark$sql$execution$adaptive$OptimizeSkewedJoin$$targetSize((Seq<Object>)rightActualSizes, rightMedSize);
                                ArrayBuffer leftSidePartitions = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
                                ArrayBuffer rightSidePartitions = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
                                IntRef numSkewedLeft = IntRef.create((int)0);
                                IntRef numSkewedRight = IntRef.create((int)0);
                                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numPartitions).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)partitionIndex -> {
                                    Seq seq;
                                    Seq leftParts;
                                    Seq seq2;
                                    boolean isRightCoalesced;
                                    long leftActualSize = BoxesRunTime.unboxToLong((Object)leftActualSizes.apply(partitionIndex));
                                    boolean isLeftSkew = OptimizeSkewedJoin$.MODULE$.org$apache$spark$sql$execution$adaptive$OptimizeSkewedJoin$$isSkewed(leftActualSize, leftMedSize) && canSplitLeft;
                                    CoalescedPartitionSpec leftPartSpec = (CoalescedPartitionSpec)((Tuple2)shuffleStageInfo.partitionsWithSizes().apply(partitionIndex))._1();
                                    boolean isLeftCoalesced = leftPartSpec.startReducerIndex() + 1 < leftPartSpec.endReducerIndex();
                                    long rightActualSize = BoxesRunTime.unboxToLong((Object)rightActualSizes.apply(partitionIndex));
                                    boolean isRightSkew = OptimizeSkewedJoin$.MODULE$.org$apache$spark$sql$execution$adaptive$OptimizeSkewedJoin$$isSkewed(rightActualSize, rightMedSize) && canSplitRight;
                                    CoalescedPartitionSpec rightPartSpec = (CoalescedPartitionSpec)((Tuple2)shuffleStageInfo2.partitionsWithSizes().apply(partitionIndex))._1();
                                    boolean bl = isRightCoalesced = rightPartSpec.startReducerIndex() + 1 < rightPartSpec.endReducerIndex();
                                    if (isLeftSkew && !isLeftCoalesced) {
                                        int reducerId = leftPartSpec.startReducerIndex();
                                        Option<Seq<PartialReducerPartitionSpec>> skewSpecs = OptimizeSkewedJoin$.MODULE$.org$apache$spark$sql$execution$adaptive$OptimizeSkewedJoin$$createSkewPartitionSpecs(shuffleStageInfo.mapStats().shuffleId(), reducerId, leftTargetSize);
                                        if (skewSpecs.isDefined()) {
                                            OptimizeSkewedJoin$.MODULE$.logDebug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Left side partition ").append(partitionIndex).append(" ").append("(").append(FileUtils.byteCountToDisplaySize((long)leftActualSize)).append(") is skewed, ").append("split it into ").append(((SeqLike)skewSpecs.get()).length()).append(" parts.").toString());
                                            ++numSkewedLeft$1.elem;
                                        }
                                        seq2 = (Seq)skewSpecs.getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CoalescedPartitionSpec[]{leftPartSpec})));
                                    } else {
                                        seq2 = leftParts = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CoalescedPartitionSpec[]{leftPartSpec}));
                                    }
                                    if (isRightSkew && !isRightCoalesced) {
                                        int reducerId = rightPartSpec.startReducerIndex();
                                        Option<Seq<PartialReducerPartitionSpec>> skewSpecs = OptimizeSkewedJoin$.MODULE$.org$apache$spark$sql$execution$adaptive$OptimizeSkewedJoin$$createSkewPartitionSpecs(shuffleStageInfo2.mapStats().shuffleId(), reducerId, rightTargetSize);
                                        if (skewSpecs.isDefined()) {
                                            OptimizeSkewedJoin$.MODULE$.logDebug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("Right side partition ").append(partitionIndex).append(" ").append("(").append(FileUtils.byteCountToDisplaySize((long)rightActualSize)).append(") is skewed, ").append("split it into ").append(((SeqLike)skewSpecs.get()).length()).append(" parts.").toString());
                                            ++numSkewedRight$1.elem;
                                        }
                                        seq = (Seq)skewSpecs.getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CoalescedPartitionSpec[]{rightPartSpec})));
                                    } else {
                                        seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CoalescedPartitionSpec[]{rightPartSpec}));
                                    }
                                    Seq rightParts = seq;
                                    leftParts.foreach((Function1 & Serializable & scala.Serializable)leftSidePartition -> {
                                        anonfun.optimizeSkewJoin.1.$anonfun$applyOrElse$9(rightParts, leftSidePartitions, rightSidePartitions, leftSidePartition);
                                        return BoxedUnit.UNIT;
                                    });
                                });
                                OptimizeSkewedJoin$.MODULE$.logDebug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("number of skewed partitions: left ").append(numSkewedLeft$1.elem).append(", right ").append(numSkewedRight$1.elem).toString());
                                if (numSkewedLeft.elem > 0 || numSkewedRight.elem > 0) {
                                    CustomShuffleReaderExec newLeft = CustomShuffleReaderExec$.MODULE$.apply(shuffleStageInfo.shuffleStage(), (Seq<ShufflePartitionSpec>)leftSidePartitions.toSeq());
                                    CustomShuffleReaderExec newRight = CustomShuffleReaderExec$.MODULE$.apply(shuffleStageInfo2.shuffleStage(), (Seq<ShufflePartitionSpec>)rightSidePartitions.toSeq());
                                    CustomShuffleReaderExec x$1 = newLeft;
                                    Seq<SortOrder> x$2 = sortExec.copy$default$1();
                                    boolean x$3 = sortExec.copy$default$2();
                                    int x$4 = sortExec.copy$default$4();
                                    SortExec x$9 = sortExec.copy(x$2, x$3, x$1, x$4);
                                    CustomShuffleReaderExec x$5 = newRight;
                                    Seq<SortOrder> x$6 = sortExec2.copy$default$1();
                                    boolean x$7 = sortExec2.copy$default$2();
                                    int x$8 = sortExec2.copy$default$4();
                                    SortExec x$102 = sortExec2.copy(x$6, x$7, x$5, x$8);
                                    boolean x$112 = true;
                                    Seq<Expression> x$12 = sortMergeJoinExec.copy$default$1();
                                    Seq<Expression> x$13 = sortMergeJoinExec.copy$default$2();
                                    JoinType x$14 = sortMergeJoinExec.copy$default$3();
                                    Option<Expression> x$15 = sortMergeJoinExec.copy$default$4();
                                    sortMergeJoinExec2 = sortMergeJoinExec.copy(x$12, x$13, x$14, x$15, x$9, x$102, x$112);
                                } else {
                                    sortMergeJoinExec2 = sortMergeJoinExec;
                                }
                                object = sortMergeJoinExec2;
                                return (B1)object;
                            }
                        }
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(SparkPlan x1) {
                SparkPlan sparkPlan = x1;
                if (!(sparkPlan instanceof SortMergeJoinExec)) return false;
                SortMergeJoinExec sortMergeJoinExec = (SortMergeJoinExec)sparkPlan;
                JoinType joinType = sortMergeJoinExec.joinType();
                SparkPlan s1 = sortMergeJoinExec.left();
                SparkPlan s2 = sortMergeJoinExec.right();
                if (!(s1 instanceof SortExec)) return false;
                SortExec sortExec = (SortExec)s1;
                SparkPlan sparkPlan2 = sortExec.child();
                Option<ShuffleStageInfo> option = ShuffleStage$.MODULE$.unapply(sparkPlan2);
                if (option.isEmpty()) return false;
                ShuffleStageInfo left = (ShuffleStageInfo)option.get();
                if (left == null) return false;
                if (!(s2 instanceof SortExec)) return false;
                SortExec sortExec2 = (SortExec)s2;
                SparkPlan sparkPlan3 = sortExec2.child();
                Option<ShuffleStageInfo> option2 = ShuffleStage$.MODULE$.unapply(sparkPlan3);
                if (option2.isEmpty()) return false;
                ShuffleStageInfo right = (ShuffleStageInfo)option2.get();
                if (right == null) return false;
                if (!OptimizeSkewedJoin$.MODULE$.org$apache$spark$sql$execution$adaptive$OptimizeSkewedJoin$$supportedJoinTypes().contains((Object)joinType)) return false;
                return true;
            }

            public static final /* synthetic */ long $anonfun$applyOrElse$2(Tuple2 x$10) {
                return x$10._2$mcJ$sp();
            }

            public static final /* synthetic */ long $anonfun$applyOrElse$3(Tuple2 x$11) {
                return x$11._2$mcJ$sp();
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$9(Seq rightParts$1, ArrayBuffer leftSidePartitions$1, ArrayBuffer rightSidePartitions$1, Product leftSidePartition) {
                rightParts$1.foreach((Function1 & Serializable & scala.Serializable)rightSidePartition -> {
                    leftSidePartitions$1.$plus$eq((Object)leftSidePartition);
                    return rightSidePartitions$1.$plus$eq(rightSidePartition);
                });
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(long org.apache.spark.sql.execution.adaptive.ShuffleStageInfo long org.apache.spark.sql.execution.adaptive.ShuffleStageInfo ), $anonfun$applyOrElse$2$adapted(scala.Tuple2 ), $anonfun$applyOrElse$3$adapted(scala.Tuple2 ), $anonfun$applyOrElse$4(scala.collection.Seq long boolean org.apache.spark.sql.execution.adaptive.ShuffleStageInfo scala.collection.Seq long boolean org.apache.spark.sql.execution.adaptive.ShuffleStageInfo long scala.runtime.IntRef long scala.runtime.IntRef scala.collection.mutable.ArrayBuffer scala.collection.mutable.ArrayBuffer int ), $anonfun$applyOrElse$11(scala.runtime.IntRef scala.runtime.IntRef ), $anonfun$applyOrElse$10(scala.collection.mutable.ArrayBuffer scala.Product scala.collection.mutable.ArrayBuffer scala.Product ), $anonfun$applyOrElse$5(int long scala.Option ), $anonfun$applyOrElse$6(org.apache.spark.sql.execution.CoalescedPartitionSpec ), $anonfun$applyOrElse$7(int long scala.Option ), $anonfun$applyOrElse$8(org.apache.spark.sql.execution.CoalescedPartitionSpec ), $anonfun$applyOrElse$9$adapted(scala.collection.Seq scala.collection.mutable.ArrayBuffer scala.collection.mutable.ArrayBuffer scala.Product )}, serializedLambda);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public SparkPlan apply(SparkPlan plan) {
        SparkPlan sparkPlan;
        if (!BoxesRunTime.unboxToBoolean((Object)this.conf().getConf(SQLConf$.MODULE$.SKEW_JOIN_ENABLED()))) {
            return plan;
        }
        Seq shuffleStages = OptimizeSkewedJoin$.collectShuffleStages$1(plan);
        if (shuffleStages.length() == 2) {
            SparkPlan optimizePlan = this.optimizeSkewJoin(plan);
            int numShuffles = this.ensureRequirements().apply(optimizePlan).collect((PartialFunction)new scala.Serializable(){
                public static final long serialVersionUID = 0L;

                public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (A1 instanceof ShuffleExchangeExec) {
                        ShuffleExchangeExec shuffleExchangeExec = (ShuffleExchangeExec)A1;
                        object = shuffleExchangeExec;
                    } else {
                        object = function1.apply(x1);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(SparkPlan x1) {
                    SparkPlan sparkPlan = x1;
                    boolean bl = sparkPlan instanceof ShuffleExchangeExec;
                    return bl;
                }
            }).length();
            if (numShuffles > 0) {
                this.logDebug((Function0 & Serializable & scala.Serializable)() -> "OptimizeSkewedJoin rule is not applied due to additional shuffles will be introduced.");
                sparkPlan = plan;
            } else {
                void var3_3;
                sparkPlan = var3_3;
            }
        } else {
            sparkPlan = plan;
        }
        return sparkPlan;
    }

    public static final /* synthetic */ PartialReducerPartitionSpec $anonfun$createSkewPartitionSpecs$1(int[] mapStartIndices$1, long[] mapPartitionSizes$1, int reducerId$1, int i) {
        int startMapIndex = mapStartIndices$1[i];
        int endMapIndex = i == mapStartIndices$1.length - 1 ? mapPartitionSizes$1.length : mapStartIndices$1[i + 1];
        long dataSize = BoxesRunTime.unboxToLong((Object)((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(startMapIndex), endMapIndex).map((Function1)(JFunction1.mcJI.sp & Serializable & scala.Serializable)x$9 -> mapPartitionSizes$1[x$9], IndexedSeq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        return new PartialReducerPartitionSpec(reducerId$1, startMapIndex, endMapIndex, dataSize);
    }

    private static final Seq collectShuffleStages$1(SparkPlan plan2) {
        Seq seq;
        SparkPlan sparkPlan = plan2;
        if (sparkPlan instanceof ShuffleQueryStageExec) {
            ShuffleQueryStageExec shuffleQueryStageExec = (ShuffleQueryStageExec)sparkPlan;
            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ShuffleQueryStageExec[]{shuffleQueryStageExec}));
        } else {
            seq = (Seq)plan2.children().flatMap((Function1 & Serializable & scala.Serializable)plan -> OptimizeSkewedJoin$.collectShuffleStages$1(plan), Seq$.MODULE$.canBuildFrom());
        }
        return seq;
    }

    private OptimizeSkewedJoin$() {
        MODULE$ = this;
        this.supportedShuffleOrigins = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ENSURE_REQUIREMENTS$[]{ENSURE_REQUIREMENTS$.MODULE$}));
        this.ensureRequirements = EnsureRequirements$.MODULE$;
        Inner$ inner$ = Inner$.MODULE$;
        Cross$ cross$ = Cross$.MODULE$;
        LeftSemi$ leftSemi$ = LeftSemi$.MODULE$;
        LeftAnti$ leftAnti$ = LeftAnti$.MODULE$;
        LeftOuter$ leftOuter$ = LeftOuter$.MODULE$;
        RightOuter$ rightOuter$ = RightOuter$.MODULE$;
        this.org$apache$spark$sql$execution$adaptive$OptimizeSkewedJoin$$supportedJoinTypes = Nil$.MODULE$.$colon$colon((Object)rightOuter$).$colon$colon((Object)leftOuter$).$colon$colon((Object)leftAnti$).$colon$colon((Object)leftSemi$).$colon$colon((Object)cross$).$colon$colon((Object)inner$);
    }
}

