/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.ml;

import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.spark.examples.ml.DataFrameExample;
import org.apache.spark.examples.ml.DataFrameExample$Params$;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.stat.MultivariateOnlineSummarizer;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.util.Utils$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.sys.package$;
import scopt.OptionParser;
import scopt.Read$;

public final class DataFrameExample$ {
    public static DataFrameExample$ MODULE$;

    static {
        new DataFrameExample$();
    }

    public void main(String[] args) {
        DataFrameExample.Params defaultParams = new DataFrameExample.Params(DataFrameExample$Params$.MODULE$.apply$default$1());
        OptionParser<DataFrameExample.Params> parser = new OptionParser<DataFrameExample.Params>(){
            {
                this.head((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DataFrameExample: an example app using DataFrame for ML."}));
                this.opt("input", Read$.MODULE$.stringRead()).text("input path to dataframe").action((Function2 & Serializable & scala.Serializable)(x, c) -> c.copy((String)x));
                this.checkConfig((Function1 & Serializable & scala.Serializable)params -> this.success());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$new$1(java.lang.String org.apache.spark.examples.ml.DataFrameExample$Params ), $anonfun$new$2(org.apache.spark.examples.ml.DataFrameExample$$anon$1 org.apache.spark.examples.ml.DataFrameExample$Params )}, serializedLambda);
            }
        };
        Option option = parser.parse((Seq)Predef$.MODULE$.wrapRefArray((Object[])args), (Object)defaultParams);
        if (!(option instanceof Some)) {
            throw package$.MODULE$.exit(1);
        }
        Some some = (Some)option;
        DataFrameExample.Params params = (DataFrameExample.Params)some.value();
        this.run(params);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public void run(DataFrameExample.Params params) {
        SparkSession spark = SparkSession$.MODULE$.builder().appName(new StringBuilder(22).append("DataFrameExample with ").append(params).toString()).getOrCreate();
        Predef$.MODULE$.println((Object)new StringBuilder(35).append("Loading LIBSVM file with UDT from ").append(params.input()).append(".").toString());
        Dataset df = spark.read().format("libsvm").load(params.input()).cache();
        Predef$.MODULE$.println((Object)"Schema from LIBSVM:");
        df.printSchema();
        Predef$.MODULE$.println((Object)new StringBuilder(50).append("Loaded training data as a DataFrame with ").append(df.count()).append(" records.").toString());
        Dataset labelSummary = df.describe((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"label"}));
        labelSummary.show();
        RDD features = df.select("features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).rdd().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Vector vector;
            Object v;
            Row row = x0$1;
            Some some = Row$.MODULE$.unapplySeq(row);
            if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(1) != 0 || !((v = ((SeqLike)some.get()).apply(0)) instanceof Vector)) {
                throw new MatchError((Object)row);
            }
            Vector vector2 = vector = (Vector)v;
            return vector2;
        }, ClassTag$.MODULE$.apply(Vector.class));
        MultivariateOnlineSummarizer featureSummary = (MultivariateOnlineSummarizer)features.aggregate((Object)new MultivariateOnlineSummarizer(), (Function2 & Serializable & scala.Serializable)(summary, feat) -> summary.add(Vectors$.MODULE$.fromML(feat)), (Function2 & Serializable & scala.Serializable)(sum1, sum2) -> sum1.merge(sum2), ClassTag$.MODULE$.apply(MultivariateOnlineSummarizer.class));
        Predef$.MODULE$.println((Object)new StringBuilder(47).append("Selected features column with average values:\n ").append(featureSummary.mean().toString()).toString());
        File tmpDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
        String outputDir = new File(tmpDir, "dataframe").toString();
        Predef$.MODULE$.println((Object)new StringBuilder(27).append("Saving to ").append(outputDir).append(" as Parquet file.").toString());
        df.write().parquet(outputDir);
        Predef$.MODULE$.println((Object)new StringBuilder(36).append("Loading Parquet file with UDT from ").append(outputDir).append(".").toString());
        Dataset newDF = spark.read().parquet(outputDir);
        Predef$.MODULE$.println((Object)"Schema from Parquet:");
        newDF.printSchema();
        spark.stop();
    }

    private DataFrameExample$() {
        MODULE$ = this;
    }
}

