/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Writable;

public class TypeDesc
implements Writable {
    private Type type;
    private int precision;
    private int scale;

    public TypeDesc(Type type) {
        this(type, 0, 0);
    }

    public TypeDesc(Type type, int precision, int scale) {
        this.type = type;
        this.precision = precision;
        this.scale = scale;
    }

    public TypeDesc(Type type, int precision) {
        this(type, precision, 0);
    }

    public TypeDesc() {
        this(Type.INT, 0, 0);
    }

    public Type getType() {
        return this.type;
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getScale() {
        return this.scale;
    }

    public String toString() {
        switch (this.type) {
            case DECIMAL: {
                return this.type.name().toLowerCase() + "(" + this.precision + "," + this.scale + ")";
            }
            case CHAR: 
            case VARCHAR: {
                return this.type.name().toLowerCase() + "(" + this.precision + ")";
            }
        }
        return this.type.name().toLowerCase();
    }

    public void write(DataOutput out) throws IOException {
        out.writeUTF(this.type.name());
        out.writeInt(this.precision);
        out.writeInt(this.scale);
    }

    public void readFields(DataInput in) throws IOException {
        this.type = Type.valueOf(in.readUTF());
        this.precision = in.readInt();
        this.scale = in.readInt();
    }

    public static enum Type {
        BOOLEAN,
        TINYINT,
        SMALLINT,
        INT,
        BIGINT,
        FLOAT,
        DOUBLE,
        STRING,
        CHAR,
        VARCHAR,
        DATE,
        TIMESTAMP,
        BINARY,
        DECIMAL;

    }
}

