/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.broadcast;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.spark.SecurityManager;
import org.apache.spark.SparkConf;
import org.apache.spark.api.python.PythonBroadcast;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.broadcast.BroadcastFactory;
import org.apache.spark.broadcast.TorrentBroadcastFactory;
import org.apache.spark.internal.Logging;
import org.slf4j.Logger;
import scala.Function0;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005-b!\u0002\u000b\u0016\u0001]i\u0002\u0002\u0003\u0016\u0001\u0005\u000b\u0007I\u0011\u0001\u0017\t\u0011A\u0002!\u0011!Q\u0001\n5B\u0001\"\r\u0001\u0003\u0002\u0003\u0006IA\r\u0005\tm\u0001\u0011\t\u0011)A\u0005o!)!\b\u0001C\u0001w!9\u0011\t\u0001a\u0001\n\u0013a\u0003b\u0002\"\u0001\u0001\u0004%Ia\u0011\u0005\u0007\u0013\u0002\u0001\u000b\u0015B\u0017\t\u000f)\u0003\u0001\u0019!C\u0005\u0017\"9q\n\u0001a\u0001\n\u0013\u0001\u0006B\u0002*\u0001A\u0003&A\nC\u0003T\u0001\u0011%A\u000bC\u0003V\u0001\u0011\u0005A\u000bC\u0004W\u0001\t\u0007I\u0011B,\t\r\u0011\u0004\u0001\u0015!\u0003Y\u0011!)\u0007A1A\u0005\u0002U1\u0007B\u00028\u0001A\u0003%q\rC\u0003p\u0001\u0011\u0005\u0001\u000fC\u0004\u0002\u0016\u0001!\t!a\u0006\u0003!\t\u0013x.\u00193dCN$X*\u00198bO\u0016\u0014(B\u0001\f\u0018\u0003%\u0011'o\\1eG\u0006\u001cHO\u0003\u0002\u00193\u0005)1\u000f]1sW*\u0011!dG\u0001\u0007CB\f7\r[3\u000b\u0003q\t1a\u001c:h'\r\u0001a\u0004\n\t\u0003?\tj\u0011\u0001\t\u0006\u0002C\u0005)1oY1mC&\u00111\u0005\t\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u0015BS\"\u0001\u0014\u000b\u0005\u001d:\u0012\u0001C5oi\u0016\u0014h.\u00197\n\u0005%2#a\u0002'pO\u001eLgnZ\u0001\tSN$%/\u001b<fe\u000e\u0001Q#A\u0017\u0011\u0005}q\u0013BA\u0018!\u0005\u001d\u0011un\u001c7fC:\f\u0011\"[:Ee&4XM\u001d\u0011\u0002\t\r|gN\u001a\t\u0003gQj\u0011aF\u0005\u0003k]\u0011\u0011b\u00159be.\u001cuN\u001c4\u0002\u001fM,7-\u001e:jifl\u0015M\\1hKJ\u0004\"a\r\u001d\n\u0005e:\"aD*fGV\u0014\u0018\u000e^=NC:\fw-\u001a:\u0002\rqJg.\u001b;?)\u0011adh\u0010!\u0011\u0005u\u0002Q\"A\u000b\t\u000b)*\u0001\u0019A\u0017\t\u000bE*\u0001\u0019\u0001\u001a\t\u000bY*\u0001\u0019A\u001c\u0002\u0017%t\u0017\u000e^5bY&TX\rZ\u0001\u0010S:LG/[1mSj,Gm\u0018\u0013fcR\u0011Ai\u0012\t\u0003?\u0015K!A\u0012\u0011\u0003\tUs\u0017\u000e\u001e\u0005\b\u0011\u001e\t\t\u00111\u0001.\u0003\rAH%M\u0001\rS:LG/[1mSj,G\rI\u0001\u0011EJ|\u0017\rZ2bgR4\u0015m\u0019;pef,\u0012\u0001\u0014\t\u0003{5K!AT\u000b\u0003!\t\u0013x.\u00193dCN$h)Y2u_JL\u0018\u0001\u00062s_\u0006$7-Y:u\r\u0006\u001cGo\u001c:z?\u0012*\u0017\u000f\u0006\u0002E#\"9\u0001JCA\u0001\u0002\u0004a\u0015!\u00052s_\u0006$7-Y:u\r\u0006\u001cGo\u001c:zA\u0005Q\u0011N\\5uS\u0006d\u0017N_3\u0015\u0003\u0011\u000bAa\u001d;pa\u0006ya.\u001a=u\u0005J|\u0017\rZ2bgRLE-F\u0001Y!\tI&-D\u0001[\u0015\tYF,\u0001\u0004bi>l\u0017n\u0019\u0006\u0003;z\u000b!bY8oGV\u0014(/\u001a8u\u0015\ty\u0006-\u0001\u0003vi&d'\"A1\u0002\t)\fg/Y\u0005\u0003Gj\u0013!\"\u0011;p[&\u001cGj\u001c8h\u0003AqW\r\u001f;Ce>\fGmY1ti&#\u0007%\u0001\u0007dC\u000eDW\r\u001a,bYV,7/F\u0001h!\u0011A\u0017n[6\u000e\u0003yK!A\u001b0\u0003\u00075\u000b\u0007\u000f\u0005\u0002 Y&\u0011Q\u000e\t\u0002\u0004\u0003:L\u0018!D2bG\",GMV1mk\u0016\u001c\b%\u0001\u0007oK^\u0014%o\\1eG\u0006\u001cH/\u0006\u0002rqR)!/!\u0004\u0002\u0012Q\u00111O \t\u0004{Q4\u0018BA;\u0016\u0005%\u0011%o\\1eG\u0006\u001cH\u000f\u0005\u0002xq2\u0001A!B=\u0013\u0005\u0004Q(!\u0001+\u0012\u0005m\\\u0007CA\u0010}\u0013\ti\bEA\u0004O_RD\u0017N\\4\t\u0011}\u0014\u0012\u0011!a\u0002\u0003\u0003\t!\"\u001a<jI\u0016t7-\u001a\u00132!\u0015\t\u0019!!\u0003w\u001b\t\t)AC\u0002\u0002\b\u0001\nqA]3gY\u0016\u001cG/\u0003\u0003\u0002\f\u0005\u0015!\u0001C\"mCN\u001cH+Y4\t\r\u0005=!\u00031\u0001w\u0003\u00191\u0018\r\\;f?\"1\u00111\u0003\nA\u00025\nq![:M_\u000e\fG.A\u0006v]\n\u0014x.\u00193dCN$Hc\u0002#\u0002\u001a\u0005\r\u0012q\u0005\u0005\b\u00037\u0019\u0002\u0019AA\u000f\u0003\tIG\rE\u0002 \u0003?I1!!\t!\u0005\u0011auN\\4\t\r\u0005\u00152\u00031\u0001.\u0003A\u0011X-\\8wK\u001a\u0013x.\u001c#sSZ,'\u000f\u0003\u0004\u0002*M\u0001\r!L\u0001\tE2|7m[5oO\u0002")
public class BroadcastManager
implements Logging {
    private final boolean isDriver;
    private final SparkConf conf;
    private final SecurityManager securityManager;
    private boolean initialized;
    private BroadcastFactory broadcastFactory;
    private final AtomicLong nextBroadcastId;
    private final Map<Object, Object> cachedValues;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$(this, isInterpreter, silent);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public boolean isDriver() {
        return this.isDriver;
    }

    private boolean initialized() {
        return this.initialized;
    }

    private void initialized_$eq(boolean x$1) {
        this.initialized = x$1;
    }

    private BroadcastFactory broadcastFactory() {
        return this.broadcastFactory;
    }

    private void broadcastFactory_$eq(BroadcastFactory x$1) {
        this.broadcastFactory = x$1;
    }

    private synchronized void initialize() {
        block0: {
            if (this.initialized()) break block0;
            this.broadcastFactory_$eq(new TorrentBroadcastFactory());
            this.broadcastFactory().initialize(this.isDriver(), this.conf, this.securityManager);
            this.initialized_$eq(true);
        }
    }

    public void stop() {
        this.broadcastFactory().stop();
    }

    private AtomicLong nextBroadcastId() {
        return this.nextBroadcastId;
    }

    public Map<Object, Object> cachedValues() {
        return this.cachedValues;
    }

    public <T> Broadcast<T> newBroadcast(T value_, boolean isLocal, ClassTag<T> evidence$1) {
        long bid = this.nextBroadcastId().getAndIncrement();
        T t = value_;
        if (t instanceof PythonBroadcast) {
            PythonBroadcast pythonBroadcast = (PythonBroadcast)t;
            pythonBroadcast.setBroadcastId(bid);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        return this.broadcastFactory().newBroadcast(value_, isLocal, bid, evidence$1);
    }

    public void unbroadcast(long id, boolean removeFromDriver, boolean blocking) {
        this.broadcastFactory().unbroadcast(id, removeFromDriver, blocking);
    }

    public BroadcastManager(boolean isDriver, SparkConf conf, SecurityManager securityManager) {
        this.isDriver = isDriver;
        this.conf = conf;
        this.securityManager = securityManager;
        Logging.$init$(this);
        this.initialized = false;
        this.broadcastFactory = null;
        this.initialize();
        this.nextBroadcastId = new AtomicLong(0L);
        this.cachedValues = Collections.synchronizedMap(new ReferenceMap(0, 2));
    }
}

