## Copyright 2009-2021 Intel Corporation
## SPDX-License-Identifier: Apache-2.0

IF (EMBREE_INSTALL_DEPENDENCIES)
  IF (TARGET TBB::${EMBREE_TBB_COMPONENT})
    GET_TARGET_PROPERTY(LIB_PATH TBB::${EMBREE_TBB_COMPONENT} IMPORTED_LOCATION_RELEASE)
    IF(WIN32)
      INSTALL(FILES "${LIB_PATH}" DESTINATION "${CMAKE_INSTALL_BINDIR}" COMPONENT examples)
      GET_TARGET_PROPERTY(IMPLIB_PATH TBB::${EMBREE_TBB_COMPONENT} IMPORTED_IMPLIB_RELEASE)
      INSTALL(FILES "${IMPLIB_PATH}" DESTINATION "${CMAKE_INSTALL_LIBDIR}" COMPONENT lib)

      # Include tbbmalloc.dll even though we don't use or need tbb_malloc.dll because it is searched for by tbb.dll.
      GET_FILENAME_COMPONENT(LIB_FOLDER ${LIB_PATH} DIRECTORY)
      FILE(GLOB TBB_MALLOC_FILES LIST_DIRECTORIES false "${LIB_FOLDER}/tbbmalloc.dll" "${LIB_FOLDER}/tbbmalloc?.dll")
      INSTALL(FILES "${TBB_MALLOC_FILES}" DESTINATION "${CMAKE_INSTALL_BINDIR}" COMPONENT examples)

    ELSE()
      GET_FILENAME_COMPONENT(LIB_DIR "${LIB_PATH}" DIRECTORY)
      FILE(GLOB LIB_FILES ${LIB_DIR}/libtbb.* ${LIB_DIR}/libtbbmalloc.so*)
      INSTALL(FILES ${LIB_FILES} DESTINATION "${CMAKE_INSTALL_LIBDIR}" COMPONENT lib)
    ENDIF()
  ELSE()
    MESSAGE(SEND_ERROR "Target TBB::${EMBREE_TBB_COMPONENT} not found during install.")
  ENDIF()
ENDIF()
