/*This file contains the sectorlist class, to save the list of
  modified sectors*/

/*Maybe i should be proud of this, this is a classical!
  I always said "Who needs C++?"
  >;>>> */


#include "defs.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "voidlist.h"
/*We include the List object motherclass*/

/* Private structures --------------------------------------------------*/


struct coords {
   int x,y;
};
/* Our Identification (List Index) Structure */

struct brightness {
   int light;
};
/* Our List Data Structure */


/* Public structures --------------------------------------------------*/

struct sectorlist{
   struct voidlist* liste;
};

/*The structure sectorlist, public itself, but members are private*/
/*Since my new class system the members are taken from class voidlist,
  so even unknown to this very file ;) */

/* Private functions --------------------------------------------------*/

int sectorlist_greater (struct voidident *vfrst, struct voidident *vscnd) {
   struct coords *frst, *scnd;
   frst=(struct coords*)vfrst;
   scnd=(struct coords*)vscnd;
   return ( (frst->y>scnd->y) || ((frst->y==scnd->y) &&(frst->x>scnd->x)) );
}

int sectorlist_equality (struct voidident *vfrst, struct voidident *vscnd) {
   struct coords *frst, *scnd;
   frst=(struct coords*)vfrst;
   scnd=(struct coords*)vscnd;
   return ( (frst->x==scnd->x) && (frst->y==scnd->y) );
}

int sectorlist_freecontent (struct voidident *videntity, struct voiddata * vdata){
   struct coords *identity;
   struct brightness *data;
   identity=(struct coords*)videntity;
   data=(struct brightness*)vdata;
   free (data);
   free (identity);
   return 0;
}

/* Function for comparisation of Index values, and to free the memory of
   the data of our list members. To tell the upper voidlist class.
   I think this is some kind of workaround since ident and data are no
   object classes but ordinary var structs */

int sectorlist_printentry (int number, struct voidident *videntity, struct voiddata *vdata, void *userdata){
   struct coords *identity;
   struct brightness *data;
   identity=(struct coords*)videntity;
   data=(struct brightness*)vdata;
   fprintf(stdout,"%i,%i:%i ",identity->x,identity->y,data->light);
   return 0;
}
/*A function to print out single sectors to stdout,
  necessary to print the whole list*/


/* Public functions ---------------------------------------------------*/

struct sectorlist* sectorlist_new() {
/*A constructor*/
   struct sectorlist* newsec;

   newsec=(struct sectorlist*)malloc(sizeof(struct sectorlist));
   if (!newsec) return NULL;
   newsec->liste=voidlist_new();
   if (!newsec->liste) {
      free(newsec);
      return NULL;
   }
   return newsec;
}

/* ------------------------------------------------------------------- */

int sectorlist_remsector (struct sectorlist* list,int x, int y) {
/*Removes a sector from the list
  0 on success, 1 on not found, -1 on error*/
   struct coords identity;

   if (!list) return -1;

   identity.x=x;
   identity.y=y;
   return voidlist_remitem(	list->liste,
   				(struct voidident*)&identity,
   				sectorlist_greater,sectorlist_equality,
				sectorlist_freecontent);

}

/* ------------------------------------------------------------------- */

int sectorlist_kill(struct sectorlist* list) {
/*A destructor, 0 on success, -1 on error*/
   if (!list) return -1;
   voidlist_kill(list->liste,sectorlist_freecontent);
   free(list);
   return 0;
}

/* ------------------------------------------------------------------- */

int sectorlist_addsector (struct sectorlist* list,int x, int y,int brightness) {
/*Adds a sector to the list
  0 added, 1, changed, -1 error */
   struct coords *identity;
   struct brightness *data;

   if (!list) return -1;

   identity=(struct coords*)malloc(sizeof(struct coords));
   if (!identity) return -1;
   data=(struct brightness*)malloc(sizeof(struct brightness));
   if (!data) {
      free(identity);
      return -1;
   }
   /*We have to create a special structure in memory to add to our list */

   identity->x=x;
   identity->y=y;
   data->light=brightness;
   /*And fill them with data*/

   return voidlist_additem (	list->liste,
   				(struct voidident*)identity,
				(struct voiddata*)data,
   				sectorlist_greater,sectorlist_equality,
				sectorlist_freecontent);
   /*And include this data in the list structure*/

}

/* ------------------------------------------------------------------- */

int sectorlist_print (struct sectorlist* list) {
/*And most important: print out all sectors*/
   int t;

   fprintf(stderr,"\nPrinting sectorlist:\n");

   fprintf(stderr,"\nOverall sector count:\t");
   fprintf(stdout,"%i\n",voidlist_members(list->liste));

   fprintf(stderr,"\nList:\n\n");
   t=voidlist_all (list->liste,sectorlist_printentry,NULL);
   fprintf(stdout,"\n");


   fprintf(stderr,"\nDone!\n");

   return t;
   /*This gives us our old shell script possibility, if the program fails,
     then there had been no movement <g>*/

}

/* -End--------------------------------------------------------------- */
