// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package connectparticipant

import (
	"fmt"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opCreateParticipantConnection = "CreateParticipantConnection"

// CreateParticipantConnectionRequest generates a "aws/request.Request" representing the
// client's request for the CreateParticipantConnection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateParticipantConnection for more information on using the CreateParticipantConnection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateParticipantConnectionRequest method.
//    req, resp := client.CreateParticipantConnectionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectparticipant-2018-09-07/CreateParticipantConnection
func (c *ConnectParticipant) CreateParticipantConnectionRequest(input *CreateParticipantConnectionInput) (req *request.Request, output *CreateParticipantConnectionOutput) {
	op := &request.Operation{
		Name:       opCreateParticipantConnection,
		HTTPMethod: "POST",
		HTTPPath:   "/participant/connection",
	}

	if input == nil {
		input = &CreateParticipantConnectionInput{}
	}

	output = &CreateParticipantConnectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateParticipantConnection API operation for Amazon Connect Participant Service.
//
// Creates the participant's connection. Note that ParticipantToken is used
// for invoking this API instead of ConnectionToken.
//
// The participant token is valid for the lifetime of the participant – until
// the they are part of a contact.
//
// The response URL for WEBSOCKET Type has a connect expiry timeout of 100s.
// Clients must manually connect to the returned websocket URL and subscribe
// to the desired topic.
//
// For chat, you need to publish the following on the established websocket
// connection:
//
// {"topic":"aws/subscribe","content":{"topics":["aws/chat"]}}
//
// Upon websocket URL expiry, as specified in the response ConnectionExpiry
// parameter, clients need to call this API again to obtain a new websocket
// URL and perform the same steps as before.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Participant Service's
// API operation CreateParticipantConnection for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * InternalServerException
//   This exception occurs when there is an internal failure in the Amazon Connect
//   service.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
//   * ValidationException
//   The input fails to satisfy the constraints specified by Amazon Connect.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectparticipant-2018-09-07/CreateParticipantConnection
func (c *ConnectParticipant) CreateParticipantConnection(input *CreateParticipantConnectionInput) (*CreateParticipantConnectionOutput, error) {
	req, out := c.CreateParticipantConnectionRequest(input)
	return out, req.Send()
}

// CreateParticipantConnectionWithContext is the same as CreateParticipantConnection with the addition of
// the ability to pass a context and additional request options.
//
// See CreateParticipantConnection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectParticipant) CreateParticipantConnectionWithContext(ctx aws.Context, input *CreateParticipantConnectionInput, opts ...request.Option) (*CreateParticipantConnectionOutput, error) {
	req, out := c.CreateParticipantConnectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisconnectParticipant = "DisconnectParticipant"

// DisconnectParticipantRequest generates a "aws/request.Request" representing the
// client's request for the DisconnectParticipant operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisconnectParticipant for more information on using the DisconnectParticipant
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisconnectParticipantRequest method.
//    req, resp := client.DisconnectParticipantRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectparticipant-2018-09-07/DisconnectParticipant
func (c *ConnectParticipant) DisconnectParticipantRequest(input *DisconnectParticipantInput) (req *request.Request, output *DisconnectParticipantOutput) {
	op := &request.Operation{
		Name:       opDisconnectParticipant,
		HTTPMethod: "POST",
		HTTPPath:   "/participant/disconnect",
	}

	if input == nil {
		input = &DisconnectParticipantInput{}
	}

	output = &DisconnectParticipantOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisconnectParticipant API operation for Amazon Connect Participant Service.
//
// Disconnects a participant. Note that ConnectionToken is used for invoking
// this API instead of ParticipantToken.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Participant Service's
// API operation DisconnectParticipant for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * InternalServerException
//   This exception occurs when there is an internal failure in the Amazon Connect
//   service.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
//   * ValidationException
//   The input fails to satisfy the constraints specified by Amazon Connect.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectparticipant-2018-09-07/DisconnectParticipant
func (c *ConnectParticipant) DisconnectParticipant(input *DisconnectParticipantInput) (*DisconnectParticipantOutput, error) {
	req, out := c.DisconnectParticipantRequest(input)
	return out, req.Send()
}

// DisconnectParticipantWithContext is the same as DisconnectParticipant with the addition of
// the ability to pass a context and additional request options.
//
// See DisconnectParticipant for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectParticipant) DisconnectParticipantWithContext(ctx aws.Context, input *DisconnectParticipantInput, opts ...request.Option) (*DisconnectParticipantOutput, error) {
	req, out := c.DisconnectParticipantRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetTranscript = "GetTranscript"

// GetTranscriptRequest generates a "aws/request.Request" representing the
// client's request for the GetTranscript operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetTranscript for more information on using the GetTranscript
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetTranscriptRequest method.
//    req, resp := client.GetTranscriptRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectparticipant-2018-09-07/GetTranscript
func (c *ConnectParticipant) GetTranscriptRequest(input *GetTranscriptInput) (req *request.Request, output *GetTranscriptOutput) {
	op := &request.Operation{
		Name:       opGetTranscript,
		HTTPMethod: "POST",
		HTTPPath:   "/participant/transcript",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetTranscriptInput{}
	}

	output = &GetTranscriptOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetTranscript API operation for Amazon Connect Participant Service.
//
// Retrieves a transcript of the session. Note that ConnectionToken is used
// for invoking this API instead of ParticipantToken.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Participant Service's
// API operation GetTranscript for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * InternalServerException
//   This exception occurs when there is an internal failure in the Amazon Connect
//   service.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
//   * ValidationException
//   The input fails to satisfy the constraints specified by Amazon Connect.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectparticipant-2018-09-07/GetTranscript
func (c *ConnectParticipant) GetTranscript(input *GetTranscriptInput) (*GetTranscriptOutput, error) {
	req, out := c.GetTranscriptRequest(input)
	return out, req.Send()
}

// GetTranscriptWithContext is the same as GetTranscript with the addition of
// the ability to pass a context and additional request options.
//
// See GetTranscript for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectParticipant) GetTranscriptWithContext(ctx aws.Context, input *GetTranscriptInput, opts ...request.Option) (*GetTranscriptOutput, error) {
	req, out := c.GetTranscriptRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetTranscriptPages iterates over the pages of a GetTranscript operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetTranscript method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetTranscript operation.
//    pageNum := 0
//    err := client.GetTranscriptPages(params,
//        func(page *connectparticipant.GetTranscriptOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ConnectParticipant) GetTranscriptPages(input *GetTranscriptInput, fn func(*GetTranscriptOutput, bool) bool) error {
	return c.GetTranscriptPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetTranscriptPagesWithContext same as GetTranscriptPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectParticipant) GetTranscriptPagesWithContext(ctx aws.Context, input *GetTranscriptInput, fn func(*GetTranscriptOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetTranscriptInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetTranscriptRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetTranscriptOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opSendEvent = "SendEvent"

// SendEventRequest generates a "aws/request.Request" representing the
// client's request for the SendEvent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SendEvent for more information on using the SendEvent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SendEventRequest method.
//    req, resp := client.SendEventRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectparticipant-2018-09-07/SendEvent
func (c *ConnectParticipant) SendEventRequest(input *SendEventInput) (req *request.Request, output *SendEventOutput) {
	op := &request.Operation{
		Name:       opSendEvent,
		HTTPMethod: "POST",
		HTTPPath:   "/participant/event",
	}

	if input == nil {
		input = &SendEventInput{}
	}

	output = &SendEventOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SendEvent API operation for Amazon Connect Participant Service.
//
// Sends an event. Note that ConnectionToken is used for invoking this API instead
// of ParticipantToken.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Participant Service's
// API operation SendEvent for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * InternalServerException
//   This exception occurs when there is an internal failure in the Amazon Connect
//   service.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
//   * ValidationException
//   The input fails to satisfy the constraints specified by Amazon Connect.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectparticipant-2018-09-07/SendEvent
func (c *ConnectParticipant) SendEvent(input *SendEventInput) (*SendEventOutput, error) {
	req, out := c.SendEventRequest(input)
	return out, req.Send()
}

// SendEventWithContext is the same as SendEvent with the addition of
// the ability to pass a context and additional request options.
//
// See SendEvent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectParticipant) SendEventWithContext(ctx aws.Context, input *SendEventInput, opts ...request.Option) (*SendEventOutput, error) {
	req, out := c.SendEventRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSendMessage = "SendMessage"

// SendMessageRequest generates a "aws/request.Request" representing the
// client's request for the SendMessage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SendMessage for more information on using the SendMessage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SendMessageRequest method.
//    req, resp := client.SendMessageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectparticipant-2018-09-07/SendMessage
func (c *ConnectParticipant) SendMessageRequest(input *SendMessageInput) (req *request.Request, output *SendMessageOutput) {
	op := &request.Operation{
		Name:       opSendMessage,
		HTTPMethod: "POST",
		HTTPPath:   "/participant/message",
	}

	if input == nil {
		input = &SendMessageInput{}
	}

	output = &SendMessageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SendMessage API operation for Amazon Connect Participant Service.
//
// Sends a message. Note that ConnectionToken is used for invoking this API
// instead of ParticipantToken.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Participant Service's
// API operation SendMessage for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * InternalServerException
//   This exception occurs when there is an internal failure in the Amazon Connect
//   service.
//
//   * ThrottlingException
//   The request was denied due to request throttling.
//
//   * ValidationException
//   The input fails to satisfy the constraints specified by Amazon Connect.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connectparticipant-2018-09-07/SendMessage
func (c *ConnectParticipant) SendMessage(input *SendMessageInput) (*SendMessageOutput, error) {
	req, out := c.SendMessageRequest(input)
	return out, req.Send()
}

// SendMessageWithContext is the same as SendMessage with the addition of
// the ability to pass a context and additional request options.
//
// See SendMessage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ConnectParticipant) SendMessageWithContext(ctx aws.Context, input *SendMessageInput, opts ...request.Option) (*SendMessageOutput, error) {
	req, out := c.SendMessageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// You do not have sufficient access to perform this action.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Connection credentials.
type ConnectionCredentials struct {
	_ struct{} `type:"structure"`

	// The connection token.
	ConnectionToken *string `min:"1" type:"string"`

	// The expiration of the token.
	//
	// It's specified in ISO 8601 format: yyyy-MM-ddThh:mm:ss.SSSZ. For example,
	// 2019-11-08T02:41:28.172Z.
	Expiry *string `type:"string"`
}

// String returns the string representation
func (s ConnectionCredentials) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConnectionCredentials) GoString() string {
	return s.String()
}

// SetConnectionToken sets the ConnectionToken field's value.
func (s *ConnectionCredentials) SetConnectionToken(v string) *ConnectionCredentials {
	s.ConnectionToken = &v
	return s
}

// SetExpiry sets the Expiry field's value.
func (s *ConnectionCredentials) SetExpiry(v string) *ConnectionCredentials {
	s.Expiry = &v
	return s
}

type CreateParticipantConnectionInput struct {
	_ struct{} `type:"structure"`

	// Participant Token as obtained from StartChatContact (https://docs.aws.amazon.com/connect/latest/APIReference/API_StartChatContactResponse.html)
	// API response.
	//
	// ParticipantToken is a required field
	ParticipantToken *string `location:"header" locationName:"X-Amz-Bearer" min:"1" type:"string" required:"true"`

	// Type of connection information required.
	//
	// Type is a required field
	Type []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s CreateParticipantConnectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateParticipantConnectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateParticipantConnectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateParticipantConnectionInput"}
	if s.ParticipantToken == nil {
		invalidParams.Add(request.NewErrParamRequired("ParticipantToken"))
	}
	if s.ParticipantToken != nil && len(*s.ParticipantToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ParticipantToken", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.Type != nil && len(s.Type) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Type", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetParticipantToken sets the ParticipantToken field's value.
func (s *CreateParticipantConnectionInput) SetParticipantToken(v string) *CreateParticipantConnectionInput {
	s.ParticipantToken = &v
	return s
}

// SetType sets the Type field's value.
func (s *CreateParticipantConnectionInput) SetType(v []*string) *CreateParticipantConnectionInput {
	s.Type = v
	return s
}

type CreateParticipantConnectionOutput struct {
	_ struct{} `type:"structure"`

	// Creates the participant's connection credentials. The authentication token
	// associated with the participant's connection.
	ConnectionCredentials *ConnectionCredentials `type:"structure"`

	// Creates the participant's websocket connection.
	Websocket *Websocket `type:"structure"`
}

// String returns the string representation
func (s CreateParticipantConnectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateParticipantConnectionOutput) GoString() string {
	return s.String()
}

// SetConnectionCredentials sets the ConnectionCredentials field's value.
func (s *CreateParticipantConnectionOutput) SetConnectionCredentials(v *ConnectionCredentials) *CreateParticipantConnectionOutput {
	s.ConnectionCredentials = v
	return s
}

// SetWebsocket sets the Websocket field's value.
func (s *CreateParticipantConnectionOutput) SetWebsocket(v *Websocket) *CreateParticipantConnectionOutput {
	s.Websocket = v
	return s
}

type DisconnectParticipantInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientToken *string `type:"string" idempotencyToken:"true"`

	// The authentication token associated with the participant's connection.
	//
	// ConnectionToken is a required field
	ConnectionToken *string `location:"header" locationName:"X-Amz-Bearer" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DisconnectParticipantInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisconnectParticipantInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisconnectParticipantInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisconnectParticipantInput"}
	if s.ConnectionToken == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectionToken"))
	}
	if s.ConnectionToken != nil && len(*s.ConnectionToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConnectionToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *DisconnectParticipantInput) SetClientToken(v string) *DisconnectParticipantInput {
	s.ClientToken = &v
	return s
}

// SetConnectionToken sets the ConnectionToken field's value.
func (s *DisconnectParticipantInput) SetConnectionToken(v string) *DisconnectParticipantInput {
	s.ConnectionToken = &v
	return s
}

type DisconnectParticipantOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisconnectParticipantOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisconnectParticipantOutput) GoString() string {
	return s.String()
}

type GetTranscriptInput struct {
	_ struct{} `type:"structure"`

	// The authentication token associated with the participant's connection.
	//
	// ConnectionToken is a required field
	ConnectionToken *string `location:"header" locationName:"X-Amz-Bearer" min:"1" type:"string" required:"true"`

	// The contactId from the current contact chain for which transcript is needed.
	ContactId *string `min:"1" type:"string"`

	// The maximum number of results to return in the page. Default: 10.
	MaxResults *int64 `type:"integer"`

	// The pagination token. Use the value returned previously in the next subsequent
	// request to retrieve the next set of results.
	NextToken *string `min:"1" type:"string"`

	// The direction from StartPosition from which to retrieve message. Default:
	// BACKWARD when no StartPosition is provided, FORWARD with StartPosition.
	ScanDirection *string `type:"string" enum:"ScanDirection"`

	// The sort order for the records. Default: DESCENDING.
	SortOrder *string `type:"string" enum:"SortKey"`

	// A filtering option for where to start.
	StartPosition *StartPosition `type:"structure"`
}

// String returns the string representation
func (s GetTranscriptInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTranscriptInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTranscriptInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetTranscriptInput"}
	if s.ConnectionToken == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectionToken"))
	}
	if s.ConnectionToken != nil && len(*s.ConnectionToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConnectionToken", 1))
	}
	if s.ContactId != nil && len(*s.ContactId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContactId", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.StartPosition != nil {
		if err := s.StartPosition.Validate(); err != nil {
			invalidParams.AddNested("StartPosition", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectionToken sets the ConnectionToken field's value.
func (s *GetTranscriptInput) SetConnectionToken(v string) *GetTranscriptInput {
	s.ConnectionToken = &v
	return s
}

// SetContactId sets the ContactId field's value.
func (s *GetTranscriptInput) SetContactId(v string) *GetTranscriptInput {
	s.ContactId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetTranscriptInput) SetMaxResults(v int64) *GetTranscriptInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetTranscriptInput) SetNextToken(v string) *GetTranscriptInput {
	s.NextToken = &v
	return s
}

// SetScanDirection sets the ScanDirection field's value.
func (s *GetTranscriptInput) SetScanDirection(v string) *GetTranscriptInput {
	s.ScanDirection = &v
	return s
}

// SetSortOrder sets the SortOrder field's value.
func (s *GetTranscriptInput) SetSortOrder(v string) *GetTranscriptInput {
	s.SortOrder = &v
	return s
}

// SetStartPosition sets the StartPosition field's value.
func (s *GetTranscriptInput) SetStartPosition(v *StartPosition) *GetTranscriptInput {
	s.StartPosition = v
	return s
}

type GetTranscriptOutput struct {
	_ struct{} `type:"structure"`

	// The initial contact ID for the contact.
	InitialContactId *string `min:"1" type:"string"`

	// The pagination token. Use the value returned previously in the next subsequent
	// request to retrieve the next set of results.
	NextToken *string `min:"1" type:"string"`

	// The list of messages in the session.
	Transcript []*Item `type:"list"`
}

// String returns the string representation
func (s GetTranscriptOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTranscriptOutput) GoString() string {
	return s.String()
}

// SetInitialContactId sets the InitialContactId field's value.
func (s *GetTranscriptOutput) SetInitialContactId(v string) *GetTranscriptOutput {
	s.InitialContactId = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetTranscriptOutput) SetNextToken(v string) *GetTranscriptOutput {
	s.NextToken = &v
	return s
}

// SetTranscript sets the Transcript field's value.
func (s *GetTranscriptOutput) SetTranscript(v []*Item) *GetTranscriptOutput {
	s.Transcript = v
	return s
}

// This exception occurs when there is an internal failure in the Amazon Connect
// service.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An item - message or event - that has been sent.
type Item struct {
	_ struct{} `type:"structure"`

	// The time when the message or event was sent.
	//
	// It's specified in ISO 8601 format: yyyy-MM-ddThh:mm:ss.SSSZ. For example,
	// 2019-11-08T02:41:28.172Z.
	AbsoluteTime *string `min:"1" type:"string"`

	// The content of the message or event.
	Content *string `min:"1" type:"string"`

	// The type of content of the item.
	ContentType *string `min:"1" type:"string"`

	// The chat display name of the sender.
	DisplayName *string `min:"1" type:"string"`

	// The ID of the item.
	Id *string `min:"1" type:"string"`

	// The ID of the sender in the session.
	ParticipantId *string `min:"1" type:"string"`

	// The role of the sender. For example, is it a customer, agent, or system.
	ParticipantRole *string `type:"string" enum:"ParticipantRole"`

	// Type of the item: message or event.
	Type *string `type:"string" enum:"ChatItemType"`
}

// String returns the string representation
func (s Item) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Item) GoString() string {
	return s.String()
}

// SetAbsoluteTime sets the AbsoluteTime field's value.
func (s *Item) SetAbsoluteTime(v string) *Item {
	s.AbsoluteTime = &v
	return s
}

// SetContent sets the Content field's value.
func (s *Item) SetContent(v string) *Item {
	s.Content = &v
	return s
}

// SetContentType sets the ContentType field's value.
func (s *Item) SetContentType(v string) *Item {
	s.ContentType = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *Item) SetDisplayName(v string) *Item {
	s.DisplayName = &v
	return s
}

// SetId sets the Id field's value.
func (s *Item) SetId(v string) *Item {
	s.Id = &v
	return s
}

// SetParticipantId sets the ParticipantId field's value.
func (s *Item) SetParticipantId(v string) *Item {
	s.ParticipantId = &v
	return s
}

// SetParticipantRole sets the ParticipantRole field's value.
func (s *Item) SetParticipantRole(v string) *Item {
	s.ParticipantRole = &v
	return s
}

// SetType sets the Type field's value.
func (s *Item) SetType(v string) *Item {
	s.Type = &v
	return s
}

type SendEventInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientToken *string `type:"string" idempotencyToken:"true"`

	// The authentication token associated with the participant's connection.
	//
	// ConnectionToken is a required field
	ConnectionToken *string `location:"header" locationName:"X-Amz-Bearer" min:"1" type:"string" required:"true"`

	// The content of the event to be sent (for example, message text). This is
	// not yet supported.
	Content *string `min:"1" type:"string"`

	// The content type of the request. Supported types are:
	//
	//    * application/vnd.amazonaws.connect.event.typing
	//
	//    * application/vnd.amazonaws.connect.event.connection.acknowledged
	//
	// ContentType is a required field
	ContentType *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s SendEventInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SendEventInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SendEventInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SendEventInput"}
	if s.ConnectionToken == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectionToken"))
	}
	if s.ConnectionToken != nil && len(*s.ConnectionToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConnectionToken", 1))
	}
	if s.Content != nil && len(*s.Content) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Content", 1))
	}
	if s.ContentType == nil {
		invalidParams.Add(request.NewErrParamRequired("ContentType"))
	}
	if s.ContentType != nil && len(*s.ContentType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContentType", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *SendEventInput) SetClientToken(v string) *SendEventInput {
	s.ClientToken = &v
	return s
}

// SetConnectionToken sets the ConnectionToken field's value.
func (s *SendEventInput) SetConnectionToken(v string) *SendEventInput {
	s.ConnectionToken = &v
	return s
}

// SetContent sets the Content field's value.
func (s *SendEventInput) SetContent(v string) *SendEventInput {
	s.Content = &v
	return s
}

// SetContentType sets the ContentType field's value.
func (s *SendEventInput) SetContentType(v string) *SendEventInput {
	s.ContentType = &v
	return s
}

type SendEventOutput struct {
	_ struct{} `type:"structure"`

	// The time when the event was sent.
	//
	// It's specified in ISO 8601 format: yyyy-MM-ddThh:mm:ss.SSSZ. For example,
	// 2019-11-08T02:41:28.172Z.
	AbsoluteTime *string `min:"1" type:"string"`

	// The ID of the response.
	Id *string `min:"1" type:"string"`
}

// String returns the string representation
func (s SendEventOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SendEventOutput) GoString() string {
	return s.String()
}

// SetAbsoluteTime sets the AbsoluteTime field's value.
func (s *SendEventOutput) SetAbsoluteTime(v string) *SendEventOutput {
	s.AbsoluteTime = &v
	return s
}

// SetId sets the Id field's value.
func (s *SendEventOutput) SetId(v string) *SendEventOutput {
	s.Id = &v
	return s
}

type SendMessageInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientToken *string `type:"string" idempotencyToken:"true"`

	// The authentication token associated with the connection.
	//
	// ConnectionToken is a required field
	ConnectionToken *string `location:"header" locationName:"X-Amz-Bearer" min:"1" type:"string" required:"true"`

	// The content of the message.
	//
	// Content is a required field
	Content *string `min:"1" type:"string" required:"true"`

	// The type of the content. Supported types are text/plain.
	//
	// ContentType is a required field
	ContentType *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s SendMessageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SendMessageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SendMessageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SendMessageInput"}
	if s.ConnectionToken == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectionToken"))
	}
	if s.ConnectionToken != nil && len(*s.ConnectionToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConnectionToken", 1))
	}
	if s.Content == nil {
		invalidParams.Add(request.NewErrParamRequired("Content"))
	}
	if s.Content != nil && len(*s.Content) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Content", 1))
	}
	if s.ContentType == nil {
		invalidParams.Add(request.NewErrParamRequired("ContentType"))
	}
	if s.ContentType != nil && len(*s.ContentType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContentType", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *SendMessageInput) SetClientToken(v string) *SendMessageInput {
	s.ClientToken = &v
	return s
}

// SetConnectionToken sets the ConnectionToken field's value.
func (s *SendMessageInput) SetConnectionToken(v string) *SendMessageInput {
	s.ConnectionToken = &v
	return s
}

// SetContent sets the Content field's value.
func (s *SendMessageInput) SetContent(v string) *SendMessageInput {
	s.Content = &v
	return s
}

// SetContentType sets the ContentType field's value.
func (s *SendMessageInput) SetContentType(v string) *SendMessageInput {
	s.ContentType = &v
	return s
}

type SendMessageOutput struct {
	_ struct{} `type:"structure"`

	// The time when the message was sent.
	//
	// It's specified in ISO 8601 format: yyyy-MM-ddThh:mm:ss.SSSZ. For example,
	// 2019-11-08T02:41:28.172Z.
	AbsoluteTime *string `min:"1" type:"string"`

	// The ID of the message.
	Id *string `min:"1" type:"string"`
}

// String returns the string representation
func (s SendMessageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SendMessageOutput) GoString() string {
	return s.String()
}

// SetAbsoluteTime sets the AbsoluteTime field's value.
func (s *SendMessageOutput) SetAbsoluteTime(v string) *SendMessageOutput {
	s.AbsoluteTime = &v
	return s
}

// SetId sets the Id field's value.
func (s *SendMessageOutput) SetId(v string) *SendMessageOutput {
	s.Id = &v
	return s
}

// A filtering option for where to start. For example, if you sent 100 messages,
// start with message 50.
type StartPosition struct {
	_ struct{} `type:"structure"`

	// The time in ISO format where to start.
	//
	// It's specified in ISO 8601 format: yyyy-MM-ddThh:mm:ss.SSSZ. For example,
	// 2019-11-08T02:41:28.172Z.
	AbsoluteTime *string `min:"1" type:"string"`

	// The ID of the message or event where to start.
	Id *string `min:"1" type:"string"`

	// The start position of the most recent message where you want to start.
	MostRecent *int64 `type:"integer"`
}

// String returns the string representation
func (s StartPosition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartPosition) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartPosition) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartPosition"}
	if s.AbsoluteTime != nil && len(*s.AbsoluteTime) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AbsoluteTime", 1))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAbsoluteTime sets the AbsoluteTime field's value.
func (s *StartPosition) SetAbsoluteTime(v string) *StartPosition {
	s.AbsoluteTime = &v
	return s
}

// SetId sets the Id field's value.
func (s *StartPosition) SetId(v string) *StartPosition {
	s.Id = &v
	return s
}

// SetMostRecent sets the MostRecent field's value.
func (s *StartPosition) SetMostRecent(v int64) *StartPosition {
	s.MostRecent = &v
	return s
}

// The request was denied due to request throttling.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The input fails to satisfy the constraints specified by Amazon Connect.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The websocket for the participant's connection.
type Websocket struct {
	_ struct{} `type:"structure"`

	// The URL expiration timestamp in ISO date format.
	//
	// It's specified in ISO 8601 format: yyyy-MM-ddThh:mm:ss.SSSZ. For example,
	// 2019-11-08T02:41:28.172Z.
	ConnectionExpiry *string `type:"string"`

	// The URL of the websocket.
	Url *string `min:"1" type:"string"`
}

// String returns the string representation
func (s Websocket) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Websocket) GoString() string {
	return s.String()
}

// SetConnectionExpiry sets the ConnectionExpiry field's value.
func (s *Websocket) SetConnectionExpiry(v string) *Websocket {
	s.ConnectionExpiry = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *Websocket) SetUrl(v string) *Websocket {
	s.Url = &v
	return s
}

const (
	// ChatItemTypeMessage is a ChatItemType enum value
	ChatItemTypeMessage = "MESSAGE"

	// ChatItemTypeEvent is a ChatItemType enum value
	ChatItemTypeEvent = "EVENT"

	// ChatItemTypeConnectionAck is a ChatItemType enum value
	ChatItemTypeConnectionAck = "CONNECTION_ACK"
)

// ChatItemType_Values returns all elements of the ChatItemType enum
func ChatItemType_Values() []string {
	return []string{
		ChatItemTypeMessage,
		ChatItemTypeEvent,
		ChatItemTypeConnectionAck,
	}
}

const (
	// ConnectionTypeWebsocket is a ConnectionType enum value
	ConnectionTypeWebsocket = "WEBSOCKET"

	// ConnectionTypeConnectionCredentials is a ConnectionType enum value
	ConnectionTypeConnectionCredentials = "CONNECTION_CREDENTIALS"
)

// ConnectionType_Values returns all elements of the ConnectionType enum
func ConnectionType_Values() []string {
	return []string{
		ConnectionTypeWebsocket,
		ConnectionTypeConnectionCredentials,
	}
}

const (
	// ParticipantRoleAgent is a ParticipantRole enum value
	ParticipantRoleAgent = "AGENT"

	// ParticipantRoleCustomer is a ParticipantRole enum value
	ParticipantRoleCustomer = "CUSTOMER"

	// ParticipantRoleSystem is a ParticipantRole enum value
	ParticipantRoleSystem = "SYSTEM"
)

// ParticipantRole_Values returns all elements of the ParticipantRole enum
func ParticipantRole_Values() []string {
	return []string{
		ParticipantRoleAgent,
		ParticipantRoleCustomer,
		ParticipantRoleSystem,
	}
}

const (
	// ScanDirectionForward is a ScanDirection enum value
	ScanDirectionForward = "FORWARD"

	// ScanDirectionBackward is a ScanDirection enum value
	ScanDirectionBackward = "BACKWARD"
)

// ScanDirection_Values returns all elements of the ScanDirection enum
func ScanDirection_Values() []string {
	return []string{
		ScanDirectionForward,
		ScanDirectionBackward,
	}
}

const (
	// SortKeyDescending is a SortKey enum value
	SortKeyDescending = "DESCENDING"

	// SortKeyAscending is a SortKey enum value
	SortKeyAscending = "ASCENDING"
)

// SortKey_Values returns all elements of the SortKey enum
func SortKey_Values() []string {
	return []string{
		SortKeyDescending,
		SortKeyAscending,
	}
}
