// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: storage/api.proto

/*
	Package storage is a generated protocol buffer package.

	It is generated from these files:
		storage/api.proto
		storage/lease_status.proto
		storage/liveness.proto
		storage/log.proto
		storage/raft.proto

	It has these top-level messages:
		StoreRequestHeader
		CollectChecksumRequest
		CollectChecksumResponse
		WaitForApplicationRequest
		WaitForApplicationResponse
		WaitForReplicaInitRequest
		WaitForReplicaInitResponse
		LeaseStatus
		Liveness
		RangeLogEvent
		RaftHeartbeat
		RaftMessageRequest
		RaftMessageRequestBatch
		RaftMessageResponseUnion
		RaftMessageResponse
		SnapshotRequest
		SnapshotResponse
		ConfChangeContext
*/
package storage

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import cockroach_roachpb1 "github.com/cockroachdb/cockroach/pkg/roachpb"
import cockroach_storage_engine_enginepb "github.com/cockroachdb/cockroach/pkg/storage/engine/enginepb"

import github_com_cockroachdb_cockroach_pkg_roachpb "github.com/cockroachdb/cockroach/pkg/roachpb"
import github_com_cockroachdb_cockroach_pkg_util_uuid "github.com/cockroachdb/cockroach/pkg/util/uuid"

import context "context"
import grpc "google.golang.org/grpc"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

// StoreRequestHeader locates a Store on a Node.
type StoreRequestHeader struct {
	NodeID  github_com_cockroachdb_cockroach_pkg_roachpb.NodeID  `protobuf:"varint,1,opt,name=node_id,json=nodeId,proto3,casttype=github.com/cockroachdb/cockroach/pkg/roachpb.NodeID" json:"node_id,omitempty"`
	StoreID github_com_cockroachdb_cockroach_pkg_roachpb.StoreID `protobuf:"varint,2,opt,name=store_id,json=storeId,proto3,casttype=github.com/cockroachdb/cockroach/pkg/roachpb.StoreID" json:"store_id,omitempty"`
}

func (m *StoreRequestHeader) Reset()                    { *m = StoreRequestHeader{} }
func (m *StoreRequestHeader) String() string            { return proto.CompactTextString(m) }
func (*StoreRequestHeader) ProtoMessage()               {}
func (*StoreRequestHeader) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{0} }

// A CollectChecksumRequest asks the addressed replica for the result of a
// roachpb.ComputeChecksumRequest.
type CollectChecksumRequest struct {
	StoreRequestHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	RangeID            github_com_cockroachdb_cockroach_pkg_roachpb.RangeID `protobuf:"varint,2,opt,name=range_id,json=rangeId,proto3,casttype=github.com/cockroachdb/cockroach/pkg/roachpb.RangeID" json:"range_id,omitempty"`
	// checksum_id identifies the corresponding roachpb.ComputeChecksumRequest.
	ChecksumID github_com_cockroachdb_cockroach_pkg_util_uuid.UUID `protobuf:"bytes,3,opt,name=checksum_id,json=checksumId,proto3,customtype=github.com/cockroachdb/cockroach/pkg/util/uuid.UUID" json:"checksum_id"`
	Checksum   []byte                                              `protobuf:"bytes,4,opt,name=checksum,proto3" json:"checksum,omitempty"`
}

func (m *CollectChecksumRequest) Reset()                    { *m = CollectChecksumRequest{} }
func (m *CollectChecksumRequest) String() string            { return proto.CompactTextString(m) }
func (*CollectChecksumRequest) ProtoMessage()               {}
func (*CollectChecksumRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{1} }

type CollectChecksumResponse struct {
	Checksum []byte `protobuf:"bytes,1,opt,name=checksum,proto3" json:"checksum,omitempty"`
	// snapshot is set if the roachpb.ComputeChecksumRequest had snapshot = true
	// and the response checksum is different from the request checksum.
	//
	// TODO(tschottdorf): with larger ranges, this is no longer tenable.
	// See https://github.com/cockroachdb/cockroach/issues/21128.
	Snapshot *cockroach_roachpb1.RaftSnapshotData `protobuf:"bytes,2,opt,name=snapshot" json:"snapshot,omitempty"`
	// delta carries the stats of the range minus the recomputed stats.
	Delta cockroach_storage_engine_enginepb.MVCCStatsDelta `protobuf:"bytes,3,opt,name=delta" json:"delta"`
}

func (m *CollectChecksumResponse) Reset()                    { *m = CollectChecksumResponse{} }
func (m *CollectChecksumResponse) String() string            { return proto.CompactTextString(m) }
func (*CollectChecksumResponse) ProtoMessage()               {}
func (*CollectChecksumResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{2} }

// WaitForApplicationRequest blocks until the addressed replica has applied the
// command with the specified lease index.
type WaitForApplicationRequest struct {
	StoreRequestHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	RangeID            github_com_cockroachdb_cockroach_pkg_roachpb.RangeID `protobuf:"varint,2,opt,name=range_id,json=rangeId,proto3,casttype=github.com/cockroachdb/cockroach/pkg/roachpb.RangeID" json:"range_id,omitempty"`
	LeaseIndex         uint64                                               `protobuf:"varint,3,opt,name=lease_index,json=leaseIndex,proto3" json:"lease_index,omitempty"`
}

func (m *WaitForApplicationRequest) Reset()                    { *m = WaitForApplicationRequest{} }
func (m *WaitForApplicationRequest) String() string            { return proto.CompactTextString(m) }
func (*WaitForApplicationRequest) ProtoMessage()               {}
func (*WaitForApplicationRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{3} }

type WaitForApplicationResponse struct {
}

func (m *WaitForApplicationResponse) Reset()                    { *m = WaitForApplicationResponse{} }
func (m *WaitForApplicationResponse) String() string            { return proto.CompactTextString(m) }
func (*WaitForApplicationResponse) ProtoMessage()               {}
func (*WaitForApplicationResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{4} }

type WaitForReplicaInitRequest struct {
	StoreRequestHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	RangeID            github_com_cockroachdb_cockroach_pkg_roachpb.RangeID `protobuf:"varint,2,opt,name=range_id,json=rangeId,proto3,casttype=github.com/cockroachdb/cockroach/pkg/roachpb.RangeID" json:"range_id,omitempty"`
}

func (m *WaitForReplicaInitRequest) Reset()                    { *m = WaitForReplicaInitRequest{} }
func (m *WaitForReplicaInitRequest) String() string            { return proto.CompactTextString(m) }
func (*WaitForReplicaInitRequest) ProtoMessage()               {}
func (*WaitForReplicaInitRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{5} }

type WaitForReplicaInitResponse struct {
}

func (m *WaitForReplicaInitResponse) Reset()                    { *m = WaitForReplicaInitResponse{} }
func (m *WaitForReplicaInitResponse) String() string            { return proto.CompactTextString(m) }
func (*WaitForReplicaInitResponse) ProtoMessage()               {}
func (*WaitForReplicaInitResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{6} }

func init() {
	proto.RegisterType((*StoreRequestHeader)(nil), "cockroach.storage.StoreRequestHeader")
	proto.RegisterType((*CollectChecksumRequest)(nil), "cockroach.storage.CollectChecksumRequest")
	proto.RegisterType((*CollectChecksumResponse)(nil), "cockroach.storage.CollectChecksumResponse")
	proto.RegisterType((*WaitForApplicationRequest)(nil), "cockroach.storage.WaitForApplicationRequest")
	proto.RegisterType((*WaitForApplicationResponse)(nil), "cockroach.storage.WaitForApplicationResponse")
	proto.RegisterType((*WaitForReplicaInitRequest)(nil), "cockroach.storage.WaitForReplicaInitRequest")
	proto.RegisterType((*WaitForReplicaInitResponse)(nil), "cockroach.storage.WaitForReplicaInitResponse")
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for PerReplica service

type PerReplicaClient interface {
	CollectChecksum(ctx context.Context, in *CollectChecksumRequest, opts ...grpc.CallOption) (*CollectChecksumResponse, error)
	WaitForApplication(ctx context.Context, in *WaitForApplicationRequest, opts ...grpc.CallOption) (*WaitForApplicationResponse, error)
	WaitForReplicaInit(ctx context.Context, in *WaitForReplicaInitRequest, opts ...grpc.CallOption) (*WaitForReplicaInitResponse, error)
}

type perReplicaClient struct {
	cc *grpc.ClientConn
}

func NewPerReplicaClient(cc *grpc.ClientConn) PerReplicaClient {
	return &perReplicaClient{cc}
}

func (c *perReplicaClient) CollectChecksum(ctx context.Context, in *CollectChecksumRequest, opts ...grpc.CallOption) (*CollectChecksumResponse, error) {
	out := new(CollectChecksumResponse)
	err := grpc.Invoke(ctx, "/cockroach.storage.PerReplica/CollectChecksum", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *perReplicaClient) WaitForApplication(ctx context.Context, in *WaitForApplicationRequest, opts ...grpc.CallOption) (*WaitForApplicationResponse, error) {
	out := new(WaitForApplicationResponse)
	err := grpc.Invoke(ctx, "/cockroach.storage.PerReplica/WaitForApplication", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *perReplicaClient) WaitForReplicaInit(ctx context.Context, in *WaitForReplicaInitRequest, opts ...grpc.CallOption) (*WaitForReplicaInitResponse, error) {
	out := new(WaitForReplicaInitResponse)
	err := grpc.Invoke(ctx, "/cockroach.storage.PerReplica/WaitForReplicaInit", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for PerReplica service

type PerReplicaServer interface {
	CollectChecksum(context.Context, *CollectChecksumRequest) (*CollectChecksumResponse, error)
	WaitForApplication(context.Context, *WaitForApplicationRequest) (*WaitForApplicationResponse, error)
	WaitForReplicaInit(context.Context, *WaitForReplicaInitRequest) (*WaitForReplicaInitResponse, error)
}

func RegisterPerReplicaServer(s *grpc.Server, srv PerReplicaServer) {
	s.RegisterService(&_PerReplica_serviceDesc, srv)
}

func _PerReplica_CollectChecksum_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CollectChecksumRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PerReplicaServer).CollectChecksum(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cockroach.storage.PerReplica/CollectChecksum",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PerReplicaServer).CollectChecksum(ctx, req.(*CollectChecksumRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PerReplica_WaitForApplication_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(WaitForApplicationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PerReplicaServer).WaitForApplication(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cockroach.storage.PerReplica/WaitForApplication",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PerReplicaServer).WaitForApplication(ctx, req.(*WaitForApplicationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PerReplica_WaitForReplicaInit_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(WaitForReplicaInitRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PerReplicaServer).WaitForReplicaInit(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cockroach.storage.PerReplica/WaitForReplicaInit",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PerReplicaServer).WaitForReplicaInit(ctx, req.(*WaitForReplicaInitRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _PerReplica_serviceDesc = grpc.ServiceDesc{
	ServiceName: "cockroach.storage.PerReplica",
	HandlerType: (*PerReplicaServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CollectChecksum",
			Handler:    _PerReplica_CollectChecksum_Handler,
		},
		{
			MethodName: "WaitForApplication",
			Handler:    _PerReplica_WaitForApplication_Handler,
		},
		{
			MethodName: "WaitForReplicaInit",
			Handler:    _PerReplica_WaitForReplicaInit_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "storage/api.proto",
}

func (m *StoreRequestHeader) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StoreRequestHeader) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.NodeID != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.NodeID))
	}
	if m.StoreID != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.StoreID))
	}
	return i, nil
}

func (m *CollectChecksumRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CollectChecksumRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.StoreRequestHeader.Size()))
	n1, err := m.StoreRequestHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n1
	if m.RangeID != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.RangeID))
	}
	dAtA[i] = 0x1a
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ChecksumID.Size()))
	n2, err := m.ChecksumID.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n2
	if len(m.Checksum) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintApi(dAtA, i, uint64(len(m.Checksum)))
		i += copy(dAtA[i:], m.Checksum)
	}
	return i, nil
}

func (m *CollectChecksumResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CollectChecksumResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Checksum) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintApi(dAtA, i, uint64(len(m.Checksum)))
		i += copy(dAtA[i:], m.Checksum)
	}
	if m.Snapshot != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Snapshot.Size()))
		n3, err := m.Snapshot.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	dAtA[i] = 0x1a
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Delta.Size()))
	n4, err := m.Delta.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n4
	return i, nil
}

func (m *WaitForApplicationRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *WaitForApplicationRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.StoreRequestHeader.Size()))
	n5, err := m.StoreRequestHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n5
	if m.RangeID != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.RangeID))
	}
	if m.LeaseIndex != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.LeaseIndex))
	}
	return i, nil
}

func (m *WaitForApplicationResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *WaitForApplicationResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *WaitForReplicaInitRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *WaitForReplicaInitRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.StoreRequestHeader.Size()))
	n6, err := m.StoreRequestHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n6
	if m.RangeID != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.RangeID))
	}
	return i, nil
}

func (m *WaitForReplicaInitResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *WaitForReplicaInitResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func encodeVarintApi(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *StoreRequestHeader) Size() (n int) {
	var l int
	_ = l
	if m.NodeID != 0 {
		n += 1 + sovApi(uint64(m.NodeID))
	}
	if m.StoreID != 0 {
		n += 1 + sovApi(uint64(m.StoreID))
	}
	return n
}

func (m *CollectChecksumRequest) Size() (n int) {
	var l int
	_ = l
	l = m.StoreRequestHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	if m.RangeID != 0 {
		n += 1 + sovApi(uint64(m.RangeID))
	}
	l = m.ChecksumID.Size()
	n += 1 + l + sovApi(uint64(l))
	l = len(m.Checksum)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *CollectChecksumResponse) Size() (n int) {
	var l int
	_ = l
	l = len(m.Checksum)
	if l > 0 {
		n += 1 + l + sovApi(uint64(l))
	}
	if m.Snapshot != nil {
		l = m.Snapshot.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	l = m.Delta.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *WaitForApplicationRequest) Size() (n int) {
	var l int
	_ = l
	l = m.StoreRequestHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	if m.RangeID != 0 {
		n += 1 + sovApi(uint64(m.RangeID))
	}
	if m.LeaseIndex != 0 {
		n += 1 + sovApi(uint64(m.LeaseIndex))
	}
	return n
}

func (m *WaitForApplicationResponse) Size() (n int) {
	var l int
	_ = l
	return n
}

func (m *WaitForReplicaInitRequest) Size() (n int) {
	var l int
	_ = l
	l = m.StoreRequestHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	if m.RangeID != 0 {
		n += 1 + sovApi(uint64(m.RangeID))
	}
	return n
}

func (m *WaitForReplicaInitResponse) Size() (n int) {
	var l int
	_ = l
	return n
}

func sovApi(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozApi(x uint64) (n int) {
	return sovApi(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *StoreRequestHeader) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StoreRequestHeader: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StoreRequestHeader: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeID", wireType)
			}
			m.NodeID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NodeID |= (github_com_cockroachdb_cockroach_pkg_roachpb.NodeID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StoreID", wireType)
			}
			m.StoreID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StoreID |= (github_com_cockroachdb_cockroach_pkg_roachpb.StoreID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CollectChecksumRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CollectChecksumRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CollectChecksumRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StoreRequestHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.StoreRequestHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RangeID", wireType)
			}
			m.RangeID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RangeID |= (github_com_cockroachdb_cockroach_pkg_roachpb.RangeID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ChecksumID", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ChecksumID.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Checksum", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Checksum = append(m.Checksum[:0], dAtA[iNdEx:postIndex]...)
			if m.Checksum == nil {
				m.Checksum = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CollectChecksumResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CollectChecksumResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CollectChecksumResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Checksum", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Checksum = append(m.Checksum[:0], dAtA[iNdEx:postIndex]...)
			if m.Checksum == nil {
				m.Checksum = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Snapshot", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Snapshot == nil {
				m.Snapshot = &cockroach_roachpb1.RaftSnapshotData{}
			}
			if err := m.Snapshot.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Delta", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Delta.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *WaitForApplicationRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: WaitForApplicationRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: WaitForApplicationRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StoreRequestHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.StoreRequestHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RangeID", wireType)
			}
			m.RangeID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RangeID |= (github_com_cockroachdb_cockroach_pkg_roachpb.RangeID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LeaseIndex", wireType)
			}
			m.LeaseIndex = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LeaseIndex |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *WaitForApplicationResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: WaitForApplicationResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: WaitForApplicationResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *WaitForReplicaInitRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: WaitForReplicaInitRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: WaitForReplicaInitRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StoreRequestHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.StoreRequestHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RangeID", wireType)
			}
			m.RangeID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RangeID |= (github_com_cockroachdb_cockroach_pkg_roachpb.RangeID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *WaitForReplicaInitResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: WaitForReplicaInitResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: WaitForReplicaInitResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipApi(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowApi
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowApi
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowApi
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthApi
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowApi
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipApi(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthApi = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowApi   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("storage/api.proto", fileDescriptorApi) }

var fileDescriptorApi = []byte{
	// 628 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xd4, 0x55, 0x5f, 0x6f, 0xd3, 0x3e,
	0x14, 0xad, 0xf7, 0xa7, 0xad, 0xdc, 0x9f, 0xf4, 0xd3, 0x2c, 0x34, 0x46, 0x41, 0xcd, 0xc8, 0x84,
	0x34, 0x10, 0x24, 0xa2, 0xe3, 0x1d, 0xad, 0xad, 0x80, 0x3c, 0x0c, 0x21, 0x4f, 0x03, 0x69, 0x0f,
	0x4c, 0x6e, 0xec, 0xa5, 0xde, 0xb2, 0x38, 0x24, 0x0e, 0xe2, 0x63, 0xf0, 0xa1, 0x40, 0x1a, 0x6f,
	0x7b, 0x44, 0x3c, 0x44, 0x10, 0xc4, 0x97, 0xe0, 0x09, 0xd9, 0x71, 0xba, 0x8d, 0x86, 0x69, 0xf0,
	0xb6, 0xa7, 0xda, 0xd7, 0xf7, 0x9c, 0x7b, 0xcf, 0xb9, 0x57, 0x0d, 0x5c, 0x4a, 0xa5, 0x48, 0x48,
	0xc0, 0x5c, 0x12, 0x73, 0x27, 0x4e, 0x84, 0x14, 0x68, 0xc9, 0x17, 0xfe, 0x61, 0x22, 0x88, 0x3f,
	0x71, 0xcc, 0x63, 0xf7, 0xa6, 0xbe, 0xc6, 0x63, 0x97, 0x47, 0x92, 0x25, 0x11, 0x09, 0xf7, 0x12,
	0xb2, 0x2f, 0xcb, 0xfc, 0xee, 0x72, 0xf5, 0x78, 0xc4, 0x24, 0xa1, 0x44, 0x12, 0x13, 0x5f, 0xab,
	0xa8, 0x59, 0x14, 0xf0, 0xa8, 0xfa, 0x51, 0x79, 0x6f, 0x7d, 0x7f, 0xc3, 0x24, 0x5d, 0x0b, 0x44,
	0x20, 0xf4, 0xd1, 0x55, 0xa7, 0x32, 0x6a, 0x9f, 0x00, 0x88, 0xb6, 0xa5, 0x48, 0x18, 0x66, 0x6f,
	0x32, 0x96, 0xca, 0x67, 0x8c, 0x50, 0x96, 0xa0, 0x5d, 0xd8, 0x8a, 0x04, 0x65, 0x7b, 0x9c, 0xae,
	0x80, 0x55, 0xb0, 0xbe, 0x38, 0xd8, 0x2c, 0x72, 0xab, 0xf9, 0x5c, 0x50, 0xe6, 0x8d, 0x7e, 0xe6,
	0xd6, 0x46, 0xc0, 0xe5, 0x24, 0x1b, 0x3b, 0xbe, 0x38, 0x72, 0xa7, 0x1a, 0xe8, 0xf8, 0xf4, 0xec,
	0xc6, 0x87, 0x81, 0x6b, 0xba, 0x75, 0x4a, 0x18, 0x6e, 0x2a, 0x46, 0x8f, 0xa2, 0xd7, 0xb0, 0xad,
	0xfa, 0xd5, 0xe4, 0x73, 0x9a, 0x7c, 0x58, 0xe4, 0x56, 0x4b, 0x77, 0xa1, 0xd9, 0x1f, 0xfd, 0x15,
	0xbb, 0xc1, 0xe1, 0x96, 0x26, 0xf5, 0xa8, 0xfd, 0x69, 0x0e, 0x2e, 0x0f, 0x45, 0x18, 0x32, 0x5f,
	0x0e, 0x27, 0xcc, 0x3f, 0x4c, 0xb3, 0x23, 0x23, 0x0e, 0x3d, 0x85, 0xcd, 0x89, 0x16, 0xa8, 0x55,
	0x75, 0xfa, 0x77, 0x9c, 0x99, 0x09, 0x38, 0xb3, 0x6e, 0x0c, 0xda, 0xc7, 0xb9, 0xd5, 0x38, 0xc9,
	0x2d, 0x80, 0x0d, 0x5c, 0x69, 0x48, 0x48, 0x14, 0x4c, 0x35, 0xcc, 0x97, 0x1a, 0xb0, 0x8a, 0xfd,
	0x83, 0x06, 0x83, 0xc3, 0x2d, 0x4d, 0xea, 0x51, 0x74, 0x00, 0x3b, 0xbe, 0xe9, 0x5d, 0x95, 0x98,
	0x5f, 0x05, 0xeb, 0xff, 0x0d, 0x3c, 0xd5, 0xc6, 0x97, 0xcb, 0xba, 0x9f, 0x49, 0x1e, 0xba, 0x59,
	0xc6, 0xa9, 0xb3, 0xb3, 0xe3, 0x8d, 0x8a, 0xdc, 0x82, 0x95, 0x1b, 0xde, 0x08, 0xc3, 0x8a, 0xdd,
	0xa3, 0xa8, 0x0b, 0xdb, 0xd5, 0x6d, 0x65, 0x41, 0x15, 0xc2, 0xd3, 0xbb, 0xfd, 0x11, 0xc0, 0xeb,
	0x33, 0x5e, 0xa6, 0xb1, 0x88, 0x52, 0x76, 0x0e, 0x07, 0xce, 0xe3, 0xd0, 0x63, 0xd8, 0x4e, 0x23,
	0x12, 0xa7, 0x13, 0x21, 0xb5, 0x3f, 0x9d, 0xfe, 0xda, 0x19, 0xab, 0x4f, 0x65, 0xef, 0xcb, 0x6d,
	0x93, 0x36, 0x22, 0x92, 0xe0, 0x29, 0x08, 0x6d, 0xc1, 0x45, 0xca, 0x42, 0x49, 0xb4, 0xf4, 0x4e,
	0xff, 0x61, 0xcd, 0xa0, 0xca, 0x2d, 0x77, 0xaa, 0x65, 0x77, 0xb6, 0x5e, 0x0e, 0x87, 0xdb, 0x92,
	0xc8, 0x74, 0xa4, 0x80, 0x83, 0x05, 0xe5, 0x16, 0x2e, 0x59, 0xec, 0x1f, 0x00, 0xde, 0x78, 0x45,
	0xb8, 0x7c, 0x22, 0x92, 0xcd, 0x38, 0x0e, 0xb9, 0x4f, 0x24, 0x17, 0xd1, 0x95, 0x5b, 0x0b, 0x0b,
	0x76, 0x42, 0x46, 0x52, 0xb6, 0xc7, 0x23, 0xca, 0xde, 0x69, 0x6f, 0x16, 0x30, 0xd4, 0x21, 0x4f,
	0x45, 0xec, 0x5b, 0xb0, 0x5b, 0x27, 0xb3, 0x9c, 0x98, 0xfd, 0xe1, 0xd4, 0x05, 0xcc, 0xf4, 0xb3,
	0x17, 0x71, 0x79, 0xd5, 0x5c, 0x38, 0x23, 0xf2, 0x9c, 0x8a, 0x52, 0x64, 0xbf, 0x98, 0x83, 0xf0,
	0x05, 0xab, 0x9e, 0xd0, 0x01, 0xfc, 0xff, 0xb7, 0x05, 0x46, 0x77, 0x6b, 0x84, 0xd5, 0xff, 0x61,
	0x74, 0xef, 0x5d, 0x26, 0xd5, 0xb8, 0xdb, 0x40, 0x29, 0x44, 0xb3, 0xee, 0xa3, 0xfb, 0x35, 0x1c,
	0x7f, 0xdc, 0xc5, 0xee, 0x83, 0x4b, 0x66, 0xd7, 0x14, 0x3d, 0xe3, 0xc6, 0x45, 0x45, 0x67, 0x47,
	0x7f, 0x51, 0xd1, 0x1a, 0x8b, 0xed, 0xc6, 0xe0, 0xf6, 0xf1, 0xb7, 0x5e, 0xe3, 0xb8, 0xe8, 0x81,
	0x93, 0xa2, 0x07, 0x3e, 0x17, 0x3d, 0xf0, 0xb5, 0xe8, 0x81, 0xf7, 0xdf, 0x7b, 0x8d, 0xdd, 0x96,
	0xc1, 0x8f, 0x9b, 0xfa, 0x03, 0xb3, 0xf1, 0x2b, 0x00, 0x00, 0xff, 0xff, 0x9d, 0xba, 0x22, 0x72,
	0xf8, 0x06, 0x00, 0x00,
}
