// Package xfixes is the X client API for the XFIXES extension.
package xfixes

// This file is automatically generated from xfixes.xml. Edit at your peril!

import (
	"github.com/jezek/xgb"

	"github.com/jezek/xgb/render"
	"github.com/jezek/xgb/shape"
	"github.com/jezek/xgb/xproto"
)

// Init must be called before using the XFIXES extension.
func Init(c *xgb.Conn) error {
	reply, err := xproto.QueryExtension(c, 6, "XFIXES").Reply()
	switch {
	case err != nil:
		return err
	case !reply.Present:
		return xgb.Errorf("No extension named XFIXES could be found on on the server.")
	}

	c.ExtLock.Lock()
	c.Extensions["XFIXES"] = reply.MajorOpcode
	c.ExtLock.Unlock()
	for evNum, fun := range xgb.NewExtEventFuncs["XFIXES"] {
		xgb.NewEventFuncs[int(reply.FirstEvent)+evNum] = fun
	}
	for errNum, fun := range xgb.NewExtErrorFuncs["XFIXES"] {
		xgb.NewErrorFuncs[int(reply.FirstError)+errNum] = fun
	}
	return nil
}

func init() {
	xgb.NewExtEventFuncs["XFIXES"] = make(map[int]xgb.NewEventFun)
	xgb.NewExtErrorFuncs["XFIXES"] = make(map[int]xgb.NewErrorFun)
}

// BadBadRegion is the error number for a BadBadRegion.
const BadBadRegion = 0

type BadRegionError struct {
	Sequence uint16
	NiceName string
}

// BadRegionErrorNew constructs a BadRegionError value that implements xgb.Error from a byte slice.
func BadRegionErrorNew(buf []byte) xgb.Error {
	v := BadRegionError{}
	v.NiceName = "BadRegion"

	b := 1 // skip error determinant
	b += 1 // don't read error number

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	return v
}

// SequenceId returns the sequence id attached to the BadBadRegion error.
// This is mostly used internally.
func (err BadRegionError) SequenceId() uint16 {
	return err.Sequence
}

// BadId returns the 'BadValue' number if one exists for the BadBadRegion error. If no bad value exists, 0 is returned.
func (err BadRegionError) BadId() uint32 {
	return 0
}

// Error returns a rudimentary string representation of the BadBadRegion error.

func (err BadRegionError) Error() string {
	fieldVals := make([]string, 0, 0)
	fieldVals = append(fieldVals, "NiceName: "+err.NiceName)
	fieldVals = append(fieldVals, xgb.Sprintf("Sequence: %d", err.Sequence))
	return "BadBadRegion {" + xgb.StringsJoin(fieldVals, ", ") + "}"
}

func init() {
	xgb.NewExtErrorFuncs["XFIXES"][0] = BadRegionErrorNew
}

type Barrier uint32

func NewBarrierId(c *xgb.Conn) (Barrier, error) {
	id, err := c.NewId()
	if err != nil {
		return 0, err
	}
	return Barrier(id), nil
}

const (
	BarrierDirectionsPositiveX = 1
	BarrierDirectionsPositiveY = 2
	BarrierDirectionsNegativeX = 4
	BarrierDirectionsNegativeY = 8
)

const (
	ClientDisconnectFlagsDefault   = 0
	ClientDisconnectFlagsTerminate = 1
)

// CursorNotify is the event number for a CursorNotifyEvent.
const CursorNotify = 1

type CursorNotifyEvent struct {
	Sequence     uint16
	Subtype      byte
	Window       xproto.Window
	CursorSerial uint32
	Timestamp    xproto.Timestamp
	Name         xproto.Atom
	// padding: 12 bytes
}

// CursorNotifyEventNew constructs a CursorNotifyEvent value that implements xgb.Event from a byte slice.
func CursorNotifyEventNew(buf []byte) xgb.Event {
	v := CursorNotifyEvent{}
	b := 1 // don't read event number

	v.Subtype = buf[b]
	b += 1

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Window = xproto.Window(xgb.Get32(buf[b:]))
	b += 4

	v.CursorSerial = xgb.Get32(buf[b:])
	b += 4

	v.Timestamp = xproto.Timestamp(xgb.Get32(buf[b:]))
	b += 4

	v.Name = xproto.Atom(xgb.Get32(buf[b:]))
	b += 4

	b += 12 // padding

	return v
}

// Bytes writes a CursorNotifyEvent value to a byte slice.
func (v CursorNotifyEvent) Bytes() []byte {
	buf := make([]byte, 32)
	b := 0

	// write event number
	buf[b] = 1
	b += 1

	buf[b] = v.Subtype
	b += 1

	b += 2 // skip sequence number

	xgb.Put32(buf[b:], uint32(v.Window))
	b += 4

	xgb.Put32(buf[b:], v.CursorSerial)
	b += 4

	xgb.Put32(buf[b:], uint32(v.Timestamp))
	b += 4

	xgb.Put32(buf[b:], uint32(v.Name))
	b += 4

	b += 12 // padding

	return buf
}

// SequenceId returns the sequence id attached to the CursorNotify event.
// Events without a sequence number (KeymapNotify) return 0.
// This is mostly used internally.
func (v CursorNotifyEvent) SequenceId() uint16 {
	return v.Sequence
}

// String is a rudimentary string representation of CursorNotifyEvent.
func (v CursorNotifyEvent) String() string {
	fieldVals := make([]string, 0, 6)
	fieldVals = append(fieldVals, xgb.Sprintf("Sequence: %d", v.Sequence))
	fieldVals = append(fieldVals, xgb.Sprintf("Subtype: %d", v.Subtype))
	fieldVals = append(fieldVals, xgb.Sprintf("Window: %d", v.Window))
	fieldVals = append(fieldVals, xgb.Sprintf("CursorSerial: %d", v.CursorSerial))
	fieldVals = append(fieldVals, xgb.Sprintf("Timestamp: %d", v.Timestamp))
	fieldVals = append(fieldVals, xgb.Sprintf("Name: %d", v.Name))
	return "CursorNotify {" + xgb.StringsJoin(fieldVals, ", ") + "}"
}

func init() {
	xgb.NewExtEventFuncs["XFIXES"][1] = CursorNotifyEventNew
}

const (
	CursorNotifyDisplayCursor = 0
)

const (
	CursorNotifyMaskDisplayCursor = 1
)

type Region uint32

func NewRegionId(c *xgb.Conn) (Region, error) {
	id, err := c.NewId()
	if err != nil {
		return 0, err
	}
	return Region(id), nil
}

const (
	RegionNone = 0
)

const (
	SaveSetMappingMap   = 0
	SaveSetMappingUnmap = 1
)

const (
	SaveSetModeInsert = 0
	SaveSetModeDelete = 1
)

const (
	SaveSetTargetNearest = 0
	SaveSetTargetRoot    = 1
)

const (
	SelectionEventSetSelectionOwner      = 0
	SelectionEventSelectionWindowDestroy = 1
	SelectionEventSelectionClientClose   = 2
)

const (
	SelectionEventMaskSetSelectionOwner      = 1
	SelectionEventMaskSelectionWindowDestroy = 2
	SelectionEventMaskSelectionClientClose   = 4
)

// SelectionNotify is the event number for a SelectionNotifyEvent.
const SelectionNotify = 0

type SelectionNotifyEvent struct {
	Sequence           uint16
	Subtype            byte
	Window             xproto.Window
	Owner              xproto.Window
	Selection          xproto.Atom
	Timestamp          xproto.Timestamp
	SelectionTimestamp xproto.Timestamp
	// padding: 8 bytes
}

// SelectionNotifyEventNew constructs a SelectionNotifyEvent value that implements xgb.Event from a byte slice.
func SelectionNotifyEventNew(buf []byte) xgb.Event {
	v := SelectionNotifyEvent{}
	b := 1 // don't read event number

	v.Subtype = buf[b]
	b += 1

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Window = xproto.Window(xgb.Get32(buf[b:]))
	b += 4

	v.Owner = xproto.Window(xgb.Get32(buf[b:]))
	b += 4

	v.Selection = xproto.Atom(xgb.Get32(buf[b:]))
	b += 4

	v.Timestamp = xproto.Timestamp(xgb.Get32(buf[b:]))
	b += 4

	v.SelectionTimestamp = xproto.Timestamp(xgb.Get32(buf[b:]))
	b += 4

	b += 8 // padding

	return v
}

// Bytes writes a SelectionNotifyEvent value to a byte slice.
func (v SelectionNotifyEvent) Bytes() []byte {
	buf := make([]byte, 32)
	b := 0

	// write event number
	buf[b] = 0
	b += 1

	buf[b] = v.Subtype
	b += 1

	b += 2 // skip sequence number

	xgb.Put32(buf[b:], uint32(v.Window))
	b += 4

	xgb.Put32(buf[b:], uint32(v.Owner))
	b += 4

	xgb.Put32(buf[b:], uint32(v.Selection))
	b += 4

	xgb.Put32(buf[b:], uint32(v.Timestamp))
	b += 4

	xgb.Put32(buf[b:], uint32(v.SelectionTimestamp))
	b += 4

	b += 8 // padding

	return buf
}

// SequenceId returns the sequence id attached to the SelectionNotify event.
// Events without a sequence number (KeymapNotify) return 0.
// This is mostly used internally.
func (v SelectionNotifyEvent) SequenceId() uint16 {
	return v.Sequence
}

// String is a rudimentary string representation of SelectionNotifyEvent.
func (v SelectionNotifyEvent) String() string {
	fieldVals := make([]string, 0, 7)
	fieldVals = append(fieldVals, xgb.Sprintf("Sequence: %d", v.Sequence))
	fieldVals = append(fieldVals, xgb.Sprintf("Subtype: %d", v.Subtype))
	fieldVals = append(fieldVals, xgb.Sprintf("Window: %d", v.Window))
	fieldVals = append(fieldVals, xgb.Sprintf("Owner: %d", v.Owner))
	fieldVals = append(fieldVals, xgb.Sprintf("Selection: %d", v.Selection))
	fieldVals = append(fieldVals, xgb.Sprintf("Timestamp: %d", v.Timestamp))
	fieldVals = append(fieldVals, xgb.Sprintf("SelectionTimestamp: %d", v.SelectionTimestamp))
	return "SelectionNotify {" + xgb.StringsJoin(fieldVals, ", ") + "}"
}

func init() {
	xgb.NewExtEventFuncs["XFIXES"][0] = SelectionNotifyEventNew
}

// Skipping definition for base type 'Bool'

// Skipping definition for base type 'Byte'

// Skipping definition for base type 'Card8'

// Skipping definition for base type 'Char'

// Skipping definition for base type 'Void'

// Skipping definition for base type 'Double'

// Skipping definition for base type 'Float'

// Skipping definition for base type 'Int16'

// Skipping definition for base type 'Int32'

// Skipping definition for base type 'Int8'

// Skipping definition for base type 'Card16'

// Skipping definition for base type 'Card32'

// ChangeCursorCookie is a cookie used only for ChangeCursor requests.
type ChangeCursorCookie struct {
	*xgb.Cookie
}

// ChangeCursor sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func ChangeCursor(c *xgb.Conn, Source xproto.Cursor, Destination xproto.Cursor) ChangeCursorCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFIXES"]; !ok {
		panic("Cannot issue request 'ChangeCursor' using the uninitialized extension 'XFIXES'. xfixes.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(changeCursorRequest(c, Source, Destination), cookie)
	return ChangeCursorCookie{cookie}
}

// ChangeCursorChecked sends a checked request.
// If an error occurs, it can be retrieved using ChangeCursorCookie.Check()
func ChangeCursorChecked(c *xgb.Conn, Source xproto.Cursor, Destination xproto.Cursor) ChangeCursorCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFIXES"]; !ok {
		panic("Cannot issue request 'ChangeCursor' using the uninitialized extension 'XFIXES'. xfixes.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(changeCursorRequest(c, Source, Destination), cookie)
	return ChangeCursorCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook ChangeCursorCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for ChangeCursor
// changeCursorRequest writes a ChangeCursor request to a byte slice.
func changeCursorRequest(c *xgb.Conn, Source xproto.Cursor, Destination xproto.Cursor) []byte {
	size := 12
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["XFIXES"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 26 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Source))
	b += 4

	xgb.Put32(buf[b:], uint32(Destination))
	b += 4

	return buf
}

// ChangeCursorByNameCookie is a cookie used only for ChangeCursorByName requests.
type ChangeCursorByNameCookie struct {
	*xgb.Cookie
}

// ChangeCursorByName sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func ChangeCursorByName(c *xgb.Conn, Src xproto.Cursor, Nbytes uint16, Name string) ChangeCursorByNameCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFIXES"]; !ok {
		panic("Cannot issue request 'ChangeCursorByName' using the uninitialized extension 'XFIXES'. xfixes.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(changeCursorByNameRequest(c, Src, Nbytes, Name), cookie)
	return ChangeCursorByNameCookie{cookie}
}

// ChangeCursorByNameChecked sends a checked request.
// If an error occurs, it can be retrieved using ChangeCursorByNameCookie.Check()
func ChangeCursorByNameChecked(c *xgb.Conn, Src xproto.Cursor, Nbytes uint16, Name string) ChangeCursorByNameCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFIXES"]; !ok {
		panic("Cannot issue request 'ChangeCursorByName' using the uninitialized extension 'XFIXES'. xfixes.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(changeCursorByNameRequest(c, Src, Nbytes, Name), cookie)
	return ChangeCursorByNameCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook ChangeCursorByNameCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for ChangeCursorByName
// changeCursorByNameRequest writes a ChangeCursorByName request to a byte slice.
func changeCursorByNameRequest(c *xgb.Conn, Src xproto.Cursor, Nbytes uint16, Name string) []byte {
	size := xgb.Pad((12 + xgb.Pad((int(Nbytes) * 1))))
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["XFIXES"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 27 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Src))
	b += 4

	xgb.Put16(buf[b:], Nbytes)
	b += 2

	b += 2 // padding

	copy(buf[b:], Name[:Nbytes])
	b += int(Nbytes)

	return buf
}

// ChangeSaveSetCookie is a cookie used only for ChangeSaveSet requests.
type ChangeSaveSetCookie struct {
	*xgb.Cookie
}

// ChangeSaveSet sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func ChangeSaveSet(c *xgb.Conn, Mode byte, Target byte, Map byte, Window xproto.Window) ChangeSaveSetCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFIXES"]; !ok {
		panic("Cannot issue request 'ChangeSaveSet' using the uninitialized extension 'XFIXES'. xfixes.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(changeSaveSetRequest(c, Mode, Target, Map, Window), cookie)
	return ChangeSaveSetCookie{cookie}
}

// ChangeSaveSetChecked sends a checked request.
// If an error occurs, it can be retrieved using ChangeSaveSetCookie.Check()
func ChangeSaveSetChecked(c *xgb.Conn, Mode byte, Target byte, Map byte, Window xproto.Window) ChangeSaveSetCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFIXES"]; !ok {
		panic("Cannot issue request 'ChangeSaveSet' using the uninitialized extension 'XFIXES'. xfixes.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(changeSaveSetRequest(c, Mode, Target, Map, Window), cookie)
	return ChangeSaveSetCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook ChangeSaveSetCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for ChangeSaveSet
// changeSaveSetRequest writes a ChangeSaveSet request to a byte slice.
func changeSaveSetRequest(c *xgb.Conn, Mode byte, Target byte, Map byte, Window xproto.Window) []byte {
	size := 12
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["XFIXES"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 1 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	buf[b] = Mode
	b += 1

	buf[b] = Target
	b += 1

	buf[b] = Map
	b += 1

	b += 1 // padding

	xgb.Put32(buf[b:], uint32(Window))
	b += 4

	return buf
}

// CopyRegionCookie is a cookie used only for CopyRegion requests.
type CopyRegionCookie struct {
	*xgb.Cookie
}

// CopyRegion sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func CopyRegion(c *xgb.Conn, Source Region, Destination Region) CopyRegionCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFIXES"]; !ok {
		panic("Cannot issue request 'CopyRegion' using the uninitialized extension 'XFIXES'. xfixes.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(copyRegionRequest(c, Source, Destination), cookie)
	return CopyRegionCookie{cookie}
}

// CopyRegionChecked sends a checked request.
// If an error occurs, it can be retrieved using CopyRegionCookie.Check()
func CopyRegionChecked(c *xgb.Conn, Source Region, Destination Region) CopyRegionCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFIXES"]; !ok {
		panic("Cannot issue request 'CopyRegion' using the uninitialized extension 'XFIXES'. xfixes.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(copyRegionRequest(c, Source, Destination), cookie)
	return CopyRegionCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook CopyRegionCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for CopyRegion
// copyRegionRequest writes a CopyRegion request to a byte slice.
func copyRegionRequest(c *xgb.Conn, Source Region, Destination Region) []byte {
	size := 12
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["XFIXES"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 12 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Source))
	b += 4

	xgb.Put32(buf[b:], uint32(Destination))
	b += 4

	return buf
}

// CreatePointerBarrierCookie is a cookie used only for CreatePointerBarrier requests.
type CreatePointerBarrierCookie struct {
	*xgb.Cookie
}

// CreatePointerBarrier sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func CreatePointerBarrier(c *xgb.Conn, Barrier Barrier, Window xproto.Window, X1 uint16, Y1 uint16, X2 uint16, Y2 uint16, Directions uint32, NumDevices uint16, Devices []uint16) CreatePointerBarrierCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFIXES"]; !ok {
		panic("Cannot issue request 'CreatePointerBarrier' using the uninitialized extension 'XFIXES'. xfixes.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(createPointerBarrierRequest(c, Barrier, Window, X1, Y1, X2, Y2, Directions, NumDevices, Devices), cookie)
	return CreatePointerBarrierCookie{cookie}
}

// CreatePointerBarrierChecked sends a checked request.
// If an error occurs, it can be retrieved using CreatePointerBarrierCookie.Check()
func CreatePointerBarrierChecked(c *xgb.Conn, Barrier Barrier, Window xproto.Window, X1 uint16, Y1 uint16, X2 uint16, Y2 uint16, Directions uint32, NumDevices uint16, Devices []uint16) CreatePointerBarrierCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFIXES"]; !ok {
		panic("Cannot issue request 'CreatePointerBarrier' using the uninitialized extension 'XFIXES'. xfixes.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(createPointerBarrierRequest(c, Barrier, Window, X1, Y1, X2, Y2, Directions, NumDevices, Devices), cookie)
	return CreatePointerBarrierCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook CreatePointerBarrierCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for CreatePointerBarrier
// createPointerBarrierRequest writes a CreatePointerBarrier request to a byte slice.
func createPointerBarrierRequest(c *xgb.Conn, Barrier Barrier, Window xproto.Window, X1 uint16, Y1 uint16, X2 uint16, Y2 uint16, Directions uint32, NumDevices uint16, Devices []uint16) []byte {
	size := xgb.Pad((28 + xgb.Pad((int(NumDevices) * 2))))
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["XFIXES"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 31 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Barrier))
	b += 4

	xgb.Put32(buf[b:], uint32(Window))
	b += 4

	xgb.Put16(buf[b:], X1)
	b += 2

	xgb.Put16(buf[b:], Y1)
	b += 2

	xgb.Put16(buf[b:], X2)
	b += 2

	xgb.Put16(buf[b:], Y2)
	b += 2

	xgb.Put32(buf[b:], Directions)
	b += 4

	b += 2 // padding

	xgb.Put16(buf[b:], NumDevices)
	b += 2

	for i := 0; i < int(NumDevices); i++ {
		xgb.Put16(buf[b:], Devices[i])
		b += 2
	}

	return buf
}

// CreateRegionCookie is a cookie used only for CreateRegion requests.
type CreateRegionCookie struct {
	*xgb.Cookie
}

// CreateRegion sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func CreateRegion(c *xgb.Conn, Region Region, Rectangles []xproto.Rectangle) CreateRegionCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFIXES"]; !ok {
		panic("Cannot issue request 'CreateRegion' using the uninitialized extension 'XFIXES'. xfixes.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(createRegionRequest(c, Region, Rectangles), cookie)
	return CreateRegionCookie{cookie}
}

// CreateRegionChecked sends a checked request.
// If an error occurs, it can be retrieved using CreateRegionCookie.Check()
func CreateRegionChecked(c *xgb.Conn, Region Region, Rectangles []xproto.Rectangle) CreateRegionCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFIXES"]; !ok {
		panic("Cannot issue request 'CreateRegion' using the uninitialized extension 'XFIXES'. xfixes.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(createRegionRequest(c, Region, Rectangles), cookie)
	return CreateRegionCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook CreateRegionCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for CreateRegion
// createRegionRequest writes a CreateRegion request to a byte slice.
func createRegionRequest(c *xgb.Conn, Region Region, Rectangles []xproto.Rectangle) []byte {
	size := xgb.Pad((8 + xgb.Pad((len(Rectangles) * 8))))
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["XFIXES"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 5 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Region))
	b += 4

	b += xproto.RectangleListBytes(buf[b:], Rectangles)

	return buf
}

// CreateRegionFromBitmapCookie is a cookie used only for CreateRegionFromBitmap requests.
type CreateRegionFromBitmapCookie struct {
	*xgb.Cookie
}

// CreateRegionFromBitmap sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func CreateRegionFromBitmap(c *xgb.Conn, Region Region, Bitmap xproto.Pixmap) CreateRegionFromBitmapCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFIXES"]; !ok {
		panic("Cannot issue request 'CreateRegionFromBitmap' using the uninitialized extension 'XFIXES'. xfixes.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(createRegionFromBitmapRequest(c, Region, Bitmap), cookie)
	return CreateRegionFromBitmapCookie{cookie}
}

// CreateRegionFromBitmapChecked sends a checked request.
// If an error occurs, it can be retrieved using CreateRegionFromBitmapCookie.Check()
func CreateRegionFromBitmapChecked(c *xgb.Conn, Region Region, Bitmap xproto.Pixmap) CreateRegionFromBitmapCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFIXES"]; !ok {
		panic("Cannot issue request 'CreateRegionFromBitmap' using the uninitialized extension 'XFIXES'. xfixes.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(createRegionFromBitmapRequest(c, Region, Bitmap), cookie)
	return CreateRegionFromBitmapCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook CreateRegionFromBitmapCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for CreateRegionFromBitmap
// createRegionFromBitmapRequest writes a CreateRegionFromBitmap request to a byte slice.
func createRegionFromBitmapRequest(c *xgb.Conn, Region Region, Bitmap xproto.Pixmap) []byte {
	size := 12
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["XFIXES"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 6 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Region))
	b += 4

	xgb.Put32(buf[b:], uint32(Bitmap))
	b += 4

	return buf
}

// CreateRegionFromGCCookie is a cookie used only for CreateRegionFromGC requests.
type CreateRegionFromGCCookie struct {
	*xgb.Cookie
}

// CreateRegionFromGC sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func CreateRegionFromGC(c *xgb.Conn, Region Region, Gc xproto.Gcontext) CreateRegionFromGCCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFIXES"]; !ok {
		panic("Cannot issue request 'CreateRegionFromGC' using the uninitialized extension 'XFIXES'. xfixes.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(createRegionFromGCRequest(c, Region, Gc), cookie)
	return CreateRegionFromGCCookie{cookie}
}

// CreateRegionFromGCChecked sends a checked request.
// If an error occurs, it can be retrieved using CreateRegionFromGCCookie.Check()
func CreateRegionFromGCChecked(c *xgb.Conn, Region Region, Gc xproto.Gcontext) CreateRegionFromGCCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFIXES"]; !ok {
		panic("Cannot issue request 'CreateRegionFromGC' using the uninitialized extension 'XFIXES'. xfixes.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(createRegionFromGCRequest(c, Region, Gc), cookie)
	return CreateRegionFromGCCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook CreateRegionFromGCCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for CreateRegionFromGC
// createRegionFromGCRequest writes a CreateRegionFromGC request to a byte slice.
func createRegionFromGCRequest(c *xgb.Conn, Region Region, Gc xproto.Gcontext) []byte {
	size := 12
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["XFIXES"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 8 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Region))
	b += 4

	xgb.Put32(buf[b:], uint32(Gc))
	b += 4

	return buf
}

// CreateRegionFromPictureCookie is a cookie used only for CreateRegionFromPicture requests.
type CreateRegionFromPictureCookie struct {
	*xgb.Cookie
}

// CreateRegionFromPicture sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func CreateRegionFromPicture(c *xgb.Conn, Region Region, Picture render.Picture) CreateRegionFromPictureCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFIXES"]; !ok {
		panic("Cannot issue request 'CreateRegionFromPicture' using the uninitialized extension 'XFIXES'. xfixes.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(createRegionFromPictureRequest(c, Region, Picture), cookie)
	return CreateRegionFromPictureCookie{cookie}
}

// CreateRegionFromPictureChecked sends a checked request.
// If an error occurs, it can be retrieved using CreateRegionFromPictureCookie.Check()
func CreateRegionFromPictureChecked(c *xgb.Conn, Region Region, Picture render.Picture) CreateRegionFromPictureCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFIXES"]; !ok {
		panic("Cannot issue request 'CreateRegionFromPicture' using the uninitialized extension 'XFIXES'. xfixes.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(createRegionFromPictureRequest(c, Region, Picture), cookie)
	return CreateRegionFromPictureCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook CreateRegionFromPictureCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for CreateRegionFromPicture
// createRegionFromPictureRequest writes a CreateRegionFromPicture request to a byte slice.
func createRegionFromPictureRequest(c *xgb.Conn, Region Region, Picture render.Picture) []byte {
	size := 12
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["XFIXES"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 9 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Region))
	b += 4

	xgb.Put32(buf[b:], uint32(Picture))
	b += 4

	return buf
}

// CreateRegionFromWindowCookie is a cookie used only for CreateRegionFromWindow requests.
type CreateRegionFromWindowCookie struct {
	*xgb.Cookie
}

// CreateRegionFromWindow sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func CreateRegionFromWindow(c *xgb.Conn, Region Region, Window xproto.Window, Kind shape.Kind) CreateRegionFromWindowCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFIXES"]; !ok {
		panic("Cannot issue request 'CreateRegionFromWindow' using the uninitialized extension 'XFIXES'. xfixes.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(createRegionFromWindowRequest(c, Region, Window, Kind), cookie)
	return CreateRegionFromWindowCookie{cookie}
}

// CreateRegionFromWindowChecked sends a checked request.
// If an error occurs, it can be retrieved using CreateRegionFromWindowCookie.Check()
func CreateRegionFromWindowChecked(c *xgb.Conn, Region Region, Window xproto.Window, Kind shape.Kind) CreateRegionFromWindowCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFIXES"]; !ok {
		panic("Cannot issue request 'CreateRegionFromWindow' using the uninitialized extension 'XFIXES'. xfixes.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(createRegionFromWindowRequest(c, Region, Window, Kind), cookie)
	return CreateRegionFromWindowCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook CreateRegionFromWindowCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for CreateRegionFromWindow
// createRegionFromWindowRequest writes a CreateRegionFromWindow request to a byte slice.
func createRegionFromWindowRequest(c *xgb.Conn, Region Region, Window xproto.Window, Kind shape.Kind) []byte {
	size := 16
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["XFIXES"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 7 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Region))
	b += 4

	xgb.Put32(buf[b:], uint32(Window))
	b += 4

	buf[b] = byte(Kind)
	b += 1

	b += 3 // padding

	return buf
}

// DeletePointerBarrierCookie is a cookie used only for DeletePointerBarrier requests.
type DeletePointerBarrierCookie struct {
	*xgb.Cookie
}

// DeletePointerBarrier sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func DeletePointerBarrier(c *xgb.Conn, Barrier Barrier) DeletePointerBarrierCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFIXES"]; !ok {
		panic("Cannot issue request 'DeletePointerBarrier' using the uninitialized extension 'XFIXES'. xfixes.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(deletePointerBarrierRequest(c, Barrier), cookie)
	return DeletePointerBarrierCookie{cookie}
}

// DeletePointerBarrierChecked sends a checked request.
// If an error occurs, it can be retrieved using DeletePointerBarrierCookie.Check()
func DeletePointerBarrierChecked(c *xgb.Conn, Barrier Barrier) DeletePointerBarrierCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFIXES"]; !ok {
		panic("Cannot issue request 'DeletePointerBarrier' using the uninitialized extension 'XFIXES'. xfixes.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(deletePointerBarrierRequest(c, Barrier), cookie)
	return DeletePointerBarrierCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook DeletePointerBarrierCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for DeletePointerBarrier
// deletePointerBarrierRequest writes a DeletePointerBarrier request to a byte slice.
func deletePointerBarrierRequest(c *xgb.Conn, Barrier Barrier) []byte {
	size := 8
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["XFIXES"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 32 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Barrier))
	b += 4

	return buf
}

// DestroyRegionCookie is a cookie used only for DestroyRegion requests.
type DestroyRegionCookie struct {
	*xgb.Cookie
}

// DestroyRegion sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func DestroyRegion(c *xgb.Conn, Region Region) DestroyRegionCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFIXES"]; !ok {
		panic("Cannot issue request 'DestroyRegion' using the uninitialized extension 'XFIXES'. xfixes.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(destroyRegionRequest(c, Region), cookie)
	return DestroyRegionCookie{cookie}
}

// DestroyRegionChecked sends a checked request.
// If an error occurs, it can be retrieved using DestroyRegionCookie.Check()
func DestroyRegionChecked(c *xgb.Conn, Region Region) DestroyRegionCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFIXES"]; !ok {
		panic("Cannot issue request 'DestroyRegion' using the uninitialized extension 'XFIXES'. xfixes.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(destroyRegionRequest(c, Region), cookie)
	return DestroyRegionCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook DestroyRegionCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for DestroyRegion
// destroyRegionRequest writes a DestroyRegion request to a byte slice.
func destroyRegionRequest(c *xgb.Conn, Region Region) []byte {
	size := 8
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["XFIXES"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 10 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Region))
	b += 4

	return buf
}

// ExpandRegionCookie is a cookie used only for ExpandRegion requests.
type ExpandRegionCookie struct {
	*xgb.Cookie
}

// ExpandRegion sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func ExpandRegion(c *xgb.Conn, Source Region, Destination Region, Left uint16, Right uint16, Top uint16, Bottom uint16) ExpandRegionCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFIXES"]; !ok {
		panic("Cannot issue request 'ExpandRegion' using the uninitialized extension 'XFIXES'. xfixes.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(expandRegionRequest(c, Source, Destination, Left, Right, Top, Bottom), cookie)
	return ExpandRegionCookie{cookie}
}

// ExpandRegionChecked sends a checked request.
// If an error occurs, it can be retrieved using ExpandRegionCookie.Check()
func ExpandRegionChecked(c *xgb.Conn, Source Region, Destination Region, Left uint16, Right uint16, Top uint16, Bottom uint16) ExpandRegionCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFIXES"]; !ok {
		panic("Cannot issue request 'ExpandRegion' using the uninitialized extension 'XFIXES'. xfixes.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(expandRegionRequest(c, Source, Destination, Left, Right, Top, Bottom), cookie)
	return ExpandRegionCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook ExpandRegionCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for ExpandRegion
// expandRegionRequest writes a ExpandRegion request to a byte slice.
func expandRegionRequest(c *xgb.Conn, Source Region, Destination Region, Left uint16, Right uint16, Top uint16, Bottom uint16) []byte {
	size := 20
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["XFIXES"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 28 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Source))
	b += 4

	xgb.Put32(buf[b:], uint32(Destination))
	b += 4

	xgb.Put16(buf[b:], Left)
	b += 2

	xgb.Put16(buf[b:], Right)
	b += 2

	xgb.Put16(buf[b:], Top)
	b += 2

	xgb.Put16(buf[b:], Bottom)
	b += 2

	return buf
}

// FetchRegionCookie is a cookie used only for FetchRegion requests.
type FetchRegionCookie struct {
	*xgb.Cookie
}

// FetchRegion sends a checked request.
// If an error occurs, it will be returned with the reply by calling FetchRegionCookie.Reply()
func FetchRegion(c *xgb.Conn, Region Region) FetchRegionCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFIXES"]; !ok {
		panic("Cannot issue request 'FetchRegion' using the uninitialized extension 'XFIXES'. xfixes.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(fetchRegionRequest(c, Region), cookie)
	return FetchRegionCookie{cookie}
}

// FetchRegionUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func FetchRegionUnchecked(c *xgb.Conn, Region Region) FetchRegionCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFIXES"]; !ok {
		panic("Cannot issue request 'FetchRegion' using the uninitialized extension 'XFIXES'. xfixes.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(fetchRegionRequest(c, Region), cookie)
	return FetchRegionCookie{cookie}
}

// FetchRegionReply represents the data returned from a FetchRegion request.
type FetchRegionReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	Extents xproto.Rectangle
	// padding: 16 bytes
	Rectangles []xproto.Rectangle // size: xgb.Pad(((int(Length) / 2) * 8))
}

// Reply blocks and returns the reply data for a FetchRegion request.
func (cook FetchRegionCookie) Reply() (*FetchRegionReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return fetchRegionReply(buf), nil
}

// fetchRegionReply reads a byte slice into a FetchRegionReply value.
func fetchRegionReply(buf []byte) *FetchRegionReply {
	v := new(FetchRegionReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	v.Extents = xproto.Rectangle{}
	b += xproto.RectangleRead(buf[b:], &v.Extents)

	b += 16 // padding

	v.Rectangles = make([]xproto.Rectangle, (int(v.Length) / 2))
	b += xproto.RectangleReadList(buf[b:], v.Rectangles)

	return v
}

// Write request to wire for FetchRegion
// fetchRegionRequest writes a FetchRegion request to a byte slice.
func fetchRegionRequest(c *xgb.Conn, Region Region) []byte {
	size := 8
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["XFIXES"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 19 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Region))
	b += 4

	return buf
}

// GetClientDisconnectModeCookie is a cookie used only for GetClientDisconnectMode requests.
type GetClientDisconnectModeCookie struct {
	*xgb.Cookie
}

// GetClientDisconnectMode sends a checked request.
// If an error occurs, it will be returned with the reply by calling GetClientDisconnectModeCookie.Reply()
func GetClientDisconnectMode(c *xgb.Conn) GetClientDisconnectModeCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFIXES"]; !ok {
		panic("Cannot issue request 'GetClientDisconnectMode' using the uninitialized extension 'XFIXES'. xfixes.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(getClientDisconnectModeRequest(c), cookie)
	return GetClientDisconnectModeCookie{cookie}
}

// GetClientDisconnectModeUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func GetClientDisconnectModeUnchecked(c *xgb.Conn) GetClientDisconnectModeCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFIXES"]; !ok {
		panic("Cannot issue request 'GetClientDisconnectMode' using the uninitialized extension 'XFIXES'. xfixes.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(getClientDisconnectModeRequest(c), cookie)
	return GetClientDisconnectModeCookie{cookie}
}

// GetClientDisconnectModeReply represents the data returned from a GetClientDisconnectMode request.
type GetClientDisconnectModeReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	DisconnectMode uint32
	// padding: 20 bytes
}

// Reply blocks and returns the reply data for a GetClientDisconnectMode request.
func (cook GetClientDisconnectModeCookie) Reply() (*GetClientDisconnectModeReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return getClientDisconnectModeReply(buf), nil
}

// getClientDisconnectModeReply reads a byte slice into a GetClientDisconnectModeReply value.
func getClientDisconnectModeReply(buf []byte) *GetClientDisconnectModeReply {
	v := new(GetClientDisconnectModeReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	v.DisconnectMode = xgb.Get32(buf[b:])
	b += 4

	b += 20 // padding

	return v
}

// Write request to wire for GetClientDisconnectMode
// getClientDisconnectModeRequest writes a GetClientDisconnectMode request to a byte slice.
func getClientDisconnectModeRequest(c *xgb.Conn) []byte {
	size := 4
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["XFIXES"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 34 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	return buf
}

// GetCursorImageCookie is a cookie used only for GetCursorImage requests.
type GetCursorImageCookie struct {
	*xgb.Cookie
}

// GetCursorImage sends a checked request.
// If an error occurs, it will be returned with the reply by calling GetCursorImageCookie.Reply()
func GetCursorImage(c *xgb.Conn) GetCursorImageCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFIXES"]; !ok {
		panic("Cannot issue request 'GetCursorImage' using the uninitialized extension 'XFIXES'. xfixes.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(getCursorImageRequest(c), cookie)
	return GetCursorImageCookie{cookie}
}

// GetCursorImageUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func GetCursorImageUnchecked(c *xgb.Conn) GetCursorImageCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFIXES"]; !ok {
		panic("Cannot issue request 'GetCursorImage' using the uninitialized extension 'XFIXES'. xfixes.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(getCursorImageRequest(c), cookie)
	return GetCursorImageCookie{cookie}
}

// GetCursorImageReply represents the data returned from a GetCursorImage request.
type GetCursorImageReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	X            int16
	Y            int16
	Width        uint16
	Height       uint16
	Xhot         uint16
	Yhot         uint16
	CursorSerial uint32
	// padding: 8 bytes
	CursorImage []uint32 // size: xgb.Pad(((int(Width) * int(Height)) * 4))
}

// Reply blocks and returns the reply data for a GetCursorImage request.
func (cook GetCursorImageCookie) Reply() (*GetCursorImageReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return getCursorImageReply(buf), nil
}

// getCursorImageReply reads a byte slice into a GetCursorImageReply value.
func getCursorImageReply(buf []byte) *GetCursorImageReply {
	v := new(GetCursorImageReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	v.X = int16(xgb.Get16(buf[b:]))
	b += 2

	v.Y = int16(xgb.Get16(buf[b:]))
	b += 2

	v.Width = xgb.Get16(buf[b:])
	b += 2

	v.Height = xgb.Get16(buf[b:])
	b += 2

	v.Xhot = xgb.Get16(buf[b:])
	b += 2

	v.Yhot = xgb.Get16(buf[b:])
	b += 2

	v.CursorSerial = xgb.Get32(buf[b:])
	b += 4

	b += 8 // padding

	v.CursorImage = make([]uint32, (int(v.Width) * int(v.Height)))
	for i := 0; i < int((int(v.Width) * int(v.Height))); i++ {
		v.CursorImage[i] = xgb.Get32(buf[b:])
		b += 4
	}

	return v
}

// Write request to wire for GetCursorImage
// getCursorImageRequest writes a GetCursorImage request to a byte slice.
func getCursorImageRequest(c *xgb.Conn) []byte {
	size := 4
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["XFIXES"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 4 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	return buf
}

// GetCursorImageAndNameCookie is a cookie used only for GetCursorImageAndName requests.
type GetCursorImageAndNameCookie struct {
	*xgb.Cookie
}

// GetCursorImageAndName sends a checked request.
// If an error occurs, it will be returned with the reply by calling GetCursorImageAndNameCookie.Reply()
func GetCursorImageAndName(c *xgb.Conn) GetCursorImageAndNameCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFIXES"]; !ok {
		panic("Cannot issue request 'GetCursorImageAndName' using the uninitialized extension 'XFIXES'. xfixes.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(getCursorImageAndNameRequest(c), cookie)
	return GetCursorImageAndNameCookie{cookie}
}

// GetCursorImageAndNameUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func GetCursorImageAndNameUnchecked(c *xgb.Conn) GetCursorImageAndNameCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFIXES"]; !ok {
		panic("Cannot issue request 'GetCursorImageAndName' using the uninitialized extension 'XFIXES'. xfixes.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(getCursorImageAndNameRequest(c), cookie)
	return GetCursorImageAndNameCookie{cookie}
}

// GetCursorImageAndNameReply represents the data returned from a GetCursorImageAndName request.
type GetCursorImageAndNameReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	X            int16
	Y            int16
	Width        uint16
	Height       uint16
	Xhot         uint16
	Yhot         uint16
	CursorSerial uint32
	CursorAtom   xproto.Atom
	Nbytes       uint16
	// padding: 2 bytes
	CursorImage []uint32 // size: xgb.Pad(((int(Width) * int(Height)) * 4))
	Name        string   // size: xgb.Pad((int(Nbytes) * 1))
}

// Reply blocks and returns the reply data for a GetCursorImageAndName request.
func (cook GetCursorImageAndNameCookie) Reply() (*GetCursorImageAndNameReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return getCursorImageAndNameReply(buf), nil
}

// getCursorImageAndNameReply reads a byte slice into a GetCursorImageAndNameReply value.
func getCursorImageAndNameReply(buf []byte) *GetCursorImageAndNameReply {
	v := new(GetCursorImageAndNameReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	v.X = int16(xgb.Get16(buf[b:]))
	b += 2

	v.Y = int16(xgb.Get16(buf[b:]))
	b += 2

	v.Width = xgb.Get16(buf[b:])
	b += 2

	v.Height = xgb.Get16(buf[b:])
	b += 2

	v.Xhot = xgb.Get16(buf[b:])
	b += 2

	v.Yhot = xgb.Get16(buf[b:])
	b += 2

	v.CursorSerial = xgb.Get32(buf[b:])
	b += 4

	v.CursorAtom = xproto.Atom(xgb.Get32(buf[b:]))
	b += 4

	v.Nbytes = xgb.Get16(buf[b:])
	b += 2

	b += 2 // padding

	v.CursorImage = make([]uint32, (int(v.Width) * int(v.Height)))
	for i := 0; i < int((int(v.Width) * int(v.Height))); i++ {
		v.CursorImage[i] = xgb.Get32(buf[b:])
		b += 4
	}

	{
		byteString := make([]byte, v.Nbytes)
		copy(byteString[:v.Nbytes], buf[b:])
		v.Name = string(byteString)
		b += int(v.Nbytes)
	}

	return v
}

// Write request to wire for GetCursorImageAndName
// getCursorImageAndNameRequest writes a GetCursorImageAndName request to a byte slice.
func getCursorImageAndNameRequest(c *xgb.Conn) []byte {
	size := 4
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["XFIXES"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 25 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	return buf
}

// GetCursorNameCookie is a cookie used only for GetCursorName requests.
type GetCursorNameCookie struct {
	*xgb.Cookie
}

// GetCursorName sends a checked request.
// If an error occurs, it will be returned with the reply by calling GetCursorNameCookie.Reply()
func GetCursorName(c *xgb.Conn, Cursor xproto.Cursor) GetCursorNameCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFIXES"]; !ok {
		panic("Cannot issue request 'GetCursorName' using the uninitialized extension 'XFIXES'. xfixes.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(getCursorNameRequest(c, Cursor), cookie)
	return GetCursorNameCookie{cookie}
}

// GetCursorNameUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func GetCursorNameUnchecked(c *xgb.Conn, Cursor xproto.Cursor) GetCursorNameCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFIXES"]; !ok {
		panic("Cannot issue request 'GetCursorName' using the uninitialized extension 'XFIXES'. xfixes.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(getCursorNameRequest(c, Cursor), cookie)
	return GetCursorNameCookie{cookie}
}

// GetCursorNameReply represents the data returned from a GetCursorName request.
type GetCursorNameReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	Atom   xproto.Atom
	Nbytes uint16
	// padding: 18 bytes
	Name string // size: xgb.Pad((int(Nbytes) * 1))
}

// Reply blocks and returns the reply data for a GetCursorName request.
func (cook GetCursorNameCookie) Reply() (*GetCursorNameReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return getCursorNameReply(buf), nil
}

// getCursorNameReply reads a byte slice into a GetCursorNameReply value.
func getCursorNameReply(buf []byte) *GetCursorNameReply {
	v := new(GetCursorNameReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	v.Atom = xproto.Atom(xgb.Get32(buf[b:]))
	b += 4

	v.Nbytes = xgb.Get16(buf[b:])
	b += 2

	b += 18 // padding

	{
		byteString := make([]byte, v.Nbytes)
		copy(byteString[:v.Nbytes], buf[b:])
		v.Name = string(byteString)
		b += int(v.Nbytes)
	}

	return v
}

// Write request to wire for GetCursorName
// getCursorNameRequest writes a GetCursorName request to a byte slice.
func getCursorNameRequest(c *xgb.Conn, Cursor xproto.Cursor) []byte {
	size := 8
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["XFIXES"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 24 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Cursor))
	b += 4

	return buf
}

// HideCursorCookie is a cookie used only for HideCursor requests.
type HideCursorCookie struct {
	*xgb.Cookie
}

// HideCursor sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func HideCursor(c *xgb.Conn, Window xproto.Window) HideCursorCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFIXES"]; !ok {
		panic("Cannot issue request 'HideCursor' using the uninitialized extension 'XFIXES'. xfixes.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(hideCursorRequest(c, Window), cookie)
	return HideCursorCookie{cookie}
}

// HideCursorChecked sends a checked request.
// If an error occurs, it can be retrieved using HideCursorCookie.Check()
func HideCursorChecked(c *xgb.Conn, Window xproto.Window) HideCursorCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFIXES"]; !ok {
		panic("Cannot issue request 'HideCursor' using the uninitialized extension 'XFIXES'. xfixes.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(hideCursorRequest(c, Window), cookie)
	return HideCursorCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook HideCursorCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for HideCursor
// hideCursorRequest writes a HideCursor request to a byte slice.
func hideCursorRequest(c *xgb.Conn, Window xproto.Window) []byte {
	size := 8
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["XFIXES"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 29 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Window))
	b += 4

	return buf
}

// IntersectRegionCookie is a cookie used only for IntersectRegion requests.
type IntersectRegionCookie struct {
	*xgb.Cookie
}

// IntersectRegion sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func IntersectRegion(c *xgb.Conn, Source1 Region, Source2 Region, Destination Region) IntersectRegionCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFIXES"]; !ok {
		panic("Cannot issue request 'IntersectRegion' using the uninitialized extension 'XFIXES'. xfixes.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(intersectRegionRequest(c, Source1, Source2, Destination), cookie)
	return IntersectRegionCookie{cookie}
}

// IntersectRegionChecked sends a checked request.
// If an error occurs, it can be retrieved using IntersectRegionCookie.Check()
func IntersectRegionChecked(c *xgb.Conn, Source1 Region, Source2 Region, Destination Region) IntersectRegionCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFIXES"]; !ok {
		panic("Cannot issue request 'IntersectRegion' using the uninitialized extension 'XFIXES'. xfixes.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(intersectRegionRequest(c, Source1, Source2, Destination), cookie)
	return IntersectRegionCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook IntersectRegionCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for IntersectRegion
// intersectRegionRequest writes a IntersectRegion request to a byte slice.
func intersectRegionRequest(c *xgb.Conn, Source1 Region, Source2 Region, Destination Region) []byte {
	size := 16
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["XFIXES"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 14 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Source1))
	b += 4

	xgb.Put32(buf[b:], uint32(Source2))
	b += 4

	xgb.Put32(buf[b:], uint32(Destination))
	b += 4

	return buf
}

// InvertRegionCookie is a cookie used only for InvertRegion requests.
type InvertRegionCookie struct {
	*xgb.Cookie
}

// InvertRegion sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func InvertRegion(c *xgb.Conn, Source Region, Bounds xproto.Rectangle, Destination Region) InvertRegionCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFIXES"]; !ok {
		panic("Cannot issue request 'InvertRegion' using the uninitialized extension 'XFIXES'. xfixes.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(invertRegionRequest(c, Source, Bounds, Destination), cookie)
	return InvertRegionCookie{cookie}
}

// InvertRegionChecked sends a checked request.
// If an error occurs, it can be retrieved using InvertRegionCookie.Check()
func InvertRegionChecked(c *xgb.Conn, Source Region, Bounds xproto.Rectangle, Destination Region) InvertRegionCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFIXES"]; !ok {
		panic("Cannot issue request 'InvertRegion' using the uninitialized extension 'XFIXES'. xfixes.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(invertRegionRequest(c, Source, Bounds, Destination), cookie)
	return InvertRegionCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook InvertRegionCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for InvertRegion
// invertRegionRequest writes a InvertRegion request to a byte slice.
func invertRegionRequest(c *xgb.Conn, Source Region, Bounds xproto.Rectangle, Destination Region) []byte {
	size := 20
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["XFIXES"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 16 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Source))
	b += 4

	{
		structBytes := Bounds.Bytes()
		copy(buf[b:], structBytes)
		b += len(structBytes)
	}

	xgb.Put32(buf[b:], uint32(Destination))
	b += 4

	return buf
}

// QueryVersionCookie is a cookie used only for QueryVersion requests.
type QueryVersionCookie struct {
	*xgb.Cookie
}

// QueryVersion sends a checked request.
// If an error occurs, it will be returned with the reply by calling QueryVersionCookie.Reply()
func QueryVersion(c *xgb.Conn, ClientMajorVersion uint32, ClientMinorVersion uint32) QueryVersionCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFIXES"]; !ok {
		panic("Cannot issue request 'QueryVersion' using the uninitialized extension 'XFIXES'. xfixes.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(queryVersionRequest(c, ClientMajorVersion, ClientMinorVersion), cookie)
	return QueryVersionCookie{cookie}
}

// QueryVersionUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func QueryVersionUnchecked(c *xgb.Conn, ClientMajorVersion uint32, ClientMinorVersion uint32) QueryVersionCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFIXES"]; !ok {
		panic("Cannot issue request 'QueryVersion' using the uninitialized extension 'XFIXES'. xfixes.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(queryVersionRequest(c, ClientMajorVersion, ClientMinorVersion), cookie)
	return QueryVersionCookie{cookie}
}

// QueryVersionReply represents the data returned from a QueryVersion request.
type QueryVersionReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	MajorVersion uint32
	MinorVersion uint32
	// padding: 16 bytes
}

// Reply blocks and returns the reply data for a QueryVersion request.
func (cook QueryVersionCookie) Reply() (*QueryVersionReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return queryVersionReply(buf), nil
}

// queryVersionReply reads a byte slice into a QueryVersionReply value.
func queryVersionReply(buf []byte) *QueryVersionReply {
	v := new(QueryVersionReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	v.MajorVersion = xgb.Get32(buf[b:])
	b += 4

	v.MinorVersion = xgb.Get32(buf[b:])
	b += 4

	b += 16 // padding

	return v
}

// Write request to wire for QueryVersion
// queryVersionRequest writes a QueryVersion request to a byte slice.
func queryVersionRequest(c *xgb.Conn, ClientMajorVersion uint32, ClientMinorVersion uint32) []byte {
	size := 12
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["XFIXES"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 0 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], ClientMajorVersion)
	b += 4

	xgb.Put32(buf[b:], ClientMinorVersion)
	b += 4

	return buf
}

// RegionExtentsCookie is a cookie used only for RegionExtents requests.
type RegionExtentsCookie struct {
	*xgb.Cookie
}

// RegionExtents sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func RegionExtents(c *xgb.Conn, Source Region, Destination Region) RegionExtentsCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFIXES"]; !ok {
		panic("Cannot issue request 'RegionExtents' using the uninitialized extension 'XFIXES'. xfixes.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(regionExtentsRequest(c, Source, Destination), cookie)
	return RegionExtentsCookie{cookie}
}

// RegionExtentsChecked sends a checked request.
// If an error occurs, it can be retrieved using RegionExtentsCookie.Check()
func RegionExtentsChecked(c *xgb.Conn, Source Region, Destination Region) RegionExtentsCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFIXES"]; !ok {
		panic("Cannot issue request 'RegionExtents' using the uninitialized extension 'XFIXES'. xfixes.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(regionExtentsRequest(c, Source, Destination), cookie)
	return RegionExtentsCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook RegionExtentsCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for RegionExtents
// regionExtentsRequest writes a RegionExtents request to a byte slice.
func regionExtentsRequest(c *xgb.Conn, Source Region, Destination Region) []byte {
	size := 12
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["XFIXES"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 18 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Source))
	b += 4

	xgb.Put32(buf[b:], uint32(Destination))
	b += 4

	return buf
}

// SelectCursorInputCookie is a cookie used only for SelectCursorInput requests.
type SelectCursorInputCookie struct {
	*xgb.Cookie
}

// SelectCursorInput sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func SelectCursorInput(c *xgb.Conn, Window xproto.Window, EventMask uint32) SelectCursorInputCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFIXES"]; !ok {
		panic("Cannot issue request 'SelectCursorInput' using the uninitialized extension 'XFIXES'. xfixes.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(selectCursorInputRequest(c, Window, EventMask), cookie)
	return SelectCursorInputCookie{cookie}
}

// SelectCursorInputChecked sends a checked request.
// If an error occurs, it can be retrieved using SelectCursorInputCookie.Check()
func SelectCursorInputChecked(c *xgb.Conn, Window xproto.Window, EventMask uint32) SelectCursorInputCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFIXES"]; !ok {
		panic("Cannot issue request 'SelectCursorInput' using the uninitialized extension 'XFIXES'. xfixes.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(selectCursorInputRequest(c, Window, EventMask), cookie)
	return SelectCursorInputCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook SelectCursorInputCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for SelectCursorInput
// selectCursorInputRequest writes a SelectCursorInput request to a byte slice.
func selectCursorInputRequest(c *xgb.Conn, Window xproto.Window, EventMask uint32) []byte {
	size := 12
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["XFIXES"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 3 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Window))
	b += 4

	xgb.Put32(buf[b:], EventMask)
	b += 4

	return buf
}

// SelectSelectionInputCookie is a cookie used only for SelectSelectionInput requests.
type SelectSelectionInputCookie struct {
	*xgb.Cookie
}

// SelectSelectionInput sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func SelectSelectionInput(c *xgb.Conn, Window xproto.Window, Selection xproto.Atom, EventMask uint32) SelectSelectionInputCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFIXES"]; !ok {
		panic("Cannot issue request 'SelectSelectionInput' using the uninitialized extension 'XFIXES'. xfixes.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(selectSelectionInputRequest(c, Window, Selection, EventMask), cookie)
	return SelectSelectionInputCookie{cookie}
}

// SelectSelectionInputChecked sends a checked request.
// If an error occurs, it can be retrieved using SelectSelectionInputCookie.Check()
func SelectSelectionInputChecked(c *xgb.Conn, Window xproto.Window, Selection xproto.Atom, EventMask uint32) SelectSelectionInputCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFIXES"]; !ok {
		panic("Cannot issue request 'SelectSelectionInput' using the uninitialized extension 'XFIXES'. xfixes.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(selectSelectionInputRequest(c, Window, Selection, EventMask), cookie)
	return SelectSelectionInputCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook SelectSelectionInputCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for SelectSelectionInput
// selectSelectionInputRequest writes a SelectSelectionInput request to a byte slice.
func selectSelectionInputRequest(c *xgb.Conn, Window xproto.Window, Selection xproto.Atom, EventMask uint32) []byte {
	size := 16
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["XFIXES"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 2 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Window))
	b += 4

	xgb.Put32(buf[b:], uint32(Selection))
	b += 4

	xgb.Put32(buf[b:], EventMask)
	b += 4

	return buf
}

// SetClientDisconnectModeCookie is a cookie used only for SetClientDisconnectMode requests.
type SetClientDisconnectModeCookie struct {
	*xgb.Cookie
}

// SetClientDisconnectMode sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func SetClientDisconnectMode(c *xgb.Conn, DisconnectMode uint32) SetClientDisconnectModeCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFIXES"]; !ok {
		panic("Cannot issue request 'SetClientDisconnectMode' using the uninitialized extension 'XFIXES'. xfixes.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(setClientDisconnectModeRequest(c, DisconnectMode), cookie)
	return SetClientDisconnectModeCookie{cookie}
}

// SetClientDisconnectModeChecked sends a checked request.
// If an error occurs, it can be retrieved using SetClientDisconnectModeCookie.Check()
func SetClientDisconnectModeChecked(c *xgb.Conn, DisconnectMode uint32) SetClientDisconnectModeCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFIXES"]; !ok {
		panic("Cannot issue request 'SetClientDisconnectMode' using the uninitialized extension 'XFIXES'. xfixes.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(setClientDisconnectModeRequest(c, DisconnectMode), cookie)
	return SetClientDisconnectModeCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook SetClientDisconnectModeCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for SetClientDisconnectMode
// setClientDisconnectModeRequest writes a SetClientDisconnectMode request to a byte slice.
func setClientDisconnectModeRequest(c *xgb.Conn, DisconnectMode uint32) []byte {
	size := 8
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["XFIXES"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 33 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], DisconnectMode)
	b += 4

	return buf
}

// SetCursorNameCookie is a cookie used only for SetCursorName requests.
type SetCursorNameCookie struct {
	*xgb.Cookie
}

// SetCursorName sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func SetCursorName(c *xgb.Conn, Cursor xproto.Cursor, Nbytes uint16, Name string) SetCursorNameCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFIXES"]; !ok {
		panic("Cannot issue request 'SetCursorName' using the uninitialized extension 'XFIXES'. xfixes.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(setCursorNameRequest(c, Cursor, Nbytes, Name), cookie)
	return SetCursorNameCookie{cookie}
}

// SetCursorNameChecked sends a checked request.
// If an error occurs, it can be retrieved using SetCursorNameCookie.Check()
func SetCursorNameChecked(c *xgb.Conn, Cursor xproto.Cursor, Nbytes uint16, Name string) SetCursorNameCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFIXES"]; !ok {
		panic("Cannot issue request 'SetCursorName' using the uninitialized extension 'XFIXES'. xfixes.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(setCursorNameRequest(c, Cursor, Nbytes, Name), cookie)
	return SetCursorNameCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook SetCursorNameCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for SetCursorName
// setCursorNameRequest writes a SetCursorName request to a byte slice.
func setCursorNameRequest(c *xgb.Conn, Cursor xproto.Cursor, Nbytes uint16, Name string) []byte {
	size := xgb.Pad((12 + xgb.Pad((int(Nbytes) * 1))))
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["XFIXES"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 23 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Cursor))
	b += 4

	xgb.Put16(buf[b:], Nbytes)
	b += 2

	b += 2 // padding

	copy(buf[b:], Name[:Nbytes])
	b += int(Nbytes)

	return buf
}

// SetGCClipRegionCookie is a cookie used only for SetGCClipRegion requests.
type SetGCClipRegionCookie struct {
	*xgb.Cookie
}

// SetGCClipRegion sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func SetGCClipRegion(c *xgb.Conn, Gc xproto.Gcontext, Region Region, XOrigin int16, YOrigin int16) SetGCClipRegionCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFIXES"]; !ok {
		panic("Cannot issue request 'SetGCClipRegion' using the uninitialized extension 'XFIXES'. xfixes.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(setGCClipRegionRequest(c, Gc, Region, XOrigin, YOrigin), cookie)
	return SetGCClipRegionCookie{cookie}
}

// SetGCClipRegionChecked sends a checked request.
// If an error occurs, it can be retrieved using SetGCClipRegionCookie.Check()
func SetGCClipRegionChecked(c *xgb.Conn, Gc xproto.Gcontext, Region Region, XOrigin int16, YOrigin int16) SetGCClipRegionCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFIXES"]; !ok {
		panic("Cannot issue request 'SetGCClipRegion' using the uninitialized extension 'XFIXES'. xfixes.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(setGCClipRegionRequest(c, Gc, Region, XOrigin, YOrigin), cookie)
	return SetGCClipRegionCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook SetGCClipRegionCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for SetGCClipRegion
// setGCClipRegionRequest writes a SetGCClipRegion request to a byte slice.
func setGCClipRegionRequest(c *xgb.Conn, Gc xproto.Gcontext, Region Region, XOrigin int16, YOrigin int16) []byte {
	size := 16
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["XFIXES"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 20 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Gc))
	b += 4

	xgb.Put32(buf[b:], uint32(Region))
	b += 4

	xgb.Put16(buf[b:], uint16(XOrigin))
	b += 2

	xgb.Put16(buf[b:], uint16(YOrigin))
	b += 2

	return buf
}

// SetPictureClipRegionCookie is a cookie used only for SetPictureClipRegion requests.
type SetPictureClipRegionCookie struct {
	*xgb.Cookie
}

// SetPictureClipRegion sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func SetPictureClipRegion(c *xgb.Conn, Picture render.Picture, Region Region, XOrigin int16, YOrigin int16) SetPictureClipRegionCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFIXES"]; !ok {
		panic("Cannot issue request 'SetPictureClipRegion' using the uninitialized extension 'XFIXES'. xfixes.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(setPictureClipRegionRequest(c, Picture, Region, XOrigin, YOrigin), cookie)
	return SetPictureClipRegionCookie{cookie}
}

// SetPictureClipRegionChecked sends a checked request.
// If an error occurs, it can be retrieved using SetPictureClipRegionCookie.Check()
func SetPictureClipRegionChecked(c *xgb.Conn, Picture render.Picture, Region Region, XOrigin int16, YOrigin int16) SetPictureClipRegionCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFIXES"]; !ok {
		panic("Cannot issue request 'SetPictureClipRegion' using the uninitialized extension 'XFIXES'. xfixes.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(setPictureClipRegionRequest(c, Picture, Region, XOrigin, YOrigin), cookie)
	return SetPictureClipRegionCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook SetPictureClipRegionCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for SetPictureClipRegion
// setPictureClipRegionRequest writes a SetPictureClipRegion request to a byte slice.
func setPictureClipRegionRequest(c *xgb.Conn, Picture render.Picture, Region Region, XOrigin int16, YOrigin int16) []byte {
	size := 16
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["XFIXES"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 22 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Picture))
	b += 4

	xgb.Put32(buf[b:], uint32(Region))
	b += 4

	xgb.Put16(buf[b:], uint16(XOrigin))
	b += 2

	xgb.Put16(buf[b:], uint16(YOrigin))
	b += 2

	return buf
}

// SetRegionCookie is a cookie used only for SetRegion requests.
type SetRegionCookie struct {
	*xgb.Cookie
}

// SetRegion sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func SetRegion(c *xgb.Conn, Region Region, Rectangles []xproto.Rectangle) SetRegionCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFIXES"]; !ok {
		panic("Cannot issue request 'SetRegion' using the uninitialized extension 'XFIXES'. xfixes.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(setRegionRequest(c, Region, Rectangles), cookie)
	return SetRegionCookie{cookie}
}

// SetRegionChecked sends a checked request.
// If an error occurs, it can be retrieved using SetRegionCookie.Check()
func SetRegionChecked(c *xgb.Conn, Region Region, Rectangles []xproto.Rectangle) SetRegionCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFIXES"]; !ok {
		panic("Cannot issue request 'SetRegion' using the uninitialized extension 'XFIXES'. xfixes.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(setRegionRequest(c, Region, Rectangles), cookie)
	return SetRegionCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook SetRegionCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for SetRegion
// setRegionRequest writes a SetRegion request to a byte slice.
func setRegionRequest(c *xgb.Conn, Region Region, Rectangles []xproto.Rectangle) []byte {
	size := xgb.Pad((8 + xgb.Pad((len(Rectangles) * 8))))
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["XFIXES"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 11 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Region))
	b += 4

	b += xproto.RectangleListBytes(buf[b:], Rectangles)

	return buf
}

// SetWindowShapeRegionCookie is a cookie used only for SetWindowShapeRegion requests.
type SetWindowShapeRegionCookie struct {
	*xgb.Cookie
}

// SetWindowShapeRegion sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func SetWindowShapeRegion(c *xgb.Conn, Dest xproto.Window, DestKind shape.Kind, XOffset int16, YOffset int16, Region Region) SetWindowShapeRegionCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFIXES"]; !ok {
		panic("Cannot issue request 'SetWindowShapeRegion' using the uninitialized extension 'XFIXES'. xfixes.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(setWindowShapeRegionRequest(c, Dest, DestKind, XOffset, YOffset, Region), cookie)
	return SetWindowShapeRegionCookie{cookie}
}

// SetWindowShapeRegionChecked sends a checked request.
// If an error occurs, it can be retrieved using SetWindowShapeRegionCookie.Check()
func SetWindowShapeRegionChecked(c *xgb.Conn, Dest xproto.Window, DestKind shape.Kind, XOffset int16, YOffset int16, Region Region) SetWindowShapeRegionCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFIXES"]; !ok {
		panic("Cannot issue request 'SetWindowShapeRegion' using the uninitialized extension 'XFIXES'. xfixes.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(setWindowShapeRegionRequest(c, Dest, DestKind, XOffset, YOffset, Region), cookie)
	return SetWindowShapeRegionCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook SetWindowShapeRegionCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for SetWindowShapeRegion
// setWindowShapeRegionRequest writes a SetWindowShapeRegion request to a byte slice.
func setWindowShapeRegionRequest(c *xgb.Conn, Dest xproto.Window, DestKind shape.Kind, XOffset int16, YOffset int16, Region Region) []byte {
	size := 20
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["XFIXES"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 21 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Dest))
	b += 4

	buf[b] = byte(DestKind)
	b += 1

	b += 3 // padding

	xgb.Put16(buf[b:], uint16(XOffset))
	b += 2

	xgb.Put16(buf[b:], uint16(YOffset))
	b += 2

	xgb.Put32(buf[b:], uint32(Region))
	b += 4

	return buf
}

// ShowCursorCookie is a cookie used only for ShowCursor requests.
type ShowCursorCookie struct {
	*xgb.Cookie
}

// ShowCursor sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func ShowCursor(c *xgb.Conn, Window xproto.Window) ShowCursorCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFIXES"]; !ok {
		panic("Cannot issue request 'ShowCursor' using the uninitialized extension 'XFIXES'. xfixes.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(showCursorRequest(c, Window), cookie)
	return ShowCursorCookie{cookie}
}

// ShowCursorChecked sends a checked request.
// If an error occurs, it can be retrieved using ShowCursorCookie.Check()
func ShowCursorChecked(c *xgb.Conn, Window xproto.Window) ShowCursorCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFIXES"]; !ok {
		panic("Cannot issue request 'ShowCursor' using the uninitialized extension 'XFIXES'. xfixes.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(showCursorRequest(c, Window), cookie)
	return ShowCursorCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook ShowCursorCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for ShowCursor
// showCursorRequest writes a ShowCursor request to a byte slice.
func showCursorRequest(c *xgb.Conn, Window xproto.Window) []byte {
	size := 8
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["XFIXES"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 30 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Window))
	b += 4

	return buf
}

// SubtractRegionCookie is a cookie used only for SubtractRegion requests.
type SubtractRegionCookie struct {
	*xgb.Cookie
}

// SubtractRegion sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func SubtractRegion(c *xgb.Conn, Source1 Region, Source2 Region, Destination Region) SubtractRegionCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFIXES"]; !ok {
		panic("Cannot issue request 'SubtractRegion' using the uninitialized extension 'XFIXES'. xfixes.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(subtractRegionRequest(c, Source1, Source2, Destination), cookie)
	return SubtractRegionCookie{cookie}
}

// SubtractRegionChecked sends a checked request.
// If an error occurs, it can be retrieved using SubtractRegionCookie.Check()
func SubtractRegionChecked(c *xgb.Conn, Source1 Region, Source2 Region, Destination Region) SubtractRegionCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFIXES"]; !ok {
		panic("Cannot issue request 'SubtractRegion' using the uninitialized extension 'XFIXES'. xfixes.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(subtractRegionRequest(c, Source1, Source2, Destination), cookie)
	return SubtractRegionCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook SubtractRegionCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for SubtractRegion
// subtractRegionRequest writes a SubtractRegion request to a byte slice.
func subtractRegionRequest(c *xgb.Conn, Source1 Region, Source2 Region, Destination Region) []byte {
	size := 16
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["XFIXES"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 15 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Source1))
	b += 4

	xgb.Put32(buf[b:], uint32(Source2))
	b += 4

	xgb.Put32(buf[b:], uint32(Destination))
	b += 4

	return buf
}

// TranslateRegionCookie is a cookie used only for TranslateRegion requests.
type TranslateRegionCookie struct {
	*xgb.Cookie
}

// TranslateRegion sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func TranslateRegion(c *xgb.Conn, Region Region, Dx int16, Dy int16) TranslateRegionCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFIXES"]; !ok {
		panic("Cannot issue request 'TranslateRegion' using the uninitialized extension 'XFIXES'. xfixes.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(translateRegionRequest(c, Region, Dx, Dy), cookie)
	return TranslateRegionCookie{cookie}
}

// TranslateRegionChecked sends a checked request.
// If an error occurs, it can be retrieved using TranslateRegionCookie.Check()
func TranslateRegionChecked(c *xgb.Conn, Region Region, Dx int16, Dy int16) TranslateRegionCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFIXES"]; !ok {
		panic("Cannot issue request 'TranslateRegion' using the uninitialized extension 'XFIXES'. xfixes.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(translateRegionRequest(c, Region, Dx, Dy), cookie)
	return TranslateRegionCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook TranslateRegionCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for TranslateRegion
// translateRegionRequest writes a TranslateRegion request to a byte slice.
func translateRegionRequest(c *xgb.Conn, Region Region, Dx int16, Dy int16) []byte {
	size := 12
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["XFIXES"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 17 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Region))
	b += 4

	xgb.Put16(buf[b:], uint16(Dx))
	b += 2

	xgb.Put16(buf[b:], uint16(Dy))
	b += 2

	return buf
}

// UnionRegionCookie is a cookie used only for UnionRegion requests.
type UnionRegionCookie struct {
	*xgb.Cookie
}

// UnionRegion sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func UnionRegion(c *xgb.Conn, Source1 Region, Source2 Region, Destination Region) UnionRegionCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFIXES"]; !ok {
		panic("Cannot issue request 'UnionRegion' using the uninitialized extension 'XFIXES'. xfixes.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(unionRegionRequest(c, Source1, Source2, Destination), cookie)
	return UnionRegionCookie{cookie}
}

// UnionRegionChecked sends a checked request.
// If an error occurs, it can be retrieved using UnionRegionCookie.Check()
func UnionRegionChecked(c *xgb.Conn, Source1 Region, Source2 Region, Destination Region) UnionRegionCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["XFIXES"]; !ok {
		panic("Cannot issue request 'UnionRegion' using the uninitialized extension 'XFIXES'. xfixes.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(unionRegionRequest(c, Source1, Source2, Destination), cookie)
	return UnionRegionCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook UnionRegionCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for UnionRegion
// unionRegionRequest writes a UnionRegion request to a byte slice.
func unionRegionRequest(c *xgb.Conn, Source1 Region, Source2 Region, Destination Region) []byte {
	size := 16
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["XFIXES"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 13 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Source1))
	b += 4

	xgb.Put32(buf[b:], uint32(Source2))
	b += 4

	xgb.Put32(buf[b:], uint32(Destination))
	b += 4

	return buf
}
