// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package log_target

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// DeleteLogTargetGlobalAcceptedCode is the HTTP code returned for type DeleteLogTargetGlobalAccepted
const DeleteLogTargetGlobalAcceptedCode int = 202

/*
DeleteLogTargetGlobalAccepted Configuration change accepted and reload requested

swagger:response deleteLogTargetGlobalAccepted
*/
type DeleteLogTargetGlobalAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`
}

// NewDeleteLogTargetGlobalAccepted creates DeleteLogTargetGlobalAccepted with default headers values
func NewDeleteLogTargetGlobalAccepted() *DeleteLogTargetGlobalAccepted {

	return &DeleteLogTargetGlobalAccepted{}
}

// WithReloadID adds the reloadId to the delete log target global accepted response
func (o *DeleteLogTargetGlobalAccepted) WithReloadID(reloadID string) *DeleteLogTargetGlobalAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the delete log target global accepted response
func (o *DeleteLogTargetGlobalAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WriteResponse to the client
func (o *DeleteLogTargetGlobalAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(202)
}

// DeleteLogTargetGlobalNoContentCode is the HTTP code returned for type DeleteLogTargetGlobalNoContent
const DeleteLogTargetGlobalNoContentCode int = 204

/*
DeleteLogTargetGlobalNoContent Log Target deleted

swagger:response deleteLogTargetGlobalNoContent
*/
type DeleteLogTargetGlobalNoContent struct {
}

// NewDeleteLogTargetGlobalNoContent creates DeleteLogTargetGlobalNoContent with default headers values
func NewDeleteLogTargetGlobalNoContent() *DeleteLogTargetGlobalNoContent {

	return &DeleteLogTargetGlobalNoContent{}
}

// WriteResponse to the client
func (o *DeleteLogTargetGlobalNoContent) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(204)
}

// DeleteLogTargetGlobalNotFoundCode is the HTTP code returned for type DeleteLogTargetGlobalNotFound
const DeleteLogTargetGlobalNotFoundCode int = 404

/*
DeleteLogTargetGlobalNotFound The specified resource was not found

swagger:response deleteLogTargetGlobalNotFound
*/
type DeleteLogTargetGlobalNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewDeleteLogTargetGlobalNotFound creates DeleteLogTargetGlobalNotFound with default headers values
func NewDeleteLogTargetGlobalNotFound() *DeleteLogTargetGlobalNotFound {

	return &DeleteLogTargetGlobalNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the delete log target global not found response
func (o *DeleteLogTargetGlobalNotFound) WithConfigurationVersion(configurationVersion string) *DeleteLogTargetGlobalNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the delete log target global not found response
func (o *DeleteLogTargetGlobalNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the delete log target global not found response
func (o *DeleteLogTargetGlobalNotFound) WithPayload(payload *models.Error) *DeleteLogTargetGlobalNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the delete log target global not found response
func (o *DeleteLogTargetGlobalNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DeleteLogTargetGlobalNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
DeleteLogTargetGlobalDefault General Error

swagger:response deleteLogTargetGlobalDefault
*/
type DeleteLogTargetGlobalDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewDeleteLogTargetGlobalDefault creates DeleteLogTargetGlobalDefault with default headers values
func NewDeleteLogTargetGlobalDefault(code int) *DeleteLogTargetGlobalDefault {
	if code <= 0 {
		code = 500
	}

	return &DeleteLogTargetGlobalDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the delete log target global default response
func (o *DeleteLogTargetGlobalDefault) WithStatusCode(code int) *DeleteLogTargetGlobalDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the delete log target global default response
func (o *DeleteLogTargetGlobalDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the delete log target global default response
func (o *DeleteLogTargetGlobalDefault) WithConfigurationVersion(configurationVersion string) *DeleteLogTargetGlobalDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the delete log target global default response
func (o *DeleteLogTargetGlobalDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the delete log target global default response
func (o *DeleteLogTargetGlobalDefault) WithPayload(payload *models.Error) *DeleteLogTargetGlobalDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the delete log target global default response
func (o *DeleteLogTargetGlobalDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DeleteLogTargetGlobalDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
