// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package log_target

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// ReplaceLogTargetBackendOKCode is the HTTP code returned for type ReplaceLogTargetBackendOK
const ReplaceLogTargetBackendOKCode int = 200

/*
ReplaceLogTargetBackendOK Log Target replaced

swagger:response replaceLogTargetBackendOK
*/
type ReplaceLogTargetBackendOK struct {

	/*
	  In: Body
	*/
	Payload *models.LogTarget `json:"body,omitempty"`
}

// NewReplaceLogTargetBackendOK creates ReplaceLogTargetBackendOK with default headers values
func NewReplaceLogTargetBackendOK() *ReplaceLogTargetBackendOK {

	return &ReplaceLogTargetBackendOK{}
}

// WithPayload adds the payload to the replace log target backend o k response
func (o *ReplaceLogTargetBackendOK) WithPayload(payload *models.LogTarget) *ReplaceLogTargetBackendOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace log target backend o k response
func (o *ReplaceLogTargetBackendOK) SetPayload(payload *models.LogTarget) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceLogTargetBackendOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceLogTargetBackendAcceptedCode is the HTTP code returned for type ReplaceLogTargetBackendAccepted
const ReplaceLogTargetBackendAcceptedCode int = 202

/*
ReplaceLogTargetBackendAccepted Configuration change accepted and reload requested

swagger:response replaceLogTargetBackendAccepted
*/
type ReplaceLogTargetBackendAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`

	/*
	  In: Body
	*/
	Payload *models.LogTarget `json:"body,omitempty"`
}

// NewReplaceLogTargetBackendAccepted creates ReplaceLogTargetBackendAccepted with default headers values
func NewReplaceLogTargetBackendAccepted() *ReplaceLogTargetBackendAccepted {

	return &ReplaceLogTargetBackendAccepted{}
}

// WithReloadID adds the reloadId to the replace log target backend accepted response
func (o *ReplaceLogTargetBackendAccepted) WithReloadID(reloadID string) *ReplaceLogTargetBackendAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the replace log target backend accepted response
func (o *ReplaceLogTargetBackendAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WithPayload adds the payload to the replace log target backend accepted response
func (o *ReplaceLogTargetBackendAccepted) WithPayload(payload *models.LogTarget) *ReplaceLogTargetBackendAccepted {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace log target backend accepted response
func (o *ReplaceLogTargetBackendAccepted) SetPayload(payload *models.LogTarget) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceLogTargetBackendAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.WriteHeader(202)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceLogTargetBackendBadRequestCode is the HTTP code returned for type ReplaceLogTargetBackendBadRequest
const ReplaceLogTargetBackendBadRequestCode int = 400

/*
ReplaceLogTargetBackendBadRequest Bad request

swagger:response replaceLogTargetBackendBadRequest
*/
type ReplaceLogTargetBackendBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceLogTargetBackendBadRequest creates ReplaceLogTargetBackendBadRequest with default headers values
func NewReplaceLogTargetBackendBadRequest() *ReplaceLogTargetBackendBadRequest {

	return &ReplaceLogTargetBackendBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the replace log target backend bad request response
func (o *ReplaceLogTargetBackendBadRequest) WithConfigurationVersion(configurationVersion string) *ReplaceLogTargetBackendBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace log target backend bad request response
func (o *ReplaceLogTargetBackendBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace log target backend bad request response
func (o *ReplaceLogTargetBackendBadRequest) WithPayload(payload *models.Error) *ReplaceLogTargetBackendBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace log target backend bad request response
func (o *ReplaceLogTargetBackendBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceLogTargetBackendBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceLogTargetBackendNotFoundCode is the HTTP code returned for type ReplaceLogTargetBackendNotFound
const ReplaceLogTargetBackendNotFoundCode int = 404

/*
ReplaceLogTargetBackendNotFound The specified resource was not found

swagger:response replaceLogTargetBackendNotFound
*/
type ReplaceLogTargetBackendNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceLogTargetBackendNotFound creates ReplaceLogTargetBackendNotFound with default headers values
func NewReplaceLogTargetBackendNotFound() *ReplaceLogTargetBackendNotFound {

	return &ReplaceLogTargetBackendNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the replace log target backend not found response
func (o *ReplaceLogTargetBackendNotFound) WithConfigurationVersion(configurationVersion string) *ReplaceLogTargetBackendNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace log target backend not found response
func (o *ReplaceLogTargetBackendNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace log target backend not found response
func (o *ReplaceLogTargetBackendNotFound) WithPayload(payload *models.Error) *ReplaceLogTargetBackendNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace log target backend not found response
func (o *ReplaceLogTargetBackendNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceLogTargetBackendNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
ReplaceLogTargetBackendDefault General Error

swagger:response replaceLogTargetBackendDefault
*/
type ReplaceLogTargetBackendDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceLogTargetBackendDefault creates ReplaceLogTargetBackendDefault with default headers values
func NewReplaceLogTargetBackendDefault(code int) *ReplaceLogTargetBackendDefault {
	if code <= 0 {
		code = 500
	}

	return &ReplaceLogTargetBackendDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the replace log target backend default response
func (o *ReplaceLogTargetBackendDefault) WithStatusCode(code int) *ReplaceLogTargetBackendDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the replace log target backend default response
func (o *ReplaceLogTargetBackendDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the replace log target backend default response
func (o *ReplaceLogTargetBackendDefault) WithConfigurationVersion(configurationVersion string) *ReplaceLogTargetBackendDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace log target backend default response
func (o *ReplaceLogTargetBackendDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace log target backend default response
func (o *ReplaceLogTargetBackendDefault) WithPayload(payload *models.Error) *ReplaceLogTargetBackendDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace log target backend default response
func (o *ReplaceLogTargetBackendDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceLogTargetBackendDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
