// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package server

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// CreateServerPeerCreatedCode is the HTTP code returned for type CreateServerPeerCreated
const CreateServerPeerCreatedCode int = 201

/*
CreateServerPeerCreated Server created

swagger:response createServerPeerCreated
*/
type CreateServerPeerCreated struct {

	/*
	  In: Body
	*/
	Payload *models.Server `json:"body,omitempty"`
}

// NewCreateServerPeerCreated creates CreateServerPeerCreated with default headers values
func NewCreateServerPeerCreated() *CreateServerPeerCreated {

	return &CreateServerPeerCreated{}
}

// WithPayload adds the payload to the create server peer created response
func (o *CreateServerPeerCreated) WithPayload(payload *models.Server) *CreateServerPeerCreated {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create server peer created response
func (o *CreateServerPeerCreated) SetPayload(payload *models.Server) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateServerPeerCreated) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(201)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateServerPeerAcceptedCode is the HTTP code returned for type CreateServerPeerAccepted
const CreateServerPeerAcceptedCode int = 202

/*
CreateServerPeerAccepted Configuration change accepted and reload requested

swagger:response createServerPeerAccepted
*/
type CreateServerPeerAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`

	/*
	  In: Body
	*/
	Payload *models.Server `json:"body,omitempty"`
}

// NewCreateServerPeerAccepted creates CreateServerPeerAccepted with default headers values
func NewCreateServerPeerAccepted() *CreateServerPeerAccepted {

	return &CreateServerPeerAccepted{}
}

// WithReloadID adds the reloadId to the create server peer accepted response
func (o *CreateServerPeerAccepted) WithReloadID(reloadID string) *CreateServerPeerAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the create server peer accepted response
func (o *CreateServerPeerAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WithPayload adds the payload to the create server peer accepted response
func (o *CreateServerPeerAccepted) WithPayload(payload *models.Server) *CreateServerPeerAccepted {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create server peer accepted response
func (o *CreateServerPeerAccepted) SetPayload(payload *models.Server) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateServerPeerAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.WriteHeader(202)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateServerPeerBadRequestCode is the HTTP code returned for type CreateServerPeerBadRequest
const CreateServerPeerBadRequestCode int = 400

/*
CreateServerPeerBadRequest Bad request

swagger:response createServerPeerBadRequest
*/
type CreateServerPeerBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateServerPeerBadRequest creates CreateServerPeerBadRequest with default headers values
func NewCreateServerPeerBadRequest() *CreateServerPeerBadRequest {

	return &CreateServerPeerBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the create server peer bad request response
func (o *CreateServerPeerBadRequest) WithConfigurationVersion(configurationVersion string) *CreateServerPeerBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create server peer bad request response
func (o *CreateServerPeerBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create server peer bad request response
func (o *CreateServerPeerBadRequest) WithPayload(payload *models.Error) *CreateServerPeerBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create server peer bad request response
func (o *CreateServerPeerBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateServerPeerBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateServerPeerConflictCode is the HTTP code returned for type CreateServerPeerConflict
const CreateServerPeerConflictCode int = 409

/*
CreateServerPeerConflict The specified resource already exists

swagger:response createServerPeerConflict
*/
type CreateServerPeerConflict struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateServerPeerConflict creates CreateServerPeerConflict with default headers values
func NewCreateServerPeerConflict() *CreateServerPeerConflict {

	return &CreateServerPeerConflict{}
}

// WithConfigurationVersion adds the configurationVersion to the create server peer conflict response
func (o *CreateServerPeerConflict) WithConfigurationVersion(configurationVersion string) *CreateServerPeerConflict {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create server peer conflict response
func (o *CreateServerPeerConflict) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create server peer conflict response
func (o *CreateServerPeerConflict) WithPayload(payload *models.Error) *CreateServerPeerConflict {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create server peer conflict response
func (o *CreateServerPeerConflict) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateServerPeerConflict) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(409)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
CreateServerPeerDefault General Error

swagger:response createServerPeerDefault
*/
type CreateServerPeerDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateServerPeerDefault creates CreateServerPeerDefault with default headers values
func NewCreateServerPeerDefault(code int) *CreateServerPeerDefault {
	if code <= 0 {
		code = 500
	}

	return &CreateServerPeerDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the create server peer default response
func (o *CreateServerPeerDefault) WithStatusCode(code int) *CreateServerPeerDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the create server peer default response
func (o *CreateServerPeerDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the create server peer default response
func (o *CreateServerPeerDefault) WithConfigurationVersion(configurationVersion string) *CreateServerPeerDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create server peer default response
func (o *CreateServerPeerDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create server peer default response
func (o *CreateServerPeerDefault) WithPayload(payload *models.Error) *CreateServerPeerDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create server peer default response
func (o *CreateServerPeerDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateServerPeerDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
