// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package stick_rule

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// ReplaceStickRulesOKCode is the HTTP code returned for type ReplaceStickRulesOK
const ReplaceStickRulesOKCode int = 200

/*
ReplaceStickRulesOK All Stick Rule lines replaced

swagger:response replaceStickRulesOK
*/
type ReplaceStickRulesOK struct {

	/*
	  In: Body
	*/
	Payload models.StickRules `json:"body,omitempty"`
}

// NewReplaceStickRulesOK creates ReplaceStickRulesOK with default headers values
func NewReplaceStickRulesOK() *ReplaceStickRulesOK {

	return &ReplaceStickRulesOK{}
}

// WithPayload adds the payload to the replace stick rules o k response
func (o *ReplaceStickRulesOK) WithPayload(payload models.StickRules) *ReplaceStickRulesOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace stick rules o k response
func (o *ReplaceStickRulesOK) SetPayload(payload models.StickRules) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceStickRulesOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	payload := o.Payload
	if payload == nil {
		// return empty array
		payload = models.StickRules{}
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

// ReplaceStickRulesAcceptedCode is the HTTP code returned for type ReplaceStickRulesAccepted
const ReplaceStickRulesAcceptedCode int = 202

/*
ReplaceStickRulesAccepted Configuration change accepted and reload requested

swagger:response replaceStickRulesAccepted
*/
type ReplaceStickRulesAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`

	/*
	  In: Body
	*/
	Payload models.StickRules `json:"body,omitempty"`
}

// NewReplaceStickRulesAccepted creates ReplaceStickRulesAccepted with default headers values
func NewReplaceStickRulesAccepted() *ReplaceStickRulesAccepted {

	return &ReplaceStickRulesAccepted{}
}

// WithReloadID adds the reloadId to the replace stick rules accepted response
func (o *ReplaceStickRulesAccepted) WithReloadID(reloadID string) *ReplaceStickRulesAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the replace stick rules accepted response
func (o *ReplaceStickRulesAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WithPayload adds the payload to the replace stick rules accepted response
func (o *ReplaceStickRulesAccepted) WithPayload(payload models.StickRules) *ReplaceStickRulesAccepted {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace stick rules accepted response
func (o *ReplaceStickRulesAccepted) SetPayload(payload models.StickRules) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceStickRulesAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.WriteHeader(202)
	payload := o.Payload
	if payload == nil {
		// return empty array
		payload = models.StickRules{}
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

// ReplaceStickRulesBadRequestCode is the HTTP code returned for type ReplaceStickRulesBadRequest
const ReplaceStickRulesBadRequestCode int = 400

/*
ReplaceStickRulesBadRequest Bad request

swagger:response replaceStickRulesBadRequest
*/
type ReplaceStickRulesBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceStickRulesBadRequest creates ReplaceStickRulesBadRequest with default headers values
func NewReplaceStickRulesBadRequest() *ReplaceStickRulesBadRequest {

	return &ReplaceStickRulesBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the replace stick rules bad request response
func (o *ReplaceStickRulesBadRequest) WithConfigurationVersion(configurationVersion string) *ReplaceStickRulesBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace stick rules bad request response
func (o *ReplaceStickRulesBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace stick rules bad request response
func (o *ReplaceStickRulesBadRequest) WithPayload(payload *models.Error) *ReplaceStickRulesBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace stick rules bad request response
func (o *ReplaceStickRulesBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceStickRulesBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
ReplaceStickRulesDefault General Error

swagger:response replaceStickRulesDefault
*/
type ReplaceStickRulesDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceStickRulesDefault creates ReplaceStickRulesDefault with default headers values
func NewReplaceStickRulesDefault(code int) *ReplaceStickRulesDefault {
	if code <= 0 {
		code = 500
	}

	return &ReplaceStickRulesDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the replace stick rules default response
func (o *ReplaceStickRulesDefault) WithStatusCode(code int) *ReplaceStickRulesDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the replace stick rules default response
func (o *ReplaceStickRulesDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the replace stick rules default response
func (o *ReplaceStickRulesDefault) WithConfigurationVersion(configurationVersion string) *ReplaceStickRulesDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace stick rules default response
func (o *ReplaceStickRulesDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace stick rules default response
func (o *ReplaceStickRulesDefault) WithPayload(payload *models.Error) *ReplaceStickRulesDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace stick rules default response
func (o *ReplaceStickRulesDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceStickRulesDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
