/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.qodana.sarif.baseline;

import com.jetbrains.qodana.sarif.model.ReportingDescriptor;
import com.jetbrains.qodana.sarif.model.Run;
import com.jetbrains.qodana.sarif.model.Tool;
import com.jetbrains.qodana.sarif.model.ToolComponent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

final class DescriptorWithLocation {
    @NotNull
    private final ReportingDescriptor descriptor;
    @NotNull
    private final ToolComponent location;

    public DescriptorWithLocation(@NotNull ReportingDescriptor descriptor, @NotNull ToolComponent location) {
        this.descriptor = descriptor;
        this.location = location;
    }

    @NotNull
    ReportingDescriptor getDescriptor() {
        return this.descriptor;
    }

    void addTo(Run run) {
        Stream fromExtensions;
        Tool tool = run.getTool();
        if (tool == null) {
            return;
        }
        Stream fromDriver = Optional.ofNullable(tool.getDriver()).map(Stream::of).orElseGet(Stream::empty);
        Optional<ToolComponent> existing = Stream.concat(fromDriver, fromExtensions = Optional.ofNullable(tool.getExtensions()).map(Collection::stream).orElseGet(Stream::empty)).filter(e -> Objects.equals(e.getFullName(), this.location.getFullName()) && Objects.equals(e.getVersion(), this.location.getVersion())).findFirst();
        if (existing.isPresent()) {
            ToolComponent e2 = existing.get();
            this.getOrCreate(e2::getRules, e2::setRules, ArrayList::new).add(this.descriptor);
        } else {
            this.getOrCreate(tool::getExtensions, tool::setExtensions, HashSet::new).add(this.location.shallowCopy().withIsComprehensive(false).withRules(new ArrayList<ReportingDescriptor>(Collections.singletonList(this.descriptor))));
        }
    }

    @NotNull
    private <T> T getOrCreate(Supplier<T> get, Consumer<T> set, Supplier<T> create) {
        T value = get.get();
        if (value != null) {
            return value;
        }
        value = create.get();
        set.accept(value);
        return value;
    }
}

