/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins;

import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.gradle.api.ExtensiblePolymorphicDomainObjectContainer;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.attributes.Category;
import org.gradle.api.attributes.HasConfigurableAttributes;
import org.gradle.api.attributes.TestSuiteType;
import org.gradle.api.attributes.VerificationType;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.artifacts.configurations.RoleBasedConfigurationContainerInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.testing.DefaultAggregateTestReport;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.plugins.jvm.JvmTestSuite;
import org.gradle.api.plugins.jvm.internal.JvmPluginServices;
import org.gradle.api.provider.Provider;
import org.gradle.api.reporting.ReportingExtension;
import org.gradle.api.tasks.testing.AggregateTestReport;
import org.gradle.testing.base.TestingExtension;

@Incubating
public abstract class TestReportAggregationPlugin
implements Plugin<Project> {
    public static final String TEST_REPORT_AGGREGATION_CONFIGURATION_NAME = "testReportAggregation";

    @Inject
    protected abstract JvmPluginServices getJvmPluginServices();

    public void apply(Project project) {
        project.getPluginManager().apply("org.gradle.reporting-base");
        RoleBasedConfigurationContainerInternal configurations = ((ProjectInternal)project).getConfigurations();
        Configuration testAggregation = (Configuration)configurations.dependencyScope(TEST_REPORT_AGGREGATION_CONFIGURATION_NAME).get();
        testAggregation.setDescription("A configuration to collect test execution results");
        testAggregation.setVisible(false);
        ReportingExtension reporting = (ReportingExtension)project.getExtensions().getByType(ReportingExtension.class);
        reporting.getReports().registerBinding(AggregateTestReport.class, DefaultAggregateTestReport.class);
        ObjectFactory objects = project.getObjects();
        DirectoryProperty testReportDirectory = objects.directoryProperty().convention(reporting.getBaseDirectory().dir("tests"));
        project.getPlugins().withId("java-base", plugin -> {
            JavaPluginExtension javaPluginExtension = (JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class);
            testReportDirectory.convention((Provider)javaPluginExtension.getTestReportDir());
        });
        Configuration testResultsConf = (Configuration)configurations.resolvable("aggregateTestReportResults").get();
        testResultsConf.extendsFrom(new Configuration[]{testAggregation});
        testResultsConf.setDescription("Graph needed for the aggregated test results report.");
        testResultsConf.setVisible(false);
        reporting.getReports().withType(AggregateTestReport.class).all(report -> report.getReportTask().configure(task -> {
            Callable<FileCollection> testResults = () -> testResultsConf.getIncoming().artifactView(view -> {
                view.withVariantReselection();
                view.componentFilter(id -> id instanceof ProjectComponentIdentifier);
                view.attributes(attributes -> {
                    attributes.attribute(Category.CATEGORY_ATTRIBUTE, (Object)((Category)objects.named(Category.class, "verification")));
                    attributes.attributeProvider(TestSuiteType.TEST_SUITE_TYPE_ATTRIBUTE, report.getTestType().map(tt -> (TestSuiteType)objects.named(TestSuiteType.class, tt)));
                    attributes.attribute(VerificationType.VERIFICATION_TYPE_ATTRIBUTE, (Object)((VerificationType)objects.named(VerificationType.class, "test-results")));
                });
            }).getFiles();
            task.getTestResults().from(new Object[]{testResults});
            task.getDestinationDirectory().convention(testReportDirectory.dir(report.getTestType().map(tt -> tt + "/aggregated-results")));
        }));
        project.getPlugins().withType(JavaBasePlugin.class, plugin -> this.getJvmPluginServices().configureAsRuntimeClasspath((HasConfigurableAttributes)testAggregation));
        project.getPlugins().withId("jvm-test-suite", plugin -> {
            testAggregation.getDependencies().add((Object)project.getDependencyFactory().create(project));
            TestingExtension testing = (TestingExtension)project.getExtensions().getByType(TestingExtension.class);
            ExtensiblePolymorphicDomainObjectContainer testSuites = testing.getSuites();
            testSuites.withType(JvmTestSuite.class).all(testSuite -> reporting.getReports().create(testSuite.getName() + "AggregateTestReport", AggregateTestReport.class, report -> report.getTestType().convention(testSuite.getTestType())));
        });
    }
}

