/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import java.util.function.IntPredicate;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.tree.tiny.NodeVectorTree;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.UType;

public final class AnyChildNodeTest
extends NodeTest {
    private static final AnyChildNodeTest THE_INSTANCE = new AnyChildNodeTest();

    public static AnyChildNodeTest getInstance() {
        return THE_INSTANCE;
    }

    private AnyChildNodeTest() {
    }

    @Override
    public UType getUType() {
        return UType.CHILD_NODE_KINDS;
    }

    @Override
    public boolean matches(int nodeKind, NodeName name, SchemaType annotation) {
        return nodeKind == 1 || nodeKind == 3 || nodeKind == 8 || nodeKind == 7;
    }

    @Override
    public IntPredicate getMatcher(NodeVectorTree tree) {
        byte[] nodeKindArray = tree.getNodeKindArray();
        return nodeNr -> {
            int nodeKind = nodeKindArray[nodeNr] & 0xF;
            return nodeKind == 1 || nodeKind == 3 || nodeKind == 4 || nodeKind == 8 || nodeKind == 7;
        };
    }

    @Override
    public boolean matchesNode(NodeInfo node) {
        int nodeKind = node.getNodeKind();
        return nodeKind == 1 || nodeKind == 3 || nodeKind == 8 || nodeKind == 7;
    }

    @Override
    public double getDefaultPriority() {
        return -0.5;
    }

    @Override
    public String toString() {
        return "( element() | text() | comment() | processing-instruction() )";
    }

    @Override
    public String generateJavaScriptItemTypeTest(ItemType knownToBe, int targetVersion) {
        return "return SaxonJS.U.isNode(item) && (item.nodeType===1 || item.nodeType===3 || item.nodeType===7 || item.nodeType===8);";
    }
}

