/*
  Copyright (C) 2004-2005 Tommi Tervonen, Petteri Klemola, Pasi Orovuo

  This file is part of Kajaani Kombat.

  Kajaani Kombat is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  Kajaani Kombat is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with Kajaani Kombat; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "audio.h"

//music files
const char *realaudio::shootmus_file = "music_shoot.ogg";
const char *realaudio::intromus_file = "music_intro.ogg";
const char *realaudio::repairmus_file = "music_repair.ogg";
const char *realaudio::cannonmus_file = "music_placecannon.ogg";

//sound effect files
const char *realaudio::hit_file = "sound_hit.ogg";
const char *realaudio::hit_cannon_file = "sound_hit_cannon.ogg";
const char *realaudio::fire_file = "sound_fire.ogg";
const char *realaudio::cannon_down_file = "sound_cannon_down.ogg";
const char *realaudio::select_castle_file ="sound_select_castle.ogg";

const char *realaudio::block_down_file = "sound_block_down.ogg";
const char *realaudio::block_rotate_file = "sound_block_rotate.ogg";
const char *realaudio::gui_navigation_file = "sound_gui_navigation.ogg";
const char *realaudio::gui_select_file ="sound_gui_select.ogg";
const char *realaudio::three_sec_warning_file ="three_sec_warning.ogg";

Mix_Music *audio::load_mus(const string &fname) throw (string)
{
  string buf = string(MEDIA_PATH);
  buf += fname;
  Mix_Music * tmp = Mix_LoadMUS(buf.c_str());
  if (tmp == NULL)
    {
      string errstr ("Error loading: ");
      errstr += fname;
      errstr += " - ";
      errstr += Mix_GetError();

      throw errstr;
    }
  return tmp;
}

Mix_Chunk *audio::load_sfx(const string &fname) throw (string)
{
  string buf = string(MEDIA_PATH);
  buf += fname;
  Mix_Chunk * tmp = Mix_LoadWAV(buf.c_str());
  if (tmp == NULL)
    {
      string errstr ("Error loading: ");
      errstr += fname;
      errstr += " - ";
      errstr += Mix_GetError();

      throw errstr;
    }
  return tmp;
}

realaudio::realaudio() throw (string &)
{
  int i=0;
  intro_mus = shoot_mus = repair_mus = cannon_mus = NULL;
  gui_navigation = gui_select = three_sec_warning = NULL;
  for (i=0;i<MAX_PLAYERS;i++)
    {
      hit[i] = NULL;
      hit_cannon[i] = NULL;
      fire[i] = NULL;
      cannon_down[i] = NULL;
      select_castle[i] = NULL;
    }
  hit_cannon[MAX_PLAYERS] = NULL;

  try {
    intro_mus = load_mus (string(intromus_file));
    shoot_mus = load_mus (string(shootmus_file));
    repair_mus = load_mus (string(repairmus_file));
    cannon_mus = load_mus (string(cannonmus_file));
    // musics are loaded now

    gui_navigation = load_sfx(string(gui_navigation_file));
    gui_select = load_sfx(string(gui_select_file));
    three_sec_warning = load_sfx(string(three_sec_warning_file));
    block_down = load_sfx(string(block_down_file));
    block_rotate = load_sfx(string(block_rotate_file));

    // general sfx are loaded

    // load sfx for all players
    char buf[100];
    for (i=0;i<MAX_PLAYERS;i++)
      {
	sprintf (buf, "%d%s", i, fire_file);
	fire[i] = load_sfx(string(buf));
	sprintf (buf, "%d%s", i, hit_file);
	hit[i] = load_sfx(string(buf));
	sprintf (buf, "%d%s", i, hit_cannon_file);
	hit_cannon[i] = load_sfx(string(buf));
	sprintf (buf, "%d%s", i, select_castle_file);
	select_castle[i] = load_sfx(string(buf));
	sprintf (buf, "%d%s", i, cannon_down_file);
	cannon_down[i] = load_sfx(string(buf));
      }
    sprintf (buf, "%d%s", MAX_PLAYERS, hit_cannon_file);
    hit_cannon[MAX_PLAYERS] = load_sfx(string(buf));
  }
  catch (string & s)
    {
      if (intro_mus) Mix_FreeMusic(intro_mus);
      if (shoot_mus) Mix_FreeMusic(shoot_mus);
      if (repair_mus) Mix_FreeMusic(repair_mus);
      if (cannon_mus) Mix_FreeMusic(cannon_mus);
      
      if (gui_navigation) Mix_FreeChunk(gui_navigation);
      if (gui_select) Mix_FreeChunk(gui_select);
      if (three_sec_warning) Mix_FreeChunk(three_sec_warning);
      if (block_down) Mix_FreeChunk(block_down);
      if (block_rotate) Mix_FreeChunk(block_rotate);

      for (i=0;i<MAX_PLAYERS;i++)
	{
	  if (hit[i]) Mix_FreeChunk(hit[i]);
	  if (hit_cannon[i]) Mix_FreeChunk(hit_cannon[i]);
	  if (fire[i]) Mix_FreeChunk(fire[i]);
	  if (cannon_down[i]) Mix_FreeChunk(cannon_down[i]);
	  if (select_castle[i]) Mix_FreeChunk(select_castle[i]);
	}
      if (hit_cannon[MAX_PLAYERS]) Mix_FreeChunk(hit_cannon[MAX_PLAYERS]);
      throw s;
    }

  /* not needed anymore
  int vol = Mix_VolumeChunk(gui_navigation, -1);
  Mix_VolumeChunk(gui_navigation, vol-100);

  vol = Mix_VolumeChunk(gui_select, -1);
  Mix_VolumeChunk(gui_select, vol-100);
  */
}

realaudio::~realaudio()
{
  Mix_FadeOutMusic(0);

  int i=0;
  //free music
  Mix_FreeMusic(intro_mus);
  Mix_FreeMusic(shoot_mus);
  Mix_FreeMusic(repair_mus);
  Mix_FreeMusic(cannon_mus);
  
  //free sound effects
  for (i=0;i<MAX_PLAYERS;i++)
    {
      Mix_FreeChunk(hit[i]);
      Mix_FreeChunk(hit_cannon[i]);
      Mix_FreeChunk(fire[i]);
      Mix_FreeChunk(cannon_down[i]);
      Mix_FreeChunk(select_castle[i]);
    }
  Mix_FreeChunk(hit_cannon[MAX_PLAYERS]);

  Mix_FreeChunk(gui_navigation);
  Mix_FreeChunk(gui_select);
  Mix_FreeChunk(three_sec_warning);
  Mix_FreeChunk(block_down);
  Mix_FreeChunk(block_rotate);
}

void realaudio::play_intro_music()
{
  //  Mix_FadeOutMusic(FADEOUT_DUR);
  Mix_FadeInMusic(intro_mus, -1, FADEIN_DUR);
}

void realaudio::play_cannonplace_music()
{
  //  Mix_FadeOutMusic(FADEOUT_DUR);
  Mix_FadeInMusic(cannon_mus, -1, FADEIN_DUR);
}

void realaudio::play_shooting_music()
{
  //  Mix_FadeOutMusic(FADEOUT_DUR);
  Mix_FadeInMusic(shoot_mus, -1, FADEIN_DUR);
}

void realaudio::play_repair_music()
{
  //  Mix_FadeOutMusic(FADEOUT_DUR);
  Mix_FadeInMusic(repair_mus, -1, FADEIN_DUR);
}

void realaudio::play_hit_sound(int pn)
{
  assert (pn >= 0 && pn < MAX_PLAYERS);
  Mix_PlayChannel(1,hit[pn],0);
}

void realaudio::play_hit_cannon_sound(int pn)
{
  assert (pn >= 0 && pn <= MAX_PLAYERS);
  Mix_PlayChannel(2,hit_cannon[pn],0);
}

void realaudio::play_fire_sound(int pn)
{
  assert (pn >= 0 && pn <= MAX_PLAYERS);
  Mix_PlayChannel(0,fire[pn],0);
}

void realaudio::play_block_down_sound()
{
  Mix_PlayChannel(0,block_down,0);
}

void realaudio::play_block_rotate_sound()
{
  Mix_PlayChannel(0,block_rotate,0);
}

void realaudio::play_cannon_down_sound(int pn)
{
  assert (pn >= 0 && pn < MAX_PLAYERS);
  Mix_PlayChannel(0,cannon_down[pn],0);
}

void realaudio::play_select_castle_sound(int pn)
{
  assert (pn >= 0 && pn < MAX_PLAYERS);
  Mix_PlayChannel(0,select_castle[pn],0);
}

void realaudio::play_gui_navigation_sound()
{
  Mix_PlayChannel(0,gui_navigation,0);
}

void realaudio::play_gui_select_sound()
{
  Mix_PlayChannel(1,gui_select,0);
}

void realaudio::play_three_sec_warning_sound()
{
  Mix_PlayChannel(2,three_sec_warning,0);
}

void realaudio::stop_music()
{
  Mix_FadeOutMusic(FADEOUT_DUR);
}
