#include "player.h"

void player::disconnect()
{
  alive =false;
  conns = NULL;
}

void player::win()
{
  wins++;
}

void player::put_character(int ch)
{
  assert (ch >= 0);
  character=ch;
}

int player::get_character() const
{
  return character;
}

player::player  (const player &p)
{
  conns = p.conns;
  name = p.name;
  alive = p.alive;
  color = p.color;
  ready_to_change = p.ready_to_change;
  wins = p.wins;
  kredits = p.kredits;
  character = MAX_PLAYERS;
}

player::player(connects *conn, const string& _name)
{
  conns = conn;
  name = _name;
  alive = true;
  wins = 0;
  kredits = 0;
  character = MAX_PLAYERS;
}

player::player()
{
  conns = NULL;
  name = string("");
  alive = false;
  wins = 0;
  kredits = 0;
  character = MAX_PLAYERS;
}

const string & player::get_name() const
{
  return name; 
}

SDL_Color player::get_color() const 
{
  return PLAYER_COLORS[character];
}

connects * player::get_connect()
{
  return conns; 
}

bool player::is_connected() const
{
  return conns != NULL; 
}

bool player::is_alive() const
{ 
  return alive; 
}
void player::kill()
{ 
  alive = false; 
}
void player::rebirth()
{ 
  alive = true; 
}

int player::get_wins() const
{ 
  return wins; 
}

void player::set_kredits(int x)
{
  kredits = x;
}

int player::get_kredits() const
{ 
  return kredits; 
}
