/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.remote.internal.inet;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.internal.remote.internal.inet.InetAddresses;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceScope(value={Scope.Global.class})
public class InetAddressFactory {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Object lock = new Object();
    private List<InetAddress> communicationAddresses;
    private InetAddress localBindingAddress;
    private InetAddress wildcardBindingAddress;
    private InetAddresses inetAddresses;
    private boolean initialized;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCommunicationAddress(InetAddress address) {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.init();
                return this.communicationAddresses.contains(address);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not determine the IP addresses for this machine.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<InetAddress> getCommunicationAddresses() {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.init();
                return this.communicationAddresses;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not determine the local IP addresses for this machine.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InetAddress getLocalBindingAddress() {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.init();
                return this.localBindingAddress;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not determine a usable local IP for this machine.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InetAddress getWildcardBindingAddress() {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.init();
                return this.wildcardBindingAddress;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not determine a usable wildcard IP for this machine.", e);
        }
    }

    private void init() throws Exception {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        if (this.inetAddresses == null) {
            this.inetAddresses = new InetAddresses();
        }
        this.wildcardBindingAddress = new InetSocketAddress(0).getAddress();
        this.findLocalBindingAddress();
        this.findCommunicationAddresses();
        this.handleOpenshift();
    }

    private void findLocalBindingAddress() {
        if (this.inetAddresses.getLoopback().isEmpty()) {
            this.logger.debug("No loopback address for local binding, using fallback {}", (Object)this.wildcardBindingAddress);
            this.localBindingAddress = this.wildcardBindingAddress;
        } else {
            this.localBindingAddress = InetAddress.getLoopbackAddress();
        }
    }

    private void handleOpenshift() {
        InetAddress openshiftBindAddress = this.findOpenshiftAddresses();
        if (openshiftBindAddress != null) {
            this.localBindingAddress = openshiftBindAddress;
            this.communicationAddresses.add(openshiftBindAddress);
        }
    }

    @Nullable
    private InetAddress findOpenshiftAddresses() {
        for (String key : System.getenv().keySet()) {
            if (!key.startsWith("OPENSHIFT_") || !key.endsWith("_IP")) continue;
            String ipAddress = System.getenv(key);
            this.logger.debug("OPENSHIFT IP environment variable {} detected. Using IP address {}.", (Object)key, (Object)ipAddress);
            try {
                return InetAddress.getByName(ipAddress);
            }
            catch (UnknownHostException e) {
                throw new RuntimeException(String.format("Unable to use OPENSHIFT IP - invalid IP address '%s' specified in environment variable %s.", ipAddress, key), e);
            }
        }
        return null;
    }

    private void findCommunicationAddresses() throws UnknownHostException {
        this.communicationAddresses = new ArrayList<InetAddress>();
        if (this.inetAddresses.getLoopback().isEmpty()) {
            if (this.inetAddresses.getRemote().isEmpty()) {
                InetAddress fallback = InetAddress.getByName(null);
                this.logger.debug("No loopback addresses for communication, using fallback {}", (Object)fallback);
                this.communicationAddresses.add(fallback);
            } else {
                this.logger.debug("No loopback addresses for communication, using remote addresses instead.");
                this.communicationAddresses.addAll(this.inetAddresses.getRemote());
            }
        } else {
            this.communicationAddresses.addAll(this.inetAddresses.getLoopback());
        }
    }
}

