/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.utils;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.utils.Printer;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0006\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u001b\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u000e\u001a\u00020\rJ\u0006\u0010\u000f\u001a\u00020\u0010J\u001f\u0010\u0011\u001a\u00020\u00102\u0012\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0013\"\u00020\u0001\u00a2\u0006\u0002\u0010\u0014J\u001f\u0010\u0015\u001a\u00020\u00102\u0012\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0013\"\u00020\u0001\u00a2\u0006\u0002\u0010\u0014J\u0006\u0010\u0016\u001a\u00020\u0010J\b\u0010\u0017\u001a\u00020\u0006H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/utils/SmartPrinter;", "", "appendable", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "indent", "", "(Ljava/lang/Appendable;Ljava/lang/String;)V", "notFirstPrint", "", "printer", "Lorg/jetbrains/kotlin/utils/Printer;", "getCurrentIndentInUnits", "", "getIndentUnit", "popIndent", "", "print", "objects", "", "([Ljava/lang/Object;)V", "println", "pushIndent", "toString", "Companion", "util.runtime"})
public final class SmartPrinter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Printer printer;
    private boolean notFirstPrint;

    public SmartPrinter(@NotNull Appendable appendable, @NotNull String indent) {
        Intrinsics.checkNotNullParameter((Object)appendable, (String)"appendable");
        Intrinsics.checkNotNullParameter((Object)indent, (String)"indent");
        this.printer = new Printer(appendable, indent);
    }

    public /* synthetic */ SmartPrinter(Appendable appendable, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string2 = "    ";
        }
        this(appendable, string2);
    }

    public final void print(Object ... objects) {
        Intrinsics.checkNotNullParameter((Object)objects, (String)"objects");
        if (this.notFirstPrint) {
            this.printer.printWithNoIndent(Arrays.copyOf(objects, objects.length));
        } else {
            this.printer.print(Arrays.copyOf(objects, objects.length));
        }
        this.notFirstPrint = true;
    }

    public final void println(Object ... objects) {
        Intrinsics.checkNotNullParameter((Object)objects, (String)"objects");
        if (this.notFirstPrint) {
            this.printer.printlnWithNoIndent(Arrays.copyOf(objects, objects.length));
        } else {
            this.printer.println(Arrays.copyOf(objects, objects.length));
        }
        this.notFirstPrint = false;
    }

    public final void pushIndent() {
        this.printer.pushIndent();
    }

    public final void popIndent() {
        this.printer.popIndent();
    }

    public final int getCurrentIndentInUnits() {
        return this.printer.getCurrentIndentLengthInUnits();
    }

    public final int getIndentUnit() {
        return this.printer.getIndentUnitLength();
    }

    @NotNull
    public String toString() {
        String string2 = this.printer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/utils/SmartPrinter$Companion;", "", "()V", "DEFAULT_INDENT", "", "util.runtime"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

