#! /bin/sh
#
# pagesize.sh -- determine this system's page size, and write a define to
#		 lib/malloc/pagesize.h for the Gnu malloc's valloc().

echo "/*"
echo " * pagesize.h"
echo " *"
echo " * This file is automatically generated by pagesize.sh"
echo " * Do not edit!"
echo " */"
echo ""

if [ -x /bin/pagesize ]; then
	echo "#define getpagesize() `/bin/pagesize`"
else
	echo "#define getpagesize() `./support/pagesize.aux`"
fi

exit 0
