# generated by datamodel-codegen:
#   filename:  jar_schema.json
#   version:   0.26.3

from __future__ import annotations

from enum import Enum
from typing import Optional, Union

from pydantic import BaseModel, ConfigDict, Field, RootModel, StrictStr


class PublicKey(BaseModel):
    """The X509 certificate containing the public key JAR which verifies the signature of the JAR"""

    model_config = ConfigDict(
        populate_by_name=True,
    )
    content: str = Field(
        ...,
        description="Specifies the content of the X509 certificate containing the public key used to verify the signature",
    )


class Signature(BaseModel):
    """Information about the included signature in the JAR file"""

    model_config = ConfigDict(
        populate_by_name=True,
    )
    content: str = Field(
        ...,
        description="Specifies the PKCS7 signature embedded within the JAR file ",
    )
    public_key: PublicKey = Field(
        ...,
        alias="publicKey",
        description="The X509 certificate containing the public key JAR which verifies the signature of the JAR",
    )


class Algorithm(str, Enum):
    """The hashing function used to compute the hash value"""

    SHA256 = "sha256"


class Hash(BaseModel):
    """Specifies the hash algorithm and value encompassing the entire signed archive"""

    model_config = ConfigDict(
        populate_by_name=True,
    )
    algorithm: Algorithm = Field(
        ...,
        description="The hashing function used to compute the hash value",
    )
    value: StrictStr = Field(..., description="The hash value for the archive")


class Archive(BaseModel):
    """Information about the archive associated with the entry"""

    model_config = ConfigDict(
        populate_by_name=True,
    )
    hash: Hash = Field(
        ...,
        description="Specifies the hash algorithm and value encompassing the entire signed archive",
    )
    content: Optional[str] = Field(
        default=None,
        description="Specifies the archive inline within the document",
    )


class Hash1(Hash):
    """Specifies the hash algorithm and value encompassing the entire signed archive"""


class Archive1(BaseModel):
    """Information about the archive associated with the entry"""

    model_config = ConfigDict(
        populate_by_name=True,
    )
    hash: Optional[Hash1] = Field(
        default=None,
        description="Specifies the hash algorithm and value encompassing the entire signed archive",
    )
    content: str = Field(..., description="Specifies the archive inline within the document")


class JarV001Schema(BaseModel):
    """Schema for JAR entries"""

    model_config = ConfigDict(
        populate_by_name=True,
    )
    signature: Optional[Signature] = Field(
        default=None,
        description="Information about the included signature in the JAR file",
    )
    archive: Union[Archive, Archive1] = Field(
        ...,
        description="Information about the archive associated with the entry",
    )


class JarSchema(RootModel[JarV001Schema]):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: JarV001Schema = Field(..., description="Schema for JAR objects", title="JAR Schema")
