.\" Automatically generated by Pandoc 3.6.3
.\"
.TH "SUDOERS" "5" "" "sudo\-rs 0.2.11" "sudo\-rs"
.SH NAME
\f[CR]sudoers\f[R] \- sudo\-compatible security configuration
.SH DESCRIPTION
The \f[CR]sudo\-rs\f[R] policy determines a user\[cq]s sudo privileges.
The policy is driven by the \f[I]/etc/sudoers file\f[R].
The policy format is described in detail in the \f[B]SUDOERS FILE
FORMAT\f[R] section.
.PP
The format used by sudo\-rs is a subset of the one used by the
sudo\-project as maintained by Todd Miller, but syntax\-compatible.
.SS User Authentication
The sudoers security policy requires that most users authenticate
themselves before they can use sudo.
A password is not required if the invoking user is root, if the target
user is the same as the invoking user, or if the policy has disabled
authentication for the user or command.
Unlike \f[CR]su\f[R], when \f[CR]sudo\-rs\f[R] requires authentication,
it validates the invoking user\[cq]s credentials, not the target
user\[cq]s (or root\[cq]s) credentials.
This can be changed via the \f[I]rootpw\f[R] flag, described later.
.PP
\f[CR]sudo\-rs\f[R] uses per\-user timestamp files for credential
caching.
Once a user has been authenticated, a record is written containing the
user\-ID that was used to authenticate, the terminal session ID, the
start time of the session leader (or parent process) and a timestamp
(using a monotonic clock if one is available).
The user may then use sudo without a password for a short period of time
(15 minutes unless overridden by the timestamp_timeout option).
\f[CR]sudo\-rs\f[R] uses a separate record for each terminal, which
means that a user\[cq]s login sessions are authenticated separately.
.SS Logging
By default, \f[CR]sudo\-rs\f[R] logs both successful and unsuccessful
attempts (as well as errors).
Messages are logged to syslog(3).
.SS Command environment
Since environment variables can influence program behavior,
\f[CR]sudo\-rs\f[R] restricts which variables from the user\[cq]s
environment are inherited by the command to be run.
.PP
In \f[CR]sudo\-rs\f[R], the \f[I]env_reset\f[R] flag cannot be disabled.
This causes commands to be executed with a new, minimal environment.
The \f[CR]HOME\f[R], \f[CR]SHELL\f[R], \f[CR]LOGNAME\f[R] and
\f[CR]USER\f[R] environment variables are initialized based on the
target user and the \f[CR]SUDO_*\f[R] variables are set based on the
invoking user.
Additional variables, such as \f[CR]DISPLAY\f[R], \f[CR]PATH\f[R] and
\f[CR]TERM\f[R], are preserved from the invoking user\[cq]s environment
if permitted by the \f[I]env_check\f[R] or \f[I]env_keep\f[R] options.
A few environment variables are treated specially.
If the \f[CR]PATH\f[R] and \f[CR]TERM\f[R] variables are not preserved
from the user\[cq]s environment, they will be set to default values.
The \f[CR]LOGNAME\f[R] and \f[CR]USER\f[R] are handled as a single
entity.
If one of them is preserved (or removed) from the user\[cq]s
environment, the other will be as well.
If \f[CR]LOGNAME\f[R] and \f[CR]USER\f[R] are to be preserved but only
one of them is present in the user\[cq]s environment, the other will be
set to the same value.
This avoids an inconsistent environment where one of the variables
describing the user name is set to the invoking user and one is set to
the target user.
Environment variables with a value beginning with \f[CR]()\f[R] are
removed, as they may be interpreted as functions by the bash shell.
.PP
Environment variables specified by \f[I]env_check\f[R] or
\f[I]env_keep\f[R] may include one or more `*' characters which will
match zero or more characters.
No other wildcard characters are supported.
Other sudoers options may influence the command environment, such as
\f[I]secure_path\f[R].
.PP
Variables in the PAM environment may be merged in to the environment.
If a variable in the PAM environment is already present in the
user\[cq]s environment, the value will only be overridden if the
variable was not preserved by \f[CR]sudo\-rs\f[R].
Variables preserved from the invoking user\[cq]s environment by the
\f[I]env_keep\f[R] list take precedence over those in the PAM
environment.
.PP
Note that the dynamic linker on most operating systems will remove
variables that can control dynamic linking from the environment of
set\-user\-ID executables, including sudo.
Depending on the operating system this may include \f[CR]_RLD*\f[R],
\f[CR]DYLD_*\f[R], \f[CR]LD_*\f[R], \f[CR]LDR_*\f[R],
\f[CR]LIBPATH\f[R], \f[CR]SHLIB_PATH\f[R], and others.
These type of variables are removed from the environment before sudo
even begins execution and, as such, it is not possible for sudo to
preserve them.
.SS Resource limits
sudo uses the operating system\[cq]s native method of setting resource
limits for the target user.
On Linux systems, resource limits are usually set by the
\f[I]pam_limits.so\f[R] PAM module.
On some BSD systems, the \f[I]/etc/login.conf\f[R] file specifies
resource limits for the user.
If there is no system mechanism to set per\-user resource limits, the
command will run with the same limits as the invoking user.
.SH SUDOERS FILE FORMAT
The sudoers file is composed of two types of entries: aliases (basically
variables) and user specifications (which specify who may run what).
.PP
When multiple entries match for a user, they are applied in order.
Where there are multiple matches, the last match is used (which is not
necessarily the most specific match).
.PP
The sudoers file grammar will be described below in Extended
Backus\-Naur Form (EBNF) borrowed from Todd Miller\[cq]s sudoers
documentation.
.SS Quick guide to EBNF
EBNF is a concise and exact way of describing the grammar of a language.
Each EBNF definition is made up of production rules.
E.g.,
.IP
.EX
 symbol ::= definition | alternate1 | alternate2 ...
.EE
.PP
Each production rule references others and thus makes up a grammar for
the language.
EBNF also contains the following operators, which many readers will
recognize from regular expressions.
Do not, however, confuse them with \[lq]wildcard\[rq] characters, which
have different meanings.
.IP
.EX
 ?     Means that the preceding symbol (or group of symbols) is optional.  That is, it may appear once or not at all.

 *     Means that the preceding symbol (or group of symbols) may appear zero or more times.

 +     Means that the preceding symbol (or group of symbols) may appear one or more times.
.EE
.PP
Parentheses may be used to group symbols together.
For clarity, we will use single quotes (\[cq]\[cq]) to designate what is
a verbatim character string (as opposed to a symbol name).
.SS Aliases
There are four kinds of aliases: User_Alias, Runas_Alias, Host_Alias and
Cmnd_Alias.
.IP
.EX
 Alias ::= \[aq]User_Alias\[aq]  User_Alias_Spec (\[aq]:\[aq] User_Alias_Spec)* |
           \[aq]Runas_Alias\[aq] Runas_Alias_Spec (\[aq]:\[aq] Runas_Alias_Spec)* |
           \[aq]Host_Alias\[aq]  Host_Alias_Spec (\[aq]:\[aq] Host_Alias_Spec)* |
           \[aq]Cmnd_Alias\[aq]  Cmnd_Alias_Spec (\[aq]:\[aq] Cmnd_Alias_Spec)* |
           \[aq]Cmd_Alias\[aq]   Cmnd_Alias_Spec (\[aq]:\[aq] Cmnd_Alias_Spec)*

 User_Alias ::= NAME

 User_Alias_Spec ::= User_Alias \[aq]=\[aq] User_List

 Runas_Alias ::= NAME

 Runas_Alias_Spec ::= Runas_Alias \[aq]=\[aq] Runas_List

 Host_Alias ::= NAME

 Host_Alias_Spec ::= Host_Alias \[aq]=\[aq] Host_List

 Cmnd_Alias ::= NAME

 Cmnd_Alias_Spec ::= Cmnd_Alias \[aq]=\[aq] Cmnd_List

 NAME ::= [A\-Z]([A\-Z][0\-9]_)*
.EE
.PP
Each alias definition is of the form
.IP
.EX
 Alias_Type NAME = item1, item2, ...
.EE
.PP
where \f[I]Alias_Type\f[R] is one of User_Alias, Runas_Alias,
Host_Alias, or Cmnd_Alias.
A NAME is a string of uppercase letters, numbers, and underscore
characters (\[cq]_\[cq]).
A NAME must start with an uppercase letter.
It is possible to put several alias definitions of the same type on a
single line, joined by a colon (`:').
E.g.,
.IP
.EX
 Alias_Type NAME = item1, item2, item3 : NAME = item4, item5
.EE
.PP
The definitions of what constitutes a valid alias member follow.
.IP
.EX
 User_List ::= User |
               User \[aq],\[aq] User_List

 User ::= \[aq]!\[aq]* user name |
          \[aq]!\[aq]* #user\-ID |
          \[aq]!\[aq]* %group |
          \[aq]!\[aq]* %#group\-ID |
          \[aq]!\[aq]* User_Alias
.EE
.PP
A User_List is made up of one or more user names, user\-IDs (prefixed
with `#'), system group names and IDs (prefixed with `%' and `%#'
respectively) and User_Aliases.
Each list item may be prefixed with zero or more `!' operators.
An odd number of `!' operators negate the value of the item; an even
number just cancel each other out.
.IP
.EX
 Runas_List ::= Runas_Member |
                Runas_Member \[aq],\[aq] Runas_List

 Runas_Member ::= \[aq]!\[aq]* user name |
                  \[aq]!\[aq]* #user\-ID |
                  \[aq]!\[aq]* %group |
                  \[aq]!\[aq]* %#group\-ID |
                  \[aq]!\[aq]* Runas_Alias
.EE
.PP
A Runas_List is similar to a User_List except that instead of
User_Aliases it can contain Runas_Aliases.
Note that user names and groups are matched as strings.
In other words, two users (groups) with the same user (group) ID are
considered to be distinct.
If you wish to match all user names with the same user\-ID (e.g., root
and toor), you can use a user\-ID instead of a name (\f[CR]#0\f[R] in
the example given).
.IP
.EX
 Host_List ::= Host |
               Host \[aq],\[aq] Host_List

 Host ::= \[aq]!\[aq]* host name |
          \[aq]!\[aq]* Host_Alias
.EE
.PP
A Host_List is made up of one or more host names.
Again, the value of an item may be negated with the `!' operator.
.IP
.EX
 Cmnd_List ::= Cmnd |
               Cmnd \[aq],\[aq] Cmnd_List

 command name ::= file name |
                  file name args |
                  file name \[aq]\[dq]\[dq]\[aq]

 Cmnd ::= \[aq]!\[aq]* command name |
          \[aq]!\[aq]* directory |
          \[aq]!\[aq]* Cmnd_Alias
          \[aq]!\[aq]* \[dq]list\[dq]
          \[aq]!\[aq]* \[dq]sudoedit\[dq] [file name]
.EE
.PP
A Cmnd_List is a list of one or more command names, directories, and
other aliases.
A command name is a fully qualified file name which may include
shell\-style wildcards (see the Wildcards section below).
A simple file name allows the user to run the command with any arguments
they wish.
However, you may also specify command line arguments (which in sudo\-rs
may \f[I]not\f[R] include wildcards).
Alternately, you can specify \[lq]\[rq] to indicate that the command may
only be run without command line arguments.
A directory is a fully qualified path name ending in a `/'.
When you specify a directory in a Cmnd_List, the user will be able to
run any file within that directory (but not in any sub\-directories
therein).
.PP
If a Cmnd has associated command line arguments, then the arguments in
the Cmnd must match exactly those given by the user on the command line.
Note that the following characters must be escaped with a `\[rs]' if
they are used in command arguments: `,', `:', `=', `\[rs]'.
.PP
There are two commands built into sudo itself: \[lq]list\[rq] and
\[lq]sudoedit\[rq].
Unlike other commands, these two must be specified in the sudoers file
without a leading path.
.PP
The \[lq]list\[rq] built\-in can be used to permit a user to list
another user\[cq]s privileges with sudo\[cq]s \-U option.
For example, \[lq]sudo \-l \-U otheruser\[rq].
A user with the \[lq]list\[rq] privilege is able to list another
user\[cq]s privileges even if they don\[cq]t have permission to run
commands as that user.
By default, only root or a user with the ability to run any command as
either root or the specified user on the current host may use the \-U
option.
No command line arguments may be specified with the \[lq]list\[rq]
built\-in.
.PP
The \[lq]sudoedit\[rq] built\-in is used to permit a user to run sudo
with the \-e option (or as sudoedit).
It may take command line arguments just as a normal command does.
Unlike other commands, \[lq]sudoedit\[rq] is built into sudo itself and
must be specified in the sudoers file without a leading path.
If a leading path is present, for example /usr/bin/sudoedit, this will
not give the user permissions to use sudoedit.
If no arguments are provided, \[lq]sudoedit\[rq] will give the user the
permission to edit any files; if an argument is present it must be an
absolute path name that does not contain symbolic links, or the command
will not be matched.
.SS Defaults
Certain configuration options may be changed from their default values
at run\-time via one or more Default_Entry lines.
These may affect all users on any host, all users on a specific host, a
specific user, a specific command, or commands being run as a specific
user.
Note that per\-command entries may not include command line arguments.
If you need to specify arguments, define a Cmnd_Alias and reference that
instead.
.IP
.EX
 Default_Type ::= \[aq]Defaults\[aq] |
                  \[aq]Defaults\[aq] \[aq]\[at]\[aq] Host_List |
                  \[aq]Defaults\[aq] \[aq]:\[aq] User_List |
                  \[aq]Defaults\[aq] \[aq]!\[aq] Cmnd_List |
                  \[aq]Defaults\[aq] \[aq]>\[aq] Runas_List

 Default_Entry ::= Default_Type Parameter_List

 Parameter_List ::= Parameter |
                    Parameter \[aq],\[aq] Parameter_List

 Parameter ::= Parameter \[aq]=\[aq] Value |
               Parameter \[aq]+=\[aq] Value |
               Parameter \[aq]\-=\[aq] Value |
               \[aq]!\[aq]* Parameter
.EE
.PP
Parameters may be flags, integer values, strings, or lists.
Flags are implicitly boolean and can be turned off via the `!' operator.
Some integer, string and list parameters may also be used in a boolean
context to disable them.
Values may be enclosed in double quotes (\[lq]\[lq]) when they contain
multiple words.
Special characters may be escaped with a backslash (`\[rs]').
.PP
To include a literal backslash character in a command line argument you
must escape the backslash twice.
For example, to match `\[rs]n' as part of a command line argument, you
must use `\[rs]\[rs]\[rs]\[rs]n' in the sudoers file.
This is due to there being two levels of escaping, one in the sudoers
parser itself and another when command line arguments are matched by the
fnmatch(3) function.
.PP
Lists have two additional assignment operators, \f[I]+=\f[R] and
\f[I]\-=\f[R].
These operators are used to add to and delete from a list respectively.
It is not an error to use the \-= operator to remove an element that
does not exist in a list.
.PP
Defaults entries are parsed in the following order: generic, host, user,
and runas Defaults are processed in the order they appear, with
per\-command defaults being processed in a second pass after that.
.PP
See \f[B]SUDOERS OPTIONS\f[R] for a list of supported Defaults
parameters.
.SS User specification
.IP
.EX
 User_Spec ::= User_List Host_List \[aq]=\[aq] Cmnd_Spec_List \[rs]
               (\[aq]:\[aq] Host_List \[aq]=\[aq] Cmnd_Spec_List)*

 Cmnd_Spec_List ::= Cmnd_Spec |
                    Cmnd_Spec \[aq],\[aq] Cmnd_Spec_List

 Cmnd_Spec ::= Runas_Spec? Chdir_Spec? Tag_Spec* Cmnd

 Runas_Spec ::= \[aq](\[aq] Runas_List? (\[aq]:\[aq] Runas_List)? \[aq])\[aq]

 Chdir_Spec ::= \[aq]CWD=directory\[aq]

 Tag_Spec ::= (\[aq]PASSWD:\[aq] | \[aq]NOPASSWD:\[aq] |
               \[aq]SETENV:\[aq] | \[aq]NOSETENV:\[aq]
               \[aq]EXEC:\[aq]   | \[aq]NOEXEC\[aq])

 AppArmor_Spec ::= \[aq]APPARMOR_PROFILE=profile\[aq]
.EE
.PP
A user specification determines which commands a user may run (and as
what user) on specified hosts.
By default, commands are run as root, but this can be changed on a
per\-command basis.
.PP
The basic structure of a user specification is \[lq]who where =
(as_whom) what\[rq].
Let\[cq]s break that down into its constituent parts:
.SS Runas_Spec
A Runas_Spec determines the user and/or the group that a command may be
run as.
A fully\-specified Runas_Spec consists of two Runas_Lists (as defined
above) separated by a colon (`:') and enclosed in a set of parentheses.
The first Runas_List indicates which users the command may be run as via
the \-u option.
The second defines a list of groups that may be specified via the \-g
option (in addition to any of the target user\[cq]s groups).
If both Runas_Lists are specified, the command may be run with any
combination of users and groups listed in their respective Runas_Lists.
If only the first is specified, the command may be run as any user in
the list and, optionally, with any group the target user belongs to.
If the first Runas_List is empty but the second is specified, the
command may be run as the invoking user with the group set to any listed
in the Runas_List.
If both Runas_Lists are empty, the command may only be run as the
invoking user and the group, if specified, must be one that the invoking
user is a member of.
If no Runas_Spec is specified, the command may only be run as root and
the group, if specified, must be one that root is a member of.
.PP
A Runas_Spec sets the default for the commands that follow it.
What this means is that for the entry:
.IP
.EX
 dgb     boulder = (operator) /bin/ls, /bin/kill, /usr/bin/lprm
.EE
.PP
The user dgb may run /bin/ls, /bin/kill, and /usr/bin/lprm on the host
boulder\[em]but only as operator.
E.g.,
.IP
.EX
 $ sudo \-u operator /bin/ls
.EE
.PP
It is also possible to override a Runas_Spec later on in an entry.
If we modify the entry like so:
.IP
.EX
 dgb     boulder = (operator) /bin/ls, (root) /bin/kill, /usr/bin/lprm
.EE
.PP
Then user dgb is now allowed to run /bin/ls as operator, but /bin/kill
and /usr/bin/lprm as root.
.PP
We can extend this to allow dgb to run /bin/ls with either the user or
group set to operator:
.IP
.EX
 dgb     boulder = (operator : operator) /bin/ls, (root) /bin/kill,\[rs]
         /usr/bin/lprm
.EE
.PP
Note that while the group portion of the Runas_Spec permits the user to
run as command with that group, it does not force the user to do so.
If no group is specified on the command line, the command will run with
the group listed in the target user\[cq]s password database entry.
The following would all be permitted by the sudoers entry above:
.IP
.EX
 $ sudo \-u operator /bin/ls
 $ sudo \-u operator \-g operator /bin/ls
 $ sudo \-g operator /bin/ls
.EE
.PP
In the following example, user tcm may run commands that access a modem
device file with the dialer group.
.IP
.EX
 tcm     boulder = (:dialer) /usr/bin/tip, /usr/bin/cu,\[rs]
         /usr/local/bin/minicom
.EE
.PP
Note that in this example only the group will be set, the command still
runs as user tcm.
E.g.
.IP
.EX
 $ sudo \-g dialer /usr/bin/cu
.EE
.PP
Multiple users and groups may be present in a Runas_Spec, in which case
the user may select any combination of users and groups via the \-u and
\-g options.
In this example:
.IP
.EX
 alan    ALL = (root, bin : operator, system) ALL
.EE
.PP
user alan may run any command as either user root or bin, optionally
setting the group to operator or system.
.SS Chdir_Spec
The working directory that the command will be run in can be specified
using the CWD setting.
The directory must be a fully\-qualified path name beginning with a `/'
or `\[ti]' character, or the special value \[lq]*\[rq].
A value of \[lq]*\[rq] indicates that the user may specify the working
directory by running sudo with the \-D option.
By default, commands are run from the invoking user\[cq]s current
working directory, unless the \-i option is given.
Path names of the form \[ti]user/path/name are interpreted as being
relative to the named user\[cq]s home directory.
If the user name is omitted, the path will be relative to the runas
user\[cq]s home directory.
.SS Tag_Spec
A command may have zero or more tags associated with it.
The following tag values are supported: PASSWD, NOPASSWD, SETENV, and
NOSETENV.
Once a tag is set on a Cmnd, subsequent Cmnds in the Cmnd_Spec_List,
inherit the tag unless it is overridden by the opposite tag (in other
words, PASSWD overrides NOPASSWD and NOSETENV overrides SETENV).
.SS EXEC and NOEXEC
On Linux systems, the NOEXEC tag can be used to prevent an executable
from running further commands itself.
.PP
In the following example, user aaron may run /usr/bin/more and
/usr/bin/vi but shell escapes will be disabled.
.IP
.EX
    aaron   shanty = NOEXEC: /usr/bin/more, /usr/bin/vi
.EE
.PP
See the \f[I]Preventing shell escapes\f[R] section below for more
details on how NOEXEC works and whether or not it suits your purpose.
.SS PASSWD and NOPASSWD
By default, sudo requires that a user authenticate before running a
command.
This behavior can be modified via the NOPASSWD tag.
Like a Runas_Spec, the NOPASSWD tag sets a default for the commands that
follow it in the Cmnd_Spec_List.
Conversely, the PASSWD tag can be used to reverse things.
For example:
.IP
.EX
   queen     rushmore = NOPASSWD: /bin/kill, /bin/ls, /usr/bin/lprm
.EE
.PP
would allow the user queen to run /bin/kill, /bin/ls, and /usr/bin/lprm
as root on the machine \[lq]rushmore\[rq] without authenticating
himself.
If we only want queen to be able to run /bin/kill without a password the
entry would be:
.IP
.EX
   queen     rushmore = NOPASSWD: /bin/kill, PASSWD: /bin/ls, /usr/bin/lprm
.EE
.PP
By default, if the NOPASSWD tag is applied to any of a user\[cq]s
entries for the current host, the user will be able to run \[lq]sudo
\-l\[rq] without a password.
Additionally, a user may only run \[lq]sudo \-v\[rq] without a password
if all of the user\[cq]s entries for the current host have the NOPASSWD
tag.
.SS SETENV and NOSETENV
These tags override the value of the setenv flag on a per\-command
basis.
Note that if SETENV has been set for a command, the user may disable the
env_reset flag from the command line via the \-E option.
Additionally, environment variables set on the command line are not
subject to the restrictions imposed by env_check, env_delete, or
env_keep.
As such, only trusted users should be allowed to set variables in this
manner.
If the command matched is ALL, the SETENV tag is implied for that
command; this default may be overridden by use of the NOSETENV tag.
.SS AppArmor_Spec
When sudo\-rs is built with support for AppArmor, sudoers file entries
may specify an AppArmor profile that should be used to confine a
command.
.PP
If an AppArmor profile is specified with the command, it will override
any default values specified in sudoers.
Appropriate profile transition rules must be defined to support the
profile change specified for a user.
.PP
AppArmor profiles can be specified in any way that complies with the
rules of \f[CR]aa_change_profile(2)\f[R].
.SS Wildcards
sudo allows shell\-style wildcards (aka meta or glob characters) to be
used in host names, path names, and command line arguments in the
sudoers file.
Wildcard matching is done via the glob(3) and fnmatch(3) functions as
specified by IEEE Std 1003.1 (\[lq]POSIX.1\[rq]).
.IP
.EX
 *         Matches any set of zero or more characters (including white space).

 ?         Matches any single character (including white space).

 [...]     Matches any character in the specified range.

 [!...]    Matches any character not in the specified range.

 \[rs]x        For any character \[oq]x\[cq], evaluates to \[oq]x\[cq].  This is used to escape special characters such as: \[oq]*\[cq], \[oq]?\[cq], \[oq][\[cq], and \[oq]]\[cq].
.EE
.PP
Note that these are not regular expressions.
Unlike a regular expression there is no way to match one or more
characters within a range.
.PP
Wildcards in command line arguments are not supported\[em]using these in
original versions of sudo was usually a sign of mis\-configuration and
consequently sudo\-rs simply forbids using them.
.SS Including other files from within sudoers
It is possible to include other sudoers files from within the sudoers
file currently being parsed using the \f[I]\[at]include\f[R] and
\f[I]\[at]includedir\f[R] directives.
For compatibility with Todd Miller\[cq]s sudo versions prior to 1.9.1,
\f[I]#include\f[R] and \f[I]#includedir\f[R] are also accepted.
.PP
An include file can be used, for example, to keep a site\-wide sudoers
file in addition to a local, per\-machine file.
For the sake of this example the site\-wide sudoers file will be
/etc/sudoers and the per\-machine one will be /etc/sudoers.local.
To include /etc/sudoers.local from within /etc/sudoers one would use the
following line in /etc/sudoers:
.IP
.EX
     \[at]include /etc/sudoers.local
.EE
.PP
When sudo reaches this line it will suspend processing of the current
file (/etc/sudoers) and switch to /etc/sudoers.local.
Upon reaching the end of /etc/sudoers.local, the rest of /etc/sudoers
will be processed.
Files that are included may themselves include other files.
A hard limit of 128 nested include files is enforced to prevent include
file loops.
.PP
The path to the include file may contain white space if it is escaped
with a backslash (`\[rs]').
Alternately, the entire path may be enclosed in double quotes
(\[lq]\[lq]), in which case no escaping is necessary.
To include a literal backslash in the path, `\[rs]\[rs]' should be used.
If the path to the include file is not fully\-qualified (does not begin
with a `/'), it must be located in the same directory as the sudoers
file it was included from.
For example, if /etc/sudoers contains the line:
.IP
.EX
     \[at]include sudoers.local
.EE
.PP
The \[at]includedir directive can be used to create a sudoers.d
directory that the system package manager can drop sudoers file rules
into as part of package installation.
For example, given:
.IP
.EX
     \[at]includedir /etc/sudoers.d
.EE
.PP
sudo will suspend processing of the current file and read each file in
/etc/sudoers.d, skipping file names that end in `\[ti]' or contain a `.'
character to avoid causing problems with package manager or editor
temporary/backup files.
Files are parsed in sorted lexical order.
That is, /etc/sudoers.d/01_first will be parsed before
/etc/sudoers.d/10_second.
Be aware that because the sorting is lexical, not numeric,
/etc/sudoers.d/1_whoops would be loaded after /etc/sudoers.d/10_second.
Using a consistent number of leading zeroes in the file names can be
used to avoid such problems.
After parsing the files in the directory, control returns to the file
that contained the \[at]includedir directive.
.PP
Note that unlike files included via \[at]include, visudo will not edit
the files in a \[at]includedir directory unless one of them contains a
syntax error.
It is still possible to run visudo with the \-f flag to edit the files
directly, but this will not catch the redefinition of an alias that is
also present in a different file.
.SS Other special characters and reserved words
The pound sign (`#') is used to indicate a comment (unless it is part of
a #include directive or unless it occurs in the context of a user name
and is followed by one or more digits, in which case it is treated as a
user\-ID).
Both the comment character and any text after it, up to the end of the
line, are ignored.
.PP
The reserved word \f[I]ALL\f[R] is a built\-in alias that always causes
a match to succeed.
It can be used wherever one might otherwise use a Cmnd_Alias,
User_Alias, Runas_Alias, or Host_Alias.
Attempting to define an alias named ALL will result in a syntax error.
Please note that using ALL can be dangerous since in a command context,
it allows the user to run any command on the system.
.PP
An exclamation point (`!') can be used as a logical not operator in a
list or alias as well as in front of a Cmnd.
This allows one to exclude certain values.
For the `!' operator to be effective, there must be something for it to
exclude.
For example, to match all users except for root one would use:
.IP
.EX
     ALL,!root
.EE
.PP
If the ALL, is omitted, as in:
.IP
.EX
     !root
.EE
.PP
it would explicitly deny root but not match any other users.
This is different from a true \[lq]negation\[rq] operator.
.PP
Note, however, that using a `!' in conjunction with the built\-in ALL
alias to allow a user to run \[lq]all but a few\[rq] commands rarely
works as intended (see SECURITY NOTES below).
.PP
White space between elements in a list as well as special syntactic
characters in a User Specification (`=', `:', `(', `)') is optional.
.PP
The following characters must be escaped with a backslash (`\[rs]') when
used as part of a word (e.g., a user name or host name): `!', `=', `:',
`,', `(', `)', `\[rs]'.
.SS SUDOERS OPTIONS
sudo\[cq]s behavior can be modified by Default_Entry lines, as explained
earlier.
A list of all supported Defaults parameters, grouped by type, are listed
below.
.SS Boolean Flags:
.IP \[bu] 2
noexec
.RS 2
.PP
If set, all commands run via sudo will behave as if the NOEXEC tag has
been set, unless overridden by an EXEC tag.
See the description of EXEC and NOEXEC as well as the Preventing shell
escapes section at the end of this manual.
This flag is off by default.
.RE
.IP \[bu] 2
noninteractive_auth If set, authentication will be attempted even in
non\-interactive mode (when sudo\[cq]s \-n option is specified).
This allows authentication methods that don\[cq]t require user
interaction to succeed.
Authentication methods that require input from the user\[cq]s terminal
will still fail.
If disabled, authentication will not be attempted in non\-interactive
mode.
This flag is off by default.
.IP \[bu] 2
env_editor
.RS 2
.PP
If set, visudo will use the value of the SUDO_EDITOR, VISUAL or EDITOR
environment variables before falling back on the default editor list.
Note that visudo is typically run as root so this flag may allow a user
with visudo privileges to run arbitrary commands as root without
logging.
An alternative is to place a colon\-separated list of \[lq]safe\[rq]
editors int the editor setting.
visudo will then only use SUDO_EDITOR, VISUAL or EDITOR if they match a
value specified in editor.
If the env_reset flag is enabled, the SUDO_EDITOR, VISUAL and/or EDITOR
environment variables must be present in the env_keep list for the
env_editor flag to function when visudo is invoked via sudo.
This flag is on by default.
.RE
.IP \[bu] 2
pwfeedback
.RS 2
.PP
By default, sudo reads the password like most other Unix programs, by
turning off echo until the user hits the return (or enter) key.
Some users become confused by this as it appears to them that sudo has
hung at this point.
When pwfeedback is set, sudo will provide visual feedback when the user
presses a key.
Note that this does have a security impact as an onlooker may be able to
determine the length of the password being entered.
This flag is off by default.
.RE
.IP \[bu] 2
rootpw
.RS 2
.PP
If set, sudo will prompt for the root password instead of the password
of the invoking user when running a command or editing a file.
This flag is off by default.
.RE
.IP \[bu] 2
setenv
.RS 2
.PP
Allow the user to set environment variables set via the command line
that are not subject to the restrictions imposed by env_check,
env_delete, or env_keep.
As such, only trusted users should be allowed to set variables in this
manner.
This flag is off by default.
.RE
.IP \[bu] 2
targetpw
.RS 2
.PP
If set, sudo will prompt for the password of the user specified by the
\-u option (defaults to root) instead of the password of the invoking
user when running a command or editing a file.
Note that this flag precludes the use of a user\-ID not listed in the
passwd database as an argument to the \-u option.
This flag is off by default.
.RE
.IP \[bu] 2
umask_override
.RS 2
.PP
If set, sudo will set the umask as specified in the sudoers file without
modification.
This makes it possible to specify a umask in the sudoers file that is
more permissive than the user\[cq]s own umask.
If umask_override is not set, sudo will set the umask to be the union of
the user\[cq]s umask and what is specified in sudoers.
This flag is off by default.
.RE
.IP \[bu] 2
use_pty
.RS 2
.PP
If set, and sudo is running in a terminal, the command will be run in a
pseudo\-terminal (even if no I/O logging is being done).
If the sudo process is not attached to a terminal, use_pty has no
effect.
.PP
A malicious program run under sudo may be capable of injecting commands
into the user\[cq]s terminal or running a background process that
retains access to the user\[cq]s terminal device even after the main
program has finished executing.
By running the command in a separate pseudo\-terminal, this attack is no
longer possible.
This flag is on by default.
.RE
.SS Integers:
.IP \[bu] 2
passwd_tries
.RS 2
.PP
The number of tries a user gets to enter his/her password before sudo
logs the failure and exits.
The default is 3.
.RE
.SS Integers that can be used in a boolean context:
.IP \[bu] 2
timestamp_timeout
.RS 2
.PP
Number of minutes that can elapse before sudo will ask for a passwd
again.
The timeout may include a fractional component if minute granularity is
insufficient, for example 2.5.
The default is 15.
Set this to 0 to always prompt for a password.
.RE
.IP \[bu] 2
umask
.RS 2
.PP
File mode creation mask to use when running the command.
Negate this option or set it to 0777 to prevent sudo from changing the
umask.
Unless the umask_override flag is set, the actual umask will be the
union of the user\[cq]s umask and the value of the umask setting, which
defaults to 0022.
This guarantees that sudo never lowers the umask when running a command.
.PP
If umask is explicitly set, it will override any umask setting in PAM.
If umask is not set, the umask specified by PAM will take precedence.
The umask setting in PAM is not used for sudoedit, which does not create
a new PAM session.
.RE
.SS Strings
.IP \[bu] 2
editor
.RS 2
.PP
A colon (`:') separated list of editor path names used by
\f[B]sudoedit\f[R] and \f[B]visudo\f[R].
For \f[B]sudoedit\f[R], this list is used to find an editor when none of
the SUDO_EDITOR, VISUAL or EDITOR environment variables are set to an
editor that exists and is executable.
For \f[B]visudo\f[R], it is used as a white list of allowed editors;
\f[B]visudo\f[R] will choose the editor that matches the user\[cq]s
SUDO_EDITOR, VISUAL or EDITOR environment variable if possible, or the
first editor in the list that exists and is executable if not.
Unless invoked as \f[B]sudoedit\f[R], sudo does not preserve the
SUDO_EDITOR, VISUAL or EDITOR environment variables unless they are
present in the \f[B]env_keep\f[R] list.
The default on Linux is
\f[I]/usr/bin/editor:/usr/bin/nano:/usr/bin/vi\f[R].
On FreeBSD the default is \f[I]/usr/bin/vi\f[R].
.RE
.SS Strings that can be used in a boolean context:
.IP \[bu] 2
apparmor_profile
.RS 2
.PP
The default AppArmor profile to transition into when executing a
command.
The default apparmor_profile can be overridden for individual sudoers
entries by specifying the APPARMOR_PROFILE option.
This option is only available when sudo\-rs is built with AppArmor
support.
This option is not set by default.
.RE
.IP \[bu] 2
secure_path
.RS 2
.PP
If set, sudo will use this value in place of the user\[cq]s PATH
environment variable.
This option can be used to reset the PATH to a known good value that
contains directories for system administrator commands such as
/usr/sbin.
This option is not set by default.
.RE
.SS Lists that can be used in a boolean context:
.IP \[bu] 2
env_check
.RS 2
.PP
Environment variables to be removed from the user\[cq]s environment
unless they are considered \[lq]safe\[rq].
For all variables except TZ, \[lq]safe\[rq] means that the
variable\[cq]s value does not contain any `%' or `/' characters.
This can be used to guard against printf\-style format vulnerabilities
in poorly\-written programs.
The TZ variable is considered unsafe if any of the following are true:
.IP
.EX
                 •  It consists of a fully\-qualified path name, optionally prefixed with a colon (\[oq]:\[cq]), that does not match the location of the zoneinfo directory.

                 •  It contains a .. path element.

                 •  It contains white space or non\-printable characters.

                 •  It is longer than the value of PATH_MAX.
.EE
.RE
.PP
The argument may be a double\-quoted, space\-separated list or a single
value without double\-quotes.
The list can be replaced, added to, deleted from, or disabled by using
the =, +=, \-=, and !
operators respectively.
Regardless of whether the env_reset option is enabled or disabled,
variables specified by env_check will be preserved in the environment if
they pass the aforementioned check.
The global list of environment variables to check is displayed when sudo
is run by root with the \-V option.
.IP \[bu] 2
env_keep
.RS 2
.PP
Environment variables to be preserved in the user\[cq]s environment when
the env_reset option is in effect.
This allows fine\-grained control over the environment sudo\-spawned
processes will receive.
The argument may be a double\-quoted, space\-separated list or a single
value without double\-quotes.
The list can be replaced, added to, deleted from, or disabled by using
the =, +=, \-=, and !
operators respectively.
The global list of variables to keep is displayed when sudo is run by
root with the \-V option.
.PP
Preserving the HOME environment variable has security implications since
many programs use it when searching for configuration or data files.
Adding HOME to env_keep may enable a user to run unrestricted commands
via sudo and is strongly discouraged.
Users wishing to edit files with sudo should run \f[B]sudoedit\f[R] (or
\f[B]sudo \-e\f[R]) to get their accustomed editor configuration instead
of invoking the editor directly.
.RE
.SS LOG FORMAT
sudo\-rs logs events via syslog(3).
.SS FILES
.IP
.EX
 /etc/sudoers\-rs           List of who can run what (for co\-existence of sudo\-rs and Todd Miller\[aq]s sudo)

 /etc/sudoers              List of who can run what (sudo\-compatible)

 /run/sudo/ts              Directory containing timestamps for the sudoers security policy
.EE
.SS SECURITY NOTES
.SS Limitations of the `!' operator
It is generally not effective to \[lq]subtract\[rq] commands from ALL
using the `!' operator.
A user can trivially circumvent this by copying the desired command to a
different name and then executing that.
For example:
.IP
.EX
 bill    ALL = ALL, !SU, !SHELLS
.EE
.PP
Doesn\[cq]t really prevent bill from running the commands listed in SU
or SHELLS since he can simply copy those commands to a different name,
or use a shell escape from an editor or other program.
Therefore, these kind of restrictions should be considered advisory at
best (and reinforced by policy).
.PP
In general, if a user has sudo ALL there is nothing to prevent them from
creating their own program that gives them a root shell (or making their
own copy of a shell) regardless of any `!' elements in the user
specification.
.SS Security implications of \f[CR]fast_glob\f[R]
sudo\-rs uses \[ga]fast_glob, which further means it is not possible to
reliably negate commands where the path name includes globbing (aka
wildcard) characters.
This is because the Rust library\[cq]s fnmatch function cannot resolve
relative paths.
While this is typically only an inconvenience for rules that grant
privileges, it can result in a security issue for rules that subtract or
revoke privileges.
.PP
For example, given the following sudoers file entry:
.IP
.EX
 john    ALL = /usr/bin/passwd [a\-zA\-Z0\-9]*, /usr/bin/chsh [a\-zA\-Z0\-9]*,\[rs]
               /usr/bin/chfn [a\-zA\-Z0\-9]*, !/usr/bin/* root
.EE
.PP
User john can still run /usr/bin/passwd root if fast_glob is enabled by
changing to /usr/bin and running ./passwd root instead.
.SS Preventing shell escapes
Once sudo executes a program, that program is free to do whatever it
pleases, including run other programs.
This can be a security issue since it is not uncommon for a program to
allow shell escapes, which lets a user bypass sudo\[cq]s access control
and logging.
Common programs that permit shell escapes include shells (obviously),
editors, paginators (such as \f[I]less\f[R]), mail, and terminal
programs.
.PP
On Linux, sudo\-rs has sudo\[cq]s \f[B]noexec\f[R] functionality, based
on a seccomp() filter.
Programs that are run in \f[B]noexec\f[R] mode cannot run other
programs.
The implementation in sudo\-rs is different than in Todd Miller\[cq]s
sudo, and should also work on statically linked binaries.
.PP
Note that restricting shell escapes is not a panacea.
Programs running as root are still capable of many potentially hazardous
operations (such as changing or overwriting files) that could lead to
unintended privilege escalation.
NOEXEC is also not a protection against malicious programs.
It doesn\[cq]t prevent mapping memory as executable, nor does it protect
against future syscalls that can do an exec() like the proposed
\f[CR]io_uring\f[R] exec feature in Linux.
And it also doesn\[cq]t protect against honest programs that
intentionally or not allow the user to write to /proc/self/mem for the
same reasons as that it doesn\[cq]t protect against malicious programs.
You should always try out if \f[B]noexec\f[R] indeed prevents shell
escapes for the programs it is intended to be used with.
.SS Timestamp file checks
sudo\-rs will check the ownership of its timestamp directory
(/run/sudo/ts by default) and ignore the directory\[cq]s contents if it
is not owned by root or if it is writable by a user other than root.
.PP
While the timestamp directory should be cleared at reboot time, to avoid
potential problems, sudo\-rs will ignore timestamp files that date from
before the machine booted on systems where the boot time is available.
.PP
Some systems with graphical desktop environments allow unprivileged
users to change the system clock.
Since sudo\-rs relies on the system clock for timestamp validation, it
may be possible on such systems for a user to run sudo for longer than
\f[I]timestamp_timeout\f[R] by setting the clock back.
To combat this, \f[CR]sudo\-rs\f[R] uses a monotonic clock (which never
moves backwards) for its timestamps if the system supports it.
sudo\-rs will not honor timestamps set far in the future.
.SS SEE ALSO
su(1), fnmatch(3), glob(3), sudo(8), visudo(8)
.SS CAVEATS
The sudoers file should always be edited by the visudo utility which
locks the file and checks for syntax errors.
If sudoers contains syntax errors, you may lock yourself out of being
able to use sudo.
.SS BUGS
If you feel you have found a bug in sudo\-rs, please submit a bug report
at https://github.com/trifectatechfoundation/sudo\-rs/issues/
.SH AUTHORS
This man page is a modified version of the sudoers(5) documentation
written by Todd Miller; see https://www.sudo.ws/ for the original.
.SS DISCLAIMER
sudo\-rs is provided \[lq]AS IS\[rq] and any express or implied
warranties, including, but not limited to, the implied warranties of
merchantability and fitness for a particular purpose are disclaimed.
