   /*******************************************************/
   /*      "C" Language Integrated Production System      */
   /*                                                     */
   /*             CLIPS Version 6.40  07/17/18            */
   /*                                                     */
   /*          MISCELLANEOUS FUNCTIONS HEADER FILE        */
   /*******************************************************/

/*************************************************************/
/* Purpose:                                                  */
/*                                                           */
/* Principal Programmer(s):                                  */
/*      Gary D. Riley                                        */
/*                                                           */
/* Contributing Programmer(s):                               */
/*                                                           */
/* Revision History:                                         */
/*                                                           */
/*      6.23: Correction for FalseSymbol/TrueSymbol. DR0859  */
/*                                                           */
/*            Corrected compilation errors for files         */
/*            generated by constructs-to-c. DR0861           */
/*                                                           */
/*            Changed name of variable exp to theExp         */
/*            because of Unix compiler warnings of shadowed  */
/*            definitions.                                   */
/*                                                           */
/*      6.24: Removed CONFLICT_RESOLUTION_STRATEGIES,        */
/*            DYNAMIC_SALIENCE, INCREMENTAL_RESET,           */
/*            LOGICAL_DEPENDENCIES, IMPERATIVE_METHODS       */
/*            INSTANCE_PATTERN_MATCHING,                     */
/*            IMPERATIVE_MESSAGE_HANDLERS, and               */
/*            AUXILIARY_MESSAGE_HANDLERS compilation flags.  */
/*                                                           */
/*            Renamed BOOLEAN macro type to intBool.         */
/*                                                           */
/*      6.30: Support for long long integers.                */
/*                                                           */
/*            Used gensprintf instead of sprintf.            */
/*                                                           */
/*            Removed conditional code for unsupported       */
/*            compilers/operating systems.                   */
/*                                                           */
/*            Renamed EX_MATH compiler flag to               */
/*            EXTENDED_MATH_FUNCTIONS.                       */
/*                                                           */
/*            Combined BASIC_IO and EXT_IO compilation       */
/*            flags into the IO_FUNCTIONS compilation flag.  */
/*                                                           */
/*            Removed code associated with HELP_FUNCTIONS    */
/*            and EMACS_EDITOR compiler flags.               */
/*                                                           */
/*            Added operating-system function.               */
/*                                                           */
/*            Added new function (for future use).           */
/*                                                           */
/*            Added const qualifiers to remove C++           */
/*            deprecation warnings.                          */
/*                                                           */
/*      6.31: Added local-time and gm-time functions.        */
/*                                                           */
/*      6.40: Refactored code to reduce header dependencies  */
/*            in sysdep.c.                                   */
/*                                                           */
/*            Removed LOCALE definition.                     */
/*                                                           */
/*            Pragma once and other inclusion changes.       */
/*                                                           */
/*            Added support for booleans with <stdbool.h>.   */
/*                                                           */
/*            Removed use of void pointers for specific      */
/*            data structures.                               */
/*                                                           */
/*            UDF redesign.                                  */
/*                                                           */
/*            Added get-error, set-error, and clear-error    */
/*            functions.                                     */
/*                                                           */
/*************************************************************/

#ifndef _H_miscfun

#pragma once

#define _H_miscfun

   void                           MiscFunctionDefinitions(Environment *);
   void                           ExitCommand(Environment *,UDFContext *,UDFValue *);
   void                           CreateFunction(Environment *,UDFContext *,UDFValue *);
   void                           SetgenFunction(Environment *,UDFContext *,UDFValue *);
   void                           GensymFunction(Environment *,UDFContext *,UDFValue *);
   void                           GensymStarFunction(Environment *,UDFContext *,UDFValue *);
   void                           RandomFunction(Environment *,UDFContext *,UDFValue *);
   void                           SeedFunction(Environment *,UDFContext *,UDFValue *);
   void                           LengthFunction(Environment *,UDFContext *,UDFValue *);
   void                           ConserveMemCommand(Environment *,UDFContext *,UDFValue *);
   void                           ReleaseMemCommand(Environment *,UDFContext *,UDFValue *);
   void                           MemUsedCommand(Environment *,UDFContext *,UDFValue *);
   void                           MemRequestsCommand(Environment *,UDFContext *,UDFValue *);
   void                           OptionsCommand(Environment *,UDFContext *,UDFValue *);
   void                           OperatingSystemFunction(Environment *,UDFContext *,UDFValue *);
   void                           ExpandFuncCall(Environment *,UDFContext *,UDFValue *);
   void                           DummyExpandFuncMultifield(Environment *,UDFContext *,UDFValue *);
   void                           CauseEvaluationError(Environment *,UDFContext *,UDFValue *);
   void                           SetSORCommand(Environment *,UDFContext *,UDFValue *);
   void                           GetSORCommand(Environment *,UDFContext *,UDFValue *);
   void                           GetFunctionRestrictions(Environment *,UDFContext *,UDFValue *);
   void                           AproposCommand(Environment *,UDFContext *,UDFValue *);
   void                           GensymStar(Environment *,UDFValue *);
   void                           GetFunctionListFunction(Environment *,UDFContext *,UDFValue *);
   void                           FuncallFunction(Environment *,UDFContext *,UDFValue *);
   void                           NewFunction(Environment *,UDFContext *,UDFValue *);
   void                           CallFunction(Environment *,UDFContext *,UDFValue *);
   void                           TimerFunction(Environment *,UDFContext *,UDFValue *);
   void                           TimeFunction(Environment *,UDFContext *,UDFValue *);
   void                           SystemCommand(Environment *,UDFContext *,UDFValue *);
   void                           LocalTimeFunction(Environment *,UDFContext *,UDFValue *);
   void                           GMTimeFunction(Environment *,UDFContext *,UDFValue *);
   void                           GetErrorFunction(Environment *,UDFContext *,UDFValue *);
   void                           ClearErrorValue(Environment *);
   void                           ClearErrorFunction(Environment *,UDFContext *,UDFValue *);
   void                           SetErrorFunction(Environment *,UDFContext *,UDFValue *);
   void                           SetErrorValue(Environment *,TypeHeader *);
   void                           VoidFunction(Environment *,UDFContext *,UDFValue *);

#endif /* _H_miscfun */






