# frozen_string_literal: true

# Generators are not automatically loaded by Rails
require 'generators/cucumber/install_generator'

describe Cucumber::InstallGenerator do
  # Tell the generator where to put its output (what it thinks of as Rails.root)
  destination File.expand_path('../../../../tmp', __dir__)

  before do
    prepare_destination
    create_config_files_the_generator_is_expected_to_modify
  end

  def create_config_files_the_generator_is_expected_to_modify
    FileUtils.mkdir_p File.join(destination_root, 'config', 'environments')
    %w[development test].each do |environment|
      File.write(
        File.join(destination_root, 'config', 'environments', "#{environment}.rb"),
        "Rails.application.configure do\nend"
      )
    end
  end

  let(:auto_generated_message) do
    '# IMPORTANT: This file is generated by cucumber-rails - edit at your own peril.'
  end

  context 'without arguments' do
    before { run_generator }

    describe 'config/cucumber.yml' do
      subject { file('config/cucumber.yml') }

      it { is_expected.to exist }
      it { is_expected.to contain 'default: <%= std_opts %> features' }
    end

    describe 'features/step_definitions folder' do
      subject { file('features/step_definitions') }

      it { is_expected.to exist }
    end

    describe 'features/support/env.rb' do
      subject { file('features/support/env.rb') }

      it { is_expected.to exist }
      it { is_expected.to contain auto_generated_message }
      it { is_expected.to contain "require 'cucumber/rails'" }
    end

    describe 'lib/tasks/cucumber.rake' do
      subject { file('lib/tasks/cucumber.rake') }

      it { is_expected.to exist }
      it { is_expected.to contain auto_generated_message }
      it { is_expected.to contain "task cucumber: 'cucumber:ok'" }
    end

    describe 'bin/cucumber' do
      subject { file('bin/cucumber') }

      it { is_expected.to exist }
      it { is_expected.to contain 'load Cucumber::BINARY' }
    end

    %w[development test].each do |environment|
      describe "config/environments/#{environment}.rb" do
        subject { file("config/environments/#{environment}.rb") }

        it { is_expected.to contain "config.annotations.register_extensions('feature') { |tag| /#\\s*(\#{tag}):?\\s*(.*)$/ }" }
        it { is_expected.to contain "config.annotations.register_directories('features')" }
      end
    end
  end
end
