// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py UTC_ARGS: --function-signature --include-generated-funcs --replace-value-regex "__omp_offloading_[0-9a-z]+_[0-9a-z]+" "reduction_size[.].+[.]" "pl_cond[.].+[.|,]" --prefix-filecheck-ir-name _

/*---------------------------------------- Test Xteam NoLoop Scan -----------------------------------------*/

// RUN: %clang_cc1 -fopenmp -x c++ -std=c++11 -triple x86_64-unknown-unknown -fopenmp-targets=amdgcn-amd-amdhsa -fopenmp-target-ignore-env-vars -fopenmp-assume-no-nested-parallelism -fopenmp-assume-no-thread-state -fopenmp-target-xteam-no-loop-scan -emit-llvm-bc %s -o %t-ppc-host1.bc
// RUN: %clang_cc1 -target-cpu gfx90a -fopenmp -x c++ -std=c++11 -triple amdgcn-amd-amdhsa -fopenmp-targets=amdgcn-amd-amdhsa -fopenmp-target-ignore-env-vars -fopenmp-assume-no-nested-parallelism -fopenmp-assume-no-thread-state -fopenmp-target-xteam-no-loop-scan -emit-llvm %s -fopenmp-is-device  -fopenmp-host-ir-file-path %t-ppc-host1.bc -o - | FileCheck %s --check-prefix=CHECK-64WAVE

// RUN: %clang_cc1 -fopenmp -x c++ -std=c++11 -triple x86_64-unknown-unknown -fopenmp-targets=amdgcn-amd-amdhsa -fopenmp-target-ignore-env-vars -fopenmp-assume-no-nested-parallelism -fopenmp-assume-no-thread-state -fopenmp-target-xteam-no-loop-scan -emit-llvm-bc %s -DNUM_THREADS=512 -o %t-ppc-host2.bc
// RUN: %clang_cc1 -target-cpu gfx90a -fopenmp -x c++ -std=c++11 -triple amdgcn-amd-amdhsa -fopenmp-targets=amdgcn-amd-amdhsa -fopenmp-target-ignore-env-vars -fopenmp-assume-no-nested-parallelism -fopenmp-assume-no-thread-state -fopenmp-target-xteam-no-loop-scan -emit-llvm %s -fopenmp-is-device -fopenmp-host-ir-file-path %t-ppc-host2.bc -DNUM_THREADS=512 -o - | FileCheck %s --check-prefix=CHECK-64WAVE-512WGSize

// RUN: %clang_cc1 -fopenmp -x c++ -std=c++11 -triple x86_64-unknown-unknown -fopenmp-targets=amdgcn-amd-amdhsa -fopenmp-target-ignore-env-vars -fopenmp-assume-no-nested-parallelism -fopenmp-assume-no-thread-state -fopenmp-target-xteam-no-loop-scan -emit-llvm-bc %s -o %t-ppc-host3.bc
// RUN: %clang_cc1 -target-cpu gfx1100 -fopenmp -x c++ -std=c++11 -triple amdgcn-amd-amdhsa -fopenmp-targets=amdgcn-amd-amdhsa -fopenmp-target-ignore-env-vars -fopenmp-assume-no-nested-parallelism -fopenmp-assume-no-thread-state -fopenmp-target-xteam-no-loop-scan -emit-llvm %s -fopenmp-is-device -fopenmp-host-ir-file-path %t-ppc-host3.bc -o - | FileCheck %s --check-prefix=CHECK-32WAVE

// RUN: %clang_cc1 -fopenmp -x c++ -std=c++11 -triple x86_64-unknown-unknown -fopenmp-targets=amdgcn-amd-amdhsa -fopenmp-target-ignore-env-vars -fopenmp-assume-no-nested-parallelism -fopenmp-assume-no-thread-state -fopenmp-target-xteam-no-loop-scan -emit-llvm-bc %s -DNUM_THREADS=512 -o %t-ppc-host4.bc
// RUN: %clang_cc1 -target-cpu gfx1100 -fopenmp -x c++ -std=c++11 -triple amdgcn-amd-amdhsa -fopenmp-targets=amdgcn-amd-amdhsa -fopenmp-target-ignore-env-vars -fopenmp-assume-no-nested-parallelism -fopenmp-assume-no-thread-state -fopenmp-target-xteam-no-loop-scan -emit-llvm %s -fopenmp-is-device -fopenmp-host-ir-file-path %t-ppc-host4.bc -DNUM_THREADS=512 -o - | FileCheck %s --check-prefix=CHECK-32WAVE-512WGSize

/*---------------------------------------- Test Xteam Segmented Scan ---------------------------------------*/

// RUN: %clang_cc1 -fopenmp -x c++ -std=c++11 -triple x86_64-unknown-unknown -fopenmp-targets=amdgcn-amd-amdhsa -fopenmp-target-ignore-env-vars -fopenmp-assume-no-nested-parallelism -fopenmp-assume-no-thread-state -fopenmp-target-xteam-scan -emit-llvm-bc %s -o %t-ppc-host1.bc
// RUN: %clang_cc1 -target-cpu gfx90a -fopenmp -x c++ -std=c++11 -triple amdgcn-amd-amdhsa -fopenmp-targets=amdgcn-amd-amdhsa -fopenmp-target-ignore-env-vars -fopenmp-assume-no-nested-parallelism -fopenmp-assume-no-thread-state -fopenmp-target-xteam-scan -emit-llvm %s -fopenmp-is-device -fopenmp-host-ir-file-path %t-ppc-host1.bc -o - | FileCheck %s --check-prefix=SEGMENTED-64WAVE

// RUN: %clang_cc1 -fopenmp -x c++ -std=c++11 -triple x86_64-unknown-unknown -fopenmp-targets=amdgcn-amd-amdhsa -fopenmp-target-ignore-env-vars -fopenmp-assume-no-nested-parallelism -fopenmp-assume-no-thread-state -fopenmp-target-xteam-scan -emit-llvm-bc %s -DNUM_THREADS=512 -o %t-ppc-host2.bc
// RUN: %clang_cc1 -target-cpu gfx90a -fopenmp -x c++ -std=c++11 -triple amdgcn-amd-amdhsa -fopenmp-targets=amdgcn-amd-amdhsa -fopenmp-target-ignore-env-vars -fopenmp-assume-no-nested-parallelism -fopenmp-assume-no-thread-state -fopenmp-target-xteam-scan -emit-llvm %s -fopenmp-is-device -fopenmp-host-ir-file-path %t-ppc-host2.bc -DNUM_THREADS=512 -o - | FileCheck %s --check-prefix=SEGMENTED-64WAVE-512WGSize

// RUN: %clang_cc1 -fopenmp -x c++ -std=c++11 -triple x86_64-unknown-unknown -fopenmp-targets=amdgcn-amd-amdhsa -fopenmp-target-ignore-env-vars -fopenmp-assume-no-nested-parallelism -fopenmp-assume-no-thread-state -fopenmp-target-xteam-scan -emit-llvm-bc %s -o %t-ppc-host3.bc
// RUN: %clang_cc1 -target-cpu gfx1100 -fopenmp -x c++ -std=c++11 -triple amdgcn-amd-amdhsa -fopenmp-targets=amdgcn-amd-amdhsa -fopenmp-target-ignore-env-vars -fopenmp-assume-no-nested-parallelism -fopenmp-assume-no-thread-state -fopenmp-target-xteam-scan -emit-llvm %s -fopenmp-is-device -fopenmp-host-ir-file-path %t-ppc-host3.bc -o - | FileCheck %s --check-prefix=SEGMENTED-32WAVE

// RUN: %clang_cc1 -fopenmp -x c++ -std=c++11 -triple x86_64-unknown-unknown -fopenmp-targets=amdgcn-amd-amdhsa -fopenmp-target-ignore-env-vars -fopenmp-assume-no-nested-parallelism -fopenmp-assume-no-thread-state -fopenmp-target-xteam-scan -emit-llvm-bc %s -DNUM_THREADS=512 -o %t-ppc-host4.bc
// RUN: %clang_cc1 -target-cpu gfx1100 -fopenmp -x c++ -std=c++11 -triple amdgcn-amd-amdhsa -fopenmp-targets=amdgcn-amd-amdhsa -fopenmp-target-ignore-env-vars -fopenmp-assume-no-nested-parallelism -fopenmp-assume-no-thread-state -fopenmp-target-xteam-scan -emit-llvm %s -fopenmp-is-device -fopenmp-host-ir-file-path %t-ppc-host4.bc -DNUM_THREADS=512 -o - | FileCheck %s --check-prefix=SEGMENTED-32WAVE-512WGSize

// expected-no-diagnostics

#ifndef NUM_TEAMS
#define NUM_TEAMS 250
#endif

#ifndef NUM_THREADS
#define NUM_THREADS 256
#endif

#define N NUM_THREADS * NUM_TEAMS

int main() {
  int in[N], out1[N];
  int sum1 = 0;

#pragma omp target teams distribute parallel for reduction(inscan, +:sum1) map(tofrom: in, out1) num_teams(NUM_TEAMS) num_threads(NUM_THREADS)
  for(int i = 0; i < N; i++) {
    sum1 += in[i];  // input phase
    #pragma omp scan inclusive(sum1)
    out1[i] = sum1; // scan phase
  }

  int sum2 = 0;
  int out2[N];

#pragma omp target teams distribute parallel for reduction(inscan, +:sum2) map(tofrom: in, out2) num_teams(NUM_TEAMS) num_threads(NUM_THREADS)
  for(int i = 0; i < N; i++) {
    out2[i] = sum2;  // scan phase
    #pragma omp scan exclusive(sum2)
    sum2 += in[i];   // input phase
  }

  return 0;
}
// CHECK-64WAVE-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l47
// CHECK-64WAVE-SAME: (ptr noalias noundef [[DYN_PTR:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM1:%.*]], ptr noundef nonnull align 4 dereferenceable(256000) [[IN:%.*]], ptr noundef nonnull align 4 dereferenceable(256000) [[OUT1:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM11:%.*]], ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]], ptr noundef [[TMP2:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK-64WAVE-NEXT:  entry:
// CHECK-64WAVE-NEXT:    [[DYN_PTR_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-64WAVE-NEXT:    [[SUM1_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-64WAVE-NEXT:    [[IN_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-64WAVE-NEXT:    [[OUT1_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-64WAVE-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8, addrspace(5)
// CHECK-64WAVE-NEXT:    [[SUM1_ADDR2:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-64WAVE-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-64WAVE-NEXT:    [[DOTADDR3:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-64WAVE-NEXT:    [[DOTADDR4:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-64WAVE-NEXT:    [[I:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-64WAVE-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-64WAVE-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-64WAVE-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-64WAVE-NEXT:    [[SUM15:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-64WAVE-NEXT:    [[DYN_PTR_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DYN_PTR_ADDR]] to ptr
// CHECK-64WAVE-NEXT:    [[SUM1_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM1_ADDR]] to ptr
// CHECK-64WAVE-NEXT:    [[IN_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[IN_ADDR]] to ptr
// CHECK-64WAVE-NEXT:    [[OUT1_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[OUT1_ADDR]] to ptr
// CHECK-64WAVE-NEXT:    [[VLA_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[VLA_ADDR]] to ptr
// CHECK-64WAVE-NEXT:    [[SUM1_ADDR2_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM1_ADDR2]] to ptr
// CHECK-64WAVE-NEXT:    [[DOTADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR]] to ptr
// CHECK-64WAVE-NEXT:    [[DOTADDR3_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR3]] to ptr
// CHECK-64WAVE-NEXT:    [[DOTADDR4_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR4]] to ptr
// CHECK-64WAVE-NEXT:    [[I_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[I]] to ptr
// CHECK-64WAVE-NEXT:    [[DOTOMP_LB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_LB]] to ptr
// CHECK-64WAVE-NEXT:    [[DOTOMP_UB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_UB]] to ptr
// CHECK-64WAVE-NEXT:    [[DOTOMP_IV_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_IV]] to ptr
// CHECK-64WAVE-NEXT:    [[SUM15_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM15]] to ptr
// CHECK-64WAVE-NEXT:    store ptr [[DYN_PTR]], ptr [[DYN_PTR_ADDR_ASCAST]], align 8
// CHECK-64WAVE-NEXT:    store ptr [[SUM1]], ptr [[SUM1_ADDR_ASCAST]], align 8
// CHECK-64WAVE-NEXT:    store ptr [[IN]], ptr [[IN_ADDR_ASCAST]], align 8
// CHECK-64WAVE-NEXT:    store ptr [[OUT1]], ptr [[OUT1_ADDR_ASCAST]], align 8
// CHECK-64WAVE-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR_ASCAST]], align 8
// CHECK-64WAVE-NEXT:    store ptr [[SUM11]], ptr [[SUM1_ADDR2_ASCAST]], align 8
// CHECK-64WAVE-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR_ASCAST]], align 8
// CHECK-64WAVE-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR3_ASCAST]], align 8
// CHECK-64WAVE-NEXT:    store ptr [[TMP2]], ptr [[DOTADDR4_ASCAST]], align 8
// CHECK-64WAVE-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[SUM1_ADDR_ASCAST]], align 8
// CHECK-64WAVE-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[IN_ADDR_ASCAST]], align 8
// CHECK-64WAVE-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[OUT1_ADDR_ASCAST]], align 8
// CHECK-64WAVE-NEXT:    [[TMP6:%.*]] = load i64, ptr [[VLA_ADDR_ASCAST]], align 8
// CHECK-64WAVE-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[SUM1_ADDR2_ASCAST]], align 8
// CHECK-64WAVE-NEXT:    call void @__kmpc_specialized_kernel_init()
// CHECK-64WAVE-NEXT:    [[TMP8:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-64WAVE-NEXT:    store i32 0, ptr addrspace(5) [[TMP8]], align 4
// CHECK-64WAVE-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// CHECK-64WAVE-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// CHECK-64WAVE-NEXT:    store i32 0, ptr [[DOTOMP_LB_ASCAST]], align 4
// CHECK-64WAVE-NEXT:    store i32 63999, ptr [[DOTOMP_UB_ASCAST]], align 4
// CHECK-64WAVE-NEXT:    [[TMP9:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// CHECK-64WAVE-NEXT:    store i32 [[TMP9]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-64WAVE-NEXT:    [[TMP10:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// CHECK-64WAVE-NEXT:    [[NVPTX_NUM_THREADS:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// CHECK-64WAVE-NEXT:    [[GPU_BLOCK_ID:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// CHECK-64WAVE-NEXT:    [[TMP11:%.*]] = mul i32 [[GPU_BLOCK_ID]], [[NVPTX_NUM_THREADS]]
// CHECK-64WAVE-NEXT:    [[TMP12:%.*]] = add i32 [[TMP11]], [[TMP10]]
// CHECK-64WAVE-NEXT:    [[TMP13:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-64WAVE-NEXT:    [[TMP14:%.*]] = add i32 [[TMP12]], [[TMP13]]
// CHECK-64WAVE-NEXT:    [[TMP15:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// CHECK-64WAVE-NEXT:    [[TMP16:%.*]] = zext i32 [[TMP14]] to i64
// CHECK-64WAVE-NEXT:    [[TOTAL_NUM_THREADS:%.*]] = mul i32 [[TMP15]], [[NVPTX_NUM_THREADS]]
// CHECK-64WAVE-NEXT:    store i32 [[TMP14]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-64WAVE-NEXT:    [[TMP17:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-64WAVE-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP17]], 1
// CHECK-64WAVE-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK-64WAVE-NEXT:    store i32 [[ADD]], ptr [[I_ASCAST]], align 4
// CHECK-64WAVE-NEXT:    [[TMP18:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-64WAVE-NEXT:    [[TMP19:%.*]] = load i32, ptr [[DOTOMP_UB_ASCAST]], align 4
// CHECK-64WAVE-NEXT:    [[CMP:%.*]] = icmp sle i32 [[TMP18]], [[TMP19]]
// CHECK-64WAVE-NEXT:    br i1 [[CMP]], label [[OMP_KERNEL_BODY:%.*]], label [[OMP_KERNEL_DONE:%.*]]
// CHECK-64WAVE:       omp.kernel.body:
// CHECK-64WAVE-NEXT:    store i32 0, ptr [[SUM15_ASCAST]], align 4
// CHECK-64WAVE-NEXT:    br label [[OMP_INSCAN_DISPATCH:%.*]]
// CHECK-64WAVE:       omp.before.scan.bb:
// CHECK-64WAVE-NEXT:    [[TMP20:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// CHECK-64WAVE-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP20]] to i64
// CHECK-64WAVE-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [64000 x i32], ptr [[TMP4]], i64 0, i64 [[IDXPROM]]
// CHECK-64WAVE-NEXT:    [[TMP21:%.*]] = load i32, ptr [[ARRAYIDX]], align 4
// CHECK-64WAVE-NEXT:    [[TMP22:%.*]] = load i32, ptr addrspace(5) [[TMP8]], align 4
// CHECK-64WAVE-NEXT:    [[TMP23:%.*]] = add i32 [[TMP22]], [[TMP21]]
// CHECK-64WAVE-NEXT:    store i32 [[TMP23]], ptr addrspace(5) [[TMP8]], align 4
// CHECK-64WAVE-NEXT:    [[TMP24:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-64WAVE-NEXT:    [[TMP25:%.*]] = zext i32 [[TMP24]] to i64
// CHECK-64WAVE-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK-64WAVE:       omp.exit.inscan.bb:
// CHECK-64WAVE-NEXT:    br label [[OMP_BODY_CONTINUE]]
// CHECK-64WAVE:       omp.inscan.dispatch:
// CHECK-64WAVE-NEXT:    br label [[OMP_BEFORE_SCAN_BB:%.*]]
// CHECK-64WAVE:       omp.after.scan.bb:
// CHECK-64WAVE-NEXT:    [[TMP26:%.*]] = load i32, ptr [[TMP3]], align 4
// CHECK-64WAVE-NEXT:    [[TMP27:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// CHECK-64WAVE-NEXT:    [[IDXPROM6:%.*]] = sext i32 [[TMP27]] to i64
// CHECK-64WAVE-NEXT:    [[ARRAYIDX7:%.*]] = getelementptr inbounds [64000 x i32], ptr [[TMP5]], i64 0, i64 [[IDXPROM6]]
// CHECK-64WAVE-NEXT:    store i32 [[TMP26]], ptr [[ARRAYIDX7]], align 4
// CHECK-64WAVE-NEXT:    br label [[OMP_EXIT_INSCAN_BB:%.*]]
// CHECK-64WAVE:       omp.body.continue:
// CHECK-64WAVE-NEXT:    [[TMP28:%.*]] = load ptr, ptr [[DOTADDR_ASCAST]], align 8
// CHECK-64WAVE-NEXT:    [[TMP29:%.*]] = load ptr, ptr [[DOTADDR3_ASCAST]], align 8
// CHECK-64WAVE-NEXT:    [[TMP30:%.*]] = load ptr, ptr [[DOTADDR4_ASCAST]], align 8
// CHECK-64WAVE-NEXT:    [[TMP31:%.*]] = load i32, ptr addrspace(5) [[TMP8]], align 4
// CHECK-64WAVE-NEXT:    call void @__kmpc_xteams_i_4x64(i32 [[TMP31]], ptr [[TMP30]], ptr [[TMP3]], ptr [[TMP28]], ptr [[TMP29]], ptr @__kmpc_rfun_sum_i, ptr @__kmpc_rfun_sum_lds_i, i32 0, i64 [[TMP16]], i32 [[TMP15]])
// CHECK-64WAVE-NEXT:    br label [[OMP_KERNEL_DONE]]
// CHECK-64WAVE:       omp.kernel.done:
// CHECK-64WAVE-NEXT:    ret void
//
//
// CHECK-64WAVE-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l47_1
// CHECK-64WAVE-SAME: (ptr noalias noundef [[DYN_PTR:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM1:%.*]], ptr noundef nonnull align 4 dereferenceable(256000) [[IN:%.*]], ptr noundef nonnull align 4 dereferenceable(256000) [[OUT1:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM11:%.*]], ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]], ptr noundef [[TMP2:%.*]]) #[[ATTR0]] {
// CHECK-64WAVE-NEXT:  entry:
// CHECK-64WAVE-NEXT:    [[DYN_PTR_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-64WAVE-NEXT:    [[SUM1_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-64WAVE-NEXT:    [[IN_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-64WAVE-NEXT:    [[OUT1_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-64WAVE-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8, addrspace(5)
// CHECK-64WAVE-NEXT:    [[SUM1_ADDR2:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-64WAVE-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-64WAVE-NEXT:    [[DOTADDR3:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-64WAVE-NEXT:    [[DOTADDR4:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-64WAVE-NEXT:    [[I:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-64WAVE-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-64WAVE-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-64WAVE-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-64WAVE-NEXT:    [[SUM15:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-64WAVE-NEXT:    [[DYN_PTR_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DYN_PTR_ADDR]] to ptr
// CHECK-64WAVE-NEXT:    [[SUM1_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM1_ADDR]] to ptr
// CHECK-64WAVE-NEXT:    [[IN_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[IN_ADDR]] to ptr
// CHECK-64WAVE-NEXT:    [[OUT1_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[OUT1_ADDR]] to ptr
// CHECK-64WAVE-NEXT:    [[VLA_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[VLA_ADDR]] to ptr
// CHECK-64WAVE-NEXT:    [[SUM1_ADDR2_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM1_ADDR2]] to ptr
// CHECK-64WAVE-NEXT:    [[DOTADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR]] to ptr
// CHECK-64WAVE-NEXT:    [[DOTADDR3_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR3]] to ptr
// CHECK-64WAVE-NEXT:    [[DOTADDR4_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR4]] to ptr
// CHECK-64WAVE-NEXT:    [[I_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[I]] to ptr
// CHECK-64WAVE-NEXT:    [[DOTOMP_LB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_LB]] to ptr
// CHECK-64WAVE-NEXT:    [[DOTOMP_UB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_UB]] to ptr
// CHECK-64WAVE-NEXT:    [[DOTOMP_IV_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_IV]] to ptr
// CHECK-64WAVE-NEXT:    [[SUM15_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM15]] to ptr
// CHECK-64WAVE-NEXT:    store ptr [[DYN_PTR]], ptr [[DYN_PTR_ADDR_ASCAST]], align 8
// CHECK-64WAVE-NEXT:    store ptr [[SUM1]], ptr [[SUM1_ADDR_ASCAST]], align 8
// CHECK-64WAVE-NEXT:    store ptr [[IN]], ptr [[IN_ADDR_ASCAST]], align 8
// CHECK-64WAVE-NEXT:    store ptr [[OUT1]], ptr [[OUT1_ADDR_ASCAST]], align 8
// CHECK-64WAVE-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR_ASCAST]], align 8
// CHECK-64WAVE-NEXT:    store ptr [[SUM11]], ptr [[SUM1_ADDR2_ASCAST]], align 8
// CHECK-64WAVE-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR_ASCAST]], align 8
// CHECK-64WAVE-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR3_ASCAST]], align 8
// CHECK-64WAVE-NEXT:    store ptr [[TMP2]], ptr [[DOTADDR4_ASCAST]], align 8
// CHECK-64WAVE-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[SUM1_ADDR_ASCAST]], align 8
// CHECK-64WAVE-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[IN_ADDR_ASCAST]], align 8
// CHECK-64WAVE-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[OUT1_ADDR_ASCAST]], align 8
// CHECK-64WAVE-NEXT:    [[TMP6:%.*]] = load i64, ptr [[VLA_ADDR_ASCAST]], align 8
// CHECK-64WAVE-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[SUM1_ADDR2_ASCAST]], align 8
// CHECK-64WAVE-NEXT:    call void @__kmpc_specialized_kernel_init()
// CHECK-64WAVE-NEXT:    [[TMP8:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-64WAVE-NEXT:    store i32 0, ptr addrspace(5) [[TMP8]], align 4
// CHECK-64WAVE-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// CHECK-64WAVE-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// CHECK-64WAVE-NEXT:    store i32 0, ptr [[DOTOMP_LB_ASCAST]], align 4
// CHECK-64WAVE-NEXT:    store i32 63999, ptr [[DOTOMP_UB_ASCAST]], align 4
// CHECK-64WAVE-NEXT:    [[TMP9:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// CHECK-64WAVE-NEXT:    store i32 [[TMP9]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-64WAVE-NEXT:    [[TMP10:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// CHECK-64WAVE-NEXT:    [[NVPTX_NUM_THREADS:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// CHECK-64WAVE-NEXT:    [[GPU_BLOCK_ID:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// CHECK-64WAVE-NEXT:    [[TMP11:%.*]] = mul i32 [[GPU_BLOCK_ID]], [[NVPTX_NUM_THREADS]]
// CHECK-64WAVE-NEXT:    [[TMP12:%.*]] = add i32 [[TMP11]], [[TMP10]]
// CHECK-64WAVE-NEXT:    [[TMP13:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-64WAVE-NEXT:    [[TMP14:%.*]] = add i32 [[TMP12]], [[TMP13]]
// CHECK-64WAVE-NEXT:    [[TMP15:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// CHECK-64WAVE-NEXT:    [[TMP16:%.*]] = zext i32 [[TMP14]] to i64
// CHECK-64WAVE-NEXT:    [[TOTAL_NUM_THREADS:%.*]] = mul i32 [[TMP15]], [[NVPTX_NUM_THREADS]]
// CHECK-64WAVE-NEXT:    store i32 [[TMP14]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-64WAVE-NEXT:    [[TMP17:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-64WAVE-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP17]], 1
// CHECK-64WAVE-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK-64WAVE-NEXT:    store i32 [[ADD]], ptr [[I_ASCAST]], align 4
// CHECK-64WAVE-NEXT:    [[TMP18:%.*]] = load ptr, ptr [[DOTADDR_ASCAST]], align 8
// CHECK-64WAVE-NEXT:    [[TMP19:%.*]] = load ptr, ptr [[DOTADDR4_ASCAST]], align 8
// CHECK-64WAVE-NEXT:    [[TMP20:%.*]] = load ptr, ptr [[DOTADDR_ASCAST]], align 8
// CHECK-64WAVE-NEXT:    [[TMP21:%.*]] = load ptr, ptr [[DOTADDR4_ASCAST]], align 8
// CHECK-64WAVE-NEXT:    [[TMP22:%.*]] = load i32, ptr addrspace(5) [[TMP8]], align 4
// CHECK-64WAVE-NEXT:    call void @__kmpc_xteams_phase2_i_4x64(ptr [[TMP21]], i32 1, ptr [[TMP20]], ptr [[TMP21]], ptr @__kmpc_rfun_sum_i, i32 0, i64 [[TMP16]], i32 1)
// CHECK-64WAVE-NEXT:    [[TMP23:%.*]] = add i32 [[TMP12]], [[TOTAL_NUM_THREADS]]
// CHECK-64WAVE-NEXT:    [[TMP24:%.*]] = getelementptr i32, ptr [[TMP19]], i32 [[TMP23]]
// CHECK-64WAVE-NEXT:    [[TMP25:%.*]] = load i32, ptr [[TMP24]], align 4
// CHECK-64WAVE-NEXT:    store i32 [[TMP25]], ptr addrspace(5) [[TMP8]], align 4
// CHECK-64WAVE-NEXT:    store i32 0, ptr [[SUM15_ASCAST]], align 4
// CHECK-64WAVE-NEXT:    br label [[OMP_INSCAN_DISPATCH:%.*]]
// CHECK-64WAVE:       omp.before.scan.bb:
// CHECK-64WAVE-NEXT:    [[TMP26:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// CHECK-64WAVE-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP26]] to i64
// CHECK-64WAVE-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [64000 x i32], ptr [[TMP4]], i64 0, i64 [[IDXPROM]]
// CHECK-64WAVE-NEXT:    [[TMP27:%.*]] = load i32, ptr [[ARRAYIDX]], align 4
// CHECK-64WAVE-NEXT:    [[TMP28:%.*]] = load i32, ptr addrspace(5) [[TMP8]], align 4
// CHECK-64WAVE-NEXT:    [[TMP29:%.*]] = add i32 [[TMP28]], [[TMP27]]
// CHECK-64WAVE-NEXT:    store i32 [[TMP29]], ptr addrspace(5) [[TMP8]], align 4
// CHECK-64WAVE-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK-64WAVE:       omp.exit.inscan.bb:
// CHECK-64WAVE-NEXT:    br label [[OMP_BODY_CONTINUE]]
// CHECK-64WAVE:       omp.inscan.dispatch:
// CHECK-64WAVE-NEXT:    [[TMP30:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-64WAVE-NEXT:    [[TMP31:%.*]] = zext i32 [[TMP30]] to i64
// CHECK-64WAVE-NEXT:    [[ARRAYIDX6:%.*]] = getelementptr inbounds nuw i32, ptr [[TMP7]], i64 [[TMP31]]
// CHECK-64WAVE-NEXT:    [[TMP32:%.*]] = load i32, ptr addrspace(5) [[TMP8]], align 4
// CHECK-64WAVE-NEXT:    store i32 [[TMP32]], ptr [[TMP3]], align 4
// CHECK-64WAVE-NEXT:    br label [[OMP_AFTER_SCAN_BB:%.*]]
// CHECK-64WAVE:       omp.after.scan.bb:
// CHECK-64WAVE-NEXT:    [[TMP33:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// CHECK-64WAVE-NEXT:    [[IDXPROM7:%.*]] = sext i32 [[TMP33]] to i64
// CHECK-64WAVE-NEXT:    [[ARRAYIDX8:%.*]] = getelementptr inbounds [64000 x i32], ptr [[TMP5]], i64 0, i64 [[IDXPROM7]]
// CHECK-64WAVE-NEXT:    [[TMP34:%.*]] = load i32, ptr addrspace(5) [[TMP8]], align 4
// CHECK-64WAVE-NEXT:    store i32 [[TMP34]], ptr [[ARRAYIDX8]], align 4
// CHECK-64WAVE-NEXT:    br label [[OMP_EXIT_INSCAN_BB:%.*]]
// CHECK-64WAVE:       omp.body.continue:
// CHECK-64WAVE-NEXT:    ret void
//
//
// CHECK-64WAVE-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l57
// CHECK-64WAVE-SAME: (ptr noalias noundef [[DYN_PTR:%.*]], ptr noundef nonnull align 4 dereferenceable(256000) [[OUT2:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM2:%.*]], ptr noundef nonnull align 4 dereferenceable(256000) [[IN:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM21:%.*]], ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]], ptr noundef [[TMP2:%.*]]) #[[ATTR0]] {
// CHECK-64WAVE-NEXT:  entry:
// CHECK-64WAVE-NEXT:    [[DYN_PTR_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-64WAVE-NEXT:    [[OUT2_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-64WAVE-NEXT:    [[SUM2_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-64WAVE-NEXT:    [[IN_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-64WAVE-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8, addrspace(5)
// CHECK-64WAVE-NEXT:    [[SUM2_ADDR2:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-64WAVE-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-64WAVE-NEXT:    [[DOTADDR3:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-64WAVE-NEXT:    [[DOTADDR4:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-64WAVE-NEXT:    [[I:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-64WAVE-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-64WAVE-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-64WAVE-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-64WAVE-NEXT:    [[SUM25:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-64WAVE-NEXT:    [[DYN_PTR_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DYN_PTR_ADDR]] to ptr
// CHECK-64WAVE-NEXT:    [[OUT2_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[OUT2_ADDR]] to ptr
// CHECK-64WAVE-NEXT:    [[SUM2_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM2_ADDR]] to ptr
// CHECK-64WAVE-NEXT:    [[IN_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[IN_ADDR]] to ptr
// CHECK-64WAVE-NEXT:    [[VLA_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[VLA_ADDR]] to ptr
// CHECK-64WAVE-NEXT:    [[SUM2_ADDR2_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM2_ADDR2]] to ptr
// CHECK-64WAVE-NEXT:    [[DOTADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR]] to ptr
// CHECK-64WAVE-NEXT:    [[DOTADDR3_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR3]] to ptr
// CHECK-64WAVE-NEXT:    [[DOTADDR4_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR4]] to ptr
// CHECK-64WAVE-NEXT:    [[I_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[I]] to ptr
// CHECK-64WAVE-NEXT:    [[DOTOMP_LB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_LB]] to ptr
// CHECK-64WAVE-NEXT:    [[DOTOMP_UB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_UB]] to ptr
// CHECK-64WAVE-NEXT:    [[DOTOMP_IV_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_IV]] to ptr
// CHECK-64WAVE-NEXT:    [[SUM25_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM25]] to ptr
// CHECK-64WAVE-NEXT:    store ptr [[DYN_PTR]], ptr [[DYN_PTR_ADDR_ASCAST]], align 8
// CHECK-64WAVE-NEXT:    store ptr [[OUT2]], ptr [[OUT2_ADDR_ASCAST]], align 8
// CHECK-64WAVE-NEXT:    store ptr [[SUM2]], ptr [[SUM2_ADDR_ASCAST]], align 8
// CHECK-64WAVE-NEXT:    store ptr [[IN]], ptr [[IN_ADDR_ASCAST]], align 8
// CHECK-64WAVE-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR_ASCAST]], align 8
// CHECK-64WAVE-NEXT:    store ptr [[SUM21]], ptr [[SUM2_ADDR2_ASCAST]], align 8
// CHECK-64WAVE-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR_ASCAST]], align 8
// CHECK-64WAVE-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR3_ASCAST]], align 8
// CHECK-64WAVE-NEXT:    store ptr [[TMP2]], ptr [[DOTADDR4_ASCAST]], align 8
// CHECK-64WAVE-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[OUT2_ADDR_ASCAST]], align 8
// CHECK-64WAVE-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[SUM2_ADDR_ASCAST]], align 8
// CHECK-64WAVE-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[IN_ADDR_ASCAST]], align 8
// CHECK-64WAVE-NEXT:    [[TMP6:%.*]] = load i64, ptr [[VLA_ADDR_ASCAST]], align 8
// CHECK-64WAVE-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[SUM2_ADDR2_ASCAST]], align 8
// CHECK-64WAVE-NEXT:    call void @__kmpc_specialized_kernel_init()
// CHECK-64WAVE-NEXT:    [[TMP8:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-64WAVE-NEXT:    store i32 0, ptr addrspace(5) [[TMP8]], align 4
// CHECK-64WAVE-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// CHECK-64WAVE-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// CHECK-64WAVE-NEXT:    store i32 0, ptr [[DOTOMP_LB_ASCAST]], align 4
// CHECK-64WAVE-NEXT:    store i32 63999, ptr [[DOTOMP_UB_ASCAST]], align 4
// CHECK-64WAVE-NEXT:    [[TMP9:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// CHECK-64WAVE-NEXT:    store i32 [[TMP9]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-64WAVE-NEXT:    [[TMP10:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// CHECK-64WAVE-NEXT:    [[NVPTX_NUM_THREADS:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// CHECK-64WAVE-NEXT:    [[GPU_BLOCK_ID:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// CHECK-64WAVE-NEXT:    [[TMP11:%.*]] = mul i32 [[GPU_BLOCK_ID]], [[NVPTX_NUM_THREADS]]
// CHECK-64WAVE-NEXT:    [[TMP12:%.*]] = add i32 [[TMP11]], [[TMP10]]
// CHECK-64WAVE-NEXT:    [[TMP13:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-64WAVE-NEXT:    [[TMP14:%.*]] = add i32 [[TMP12]], [[TMP13]]
// CHECK-64WAVE-NEXT:    [[TMP15:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// CHECK-64WAVE-NEXT:    [[TMP16:%.*]] = zext i32 [[TMP14]] to i64
// CHECK-64WAVE-NEXT:    [[TOTAL_NUM_THREADS:%.*]] = mul i32 [[TMP15]], [[NVPTX_NUM_THREADS]]
// CHECK-64WAVE-NEXT:    store i32 [[TMP14]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-64WAVE-NEXT:    [[TMP17:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-64WAVE-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP17]], 1
// CHECK-64WAVE-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK-64WAVE-NEXT:    store i32 [[ADD]], ptr [[I_ASCAST]], align 4
// CHECK-64WAVE-NEXT:    [[TMP18:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-64WAVE-NEXT:    [[TMP19:%.*]] = load i32, ptr [[DOTOMP_UB_ASCAST]], align 4
// CHECK-64WAVE-NEXT:    [[CMP:%.*]] = icmp sle i32 [[TMP18]], [[TMP19]]
// CHECK-64WAVE-NEXT:    br i1 [[CMP]], label [[OMP_KERNEL_BODY:%.*]], label [[OMP_KERNEL_DONE:%.*]]
// CHECK-64WAVE:       omp.kernel.body:
// CHECK-64WAVE-NEXT:    store i32 0, ptr [[SUM25_ASCAST]], align 4
// CHECK-64WAVE-NEXT:    br label [[OMP_INSCAN_DISPATCH:%.*]]
// CHECK-64WAVE:       omp.before.scan.bb:
// CHECK-64WAVE-NEXT:    [[TMP20:%.*]] = load i32, ptr [[TMP4]], align 4
// CHECK-64WAVE-NEXT:    [[TMP21:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// CHECK-64WAVE-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP21]] to i64
// CHECK-64WAVE-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [64000 x i32], ptr [[TMP3]], i64 0, i64 [[IDXPROM]]
// CHECK-64WAVE-NEXT:    store i32 [[TMP20]], ptr [[ARRAYIDX]], align 4
// CHECK-64WAVE-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK-64WAVE:       omp.exit.inscan.bb:
// CHECK-64WAVE-NEXT:    [[TMP22:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-64WAVE-NEXT:    [[TMP23:%.*]] = zext i32 [[TMP22]] to i64
// CHECK-64WAVE-NEXT:    br label [[OMP_BODY_CONTINUE]]
// CHECK-64WAVE:       omp.inscan.dispatch:
// CHECK-64WAVE-NEXT:    br label [[OMP_AFTER_SCAN_BB:%.*]]
// CHECK-64WAVE:       omp.after.scan.bb:
// CHECK-64WAVE-NEXT:    [[TMP24:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// CHECK-64WAVE-NEXT:    [[IDXPROM6:%.*]] = sext i32 [[TMP24]] to i64
// CHECK-64WAVE-NEXT:    [[ARRAYIDX7:%.*]] = getelementptr inbounds [64000 x i32], ptr [[TMP5]], i64 0, i64 [[IDXPROM6]]
// CHECK-64WAVE-NEXT:    [[TMP25:%.*]] = load i32, ptr [[ARRAYIDX7]], align 4
// CHECK-64WAVE-NEXT:    [[TMP26:%.*]] = load i32, ptr addrspace(5) [[TMP8]], align 4
// CHECK-64WAVE-NEXT:    [[TMP27:%.*]] = add i32 [[TMP26]], [[TMP25]]
// CHECK-64WAVE-NEXT:    store i32 [[TMP27]], ptr addrspace(5) [[TMP8]], align 4
// CHECK-64WAVE-NEXT:    br label [[OMP_EXIT_INSCAN_BB:%.*]]
// CHECK-64WAVE:       omp.body.continue:
// CHECK-64WAVE-NEXT:    [[TMP28:%.*]] = load ptr, ptr [[DOTADDR_ASCAST]], align 8
// CHECK-64WAVE-NEXT:    [[TMP29:%.*]] = load ptr, ptr [[DOTADDR3_ASCAST]], align 8
// CHECK-64WAVE-NEXT:    [[TMP30:%.*]] = load ptr, ptr [[DOTADDR4_ASCAST]], align 8
// CHECK-64WAVE-NEXT:    [[TMP31:%.*]] = load i32, ptr addrspace(5) [[TMP8]], align 4
// CHECK-64WAVE-NEXT:    call void @__kmpc_xteams_i_4x64(i32 [[TMP31]], ptr [[TMP30]], ptr [[TMP4]], ptr [[TMP28]], ptr [[TMP29]], ptr @__kmpc_rfun_sum_i, ptr @__kmpc_rfun_sum_lds_i, i32 0, i64 [[TMP16]], i32 [[TMP15]])
// CHECK-64WAVE-NEXT:    br label [[OMP_KERNEL_DONE]]
// CHECK-64WAVE:       omp.kernel.done:
// CHECK-64WAVE-NEXT:    ret void
//
//
// CHECK-64WAVE-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l57_1
// CHECK-64WAVE-SAME: (ptr noalias noundef [[DYN_PTR:%.*]], ptr noundef nonnull align 4 dereferenceable(256000) [[OUT2:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM2:%.*]], ptr noundef nonnull align 4 dereferenceable(256000) [[IN:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM21:%.*]], ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]], ptr noundef [[TMP2:%.*]]) #[[ATTR0]] {
// CHECK-64WAVE-NEXT:  entry:
// CHECK-64WAVE-NEXT:    [[DYN_PTR_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-64WAVE-NEXT:    [[OUT2_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-64WAVE-NEXT:    [[SUM2_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-64WAVE-NEXT:    [[IN_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-64WAVE-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8, addrspace(5)
// CHECK-64WAVE-NEXT:    [[SUM2_ADDR2:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-64WAVE-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-64WAVE-NEXT:    [[DOTADDR3:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-64WAVE-NEXT:    [[DOTADDR4:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-64WAVE-NEXT:    [[I:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-64WAVE-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-64WAVE-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-64WAVE-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-64WAVE-NEXT:    [[SUM25:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-64WAVE-NEXT:    [[DYN_PTR_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DYN_PTR_ADDR]] to ptr
// CHECK-64WAVE-NEXT:    [[OUT2_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[OUT2_ADDR]] to ptr
// CHECK-64WAVE-NEXT:    [[SUM2_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM2_ADDR]] to ptr
// CHECK-64WAVE-NEXT:    [[IN_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[IN_ADDR]] to ptr
// CHECK-64WAVE-NEXT:    [[VLA_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[VLA_ADDR]] to ptr
// CHECK-64WAVE-NEXT:    [[SUM2_ADDR2_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM2_ADDR2]] to ptr
// CHECK-64WAVE-NEXT:    [[DOTADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR]] to ptr
// CHECK-64WAVE-NEXT:    [[DOTADDR3_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR3]] to ptr
// CHECK-64WAVE-NEXT:    [[DOTADDR4_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR4]] to ptr
// CHECK-64WAVE-NEXT:    [[I_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[I]] to ptr
// CHECK-64WAVE-NEXT:    [[DOTOMP_LB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_LB]] to ptr
// CHECK-64WAVE-NEXT:    [[DOTOMP_UB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_UB]] to ptr
// CHECK-64WAVE-NEXT:    [[DOTOMP_IV_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_IV]] to ptr
// CHECK-64WAVE-NEXT:    [[SUM25_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM25]] to ptr
// CHECK-64WAVE-NEXT:    store ptr [[DYN_PTR]], ptr [[DYN_PTR_ADDR_ASCAST]], align 8
// CHECK-64WAVE-NEXT:    store ptr [[OUT2]], ptr [[OUT2_ADDR_ASCAST]], align 8
// CHECK-64WAVE-NEXT:    store ptr [[SUM2]], ptr [[SUM2_ADDR_ASCAST]], align 8
// CHECK-64WAVE-NEXT:    store ptr [[IN]], ptr [[IN_ADDR_ASCAST]], align 8
// CHECK-64WAVE-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR_ASCAST]], align 8
// CHECK-64WAVE-NEXT:    store ptr [[SUM21]], ptr [[SUM2_ADDR2_ASCAST]], align 8
// CHECK-64WAVE-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR_ASCAST]], align 8
// CHECK-64WAVE-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR3_ASCAST]], align 8
// CHECK-64WAVE-NEXT:    store ptr [[TMP2]], ptr [[DOTADDR4_ASCAST]], align 8
// CHECK-64WAVE-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[OUT2_ADDR_ASCAST]], align 8
// CHECK-64WAVE-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[SUM2_ADDR_ASCAST]], align 8
// CHECK-64WAVE-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[IN_ADDR_ASCAST]], align 8
// CHECK-64WAVE-NEXT:    [[TMP6:%.*]] = load i64, ptr [[VLA_ADDR_ASCAST]], align 8
// CHECK-64WAVE-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[SUM2_ADDR2_ASCAST]], align 8
// CHECK-64WAVE-NEXT:    call void @__kmpc_specialized_kernel_init()
// CHECK-64WAVE-NEXT:    [[TMP8:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-64WAVE-NEXT:    store i32 0, ptr addrspace(5) [[TMP8]], align 4
// CHECK-64WAVE-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// CHECK-64WAVE-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// CHECK-64WAVE-NEXT:    store i32 0, ptr [[DOTOMP_LB_ASCAST]], align 4
// CHECK-64WAVE-NEXT:    store i32 63999, ptr [[DOTOMP_UB_ASCAST]], align 4
// CHECK-64WAVE-NEXT:    [[TMP9:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// CHECK-64WAVE-NEXT:    store i32 [[TMP9]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-64WAVE-NEXT:    [[TMP10:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// CHECK-64WAVE-NEXT:    [[NVPTX_NUM_THREADS:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// CHECK-64WAVE-NEXT:    [[GPU_BLOCK_ID:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// CHECK-64WAVE-NEXT:    [[TMP11:%.*]] = mul i32 [[GPU_BLOCK_ID]], [[NVPTX_NUM_THREADS]]
// CHECK-64WAVE-NEXT:    [[TMP12:%.*]] = add i32 [[TMP11]], [[TMP10]]
// CHECK-64WAVE-NEXT:    [[TMP13:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-64WAVE-NEXT:    [[TMP14:%.*]] = add i32 [[TMP12]], [[TMP13]]
// CHECK-64WAVE-NEXT:    [[TMP15:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// CHECK-64WAVE-NEXT:    [[TMP16:%.*]] = zext i32 [[TMP14]] to i64
// CHECK-64WAVE-NEXT:    [[TOTAL_NUM_THREADS:%.*]] = mul i32 [[TMP15]], [[NVPTX_NUM_THREADS]]
// CHECK-64WAVE-NEXT:    store i32 [[TMP14]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-64WAVE-NEXT:    [[TMP17:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-64WAVE-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP17]], 1
// CHECK-64WAVE-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK-64WAVE-NEXT:    store i32 [[ADD]], ptr [[I_ASCAST]], align 4
// CHECK-64WAVE-NEXT:    [[TMP18:%.*]] = load ptr, ptr [[DOTADDR_ASCAST]], align 8
// CHECK-64WAVE-NEXT:    [[TMP19:%.*]] = load ptr, ptr [[DOTADDR4_ASCAST]], align 8
// CHECK-64WAVE-NEXT:    [[TMP20:%.*]] = load ptr, ptr [[DOTADDR_ASCAST]], align 8
// CHECK-64WAVE-NEXT:    [[TMP21:%.*]] = load ptr, ptr [[DOTADDR4_ASCAST]], align 8
// CHECK-64WAVE-NEXT:    [[TMP22:%.*]] = load i32, ptr addrspace(5) [[TMP8]], align 4
// CHECK-64WAVE-NEXT:    call void @__kmpc_xteams_phase2_i_4x64(ptr [[TMP21]], i32 1, ptr [[TMP20]], ptr [[TMP21]], ptr @__kmpc_rfun_sum_i, i32 0, i64 [[TMP16]], i32 0)
// CHECK-64WAVE-NEXT:    [[TMP23:%.*]] = add i32 [[TMP12]], [[TOTAL_NUM_THREADS]]
// CHECK-64WAVE-NEXT:    [[TMP24:%.*]] = getelementptr i32, ptr [[TMP19]], i32 [[TMP23]]
// CHECK-64WAVE-NEXT:    [[TMP25:%.*]] = load i32, ptr [[TMP24]], align 4
// CHECK-64WAVE-NEXT:    store i32 [[TMP25]], ptr addrspace(5) [[TMP8]], align 4
// CHECK-64WAVE-NEXT:    store i32 0, ptr [[SUM25_ASCAST]], align 4
// CHECK-64WAVE-NEXT:    br label [[OMP_INSCAN_DISPATCH:%.*]]
// CHECK-64WAVE:       omp.before.scan.bb:
// CHECK-64WAVE-NEXT:    [[TMP26:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// CHECK-64WAVE-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP26]] to i64
// CHECK-64WAVE-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [64000 x i32], ptr [[TMP3]], i64 0, i64 [[IDXPROM]]
// CHECK-64WAVE-NEXT:    [[TMP27:%.*]] = load i32, ptr addrspace(5) [[TMP8]], align 4
// CHECK-64WAVE-NEXT:    store i32 [[TMP27]], ptr [[ARRAYIDX]], align 4
// CHECK-64WAVE-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK-64WAVE:       omp.exit.inscan.bb:
// CHECK-64WAVE-NEXT:    br label [[OMP_BODY_CONTINUE]]
// CHECK-64WAVE:       omp.inscan.dispatch:
// CHECK-64WAVE-NEXT:    [[TMP28:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-64WAVE-NEXT:    [[TMP29:%.*]] = zext i32 [[TMP28]] to i64
// CHECK-64WAVE-NEXT:    [[TMP30:%.*]] = icmp eq i64 [[TMP29]], 0
// CHECK-64WAVE-NEXT:    br i1 [[TMP30]], label [[OMP_EXCLUSIVE_COPY_EXIT:%.*]], label [[OMP_EXCLUSIVE_DEC:%.*]]
// CHECK-64WAVE:       omp.exclusive.dec:
// CHECK-64WAVE-NEXT:    [[TMP31:%.*]] = sub nuw i64 [[TMP29]], 1
// CHECK-64WAVE-NEXT:    [[ARRAYIDX6:%.*]] = getelementptr inbounds nuw i32, ptr [[TMP7]], i64 [[TMP31]]
// CHECK-64WAVE-NEXT:    [[TMP32:%.*]] = load i32, ptr addrspace(5) [[TMP8]], align 4
// CHECK-64WAVE-NEXT:    store i32 [[TMP32]], ptr [[TMP4]], align 4
// CHECK-64WAVE-NEXT:    br label [[OMP_EXCLUSIVE_COPY_EXIT]]
// CHECK-64WAVE:       omp.exclusive.copy.exit:
// CHECK-64WAVE-NEXT:    br label [[OMP_BEFORE_SCAN_BB:%.*]]
// CHECK-64WAVE:       omp.after.scan.bb:
// CHECK-64WAVE-NEXT:    [[TMP33:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// CHECK-64WAVE-NEXT:    [[IDXPROM7:%.*]] = sext i32 [[TMP33]] to i64
// CHECK-64WAVE-NEXT:    [[ARRAYIDX8:%.*]] = getelementptr inbounds [64000 x i32], ptr [[TMP5]], i64 0, i64 [[IDXPROM7]]
// CHECK-64WAVE-NEXT:    [[TMP34:%.*]] = load i32, ptr [[ARRAYIDX8]], align 4
// CHECK-64WAVE-NEXT:    [[TMP35:%.*]] = load i32, ptr addrspace(5) [[TMP8]], align 4
// CHECK-64WAVE-NEXT:    [[TMP36:%.*]] = add i32 [[TMP35]], [[TMP34]]
// CHECK-64WAVE-NEXT:    store i32 [[TMP36]], ptr addrspace(5) [[TMP8]], align 4
// CHECK-64WAVE-NEXT:    br label [[OMP_EXIT_INSCAN_BB:%.*]]
// CHECK-64WAVE:       omp.body.continue:
// CHECK-64WAVE-NEXT:    ret void
//
//
// CHECK-64WAVE-512WGSize-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l47
// CHECK-64WAVE-512WGSize-SAME: (ptr noalias noundef [[DYN_PTR:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM1:%.*]], ptr noundef nonnull align 4 dereferenceable(512000) [[IN:%.*]], ptr noundef nonnull align 4 dereferenceable(512000) [[OUT1:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM11:%.*]], ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]], ptr noundef [[TMP2:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK-64WAVE-512WGSize-NEXT:  entry:
// CHECK-64WAVE-512WGSize-NEXT:    [[DYN_PTR_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-64WAVE-512WGSize-NEXT:    [[SUM1_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-64WAVE-512WGSize-NEXT:    [[IN_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-64WAVE-512WGSize-NEXT:    [[OUT1_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-64WAVE-512WGSize-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8, addrspace(5)
// CHECK-64WAVE-512WGSize-NEXT:    [[SUM1_ADDR2:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-64WAVE-512WGSize-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-64WAVE-512WGSize-NEXT:    [[DOTADDR3:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-64WAVE-512WGSize-NEXT:    [[DOTADDR4:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-64WAVE-512WGSize-NEXT:    [[I:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-64WAVE-512WGSize-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-64WAVE-512WGSize-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-64WAVE-512WGSize-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-64WAVE-512WGSize-NEXT:    [[SUM15:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-64WAVE-512WGSize-NEXT:    [[DYN_PTR_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DYN_PTR_ADDR]] to ptr
// CHECK-64WAVE-512WGSize-NEXT:    [[SUM1_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM1_ADDR]] to ptr
// CHECK-64WAVE-512WGSize-NEXT:    [[IN_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[IN_ADDR]] to ptr
// CHECK-64WAVE-512WGSize-NEXT:    [[OUT1_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[OUT1_ADDR]] to ptr
// CHECK-64WAVE-512WGSize-NEXT:    [[VLA_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[VLA_ADDR]] to ptr
// CHECK-64WAVE-512WGSize-NEXT:    [[SUM1_ADDR2_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM1_ADDR2]] to ptr
// CHECK-64WAVE-512WGSize-NEXT:    [[DOTADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR]] to ptr
// CHECK-64WAVE-512WGSize-NEXT:    [[DOTADDR3_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR3]] to ptr
// CHECK-64WAVE-512WGSize-NEXT:    [[DOTADDR4_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR4]] to ptr
// CHECK-64WAVE-512WGSize-NEXT:    [[I_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[I]] to ptr
// CHECK-64WAVE-512WGSize-NEXT:    [[DOTOMP_LB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_LB]] to ptr
// CHECK-64WAVE-512WGSize-NEXT:    [[DOTOMP_UB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_UB]] to ptr
// CHECK-64WAVE-512WGSize-NEXT:    [[DOTOMP_IV_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_IV]] to ptr
// CHECK-64WAVE-512WGSize-NEXT:    [[SUM15_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM15]] to ptr
// CHECK-64WAVE-512WGSize-NEXT:    store ptr [[DYN_PTR]], ptr [[DYN_PTR_ADDR_ASCAST]], align 8
// CHECK-64WAVE-512WGSize-NEXT:    store ptr [[SUM1]], ptr [[SUM1_ADDR_ASCAST]], align 8
// CHECK-64WAVE-512WGSize-NEXT:    store ptr [[IN]], ptr [[IN_ADDR_ASCAST]], align 8
// CHECK-64WAVE-512WGSize-NEXT:    store ptr [[OUT1]], ptr [[OUT1_ADDR_ASCAST]], align 8
// CHECK-64WAVE-512WGSize-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR_ASCAST]], align 8
// CHECK-64WAVE-512WGSize-NEXT:    store ptr [[SUM11]], ptr [[SUM1_ADDR2_ASCAST]], align 8
// CHECK-64WAVE-512WGSize-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR_ASCAST]], align 8
// CHECK-64WAVE-512WGSize-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR3_ASCAST]], align 8
// CHECK-64WAVE-512WGSize-NEXT:    store ptr [[TMP2]], ptr [[DOTADDR4_ASCAST]], align 8
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[SUM1_ADDR_ASCAST]], align 8
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[IN_ADDR_ASCAST]], align 8
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[OUT1_ADDR_ASCAST]], align 8
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP6:%.*]] = load i64, ptr [[VLA_ADDR_ASCAST]], align 8
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[SUM1_ADDR2_ASCAST]], align 8
// CHECK-64WAVE-512WGSize-NEXT:    call void @__kmpc_specialized_kernel_init()
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP8:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-64WAVE-512WGSize-NEXT:    store i32 0, ptr addrspace(5) [[TMP8]], align 4
// CHECK-64WAVE-512WGSize-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// CHECK-64WAVE-512WGSize-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// CHECK-64WAVE-512WGSize-NEXT:    store i32 0, ptr [[DOTOMP_LB_ASCAST]], align 4
// CHECK-64WAVE-512WGSize-NEXT:    store i32 127999, ptr [[DOTOMP_UB_ASCAST]], align 4
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP9:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// CHECK-64WAVE-512WGSize-NEXT:    store i32 [[TMP9]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP10:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// CHECK-64WAVE-512WGSize-NEXT:    [[NVPTX_NUM_THREADS:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// CHECK-64WAVE-512WGSize-NEXT:    [[GPU_BLOCK_ID:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP11:%.*]] = mul i32 [[GPU_BLOCK_ID]], [[NVPTX_NUM_THREADS]]
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP12:%.*]] = add i32 [[TMP11]], [[TMP10]]
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP13:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP14:%.*]] = add i32 [[TMP12]], [[TMP13]]
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP15:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP16:%.*]] = zext i32 [[TMP14]] to i64
// CHECK-64WAVE-512WGSize-NEXT:    [[TOTAL_NUM_THREADS:%.*]] = mul i32 [[TMP15]], [[NVPTX_NUM_THREADS]]
// CHECK-64WAVE-512WGSize-NEXT:    store i32 [[TMP14]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP17:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-64WAVE-512WGSize-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP17]], 1
// CHECK-64WAVE-512WGSize-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK-64WAVE-512WGSize-NEXT:    store i32 [[ADD]], ptr [[I_ASCAST]], align 4
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP18:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP19:%.*]] = load i32, ptr [[DOTOMP_UB_ASCAST]], align 4
// CHECK-64WAVE-512WGSize-NEXT:    [[CMP:%.*]] = icmp sle i32 [[TMP18]], [[TMP19]]
// CHECK-64WAVE-512WGSize-NEXT:    br i1 [[CMP]], label [[OMP_KERNEL_BODY:%.*]], label [[OMP_KERNEL_DONE:%.*]]
// CHECK-64WAVE-512WGSize:       omp.kernel.body:
// CHECK-64WAVE-512WGSize-NEXT:    store i32 0, ptr [[SUM15_ASCAST]], align 4
// CHECK-64WAVE-512WGSize-NEXT:    br label [[OMP_INSCAN_DISPATCH:%.*]]
// CHECK-64WAVE-512WGSize:       omp.before.scan.bb:
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP20:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// CHECK-64WAVE-512WGSize-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP20]] to i64
// CHECK-64WAVE-512WGSize-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [128000 x i32], ptr [[TMP4]], i64 0, i64 [[IDXPROM]]
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP21:%.*]] = load i32, ptr [[ARRAYIDX]], align 4
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP22:%.*]] = load i32, ptr addrspace(5) [[TMP8]], align 4
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP23:%.*]] = add i32 [[TMP22]], [[TMP21]]
// CHECK-64WAVE-512WGSize-NEXT:    store i32 [[TMP23]], ptr addrspace(5) [[TMP8]], align 4
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP24:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP25:%.*]] = zext i32 [[TMP24]] to i64
// CHECK-64WAVE-512WGSize-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK-64WAVE-512WGSize:       omp.exit.inscan.bb:
// CHECK-64WAVE-512WGSize-NEXT:    br label [[OMP_BODY_CONTINUE]]
// CHECK-64WAVE-512WGSize:       omp.inscan.dispatch:
// CHECK-64WAVE-512WGSize-NEXT:    br label [[OMP_BEFORE_SCAN_BB:%.*]]
// CHECK-64WAVE-512WGSize:       omp.after.scan.bb:
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP26:%.*]] = load i32, ptr [[TMP3]], align 4
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP27:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// CHECK-64WAVE-512WGSize-NEXT:    [[IDXPROM6:%.*]] = sext i32 [[TMP27]] to i64
// CHECK-64WAVE-512WGSize-NEXT:    [[ARRAYIDX7:%.*]] = getelementptr inbounds [128000 x i32], ptr [[TMP5]], i64 0, i64 [[IDXPROM6]]
// CHECK-64WAVE-512WGSize-NEXT:    store i32 [[TMP26]], ptr [[ARRAYIDX7]], align 4
// CHECK-64WAVE-512WGSize-NEXT:    br label [[OMP_EXIT_INSCAN_BB:%.*]]
// CHECK-64WAVE-512WGSize:       omp.body.continue:
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP28:%.*]] = load ptr, ptr [[DOTADDR_ASCAST]], align 8
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP29:%.*]] = load ptr, ptr [[DOTADDR3_ASCAST]], align 8
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP30:%.*]] = load ptr, ptr [[DOTADDR4_ASCAST]], align 8
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP31:%.*]] = load i32, ptr addrspace(5) [[TMP8]], align 4
// CHECK-64WAVE-512WGSize-NEXT:    call void @__kmpc_xteams_i_8x64(i32 [[TMP31]], ptr [[TMP30]], ptr [[TMP3]], ptr [[TMP28]], ptr [[TMP29]], ptr @__kmpc_rfun_sum_i, ptr @__kmpc_rfun_sum_lds_i, i32 0, i64 [[TMP16]], i32 [[TMP15]])
// CHECK-64WAVE-512WGSize-NEXT:    br label [[OMP_KERNEL_DONE]]
// CHECK-64WAVE-512WGSize:       omp.kernel.done:
// CHECK-64WAVE-512WGSize-NEXT:    ret void
//
//
// CHECK-64WAVE-512WGSize-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l47_1
// CHECK-64WAVE-512WGSize-SAME: (ptr noalias noundef [[DYN_PTR:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM1:%.*]], ptr noundef nonnull align 4 dereferenceable(512000) [[IN:%.*]], ptr noundef nonnull align 4 dereferenceable(512000) [[OUT1:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM11:%.*]], ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]], ptr noundef [[TMP2:%.*]]) #[[ATTR0]] {
// CHECK-64WAVE-512WGSize-NEXT:  entry:
// CHECK-64WAVE-512WGSize-NEXT:    [[DYN_PTR_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-64WAVE-512WGSize-NEXT:    [[SUM1_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-64WAVE-512WGSize-NEXT:    [[IN_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-64WAVE-512WGSize-NEXT:    [[OUT1_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-64WAVE-512WGSize-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8, addrspace(5)
// CHECK-64WAVE-512WGSize-NEXT:    [[SUM1_ADDR2:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-64WAVE-512WGSize-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-64WAVE-512WGSize-NEXT:    [[DOTADDR3:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-64WAVE-512WGSize-NEXT:    [[DOTADDR4:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-64WAVE-512WGSize-NEXT:    [[I:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-64WAVE-512WGSize-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-64WAVE-512WGSize-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-64WAVE-512WGSize-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-64WAVE-512WGSize-NEXT:    [[SUM15:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-64WAVE-512WGSize-NEXT:    [[DYN_PTR_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DYN_PTR_ADDR]] to ptr
// CHECK-64WAVE-512WGSize-NEXT:    [[SUM1_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM1_ADDR]] to ptr
// CHECK-64WAVE-512WGSize-NEXT:    [[IN_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[IN_ADDR]] to ptr
// CHECK-64WAVE-512WGSize-NEXT:    [[OUT1_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[OUT1_ADDR]] to ptr
// CHECK-64WAVE-512WGSize-NEXT:    [[VLA_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[VLA_ADDR]] to ptr
// CHECK-64WAVE-512WGSize-NEXT:    [[SUM1_ADDR2_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM1_ADDR2]] to ptr
// CHECK-64WAVE-512WGSize-NEXT:    [[DOTADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR]] to ptr
// CHECK-64WAVE-512WGSize-NEXT:    [[DOTADDR3_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR3]] to ptr
// CHECK-64WAVE-512WGSize-NEXT:    [[DOTADDR4_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR4]] to ptr
// CHECK-64WAVE-512WGSize-NEXT:    [[I_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[I]] to ptr
// CHECK-64WAVE-512WGSize-NEXT:    [[DOTOMP_LB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_LB]] to ptr
// CHECK-64WAVE-512WGSize-NEXT:    [[DOTOMP_UB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_UB]] to ptr
// CHECK-64WAVE-512WGSize-NEXT:    [[DOTOMP_IV_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_IV]] to ptr
// CHECK-64WAVE-512WGSize-NEXT:    [[SUM15_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM15]] to ptr
// CHECK-64WAVE-512WGSize-NEXT:    store ptr [[DYN_PTR]], ptr [[DYN_PTR_ADDR_ASCAST]], align 8
// CHECK-64WAVE-512WGSize-NEXT:    store ptr [[SUM1]], ptr [[SUM1_ADDR_ASCAST]], align 8
// CHECK-64WAVE-512WGSize-NEXT:    store ptr [[IN]], ptr [[IN_ADDR_ASCAST]], align 8
// CHECK-64WAVE-512WGSize-NEXT:    store ptr [[OUT1]], ptr [[OUT1_ADDR_ASCAST]], align 8
// CHECK-64WAVE-512WGSize-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR_ASCAST]], align 8
// CHECK-64WAVE-512WGSize-NEXT:    store ptr [[SUM11]], ptr [[SUM1_ADDR2_ASCAST]], align 8
// CHECK-64WAVE-512WGSize-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR_ASCAST]], align 8
// CHECK-64WAVE-512WGSize-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR3_ASCAST]], align 8
// CHECK-64WAVE-512WGSize-NEXT:    store ptr [[TMP2]], ptr [[DOTADDR4_ASCAST]], align 8
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[SUM1_ADDR_ASCAST]], align 8
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[IN_ADDR_ASCAST]], align 8
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[OUT1_ADDR_ASCAST]], align 8
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP6:%.*]] = load i64, ptr [[VLA_ADDR_ASCAST]], align 8
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[SUM1_ADDR2_ASCAST]], align 8
// CHECK-64WAVE-512WGSize-NEXT:    call void @__kmpc_specialized_kernel_init()
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP8:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-64WAVE-512WGSize-NEXT:    store i32 0, ptr addrspace(5) [[TMP8]], align 4
// CHECK-64WAVE-512WGSize-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// CHECK-64WAVE-512WGSize-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// CHECK-64WAVE-512WGSize-NEXT:    store i32 0, ptr [[DOTOMP_LB_ASCAST]], align 4
// CHECK-64WAVE-512WGSize-NEXT:    store i32 127999, ptr [[DOTOMP_UB_ASCAST]], align 4
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP9:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// CHECK-64WAVE-512WGSize-NEXT:    store i32 [[TMP9]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP10:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// CHECK-64WAVE-512WGSize-NEXT:    [[NVPTX_NUM_THREADS:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// CHECK-64WAVE-512WGSize-NEXT:    [[GPU_BLOCK_ID:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP11:%.*]] = mul i32 [[GPU_BLOCK_ID]], [[NVPTX_NUM_THREADS]]
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP12:%.*]] = add i32 [[TMP11]], [[TMP10]]
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP13:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP14:%.*]] = add i32 [[TMP12]], [[TMP13]]
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP15:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP16:%.*]] = zext i32 [[TMP14]] to i64
// CHECK-64WAVE-512WGSize-NEXT:    [[TOTAL_NUM_THREADS:%.*]] = mul i32 [[TMP15]], [[NVPTX_NUM_THREADS]]
// CHECK-64WAVE-512WGSize-NEXT:    store i32 [[TMP14]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP17:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-64WAVE-512WGSize-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP17]], 1
// CHECK-64WAVE-512WGSize-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK-64WAVE-512WGSize-NEXT:    store i32 [[ADD]], ptr [[I_ASCAST]], align 4
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP18:%.*]] = load ptr, ptr [[DOTADDR_ASCAST]], align 8
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP19:%.*]] = load ptr, ptr [[DOTADDR4_ASCAST]], align 8
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP20:%.*]] = load ptr, ptr [[DOTADDR_ASCAST]], align 8
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP21:%.*]] = load ptr, ptr [[DOTADDR4_ASCAST]], align 8
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP22:%.*]] = load i32, ptr addrspace(5) [[TMP8]], align 4
// CHECK-64WAVE-512WGSize-NEXT:    call void @__kmpc_xteams_phase2_i_8x64(ptr [[TMP21]], i32 1, ptr [[TMP20]], ptr [[TMP21]], ptr @__kmpc_rfun_sum_i, i32 0, i64 [[TMP16]], i32 1)
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP23:%.*]] = add i32 [[TMP12]], [[TOTAL_NUM_THREADS]]
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP24:%.*]] = getelementptr i32, ptr [[TMP19]], i32 [[TMP23]]
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP25:%.*]] = load i32, ptr [[TMP24]], align 4
// CHECK-64WAVE-512WGSize-NEXT:    store i32 [[TMP25]], ptr addrspace(5) [[TMP8]], align 4
// CHECK-64WAVE-512WGSize-NEXT:    store i32 0, ptr [[SUM15_ASCAST]], align 4
// CHECK-64WAVE-512WGSize-NEXT:    br label [[OMP_INSCAN_DISPATCH:%.*]]
// CHECK-64WAVE-512WGSize:       omp.before.scan.bb:
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP26:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// CHECK-64WAVE-512WGSize-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP26]] to i64
// CHECK-64WAVE-512WGSize-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [128000 x i32], ptr [[TMP4]], i64 0, i64 [[IDXPROM]]
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP27:%.*]] = load i32, ptr [[ARRAYIDX]], align 4
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP28:%.*]] = load i32, ptr addrspace(5) [[TMP8]], align 4
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP29:%.*]] = add i32 [[TMP28]], [[TMP27]]
// CHECK-64WAVE-512WGSize-NEXT:    store i32 [[TMP29]], ptr addrspace(5) [[TMP8]], align 4
// CHECK-64WAVE-512WGSize-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK-64WAVE-512WGSize:       omp.exit.inscan.bb:
// CHECK-64WAVE-512WGSize-NEXT:    br label [[OMP_BODY_CONTINUE]]
// CHECK-64WAVE-512WGSize:       omp.inscan.dispatch:
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP30:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP31:%.*]] = zext i32 [[TMP30]] to i64
// CHECK-64WAVE-512WGSize-NEXT:    [[ARRAYIDX6:%.*]] = getelementptr inbounds nuw i32, ptr [[TMP7]], i64 [[TMP31]]
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP32:%.*]] = load i32, ptr addrspace(5) [[TMP8]], align 4
// CHECK-64WAVE-512WGSize-NEXT:    store i32 [[TMP32]], ptr [[TMP3]], align 4
// CHECK-64WAVE-512WGSize-NEXT:    br label [[OMP_AFTER_SCAN_BB:%.*]]
// CHECK-64WAVE-512WGSize:       omp.after.scan.bb:
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP33:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// CHECK-64WAVE-512WGSize-NEXT:    [[IDXPROM7:%.*]] = sext i32 [[TMP33]] to i64
// CHECK-64WAVE-512WGSize-NEXT:    [[ARRAYIDX8:%.*]] = getelementptr inbounds [128000 x i32], ptr [[TMP5]], i64 0, i64 [[IDXPROM7]]
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP34:%.*]] = load i32, ptr addrspace(5) [[TMP8]], align 4
// CHECK-64WAVE-512WGSize-NEXT:    store i32 [[TMP34]], ptr [[ARRAYIDX8]], align 4
// CHECK-64WAVE-512WGSize-NEXT:    br label [[OMP_EXIT_INSCAN_BB:%.*]]
// CHECK-64WAVE-512WGSize:       omp.body.continue:
// CHECK-64WAVE-512WGSize-NEXT:    ret void
//
//
// CHECK-64WAVE-512WGSize-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l57
// CHECK-64WAVE-512WGSize-SAME: (ptr noalias noundef [[DYN_PTR:%.*]], ptr noundef nonnull align 4 dereferenceable(512000) [[OUT2:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM2:%.*]], ptr noundef nonnull align 4 dereferenceable(512000) [[IN:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM21:%.*]], ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]], ptr noundef [[TMP2:%.*]]) #[[ATTR0]] {
// CHECK-64WAVE-512WGSize-NEXT:  entry:
// CHECK-64WAVE-512WGSize-NEXT:    [[DYN_PTR_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-64WAVE-512WGSize-NEXT:    [[OUT2_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-64WAVE-512WGSize-NEXT:    [[SUM2_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-64WAVE-512WGSize-NEXT:    [[IN_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-64WAVE-512WGSize-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8, addrspace(5)
// CHECK-64WAVE-512WGSize-NEXT:    [[SUM2_ADDR2:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-64WAVE-512WGSize-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-64WAVE-512WGSize-NEXT:    [[DOTADDR3:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-64WAVE-512WGSize-NEXT:    [[DOTADDR4:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-64WAVE-512WGSize-NEXT:    [[I:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-64WAVE-512WGSize-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-64WAVE-512WGSize-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-64WAVE-512WGSize-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-64WAVE-512WGSize-NEXT:    [[SUM25:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-64WAVE-512WGSize-NEXT:    [[DYN_PTR_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DYN_PTR_ADDR]] to ptr
// CHECK-64WAVE-512WGSize-NEXT:    [[OUT2_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[OUT2_ADDR]] to ptr
// CHECK-64WAVE-512WGSize-NEXT:    [[SUM2_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM2_ADDR]] to ptr
// CHECK-64WAVE-512WGSize-NEXT:    [[IN_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[IN_ADDR]] to ptr
// CHECK-64WAVE-512WGSize-NEXT:    [[VLA_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[VLA_ADDR]] to ptr
// CHECK-64WAVE-512WGSize-NEXT:    [[SUM2_ADDR2_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM2_ADDR2]] to ptr
// CHECK-64WAVE-512WGSize-NEXT:    [[DOTADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR]] to ptr
// CHECK-64WAVE-512WGSize-NEXT:    [[DOTADDR3_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR3]] to ptr
// CHECK-64WAVE-512WGSize-NEXT:    [[DOTADDR4_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR4]] to ptr
// CHECK-64WAVE-512WGSize-NEXT:    [[I_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[I]] to ptr
// CHECK-64WAVE-512WGSize-NEXT:    [[DOTOMP_LB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_LB]] to ptr
// CHECK-64WAVE-512WGSize-NEXT:    [[DOTOMP_UB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_UB]] to ptr
// CHECK-64WAVE-512WGSize-NEXT:    [[DOTOMP_IV_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_IV]] to ptr
// CHECK-64WAVE-512WGSize-NEXT:    [[SUM25_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM25]] to ptr
// CHECK-64WAVE-512WGSize-NEXT:    store ptr [[DYN_PTR]], ptr [[DYN_PTR_ADDR_ASCAST]], align 8
// CHECK-64WAVE-512WGSize-NEXT:    store ptr [[OUT2]], ptr [[OUT2_ADDR_ASCAST]], align 8
// CHECK-64WAVE-512WGSize-NEXT:    store ptr [[SUM2]], ptr [[SUM2_ADDR_ASCAST]], align 8
// CHECK-64WAVE-512WGSize-NEXT:    store ptr [[IN]], ptr [[IN_ADDR_ASCAST]], align 8
// CHECK-64WAVE-512WGSize-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR_ASCAST]], align 8
// CHECK-64WAVE-512WGSize-NEXT:    store ptr [[SUM21]], ptr [[SUM2_ADDR2_ASCAST]], align 8
// CHECK-64WAVE-512WGSize-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR_ASCAST]], align 8
// CHECK-64WAVE-512WGSize-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR3_ASCAST]], align 8
// CHECK-64WAVE-512WGSize-NEXT:    store ptr [[TMP2]], ptr [[DOTADDR4_ASCAST]], align 8
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[OUT2_ADDR_ASCAST]], align 8
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[SUM2_ADDR_ASCAST]], align 8
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[IN_ADDR_ASCAST]], align 8
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP6:%.*]] = load i64, ptr [[VLA_ADDR_ASCAST]], align 8
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[SUM2_ADDR2_ASCAST]], align 8
// CHECK-64WAVE-512WGSize-NEXT:    call void @__kmpc_specialized_kernel_init()
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP8:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-64WAVE-512WGSize-NEXT:    store i32 0, ptr addrspace(5) [[TMP8]], align 4
// CHECK-64WAVE-512WGSize-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// CHECK-64WAVE-512WGSize-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// CHECK-64WAVE-512WGSize-NEXT:    store i32 0, ptr [[DOTOMP_LB_ASCAST]], align 4
// CHECK-64WAVE-512WGSize-NEXT:    store i32 127999, ptr [[DOTOMP_UB_ASCAST]], align 4
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP9:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// CHECK-64WAVE-512WGSize-NEXT:    store i32 [[TMP9]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP10:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// CHECK-64WAVE-512WGSize-NEXT:    [[NVPTX_NUM_THREADS:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// CHECK-64WAVE-512WGSize-NEXT:    [[GPU_BLOCK_ID:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP11:%.*]] = mul i32 [[GPU_BLOCK_ID]], [[NVPTX_NUM_THREADS]]
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP12:%.*]] = add i32 [[TMP11]], [[TMP10]]
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP13:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP14:%.*]] = add i32 [[TMP12]], [[TMP13]]
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP15:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP16:%.*]] = zext i32 [[TMP14]] to i64
// CHECK-64WAVE-512WGSize-NEXT:    [[TOTAL_NUM_THREADS:%.*]] = mul i32 [[TMP15]], [[NVPTX_NUM_THREADS]]
// CHECK-64WAVE-512WGSize-NEXT:    store i32 [[TMP14]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP17:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-64WAVE-512WGSize-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP17]], 1
// CHECK-64WAVE-512WGSize-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK-64WAVE-512WGSize-NEXT:    store i32 [[ADD]], ptr [[I_ASCAST]], align 4
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP18:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP19:%.*]] = load i32, ptr [[DOTOMP_UB_ASCAST]], align 4
// CHECK-64WAVE-512WGSize-NEXT:    [[CMP:%.*]] = icmp sle i32 [[TMP18]], [[TMP19]]
// CHECK-64WAVE-512WGSize-NEXT:    br i1 [[CMP]], label [[OMP_KERNEL_BODY:%.*]], label [[OMP_KERNEL_DONE:%.*]]
// CHECK-64WAVE-512WGSize:       omp.kernel.body:
// CHECK-64WAVE-512WGSize-NEXT:    store i32 0, ptr [[SUM25_ASCAST]], align 4
// CHECK-64WAVE-512WGSize-NEXT:    br label [[OMP_INSCAN_DISPATCH:%.*]]
// CHECK-64WAVE-512WGSize:       omp.before.scan.bb:
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP20:%.*]] = load i32, ptr [[TMP4]], align 4
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP21:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// CHECK-64WAVE-512WGSize-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP21]] to i64
// CHECK-64WAVE-512WGSize-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [128000 x i32], ptr [[TMP3]], i64 0, i64 [[IDXPROM]]
// CHECK-64WAVE-512WGSize-NEXT:    store i32 [[TMP20]], ptr [[ARRAYIDX]], align 4
// CHECK-64WAVE-512WGSize-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK-64WAVE-512WGSize:       omp.exit.inscan.bb:
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP22:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP23:%.*]] = zext i32 [[TMP22]] to i64
// CHECK-64WAVE-512WGSize-NEXT:    br label [[OMP_BODY_CONTINUE]]
// CHECK-64WAVE-512WGSize:       omp.inscan.dispatch:
// CHECK-64WAVE-512WGSize-NEXT:    br label [[OMP_AFTER_SCAN_BB:%.*]]
// CHECK-64WAVE-512WGSize:       omp.after.scan.bb:
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP24:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// CHECK-64WAVE-512WGSize-NEXT:    [[IDXPROM6:%.*]] = sext i32 [[TMP24]] to i64
// CHECK-64WAVE-512WGSize-NEXT:    [[ARRAYIDX7:%.*]] = getelementptr inbounds [128000 x i32], ptr [[TMP5]], i64 0, i64 [[IDXPROM6]]
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP25:%.*]] = load i32, ptr [[ARRAYIDX7]], align 4
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP26:%.*]] = load i32, ptr addrspace(5) [[TMP8]], align 4
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP27:%.*]] = add i32 [[TMP26]], [[TMP25]]
// CHECK-64WAVE-512WGSize-NEXT:    store i32 [[TMP27]], ptr addrspace(5) [[TMP8]], align 4
// CHECK-64WAVE-512WGSize-NEXT:    br label [[OMP_EXIT_INSCAN_BB:%.*]]
// CHECK-64WAVE-512WGSize:       omp.body.continue:
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP28:%.*]] = load ptr, ptr [[DOTADDR_ASCAST]], align 8
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP29:%.*]] = load ptr, ptr [[DOTADDR3_ASCAST]], align 8
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP30:%.*]] = load ptr, ptr [[DOTADDR4_ASCAST]], align 8
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP31:%.*]] = load i32, ptr addrspace(5) [[TMP8]], align 4
// CHECK-64WAVE-512WGSize-NEXT:    call void @__kmpc_xteams_i_8x64(i32 [[TMP31]], ptr [[TMP30]], ptr [[TMP4]], ptr [[TMP28]], ptr [[TMP29]], ptr @__kmpc_rfun_sum_i, ptr @__kmpc_rfun_sum_lds_i, i32 0, i64 [[TMP16]], i32 [[TMP15]])
// CHECK-64WAVE-512WGSize-NEXT:    br label [[OMP_KERNEL_DONE]]
// CHECK-64WAVE-512WGSize:       omp.kernel.done:
// CHECK-64WAVE-512WGSize-NEXT:    ret void
//
//
// CHECK-64WAVE-512WGSize-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l57_1
// CHECK-64WAVE-512WGSize-SAME: (ptr noalias noundef [[DYN_PTR:%.*]], ptr noundef nonnull align 4 dereferenceable(512000) [[OUT2:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM2:%.*]], ptr noundef nonnull align 4 dereferenceable(512000) [[IN:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM21:%.*]], ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]], ptr noundef [[TMP2:%.*]]) #[[ATTR0]] {
// CHECK-64WAVE-512WGSize-NEXT:  entry:
// CHECK-64WAVE-512WGSize-NEXT:    [[DYN_PTR_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-64WAVE-512WGSize-NEXT:    [[OUT2_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-64WAVE-512WGSize-NEXT:    [[SUM2_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-64WAVE-512WGSize-NEXT:    [[IN_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-64WAVE-512WGSize-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8, addrspace(5)
// CHECK-64WAVE-512WGSize-NEXT:    [[SUM2_ADDR2:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-64WAVE-512WGSize-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-64WAVE-512WGSize-NEXT:    [[DOTADDR3:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-64WAVE-512WGSize-NEXT:    [[DOTADDR4:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-64WAVE-512WGSize-NEXT:    [[I:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-64WAVE-512WGSize-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-64WAVE-512WGSize-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-64WAVE-512WGSize-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-64WAVE-512WGSize-NEXT:    [[SUM25:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-64WAVE-512WGSize-NEXT:    [[DYN_PTR_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DYN_PTR_ADDR]] to ptr
// CHECK-64WAVE-512WGSize-NEXT:    [[OUT2_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[OUT2_ADDR]] to ptr
// CHECK-64WAVE-512WGSize-NEXT:    [[SUM2_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM2_ADDR]] to ptr
// CHECK-64WAVE-512WGSize-NEXT:    [[IN_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[IN_ADDR]] to ptr
// CHECK-64WAVE-512WGSize-NEXT:    [[VLA_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[VLA_ADDR]] to ptr
// CHECK-64WAVE-512WGSize-NEXT:    [[SUM2_ADDR2_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM2_ADDR2]] to ptr
// CHECK-64WAVE-512WGSize-NEXT:    [[DOTADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR]] to ptr
// CHECK-64WAVE-512WGSize-NEXT:    [[DOTADDR3_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR3]] to ptr
// CHECK-64WAVE-512WGSize-NEXT:    [[DOTADDR4_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR4]] to ptr
// CHECK-64WAVE-512WGSize-NEXT:    [[I_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[I]] to ptr
// CHECK-64WAVE-512WGSize-NEXT:    [[DOTOMP_LB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_LB]] to ptr
// CHECK-64WAVE-512WGSize-NEXT:    [[DOTOMP_UB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_UB]] to ptr
// CHECK-64WAVE-512WGSize-NEXT:    [[DOTOMP_IV_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_IV]] to ptr
// CHECK-64WAVE-512WGSize-NEXT:    [[SUM25_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM25]] to ptr
// CHECK-64WAVE-512WGSize-NEXT:    store ptr [[DYN_PTR]], ptr [[DYN_PTR_ADDR_ASCAST]], align 8
// CHECK-64WAVE-512WGSize-NEXT:    store ptr [[OUT2]], ptr [[OUT2_ADDR_ASCAST]], align 8
// CHECK-64WAVE-512WGSize-NEXT:    store ptr [[SUM2]], ptr [[SUM2_ADDR_ASCAST]], align 8
// CHECK-64WAVE-512WGSize-NEXT:    store ptr [[IN]], ptr [[IN_ADDR_ASCAST]], align 8
// CHECK-64WAVE-512WGSize-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR_ASCAST]], align 8
// CHECK-64WAVE-512WGSize-NEXT:    store ptr [[SUM21]], ptr [[SUM2_ADDR2_ASCAST]], align 8
// CHECK-64WAVE-512WGSize-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR_ASCAST]], align 8
// CHECK-64WAVE-512WGSize-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR3_ASCAST]], align 8
// CHECK-64WAVE-512WGSize-NEXT:    store ptr [[TMP2]], ptr [[DOTADDR4_ASCAST]], align 8
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[OUT2_ADDR_ASCAST]], align 8
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[SUM2_ADDR_ASCAST]], align 8
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[IN_ADDR_ASCAST]], align 8
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP6:%.*]] = load i64, ptr [[VLA_ADDR_ASCAST]], align 8
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[SUM2_ADDR2_ASCAST]], align 8
// CHECK-64WAVE-512WGSize-NEXT:    call void @__kmpc_specialized_kernel_init()
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP8:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-64WAVE-512WGSize-NEXT:    store i32 0, ptr addrspace(5) [[TMP8]], align 4
// CHECK-64WAVE-512WGSize-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// CHECK-64WAVE-512WGSize-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// CHECK-64WAVE-512WGSize-NEXT:    store i32 0, ptr [[DOTOMP_LB_ASCAST]], align 4
// CHECK-64WAVE-512WGSize-NEXT:    store i32 127999, ptr [[DOTOMP_UB_ASCAST]], align 4
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP9:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// CHECK-64WAVE-512WGSize-NEXT:    store i32 [[TMP9]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP10:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// CHECK-64WAVE-512WGSize-NEXT:    [[NVPTX_NUM_THREADS:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// CHECK-64WAVE-512WGSize-NEXT:    [[GPU_BLOCK_ID:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP11:%.*]] = mul i32 [[GPU_BLOCK_ID]], [[NVPTX_NUM_THREADS]]
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP12:%.*]] = add i32 [[TMP11]], [[TMP10]]
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP13:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP14:%.*]] = add i32 [[TMP12]], [[TMP13]]
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP15:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP16:%.*]] = zext i32 [[TMP14]] to i64
// CHECK-64WAVE-512WGSize-NEXT:    [[TOTAL_NUM_THREADS:%.*]] = mul i32 [[TMP15]], [[NVPTX_NUM_THREADS]]
// CHECK-64WAVE-512WGSize-NEXT:    store i32 [[TMP14]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP17:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-64WAVE-512WGSize-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP17]], 1
// CHECK-64WAVE-512WGSize-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK-64WAVE-512WGSize-NEXT:    store i32 [[ADD]], ptr [[I_ASCAST]], align 4
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP18:%.*]] = load ptr, ptr [[DOTADDR_ASCAST]], align 8
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP19:%.*]] = load ptr, ptr [[DOTADDR4_ASCAST]], align 8
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP20:%.*]] = load ptr, ptr [[DOTADDR_ASCAST]], align 8
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP21:%.*]] = load ptr, ptr [[DOTADDR4_ASCAST]], align 8
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP22:%.*]] = load i32, ptr addrspace(5) [[TMP8]], align 4
// CHECK-64WAVE-512WGSize-NEXT:    call void @__kmpc_xteams_phase2_i_8x64(ptr [[TMP21]], i32 1, ptr [[TMP20]], ptr [[TMP21]], ptr @__kmpc_rfun_sum_i, i32 0, i64 [[TMP16]], i32 0)
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP23:%.*]] = add i32 [[TMP12]], [[TOTAL_NUM_THREADS]]
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP24:%.*]] = getelementptr i32, ptr [[TMP19]], i32 [[TMP23]]
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP25:%.*]] = load i32, ptr [[TMP24]], align 4
// CHECK-64WAVE-512WGSize-NEXT:    store i32 [[TMP25]], ptr addrspace(5) [[TMP8]], align 4
// CHECK-64WAVE-512WGSize-NEXT:    store i32 0, ptr [[SUM25_ASCAST]], align 4
// CHECK-64WAVE-512WGSize-NEXT:    br label [[OMP_INSCAN_DISPATCH:%.*]]
// CHECK-64WAVE-512WGSize:       omp.before.scan.bb:
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP26:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// CHECK-64WAVE-512WGSize-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP26]] to i64
// CHECK-64WAVE-512WGSize-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [128000 x i32], ptr [[TMP3]], i64 0, i64 [[IDXPROM]]
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP27:%.*]] = load i32, ptr addrspace(5) [[TMP8]], align 4
// CHECK-64WAVE-512WGSize-NEXT:    store i32 [[TMP27]], ptr [[ARRAYIDX]], align 4
// CHECK-64WAVE-512WGSize-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK-64WAVE-512WGSize:       omp.exit.inscan.bb:
// CHECK-64WAVE-512WGSize-NEXT:    br label [[OMP_BODY_CONTINUE]]
// CHECK-64WAVE-512WGSize:       omp.inscan.dispatch:
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP28:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP29:%.*]] = zext i32 [[TMP28]] to i64
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP30:%.*]] = icmp eq i64 [[TMP29]], 0
// CHECK-64WAVE-512WGSize-NEXT:    br i1 [[TMP30]], label [[OMP_EXCLUSIVE_COPY_EXIT:%.*]], label [[OMP_EXCLUSIVE_DEC:%.*]]
// CHECK-64WAVE-512WGSize:       omp.exclusive.dec:
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP31:%.*]] = sub nuw i64 [[TMP29]], 1
// CHECK-64WAVE-512WGSize-NEXT:    [[ARRAYIDX6:%.*]] = getelementptr inbounds nuw i32, ptr [[TMP7]], i64 [[TMP31]]
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP32:%.*]] = load i32, ptr addrspace(5) [[TMP8]], align 4
// CHECK-64WAVE-512WGSize-NEXT:    store i32 [[TMP32]], ptr [[TMP4]], align 4
// CHECK-64WAVE-512WGSize-NEXT:    br label [[OMP_EXCLUSIVE_COPY_EXIT]]
// CHECK-64WAVE-512WGSize:       omp.exclusive.copy.exit:
// CHECK-64WAVE-512WGSize-NEXT:    br label [[OMP_BEFORE_SCAN_BB:%.*]]
// CHECK-64WAVE-512WGSize:       omp.after.scan.bb:
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP33:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// CHECK-64WAVE-512WGSize-NEXT:    [[IDXPROM7:%.*]] = sext i32 [[TMP33]] to i64
// CHECK-64WAVE-512WGSize-NEXT:    [[ARRAYIDX8:%.*]] = getelementptr inbounds [128000 x i32], ptr [[TMP5]], i64 0, i64 [[IDXPROM7]]
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP34:%.*]] = load i32, ptr [[ARRAYIDX8]], align 4
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP35:%.*]] = load i32, ptr addrspace(5) [[TMP8]], align 4
// CHECK-64WAVE-512WGSize-NEXT:    [[TMP36:%.*]] = add i32 [[TMP35]], [[TMP34]]
// CHECK-64WAVE-512WGSize-NEXT:    store i32 [[TMP36]], ptr addrspace(5) [[TMP8]], align 4
// CHECK-64WAVE-512WGSize-NEXT:    br label [[OMP_EXIT_INSCAN_BB:%.*]]
// CHECK-64WAVE-512WGSize:       omp.body.continue:
// CHECK-64WAVE-512WGSize-NEXT:    ret void
//
//
// CHECK-32WAVE-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l47
// CHECK-32WAVE-SAME: (ptr noalias noundef [[DYN_PTR:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM1:%.*]], ptr noundef nonnull align 4 dereferenceable(256000) [[IN:%.*]], ptr noundef nonnull align 4 dereferenceable(256000) [[OUT1:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM11:%.*]], ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]], ptr noundef [[TMP2:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK-32WAVE-NEXT:  entry:
// CHECK-32WAVE-NEXT:    [[DYN_PTR_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-32WAVE-NEXT:    [[SUM1_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-32WAVE-NEXT:    [[IN_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-32WAVE-NEXT:    [[OUT1_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-32WAVE-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8, addrspace(5)
// CHECK-32WAVE-NEXT:    [[SUM1_ADDR2:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-32WAVE-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-32WAVE-NEXT:    [[DOTADDR3:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-32WAVE-NEXT:    [[DOTADDR4:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-32WAVE-NEXT:    [[I:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-32WAVE-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-32WAVE-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-32WAVE-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-32WAVE-NEXT:    [[SUM15:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-32WAVE-NEXT:    [[DYN_PTR_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DYN_PTR_ADDR]] to ptr
// CHECK-32WAVE-NEXT:    [[SUM1_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM1_ADDR]] to ptr
// CHECK-32WAVE-NEXT:    [[IN_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[IN_ADDR]] to ptr
// CHECK-32WAVE-NEXT:    [[OUT1_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[OUT1_ADDR]] to ptr
// CHECK-32WAVE-NEXT:    [[VLA_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[VLA_ADDR]] to ptr
// CHECK-32WAVE-NEXT:    [[SUM1_ADDR2_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM1_ADDR2]] to ptr
// CHECK-32WAVE-NEXT:    [[DOTADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR]] to ptr
// CHECK-32WAVE-NEXT:    [[DOTADDR3_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR3]] to ptr
// CHECK-32WAVE-NEXT:    [[DOTADDR4_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR4]] to ptr
// CHECK-32WAVE-NEXT:    [[I_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[I]] to ptr
// CHECK-32WAVE-NEXT:    [[DOTOMP_LB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_LB]] to ptr
// CHECK-32WAVE-NEXT:    [[DOTOMP_UB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_UB]] to ptr
// CHECK-32WAVE-NEXT:    [[DOTOMP_IV_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_IV]] to ptr
// CHECK-32WAVE-NEXT:    [[SUM15_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM15]] to ptr
// CHECK-32WAVE-NEXT:    store ptr [[DYN_PTR]], ptr [[DYN_PTR_ADDR_ASCAST]], align 8
// CHECK-32WAVE-NEXT:    store ptr [[SUM1]], ptr [[SUM1_ADDR_ASCAST]], align 8
// CHECK-32WAVE-NEXT:    store ptr [[IN]], ptr [[IN_ADDR_ASCAST]], align 8
// CHECK-32WAVE-NEXT:    store ptr [[OUT1]], ptr [[OUT1_ADDR_ASCAST]], align 8
// CHECK-32WAVE-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR_ASCAST]], align 8
// CHECK-32WAVE-NEXT:    store ptr [[SUM11]], ptr [[SUM1_ADDR2_ASCAST]], align 8
// CHECK-32WAVE-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR_ASCAST]], align 8
// CHECK-32WAVE-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR3_ASCAST]], align 8
// CHECK-32WAVE-NEXT:    store ptr [[TMP2]], ptr [[DOTADDR4_ASCAST]], align 8
// CHECK-32WAVE-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[SUM1_ADDR_ASCAST]], align 8
// CHECK-32WAVE-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[IN_ADDR_ASCAST]], align 8
// CHECK-32WAVE-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[OUT1_ADDR_ASCAST]], align 8
// CHECK-32WAVE-NEXT:    [[TMP6:%.*]] = load i64, ptr [[VLA_ADDR_ASCAST]], align 8
// CHECK-32WAVE-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[SUM1_ADDR2_ASCAST]], align 8
// CHECK-32WAVE-NEXT:    call void @__kmpc_specialized_kernel_init()
// CHECK-32WAVE-NEXT:    [[TMP8:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-32WAVE-NEXT:    store i32 0, ptr addrspace(5) [[TMP8]], align 4
// CHECK-32WAVE-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// CHECK-32WAVE-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// CHECK-32WAVE-NEXT:    store i32 0, ptr [[DOTOMP_LB_ASCAST]], align 4
// CHECK-32WAVE-NEXT:    store i32 63999, ptr [[DOTOMP_UB_ASCAST]], align 4
// CHECK-32WAVE-NEXT:    [[TMP9:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// CHECK-32WAVE-NEXT:    store i32 [[TMP9]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-32WAVE-NEXT:    [[TMP10:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// CHECK-32WAVE-NEXT:    [[NVPTX_NUM_THREADS:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// CHECK-32WAVE-NEXT:    [[GPU_BLOCK_ID:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// CHECK-32WAVE-NEXT:    [[TMP11:%.*]] = mul i32 [[GPU_BLOCK_ID]], [[NVPTX_NUM_THREADS]]
// CHECK-32WAVE-NEXT:    [[TMP12:%.*]] = add i32 [[TMP11]], [[TMP10]]
// CHECK-32WAVE-NEXT:    [[TMP13:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-32WAVE-NEXT:    [[TMP14:%.*]] = add i32 [[TMP12]], [[TMP13]]
// CHECK-32WAVE-NEXT:    [[TMP15:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// CHECK-32WAVE-NEXT:    [[TMP16:%.*]] = zext i32 [[TMP14]] to i64
// CHECK-32WAVE-NEXT:    [[TOTAL_NUM_THREADS:%.*]] = mul i32 [[TMP15]], [[NVPTX_NUM_THREADS]]
// CHECK-32WAVE-NEXT:    store i32 [[TMP14]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-32WAVE-NEXT:    [[TMP17:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-32WAVE-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP17]], 1
// CHECK-32WAVE-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK-32WAVE-NEXT:    store i32 [[ADD]], ptr [[I_ASCAST]], align 4
// CHECK-32WAVE-NEXT:    [[TMP18:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-32WAVE-NEXT:    [[TMP19:%.*]] = load i32, ptr [[DOTOMP_UB_ASCAST]], align 4
// CHECK-32WAVE-NEXT:    [[CMP:%.*]] = icmp sle i32 [[TMP18]], [[TMP19]]
// CHECK-32WAVE-NEXT:    br i1 [[CMP]], label [[OMP_KERNEL_BODY:%.*]], label [[OMP_KERNEL_DONE:%.*]]
// CHECK-32WAVE:       omp.kernel.body:
// CHECK-32WAVE-NEXT:    store i32 0, ptr [[SUM15_ASCAST]], align 4
// CHECK-32WAVE-NEXT:    br label [[OMP_INSCAN_DISPATCH:%.*]]
// CHECK-32WAVE:       omp.before.scan.bb:
// CHECK-32WAVE-NEXT:    [[TMP20:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// CHECK-32WAVE-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP20]] to i64
// CHECK-32WAVE-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [64000 x i32], ptr [[TMP4]], i64 0, i64 [[IDXPROM]]
// CHECK-32WAVE-NEXT:    [[TMP21:%.*]] = load i32, ptr [[ARRAYIDX]], align 4
// CHECK-32WAVE-NEXT:    [[TMP22:%.*]] = load i32, ptr addrspace(5) [[TMP8]], align 4
// CHECK-32WAVE-NEXT:    [[TMP23:%.*]] = add i32 [[TMP22]], [[TMP21]]
// CHECK-32WAVE-NEXT:    store i32 [[TMP23]], ptr addrspace(5) [[TMP8]], align 4
// CHECK-32WAVE-NEXT:    [[TMP24:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-32WAVE-NEXT:    [[TMP25:%.*]] = zext i32 [[TMP24]] to i64
// CHECK-32WAVE-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK-32WAVE:       omp.exit.inscan.bb:
// CHECK-32WAVE-NEXT:    br label [[OMP_BODY_CONTINUE]]
// CHECK-32WAVE:       omp.inscan.dispatch:
// CHECK-32WAVE-NEXT:    br label [[OMP_BEFORE_SCAN_BB:%.*]]
// CHECK-32WAVE:       omp.after.scan.bb:
// CHECK-32WAVE-NEXT:    [[TMP26:%.*]] = load i32, ptr [[TMP3]], align 4
// CHECK-32WAVE-NEXT:    [[TMP27:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// CHECK-32WAVE-NEXT:    [[IDXPROM6:%.*]] = sext i32 [[TMP27]] to i64
// CHECK-32WAVE-NEXT:    [[ARRAYIDX7:%.*]] = getelementptr inbounds [64000 x i32], ptr [[TMP5]], i64 0, i64 [[IDXPROM6]]
// CHECK-32WAVE-NEXT:    store i32 [[TMP26]], ptr [[ARRAYIDX7]], align 4
// CHECK-32WAVE-NEXT:    br label [[OMP_EXIT_INSCAN_BB:%.*]]
// CHECK-32WAVE:       omp.body.continue:
// CHECK-32WAVE-NEXT:    [[TMP28:%.*]] = load ptr, ptr [[DOTADDR_ASCAST]], align 8
// CHECK-32WAVE-NEXT:    [[TMP29:%.*]] = load ptr, ptr [[DOTADDR3_ASCAST]], align 8
// CHECK-32WAVE-NEXT:    [[TMP30:%.*]] = load ptr, ptr [[DOTADDR4_ASCAST]], align 8
// CHECK-32WAVE-NEXT:    [[TMP31:%.*]] = load i32, ptr addrspace(5) [[TMP8]], align 4
// CHECK-32WAVE-NEXT:    call void @__kmpc_xteams_i_8x32(i32 [[TMP31]], ptr [[TMP30]], ptr [[TMP3]], ptr [[TMP28]], ptr [[TMP29]], ptr @__kmpc_rfun_sum_i, ptr @__kmpc_rfun_sum_lds_i, i32 0, i64 [[TMP16]], i32 [[TMP15]])
// CHECK-32WAVE-NEXT:    br label [[OMP_KERNEL_DONE]]
// CHECK-32WAVE:       omp.kernel.done:
// CHECK-32WAVE-NEXT:    ret void
//
//
// CHECK-32WAVE-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l47_1
// CHECK-32WAVE-SAME: (ptr noalias noundef [[DYN_PTR:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM1:%.*]], ptr noundef nonnull align 4 dereferenceable(256000) [[IN:%.*]], ptr noundef nonnull align 4 dereferenceable(256000) [[OUT1:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM11:%.*]], ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]], ptr noundef [[TMP2:%.*]]) #[[ATTR0]] {
// CHECK-32WAVE-NEXT:  entry:
// CHECK-32WAVE-NEXT:    [[DYN_PTR_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-32WAVE-NEXT:    [[SUM1_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-32WAVE-NEXT:    [[IN_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-32WAVE-NEXT:    [[OUT1_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-32WAVE-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8, addrspace(5)
// CHECK-32WAVE-NEXT:    [[SUM1_ADDR2:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-32WAVE-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-32WAVE-NEXT:    [[DOTADDR3:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-32WAVE-NEXT:    [[DOTADDR4:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-32WAVE-NEXT:    [[I:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-32WAVE-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-32WAVE-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-32WAVE-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-32WAVE-NEXT:    [[SUM15:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-32WAVE-NEXT:    [[DYN_PTR_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DYN_PTR_ADDR]] to ptr
// CHECK-32WAVE-NEXT:    [[SUM1_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM1_ADDR]] to ptr
// CHECK-32WAVE-NEXT:    [[IN_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[IN_ADDR]] to ptr
// CHECK-32WAVE-NEXT:    [[OUT1_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[OUT1_ADDR]] to ptr
// CHECK-32WAVE-NEXT:    [[VLA_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[VLA_ADDR]] to ptr
// CHECK-32WAVE-NEXT:    [[SUM1_ADDR2_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM1_ADDR2]] to ptr
// CHECK-32WAVE-NEXT:    [[DOTADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR]] to ptr
// CHECK-32WAVE-NEXT:    [[DOTADDR3_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR3]] to ptr
// CHECK-32WAVE-NEXT:    [[DOTADDR4_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR4]] to ptr
// CHECK-32WAVE-NEXT:    [[I_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[I]] to ptr
// CHECK-32WAVE-NEXT:    [[DOTOMP_LB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_LB]] to ptr
// CHECK-32WAVE-NEXT:    [[DOTOMP_UB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_UB]] to ptr
// CHECK-32WAVE-NEXT:    [[DOTOMP_IV_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_IV]] to ptr
// CHECK-32WAVE-NEXT:    [[SUM15_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM15]] to ptr
// CHECK-32WAVE-NEXT:    store ptr [[DYN_PTR]], ptr [[DYN_PTR_ADDR_ASCAST]], align 8
// CHECK-32WAVE-NEXT:    store ptr [[SUM1]], ptr [[SUM1_ADDR_ASCAST]], align 8
// CHECK-32WAVE-NEXT:    store ptr [[IN]], ptr [[IN_ADDR_ASCAST]], align 8
// CHECK-32WAVE-NEXT:    store ptr [[OUT1]], ptr [[OUT1_ADDR_ASCAST]], align 8
// CHECK-32WAVE-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR_ASCAST]], align 8
// CHECK-32WAVE-NEXT:    store ptr [[SUM11]], ptr [[SUM1_ADDR2_ASCAST]], align 8
// CHECK-32WAVE-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR_ASCAST]], align 8
// CHECK-32WAVE-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR3_ASCAST]], align 8
// CHECK-32WAVE-NEXT:    store ptr [[TMP2]], ptr [[DOTADDR4_ASCAST]], align 8
// CHECK-32WAVE-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[SUM1_ADDR_ASCAST]], align 8
// CHECK-32WAVE-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[IN_ADDR_ASCAST]], align 8
// CHECK-32WAVE-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[OUT1_ADDR_ASCAST]], align 8
// CHECK-32WAVE-NEXT:    [[TMP6:%.*]] = load i64, ptr [[VLA_ADDR_ASCAST]], align 8
// CHECK-32WAVE-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[SUM1_ADDR2_ASCAST]], align 8
// CHECK-32WAVE-NEXT:    call void @__kmpc_specialized_kernel_init()
// CHECK-32WAVE-NEXT:    [[TMP8:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-32WAVE-NEXT:    store i32 0, ptr addrspace(5) [[TMP8]], align 4
// CHECK-32WAVE-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// CHECK-32WAVE-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// CHECK-32WAVE-NEXT:    store i32 0, ptr [[DOTOMP_LB_ASCAST]], align 4
// CHECK-32WAVE-NEXT:    store i32 63999, ptr [[DOTOMP_UB_ASCAST]], align 4
// CHECK-32WAVE-NEXT:    [[TMP9:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// CHECK-32WAVE-NEXT:    store i32 [[TMP9]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-32WAVE-NEXT:    [[TMP10:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// CHECK-32WAVE-NEXT:    [[NVPTX_NUM_THREADS:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// CHECK-32WAVE-NEXT:    [[GPU_BLOCK_ID:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// CHECK-32WAVE-NEXT:    [[TMP11:%.*]] = mul i32 [[GPU_BLOCK_ID]], [[NVPTX_NUM_THREADS]]
// CHECK-32WAVE-NEXT:    [[TMP12:%.*]] = add i32 [[TMP11]], [[TMP10]]
// CHECK-32WAVE-NEXT:    [[TMP13:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-32WAVE-NEXT:    [[TMP14:%.*]] = add i32 [[TMP12]], [[TMP13]]
// CHECK-32WAVE-NEXT:    [[TMP15:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// CHECK-32WAVE-NEXT:    [[TMP16:%.*]] = zext i32 [[TMP14]] to i64
// CHECK-32WAVE-NEXT:    [[TOTAL_NUM_THREADS:%.*]] = mul i32 [[TMP15]], [[NVPTX_NUM_THREADS]]
// CHECK-32WAVE-NEXT:    store i32 [[TMP14]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-32WAVE-NEXT:    [[TMP17:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-32WAVE-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP17]], 1
// CHECK-32WAVE-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK-32WAVE-NEXT:    store i32 [[ADD]], ptr [[I_ASCAST]], align 4
// CHECK-32WAVE-NEXT:    [[TMP18:%.*]] = load ptr, ptr [[DOTADDR_ASCAST]], align 8
// CHECK-32WAVE-NEXT:    [[TMP19:%.*]] = load ptr, ptr [[DOTADDR4_ASCAST]], align 8
// CHECK-32WAVE-NEXT:    [[TMP20:%.*]] = load ptr, ptr [[DOTADDR_ASCAST]], align 8
// CHECK-32WAVE-NEXT:    [[TMP21:%.*]] = load ptr, ptr [[DOTADDR4_ASCAST]], align 8
// CHECK-32WAVE-NEXT:    [[TMP22:%.*]] = load i32, ptr addrspace(5) [[TMP8]], align 4
// CHECK-32WAVE-NEXT:    call void @__kmpc_xteams_phase2_i_8x32(ptr [[TMP21]], i32 1, ptr [[TMP20]], ptr [[TMP21]], ptr @__kmpc_rfun_sum_i, i32 0, i64 [[TMP16]], i32 1)
// CHECK-32WAVE-NEXT:    [[TMP23:%.*]] = add i32 [[TMP12]], [[TOTAL_NUM_THREADS]]
// CHECK-32WAVE-NEXT:    [[TMP24:%.*]] = getelementptr i32, ptr [[TMP19]], i32 [[TMP23]]
// CHECK-32WAVE-NEXT:    [[TMP25:%.*]] = load i32, ptr [[TMP24]], align 4
// CHECK-32WAVE-NEXT:    store i32 [[TMP25]], ptr addrspace(5) [[TMP8]], align 4
// CHECK-32WAVE-NEXT:    store i32 0, ptr [[SUM15_ASCAST]], align 4
// CHECK-32WAVE-NEXT:    br label [[OMP_INSCAN_DISPATCH:%.*]]
// CHECK-32WAVE:       omp.before.scan.bb:
// CHECK-32WAVE-NEXT:    [[TMP26:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// CHECK-32WAVE-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP26]] to i64
// CHECK-32WAVE-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [64000 x i32], ptr [[TMP4]], i64 0, i64 [[IDXPROM]]
// CHECK-32WAVE-NEXT:    [[TMP27:%.*]] = load i32, ptr [[ARRAYIDX]], align 4
// CHECK-32WAVE-NEXT:    [[TMP28:%.*]] = load i32, ptr addrspace(5) [[TMP8]], align 4
// CHECK-32WAVE-NEXT:    [[TMP29:%.*]] = add i32 [[TMP28]], [[TMP27]]
// CHECK-32WAVE-NEXT:    store i32 [[TMP29]], ptr addrspace(5) [[TMP8]], align 4
// CHECK-32WAVE-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK-32WAVE:       omp.exit.inscan.bb:
// CHECK-32WAVE-NEXT:    br label [[OMP_BODY_CONTINUE]]
// CHECK-32WAVE:       omp.inscan.dispatch:
// CHECK-32WAVE-NEXT:    [[TMP30:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-32WAVE-NEXT:    [[TMP31:%.*]] = zext i32 [[TMP30]] to i64
// CHECK-32WAVE-NEXT:    [[ARRAYIDX6:%.*]] = getelementptr inbounds nuw i32, ptr [[TMP7]], i64 [[TMP31]]
// CHECK-32WAVE-NEXT:    [[TMP32:%.*]] = load i32, ptr addrspace(5) [[TMP8]], align 4
// CHECK-32WAVE-NEXT:    store i32 [[TMP32]], ptr [[TMP3]], align 4
// CHECK-32WAVE-NEXT:    br label [[OMP_AFTER_SCAN_BB:%.*]]
// CHECK-32WAVE:       omp.after.scan.bb:
// CHECK-32WAVE-NEXT:    [[TMP33:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// CHECK-32WAVE-NEXT:    [[IDXPROM7:%.*]] = sext i32 [[TMP33]] to i64
// CHECK-32WAVE-NEXT:    [[ARRAYIDX8:%.*]] = getelementptr inbounds [64000 x i32], ptr [[TMP5]], i64 0, i64 [[IDXPROM7]]
// CHECK-32WAVE-NEXT:    [[TMP34:%.*]] = load i32, ptr addrspace(5) [[TMP8]], align 4
// CHECK-32WAVE-NEXT:    store i32 [[TMP34]], ptr [[ARRAYIDX8]], align 4
// CHECK-32WAVE-NEXT:    br label [[OMP_EXIT_INSCAN_BB:%.*]]
// CHECK-32WAVE:       omp.body.continue:
// CHECK-32WAVE-NEXT:    ret void
//
//
// CHECK-32WAVE-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l57
// CHECK-32WAVE-SAME: (ptr noalias noundef [[DYN_PTR:%.*]], ptr noundef nonnull align 4 dereferenceable(256000) [[OUT2:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM2:%.*]], ptr noundef nonnull align 4 dereferenceable(256000) [[IN:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM21:%.*]], ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]], ptr noundef [[TMP2:%.*]]) #[[ATTR0]] {
// CHECK-32WAVE-NEXT:  entry:
// CHECK-32WAVE-NEXT:    [[DYN_PTR_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-32WAVE-NEXT:    [[OUT2_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-32WAVE-NEXT:    [[SUM2_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-32WAVE-NEXT:    [[IN_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-32WAVE-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8, addrspace(5)
// CHECK-32WAVE-NEXT:    [[SUM2_ADDR2:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-32WAVE-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-32WAVE-NEXT:    [[DOTADDR3:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-32WAVE-NEXT:    [[DOTADDR4:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-32WAVE-NEXT:    [[I:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-32WAVE-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-32WAVE-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-32WAVE-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-32WAVE-NEXT:    [[SUM25:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-32WAVE-NEXT:    [[DYN_PTR_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DYN_PTR_ADDR]] to ptr
// CHECK-32WAVE-NEXT:    [[OUT2_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[OUT2_ADDR]] to ptr
// CHECK-32WAVE-NEXT:    [[SUM2_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM2_ADDR]] to ptr
// CHECK-32WAVE-NEXT:    [[IN_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[IN_ADDR]] to ptr
// CHECK-32WAVE-NEXT:    [[VLA_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[VLA_ADDR]] to ptr
// CHECK-32WAVE-NEXT:    [[SUM2_ADDR2_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM2_ADDR2]] to ptr
// CHECK-32WAVE-NEXT:    [[DOTADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR]] to ptr
// CHECK-32WAVE-NEXT:    [[DOTADDR3_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR3]] to ptr
// CHECK-32WAVE-NEXT:    [[DOTADDR4_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR4]] to ptr
// CHECK-32WAVE-NEXT:    [[I_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[I]] to ptr
// CHECK-32WAVE-NEXT:    [[DOTOMP_LB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_LB]] to ptr
// CHECK-32WAVE-NEXT:    [[DOTOMP_UB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_UB]] to ptr
// CHECK-32WAVE-NEXT:    [[DOTOMP_IV_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_IV]] to ptr
// CHECK-32WAVE-NEXT:    [[SUM25_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM25]] to ptr
// CHECK-32WAVE-NEXT:    store ptr [[DYN_PTR]], ptr [[DYN_PTR_ADDR_ASCAST]], align 8
// CHECK-32WAVE-NEXT:    store ptr [[OUT2]], ptr [[OUT2_ADDR_ASCAST]], align 8
// CHECK-32WAVE-NEXT:    store ptr [[SUM2]], ptr [[SUM2_ADDR_ASCAST]], align 8
// CHECK-32WAVE-NEXT:    store ptr [[IN]], ptr [[IN_ADDR_ASCAST]], align 8
// CHECK-32WAVE-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR_ASCAST]], align 8
// CHECK-32WAVE-NEXT:    store ptr [[SUM21]], ptr [[SUM2_ADDR2_ASCAST]], align 8
// CHECK-32WAVE-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR_ASCAST]], align 8
// CHECK-32WAVE-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR3_ASCAST]], align 8
// CHECK-32WAVE-NEXT:    store ptr [[TMP2]], ptr [[DOTADDR4_ASCAST]], align 8
// CHECK-32WAVE-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[OUT2_ADDR_ASCAST]], align 8
// CHECK-32WAVE-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[SUM2_ADDR_ASCAST]], align 8
// CHECK-32WAVE-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[IN_ADDR_ASCAST]], align 8
// CHECK-32WAVE-NEXT:    [[TMP6:%.*]] = load i64, ptr [[VLA_ADDR_ASCAST]], align 8
// CHECK-32WAVE-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[SUM2_ADDR2_ASCAST]], align 8
// CHECK-32WAVE-NEXT:    call void @__kmpc_specialized_kernel_init()
// CHECK-32WAVE-NEXT:    [[TMP8:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-32WAVE-NEXT:    store i32 0, ptr addrspace(5) [[TMP8]], align 4
// CHECK-32WAVE-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// CHECK-32WAVE-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// CHECK-32WAVE-NEXT:    store i32 0, ptr [[DOTOMP_LB_ASCAST]], align 4
// CHECK-32WAVE-NEXT:    store i32 63999, ptr [[DOTOMP_UB_ASCAST]], align 4
// CHECK-32WAVE-NEXT:    [[TMP9:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// CHECK-32WAVE-NEXT:    store i32 [[TMP9]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-32WAVE-NEXT:    [[TMP10:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// CHECK-32WAVE-NEXT:    [[NVPTX_NUM_THREADS:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// CHECK-32WAVE-NEXT:    [[GPU_BLOCK_ID:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// CHECK-32WAVE-NEXT:    [[TMP11:%.*]] = mul i32 [[GPU_BLOCK_ID]], [[NVPTX_NUM_THREADS]]
// CHECK-32WAVE-NEXT:    [[TMP12:%.*]] = add i32 [[TMP11]], [[TMP10]]
// CHECK-32WAVE-NEXT:    [[TMP13:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-32WAVE-NEXT:    [[TMP14:%.*]] = add i32 [[TMP12]], [[TMP13]]
// CHECK-32WAVE-NEXT:    [[TMP15:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// CHECK-32WAVE-NEXT:    [[TMP16:%.*]] = zext i32 [[TMP14]] to i64
// CHECK-32WAVE-NEXT:    [[TOTAL_NUM_THREADS:%.*]] = mul i32 [[TMP15]], [[NVPTX_NUM_THREADS]]
// CHECK-32WAVE-NEXT:    store i32 [[TMP14]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-32WAVE-NEXT:    [[TMP17:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-32WAVE-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP17]], 1
// CHECK-32WAVE-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK-32WAVE-NEXT:    store i32 [[ADD]], ptr [[I_ASCAST]], align 4
// CHECK-32WAVE-NEXT:    [[TMP18:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-32WAVE-NEXT:    [[TMP19:%.*]] = load i32, ptr [[DOTOMP_UB_ASCAST]], align 4
// CHECK-32WAVE-NEXT:    [[CMP:%.*]] = icmp sle i32 [[TMP18]], [[TMP19]]
// CHECK-32WAVE-NEXT:    br i1 [[CMP]], label [[OMP_KERNEL_BODY:%.*]], label [[OMP_KERNEL_DONE:%.*]]
// CHECK-32WAVE:       omp.kernel.body:
// CHECK-32WAVE-NEXT:    store i32 0, ptr [[SUM25_ASCAST]], align 4
// CHECK-32WAVE-NEXT:    br label [[OMP_INSCAN_DISPATCH:%.*]]
// CHECK-32WAVE:       omp.before.scan.bb:
// CHECK-32WAVE-NEXT:    [[TMP20:%.*]] = load i32, ptr [[TMP4]], align 4
// CHECK-32WAVE-NEXT:    [[TMP21:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// CHECK-32WAVE-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP21]] to i64
// CHECK-32WAVE-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [64000 x i32], ptr [[TMP3]], i64 0, i64 [[IDXPROM]]
// CHECK-32WAVE-NEXT:    store i32 [[TMP20]], ptr [[ARRAYIDX]], align 4
// CHECK-32WAVE-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK-32WAVE:       omp.exit.inscan.bb:
// CHECK-32WAVE-NEXT:    [[TMP22:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-32WAVE-NEXT:    [[TMP23:%.*]] = zext i32 [[TMP22]] to i64
// CHECK-32WAVE-NEXT:    br label [[OMP_BODY_CONTINUE]]
// CHECK-32WAVE:       omp.inscan.dispatch:
// CHECK-32WAVE-NEXT:    br label [[OMP_AFTER_SCAN_BB:%.*]]
// CHECK-32WAVE:       omp.after.scan.bb:
// CHECK-32WAVE-NEXT:    [[TMP24:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// CHECK-32WAVE-NEXT:    [[IDXPROM6:%.*]] = sext i32 [[TMP24]] to i64
// CHECK-32WAVE-NEXT:    [[ARRAYIDX7:%.*]] = getelementptr inbounds [64000 x i32], ptr [[TMP5]], i64 0, i64 [[IDXPROM6]]
// CHECK-32WAVE-NEXT:    [[TMP25:%.*]] = load i32, ptr [[ARRAYIDX7]], align 4
// CHECK-32WAVE-NEXT:    [[TMP26:%.*]] = load i32, ptr addrspace(5) [[TMP8]], align 4
// CHECK-32WAVE-NEXT:    [[TMP27:%.*]] = add i32 [[TMP26]], [[TMP25]]
// CHECK-32WAVE-NEXT:    store i32 [[TMP27]], ptr addrspace(5) [[TMP8]], align 4
// CHECK-32WAVE-NEXT:    br label [[OMP_EXIT_INSCAN_BB:%.*]]
// CHECK-32WAVE:       omp.body.continue:
// CHECK-32WAVE-NEXT:    [[TMP28:%.*]] = load ptr, ptr [[DOTADDR_ASCAST]], align 8
// CHECK-32WAVE-NEXT:    [[TMP29:%.*]] = load ptr, ptr [[DOTADDR3_ASCAST]], align 8
// CHECK-32WAVE-NEXT:    [[TMP30:%.*]] = load ptr, ptr [[DOTADDR4_ASCAST]], align 8
// CHECK-32WAVE-NEXT:    [[TMP31:%.*]] = load i32, ptr addrspace(5) [[TMP8]], align 4
// CHECK-32WAVE-NEXT:    call void @__kmpc_xteams_i_8x32(i32 [[TMP31]], ptr [[TMP30]], ptr [[TMP4]], ptr [[TMP28]], ptr [[TMP29]], ptr @__kmpc_rfun_sum_i, ptr @__kmpc_rfun_sum_lds_i, i32 0, i64 [[TMP16]], i32 [[TMP15]])
// CHECK-32WAVE-NEXT:    br label [[OMP_KERNEL_DONE]]
// CHECK-32WAVE:       omp.kernel.done:
// CHECK-32WAVE-NEXT:    ret void
//
//
// CHECK-32WAVE-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l57_1
// CHECK-32WAVE-SAME: (ptr noalias noundef [[DYN_PTR:%.*]], ptr noundef nonnull align 4 dereferenceable(256000) [[OUT2:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM2:%.*]], ptr noundef nonnull align 4 dereferenceable(256000) [[IN:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM21:%.*]], ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]], ptr noundef [[TMP2:%.*]]) #[[ATTR0]] {
// CHECK-32WAVE-NEXT:  entry:
// CHECK-32WAVE-NEXT:    [[DYN_PTR_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-32WAVE-NEXT:    [[OUT2_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-32WAVE-NEXT:    [[SUM2_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-32WAVE-NEXT:    [[IN_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-32WAVE-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8, addrspace(5)
// CHECK-32WAVE-NEXT:    [[SUM2_ADDR2:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-32WAVE-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-32WAVE-NEXT:    [[DOTADDR3:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-32WAVE-NEXT:    [[DOTADDR4:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-32WAVE-NEXT:    [[I:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-32WAVE-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-32WAVE-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-32WAVE-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-32WAVE-NEXT:    [[SUM25:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-32WAVE-NEXT:    [[DYN_PTR_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DYN_PTR_ADDR]] to ptr
// CHECK-32WAVE-NEXT:    [[OUT2_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[OUT2_ADDR]] to ptr
// CHECK-32WAVE-NEXT:    [[SUM2_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM2_ADDR]] to ptr
// CHECK-32WAVE-NEXT:    [[IN_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[IN_ADDR]] to ptr
// CHECK-32WAVE-NEXT:    [[VLA_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[VLA_ADDR]] to ptr
// CHECK-32WAVE-NEXT:    [[SUM2_ADDR2_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM2_ADDR2]] to ptr
// CHECK-32WAVE-NEXT:    [[DOTADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR]] to ptr
// CHECK-32WAVE-NEXT:    [[DOTADDR3_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR3]] to ptr
// CHECK-32WAVE-NEXT:    [[DOTADDR4_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR4]] to ptr
// CHECK-32WAVE-NEXT:    [[I_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[I]] to ptr
// CHECK-32WAVE-NEXT:    [[DOTOMP_LB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_LB]] to ptr
// CHECK-32WAVE-NEXT:    [[DOTOMP_UB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_UB]] to ptr
// CHECK-32WAVE-NEXT:    [[DOTOMP_IV_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_IV]] to ptr
// CHECK-32WAVE-NEXT:    [[SUM25_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM25]] to ptr
// CHECK-32WAVE-NEXT:    store ptr [[DYN_PTR]], ptr [[DYN_PTR_ADDR_ASCAST]], align 8
// CHECK-32WAVE-NEXT:    store ptr [[OUT2]], ptr [[OUT2_ADDR_ASCAST]], align 8
// CHECK-32WAVE-NEXT:    store ptr [[SUM2]], ptr [[SUM2_ADDR_ASCAST]], align 8
// CHECK-32WAVE-NEXT:    store ptr [[IN]], ptr [[IN_ADDR_ASCAST]], align 8
// CHECK-32WAVE-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR_ASCAST]], align 8
// CHECK-32WAVE-NEXT:    store ptr [[SUM21]], ptr [[SUM2_ADDR2_ASCAST]], align 8
// CHECK-32WAVE-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR_ASCAST]], align 8
// CHECK-32WAVE-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR3_ASCAST]], align 8
// CHECK-32WAVE-NEXT:    store ptr [[TMP2]], ptr [[DOTADDR4_ASCAST]], align 8
// CHECK-32WAVE-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[OUT2_ADDR_ASCAST]], align 8
// CHECK-32WAVE-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[SUM2_ADDR_ASCAST]], align 8
// CHECK-32WAVE-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[IN_ADDR_ASCAST]], align 8
// CHECK-32WAVE-NEXT:    [[TMP6:%.*]] = load i64, ptr [[VLA_ADDR_ASCAST]], align 8
// CHECK-32WAVE-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[SUM2_ADDR2_ASCAST]], align 8
// CHECK-32WAVE-NEXT:    call void @__kmpc_specialized_kernel_init()
// CHECK-32WAVE-NEXT:    [[TMP8:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-32WAVE-NEXT:    store i32 0, ptr addrspace(5) [[TMP8]], align 4
// CHECK-32WAVE-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// CHECK-32WAVE-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// CHECK-32WAVE-NEXT:    store i32 0, ptr [[DOTOMP_LB_ASCAST]], align 4
// CHECK-32WAVE-NEXT:    store i32 63999, ptr [[DOTOMP_UB_ASCAST]], align 4
// CHECK-32WAVE-NEXT:    [[TMP9:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// CHECK-32WAVE-NEXT:    store i32 [[TMP9]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-32WAVE-NEXT:    [[TMP10:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// CHECK-32WAVE-NEXT:    [[NVPTX_NUM_THREADS:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// CHECK-32WAVE-NEXT:    [[GPU_BLOCK_ID:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// CHECK-32WAVE-NEXT:    [[TMP11:%.*]] = mul i32 [[GPU_BLOCK_ID]], [[NVPTX_NUM_THREADS]]
// CHECK-32WAVE-NEXT:    [[TMP12:%.*]] = add i32 [[TMP11]], [[TMP10]]
// CHECK-32WAVE-NEXT:    [[TMP13:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-32WAVE-NEXT:    [[TMP14:%.*]] = add i32 [[TMP12]], [[TMP13]]
// CHECK-32WAVE-NEXT:    [[TMP15:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// CHECK-32WAVE-NEXT:    [[TMP16:%.*]] = zext i32 [[TMP14]] to i64
// CHECK-32WAVE-NEXT:    [[TOTAL_NUM_THREADS:%.*]] = mul i32 [[TMP15]], [[NVPTX_NUM_THREADS]]
// CHECK-32WAVE-NEXT:    store i32 [[TMP14]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-32WAVE-NEXT:    [[TMP17:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-32WAVE-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP17]], 1
// CHECK-32WAVE-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK-32WAVE-NEXT:    store i32 [[ADD]], ptr [[I_ASCAST]], align 4
// CHECK-32WAVE-NEXT:    [[TMP18:%.*]] = load ptr, ptr [[DOTADDR_ASCAST]], align 8
// CHECK-32WAVE-NEXT:    [[TMP19:%.*]] = load ptr, ptr [[DOTADDR4_ASCAST]], align 8
// CHECK-32WAVE-NEXT:    [[TMP20:%.*]] = load ptr, ptr [[DOTADDR_ASCAST]], align 8
// CHECK-32WAVE-NEXT:    [[TMP21:%.*]] = load ptr, ptr [[DOTADDR4_ASCAST]], align 8
// CHECK-32WAVE-NEXT:    [[TMP22:%.*]] = load i32, ptr addrspace(5) [[TMP8]], align 4
// CHECK-32WAVE-NEXT:    call void @__kmpc_xteams_phase2_i_8x32(ptr [[TMP21]], i32 1, ptr [[TMP20]], ptr [[TMP21]], ptr @__kmpc_rfun_sum_i, i32 0, i64 [[TMP16]], i32 0)
// CHECK-32WAVE-NEXT:    [[TMP23:%.*]] = add i32 [[TMP12]], [[TOTAL_NUM_THREADS]]
// CHECK-32WAVE-NEXT:    [[TMP24:%.*]] = getelementptr i32, ptr [[TMP19]], i32 [[TMP23]]
// CHECK-32WAVE-NEXT:    [[TMP25:%.*]] = load i32, ptr [[TMP24]], align 4
// CHECK-32WAVE-NEXT:    store i32 [[TMP25]], ptr addrspace(5) [[TMP8]], align 4
// CHECK-32WAVE-NEXT:    store i32 0, ptr [[SUM25_ASCAST]], align 4
// CHECK-32WAVE-NEXT:    br label [[OMP_INSCAN_DISPATCH:%.*]]
// CHECK-32WAVE:       omp.before.scan.bb:
// CHECK-32WAVE-NEXT:    [[TMP26:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// CHECK-32WAVE-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP26]] to i64
// CHECK-32WAVE-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [64000 x i32], ptr [[TMP3]], i64 0, i64 [[IDXPROM]]
// CHECK-32WAVE-NEXT:    [[TMP27:%.*]] = load i32, ptr addrspace(5) [[TMP8]], align 4
// CHECK-32WAVE-NEXT:    store i32 [[TMP27]], ptr [[ARRAYIDX]], align 4
// CHECK-32WAVE-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK-32WAVE:       omp.exit.inscan.bb:
// CHECK-32WAVE-NEXT:    br label [[OMP_BODY_CONTINUE]]
// CHECK-32WAVE:       omp.inscan.dispatch:
// CHECK-32WAVE-NEXT:    [[TMP28:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-32WAVE-NEXT:    [[TMP29:%.*]] = zext i32 [[TMP28]] to i64
// CHECK-32WAVE-NEXT:    [[TMP30:%.*]] = icmp eq i64 [[TMP29]], 0
// CHECK-32WAVE-NEXT:    br i1 [[TMP30]], label [[OMP_EXCLUSIVE_COPY_EXIT:%.*]], label [[OMP_EXCLUSIVE_DEC:%.*]]
// CHECK-32WAVE:       omp.exclusive.dec:
// CHECK-32WAVE-NEXT:    [[TMP31:%.*]] = sub nuw i64 [[TMP29]], 1
// CHECK-32WAVE-NEXT:    [[ARRAYIDX6:%.*]] = getelementptr inbounds nuw i32, ptr [[TMP7]], i64 [[TMP31]]
// CHECK-32WAVE-NEXT:    [[TMP32:%.*]] = load i32, ptr addrspace(5) [[TMP8]], align 4
// CHECK-32WAVE-NEXT:    store i32 [[TMP32]], ptr [[TMP4]], align 4
// CHECK-32WAVE-NEXT:    br label [[OMP_EXCLUSIVE_COPY_EXIT]]
// CHECK-32WAVE:       omp.exclusive.copy.exit:
// CHECK-32WAVE-NEXT:    br label [[OMP_BEFORE_SCAN_BB:%.*]]
// CHECK-32WAVE:       omp.after.scan.bb:
// CHECK-32WAVE-NEXT:    [[TMP33:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// CHECK-32WAVE-NEXT:    [[IDXPROM7:%.*]] = sext i32 [[TMP33]] to i64
// CHECK-32WAVE-NEXT:    [[ARRAYIDX8:%.*]] = getelementptr inbounds [64000 x i32], ptr [[TMP5]], i64 0, i64 [[IDXPROM7]]
// CHECK-32WAVE-NEXT:    [[TMP34:%.*]] = load i32, ptr [[ARRAYIDX8]], align 4
// CHECK-32WAVE-NEXT:    [[TMP35:%.*]] = load i32, ptr addrspace(5) [[TMP8]], align 4
// CHECK-32WAVE-NEXT:    [[TMP36:%.*]] = add i32 [[TMP35]], [[TMP34]]
// CHECK-32WAVE-NEXT:    store i32 [[TMP36]], ptr addrspace(5) [[TMP8]], align 4
// CHECK-32WAVE-NEXT:    br label [[OMP_EXIT_INSCAN_BB:%.*]]
// CHECK-32WAVE:       omp.body.continue:
// CHECK-32WAVE-NEXT:    ret void
//
//
// CHECK-32WAVE-512WGSize-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l47
// CHECK-32WAVE-512WGSize-SAME: (ptr noalias noundef [[DYN_PTR:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM1:%.*]], ptr noundef nonnull align 4 dereferenceable(512000) [[IN:%.*]], ptr noundef nonnull align 4 dereferenceable(512000) [[OUT1:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM11:%.*]], ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]], ptr noundef [[TMP2:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK-32WAVE-512WGSize-NEXT:  entry:
// CHECK-32WAVE-512WGSize-NEXT:    [[DYN_PTR_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-32WAVE-512WGSize-NEXT:    [[SUM1_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-32WAVE-512WGSize-NEXT:    [[IN_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-32WAVE-512WGSize-NEXT:    [[OUT1_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-32WAVE-512WGSize-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8, addrspace(5)
// CHECK-32WAVE-512WGSize-NEXT:    [[SUM1_ADDR2:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-32WAVE-512WGSize-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-32WAVE-512WGSize-NEXT:    [[DOTADDR3:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-32WAVE-512WGSize-NEXT:    [[DOTADDR4:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-32WAVE-512WGSize-NEXT:    [[I:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-32WAVE-512WGSize-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-32WAVE-512WGSize-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-32WAVE-512WGSize-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-32WAVE-512WGSize-NEXT:    [[SUM15:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-32WAVE-512WGSize-NEXT:    [[DYN_PTR_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DYN_PTR_ADDR]] to ptr
// CHECK-32WAVE-512WGSize-NEXT:    [[SUM1_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM1_ADDR]] to ptr
// CHECK-32WAVE-512WGSize-NEXT:    [[IN_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[IN_ADDR]] to ptr
// CHECK-32WAVE-512WGSize-NEXT:    [[OUT1_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[OUT1_ADDR]] to ptr
// CHECK-32WAVE-512WGSize-NEXT:    [[VLA_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[VLA_ADDR]] to ptr
// CHECK-32WAVE-512WGSize-NEXT:    [[SUM1_ADDR2_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM1_ADDR2]] to ptr
// CHECK-32WAVE-512WGSize-NEXT:    [[DOTADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR]] to ptr
// CHECK-32WAVE-512WGSize-NEXT:    [[DOTADDR3_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR3]] to ptr
// CHECK-32WAVE-512WGSize-NEXT:    [[DOTADDR4_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR4]] to ptr
// CHECK-32WAVE-512WGSize-NEXT:    [[I_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[I]] to ptr
// CHECK-32WAVE-512WGSize-NEXT:    [[DOTOMP_LB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_LB]] to ptr
// CHECK-32WAVE-512WGSize-NEXT:    [[DOTOMP_UB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_UB]] to ptr
// CHECK-32WAVE-512WGSize-NEXT:    [[DOTOMP_IV_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_IV]] to ptr
// CHECK-32WAVE-512WGSize-NEXT:    [[SUM15_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM15]] to ptr
// CHECK-32WAVE-512WGSize-NEXT:    store ptr [[DYN_PTR]], ptr [[DYN_PTR_ADDR_ASCAST]], align 8
// CHECK-32WAVE-512WGSize-NEXT:    store ptr [[SUM1]], ptr [[SUM1_ADDR_ASCAST]], align 8
// CHECK-32WAVE-512WGSize-NEXT:    store ptr [[IN]], ptr [[IN_ADDR_ASCAST]], align 8
// CHECK-32WAVE-512WGSize-NEXT:    store ptr [[OUT1]], ptr [[OUT1_ADDR_ASCAST]], align 8
// CHECK-32WAVE-512WGSize-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR_ASCAST]], align 8
// CHECK-32WAVE-512WGSize-NEXT:    store ptr [[SUM11]], ptr [[SUM1_ADDR2_ASCAST]], align 8
// CHECK-32WAVE-512WGSize-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR_ASCAST]], align 8
// CHECK-32WAVE-512WGSize-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR3_ASCAST]], align 8
// CHECK-32WAVE-512WGSize-NEXT:    store ptr [[TMP2]], ptr [[DOTADDR4_ASCAST]], align 8
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[SUM1_ADDR_ASCAST]], align 8
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[IN_ADDR_ASCAST]], align 8
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[OUT1_ADDR_ASCAST]], align 8
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP6:%.*]] = load i64, ptr [[VLA_ADDR_ASCAST]], align 8
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[SUM1_ADDR2_ASCAST]], align 8
// CHECK-32WAVE-512WGSize-NEXT:    call void @__kmpc_specialized_kernel_init()
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP8:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-32WAVE-512WGSize-NEXT:    store i32 0, ptr addrspace(5) [[TMP8]], align 4
// CHECK-32WAVE-512WGSize-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// CHECK-32WAVE-512WGSize-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// CHECK-32WAVE-512WGSize-NEXT:    store i32 0, ptr [[DOTOMP_LB_ASCAST]], align 4
// CHECK-32WAVE-512WGSize-NEXT:    store i32 127999, ptr [[DOTOMP_UB_ASCAST]], align 4
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP9:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// CHECK-32WAVE-512WGSize-NEXT:    store i32 [[TMP9]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP10:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// CHECK-32WAVE-512WGSize-NEXT:    [[NVPTX_NUM_THREADS:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// CHECK-32WAVE-512WGSize-NEXT:    [[GPU_BLOCK_ID:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP11:%.*]] = mul i32 [[GPU_BLOCK_ID]], [[NVPTX_NUM_THREADS]]
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP12:%.*]] = add i32 [[TMP11]], [[TMP10]]
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP13:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP14:%.*]] = add i32 [[TMP12]], [[TMP13]]
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP15:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP16:%.*]] = zext i32 [[TMP14]] to i64
// CHECK-32WAVE-512WGSize-NEXT:    [[TOTAL_NUM_THREADS:%.*]] = mul i32 [[TMP15]], [[NVPTX_NUM_THREADS]]
// CHECK-32WAVE-512WGSize-NEXT:    store i32 [[TMP14]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP17:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-32WAVE-512WGSize-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP17]], 1
// CHECK-32WAVE-512WGSize-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK-32WAVE-512WGSize-NEXT:    store i32 [[ADD]], ptr [[I_ASCAST]], align 4
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP18:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP19:%.*]] = load i32, ptr [[DOTOMP_UB_ASCAST]], align 4
// CHECK-32WAVE-512WGSize-NEXT:    [[CMP:%.*]] = icmp sle i32 [[TMP18]], [[TMP19]]
// CHECK-32WAVE-512WGSize-NEXT:    br i1 [[CMP]], label [[OMP_KERNEL_BODY:%.*]], label [[OMP_KERNEL_DONE:%.*]]
// CHECK-32WAVE-512WGSize:       omp.kernel.body:
// CHECK-32WAVE-512WGSize-NEXT:    store i32 0, ptr [[SUM15_ASCAST]], align 4
// CHECK-32WAVE-512WGSize-NEXT:    br label [[OMP_INSCAN_DISPATCH:%.*]]
// CHECK-32WAVE-512WGSize:       omp.before.scan.bb:
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP20:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// CHECK-32WAVE-512WGSize-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP20]] to i64
// CHECK-32WAVE-512WGSize-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [128000 x i32], ptr [[TMP4]], i64 0, i64 [[IDXPROM]]
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP21:%.*]] = load i32, ptr [[ARRAYIDX]], align 4
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP22:%.*]] = load i32, ptr addrspace(5) [[TMP8]], align 4
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP23:%.*]] = add i32 [[TMP22]], [[TMP21]]
// CHECK-32WAVE-512WGSize-NEXT:    store i32 [[TMP23]], ptr addrspace(5) [[TMP8]], align 4
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP24:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP25:%.*]] = zext i32 [[TMP24]] to i64
// CHECK-32WAVE-512WGSize-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK-32WAVE-512WGSize:       omp.exit.inscan.bb:
// CHECK-32WAVE-512WGSize-NEXT:    br label [[OMP_BODY_CONTINUE]]
// CHECK-32WAVE-512WGSize:       omp.inscan.dispatch:
// CHECK-32WAVE-512WGSize-NEXT:    br label [[OMP_BEFORE_SCAN_BB:%.*]]
// CHECK-32WAVE-512WGSize:       omp.after.scan.bb:
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP26:%.*]] = load i32, ptr [[TMP3]], align 4
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP27:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// CHECK-32WAVE-512WGSize-NEXT:    [[IDXPROM6:%.*]] = sext i32 [[TMP27]] to i64
// CHECK-32WAVE-512WGSize-NEXT:    [[ARRAYIDX7:%.*]] = getelementptr inbounds [128000 x i32], ptr [[TMP5]], i64 0, i64 [[IDXPROM6]]
// CHECK-32WAVE-512WGSize-NEXT:    store i32 [[TMP26]], ptr [[ARRAYIDX7]], align 4
// CHECK-32WAVE-512WGSize-NEXT:    br label [[OMP_EXIT_INSCAN_BB:%.*]]
// CHECK-32WAVE-512WGSize:       omp.body.continue:
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP28:%.*]] = load ptr, ptr [[DOTADDR_ASCAST]], align 8
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP29:%.*]] = load ptr, ptr [[DOTADDR3_ASCAST]], align 8
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP30:%.*]] = load ptr, ptr [[DOTADDR4_ASCAST]], align 8
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP31:%.*]] = load i32, ptr addrspace(5) [[TMP8]], align 4
// CHECK-32WAVE-512WGSize-NEXT:    call void @__kmpc_xteams_i_16x32(i32 [[TMP31]], ptr [[TMP30]], ptr [[TMP3]], ptr [[TMP28]], ptr [[TMP29]], ptr @__kmpc_rfun_sum_i, ptr @__kmpc_rfun_sum_lds_i, i32 0, i64 [[TMP16]], i32 [[TMP15]])
// CHECK-32WAVE-512WGSize-NEXT:    br label [[OMP_KERNEL_DONE]]
// CHECK-32WAVE-512WGSize:       omp.kernel.done:
// CHECK-32WAVE-512WGSize-NEXT:    ret void
//
//
// CHECK-32WAVE-512WGSize-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l47_1
// CHECK-32WAVE-512WGSize-SAME: (ptr noalias noundef [[DYN_PTR:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM1:%.*]], ptr noundef nonnull align 4 dereferenceable(512000) [[IN:%.*]], ptr noundef nonnull align 4 dereferenceable(512000) [[OUT1:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM11:%.*]], ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]], ptr noundef [[TMP2:%.*]]) #[[ATTR0]] {
// CHECK-32WAVE-512WGSize-NEXT:  entry:
// CHECK-32WAVE-512WGSize-NEXT:    [[DYN_PTR_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-32WAVE-512WGSize-NEXT:    [[SUM1_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-32WAVE-512WGSize-NEXT:    [[IN_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-32WAVE-512WGSize-NEXT:    [[OUT1_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-32WAVE-512WGSize-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8, addrspace(5)
// CHECK-32WAVE-512WGSize-NEXT:    [[SUM1_ADDR2:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-32WAVE-512WGSize-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-32WAVE-512WGSize-NEXT:    [[DOTADDR3:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-32WAVE-512WGSize-NEXT:    [[DOTADDR4:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-32WAVE-512WGSize-NEXT:    [[I:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-32WAVE-512WGSize-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-32WAVE-512WGSize-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-32WAVE-512WGSize-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-32WAVE-512WGSize-NEXT:    [[SUM15:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-32WAVE-512WGSize-NEXT:    [[DYN_PTR_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DYN_PTR_ADDR]] to ptr
// CHECK-32WAVE-512WGSize-NEXT:    [[SUM1_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM1_ADDR]] to ptr
// CHECK-32WAVE-512WGSize-NEXT:    [[IN_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[IN_ADDR]] to ptr
// CHECK-32WAVE-512WGSize-NEXT:    [[OUT1_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[OUT1_ADDR]] to ptr
// CHECK-32WAVE-512WGSize-NEXT:    [[VLA_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[VLA_ADDR]] to ptr
// CHECK-32WAVE-512WGSize-NEXT:    [[SUM1_ADDR2_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM1_ADDR2]] to ptr
// CHECK-32WAVE-512WGSize-NEXT:    [[DOTADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR]] to ptr
// CHECK-32WAVE-512WGSize-NEXT:    [[DOTADDR3_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR3]] to ptr
// CHECK-32WAVE-512WGSize-NEXT:    [[DOTADDR4_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR4]] to ptr
// CHECK-32WAVE-512WGSize-NEXT:    [[I_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[I]] to ptr
// CHECK-32WAVE-512WGSize-NEXT:    [[DOTOMP_LB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_LB]] to ptr
// CHECK-32WAVE-512WGSize-NEXT:    [[DOTOMP_UB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_UB]] to ptr
// CHECK-32WAVE-512WGSize-NEXT:    [[DOTOMP_IV_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_IV]] to ptr
// CHECK-32WAVE-512WGSize-NEXT:    [[SUM15_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM15]] to ptr
// CHECK-32WAVE-512WGSize-NEXT:    store ptr [[DYN_PTR]], ptr [[DYN_PTR_ADDR_ASCAST]], align 8
// CHECK-32WAVE-512WGSize-NEXT:    store ptr [[SUM1]], ptr [[SUM1_ADDR_ASCAST]], align 8
// CHECK-32WAVE-512WGSize-NEXT:    store ptr [[IN]], ptr [[IN_ADDR_ASCAST]], align 8
// CHECK-32WAVE-512WGSize-NEXT:    store ptr [[OUT1]], ptr [[OUT1_ADDR_ASCAST]], align 8
// CHECK-32WAVE-512WGSize-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR_ASCAST]], align 8
// CHECK-32WAVE-512WGSize-NEXT:    store ptr [[SUM11]], ptr [[SUM1_ADDR2_ASCAST]], align 8
// CHECK-32WAVE-512WGSize-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR_ASCAST]], align 8
// CHECK-32WAVE-512WGSize-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR3_ASCAST]], align 8
// CHECK-32WAVE-512WGSize-NEXT:    store ptr [[TMP2]], ptr [[DOTADDR4_ASCAST]], align 8
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[SUM1_ADDR_ASCAST]], align 8
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[IN_ADDR_ASCAST]], align 8
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[OUT1_ADDR_ASCAST]], align 8
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP6:%.*]] = load i64, ptr [[VLA_ADDR_ASCAST]], align 8
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[SUM1_ADDR2_ASCAST]], align 8
// CHECK-32WAVE-512WGSize-NEXT:    call void @__kmpc_specialized_kernel_init()
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP8:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-32WAVE-512WGSize-NEXT:    store i32 0, ptr addrspace(5) [[TMP8]], align 4
// CHECK-32WAVE-512WGSize-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// CHECK-32WAVE-512WGSize-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// CHECK-32WAVE-512WGSize-NEXT:    store i32 0, ptr [[DOTOMP_LB_ASCAST]], align 4
// CHECK-32WAVE-512WGSize-NEXT:    store i32 127999, ptr [[DOTOMP_UB_ASCAST]], align 4
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP9:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// CHECK-32WAVE-512WGSize-NEXT:    store i32 [[TMP9]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP10:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// CHECK-32WAVE-512WGSize-NEXT:    [[NVPTX_NUM_THREADS:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// CHECK-32WAVE-512WGSize-NEXT:    [[GPU_BLOCK_ID:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP11:%.*]] = mul i32 [[GPU_BLOCK_ID]], [[NVPTX_NUM_THREADS]]
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP12:%.*]] = add i32 [[TMP11]], [[TMP10]]
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP13:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP14:%.*]] = add i32 [[TMP12]], [[TMP13]]
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP15:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP16:%.*]] = zext i32 [[TMP14]] to i64
// CHECK-32WAVE-512WGSize-NEXT:    [[TOTAL_NUM_THREADS:%.*]] = mul i32 [[TMP15]], [[NVPTX_NUM_THREADS]]
// CHECK-32WAVE-512WGSize-NEXT:    store i32 [[TMP14]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP17:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-32WAVE-512WGSize-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP17]], 1
// CHECK-32WAVE-512WGSize-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK-32WAVE-512WGSize-NEXT:    store i32 [[ADD]], ptr [[I_ASCAST]], align 4
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP18:%.*]] = load ptr, ptr [[DOTADDR_ASCAST]], align 8
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP19:%.*]] = load ptr, ptr [[DOTADDR4_ASCAST]], align 8
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP20:%.*]] = load ptr, ptr [[DOTADDR_ASCAST]], align 8
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP21:%.*]] = load ptr, ptr [[DOTADDR4_ASCAST]], align 8
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP22:%.*]] = load i32, ptr addrspace(5) [[TMP8]], align 4
// CHECK-32WAVE-512WGSize-NEXT:    call void @__kmpc_xteams_phase2_i_16x32(ptr [[TMP21]], i32 1, ptr [[TMP20]], ptr [[TMP21]], ptr @__kmpc_rfun_sum_i, i32 0, i64 [[TMP16]], i32 1)
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP23:%.*]] = add i32 [[TMP12]], [[TOTAL_NUM_THREADS]]
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP24:%.*]] = getelementptr i32, ptr [[TMP19]], i32 [[TMP23]]
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP25:%.*]] = load i32, ptr [[TMP24]], align 4
// CHECK-32WAVE-512WGSize-NEXT:    store i32 [[TMP25]], ptr addrspace(5) [[TMP8]], align 4
// CHECK-32WAVE-512WGSize-NEXT:    store i32 0, ptr [[SUM15_ASCAST]], align 4
// CHECK-32WAVE-512WGSize-NEXT:    br label [[OMP_INSCAN_DISPATCH:%.*]]
// CHECK-32WAVE-512WGSize:       omp.before.scan.bb:
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP26:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// CHECK-32WAVE-512WGSize-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP26]] to i64
// CHECK-32WAVE-512WGSize-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [128000 x i32], ptr [[TMP4]], i64 0, i64 [[IDXPROM]]
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP27:%.*]] = load i32, ptr [[ARRAYIDX]], align 4
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP28:%.*]] = load i32, ptr addrspace(5) [[TMP8]], align 4
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP29:%.*]] = add i32 [[TMP28]], [[TMP27]]
// CHECK-32WAVE-512WGSize-NEXT:    store i32 [[TMP29]], ptr addrspace(5) [[TMP8]], align 4
// CHECK-32WAVE-512WGSize-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK-32WAVE-512WGSize:       omp.exit.inscan.bb:
// CHECK-32WAVE-512WGSize-NEXT:    br label [[OMP_BODY_CONTINUE]]
// CHECK-32WAVE-512WGSize:       omp.inscan.dispatch:
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP30:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP31:%.*]] = zext i32 [[TMP30]] to i64
// CHECK-32WAVE-512WGSize-NEXT:    [[ARRAYIDX6:%.*]] = getelementptr inbounds nuw i32, ptr [[TMP7]], i64 [[TMP31]]
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP32:%.*]] = load i32, ptr addrspace(5) [[TMP8]], align 4
// CHECK-32WAVE-512WGSize-NEXT:    store i32 [[TMP32]], ptr [[TMP3]], align 4
// CHECK-32WAVE-512WGSize-NEXT:    br label [[OMP_AFTER_SCAN_BB:%.*]]
// CHECK-32WAVE-512WGSize:       omp.after.scan.bb:
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP33:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// CHECK-32WAVE-512WGSize-NEXT:    [[IDXPROM7:%.*]] = sext i32 [[TMP33]] to i64
// CHECK-32WAVE-512WGSize-NEXT:    [[ARRAYIDX8:%.*]] = getelementptr inbounds [128000 x i32], ptr [[TMP5]], i64 0, i64 [[IDXPROM7]]
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP34:%.*]] = load i32, ptr addrspace(5) [[TMP8]], align 4
// CHECK-32WAVE-512WGSize-NEXT:    store i32 [[TMP34]], ptr [[ARRAYIDX8]], align 4
// CHECK-32WAVE-512WGSize-NEXT:    br label [[OMP_EXIT_INSCAN_BB:%.*]]
// CHECK-32WAVE-512WGSize:       omp.body.continue:
// CHECK-32WAVE-512WGSize-NEXT:    ret void
//
//
// CHECK-32WAVE-512WGSize-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l57
// CHECK-32WAVE-512WGSize-SAME: (ptr noalias noundef [[DYN_PTR:%.*]], ptr noundef nonnull align 4 dereferenceable(512000) [[OUT2:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM2:%.*]], ptr noundef nonnull align 4 dereferenceable(512000) [[IN:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM21:%.*]], ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]], ptr noundef [[TMP2:%.*]]) #[[ATTR0]] {
// CHECK-32WAVE-512WGSize-NEXT:  entry:
// CHECK-32WAVE-512WGSize-NEXT:    [[DYN_PTR_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-32WAVE-512WGSize-NEXT:    [[OUT2_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-32WAVE-512WGSize-NEXT:    [[SUM2_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-32WAVE-512WGSize-NEXT:    [[IN_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-32WAVE-512WGSize-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8, addrspace(5)
// CHECK-32WAVE-512WGSize-NEXT:    [[SUM2_ADDR2:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-32WAVE-512WGSize-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-32WAVE-512WGSize-NEXT:    [[DOTADDR3:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-32WAVE-512WGSize-NEXT:    [[DOTADDR4:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-32WAVE-512WGSize-NEXT:    [[I:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-32WAVE-512WGSize-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-32WAVE-512WGSize-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-32WAVE-512WGSize-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-32WAVE-512WGSize-NEXT:    [[SUM25:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-32WAVE-512WGSize-NEXT:    [[DYN_PTR_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DYN_PTR_ADDR]] to ptr
// CHECK-32WAVE-512WGSize-NEXT:    [[OUT2_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[OUT2_ADDR]] to ptr
// CHECK-32WAVE-512WGSize-NEXT:    [[SUM2_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM2_ADDR]] to ptr
// CHECK-32WAVE-512WGSize-NEXT:    [[IN_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[IN_ADDR]] to ptr
// CHECK-32WAVE-512WGSize-NEXT:    [[VLA_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[VLA_ADDR]] to ptr
// CHECK-32WAVE-512WGSize-NEXT:    [[SUM2_ADDR2_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM2_ADDR2]] to ptr
// CHECK-32WAVE-512WGSize-NEXT:    [[DOTADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR]] to ptr
// CHECK-32WAVE-512WGSize-NEXT:    [[DOTADDR3_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR3]] to ptr
// CHECK-32WAVE-512WGSize-NEXT:    [[DOTADDR4_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR4]] to ptr
// CHECK-32WAVE-512WGSize-NEXT:    [[I_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[I]] to ptr
// CHECK-32WAVE-512WGSize-NEXT:    [[DOTOMP_LB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_LB]] to ptr
// CHECK-32WAVE-512WGSize-NEXT:    [[DOTOMP_UB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_UB]] to ptr
// CHECK-32WAVE-512WGSize-NEXT:    [[DOTOMP_IV_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_IV]] to ptr
// CHECK-32WAVE-512WGSize-NEXT:    [[SUM25_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM25]] to ptr
// CHECK-32WAVE-512WGSize-NEXT:    store ptr [[DYN_PTR]], ptr [[DYN_PTR_ADDR_ASCAST]], align 8
// CHECK-32WAVE-512WGSize-NEXT:    store ptr [[OUT2]], ptr [[OUT2_ADDR_ASCAST]], align 8
// CHECK-32WAVE-512WGSize-NEXT:    store ptr [[SUM2]], ptr [[SUM2_ADDR_ASCAST]], align 8
// CHECK-32WAVE-512WGSize-NEXT:    store ptr [[IN]], ptr [[IN_ADDR_ASCAST]], align 8
// CHECK-32WAVE-512WGSize-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR_ASCAST]], align 8
// CHECK-32WAVE-512WGSize-NEXT:    store ptr [[SUM21]], ptr [[SUM2_ADDR2_ASCAST]], align 8
// CHECK-32WAVE-512WGSize-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR_ASCAST]], align 8
// CHECK-32WAVE-512WGSize-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR3_ASCAST]], align 8
// CHECK-32WAVE-512WGSize-NEXT:    store ptr [[TMP2]], ptr [[DOTADDR4_ASCAST]], align 8
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[OUT2_ADDR_ASCAST]], align 8
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[SUM2_ADDR_ASCAST]], align 8
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[IN_ADDR_ASCAST]], align 8
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP6:%.*]] = load i64, ptr [[VLA_ADDR_ASCAST]], align 8
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[SUM2_ADDR2_ASCAST]], align 8
// CHECK-32WAVE-512WGSize-NEXT:    call void @__kmpc_specialized_kernel_init()
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP8:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-32WAVE-512WGSize-NEXT:    store i32 0, ptr addrspace(5) [[TMP8]], align 4
// CHECK-32WAVE-512WGSize-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// CHECK-32WAVE-512WGSize-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// CHECK-32WAVE-512WGSize-NEXT:    store i32 0, ptr [[DOTOMP_LB_ASCAST]], align 4
// CHECK-32WAVE-512WGSize-NEXT:    store i32 127999, ptr [[DOTOMP_UB_ASCAST]], align 4
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP9:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// CHECK-32WAVE-512WGSize-NEXT:    store i32 [[TMP9]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP10:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// CHECK-32WAVE-512WGSize-NEXT:    [[NVPTX_NUM_THREADS:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// CHECK-32WAVE-512WGSize-NEXT:    [[GPU_BLOCK_ID:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP11:%.*]] = mul i32 [[GPU_BLOCK_ID]], [[NVPTX_NUM_THREADS]]
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP12:%.*]] = add i32 [[TMP11]], [[TMP10]]
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP13:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP14:%.*]] = add i32 [[TMP12]], [[TMP13]]
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP15:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP16:%.*]] = zext i32 [[TMP14]] to i64
// CHECK-32WAVE-512WGSize-NEXT:    [[TOTAL_NUM_THREADS:%.*]] = mul i32 [[TMP15]], [[NVPTX_NUM_THREADS]]
// CHECK-32WAVE-512WGSize-NEXT:    store i32 [[TMP14]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP17:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-32WAVE-512WGSize-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP17]], 1
// CHECK-32WAVE-512WGSize-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK-32WAVE-512WGSize-NEXT:    store i32 [[ADD]], ptr [[I_ASCAST]], align 4
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP18:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP19:%.*]] = load i32, ptr [[DOTOMP_UB_ASCAST]], align 4
// CHECK-32WAVE-512WGSize-NEXT:    [[CMP:%.*]] = icmp sle i32 [[TMP18]], [[TMP19]]
// CHECK-32WAVE-512WGSize-NEXT:    br i1 [[CMP]], label [[OMP_KERNEL_BODY:%.*]], label [[OMP_KERNEL_DONE:%.*]]
// CHECK-32WAVE-512WGSize:       omp.kernel.body:
// CHECK-32WAVE-512WGSize-NEXT:    store i32 0, ptr [[SUM25_ASCAST]], align 4
// CHECK-32WAVE-512WGSize-NEXT:    br label [[OMP_INSCAN_DISPATCH:%.*]]
// CHECK-32WAVE-512WGSize:       omp.before.scan.bb:
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP20:%.*]] = load i32, ptr [[TMP4]], align 4
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP21:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// CHECK-32WAVE-512WGSize-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP21]] to i64
// CHECK-32WAVE-512WGSize-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [128000 x i32], ptr [[TMP3]], i64 0, i64 [[IDXPROM]]
// CHECK-32WAVE-512WGSize-NEXT:    store i32 [[TMP20]], ptr [[ARRAYIDX]], align 4
// CHECK-32WAVE-512WGSize-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK-32WAVE-512WGSize:       omp.exit.inscan.bb:
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP22:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP23:%.*]] = zext i32 [[TMP22]] to i64
// CHECK-32WAVE-512WGSize-NEXT:    br label [[OMP_BODY_CONTINUE]]
// CHECK-32WAVE-512WGSize:       omp.inscan.dispatch:
// CHECK-32WAVE-512WGSize-NEXT:    br label [[OMP_AFTER_SCAN_BB:%.*]]
// CHECK-32WAVE-512WGSize:       omp.after.scan.bb:
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP24:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// CHECK-32WAVE-512WGSize-NEXT:    [[IDXPROM6:%.*]] = sext i32 [[TMP24]] to i64
// CHECK-32WAVE-512WGSize-NEXT:    [[ARRAYIDX7:%.*]] = getelementptr inbounds [128000 x i32], ptr [[TMP5]], i64 0, i64 [[IDXPROM6]]
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP25:%.*]] = load i32, ptr [[ARRAYIDX7]], align 4
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP26:%.*]] = load i32, ptr addrspace(5) [[TMP8]], align 4
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP27:%.*]] = add i32 [[TMP26]], [[TMP25]]
// CHECK-32WAVE-512WGSize-NEXT:    store i32 [[TMP27]], ptr addrspace(5) [[TMP8]], align 4
// CHECK-32WAVE-512WGSize-NEXT:    br label [[OMP_EXIT_INSCAN_BB:%.*]]
// CHECK-32WAVE-512WGSize:       omp.body.continue:
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP28:%.*]] = load ptr, ptr [[DOTADDR_ASCAST]], align 8
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP29:%.*]] = load ptr, ptr [[DOTADDR3_ASCAST]], align 8
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP30:%.*]] = load ptr, ptr [[DOTADDR4_ASCAST]], align 8
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP31:%.*]] = load i32, ptr addrspace(5) [[TMP8]], align 4
// CHECK-32WAVE-512WGSize-NEXT:    call void @__kmpc_xteams_i_16x32(i32 [[TMP31]], ptr [[TMP30]], ptr [[TMP4]], ptr [[TMP28]], ptr [[TMP29]], ptr @__kmpc_rfun_sum_i, ptr @__kmpc_rfun_sum_lds_i, i32 0, i64 [[TMP16]], i32 [[TMP15]])
// CHECK-32WAVE-512WGSize-NEXT:    br label [[OMP_KERNEL_DONE]]
// CHECK-32WAVE-512WGSize:       omp.kernel.done:
// CHECK-32WAVE-512WGSize-NEXT:    ret void
//
//
// CHECK-32WAVE-512WGSize-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l57_1
// CHECK-32WAVE-512WGSize-SAME: (ptr noalias noundef [[DYN_PTR:%.*]], ptr noundef nonnull align 4 dereferenceable(512000) [[OUT2:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM2:%.*]], ptr noundef nonnull align 4 dereferenceable(512000) [[IN:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM21:%.*]], ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]], ptr noundef [[TMP2:%.*]]) #[[ATTR0]] {
// CHECK-32WAVE-512WGSize-NEXT:  entry:
// CHECK-32WAVE-512WGSize-NEXT:    [[DYN_PTR_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-32WAVE-512WGSize-NEXT:    [[OUT2_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-32WAVE-512WGSize-NEXT:    [[SUM2_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-32WAVE-512WGSize-NEXT:    [[IN_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-32WAVE-512WGSize-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8, addrspace(5)
// CHECK-32WAVE-512WGSize-NEXT:    [[SUM2_ADDR2:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-32WAVE-512WGSize-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-32WAVE-512WGSize-NEXT:    [[DOTADDR3:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-32WAVE-512WGSize-NEXT:    [[DOTADDR4:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-32WAVE-512WGSize-NEXT:    [[I:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-32WAVE-512WGSize-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-32WAVE-512WGSize-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-32WAVE-512WGSize-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-32WAVE-512WGSize-NEXT:    [[SUM25:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-32WAVE-512WGSize-NEXT:    [[DYN_PTR_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DYN_PTR_ADDR]] to ptr
// CHECK-32WAVE-512WGSize-NEXT:    [[OUT2_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[OUT2_ADDR]] to ptr
// CHECK-32WAVE-512WGSize-NEXT:    [[SUM2_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM2_ADDR]] to ptr
// CHECK-32WAVE-512WGSize-NEXT:    [[IN_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[IN_ADDR]] to ptr
// CHECK-32WAVE-512WGSize-NEXT:    [[VLA_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[VLA_ADDR]] to ptr
// CHECK-32WAVE-512WGSize-NEXT:    [[SUM2_ADDR2_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM2_ADDR2]] to ptr
// CHECK-32WAVE-512WGSize-NEXT:    [[DOTADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR]] to ptr
// CHECK-32WAVE-512WGSize-NEXT:    [[DOTADDR3_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR3]] to ptr
// CHECK-32WAVE-512WGSize-NEXT:    [[DOTADDR4_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR4]] to ptr
// CHECK-32WAVE-512WGSize-NEXT:    [[I_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[I]] to ptr
// CHECK-32WAVE-512WGSize-NEXT:    [[DOTOMP_LB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_LB]] to ptr
// CHECK-32WAVE-512WGSize-NEXT:    [[DOTOMP_UB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_UB]] to ptr
// CHECK-32WAVE-512WGSize-NEXT:    [[DOTOMP_IV_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_IV]] to ptr
// CHECK-32WAVE-512WGSize-NEXT:    [[SUM25_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM25]] to ptr
// CHECK-32WAVE-512WGSize-NEXT:    store ptr [[DYN_PTR]], ptr [[DYN_PTR_ADDR_ASCAST]], align 8
// CHECK-32WAVE-512WGSize-NEXT:    store ptr [[OUT2]], ptr [[OUT2_ADDR_ASCAST]], align 8
// CHECK-32WAVE-512WGSize-NEXT:    store ptr [[SUM2]], ptr [[SUM2_ADDR_ASCAST]], align 8
// CHECK-32WAVE-512WGSize-NEXT:    store ptr [[IN]], ptr [[IN_ADDR_ASCAST]], align 8
// CHECK-32WAVE-512WGSize-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR_ASCAST]], align 8
// CHECK-32WAVE-512WGSize-NEXT:    store ptr [[SUM21]], ptr [[SUM2_ADDR2_ASCAST]], align 8
// CHECK-32WAVE-512WGSize-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR_ASCAST]], align 8
// CHECK-32WAVE-512WGSize-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR3_ASCAST]], align 8
// CHECK-32WAVE-512WGSize-NEXT:    store ptr [[TMP2]], ptr [[DOTADDR4_ASCAST]], align 8
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[OUT2_ADDR_ASCAST]], align 8
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[SUM2_ADDR_ASCAST]], align 8
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[IN_ADDR_ASCAST]], align 8
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP6:%.*]] = load i64, ptr [[VLA_ADDR_ASCAST]], align 8
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[SUM2_ADDR2_ASCAST]], align 8
// CHECK-32WAVE-512WGSize-NEXT:    call void @__kmpc_specialized_kernel_init()
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP8:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-32WAVE-512WGSize-NEXT:    store i32 0, ptr addrspace(5) [[TMP8]], align 4
// CHECK-32WAVE-512WGSize-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// CHECK-32WAVE-512WGSize-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// CHECK-32WAVE-512WGSize-NEXT:    store i32 0, ptr [[DOTOMP_LB_ASCAST]], align 4
// CHECK-32WAVE-512WGSize-NEXT:    store i32 127999, ptr [[DOTOMP_UB_ASCAST]], align 4
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP9:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// CHECK-32WAVE-512WGSize-NEXT:    store i32 [[TMP9]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP10:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// CHECK-32WAVE-512WGSize-NEXT:    [[NVPTX_NUM_THREADS:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// CHECK-32WAVE-512WGSize-NEXT:    [[GPU_BLOCK_ID:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP11:%.*]] = mul i32 [[GPU_BLOCK_ID]], [[NVPTX_NUM_THREADS]]
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP12:%.*]] = add i32 [[TMP11]], [[TMP10]]
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP13:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP14:%.*]] = add i32 [[TMP12]], [[TMP13]]
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP15:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP16:%.*]] = zext i32 [[TMP14]] to i64
// CHECK-32WAVE-512WGSize-NEXT:    [[TOTAL_NUM_THREADS:%.*]] = mul i32 [[TMP15]], [[NVPTX_NUM_THREADS]]
// CHECK-32WAVE-512WGSize-NEXT:    store i32 [[TMP14]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP17:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-32WAVE-512WGSize-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP17]], 1
// CHECK-32WAVE-512WGSize-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK-32WAVE-512WGSize-NEXT:    store i32 [[ADD]], ptr [[I_ASCAST]], align 4
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP18:%.*]] = load ptr, ptr [[DOTADDR_ASCAST]], align 8
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP19:%.*]] = load ptr, ptr [[DOTADDR4_ASCAST]], align 8
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP20:%.*]] = load ptr, ptr [[DOTADDR_ASCAST]], align 8
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP21:%.*]] = load ptr, ptr [[DOTADDR4_ASCAST]], align 8
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP22:%.*]] = load i32, ptr addrspace(5) [[TMP8]], align 4
// CHECK-32WAVE-512WGSize-NEXT:    call void @__kmpc_xteams_phase2_i_16x32(ptr [[TMP21]], i32 1, ptr [[TMP20]], ptr [[TMP21]], ptr @__kmpc_rfun_sum_i, i32 0, i64 [[TMP16]], i32 0)
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP23:%.*]] = add i32 [[TMP12]], [[TOTAL_NUM_THREADS]]
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP24:%.*]] = getelementptr i32, ptr [[TMP19]], i32 [[TMP23]]
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP25:%.*]] = load i32, ptr [[TMP24]], align 4
// CHECK-32WAVE-512WGSize-NEXT:    store i32 [[TMP25]], ptr addrspace(5) [[TMP8]], align 4
// CHECK-32WAVE-512WGSize-NEXT:    store i32 0, ptr [[SUM25_ASCAST]], align 4
// CHECK-32WAVE-512WGSize-NEXT:    br label [[OMP_INSCAN_DISPATCH:%.*]]
// CHECK-32WAVE-512WGSize:       omp.before.scan.bb:
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP26:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// CHECK-32WAVE-512WGSize-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP26]] to i64
// CHECK-32WAVE-512WGSize-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [128000 x i32], ptr [[TMP3]], i64 0, i64 [[IDXPROM]]
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP27:%.*]] = load i32, ptr addrspace(5) [[TMP8]], align 4
// CHECK-32WAVE-512WGSize-NEXT:    store i32 [[TMP27]], ptr [[ARRAYIDX]], align 4
// CHECK-32WAVE-512WGSize-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK-32WAVE-512WGSize:       omp.exit.inscan.bb:
// CHECK-32WAVE-512WGSize-NEXT:    br label [[OMP_BODY_CONTINUE]]
// CHECK-32WAVE-512WGSize:       omp.inscan.dispatch:
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP28:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP29:%.*]] = zext i32 [[TMP28]] to i64
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP30:%.*]] = icmp eq i64 [[TMP29]], 0
// CHECK-32WAVE-512WGSize-NEXT:    br i1 [[TMP30]], label [[OMP_EXCLUSIVE_COPY_EXIT:%.*]], label [[OMP_EXCLUSIVE_DEC:%.*]]
// CHECK-32WAVE-512WGSize:       omp.exclusive.dec:
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP31:%.*]] = sub nuw i64 [[TMP29]], 1
// CHECK-32WAVE-512WGSize-NEXT:    [[ARRAYIDX6:%.*]] = getelementptr inbounds nuw i32, ptr [[TMP7]], i64 [[TMP31]]
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP32:%.*]] = load i32, ptr addrspace(5) [[TMP8]], align 4
// CHECK-32WAVE-512WGSize-NEXT:    store i32 [[TMP32]], ptr [[TMP4]], align 4
// CHECK-32WAVE-512WGSize-NEXT:    br label [[OMP_EXCLUSIVE_COPY_EXIT]]
// CHECK-32WAVE-512WGSize:       omp.exclusive.copy.exit:
// CHECK-32WAVE-512WGSize-NEXT:    br label [[OMP_BEFORE_SCAN_BB:%.*]]
// CHECK-32WAVE-512WGSize:       omp.after.scan.bb:
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP33:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// CHECK-32WAVE-512WGSize-NEXT:    [[IDXPROM7:%.*]] = sext i32 [[TMP33]] to i64
// CHECK-32WAVE-512WGSize-NEXT:    [[ARRAYIDX8:%.*]] = getelementptr inbounds [128000 x i32], ptr [[TMP5]], i64 0, i64 [[IDXPROM7]]
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP34:%.*]] = load i32, ptr [[ARRAYIDX8]], align 4
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP35:%.*]] = load i32, ptr addrspace(5) [[TMP8]], align 4
// CHECK-32WAVE-512WGSize-NEXT:    [[TMP36:%.*]] = add i32 [[TMP35]], [[TMP34]]
// CHECK-32WAVE-512WGSize-NEXT:    store i32 [[TMP36]], ptr addrspace(5) [[TMP8]], align 4
// CHECK-32WAVE-512WGSize-NEXT:    br label [[OMP_EXIT_INSCAN_BB:%.*]]
// CHECK-32WAVE-512WGSize:       omp.body.continue:
// CHECK-32WAVE-512WGSize-NEXT:    ret void
//
//
// SEGMENTED-64WAVE-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l47
// SEGMENTED-64WAVE-SAME: (ptr noalias noundef [[DYN_PTR:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM1:%.*]], ptr noundef nonnull align 4 dereferenceable(256000) [[IN:%.*]], ptr noundef nonnull align 4 dereferenceable(256000) [[OUT1:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM11:%.*]], ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]], ptr noundef [[TMP2:%.*]], ptr noundef [[TMP3:%.*]]) #[[ATTR0:[0-9]+]] {
// SEGMENTED-64WAVE-NEXT:  entry:
// SEGMENTED-64WAVE-NEXT:    [[DYN_PTR_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-64WAVE-NEXT:    [[SUM1_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-64WAVE-NEXT:    [[IN_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-64WAVE-NEXT:    [[OUT1_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-64WAVE-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8, addrspace(5)
// SEGMENTED-64WAVE-NEXT:    [[SUM1_ADDR2:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-64WAVE-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-64WAVE-NEXT:    [[DOTADDR3:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-64WAVE-NEXT:    [[DOTADDR4:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-64WAVE-NEXT:    [[DOTADDR5:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-64WAVE-NEXT:    [[I:%.*]] = alloca i32, align 4, addrspace(5)
// SEGMENTED-64WAVE-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4, addrspace(5)
// SEGMENTED-64WAVE-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4, addrspace(5)
// SEGMENTED-64WAVE-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4, addrspace(5)
// SEGMENTED-64WAVE-NEXT:    [[SUM18:%.*]] = alloca i32, align 4, addrspace(5)
// SEGMENTED-64WAVE-NEXT:    [[DYN_PTR_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DYN_PTR_ADDR]] to ptr
// SEGMENTED-64WAVE-NEXT:    [[SUM1_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM1_ADDR]] to ptr
// SEGMENTED-64WAVE-NEXT:    [[IN_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[IN_ADDR]] to ptr
// SEGMENTED-64WAVE-NEXT:    [[OUT1_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[OUT1_ADDR]] to ptr
// SEGMENTED-64WAVE-NEXT:    [[VLA_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[VLA_ADDR]] to ptr
// SEGMENTED-64WAVE-NEXT:    [[SUM1_ADDR2_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM1_ADDR2]] to ptr
// SEGMENTED-64WAVE-NEXT:    [[DOTADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR]] to ptr
// SEGMENTED-64WAVE-NEXT:    [[DOTADDR3_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR3]] to ptr
// SEGMENTED-64WAVE-NEXT:    [[DOTADDR4_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR4]] to ptr
// SEGMENTED-64WAVE-NEXT:    [[DOTADDR5_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR5]] to ptr
// SEGMENTED-64WAVE-NEXT:    [[I_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[I]] to ptr
// SEGMENTED-64WAVE-NEXT:    [[DOTOMP_LB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_LB]] to ptr
// SEGMENTED-64WAVE-NEXT:    [[DOTOMP_UB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_UB]] to ptr
// SEGMENTED-64WAVE-NEXT:    [[DOTOMP_IV_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_IV]] to ptr
// SEGMENTED-64WAVE-NEXT:    [[SUM18_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM18]] to ptr
// SEGMENTED-64WAVE-NEXT:    store ptr [[DYN_PTR]], ptr [[DYN_PTR_ADDR_ASCAST]], align 8
// SEGMENTED-64WAVE-NEXT:    store ptr [[SUM1]], ptr [[SUM1_ADDR_ASCAST]], align 8
// SEGMENTED-64WAVE-NEXT:    store ptr [[IN]], ptr [[IN_ADDR_ASCAST]], align 8
// SEGMENTED-64WAVE-NEXT:    store ptr [[OUT1]], ptr [[OUT1_ADDR_ASCAST]], align 8
// SEGMENTED-64WAVE-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR_ASCAST]], align 8
// SEGMENTED-64WAVE-NEXT:    store ptr [[SUM11]], ptr [[SUM1_ADDR2_ASCAST]], align 8
// SEGMENTED-64WAVE-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR_ASCAST]], align 8
// SEGMENTED-64WAVE-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR3_ASCAST]], align 8
// SEGMENTED-64WAVE-NEXT:    store ptr [[TMP2]], ptr [[DOTADDR4_ASCAST]], align 8
// SEGMENTED-64WAVE-NEXT:    store ptr [[TMP3]], ptr [[DOTADDR5_ASCAST]], align 8
// SEGMENTED-64WAVE-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[SUM1_ADDR_ASCAST]], align 8
// SEGMENTED-64WAVE-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[IN_ADDR_ASCAST]], align 8
// SEGMENTED-64WAVE-NEXT:    [[TMP6:%.*]] = load ptr, ptr [[OUT1_ADDR_ASCAST]], align 8
// SEGMENTED-64WAVE-NEXT:    [[TMP7:%.*]] = load i64, ptr [[VLA_ADDR_ASCAST]], align 8
// SEGMENTED-64WAVE-NEXT:    [[TMP8:%.*]] = load ptr, ptr [[SUM1_ADDR2_ASCAST]], align 8
// SEGMENTED-64WAVE-NEXT:    call void @__kmpc_specialized_kernel_init()
// SEGMENTED-64WAVE-NEXT:    [[TMP9:%.*]] = alloca i32, align 4, addrspace(5)
// SEGMENTED-64WAVE-NEXT:    store i32 0, ptr addrspace(5) [[TMP9]], align 4
// SEGMENTED-64WAVE-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// SEGMENTED-64WAVE-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// SEGMENTED-64WAVE-NEXT:    store i32 0, ptr [[DOTOMP_LB_ASCAST]], align 4
// SEGMENTED-64WAVE-NEXT:    store i32 63999, ptr [[DOTOMP_UB_ASCAST]], align 4
// SEGMENTED-64WAVE-NEXT:    [[TMP10:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// SEGMENTED-64WAVE-NEXT:    store i32 [[TMP10]], ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-64WAVE-NEXT:    [[TMP11:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// SEGMENTED-64WAVE-NEXT:    [[NVPTX_NUM_THREADS:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// SEGMENTED-64WAVE-NEXT:    [[GPU_BLOCK_ID:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// SEGMENTED-64WAVE-NEXT:    [[TMP12:%.*]] = mul i32 [[GPU_BLOCK_ID]], [[NVPTX_NUM_THREADS]]
// SEGMENTED-64WAVE-NEXT:    [[TMP13:%.*]] = add i32 [[TMP12]], [[TMP11]]
// SEGMENTED-64WAVE-NEXT:    [[TMP14:%.*]] = mul i32 [[TMP13]], 1
// SEGMENTED-64WAVE-NEXT:    [[TMP15:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-64WAVE-NEXT:    [[TMP16:%.*]] = add i32 [[TMP14]], [[TMP15]]
// SEGMENTED-64WAVE-NEXT:    [[TMP17:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// SEGMENTED-64WAVE-NEXT:    [[TMP18:%.*]] = zext i32 [[TMP16]] to i64
// SEGMENTED-64WAVE-NEXT:    store i32 [[TMP16]], ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-64WAVE-NEXT:    [[GLOBAL_UPPER_BOUND:%.*]] = load i32, ptr [[DOTOMP_UB_ASCAST]], align 4
// SEGMENTED-64WAVE-NEXT:    [[TMP19:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// SEGMENTED-64WAVE-NEXT:    [[TMP20:%.*]] = sub i32 [[GLOBAL_UPPER_BOUND]], [[TMP19]]
// SEGMENTED-64WAVE-NEXT:    [[TMP21:%.*]] = add i32 [[TMP20]], 1
// SEGMENTED-64WAVE-NEXT:    [[TMP22:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// SEGMENTED-64WAVE-NEXT:    [[NVPTX_NUM_THREADS6:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// SEGMENTED-64WAVE-NEXT:    [[GPU_BLOCK_ID7:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// SEGMENTED-64WAVE-NEXT:    [[TMP23:%.*]] = mul i32 [[GPU_BLOCK_ID7]], [[NVPTX_NUM_THREADS6]]
// SEGMENTED-64WAVE-NEXT:    [[TMP24:%.*]] = add i32 [[TMP23]], [[TMP22]]
// SEGMENTED-64WAVE-NEXT:    [[TMP25:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// SEGMENTED-64WAVE-NEXT:    [[TMP26:%.*]] = mul i32 [[NVPTX_NUM_THREADS6]], [[TMP25]]
// SEGMENTED-64WAVE-NEXT:    [[TMP27:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-64WAVE-NEXT:    [[TMP28:%.*]] = icmp ult i32 [[TMP27]], [[TMP26]]
// SEGMENTED-64WAVE-NEXT:    br i1 [[TMP28]], label [[OMP_KERNEL_BODY:%.*]], label [[OMP_KERNEL_DONE:%.*]]
// SEGMENTED-64WAVE:       omp.kernel.body:
// SEGMENTED-64WAVE-NEXT:    [[TMP29:%.*]] = udiv i32 [[TMP21]], [[TMP26]]
// SEGMENTED-64WAVE-NEXT:    [[PADDED_SEGMENT_SIZE:%.*]] = add i32 [[TMP29]], 1
// SEGMENTED-64WAVE-NEXT:    [[TMP30:%.*]] = mul i32 [[PADDED_SEGMENT_SIZE]], [[TMP24]]
// SEGMENTED-64WAVE-NEXT:    store i32 [[TMP30]], ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-64WAVE-NEXT:    [[TMP31:%.*]] = add i32 [[TMP24]], 1
// SEGMENTED-64WAVE-NEXT:    [[TMP32:%.*]] = mul i32 [[PADDED_SEGMENT_SIZE]], [[TMP31]]
// SEGMENTED-64WAVE-NEXT:    [[TMP33:%.*]] = load ptr, ptr [[DOTADDR5_ASCAST]], align 8
// SEGMENTED-64WAVE-NEXT:    br label [[FOR_COND:%.*]]
// SEGMENTED-64WAVE:       for.cond:
// SEGMENTED-64WAVE-NEXT:    [[TMP34:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-64WAVE-NEXT:    [[TMP35:%.*]] = icmp ult i32 [[TMP34]], [[TMP32]]
// SEGMENTED-64WAVE-NEXT:    [[TMP36:%.*]] = icmp ule i32 [[TMP34]], [[GLOBAL_UPPER_BOUND]]
// SEGMENTED-64WAVE-NEXT:    [[TMP37:%.*]] = and i1 [[TMP36]], [[TMP35]]
// SEGMENTED-64WAVE-NEXT:    br i1 [[TMP37]], label [[FOR_BODY:%.*]], label [[FOR_END:%.*]]
// SEGMENTED-64WAVE:       for.body:
// SEGMENTED-64WAVE-NEXT:    [[TMP38:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-64WAVE-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP38]], 1
// SEGMENTED-64WAVE-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// SEGMENTED-64WAVE-NEXT:    store i32 [[ADD]], ptr [[I_ASCAST]], align 4
// SEGMENTED-64WAVE-NEXT:    store i32 0, ptr [[SUM18_ASCAST]], align 4
// SEGMENTED-64WAVE-NEXT:    br label [[OMP_INSCAN_DISPATCH:%.*]]
// SEGMENTED-64WAVE:       omp.before.scan.bb:
// SEGMENTED-64WAVE-NEXT:    [[TMP39:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// SEGMENTED-64WAVE-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP39]] to i64
// SEGMENTED-64WAVE-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [64000 x i32], ptr [[TMP5]], i64 0, i64 [[IDXPROM]]
// SEGMENTED-64WAVE-NEXT:    [[TMP40:%.*]] = load i32, ptr [[ARRAYIDX]], align 4
// SEGMENTED-64WAVE-NEXT:    [[TMP41:%.*]] = load i32, ptr addrspace(5) [[TMP9]], align 4
// SEGMENTED-64WAVE-NEXT:    [[TMP42:%.*]] = add i32 [[TMP41]], [[TMP40]]
// SEGMENTED-64WAVE-NEXT:    store i32 [[TMP42]], ptr addrspace(5) [[TMP9]], align 4
// SEGMENTED-64WAVE-NEXT:    [[TMP43:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-64WAVE-NEXT:    [[TMP44:%.*]] = zext i32 [[TMP43]] to i64
// SEGMENTED-64WAVE-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// SEGMENTED-64WAVE:       omp.exit.inscan.bb:
// SEGMENTED-64WAVE-NEXT:    br label [[OMP_BODY_CONTINUE]]
// SEGMENTED-64WAVE:       omp.inscan.dispatch:
// SEGMENTED-64WAVE-NEXT:    br label [[OMP_BEFORE_SCAN_BB:%.*]]
// SEGMENTED-64WAVE:       omp.after.scan.bb:
// SEGMENTED-64WAVE-NEXT:    [[TMP45:%.*]] = load i32, ptr [[TMP4]], align 4
// SEGMENTED-64WAVE-NEXT:    [[TMP46:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// SEGMENTED-64WAVE-NEXT:    [[IDXPROM9:%.*]] = sext i32 [[TMP46]] to i64
// SEGMENTED-64WAVE-NEXT:    [[ARRAYIDX10:%.*]] = getelementptr inbounds [64000 x i32], ptr [[TMP6]], i64 0, i64 [[IDXPROM9]]
// SEGMENTED-64WAVE-NEXT:    store i32 [[TMP45]], ptr [[ARRAYIDX10]], align 4
// SEGMENTED-64WAVE-NEXT:    br label [[OMP_EXIT_INSCAN_BB:%.*]]
// SEGMENTED-64WAVE:       omp.body.continue:
// SEGMENTED-64WAVE-NEXT:    br label [[FOR_INC:%.*]]
// SEGMENTED-64WAVE:       for.inc:
// SEGMENTED-64WAVE-NEXT:    [[TMP47:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-64WAVE-NEXT:    [[TMP48:%.*]] = getelementptr i32, ptr [[TMP33]], i32 [[TMP47]]
// SEGMENTED-64WAVE-NEXT:    [[TMP49:%.*]] = load i32, ptr addrspace(5) [[TMP9]], align 4
// SEGMENTED-64WAVE-NEXT:    store i32 [[TMP49]], ptr [[TMP48]], align 4
// SEGMENTED-64WAVE-NEXT:    [[TMP50:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-64WAVE-NEXT:    [[TMP51:%.*]] = add i32 1, [[TMP50]]
// SEGMENTED-64WAVE-NEXT:    store i32 [[TMP51]], ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-64WAVE-NEXT:    br label [[FOR_COND]], !llvm.loop [[LOOP13:![0-9]+]]
// SEGMENTED-64WAVE:       for.end:
// SEGMENTED-64WAVE-NEXT:    [[TMP52:%.*]] = load ptr, ptr [[DOTADDR_ASCAST]], align 8
// SEGMENTED-64WAVE-NEXT:    [[TMP53:%.*]] = load ptr, ptr [[DOTADDR3_ASCAST]], align 8
// SEGMENTED-64WAVE-NEXT:    [[TMP54:%.*]] = load ptr, ptr [[DOTADDR4_ASCAST]], align 8
// SEGMENTED-64WAVE-NEXT:    [[TMP55:%.*]] = load i32, ptr addrspace(5) [[TMP9]], align 4
// SEGMENTED-64WAVE-NEXT:    call void @__kmpc_xteams_i_4x64(i32 [[TMP55]], ptr [[TMP54]], ptr [[TMP4]], ptr [[TMP52]], ptr [[TMP53]], ptr @__kmpc_rfun_sum_i, ptr @__kmpc_rfun_sum_lds_i, i32 0, i64 [[TMP18]], i32 [[TMP17]])
// SEGMENTED-64WAVE-NEXT:    br label [[OMP_KERNEL_DONE]]
// SEGMENTED-64WAVE:       omp.kernel.done:
// SEGMENTED-64WAVE-NEXT:    ret void
//
//
// SEGMENTED-64WAVE-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l47_1
// SEGMENTED-64WAVE-SAME: (ptr noalias noundef [[DYN_PTR:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM1:%.*]], ptr noundef nonnull align 4 dereferenceable(256000) [[IN:%.*]], ptr noundef nonnull align 4 dereferenceable(256000) [[OUT1:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM11:%.*]], ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]], ptr noundef [[TMP2:%.*]], ptr noundef [[TMP3:%.*]]) #[[ATTR0]] {
// SEGMENTED-64WAVE-NEXT:  entry:
// SEGMENTED-64WAVE-NEXT:    [[DYN_PTR_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-64WAVE-NEXT:    [[SUM1_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-64WAVE-NEXT:    [[IN_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-64WAVE-NEXT:    [[OUT1_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-64WAVE-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8, addrspace(5)
// SEGMENTED-64WAVE-NEXT:    [[SUM1_ADDR2:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-64WAVE-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-64WAVE-NEXT:    [[DOTADDR3:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-64WAVE-NEXT:    [[DOTADDR4:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-64WAVE-NEXT:    [[DOTADDR5:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-64WAVE-NEXT:    [[I:%.*]] = alloca i32, align 4, addrspace(5)
// SEGMENTED-64WAVE-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4, addrspace(5)
// SEGMENTED-64WAVE-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4, addrspace(5)
// SEGMENTED-64WAVE-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4, addrspace(5)
// SEGMENTED-64WAVE-NEXT:    [[SUM18:%.*]] = alloca i32, align 4, addrspace(5)
// SEGMENTED-64WAVE-NEXT:    [[DYN_PTR_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DYN_PTR_ADDR]] to ptr
// SEGMENTED-64WAVE-NEXT:    [[SUM1_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM1_ADDR]] to ptr
// SEGMENTED-64WAVE-NEXT:    [[IN_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[IN_ADDR]] to ptr
// SEGMENTED-64WAVE-NEXT:    [[OUT1_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[OUT1_ADDR]] to ptr
// SEGMENTED-64WAVE-NEXT:    [[VLA_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[VLA_ADDR]] to ptr
// SEGMENTED-64WAVE-NEXT:    [[SUM1_ADDR2_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM1_ADDR2]] to ptr
// SEGMENTED-64WAVE-NEXT:    [[DOTADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR]] to ptr
// SEGMENTED-64WAVE-NEXT:    [[DOTADDR3_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR3]] to ptr
// SEGMENTED-64WAVE-NEXT:    [[DOTADDR4_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR4]] to ptr
// SEGMENTED-64WAVE-NEXT:    [[DOTADDR5_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR5]] to ptr
// SEGMENTED-64WAVE-NEXT:    [[I_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[I]] to ptr
// SEGMENTED-64WAVE-NEXT:    [[DOTOMP_LB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_LB]] to ptr
// SEGMENTED-64WAVE-NEXT:    [[DOTOMP_UB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_UB]] to ptr
// SEGMENTED-64WAVE-NEXT:    [[DOTOMP_IV_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_IV]] to ptr
// SEGMENTED-64WAVE-NEXT:    [[SUM18_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM18]] to ptr
// SEGMENTED-64WAVE-NEXT:    store ptr [[DYN_PTR]], ptr [[DYN_PTR_ADDR_ASCAST]], align 8
// SEGMENTED-64WAVE-NEXT:    store ptr [[SUM1]], ptr [[SUM1_ADDR_ASCAST]], align 8
// SEGMENTED-64WAVE-NEXT:    store ptr [[IN]], ptr [[IN_ADDR_ASCAST]], align 8
// SEGMENTED-64WAVE-NEXT:    store ptr [[OUT1]], ptr [[OUT1_ADDR_ASCAST]], align 8
// SEGMENTED-64WAVE-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR_ASCAST]], align 8
// SEGMENTED-64WAVE-NEXT:    store ptr [[SUM11]], ptr [[SUM1_ADDR2_ASCAST]], align 8
// SEGMENTED-64WAVE-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR_ASCAST]], align 8
// SEGMENTED-64WAVE-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR3_ASCAST]], align 8
// SEGMENTED-64WAVE-NEXT:    store ptr [[TMP2]], ptr [[DOTADDR4_ASCAST]], align 8
// SEGMENTED-64WAVE-NEXT:    store ptr [[TMP3]], ptr [[DOTADDR5_ASCAST]], align 8
// SEGMENTED-64WAVE-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[SUM1_ADDR_ASCAST]], align 8
// SEGMENTED-64WAVE-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[IN_ADDR_ASCAST]], align 8
// SEGMENTED-64WAVE-NEXT:    [[TMP6:%.*]] = load ptr, ptr [[OUT1_ADDR_ASCAST]], align 8
// SEGMENTED-64WAVE-NEXT:    [[TMP7:%.*]] = load i64, ptr [[VLA_ADDR_ASCAST]], align 8
// SEGMENTED-64WAVE-NEXT:    [[TMP8:%.*]] = load ptr, ptr [[SUM1_ADDR2_ASCAST]], align 8
// SEGMENTED-64WAVE-NEXT:    call void @__kmpc_specialized_kernel_init()
// SEGMENTED-64WAVE-NEXT:    [[TMP9:%.*]] = alloca i32, align 4, addrspace(5)
// SEGMENTED-64WAVE-NEXT:    store i32 0, ptr addrspace(5) [[TMP9]], align 4
// SEGMENTED-64WAVE-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// SEGMENTED-64WAVE-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// SEGMENTED-64WAVE-NEXT:    store i32 0, ptr [[DOTOMP_LB_ASCAST]], align 4
// SEGMENTED-64WAVE-NEXT:    store i32 63999, ptr [[DOTOMP_UB_ASCAST]], align 4
// SEGMENTED-64WAVE-NEXT:    [[TMP10:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// SEGMENTED-64WAVE-NEXT:    store i32 [[TMP10]], ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-64WAVE-NEXT:    [[TMP11:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// SEGMENTED-64WAVE-NEXT:    [[NVPTX_NUM_THREADS:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// SEGMENTED-64WAVE-NEXT:    [[GPU_BLOCK_ID:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// SEGMENTED-64WAVE-NEXT:    [[TMP12:%.*]] = mul i32 [[GPU_BLOCK_ID]], [[NVPTX_NUM_THREADS]]
// SEGMENTED-64WAVE-NEXT:    [[TMP13:%.*]] = add i32 [[TMP12]], [[TMP11]]
// SEGMENTED-64WAVE-NEXT:    [[TMP14:%.*]] = mul i32 [[TMP13]], 1
// SEGMENTED-64WAVE-NEXT:    [[TMP15:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-64WAVE-NEXT:    [[TMP16:%.*]] = add i32 [[TMP14]], [[TMP15]]
// SEGMENTED-64WAVE-NEXT:    [[TMP17:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// SEGMENTED-64WAVE-NEXT:    [[TMP18:%.*]] = zext i32 [[TMP16]] to i64
// SEGMENTED-64WAVE-NEXT:    store i32 [[TMP16]], ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-64WAVE-NEXT:    [[GLOBAL_UPPER_BOUND:%.*]] = load i32, ptr [[DOTOMP_UB_ASCAST]], align 4
// SEGMENTED-64WAVE-NEXT:    [[TMP19:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// SEGMENTED-64WAVE-NEXT:    [[TMP20:%.*]] = sub i32 [[GLOBAL_UPPER_BOUND]], [[TMP19]]
// SEGMENTED-64WAVE-NEXT:    [[TMP21:%.*]] = add i32 [[TMP20]], 1
// SEGMENTED-64WAVE-NEXT:    [[TMP22:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// SEGMENTED-64WAVE-NEXT:    [[NVPTX_NUM_THREADS6:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// SEGMENTED-64WAVE-NEXT:    [[GPU_BLOCK_ID7:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// SEGMENTED-64WAVE-NEXT:    [[TMP23:%.*]] = mul i32 [[GPU_BLOCK_ID7]], [[NVPTX_NUM_THREADS6]]
// SEGMENTED-64WAVE-NEXT:    [[TMP24:%.*]] = add i32 [[TMP23]], [[TMP22]]
// SEGMENTED-64WAVE-NEXT:    [[TMP25:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// SEGMENTED-64WAVE-NEXT:    [[TMP26:%.*]] = mul i32 [[NVPTX_NUM_THREADS6]], [[TMP25]]
// SEGMENTED-64WAVE-NEXT:    [[TMP27:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-64WAVE-NEXT:    [[TMP28:%.*]] = icmp ult i32 [[TMP27]], [[TMP26]]
// SEGMENTED-64WAVE-NEXT:    br i1 [[TMP28]], label [[OMP_KERNEL_BODY:%.*]], label [[OMP_KERNEL_DONE:%.*]]
// SEGMENTED-64WAVE:       omp.kernel.body:
// SEGMENTED-64WAVE-NEXT:    [[TMP29:%.*]] = udiv i32 [[TMP21]], [[TMP26]]
// SEGMENTED-64WAVE-NEXT:    [[PADDED_SEGMENT_SIZE:%.*]] = add i32 [[TMP29]], 1
// SEGMENTED-64WAVE-NEXT:    [[TMP30:%.*]] = load ptr, ptr [[DOTADDR_ASCAST]], align 8
// SEGMENTED-64WAVE-NEXT:    [[TMP31:%.*]] = load ptr, ptr [[DOTADDR4_ASCAST]], align 8
// SEGMENTED-64WAVE-NEXT:    [[TMP32:%.*]] = load ptr, ptr [[DOTADDR5_ASCAST]], align 8
// SEGMENTED-64WAVE-NEXT:    [[TMP33:%.*]] = load i32, ptr addrspace(5) [[TMP9]], align 4
// SEGMENTED-64WAVE-NEXT:    call void @__kmpc_xteams_phase2_i_4x64(ptr [[TMP31]], i32 [[PADDED_SEGMENT_SIZE]], ptr [[TMP30]], ptr [[TMP32]], ptr @__kmpc_rfun_sum_i, i32 0, i64 [[TMP18]], i32 1)
// SEGMENTED-64WAVE-NEXT:    [[TMP34:%.*]] = mul i32 [[PADDED_SEGMENT_SIZE]], [[TMP24]]
// SEGMENTED-64WAVE-NEXT:    store i32 [[TMP34]], ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-64WAVE-NEXT:    [[TMP35:%.*]] = add i32 [[TMP24]], 1
// SEGMENTED-64WAVE-NEXT:    [[TMP36:%.*]] = mul i32 [[PADDED_SEGMENT_SIZE]], [[TMP35]]
// SEGMENTED-64WAVE-NEXT:    [[TMP37:%.*]] = load ptr, ptr [[DOTADDR5_ASCAST]], align 8
// SEGMENTED-64WAVE-NEXT:    br label [[FOR_COND:%.*]]
// SEGMENTED-64WAVE:       for.cond:
// SEGMENTED-64WAVE-NEXT:    [[TMP38:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-64WAVE-NEXT:    [[TMP39:%.*]] = icmp ult i32 [[TMP38]], [[TMP36]]
// SEGMENTED-64WAVE-NEXT:    [[TMP40:%.*]] = icmp ule i32 [[TMP38]], [[GLOBAL_UPPER_BOUND]]
// SEGMENTED-64WAVE-NEXT:    [[TMP41:%.*]] = and i1 [[TMP40]], [[TMP39]]
// SEGMENTED-64WAVE-NEXT:    br i1 [[TMP41]], label [[FOR_BODY:%.*]], label [[FOR_END:%.*]]
// SEGMENTED-64WAVE:       for.body:
// SEGMENTED-64WAVE-NEXT:    [[TMP42:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-64WAVE-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP42]], 1
// SEGMENTED-64WAVE-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// SEGMENTED-64WAVE-NEXT:    store i32 [[ADD]], ptr [[I_ASCAST]], align 4
// SEGMENTED-64WAVE-NEXT:    [[TMP43:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-64WAVE-NEXT:    [[TMP44:%.*]] = getelementptr i32, ptr [[TMP37]], i32 [[TMP43]]
// SEGMENTED-64WAVE-NEXT:    [[TMP45:%.*]] = load i32, ptr [[TMP44]], align 4
// SEGMENTED-64WAVE-NEXT:    store i32 [[TMP45]], ptr addrspace(5) [[TMP9]], align 4
// SEGMENTED-64WAVE-NEXT:    store i32 0, ptr [[SUM18_ASCAST]], align 4
// SEGMENTED-64WAVE-NEXT:    br label [[OMP_INSCAN_DISPATCH:%.*]]
// SEGMENTED-64WAVE:       omp.before.scan.bb:
// SEGMENTED-64WAVE-NEXT:    [[TMP46:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// SEGMENTED-64WAVE-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP46]] to i64
// SEGMENTED-64WAVE-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [64000 x i32], ptr [[TMP5]], i64 0, i64 [[IDXPROM]]
// SEGMENTED-64WAVE-NEXT:    [[TMP47:%.*]] = load i32, ptr [[ARRAYIDX]], align 4
// SEGMENTED-64WAVE-NEXT:    [[TMP48:%.*]] = load i32, ptr addrspace(5) [[TMP9]], align 4
// SEGMENTED-64WAVE-NEXT:    [[TMP49:%.*]] = add i32 [[TMP48]], [[TMP47]]
// SEGMENTED-64WAVE-NEXT:    store i32 [[TMP49]], ptr addrspace(5) [[TMP9]], align 4
// SEGMENTED-64WAVE-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// SEGMENTED-64WAVE:       omp.exit.inscan.bb:
// SEGMENTED-64WAVE-NEXT:    br label [[OMP_BODY_CONTINUE]]
// SEGMENTED-64WAVE:       omp.inscan.dispatch:
// SEGMENTED-64WAVE-NEXT:    [[TMP50:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-64WAVE-NEXT:    [[TMP51:%.*]] = zext i32 [[TMP50]] to i64
// SEGMENTED-64WAVE-NEXT:    [[ARRAYIDX9:%.*]] = getelementptr inbounds nuw i32, ptr [[TMP8]], i64 [[TMP51]]
// SEGMENTED-64WAVE-NEXT:    [[TMP52:%.*]] = load i32, ptr addrspace(5) [[TMP9]], align 4
// SEGMENTED-64WAVE-NEXT:    store i32 [[TMP52]], ptr [[TMP4]], align 4
// SEGMENTED-64WAVE-NEXT:    br label [[OMP_AFTER_SCAN_BB:%.*]]
// SEGMENTED-64WAVE:       omp.after.scan.bb:
// SEGMENTED-64WAVE-NEXT:    [[TMP53:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// SEGMENTED-64WAVE-NEXT:    [[IDXPROM10:%.*]] = sext i32 [[TMP53]] to i64
// SEGMENTED-64WAVE-NEXT:    [[ARRAYIDX11:%.*]] = getelementptr inbounds [64000 x i32], ptr [[TMP6]], i64 0, i64 [[IDXPROM10]]
// SEGMENTED-64WAVE-NEXT:    [[TMP54:%.*]] = load i32, ptr addrspace(5) [[TMP9]], align 4
// SEGMENTED-64WAVE-NEXT:    store i32 [[TMP54]], ptr [[ARRAYIDX11]], align 4
// SEGMENTED-64WAVE-NEXT:    br label [[OMP_EXIT_INSCAN_BB:%.*]]
// SEGMENTED-64WAVE:       omp.body.continue:
// SEGMENTED-64WAVE-NEXT:    br label [[FOR_INC:%.*]]
// SEGMENTED-64WAVE:       for.inc:
// SEGMENTED-64WAVE-NEXT:    [[TMP55:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-64WAVE-NEXT:    [[TMP56:%.*]] = getelementptr i32, ptr [[TMP37]], i32 [[TMP55]]
// SEGMENTED-64WAVE-NEXT:    [[TMP57:%.*]] = load i32, ptr addrspace(5) [[TMP9]], align 4
// SEGMENTED-64WAVE-NEXT:    store i32 [[TMP57]], ptr [[TMP56]], align 4
// SEGMENTED-64WAVE-NEXT:    [[TMP58:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-64WAVE-NEXT:    [[TMP59:%.*]] = add i32 1, [[TMP58]]
// SEGMENTED-64WAVE-NEXT:    store i32 [[TMP59]], ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-64WAVE-NEXT:    br label [[FOR_COND]], !llvm.loop [[LOOP15:![0-9]+]]
// SEGMENTED-64WAVE:       for.end:
// SEGMENTED-64WAVE-NEXT:    br label [[OMP_KERNEL_DONE]]
// SEGMENTED-64WAVE:       omp.kernel.done:
// SEGMENTED-64WAVE-NEXT:    ret void
//
//
// SEGMENTED-64WAVE-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l57
// SEGMENTED-64WAVE-SAME: (ptr noalias noundef [[DYN_PTR:%.*]], ptr noundef nonnull align 4 dereferenceable(256000) [[OUT2:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM2:%.*]], ptr noundef nonnull align 4 dereferenceable(256000) [[IN:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM21:%.*]], ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]], ptr noundef [[TMP2:%.*]], ptr noundef [[TMP3:%.*]]) #[[ATTR0]] {
// SEGMENTED-64WAVE-NEXT:  entry:
// SEGMENTED-64WAVE-NEXT:    [[DYN_PTR_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-64WAVE-NEXT:    [[OUT2_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-64WAVE-NEXT:    [[SUM2_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-64WAVE-NEXT:    [[IN_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-64WAVE-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8, addrspace(5)
// SEGMENTED-64WAVE-NEXT:    [[SUM2_ADDR2:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-64WAVE-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-64WAVE-NEXT:    [[DOTADDR3:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-64WAVE-NEXT:    [[DOTADDR4:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-64WAVE-NEXT:    [[DOTADDR5:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-64WAVE-NEXT:    [[I:%.*]] = alloca i32, align 4, addrspace(5)
// SEGMENTED-64WAVE-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4, addrspace(5)
// SEGMENTED-64WAVE-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4, addrspace(5)
// SEGMENTED-64WAVE-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4, addrspace(5)
// SEGMENTED-64WAVE-NEXT:    [[SUM28:%.*]] = alloca i32, align 4, addrspace(5)
// SEGMENTED-64WAVE-NEXT:    [[DYN_PTR_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DYN_PTR_ADDR]] to ptr
// SEGMENTED-64WAVE-NEXT:    [[OUT2_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[OUT2_ADDR]] to ptr
// SEGMENTED-64WAVE-NEXT:    [[SUM2_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM2_ADDR]] to ptr
// SEGMENTED-64WAVE-NEXT:    [[IN_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[IN_ADDR]] to ptr
// SEGMENTED-64WAVE-NEXT:    [[VLA_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[VLA_ADDR]] to ptr
// SEGMENTED-64WAVE-NEXT:    [[SUM2_ADDR2_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM2_ADDR2]] to ptr
// SEGMENTED-64WAVE-NEXT:    [[DOTADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR]] to ptr
// SEGMENTED-64WAVE-NEXT:    [[DOTADDR3_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR3]] to ptr
// SEGMENTED-64WAVE-NEXT:    [[DOTADDR4_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR4]] to ptr
// SEGMENTED-64WAVE-NEXT:    [[DOTADDR5_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR5]] to ptr
// SEGMENTED-64WAVE-NEXT:    [[I_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[I]] to ptr
// SEGMENTED-64WAVE-NEXT:    [[DOTOMP_LB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_LB]] to ptr
// SEGMENTED-64WAVE-NEXT:    [[DOTOMP_UB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_UB]] to ptr
// SEGMENTED-64WAVE-NEXT:    [[DOTOMP_IV_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_IV]] to ptr
// SEGMENTED-64WAVE-NEXT:    [[SUM28_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM28]] to ptr
// SEGMENTED-64WAVE-NEXT:    store ptr [[DYN_PTR]], ptr [[DYN_PTR_ADDR_ASCAST]], align 8
// SEGMENTED-64WAVE-NEXT:    store ptr [[OUT2]], ptr [[OUT2_ADDR_ASCAST]], align 8
// SEGMENTED-64WAVE-NEXT:    store ptr [[SUM2]], ptr [[SUM2_ADDR_ASCAST]], align 8
// SEGMENTED-64WAVE-NEXT:    store ptr [[IN]], ptr [[IN_ADDR_ASCAST]], align 8
// SEGMENTED-64WAVE-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR_ASCAST]], align 8
// SEGMENTED-64WAVE-NEXT:    store ptr [[SUM21]], ptr [[SUM2_ADDR2_ASCAST]], align 8
// SEGMENTED-64WAVE-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR_ASCAST]], align 8
// SEGMENTED-64WAVE-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR3_ASCAST]], align 8
// SEGMENTED-64WAVE-NEXT:    store ptr [[TMP2]], ptr [[DOTADDR4_ASCAST]], align 8
// SEGMENTED-64WAVE-NEXT:    store ptr [[TMP3]], ptr [[DOTADDR5_ASCAST]], align 8
// SEGMENTED-64WAVE-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[OUT2_ADDR_ASCAST]], align 8
// SEGMENTED-64WAVE-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[SUM2_ADDR_ASCAST]], align 8
// SEGMENTED-64WAVE-NEXT:    [[TMP6:%.*]] = load ptr, ptr [[IN_ADDR_ASCAST]], align 8
// SEGMENTED-64WAVE-NEXT:    [[TMP7:%.*]] = load i64, ptr [[VLA_ADDR_ASCAST]], align 8
// SEGMENTED-64WAVE-NEXT:    [[TMP8:%.*]] = load ptr, ptr [[SUM2_ADDR2_ASCAST]], align 8
// SEGMENTED-64WAVE-NEXT:    call void @__kmpc_specialized_kernel_init()
// SEGMENTED-64WAVE-NEXT:    [[TMP9:%.*]] = alloca i32, align 4, addrspace(5)
// SEGMENTED-64WAVE-NEXT:    store i32 0, ptr addrspace(5) [[TMP9]], align 4
// SEGMENTED-64WAVE-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// SEGMENTED-64WAVE-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// SEGMENTED-64WAVE-NEXT:    store i32 0, ptr [[DOTOMP_LB_ASCAST]], align 4
// SEGMENTED-64WAVE-NEXT:    store i32 63999, ptr [[DOTOMP_UB_ASCAST]], align 4
// SEGMENTED-64WAVE-NEXT:    [[TMP10:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// SEGMENTED-64WAVE-NEXT:    store i32 [[TMP10]], ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-64WAVE-NEXT:    [[TMP11:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// SEGMENTED-64WAVE-NEXT:    [[NVPTX_NUM_THREADS:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// SEGMENTED-64WAVE-NEXT:    [[GPU_BLOCK_ID:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// SEGMENTED-64WAVE-NEXT:    [[TMP12:%.*]] = mul i32 [[GPU_BLOCK_ID]], [[NVPTX_NUM_THREADS]]
// SEGMENTED-64WAVE-NEXT:    [[TMP13:%.*]] = add i32 [[TMP12]], [[TMP11]]
// SEGMENTED-64WAVE-NEXT:    [[TMP14:%.*]] = mul i32 [[TMP13]], 1
// SEGMENTED-64WAVE-NEXT:    [[TMP15:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-64WAVE-NEXT:    [[TMP16:%.*]] = add i32 [[TMP14]], [[TMP15]]
// SEGMENTED-64WAVE-NEXT:    [[TMP17:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// SEGMENTED-64WAVE-NEXT:    [[TMP18:%.*]] = zext i32 [[TMP16]] to i64
// SEGMENTED-64WAVE-NEXT:    store i32 [[TMP16]], ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-64WAVE-NEXT:    [[GLOBAL_UPPER_BOUND:%.*]] = load i32, ptr [[DOTOMP_UB_ASCAST]], align 4
// SEGMENTED-64WAVE-NEXT:    [[TMP19:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// SEGMENTED-64WAVE-NEXT:    [[TMP20:%.*]] = sub i32 [[GLOBAL_UPPER_BOUND]], [[TMP19]]
// SEGMENTED-64WAVE-NEXT:    [[TMP21:%.*]] = add i32 [[TMP20]], 1
// SEGMENTED-64WAVE-NEXT:    [[TMP22:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// SEGMENTED-64WAVE-NEXT:    [[NVPTX_NUM_THREADS6:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// SEGMENTED-64WAVE-NEXT:    [[GPU_BLOCK_ID7:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// SEGMENTED-64WAVE-NEXT:    [[TMP23:%.*]] = mul i32 [[GPU_BLOCK_ID7]], [[NVPTX_NUM_THREADS6]]
// SEGMENTED-64WAVE-NEXT:    [[TMP24:%.*]] = add i32 [[TMP23]], [[TMP22]]
// SEGMENTED-64WAVE-NEXT:    [[TMP25:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// SEGMENTED-64WAVE-NEXT:    [[TMP26:%.*]] = mul i32 [[NVPTX_NUM_THREADS6]], [[TMP25]]
// SEGMENTED-64WAVE-NEXT:    [[TMP27:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-64WAVE-NEXT:    [[TMP28:%.*]] = icmp ult i32 [[TMP27]], [[TMP26]]
// SEGMENTED-64WAVE-NEXT:    br i1 [[TMP28]], label [[OMP_KERNEL_BODY:%.*]], label [[OMP_KERNEL_DONE:%.*]]
// SEGMENTED-64WAVE:       omp.kernel.body:
// SEGMENTED-64WAVE-NEXT:    [[TMP29:%.*]] = udiv i32 [[TMP21]], [[TMP26]]
// SEGMENTED-64WAVE-NEXT:    [[PADDED_SEGMENT_SIZE:%.*]] = add i32 [[TMP29]], 1
// SEGMENTED-64WAVE-NEXT:    [[TMP30:%.*]] = mul i32 [[PADDED_SEGMENT_SIZE]], [[TMP24]]
// SEGMENTED-64WAVE-NEXT:    store i32 [[TMP30]], ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-64WAVE-NEXT:    [[TMP31:%.*]] = add i32 [[TMP24]], 1
// SEGMENTED-64WAVE-NEXT:    [[TMP32:%.*]] = mul i32 [[PADDED_SEGMENT_SIZE]], [[TMP31]]
// SEGMENTED-64WAVE-NEXT:    [[TMP33:%.*]] = load ptr, ptr [[DOTADDR5_ASCAST]], align 8
// SEGMENTED-64WAVE-NEXT:    br label [[FOR_COND:%.*]]
// SEGMENTED-64WAVE:       for.cond:
// SEGMENTED-64WAVE-NEXT:    [[TMP34:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-64WAVE-NEXT:    [[TMP35:%.*]] = icmp ult i32 [[TMP34]], [[TMP32]]
// SEGMENTED-64WAVE-NEXT:    [[TMP36:%.*]] = icmp ule i32 [[TMP34]], [[GLOBAL_UPPER_BOUND]]
// SEGMENTED-64WAVE-NEXT:    [[TMP37:%.*]] = and i1 [[TMP36]], [[TMP35]]
// SEGMENTED-64WAVE-NEXT:    br i1 [[TMP37]], label [[FOR_BODY:%.*]], label [[FOR_END:%.*]]
// SEGMENTED-64WAVE:       for.body:
// SEGMENTED-64WAVE-NEXT:    [[TMP38:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-64WAVE-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP38]], 1
// SEGMENTED-64WAVE-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// SEGMENTED-64WAVE-NEXT:    store i32 [[ADD]], ptr [[I_ASCAST]], align 4
// SEGMENTED-64WAVE-NEXT:    store i32 0, ptr [[SUM28_ASCAST]], align 4
// SEGMENTED-64WAVE-NEXT:    br label [[OMP_INSCAN_DISPATCH:%.*]]
// SEGMENTED-64WAVE:       omp.before.scan.bb:
// SEGMENTED-64WAVE-NEXT:    [[TMP39:%.*]] = load i32, ptr [[TMP5]], align 4
// SEGMENTED-64WAVE-NEXT:    [[TMP40:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// SEGMENTED-64WAVE-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP40]] to i64
// SEGMENTED-64WAVE-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [64000 x i32], ptr [[TMP4]], i64 0, i64 [[IDXPROM]]
// SEGMENTED-64WAVE-NEXT:    store i32 [[TMP39]], ptr [[ARRAYIDX]], align 4
// SEGMENTED-64WAVE-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// SEGMENTED-64WAVE:       omp.exit.inscan.bb:
// SEGMENTED-64WAVE-NEXT:    [[TMP41:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-64WAVE-NEXT:    [[TMP42:%.*]] = zext i32 [[TMP41]] to i64
// SEGMENTED-64WAVE-NEXT:    br label [[OMP_BODY_CONTINUE]]
// SEGMENTED-64WAVE:       omp.inscan.dispatch:
// SEGMENTED-64WAVE-NEXT:    br label [[OMP_AFTER_SCAN_BB:%.*]]
// SEGMENTED-64WAVE:       omp.after.scan.bb:
// SEGMENTED-64WAVE-NEXT:    [[TMP43:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// SEGMENTED-64WAVE-NEXT:    [[IDXPROM9:%.*]] = sext i32 [[TMP43]] to i64
// SEGMENTED-64WAVE-NEXT:    [[ARRAYIDX10:%.*]] = getelementptr inbounds [64000 x i32], ptr [[TMP6]], i64 0, i64 [[IDXPROM9]]
// SEGMENTED-64WAVE-NEXT:    [[TMP44:%.*]] = load i32, ptr [[ARRAYIDX10]], align 4
// SEGMENTED-64WAVE-NEXT:    [[TMP45:%.*]] = load i32, ptr addrspace(5) [[TMP9]], align 4
// SEGMENTED-64WAVE-NEXT:    [[TMP46:%.*]] = add i32 [[TMP45]], [[TMP44]]
// SEGMENTED-64WAVE-NEXT:    store i32 [[TMP46]], ptr addrspace(5) [[TMP9]], align 4
// SEGMENTED-64WAVE-NEXT:    br label [[OMP_EXIT_INSCAN_BB:%.*]]
// SEGMENTED-64WAVE:       omp.body.continue:
// SEGMENTED-64WAVE-NEXT:    br label [[FOR_INC:%.*]]
// SEGMENTED-64WAVE:       for.inc:
// SEGMENTED-64WAVE-NEXT:    [[TMP47:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-64WAVE-NEXT:    [[TMP48:%.*]] = getelementptr i32, ptr [[TMP33]], i32 [[TMP47]]
// SEGMENTED-64WAVE-NEXT:    [[TMP49:%.*]] = load i32, ptr addrspace(5) [[TMP9]], align 4
// SEGMENTED-64WAVE-NEXT:    store i32 [[TMP49]], ptr [[TMP48]], align 4
// SEGMENTED-64WAVE-NEXT:    [[TMP50:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-64WAVE-NEXT:    [[TMP51:%.*]] = add i32 1, [[TMP50]]
// SEGMENTED-64WAVE-NEXT:    store i32 [[TMP51]], ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-64WAVE-NEXT:    br label [[FOR_COND]], !llvm.loop [[LOOP16:![0-9]+]]
// SEGMENTED-64WAVE:       for.end:
// SEGMENTED-64WAVE-NEXT:    [[TMP52:%.*]] = load ptr, ptr [[DOTADDR_ASCAST]], align 8
// SEGMENTED-64WAVE-NEXT:    [[TMP53:%.*]] = load ptr, ptr [[DOTADDR3_ASCAST]], align 8
// SEGMENTED-64WAVE-NEXT:    [[TMP54:%.*]] = load ptr, ptr [[DOTADDR4_ASCAST]], align 8
// SEGMENTED-64WAVE-NEXT:    [[TMP55:%.*]] = load i32, ptr addrspace(5) [[TMP9]], align 4
// SEGMENTED-64WAVE-NEXT:    call void @__kmpc_xteams_i_4x64(i32 [[TMP55]], ptr [[TMP54]], ptr [[TMP5]], ptr [[TMP52]], ptr [[TMP53]], ptr @__kmpc_rfun_sum_i, ptr @__kmpc_rfun_sum_lds_i, i32 0, i64 [[TMP18]], i32 [[TMP17]])
// SEGMENTED-64WAVE-NEXT:    br label [[OMP_KERNEL_DONE]]
// SEGMENTED-64WAVE:       omp.kernel.done:
// SEGMENTED-64WAVE-NEXT:    ret void
//
//
// SEGMENTED-64WAVE-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l57_1
// SEGMENTED-64WAVE-SAME: (ptr noalias noundef [[DYN_PTR:%.*]], ptr noundef nonnull align 4 dereferenceable(256000) [[OUT2:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM2:%.*]], ptr noundef nonnull align 4 dereferenceable(256000) [[IN:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM21:%.*]], ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]], ptr noundef [[TMP2:%.*]], ptr noundef [[TMP3:%.*]]) #[[ATTR0]] {
// SEGMENTED-64WAVE-NEXT:  entry:
// SEGMENTED-64WAVE-NEXT:    [[DYN_PTR_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-64WAVE-NEXT:    [[OUT2_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-64WAVE-NEXT:    [[SUM2_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-64WAVE-NEXT:    [[IN_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-64WAVE-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8, addrspace(5)
// SEGMENTED-64WAVE-NEXT:    [[SUM2_ADDR2:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-64WAVE-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-64WAVE-NEXT:    [[DOTADDR3:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-64WAVE-NEXT:    [[DOTADDR4:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-64WAVE-NEXT:    [[DOTADDR5:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-64WAVE-NEXT:    [[I:%.*]] = alloca i32, align 4, addrspace(5)
// SEGMENTED-64WAVE-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4, addrspace(5)
// SEGMENTED-64WAVE-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4, addrspace(5)
// SEGMENTED-64WAVE-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4, addrspace(5)
// SEGMENTED-64WAVE-NEXT:    [[SUM28:%.*]] = alloca i32, align 4, addrspace(5)
// SEGMENTED-64WAVE-NEXT:    [[DYN_PTR_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DYN_PTR_ADDR]] to ptr
// SEGMENTED-64WAVE-NEXT:    [[OUT2_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[OUT2_ADDR]] to ptr
// SEGMENTED-64WAVE-NEXT:    [[SUM2_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM2_ADDR]] to ptr
// SEGMENTED-64WAVE-NEXT:    [[IN_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[IN_ADDR]] to ptr
// SEGMENTED-64WAVE-NEXT:    [[VLA_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[VLA_ADDR]] to ptr
// SEGMENTED-64WAVE-NEXT:    [[SUM2_ADDR2_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM2_ADDR2]] to ptr
// SEGMENTED-64WAVE-NEXT:    [[DOTADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR]] to ptr
// SEGMENTED-64WAVE-NEXT:    [[DOTADDR3_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR3]] to ptr
// SEGMENTED-64WAVE-NEXT:    [[DOTADDR4_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR4]] to ptr
// SEGMENTED-64WAVE-NEXT:    [[DOTADDR5_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR5]] to ptr
// SEGMENTED-64WAVE-NEXT:    [[I_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[I]] to ptr
// SEGMENTED-64WAVE-NEXT:    [[DOTOMP_LB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_LB]] to ptr
// SEGMENTED-64WAVE-NEXT:    [[DOTOMP_UB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_UB]] to ptr
// SEGMENTED-64WAVE-NEXT:    [[DOTOMP_IV_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_IV]] to ptr
// SEGMENTED-64WAVE-NEXT:    [[SUM28_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM28]] to ptr
// SEGMENTED-64WAVE-NEXT:    store ptr [[DYN_PTR]], ptr [[DYN_PTR_ADDR_ASCAST]], align 8
// SEGMENTED-64WAVE-NEXT:    store ptr [[OUT2]], ptr [[OUT2_ADDR_ASCAST]], align 8
// SEGMENTED-64WAVE-NEXT:    store ptr [[SUM2]], ptr [[SUM2_ADDR_ASCAST]], align 8
// SEGMENTED-64WAVE-NEXT:    store ptr [[IN]], ptr [[IN_ADDR_ASCAST]], align 8
// SEGMENTED-64WAVE-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR_ASCAST]], align 8
// SEGMENTED-64WAVE-NEXT:    store ptr [[SUM21]], ptr [[SUM2_ADDR2_ASCAST]], align 8
// SEGMENTED-64WAVE-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR_ASCAST]], align 8
// SEGMENTED-64WAVE-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR3_ASCAST]], align 8
// SEGMENTED-64WAVE-NEXT:    store ptr [[TMP2]], ptr [[DOTADDR4_ASCAST]], align 8
// SEGMENTED-64WAVE-NEXT:    store ptr [[TMP3]], ptr [[DOTADDR5_ASCAST]], align 8
// SEGMENTED-64WAVE-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[OUT2_ADDR_ASCAST]], align 8
// SEGMENTED-64WAVE-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[SUM2_ADDR_ASCAST]], align 8
// SEGMENTED-64WAVE-NEXT:    [[TMP6:%.*]] = load ptr, ptr [[IN_ADDR_ASCAST]], align 8
// SEGMENTED-64WAVE-NEXT:    [[TMP7:%.*]] = load i64, ptr [[VLA_ADDR_ASCAST]], align 8
// SEGMENTED-64WAVE-NEXT:    [[TMP8:%.*]] = load ptr, ptr [[SUM2_ADDR2_ASCAST]], align 8
// SEGMENTED-64WAVE-NEXT:    call void @__kmpc_specialized_kernel_init()
// SEGMENTED-64WAVE-NEXT:    [[TMP9:%.*]] = alloca i32, align 4, addrspace(5)
// SEGMENTED-64WAVE-NEXT:    store i32 0, ptr addrspace(5) [[TMP9]], align 4
// SEGMENTED-64WAVE-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// SEGMENTED-64WAVE-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// SEGMENTED-64WAVE-NEXT:    store i32 0, ptr [[DOTOMP_LB_ASCAST]], align 4
// SEGMENTED-64WAVE-NEXT:    store i32 63999, ptr [[DOTOMP_UB_ASCAST]], align 4
// SEGMENTED-64WAVE-NEXT:    [[TMP10:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// SEGMENTED-64WAVE-NEXT:    store i32 [[TMP10]], ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-64WAVE-NEXT:    [[TMP11:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// SEGMENTED-64WAVE-NEXT:    [[NVPTX_NUM_THREADS:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// SEGMENTED-64WAVE-NEXT:    [[GPU_BLOCK_ID:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// SEGMENTED-64WAVE-NEXT:    [[TMP12:%.*]] = mul i32 [[GPU_BLOCK_ID]], [[NVPTX_NUM_THREADS]]
// SEGMENTED-64WAVE-NEXT:    [[TMP13:%.*]] = add i32 [[TMP12]], [[TMP11]]
// SEGMENTED-64WAVE-NEXT:    [[TMP14:%.*]] = mul i32 [[TMP13]], 1
// SEGMENTED-64WAVE-NEXT:    [[TMP15:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-64WAVE-NEXT:    [[TMP16:%.*]] = add i32 [[TMP14]], [[TMP15]]
// SEGMENTED-64WAVE-NEXT:    [[TMP17:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// SEGMENTED-64WAVE-NEXT:    [[TMP18:%.*]] = zext i32 [[TMP16]] to i64
// SEGMENTED-64WAVE-NEXT:    store i32 [[TMP16]], ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-64WAVE-NEXT:    [[GLOBAL_UPPER_BOUND:%.*]] = load i32, ptr [[DOTOMP_UB_ASCAST]], align 4
// SEGMENTED-64WAVE-NEXT:    [[TMP19:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// SEGMENTED-64WAVE-NEXT:    [[TMP20:%.*]] = sub i32 [[GLOBAL_UPPER_BOUND]], [[TMP19]]
// SEGMENTED-64WAVE-NEXT:    [[TMP21:%.*]] = add i32 [[TMP20]], 1
// SEGMENTED-64WAVE-NEXT:    [[TMP22:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// SEGMENTED-64WAVE-NEXT:    [[NVPTX_NUM_THREADS6:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// SEGMENTED-64WAVE-NEXT:    [[GPU_BLOCK_ID7:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// SEGMENTED-64WAVE-NEXT:    [[TMP23:%.*]] = mul i32 [[GPU_BLOCK_ID7]], [[NVPTX_NUM_THREADS6]]
// SEGMENTED-64WAVE-NEXT:    [[TMP24:%.*]] = add i32 [[TMP23]], [[TMP22]]
// SEGMENTED-64WAVE-NEXT:    [[TMP25:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// SEGMENTED-64WAVE-NEXT:    [[TMP26:%.*]] = mul i32 [[NVPTX_NUM_THREADS6]], [[TMP25]]
// SEGMENTED-64WAVE-NEXT:    [[TMP27:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-64WAVE-NEXT:    [[TMP28:%.*]] = icmp ult i32 [[TMP27]], [[TMP26]]
// SEGMENTED-64WAVE-NEXT:    br i1 [[TMP28]], label [[OMP_KERNEL_BODY:%.*]], label [[OMP_KERNEL_DONE:%.*]]
// SEGMENTED-64WAVE:       omp.kernel.body:
// SEGMENTED-64WAVE-NEXT:    [[TMP29:%.*]] = udiv i32 [[TMP21]], [[TMP26]]
// SEGMENTED-64WAVE-NEXT:    [[PADDED_SEGMENT_SIZE:%.*]] = add i32 [[TMP29]], 1
// SEGMENTED-64WAVE-NEXT:    [[TMP30:%.*]] = load ptr, ptr [[DOTADDR_ASCAST]], align 8
// SEGMENTED-64WAVE-NEXT:    [[TMP31:%.*]] = load ptr, ptr [[DOTADDR4_ASCAST]], align 8
// SEGMENTED-64WAVE-NEXT:    [[TMP32:%.*]] = load ptr, ptr [[DOTADDR5_ASCAST]], align 8
// SEGMENTED-64WAVE-NEXT:    [[TMP33:%.*]] = load i32, ptr addrspace(5) [[TMP9]], align 4
// SEGMENTED-64WAVE-NEXT:    call void @__kmpc_xteams_phase2_i_4x64(ptr [[TMP31]], i32 [[PADDED_SEGMENT_SIZE]], ptr [[TMP30]], ptr [[TMP32]], ptr @__kmpc_rfun_sum_i, i32 0, i64 [[TMP18]], i32 0)
// SEGMENTED-64WAVE-NEXT:    [[TMP34:%.*]] = mul i32 [[PADDED_SEGMENT_SIZE]], [[TMP24]]
// SEGMENTED-64WAVE-NEXT:    store i32 [[TMP34]], ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-64WAVE-NEXT:    [[TMP35:%.*]] = add i32 [[TMP24]], 1
// SEGMENTED-64WAVE-NEXT:    [[TMP36:%.*]] = mul i32 [[PADDED_SEGMENT_SIZE]], [[TMP35]]
// SEGMENTED-64WAVE-NEXT:    [[TMP37:%.*]] = load ptr, ptr [[DOTADDR5_ASCAST]], align 8
// SEGMENTED-64WAVE-NEXT:    br label [[FOR_COND:%.*]]
// SEGMENTED-64WAVE:       for.cond:
// SEGMENTED-64WAVE-NEXT:    [[TMP38:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-64WAVE-NEXT:    [[TMP39:%.*]] = icmp ult i32 [[TMP38]], [[TMP36]]
// SEGMENTED-64WAVE-NEXT:    [[TMP40:%.*]] = icmp ule i32 [[TMP38]], [[GLOBAL_UPPER_BOUND]]
// SEGMENTED-64WAVE-NEXT:    [[TMP41:%.*]] = and i1 [[TMP40]], [[TMP39]]
// SEGMENTED-64WAVE-NEXT:    br i1 [[TMP41]], label [[FOR_BODY:%.*]], label [[FOR_END:%.*]]
// SEGMENTED-64WAVE:       for.body:
// SEGMENTED-64WAVE-NEXT:    [[TMP42:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-64WAVE-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP42]], 1
// SEGMENTED-64WAVE-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// SEGMENTED-64WAVE-NEXT:    store i32 [[ADD]], ptr [[I_ASCAST]], align 4
// SEGMENTED-64WAVE-NEXT:    [[TMP43:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-64WAVE-NEXT:    [[TMP44:%.*]] = getelementptr i32, ptr [[TMP37]], i32 [[TMP43]]
// SEGMENTED-64WAVE-NEXT:    [[TMP45:%.*]] = load i32, ptr [[TMP44]], align 4
// SEGMENTED-64WAVE-NEXT:    store i32 [[TMP45]], ptr addrspace(5) [[TMP9]], align 4
// SEGMENTED-64WAVE-NEXT:    store i32 0, ptr [[SUM28_ASCAST]], align 4
// SEGMENTED-64WAVE-NEXT:    br label [[OMP_INSCAN_DISPATCH:%.*]]
// SEGMENTED-64WAVE:       omp.before.scan.bb:
// SEGMENTED-64WAVE-NEXT:    [[TMP46:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// SEGMENTED-64WAVE-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP46]] to i64
// SEGMENTED-64WAVE-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [64000 x i32], ptr [[TMP4]], i64 0, i64 [[IDXPROM]]
// SEGMENTED-64WAVE-NEXT:    [[TMP47:%.*]] = load i32, ptr addrspace(5) [[TMP9]], align 4
// SEGMENTED-64WAVE-NEXT:    store i32 [[TMP47]], ptr [[ARRAYIDX]], align 4
// SEGMENTED-64WAVE-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// SEGMENTED-64WAVE:       omp.exit.inscan.bb:
// SEGMENTED-64WAVE-NEXT:    br label [[OMP_BODY_CONTINUE]]
// SEGMENTED-64WAVE:       omp.inscan.dispatch:
// SEGMENTED-64WAVE-NEXT:    [[TMP48:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-64WAVE-NEXT:    [[TMP49:%.*]] = zext i32 [[TMP48]] to i64
// SEGMENTED-64WAVE-NEXT:    [[TMP50:%.*]] = icmp eq i64 [[TMP49]], 0
// SEGMENTED-64WAVE-NEXT:    br i1 [[TMP50]], label [[OMP_EXCLUSIVE_COPY_EXIT:%.*]], label [[OMP_EXCLUSIVE_DEC:%.*]]
// SEGMENTED-64WAVE:       omp.exclusive.dec:
// SEGMENTED-64WAVE-NEXT:    [[TMP51:%.*]] = sub nuw i64 [[TMP49]], 1
// SEGMENTED-64WAVE-NEXT:    [[ARRAYIDX9:%.*]] = getelementptr inbounds nuw i32, ptr [[TMP8]], i64 [[TMP51]]
// SEGMENTED-64WAVE-NEXT:    [[TMP52:%.*]] = load i32, ptr addrspace(5) [[TMP9]], align 4
// SEGMENTED-64WAVE-NEXT:    store i32 [[TMP52]], ptr [[TMP5]], align 4
// SEGMENTED-64WAVE-NEXT:    br label [[OMP_EXCLUSIVE_COPY_EXIT]]
// SEGMENTED-64WAVE:       omp.exclusive.copy.exit:
// SEGMENTED-64WAVE-NEXT:    br label [[OMP_BEFORE_SCAN_BB:%.*]]
// SEGMENTED-64WAVE:       omp.after.scan.bb:
// SEGMENTED-64WAVE-NEXT:    [[TMP53:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// SEGMENTED-64WAVE-NEXT:    [[IDXPROM10:%.*]] = sext i32 [[TMP53]] to i64
// SEGMENTED-64WAVE-NEXT:    [[ARRAYIDX11:%.*]] = getelementptr inbounds [64000 x i32], ptr [[TMP6]], i64 0, i64 [[IDXPROM10]]
// SEGMENTED-64WAVE-NEXT:    [[TMP54:%.*]] = load i32, ptr [[ARRAYIDX11]], align 4
// SEGMENTED-64WAVE-NEXT:    [[TMP55:%.*]] = load i32, ptr addrspace(5) [[TMP9]], align 4
// SEGMENTED-64WAVE-NEXT:    [[TMP56:%.*]] = add i32 [[TMP55]], [[TMP54]]
// SEGMENTED-64WAVE-NEXT:    store i32 [[TMP56]], ptr addrspace(5) [[TMP9]], align 4
// SEGMENTED-64WAVE-NEXT:    br label [[OMP_EXIT_INSCAN_BB:%.*]]
// SEGMENTED-64WAVE:       omp.body.continue:
// SEGMENTED-64WAVE-NEXT:    br label [[FOR_INC:%.*]]
// SEGMENTED-64WAVE:       for.inc:
// SEGMENTED-64WAVE-NEXT:    [[TMP57:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-64WAVE-NEXT:    [[TMP58:%.*]] = getelementptr i32, ptr [[TMP37]], i32 [[TMP57]]
// SEGMENTED-64WAVE-NEXT:    [[TMP59:%.*]] = load i32, ptr addrspace(5) [[TMP9]], align 4
// SEGMENTED-64WAVE-NEXT:    store i32 [[TMP59]], ptr [[TMP58]], align 4
// SEGMENTED-64WAVE-NEXT:    [[TMP60:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-64WAVE-NEXT:    [[TMP61:%.*]] = add i32 1, [[TMP60]]
// SEGMENTED-64WAVE-NEXT:    store i32 [[TMP61]], ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-64WAVE-NEXT:    br label [[FOR_COND]], !llvm.loop [[LOOP17:![0-9]+]]
// SEGMENTED-64WAVE:       for.end:
// SEGMENTED-64WAVE-NEXT:    br label [[OMP_KERNEL_DONE]]
// SEGMENTED-64WAVE:       omp.kernel.done:
// SEGMENTED-64WAVE-NEXT:    ret void
//
//
// SEGMENTED-64WAVE-512WGSize-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l47
// SEGMENTED-64WAVE-512WGSize-SAME: (ptr noalias noundef [[DYN_PTR:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM1:%.*]], ptr noundef nonnull align 4 dereferenceable(512000) [[IN:%.*]], ptr noundef nonnull align 4 dereferenceable(512000) [[OUT1:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM11:%.*]], ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]], ptr noundef [[TMP2:%.*]], ptr noundef [[TMP3:%.*]]) #[[ATTR0:[0-9]+]] {
// SEGMENTED-64WAVE-512WGSize-NEXT:  entry:
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[DYN_PTR_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[SUM1_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[IN_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[OUT1_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8, addrspace(5)
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[SUM1_ADDR2:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[DOTADDR3:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[DOTADDR4:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[DOTADDR5:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[I:%.*]] = alloca i32, align 4, addrspace(5)
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4, addrspace(5)
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4, addrspace(5)
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4, addrspace(5)
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[SUM18:%.*]] = alloca i32, align 4, addrspace(5)
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[DYN_PTR_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DYN_PTR_ADDR]] to ptr
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[SUM1_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM1_ADDR]] to ptr
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[IN_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[IN_ADDR]] to ptr
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[OUT1_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[OUT1_ADDR]] to ptr
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[VLA_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[VLA_ADDR]] to ptr
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[SUM1_ADDR2_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM1_ADDR2]] to ptr
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[DOTADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR]] to ptr
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[DOTADDR3_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR3]] to ptr
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[DOTADDR4_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR4]] to ptr
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[DOTADDR5_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR5]] to ptr
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[I_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[I]] to ptr
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[DOTOMP_LB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_LB]] to ptr
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[DOTOMP_UB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_UB]] to ptr
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[DOTOMP_IV_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_IV]] to ptr
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[SUM18_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM18]] to ptr
// SEGMENTED-64WAVE-512WGSize-NEXT:    store ptr [[DYN_PTR]], ptr [[DYN_PTR_ADDR_ASCAST]], align 8
// SEGMENTED-64WAVE-512WGSize-NEXT:    store ptr [[SUM1]], ptr [[SUM1_ADDR_ASCAST]], align 8
// SEGMENTED-64WAVE-512WGSize-NEXT:    store ptr [[IN]], ptr [[IN_ADDR_ASCAST]], align 8
// SEGMENTED-64WAVE-512WGSize-NEXT:    store ptr [[OUT1]], ptr [[OUT1_ADDR_ASCAST]], align 8
// SEGMENTED-64WAVE-512WGSize-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR_ASCAST]], align 8
// SEGMENTED-64WAVE-512WGSize-NEXT:    store ptr [[SUM11]], ptr [[SUM1_ADDR2_ASCAST]], align 8
// SEGMENTED-64WAVE-512WGSize-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR_ASCAST]], align 8
// SEGMENTED-64WAVE-512WGSize-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR3_ASCAST]], align 8
// SEGMENTED-64WAVE-512WGSize-NEXT:    store ptr [[TMP2]], ptr [[DOTADDR4_ASCAST]], align 8
// SEGMENTED-64WAVE-512WGSize-NEXT:    store ptr [[TMP3]], ptr [[DOTADDR5_ASCAST]], align 8
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[SUM1_ADDR_ASCAST]], align 8
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[IN_ADDR_ASCAST]], align 8
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP6:%.*]] = load ptr, ptr [[OUT1_ADDR_ASCAST]], align 8
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP7:%.*]] = load i64, ptr [[VLA_ADDR_ASCAST]], align 8
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP8:%.*]] = load ptr, ptr [[SUM1_ADDR2_ASCAST]], align 8
// SEGMENTED-64WAVE-512WGSize-NEXT:    call void @__kmpc_specialized_kernel_init()
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP9:%.*]] = alloca i32, align 4, addrspace(5)
// SEGMENTED-64WAVE-512WGSize-NEXT:    store i32 0, ptr addrspace(5) [[TMP9]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    store i32 0, ptr [[DOTOMP_LB_ASCAST]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    store i32 127999, ptr [[DOTOMP_UB_ASCAST]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP10:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    store i32 [[TMP10]], ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP11:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[NVPTX_NUM_THREADS:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[GPU_BLOCK_ID:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP12:%.*]] = mul i32 [[GPU_BLOCK_ID]], [[NVPTX_NUM_THREADS]]
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP13:%.*]] = add i32 [[TMP12]], [[TMP11]]
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP14:%.*]] = mul i32 [[TMP13]], 1
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP15:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP16:%.*]] = add i32 [[TMP14]], [[TMP15]]
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP17:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP18:%.*]] = zext i32 [[TMP16]] to i64
// SEGMENTED-64WAVE-512WGSize-NEXT:    store i32 [[TMP16]], ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[GLOBAL_UPPER_BOUND:%.*]] = load i32, ptr [[DOTOMP_UB_ASCAST]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP19:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP20:%.*]] = sub i32 [[GLOBAL_UPPER_BOUND]], [[TMP19]]
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP21:%.*]] = add i32 [[TMP20]], 1
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP22:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[NVPTX_NUM_THREADS6:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[GPU_BLOCK_ID7:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP23:%.*]] = mul i32 [[GPU_BLOCK_ID7]], [[NVPTX_NUM_THREADS6]]
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP24:%.*]] = add i32 [[TMP23]], [[TMP22]]
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP25:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP26:%.*]] = mul i32 [[NVPTX_NUM_THREADS6]], [[TMP25]]
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP27:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP28:%.*]] = icmp ult i32 [[TMP27]], [[TMP26]]
// SEGMENTED-64WAVE-512WGSize-NEXT:    br i1 [[TMP28]], label [[OMP_KERNEL_BODY:%.*]], label [[OMP_KERNEL_DONE:%.*]]
// SEGMENTED-64WAVE-512WGSize:       omp.kernel.body:
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP29:%.*]] = udiv i32 [[TMP21]], [[TMP26]]
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[PADDED_SEGMENT_SIZE:%.*]] = add i32 [[TMP29]], 1
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP30:%.*]] = mul i32 [[PADDED_SEGMENT_SIZE]], [[TMP24]]
// SEGMENTED-64WAVE-512WGSize-NEXT:    store i32 [[TMP30]], ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP31:%.*]] = add i32 [[TMP24]], 1
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP32:%.*]] = mul i32 [[PADDED_SEGMENT_SIZE]], [[TMP31]]
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP33:%.*]] = load ptr, ptr [[DOTADDR5_ASCAST]], align 8
// SEGMENTED-64WAVE-512WGSize-NEXT:    br label [[FOR_COND:%.*]]
// SEGMENTED-64WAVE-512WGSize:       for.cond:
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP34:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP35:%.*]] = icmp ult i32 [[TMP34]], [[TMP32]]
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP36:%.*]] = icmp ule i32 [[TMP34]], [[GLOBAL_UPPER_BOUND]]
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP37:%.*]] = and i1 [[TMP36]], [[TMP35]]
// SEGMENTED-64WAVE-512WGSize-NEXT:    br i1 [[TMP37]], label [[FOR_BODY:%.*]], label [[FOR_END:%.*]]
// SEGMENTED-64WAVE-512WGSize:       for.body:
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP38:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP38]], 1
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// SEGMENTED-64WAVE-512WGSize-NEXT:    store i32 [[ADD]], ptr [[I_ASCAST]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    store i32 0, ptr [[SUM18_ASCAST]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    br label [[OMP_INSCAN_DISPATCH:%.*]]
// SEGMENTED-64WAVE-512WGSize:       omp.before.scan.bb:
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP39:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP39]] to i64
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [128000 x i32], ptr [[TMP5]], i64 0, i64 [[IDXPROM]]
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP40:%.*]] = load i32, ptr [[ARRAYIDX]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP41:%.*]] = load i32, ptr addrspace(5) [[TMP9]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP42:%.*]] = add i32 [[TMP41]], [[TMP40]]
// SEGMENTED-64WAVE-512WGSize-NEXT:    store i32 [[TMP42]], ptr addrspace(5) [[TMP9]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP43:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP44:%.*]] = zext i32 [[TMP43]] to i64
// SEGMENTED-64WAVE-512WGSize-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// SEGMENTED-64WAVE-512WGSize:       omp.exit.inscan.bb:
// SEGMENTED-64WAVE-512WGSize-NEXT:    br label [[OMP_BODY_CONTINUE]]
// SEGMENTED-64WAVE-512WGSize:       omp.inscan.dispatch:
// SEGMENTED-64WAVE-512WGSize-NEXT:    br label [[OMP_BEFORE_SCAN_BB:%.*]]
// SEGMENTED-64WAVE-512WGSize:       omp.after.scan.bb:
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP45:%.*]] = load i32, ptr [[TMP4]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP46:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[IDXPROM9:%.*]] = sext i32 [[TMP46]] to i64
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[ARRAYIDX10:%.*]] = getelementptr inbounds [128000 x i32], ptr [[TMP6]], i64 0, i64 [[IDXPROM9]]
// SEGMENTED-64WAVE-512WGSize-NEXT:    store i32 [[TMP45]], ptr [[ARRAYIDX10]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    br label [[OMP_EXIT_INSCAN_BB:%.*]]
// SEGMENTED-64WAVE-512WGSize:       omp.body.continue:
// SEGMENTED-64WAVE-512WGSize-NEXT:    br label [[FOR_INC:%.*]]
// SEGMENTED-64WAVE-512WGSize:       for.inc:
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP47:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP48:%.*]] = getelementptr i32, ptr [[TMP33]], i32 [[TMP47]]
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP49:%.*]] = load i32, ptr addrspace(5) [[TMP9]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    store i32 [[TMP49]], ptr [[TMP48]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP50:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP51:%.*]] = add i32 1, [[TMP50]]
// SEGMENTED-64WAVE-512WGSize-NEXT:    store i32 [[TMP51]], ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    br label [[FOR_COND]], !llvm.loop [[LOOP13:![0-9]+]]
// SEGMENTED-64WAVE-512WGSize:       for.end:
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP52:%.*]] = load ptr, ptr [[DOTADDR_ASCAST]], align 8
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP53:%.*]] = load ptr, ptr [[DOTADDR3_ASCAST]], align 8
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP54:%.*]] = load ptr, ptr [[DOTADDR4_ASCAST]], align 8
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP55:%.*]] = load i32, ptr addrspace(5) [[TMP9]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    call void @__kmpc_xteams_i_8x64(i32 [[TMP55]], ptr [[TMP54]], ptr [[TMP4]], ptr [[TMP52]], ptr [[TMP53]], ptr @__kmpc_rfun_sum_i, ptr @__kmpc_rfun_sum_lds_i, i32 0, i64 [[TMP18]], i32 [[TMP17]])
// SEGMENTED-64WAVE-512WGSize-NEXT:    br label [[OMP_KERNEL_DONE]]
// SEGMENTED-64WAVE-512WGSize:       omp.kernel.done:
// SEGMENTED-64WAVE-512WGSize-NEXT:    ret void
//
//
// SEGMENTED-64WAVE-512WGSize-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l47_1
// SEGMENTED-64WAVE-512WGSize-SAME: (ptr noalias noundef [[DYN_PTR:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM1:%.*]], ptr noundef nonnull align 4 dereferenceable(512000) [[IN:%.*]], ptr noundef nonnull align 4 dereferenceable(512000) [[OUT1:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM11:%.*]], ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]], ptr noundef [[TMP2:%.*]], ptr noundef [[TMP3:%.*]]) #[[ATTR0]] {
// SEGMENTED-64WAVE-512WGSize-NEXT:  entry:
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[DYN_PTR_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[SUM1_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[IN_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[OUT1_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8, addrspace(5)
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[SUM1_ADDR2:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[DOTADDR3:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[DOTADDR4:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[DOTADDR5:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[I:%.*]] = alloca i32, align 4, addrspace(5)
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4, addrspace(5)
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4, addrspace(5)
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4, addrspace(5)
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[SUM18:%.*]] = alloca i32, align 4, addrspace(5)
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[DYN_PTR_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DYN_PTR_ADDR]] to ptr
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[SUM1_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM1_ADDR]] to ptr
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[IN_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[IN_ADDR]] to ptr
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[OUT1_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[OUT1_ADDR]] to ptr
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[VLA_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[VLA_ADDR]] to ptr
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[SUM1_ADDR2_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM1_ADDR2]] to ptr
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[DOTADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR]] to ptr
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[DOTADDR3_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR3]] to ptr
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[DOTADDR4_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR4]] to ptr
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[DOTADDR5_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR5]] to ptr
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[I_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[I]] to ptr
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[DOTOMP_LB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_LB]] to ptr
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[DOTOMP_UB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_UB]] to ptr
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[DOTOMP_IV_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_IV]] to ptr
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[SUM18_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM18]] to ptr
// SEGMENTED-64WAVE-512WGSize-NEXT:    store ptr [[DYN_PTR]], ptr [[DYN_PTR_ADDR_ASCAST]], align 8
// SEGMENTED-64WAVE-512WGSize-NEXT:    store ptr [[SUM1]], ptr [[SUM1_ADDR_ASCAST]], align 8
// SEGMENTED-64WAVE-512WGSize-NEXT:    store ptr [[IN]], ptr [[IN_ADDR_ASCAST]], align 8
// SEGMENTED-64WAVE-512WGSize-NEXT:    store ptr [[OUT1]], ptr [[OUT1_ADDR_ASCAST]], align 8
// SEGMENTED-64WAVE-512WGSize-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR_ASCAST]], align 8
// SEGMENTED-64WAVE-512WGSize-NEXT:    store ptr [[SUM11]], ptr [[SUM1_ADDR2_ASCAST]], align 8
// SEGMENTED-64WAVE-512WGSize-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR_ASCAST]], align 8
// SEGMENTED-64WAVE-512WGSize-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR3_ASCAST]], align 8
// SEGMENTED-64WAVE-512WGSize-NEXT:    store ptr [[TMP2]], ptr [[DOTADDR4_ASCAST]], align 8
// SEGMENTED-64WAVE-512WGSize-NEXT:    store ptr [[TMP3]], ptr [[DOTADDR5_ASCAST]], align 8
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[SUM1_ADDR_ASCAST]], align 8
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[IN_ADDR_ASCAST]], align 8
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP6:%.*]] = load ptr, ptr [[OUT1_ADDR_ASCAST]], align 8
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP7:%.*]] = load i64, ptr [[VLA_ADDR_ASCAST]], align 8
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP8:%.*]] = load ptr, ptr [[SUM1_ADDR2_ASCAST]], align 8
// SEGMENTED-64WAVE-512WGSize-NEXT:    call void @__kmpc_specialized_kernel_init()
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP9:%.*]] = alloca i32, align 4, addrspace(5)
// SEGMENTED-64WAVE-512WGSize-NEXT:    store i32 0, ptr addrspace(5) [[TMP9]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    store i32 0, ptr [[DOTOMP_LB_ASCAST]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    store i32 127999, ptr [[DOTOMP_UB_ASCAST]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP10:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    store i32 [[TMP10]], ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP11:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[NVPTX_NUM_THREADS:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[GPU_BLOCK_ID:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP12:%.*]] = mul i32 [[GPU_BLOCK_ID]], [[NVPTX_NUM_THREADS]]
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP13:%.*]] = add i32 [[TMP12]], [[TMP11]]
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP14:%.*]] = mul i32 [[TMP13]], 1
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP15:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP16:%.*]] = add i32 [[TMP14]], [[TMP15]]
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP17:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP18:%.*]] = zext i32 [[TMP16]] to i64
// SEGMENTED-64WAVE-512WGSize-NEXT:    store i32 [[TMP16]], ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[GLOBAL_UPPER_BOUND:%.*]] = load i32, ptr [[DOTOMP_UB_ASCAST]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP19:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP20:%.*]] = sub i32 [[GLOBAL_UPPER_BOUND]], [[TMP19]]
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP21:%.*]] = add i32 [[TMP20]], 1
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP22:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[NVPTX_NUM_THREADS6:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[GPU_BLOCK_ID7:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP23:%.*]] = mul i32 [[GPU_BLOCK_ID7]], [[NVPTX_NUM_THREADS6]]
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP24:%.*]] = add i32 [[TMP23]], [[TMP22]]
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP25:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP26:%.*]] = mul i32 [[NVPTX_NUM_THREADS6]], [[TMP25]]
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP27:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP28:%.*]] = icmp ult i32 [[TMP27]], [[TMP26]]
// SEGMENTED-64WAVE-512WGSize-NEXT:    br i1 [[TMP28]], label [[OMP_KERNEL_BODY:%.*]], label [[OMP_KERNEL_DONE:%.*]]
// SEGMENTED-64WAVE-512WGSize:       omp.kernel.body:
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP29:%.*]] = udiv i32 [[TMP21]], [[TMP26]]
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[PADDED_SEGMENT_SIZE:%.*]] = add i32 [[TMP29]], 1
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP30:%.*]] = load ptr, ptr [[DOTADDR_ASCAST]], align 8
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP31:%.*]] = load ptr, ptr [[DOTADDR4_ASCAST]], align 8
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP32:%.*]] = load ptr, ptr [[DOTADDR5_ASCAST]], align 8
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP33:%.*]] = load i32, ptr addrspace(5) [[TMP9]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    call void @__kmpc_xteams_phase2_i_8x64(ptr [[TMP31]], i32 [[PADDED_SEGMENT_SIZE]], ptr [[TMP30]], ptr [[TMP32]], ptr @__kmpc_rfun_sum_i, i32 0, i64 [[TMP18]], i32 1)
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP34:%.*]] = mul i32 [[PADDED_SEGMENT_SIZE]], [[TMP24]]
// SEGMENTED-64WAVE-512WGSize-NEXT:    store i32 [[TMP34]], ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP35:%.*]] = add i32 [[TMP24]], 1
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP36:%.*]] = mul i32 [[PADDED_SEGMENT_SIZE]], [[TMP35]]
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP37:%.*]] = load ptr, ptr [[DOTADDR5_ASCAST]], align 8
// SEGMENTED-64WAVE-512WGSize-NEXT:    br label [[FOR_COND:%.*]]
// SEGMENTED-64WAVE-512WGSize:       for.cond:
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP38:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP39:%.*]] = icmp ult i32 [[TMP38]], [[TMP36]]
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP40:%.*]] = icmp ule i32 [[TMP38]], [[GLOBAL_UPPER_BOUND]]
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP41:%.*]] = and i1 [[TMP40]], [[TMP39]]
// SEGMENTED-64WAVE-512WGSize-NEXT:    br i1 [[TMP41]], label [[FOR_BODY:%.*]], label [[FOR_END:%.*]]
// SEGMENTED-64WAVE-512WGSize:       for.body:
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP42:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP42]], 1
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// SEGMENTED-64WAVE-512WGSize-NEXT:    store i32 [[ADD]], ptr [[I_ASCAST]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP43:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP44:%.*]] = getelementptr i32, ptr [[TMP37]], i32 [[TMP43]]
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP45:%.*]] = load i32, ptr [[TMP44]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    store i32 [[TMP45]], ptr addrspace(5) [[TMP9]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    store i32 0, ptr [[SUM18_ASCAST]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    br label [[OMP_INSCAN_DISPATCH:%.*]]
// SEGMENTED-64WAVE-512WGSize:       omp.before.scan.bb:
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP46:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP46]] to i64
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [128000 x i32], ptr [[TMP5]], i64 0, i64 [[IDXPROM]]
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP47:%.*]] = load i32, ptr [[ARRAYIDX]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP48:%.*]] = load i32, ptr addrspace(5) [[TMP9]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP49:%.*]] = add i32 [[TMP48]], [[TMP47]]
// SEGMENTED-64WAVE-512WGSize-NEXT:    store i32 [[TMP49]], ptr addrspace(5) [[TMP9]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// SEGMENTED-64WAVE-512WGSize:       omp.exit.inscan.bb:
// SEGMENTED-64WAVE-512WGSize-NEXT:    br label [[OMP_BODY_CONTINUE]]
// SEGMENTED-64WAVE-512WGSize:       omp.inscan.dispatch:
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP50:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP51:%.*]] = zext i32 [[TMP50]] to i64
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[ARRAYIDX9:%.*]] = getelementptr inbounds nuw i32, ptr [[TMP8]], i64 [[TMP51]]
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP52:%.*]] = load i32, ptr addrspace(5) [[TMP9]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    store i32 [[TMP52]], ptr [[TMP4]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    br label [[OMP_AFTER_SCAN_BB:%.*]]
// SEGMENTED-64WAVE-512WGSize:       omp.after.scan.bb:
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP53:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[IDXPROM10:%.*]] = sext i32 [[TMP53]] to i64
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[ARRAYIDX11:%.*]] = getelementptr inbounds [128000 x i32], ptr [[TMP6]], i64 0, i64 [[IDXPROM10]]
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP54:%.*]] = load i32, ptr addrspace(5) [[TMP9]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    store i32 [[TMP54]], ptr [[ARRAYIDX11]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    br label [[OMP_EXIT_INSCAN_BB:%.*]]
// SEGMENTED-64WAVE-512WGSize:       omp.body.continue:
// SEGMENTED-64WAVE-512WGSize-NEXT:    br label [[FOR_INC:%.*]]
// SEGMENTED-64WAVE-512WGSize:       for.inc:
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP55:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP56:%.*]] = getelementptr i32, ptr [[TMP37]], i32 [[TMP55]]
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP57:%.*]] = load i32, ptr addrspace(5) [[TMP9]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    store i32 [[TMP57]], ptr [[TMP56]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP58:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP59:%.*]] = add i32 1, [[TMP58]]
// SEGMENTED-64WAVE-512WGSize-NEXT:    store i32 [[TMP59]], ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    br label [[FOR_COND]], !llvm.loop [[LOOP15:![0-9]+]]
// SEGMENTED-64WAVE-512WGSize:       for.end:
// SEGMENTED-64WAVE-512WGSize-NEXT:    br label [[OMP_KERNEL_DONE]]
// SEGMENTED-64WAVE-512WGSize:       omp.kernel.done:
// SEGMENTED-64WAVE-512WGSize-NEXT:    ret void
//
//
// SEGMENTED-64WAVE-512WGSize-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l57
// SEGMENTED-64WAVE-512WGSize-SAME: (ptr noalias noundef [[DYN_PTR:%.*]], ptr noundef nonnull align 4 dereferenceable(512000) [[OUT2:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM2:%.*]], ptr noundef nonnull align 4 dereferenceable(512000) [[IN:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM21:%.*]], ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]], ptr noundef [[TMP2:%.*]], ptr noundef [[TMP3:%.*]]) #[[ATTR0]] {
// SEGMENTED-64WAVE-512WGSize-NEXT:  entry:
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[DYN_PTR_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[OUT2_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[SUM2_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[IN_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8, addrspace(5)
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[SUM2_ADDR2:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[DOTADDR3:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[DOTADDR4:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[DOTADDR5:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[I:%.*]] = alloca i32, align 4, addrspace(5)
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4, addrspace(5)
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4, addrspace(5)
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4, addrspace(5)
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[SUM28:%.*]] = alloca i32, align 4, addrspace(5)
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[DYN_PTR_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DYN_PTR_ADDR]] to ptr
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[OUT2_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[OUT2_ADDR]] to ptr
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[SUM2_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM2_ADDR]] to ptr
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[IN_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[IN_ADDR]] to ptr
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[VLA_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[VLA_ADDR]] to ptr
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[SUM2_ADDR2_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM2_ADDR2]] to ptr
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[DOTADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR]] to ptr
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[DOTADDR3_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR3]] to ptr
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[DOTADDR4_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR4]] to ptr
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[DOTADDR5_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR5]] to ptr
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[I_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[I]] to ptr
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[DOTOMP_LB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_LB]] to ptr
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[DOTOMP_UB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_UB]] to ptr
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[DOTOMP_IV_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_IV]] to ptr
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[SUM28_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM28]] to ptr
// SEGMENTED-64WAVE-512WGSize-NEXT:    store ptr [[DYN_PTR]], ptr [[DYN_PTR_ADDR_ASCAST]], align 8
// SEGMENTED-64WAVE-512WGSize-NEXT:    store ptr [[OUT2]], ptr [[OUT2_ADDR_ASCAST]], align 8
// SEGMENTED-64WAVE-512WGSize-NEXT:    store ptr [[SUM2]], ptr [[SUM2_ADDR_ASCAST]], align 8
// SEGMENTED-64WAVE-512WGSize-NEXT:    store ptr [[IN]], ptr [[IN_ADDR_ASCAST]], align 8
// SEGMENTED-64WAVE-512WGSize-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR_ASCAST]], align 8
// SEGMENTED-64WAVE-512WGSize-NEXT:    store ptr [[SUM21]], ptr [[SUM2_ADDR2_ASCAST]], align 8
// SEGMENTED-64WAVE-512WGSize-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR_ASCAST]], align 8
// SEGMENTED-64WAVE-512WGSize-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR3_ASCAST]], align 8
// SEGMENTED-64WAVE-512WGSize-NEXT:    store ptr [[TMP2]], ptr [[DOTADDR4_ASCAST]], align 8
// SEGMENTED-64WAVE-512WGSize-NEXT:    store ptr [[TMP3]], ptr [[DOTADDR5_ASCAST]], align 8
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[OUT2_ADDR_ASCAST]], align 8
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[SUM2_ADDR_ASCAST]], align 8
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP6:%.*]] = load ptr, ptr [[IN_ADDR_ASCAST]], align 8
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP7:%.*]] = load i64, ptr [[VLA_ADDR_ASCAST]], align 8
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP8:%.*]] = load ptr, ptr [[SUM2_ADDR2_ASCAST]], align 8
// SEGMENTED-64WAVE-512WGSize-NEXT:    call void @__kmpc_specialized_kernel_init()
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP9:%.*]] = alloca i32, align 4, addrspace(5)
// SEGMENTED-64WAVE-512WGSize-NEXT:    store i32 0, ptr addrspace(5) [[TMP9]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    store i32 0, ptr [[DOTOMP_LB_ASCAST]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    store i32 127999, ptr [[DOTOMP_UB_ASCAST]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP10:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    store i32 [[TMP10]], ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP11:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[NVPTX_NUM_THREADS:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[GPU_BLOCK_ID:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP12:%.*]] = mul i32 [[GPU_BLOCK_ID]], [[NVPTX_NUM_THREADS]]
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP13:%.*]] = add i32 [[TMP12]], [[TMP11]]
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP14:%.*]] = mul i32 [[TMP13]], 1
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP15:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP16:%.*]] = add i32 [[TMP14]], [[TMP15]]
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP17:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP18:%.*]] = zext i32 [[TMP16]] to i64
// SEGMENTED-64WAVE-512WGSize-NEXT:    store i32 [[TMP16]], ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[GLOBAL_UPPER_BOUND:%.*]] = load i32, ptr [[DOTOMP_UB_ASCAST]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP19:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP20:%.*]] = sub i32 [[GLOBAL_UPPER_BOUND]], [[TMP19]]
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP21:%.*]] = add i32 [[TMP20]], 1
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP22:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[NVPTX_NUM_THREADS6:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[GPU_BLOCK_ID7:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP23:%.*]] = mul i32 [[GPU_BLOCK_ID7]], [[NVPTX_NUM_THREADS6]]
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP24:%.*]] = add i32 [[TMP23]], [[TMP22]]
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP25:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP26:%.*]] = mul i32 [[NVPTX_NUM_THREADS6]], [[TMP25]]
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP27:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP28:%.*]] = icmp ult i32 [[TMP27]], [[TMP26]]
// SEGMENTED-64WAVE-512WGSize-NEXT:    br i1 [[TMP28]], label [[OMP_KERNEL_BODY:%.*]], label [[OMP_KERNEL_DONE:%.*]]
// SEGMENTED-64WAVE-512WGSize:       omp.kernel.body:
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP29:%.*]] = udiv i32 [[TMP21]], [[TMP26]]
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[PADDED_SEGMENT_SIZE:%.*]] = add i32 [[TMP29]], 1
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP30:%.*]] = mul i32 [[PADDED_SEGMENT_SIZE]], [[TMP24]]
// SEGMENTED-64WAVE-512WGSize-NEXT:    store i32 [[TMP30]], ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP31:%.*]] = add i32 [[TMP24]], 1
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP32:%.*]] = mul i32 [[PADDED_SEGMENT_SIZE]], [[TMP31]]
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP33:%.*]] = load ptr, ptr [[DOTADDR5_ASCAST]], align 8
// SEGMENTED-64WAVE-512WGSize-NEXT:    br label [[FOR_COND:%.*]]
// SEGMENTED-64WAVE-512WGSize:       for.cond:
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP34:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP35:%.*]] = icmp ult i32 [[TMP34]], [[TMP32]]
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP36:%.*]] = icmp ule i32 [[TMP34]], [[GLOBAL_UPPER_BOUND]]
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP37:%.*]] = and i1 [[TMP36]], [[TMP35]]
// SEGMENTED-64WAVE-512WGSize-NEXT:    br i1 [[TMP37]], label [[FOR_BODY:%.*]], label [[FOR_END:%.*]]
// SEGMENTED-64WAVE-512WGSize:       for.body:
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP38:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP38]], 1
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// SEGMENTED-64WAVE-512WGSize-NEXT:    store i32 [[ADD]], ptr [[I_ASCAST]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    store i32 0, ptr [[SUM28_ASCAST]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    br label [[OMP_INSCAN_DISPATCH:%.*]]
// SEGMENTED-64WAVE-512WGSize:       omp.before.scan.bb:
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP39:%.*]] = load i32, ptr [[TMP5]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP40:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP40]] to i64
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [128000 x i32], ptr [[TMP4]], i64 0, i64 [[IDXPROM]]
// SEGMENTED-64WAVE-512WGSize-NEXT:    store i32 [[TMP39]], ptr [[ARRAYIDX]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// SEGMENTED-64WAVE-512WGSize:       omp.exit.inscan.bb:
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP41:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP42:%.*]] = zext i32 [[TMP41]] to i64
// SEGMENTED-64WAVE-512WGSize-NEXT:    br label [[OMP_BODY_CONTINUE]]
// SEGMENTED-64WAVE-512WGSize:       omp.inscan.dispatch:
// SEGMENTED-64WAVE-512WGSize-NEXT:    br label [[OMP_AFTER_SCAN_BB:%.*]]
// SEGMENTED-64WAVE-512WGSize:       omp.after.scan.bb:
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP43:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[IDXPROM9:%.*]] = sext i32 [[TMP43]] to i64
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[ARRAYIDX10:%.*]] = getelementptr inbounds [128000 x i32], ptr [[TMP6]], i64 0, i64 [[IDXPROM9]]
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP44:%.*]] = load i32, ptr [[ARRAYIDX10]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP45:%.*]] = load i32, ptr addrspace(5) [[TMP9]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP46:%.*]] = add i32 [[TMP45]], [[TMP44]]
// SEGMENTED-64WAVE-512WGSize-NEXT:    store i32 [[TMP46]], ptr addrspace(5) [[TMP9]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    br label [[OMP_EXIT_INSCAN_BB:%.*]]
// SEGMENTED-64WAVE-512WGSize:       omp.body.continue:
// SEGMENTED-64WAVE-512WGSize-NEXT:    br label [[FOR_INC:%.*]]
// SEGMENTED-64WAVE-512WGSize:       for.inc:
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP47:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP48:%.*]] = getelementptr i32, ptr [[TMP33]], i32 [[TMP47]]
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP49:%.*]] = load i32, ptr addrspace(5) [[TMP9]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    store i32 [[TMP49]], ptr [[TMP48]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP50:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP51:%.*]] = add i32 1, [[TMP50]]
// SEGMENTED-64WAVE-512WGSize-NEXT:    store i32 [[TMP51]], ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    br label [[FOR_COND]], !llvm.loop [[LOOP16:![0-9]+]]
// SEGMENTED-64WAVE-512WGSize:       for.end:
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP52:%.*]] = load ptr, ptr [[DOTADDR_ASCAST]], align 8
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP53:%.*]] = load ptr, ptr [[DOTADDR3_ASCAST]], align 8
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP54:%.*]] = load ptr, ptr [[DOTADDR4_ASCAST]], align 8
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP55:%.*]] = load i32, ptr addrspace(5) [[TMP9]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    call void @__kmpc_xteams_i_8x64(i32 [[TMP55]], ptr [[TMP54]], ptr [[TMP5]], ptr [[TMP52]], ptr [[TMP53]], ptr @__kmpc_rfun_sum_i, ptr @__kmpc_rfun_sum_lds_i, i32 0, i64 [[TMP18]], i32 [[TMP17]])
// SEGMENTED-64WAVE-512WGSize-NEXT:    br label [[OMP_KERNEL_DONE]]
// SEGMENTED-64WAVE-512WGSize:       omp.kernel.done:
// SEGMENTED-64WAVE-512WGSize-NEXT:    ret void
//
//
// SEGMENTED-64WAVE-512WGSize-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l57_1
// SEGMENTED-64WAVE-512WGSize-SAME: (ptr noalias noundef [[DYN_PTR:%.*]], ptr noundef nonnull align 4 dereferenceable(512000) [[OUT2:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM2:%.*]], ptr noundef nonnull align 4 dereferenceable(512000) [[IN:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM21:%.*]], ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]], ptr noundef [[TMP2:%.*]], ptr noundef [[TMP3:%.*]]) #[[ATTR0]] {
// SEGMENTED-64WAVE-512WGSize-NEXT:  entry:
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[DYN_PTR_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[OUT2_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[SUM2_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[IN_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8, addrspace(5)
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[SUM2_ADDR2:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[DOTADDR3:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[DOTADDR4:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[DOTADDR5:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[I:%.*]] = alloca i32, align 4, addrspace(5)
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4, addrspace(5)
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4, addrspace(5)
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4, addrspace(5)
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[SUM28:%.*]] = alloca i32, align 4, addrspace(5)
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[DYN_PTR_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DYN_PTR_ADDR]] to ptr
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[OUT2_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[OUT2_ADDR]] to ptr
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[SUM2_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM2_ADDR]] to ptr
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[IN_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[IN_ADDR]] to ptr
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[VLA_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[VLA_ADDR]] to ptr
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[SUM2_ADDR2_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM2_ADDR2]] to ptr
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[DOTADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR]] to ptr
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[DOTADDR3_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR3]] to ptr
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[DOTADDR4_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR4]] to ptr
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[DOTADDR5_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR5]] to ptr
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[I_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[I]] to ptr
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[DOTOMP_LB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_LB]] to ptr
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[DOTOMP_UB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_UB]] to ptr
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[DOTOMP_IV_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_IV]] to ptr
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[SUM28_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM28]] to ptr
// SEGMENTED-64WAVE-512WGSize-NEXT:    store ptr [[DYN_PTR]], ptr [[DYN_PTR_ADDR_ASCAST]], align 8
// SEGMENTED-64WAVE-512WGSize-NEXT:    store ptr [[OUT2]], ptr [[OUT2_ADDR_ASCAST]], align 8
// SEGMENTED-64WAVE-512WGSize-NEXT:    store ptr [[SUM2]], ptr [[SUM2_ADDR_ASCAST]], align 8
// SEGMENTED-64WAVE-512WGSize-NEXT:    store ptr [[IN]], ptr [[IN_ADDR_ASCAST]], align 8
// SEGMENTED-64WAVE-512WGSize-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR_ASCAST]], align 8
// SEGMENTED-64WAVE-512WGSize-NEXT:    store ptr [[SUM21]], ptr [[SUM2_ADDR2_ASCAST]], align 8
// SEGMENTED-64WAVE-512WGSize-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR_ASCAST]], align 8
// SEGMENTED-64WAVE-512WGSize-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR3_ASCAST]], align 8
// SEGMENTED-64WAVE-512WGSize-NEXT:    store ptr [[TMP2]], ptr [[DOTADDR4_ASCAST]], align 8
// SEGMENTED-64WAVE-512WGSize-NEXT:    store ptr [[TMP3]], ptr [[DOTADDR5_ASCAST]], align 8
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[OUT2_ADDR_ASCAST]], align 8
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[SUM2_ADDR_ASCAST]], align 8
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP6:%.*]] = load ptr, ptr [[IN_ADDR_ASCAST]], align 8
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP7:%.*]] = load i64, ptr [[VLA_ADDR_ASCAST]], align 8
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP8:%.*]] = load ptr, ptr [[SUM2_ADDR2_ASCAST]], align 8
// SEGMENTED-64WAVE-512WGSize-NEXT:    call void @__kmpc_specialized_kernel_init()
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP9:%.*]] = alloca i32, align 4, addrspace(5)
// SEGMENTED-64WAVE-512WGSize-NEXT:    store i32 0, ptr addrspace(5) [[TMP9]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    store i32 0, ptr [[DOTOMP_LB_ASCAST]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    store i32 127999, ptr [[DOTOMP_UB_ASCAST]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP10:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    store i32 [[TMP10]], ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP11:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[NVPTX_NUM_THREADS:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[GPU_BLOCK_ID:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP12:%.*]] = mul i32 [[GPU_BLOCK_ID]], [[NVPTX_NUM_THREADS]]
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP13:%.*]] = add i32 [[TMP12]], [[TMP11]]
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP14:%.*]] = mul i32 [[TMP13]], 1
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP15:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP16:%.*]] = add i32 [[TMP14]], [[TMP15]]
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP17:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP18:%.*]] = zext i32 [[TMP16]] to i64
// SEGMENTED-64WAVE-512WGSize-NEXT:    store i32 [[TMP16]], ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[GLOBAL_UPPER_BOUND:%.*]] = load i32, ptr [[DOTOMP_UB_ASCAST]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP19:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP20:%.*]] = sub i32 [[GLOBAL_UPPER_BOUND]], [[TMP19]]
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP21:%.*]] = add i32 [[TMP20]], 1
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP22:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[NVPTX_NUM_THREADS6:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[GPU_BLOCK_ID7:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP23:%.*]] = mul i32 [[GPU_BLOCK_ID7]], [[NVPTX_NUM_THREADS6]]
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP24:%.*]] = add i32 [[TMP23]], [[TMP22]]
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP25:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP26:%.*]] = mul i32 [[NVPTX_NUM_THREADS6]], [[TMP25]]
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP27:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP28:%.*]] = icmp ult i32 [[TMP27]], [[TMP26]]
// SEGMENTED-64WAVE-512WGSize-NEXT:    br i1 [[TMP28]], label [[OMP_KERNEL_BODY:%.*]], label [[OMP_KERNEL_DONE:%.*]]
// SEGMENTED-64WAVE-512WGSize:       omp.kernel.body:
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP29:%.*]] = udiv i32 [[TMP21]], [[TMP26]]
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[PADDED_SEGMENT_SIZE:%.*]] = add i32 [[TMP29]], 1
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP30:%.*]] = load ptr, ptr [[DOTADDR_ASCAST]], align 8
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP31:%.*]] = load ptr, ptr [[DOTADDR4_ASCAST]], align 8
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP32:%.*]] = load ptr, ptr [[DOTADDR5_ASCAST]], align 8
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP33:%.*]] = load i32, ptr addrspace(5) [[TMP9]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    call void @__kmpc_xteams_phase2_i_8x64(ptr [[TMP31]], i32 [[PADDED_SEGMENT_SIZE]], ptr [[TMP30]], ptr [[TMP32]], ptr @__kmpc_rfun_sum_i, i32 0, i64 [[TMP18]], i32 0)
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP34:%.*]] = mul i32 [[PADDED_SEGMENT_SIZE]], [[TMP24]]
// SEGMENTED-64WAVE-512WGSize-NEXT:    store i32 [[TMP34]], ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP35:%.*]] = add i32 [[TMP24]], 1
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP36:%.*]] = mul i32 [[PADDED_SEGMENT_SIZE]], [[TMP35]]
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP37:%.*]] = load ptr, ptr [[DOTADDR5_ASCAST]], align 8
// SEGMENTED-64WAVE-512WGSize-NEXT:    br label [[FOR_COND:%.*]]
// SEGMENTED-64WAVE-512WGSize:       for.cond:
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP38:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP39:%.*]] = icmp ult i32 [[TMP38]], [[TMP36]]
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP40:%.*]] = icmp ule i32 [[TMP38]], [[GLOBAL_UPPER_BOUND]]
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP41:%.*]] = and i1 [[TMP40]], [[TMP39]]
// SEGMENTED-64WAVE-512WGSize-NEXT:    br i1 [[TMP41]], label [[FOR_BODY:%.*]], label [[FOR_END:%.*]]
// SEGMENTED-64WAVE-512WGSize:       for.body:
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP42:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP42]], 1
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// SEGMENTED-64WAVE-512WGSize-NEXT:    store i32 [[ADD]], ptr [[I_ASCAST]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP43:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP44:%.*]] = getelementptr i32, ptr [[TMP37]], i32 [[TMP43]]
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP45:%.*]] = load i32, ptr [[TMP44]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    store i32 [[TMP45]], ptr addrspace(5) [[TMP9]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    store i32 0, ptr [[SUM28_ASCAST]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    br label [[OMP_INSCAN_DISPATCH:%.*]]
// SEGMENTED-64WAVE-512WGSize:       omp.before.scan.bb:
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP46:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP46]] to i64
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [128000 x i32], ptr [[TMP4]], i64 0, i64 [[IDXPROM]]
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP47:%.*]] = load i32, ptr addrspace(5) [[TMP9]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    store i32 [[TMP47]], ptr [[ARRAYIDX]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// SEGMENTED-64WAVE-512WGSize:       omp.exit.inscan.bb:
// SEGMENTED-64WAVE-512WGSize-NEXT:    br label [[OMP_BODY_CONTINUE]]
// SEGMENTED-64WAVE-512WGSize:       omp.inscan.dispatch:
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP48:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP49:%.*]] = zext i32 [[TMP48]] to i64
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP50:%.*]] = icmp eq i64 [[TMP49]], 0
// SEGMENTED-64WAVE-512WGSize-NEXT:    br i1 [[TMP50]], label [[OMP_EXCLUSIVE_COPY_EXIT:%.*]], label [[OMP_EXCLUSIVE_DEC:%.*]]
// SEGMENTED-64WAVE-512WGSize:       omp.exclusive.dec:
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP51:%.*]] = sub nuw i64 [[TMP49]], 1
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[ARRAYIDX9:%.*]] = getelementptr inbounds nuw i32, ptr [[TMP8]], i64 [[TMP51]]
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP52:%.*]] = load i32, ptr addrspace(5) [[TMP9]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    store i32 [[TMP52]], ptr [[TMP5]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    br label [[OMP_EXCLUSIVE_COPY_EXIT]]
// SEGMENTED-64WAVE-512WGSize:       omp.exclusive.copy.exit:
// SEGMENTED-64WAVE-512WGSize-NEXT:    br label [[OMP_BEFORE_SCAN_BB:%.*]]
// SEGMENTED-64WAVE-512WGSize:       omp.after.scan.bb:
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP53:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[IDXPROM10:%.*]] = sext i32 [[TMP53]] to i64
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[ARRAYIDX11:%.*]] = getelementptr inbounds [128000 x i32], ptr [[TMP6]], i64 0, i64 [[IDXPROM10]]
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP54:%.*]] = load i32, ptr [[ARRAYIDX11]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP55:%.*]] = load i32, ptr addrspace(5) [[TMP9]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP56:%.*]] = add i32 [[TMP55]], [[TMP54]]
// SEGMENTED-64WAVE-512WGSize-NEXT:    store i32 [[TMP56]], ptr addrspace(5) [[TMP9]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    br label [[OMP_EXIT_INSCAN_BB:%.*]]
// SEGMENTED-64WAVE-512WGSize:       omp.body.continue:
// SEGMENTED-64WAVE-512WGSize-NEXT:    br label [[FOR_INC:%.*]]
// SEGMENTED-64WAVE-512WGSize:       for.inc:
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP57:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP58:%.*]] = getelementptr i32, ptr [[TMP37]], i32 [[TMP57]]
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP59:%.*]] = load i32, ptr addrspace(5) [[TMP9]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    store i32 [[TMP59]], ptr [[TMP58]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP60:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    [[TMP61:%.*]] = add i32 1, [[TMP60]]
// SEGMENTED-64WAVE-512WGSize-NEXT:    store i32 [[TMP61]], ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-64WAVE-512WGSize-NEXT:    br label [[FOR_COND]], !llvm.loop [[LOOP17:![0-9]+]]
// SEGMENTED-64WAVE-512WGSize:       for.end:
// SEGMENTED-64WAVE-512WGSize-NEXT:    br label [[OMP_KERNEL_DONE]]
// SEGMENTED-64WAVE-512WGSize:       omp.kernel.done:
// SEGMENTED-64WAVE-512WGSize-NEXT:    ret void
//
//
// SEGMENTED-32WAVE-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l47
// SEGMENTED-32WAVE-SAME: (ptr noalias noundef [[DYN_PTR:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM1:%.*]], ptr noundef nonnull align 4 dereferenceable(256000) [[IN:%.*]], ptr noundef nonnull align 4 dereferenceable(256000) [[OUT1:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM11:%.*]], ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]], ptr noundef [[TMP2:%.*]], ptr noundef [[TMP3:%.*]]) #[[ATTR0:[0-9]+]] {
// SEGMENTED-32WAVE-NEXT:  entry:
// SEGMENTED-32WAVE-NEXT:    [[DYN_PTR_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-32WAVE-NEXT:    [[SUM1_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-32WAVE-NEXT:    [[IN_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-32WAVE-NEXT:    [[OUT1_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-32WAVE-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8, addrspace(5)
// SEGMENTED-32WAVE-NEXT:    [[SUM1_ADDR2:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-32WAVE-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-32WAVE-NEXT:    [[DOTADDR3:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-32WAVE-NEXT:    [[DOTADDR4:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-32WAVE-NEXT:    [[DOTADDR5:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-32WAVE-NEXT:    [[I:%.*]] = alloca i32, align 4, addrspace(5)
// SEGMENTED-32WAVE-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4, addrspace(5)
// SEGMENTED-32WAVE-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4, addrspace(5)
// SEGMENTED-32WAVE-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4, addrspace(5)
// SEGMENTED-32WAVE-NEXT:    [[SUM18:%.*]] = alloca i32, align 4, addrspace(5)
// SEGMENTED-32WAVE-NEXT:    [[DYN_PTR_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DYN_PTR_ADDR]] to ptr
// SEGMENTED-32WAVE-NEXT:    [[SUM1_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM1_ADDR]] to ptr
// SEGMENTED-32WAVE-NEXT:    [[IN_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[IN_ADDR]] to ptr
// SEGMENTED-32WAVE-NEXT:    [[OUT1_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[OUT1_ADDR]] to ptr
// SEGMENTED-32WAVE-NEXT:    [[VLA_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[VLA_ADDR]] to ptr
// SEGMENTED-32WAVE-NEXT:    [[SUM1_ADDR2_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM1_ADDR2]] to ptr
// SEGMENTED-32WAVE-NEXT:    [[DOTADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR]] to ptr
// SEGMENTED-32WAVE-NEXT:    [[DOTADDR3_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR3]] to ptr
// SEGMENTED-32WAVE-NEXT:    [[DOTADDR4_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR4]] to ptr
// SEGMENTED-32WAVE-NEXT:    [[DOTADDR5_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR5]] to ptr
// SEGMENTED-32WAVE-NEXT:    [[I_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[I]] to ptr
// SEGMENTED-32WAVE-NEXT:    [[DOTOMP_LB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_LB]] to ptr
// SEGMENTED-32WAVE-NEXT:    [[DOTOMP_UB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_UB]] to ptr
// SEGMENTED-32WAVE-NEXT:    [[DOTOMP_IV_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_IV]] to ptr
// SEGMENTED-32WAVE-NEXT:    [[SUM18_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM18]] to ptr
// SEGMENTED-32WAVE-NEXT:    store ptr [[DYN_PTR]], ptr [[DYN_PTR_ADDR_ASCAST]], align 8
// SEGMENTED-32WAVE-NEXT:    store ptr [[SUM1]], ptr [[SUM1_ADDR_ASCAST]], align 8
// SEGMENTED-32WAVE-NEXT:    store ptr [[IN]], ptr [[IN_ADDR_ASCAST]], align 8
// SEGMENTED-32WAVE-NEXT:    store ptr [[OUT1]], ptr [[OUT1_ADDR_ASCAST]], align 8
// SEGMENTED-32WAVE-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR_ASCAST]], align 8
// SEGMENTED-32WAVE-NEXT:    store ptr [[SUM11]], ptr [[SUM1_ADDR2_ASCAST]], align 8
// SEGMENTED-32WAVE-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR_ASCAST]], align 8
// SEGMENTED-32WAVE-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR3_ASCAST]], align 8
// SEGMENTED-32WAVE-NEXT:    store ptr [[TMP2]], ptr [[DOTADDR4_ASCAST]], align 8
// SEGMENTED-32WAVE-NEXT:    store ptr [[TMP3]], ptr [[DOTADDR5_ASCAST]], align 8
// SEGMENTED-32WAVE-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[SUM1_ADDR_ASCAST]], align 8
// SEGMENTED-32WAVE-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[IN_ADDR_ASCAST]], align 8
// SEGMENTED-32WAVE-NEXT:    [[TMP6:%.*]] = load ptr, ptr [[OUT1_ADDR_ASCAST]], align 8
// SEGMENTED-32WAVE-NEXT:    [[TMP7:%.*]] = load i64, ptr [[VLA_ADDR_ASCAST]], align 8
// SEGMENTED-32WAVE-NEXT:    [[TMP8:%.*]] = load ptr, ptr [[SUM1_ADDR2_ASCAST]], align 8
// SEGMENTED-32WAVE-NEXT:    call void @__kmpc_specialized_kernel_init()
// SEGMENTED-32WAVE-NEXT:    [[TMP9:%.*]] = alloca i32, align 4, addrspace(5)
// SEGMENTED-32WAVE-NEXT:    store i32 0, ptr addrspace(5) [[TMP9]], align 4
// SEGMENTED-32WAVE-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// SEGMENTED-32WAVE-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// SEGMENTED-32WAVE-NEXT:    store i32 0, ptr [[DOTOMP_LB_ASCAST]], align 4
// SEGMENTED-32WAVE-NEXT:    store i32 63999, ptr [[DOTOMP_UB_ASCAST]], align 4
// SEGMENTED-32WAVE-NEXT:    [[TMP10:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// SEGMENTED-32WAVE-NEXT:    store i32 [[TMP10]], ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-32WAVE-NEXT:    [[TMP11:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// SEGMENTED-32WAVE-NEXT:    [[NVPTX_NUM_THREADS:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// SEGMENTED-32WAVE-NEXT:    [[GPU_BLOCK_ID:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// SEGMENTED-32WAVE-NEXT:    [[TMP12:%.*]] = mul i32 [[GPU_BLOCK_ID]], [[NVPTX_NUM_THREADS]]
// SEGMENTED-32WAVE-NEXT:    [[TMP13:%.*]] = add i32 [[TMP12]], [[TMP11]]
// SEGMENTED-32WAVE-NEXT:    [[TMP14:%.*]] = mul i32 [[TMP13]], 1
// SEGMENTED-32WAVE-NEXT:    [[TMP15:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-32WAVE-NEXT:    [[TMP16:%.*]] = add i32 [[TMP14]], [[TMP15]]
// SEGMENTED-32WAVE-NEXT:    [[TMP17:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// SEGMENTED-32WAVE-NEXT:    [[TMP18:%.*]] = zext i32 [[TMP16]] to i64
// SEGMENTED-32WAVE-NEXT:    store i32 [[TMP16]], ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-32WAVE-NEXT:    [[GLOBAL_UPPER_BOUND:%.*]] = load i32, ptr [[DOTOMP_UB_ASCAST]], align 4
// SEGMENTED-32WAVE-NEXT:    [[TMP19:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// SEGMENTED-32WAVE-NEXT:    [[TMP20:%.*]] = sub i32 [[GLOBAL_UPPER_BOUND]], [[TMP19]]
// SEGMENTED-32WAVE-NEXT:    [[TMP21:%.*]] = add i32 [[TMP20]], 1
// SEGMENTED-32WAVE-NEXT:    [[TMP22:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// SEGMENTED-32WAVE-NEXT:    [[NVPTX_NUM_THREADS6:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// SEGMENTED-32WAVE-NEXT:    [[GPU_BLOCK_ID7:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// SEGMENTED-32WAVE-NEXT:    [[TMP23:%.*]] = mul i32 [[GPU_BLOCK_ID7]], [[NVPTX_NUM_THREADS6]]
// SEGMENTED-32WAVE-NEXT:    [[TMP24:%.*]] = add i32 [[TMP23]], [[TMP22]]
// SEGMENTED-32WAVE-NEXT:    [[TMP25:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// SEGMENTED-32WAVE-NEXT:    [[TMP26:%.*]] = mul i32 [[NVPTX_NUM_THREADS6]], [[TMP25]]
// SEGMENTED-32WAVE-NEXT:    [[TMP27:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-32WAVE-NEXT:    [[TMP28:%.*]] = icmp ult i32 [[TMP27]], [[TMP26]]
// SEGMENTED-32WAVE-NEXT:    br i1 [[TMP28]], label [[OMP_KERNEL_BODY:%.*]], label [[OMP_KERNEL_DONE:%.*]]
// SEGMENTED-32WAVE:       omp.kernel.body:
// SEGMENTED-32WAVE-NEXT:    [[TMP29:%.*]] = udiv i32 [[TMP21]], [[TMP26]]
// SEGMENTED-32WAVE-NEXT:    [[PADDED_SEGMENT_SIZE:%.*]] = add i32 [[TMP29]], 1
// SEGMENTED-32WAVE-NEXT:    [[TMP30:%.*]] = mul i32 [[PADDED_SEGMENT_SIZE]], [[TMP24]]
// SEGMENTED-32WAVE-NEXT:    store i32 [[TMP30]], ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-32WAVE-NEXT:    [[TMP31:%.*]] = add i32 [[TMP24]], 1
// SEGMENTED-32WAVE-NEXT:    [[TMP32:%.*]] = mul i32 [[PADDED_SEGMENT_SIZE]], [[TMP31]]
// SEGMENTED-32WAVE-NEXT:    [[TMP33:%.*]] = load ptr, ptr [[DOTADDR5_ASCAST]], align 8
// SEGMENTED-32WAVE-NEXT:    br label [[FOR_COND:%.*]]
// SEGMENTED-32WAVE:       for.cond:
// SEGMENTED-32WAVE-NEXT:    [[TMP34:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-32WAVE-NEXT:    [[TMP35:%.*]] = icmp ult i32 [[TMP34]], [[TMP32]]
// SEGMENTED-32WAVE-NEXT:    [[TMP36:%.*]] = icmp ule i32 [[TMP34]], [[GLOBAL_UPPER_BOUND]]
// SEGMENTED-32WAVE-NEXT:    [[TMP37:%.*]] = and i1 [[TMP36]], [[TMP35]]
// SEGMENTED-32WAVE-NEXT:    br i1 [[TMP37]], label [[FOR_BODY:%.*]], label [[FOR_END:%.*]]
// SEGMENTED-32WAVE:       for.body:
// SEGMENTED-32WAVE-NEXT:    [[TMP38:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-32WAVE-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP38]], 1
// SEGMENTED-32WAVE-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// SEGMENTED-32WAVE-NEXT:    store i32 [[ADD]], ptr [[I_ASCAST]], align 4
// SEGMENTED-32WAVE-NEXT:    store i32 0, ptr [[SUM18_ASCAST]], align 4
// SEGMENTED-32WAVE-NEXT:    br label [[OMP_INSCAN_DISPATCH:%.*]]
// SEGMENTED-32WAVE:       omp.before.scan.bb:
// SEGMENTED-32WAVE-NEXT:    [[TMP39:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// SEGMENTED-32WAVE-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP39]] to i64
// SEGMENTED-32WAVE-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [64000 x i32], ptr [[TMP5]], i64 0, i64 [[IDXPROM]]
// SEGMENTED-32WAVE-NEXT:    [[TMP40:%.*]] = load i32, ptr [[ARRAYIDX]], align 4
// SEGMENTED-32WAVE-NEXT:    [[TMP41:%.*]] = load i32, ptr addrspace(5) [[TMP9]], align 4
// SEGMENTED-32WAVE-NEXT:    [[TMP42:%.*]] = add i32 [[TMP41]], [[TMP40]]
// SEGMENTED-32WAVE-NEXT:    store i32 [[TMP42]], ptr addrspace(5) [[TMP9]], align 4
// SEGMENTED-32WAVE-NEXT:    [[TMP43:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-32WAVE-NEXT:    [[TMP44:%.*]] = zext i32 [[TMP43]] to i64
// SEGMENTED-32WAVE-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// SEGMENTED-32WAVE:       omp.exit.inscan.bb:
// SEGMENTED-32WAVE-NEXT:    br label [[OMP_BODY_CONTINUE]]
// SEGMENTED-32WAVE:       omp.inscan.dispatch:
// SEGMENTED-32WAVE-NEXT:    br label [[OMP_BEFORE_SCAN_BB:%.*]]
// SEGMENTED-32WAVE:       omp.after.scan.bb:
// SEGMENTED-32WAVE-NEXT:    [[TMP45:%.*]] = load i32, ptr [[TMP4]], align 4
// SEGMENTED-32WAVE-NEXT:    [[TMP46:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// SEGMENTED-32WAVE-NEXT:    [[IDXPROM9:%.*]] = sext i32 [[TMP46]] to i64
// SEGMENTED-32WAVE-NEXT:    [[ARRAYIDX10:%.*]] = getelementptr inbounds [64000 x i32], ptr [[TMP6]], i64 0, i64 [[IDXPROM9]]
// SEGMENTED-32WAVE-NEXT:    store i32 [[TMP45]], ptr [[ARRAYIDX10]], align 4
// SEGMENTED-32WAVE-NEXT:    br label [[OMP_EXIT_INSCAN_BB:%.*]]
// SEGMENTED-32WAVE:       omp.body.continue:
// SEGMENTED-32WAVE-NEXT:    br label [[FOR_INC:%.*]]
// SEGMENTED-32WAVE:       for.inc:
// SEGMENTED-32WAVE-NEXT:    [[TMP47:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-32WAVE-NEXT:    [[TMP48:%.*]] = getelementptr i32, ptr [[TMP33]], i32 [[TMP47]]
// SEGMENTED-32WAVE-NEXT:    [[TMP49:%.*]] = load i32, ptr addrspace(5) [[TMP9]], align 4
// SEGMENTED-32WAVE-NEXT:    store i32 [[TMP49]], ptr [[TMP48]], align 4
// SEGMENTED-32WAVE-NEXT:    [[TMP50:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-32WAVE-NEXT:    [[TMP51:%.*]] = add i32 1, [[TMP50]]
// SEGMENTED-32WAVE-NEXT:    store i32 [[TMP51]], ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-32WAVE-NEXT:    br label [[FOR_COND]], !llvm.loop [[LOOP13:![0-9]+]]
// SEGMENTED-32WAVE:       for.end:
// SEGMENTED-32WAVE-NEXT:    [[TMP52:%.*]] = load ptr, ptr [[DOTADDR_ASCAST]], align 8
// SEGMENTED-32WAVE-NEXT:    [[TMP53:%.*]] = load ptr, ptr [[DOTADDR3_ASCAST]], align 8
// SEGMENTED-32WAVE-NEXT:    [[TMP54:%.*]] = load ptr, ptr [[DOTADDR4_ASCAST]], align 8
// SEGMENTED-32WAVE-NEXT:    [[TMP55:%.*]] = load i32, ptr addrspace(5) [[TMP9]], align 4
// SEGMENTED-32WAVE-NEXT:    call void @__kmpc_xteams_i_8x32(i32 [[TMP55]], ptr [[TMP54]], ptr [[TMP4]], ptr [[TMP52]], ptr [[TMP53]], ptr @__kmpc_rfun_sum_i, ptr @__kmpc_rfun_sum_lds_i, i32 0, i64 [[TMP18]], i32 [[TMP17]])
// SEGMENTED-32WAVE-NEXT:    br label [[OMP_KERNEL_DONE]]
// SEGMENTED-32WAVE:       omp.kernel.done:
// SEGMENTED-32WAVE-NEXT:    ret void
//
//
// SEGMENTED-32WAVE-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l47_1
// SEGMENTED-32WAVE-SAME: (ptr noalias noundef [[DYN_PTR:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM1:%.*]], ptr noundef nonnull align 4 dereferenceable(256000) [[IN:%.*]], ptr noundef nonnull align 4 dereferenceable(256000) [[OUT1:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM11:%.*]], ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]], ptr noundef [[TMP2:%.*]], ptr noundef [[TMP3:%.*]]) #[[ATTR0]] {
// SEGMENTED-32WAVE-NEXT:  entry:
// SEGMENTED-32WAVE-NEXT:    [[DYN_PTR_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-32WAVE-NEXT:    [[SUM1_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-32WAVE-NEXT:    [[IN_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-32WAVE-NEXT:    [[OUT1_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-32WAVE-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8, addrspace(5)
// SEGMENTED-32WAVE-NEXT:    [[SUM1_ADDR2:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-32WAVE-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-32WAVE-NEXT:    [[DOTADDR3:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-32WAVE-NEXT:    [[DOTADDR4:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-32WAVE-NEXT:    [[DOTADDR5:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-32WAVE-NEXT:    [[I:%.*]] = alloca i32, align 4, addrspace(5)
// SEGMENTED-32WAVE-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4, addrspace(5)
// SEGMENTED-32WAVE-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4, addrspace(5)
// SEGMENTED-32WAVE-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4, addrspace(5)
// SEGMENTED-32WAVE-NEXT:    [[SUM18:%.*]] = alloca i32, align 4, addrspace(5)
// SEGMENTED-32WAVE-NEXT:    [[DYN_PTR_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DYN_PTR_ADDR]] to ptr
// SEGMENTED-32WAVE-NEXT:    [[SUM1_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM1_ADDR]] to ptr
// SEGMENTED-32WAVE-NEXT:    [[IN_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[IN_ADDR]] to ptr
// SEGMENTED-32WAVE-NEXT:    [[OUT1_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[OUT1_ADDR]] to ptr
// SEGMENTED-32WAVE-NEXT:    [[VLA_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[VLA_ADDR]] to ptr
// SEGMENTED-32WAVE-NEXT:    [[SUM1_ADDR2_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM1_ADDR2]] to ptr
// SEGMENTED-32WAVE-NEXT:    [[DOTADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR]] to ptr
// SEGMENTED-32WAVE-NEXT:    [[DOTADDR3_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR3]] to ptr
// SEGMENTED-32WAVE-NEXT:    [[DOTADDR4_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR4]] to ptr
// SEGMENTED-32WAVE-NEXT:    [[DOTADDR5_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR5]] to ptr
// SEGMENTED-32WAVE-NEXT:    [[I_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[I]] to ptr
// SEGMENTED-32WAVE-NEXT:    [[DOTOMP_LB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_LB]] to ptr
// SEGMENTED-32WAVE-NEXT:    [[DOTOMP_UB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_UB]] to ptr
// SEGMENTED-32WAVE-NEXT:    [[DOTOMP_IV_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_IV]] to ptr
// SEGMENTED-32WAVE-NEXT:    [[SUM18_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM18]] to ptr
// SEGMENTED-32WAVE-NEXT:    store ptr [[DYN_PTR]], ptr [[DYN_PTR_ADDR_ASCAST]], align 8
// SEGMENTED-32WAVE-NEXT:    store ptr [[SUM1]], ptr [[SUM1_ADDR_ASCAST]], align 8
// SEGMENTED-32WAVE-NEXT:    store ptr [[IN]], ptr [[IN_ADDR_ASCAST]], align 8
// SEGMENTED-32WAVE-NEXT:    store ptr [[OUT1]], ptr [[OUT1_ADDR_ASCAST]], align 8
// SEGMENTED-32WAVE-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR_ASCAST]], align 8
// SEGMENTED-32WAVE-NEXT:    store ptr [[SUM11]], ptr [[SUM1_ADDR2_ASCAST]], align 8
// SEGMENTED-32WAVE-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR_ASCAST]], align 8
// SEGMENTED-32WAVE-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR3_ASCAST]], align 8
// SEGMENTED-32WAVE-NEXT:    store ptr [[TMP2]], ptr [[DOTADDR4_ASCAST]], align 8
// SEGMENTED-32WAVE-NEXT:    store ptr [[TMP3]], ptr [[DOTADDR5_ASCAST]], align 8
// SEGMENTED-32WAVE-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[SUM1_ADDR_ASCAST]], align 8
// SEGMENTED-32WAVE-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[IN_ADDR_ASCAST]], align 8
// SEGMENTED-32WAVE-NEXT:    [[TMP6:%.*]] = load ptr, ptr [[OUT1_ADDR_ASCAST]], align 8
// SEGMENTED-32WAVE-NEXT:    [[TMP7:%.*]] = load i64, ptr [[VLA_ADDR_ASCAST]], align 8
// SEGMENTED-32WAVE-NEXT:    [[TMP8:%.*]] = load ptr, ptr [[SUM1_ADDR2_ASCAST]], align 8
// SEGMENTED-32WAVE-NEXT:    call void @__kmpc_specialized_kernel_init()
// SEGMENTED-32WAVE-NEXT:    [[TMP9:%.*]] = alloca i32, align 4, addrspace(5)
// SEGMENTED-32WAVE-NEXT:    store i32 0, ptr addrspace(5) [[TMP9]], align 4
// SEGMENTED-32WAVE-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// SEGMENTED-32WAVE-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// SEGMENTED-32WAVE-NEXT:    store i32 0, ptr [[DOTOMP_LB_ASCAST]], align 4
// SEGMENTED-32WAVE-NEXT:    store i32 63999, ptr [[DOTOMP_UB_ASCAST]], align 4
// SEGMENTED-32WAVE-NEXT:    [[TMP10:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// SEGMENTED-32WAVE-NEXT:    store i32 [[TMP10]], ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-32WAVE-NEXT:    [[TMP11:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// SEGMENTED-32WAVE-NEXT:    [[NVPTX_NUM_THREADS:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// SEGMENTED-32WAVE-NEXT:    [[GPU_BLOCK_ID:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// SEGMENTED-32WAVE-NEXT:    [[TMP12:%.*]] = mul i32 [[GPU_BLOCK_ID]], [[NVPTX_NUM_THREADS]]
// SEGMENTED-32WAVE-NEXT:    [[TMP13:%.*]] = add i32 [[TMP12]], [[TMP11]]
// SEGMENTED-32WAVE-NEXT:    [[TMP14:%.*]] = mul i32 [[TMP13]], 1
// SEGMENTED-32WAVE-NEXT:    [[TMP15:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-32WAVE-NEXT:    [[TMP16:%.*]] = add i32 [[TMP14]], [[TMP15]]
// SEGMENTED-32WAVE-NEXT:    [[TMP17:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// SEGMENTED-32WAVE-NEXT:    [[TMP18:%.*]] = zext i32 [[TMP16]] to i64
// SEGMENTED-32WAVE-NEXT:    store i32 [[TMP16]], ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-32WAVE-NEXT:    [[GLOBAL_UPPER_BOUND:%.*]] = load i32, ptr [[DOTOMP_UB_ASCAST]], align 4
// SEGMENTED-32WAVE-NEXT:    [[TMP19:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// SEGMENTED-32WAVE-NEXT:    [[TMP20:%.*]] = sub i32 [[GLOBAL_UPPER_BOUND]], [[TMP19]]
// SEGMENTED-32WAVE-NEXT:    [[TMP21:%.*]] = add i32 [[TMP20]], 1
// SEGMENTED-32WAVE-NEXT:    [[TMP22:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// SEGMENTED-32WAVE-NEXT:    [[NVPTX_NUM_THREADS6:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// SEGMENTED-32WAVE-NEXT:    [[GPU_BLOCK_ID7:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// SEGMENTED-32WAVE-NEXT:    [[TMP23:%.*]] = mul i32 [[GPU_BLOCK_ID7]], [[NVPTX_NUM_THREADS6]]
// SEGMENTED-32WAVE-NEXT:    [[TMP24:%.*]] = add i32 [[TMP23]], [[TMP22]]
// SEGMENTED-32WAVE-NEXT:    [[TMP25:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// SEGMENTED-32WAVE-NEXT:    [[TMP26:%.*]] = mul i32 [[NVPTX_NUM_THREADS6]], [[TMP25]]
// SEGMENTED-32WAVE-NEXT:    [[TMP27:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-32WAVE-NEXT:    [[TMP28:%.*]] = icmp ult i32 [[TMP27]], [[TMP26]]
// SEGMENTED-32WAVE-NEXT:    br i1 [[TMP28]], label [[OMP_KERNEL_BODY:%.*]], label [[OMP_KERNEL_DONE:%.*]]
// SEGMENTED-32WAVE:       omp.kernel.body:
// SEGMENTED-32WAVE-NEXT:    [[TMP29:%.*]] = udiv i32 [[TMP21]], [[TMP26]]
// SEGMENTED-32WAVE-NEXT:    [[PADDED_SEGMENT_SIZE:%.*]] = add i32 [[TMP29]], 1
// SEGMENTED-32WAVE-NEXT:    [[TMP30:%.*]] = load ptr, ptr [[DOTADDR_ASCAST]], align 8
// SEGMENTED-32WAVE-NEXT:    [[TMP31:%.*]] = load ptr, ptr [[DOTADDR4_ASCAST]], align 8
// SEGMENTED-32WAVE-NEXT:    [[TMP32:%.*]] = load ptr, ptr [[DOTADDR5_ASCAST]], align 8
// SEGMENTED-32WAVE-NEXT:    [[TMP33:%.*]] = load i32, ptr addrspace(5) [[TMP9]], align 4
// SEGMENTED-32WAVE-NEXT:    call void @__kmpc_xteams_phase2_i_8x32(ptr [[TMP31]], i32 [[PADDED_SEGMENT_SIZE]], ptr [[TMP30]], ptr [[TMP32]], ptr @__kmpc_rfun_sum_i, i32 0, i64 [[TMP18]], i32 1)
// SEGMENTED-32WAVE-NEXT:    [[TMP34:%.*]] = mul i32 [[PADDED_SEGMENT_SIZE]], [[TMP24]]
// SEGMENTED-32WAVE-NEXT:    store i32 [[TMP34]], ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-32WAVE-NEXT:    [[TMP35:%.*]] = add i32 [[TMP24]], 1
// SEGMENTED-32WAVE-NEXT:    [[TMP36:%.*]] = mul i32 [[PADDED_SEGMENT_SIZE]], [[TMP35]]
// SEGMENTED-32WAVE-NEXT:    [[TMP37:%.*]] = load ptr, ptr [[DOTADDR5_ASCAST]], align 8
// SEGMENTED-32WAVE-NEXT:    br label [[FOR_COND:%.*]]
// SEGMENTED-32WAVE:       for.cond:
// SEGMENTED-32WAVE-NEXT:    [[TMP38:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-32WAVE-NEXT:    [[TMP39:%.*]] = icmp ult i32 [[TMP38]], [[TMP36]]
// SEGMENTED-32WAVE-NEXT:    [[TMP40:%.*]] = icmp ule i32 [[TMP38]], [[GLOBAL_UPPER_BOUND]]
// SEGMENTED-32WAVE-NEXT:    [[TMP41:%.*]] = and i1 [[TMP40]], [[TMP39]]
// SEGMENTED-32WAVE-NEXT:    br i1 [[TMP41]], label [[FOR_BODY:%.*]], label [[FOR_END:%.*]]
// SEGMENTED-32WAVE:       for.body:
// SEGMENTED-32WAVE-NEXT:    [[TMP42:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-32WAVE-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP42]], 1
// SEGMENTED-32WAVE-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// SEGMENTED-32WAVE-NEXT:    store i32 [[ADD]], ptr [[I_ASCAST]], align 4
// SEGMENTED-32WAVE-NEXT:    [[TMP43:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-32WAVE-NEXT:    [[TMP44:%.*]] = getelementptr i32, ptr [[TMP37]], i32 [[TMP43]]
// SEGMENTED-32WAVE-NEXT:    [[TMP45:%.*]] = load i32, ptr [[TMP44]], align 4
// SEGMENTED-32WAVE-NEXT:    store i32 [[TMP45]], ptr addrspace(5) [[TMP9]], align 4
// SEGMENTED-32WAVE-NEXT:    store i32 0, ptr [[SUM18_ASCAST]], align 4
// SEGMENTED-32WAVE-NEXT:    br label [[OMP_INSCAN_DISPATCH:%.*]]
// SEGMENTED-32WAVE:       omp.before.scan.bb:
// SEGMENTED-32WAVE-NEXT:    [[TMP46:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// SEGMENTED-32WAVE-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP46]] to i64
// SEGMENTED-32WAVE-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [64000 x i32], ptr [[TMP5]], i64 0, i64 [[IDXPROM]]
// SEGMENTED-32WAVE-NEXT:    [[TMP47:%.*]] = load i32, ptr [[ARRAYIDX]], align 4
// SEGMENTED-32WAVE-NEXT:    [[TMP48:%.*]] = load i32, ptr addrspace(5) [[TMP9]], align 4
// SEGMENTED-32WAVE-NEXT:    [[TMP49:%.*]] = add i32 [[TMP48]], [[TMP47]]
// SEGMENTED-32WAVE-NEXT:    store i32 [[TMP49]], ptr addrspace(5) [[TMP9]], align 4
// SEGMENTED-32WAVE-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// SEGMENTED-32WAVE:       omp.exit.inscan.bb:
// SEGMENTED-32WAVE-NEXT:    br label [[OMP_BODY_CONTINUE]]
// SEGMENTED-32WAVE:       omp.inscan.dispatch:
// SEGMENTED-32WAVE-NEXT:    [[TMP50:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-32WAVE-NEXT:    [[TMP51:%.*]] = zext i32 [[TMP50]] to i64
// SEGMENTED-32WAVE-NEXT:    [[ARRAYIDX9:%.*]] = getelementptr inbounds nuw i32, ptr [[TMP8]], i64 [[TMP51]]
// SEGMENTED-32WAVE-NEXT:    [[TMP52:%.*]] = load i32, ptr addrspace(5) [[TMP9]], align 4
// SEGMENTED-32WAVE-NEXT:    store i32 [[TMP52]], ptr [[TMP4]], align 4
// SEGMENTED-32WAVE-NEXT:    br label [[OMP_AFTER_SCAN_BB:%.*]]
// SEGMENTED-32WAVE:       omp.after.scan.bb:
// SEGMENTED-32WAVE-NEXT:    [[TMP53:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// SEGMENTED-32WAVE-NEXT:    [[IDXPROM10:%.*]] = sext i32 [[TMP53]] to i64
// SEGMENTED-32WAVE-NEXT:    [[ARRAYIDX11:%.*]] = getelementptr inbounds [64000 x i32], ptr [[TMP6]], i64 0, i64 [[IDXPROM10]]
// SEGMENTED-32WAVE-NEXT:    [[TMP54:%.*]] = load i32, ptr addrspace(5) [[TMP9]], align 4
// SEGMENTED-32WAVE-NEXT:    store i32 [[TMP54]], ptr [[ARRAYIDX11]], align 4
// SEGMENTED-32WAVE-NEXT:    br label [[OMP_EXIT_INSCAN_BB:%.*]]
// SEGMENTED-32WAVE:       omp.body.continue:
// SEGMENTED-32WAVE-NEXT:    br label [[FOR_INC:%.*]]
// SEGMENTED-32WAVE:       for.inc:
// SEGMENTED-32WAVE-NEXT:    [[TMP55:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-32WAVE-NEXT:    [[TMP56:%.*]] = getelementptr i32, ptr [[TMP37]], i32 [[TMP55]]
// SEGMENTED-32WAVE-NEXT:    [[TMP57:%.*]] = load i32, ptr addrspace(5) [[TMP9]], align 4
// SEGMENTED-32WAVE-NEXT:    store i32 [[TMP57]], ptr [[TMP56]], align 4
// SEGMENTED-32WAVE-NEXT:    [[TMP58:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-32WAVE-NEXT:    [[TMP59:%.*]] = add i32 1, [[TMP58]]
// SEGMENTED-32WAVE-NEXT:    store i32 [[TMP59]], ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-32WAVE-NEXT:    br label [[FOR_COND]], !llvm.loop [[LOOP15:![0-9]+]]
// SEGMENTED-32WAVE:       for.end:
// SEGMENTED-32WAVE-NEXT:    br label [[OMP_KERNEL_DONE]]
// SEGMENTED-32WAVE:       omp.kernel.done:
// SEGMENTED-32WAVE-NEXT:    ret void
//
//
// SEGMENTED-32WAVE-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l57
// SEGMENTED-32WAVE-SAME: (ptr noalias noundef [[DYN_PTR:%.*]], ptr noundef nonnull align 4 dereferenceable(256000) [[OUT2:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM2:%.*]], ptr noundef nonnull align 4 dereferenceable(256000) [[IN:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM21:%.*]], ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]], ptr noundef [[TMP2:%.*]], ptr noundef [[TMP3:%.*]]) #[[ATTR0]] {
// SEGMENTED-32WAVE-NEXT:  entry:
// SEGMENTED-32WAVE-NEXT:    [[DYN_PTR_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-32WAVE-NEXT:    [[OUT2_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-32WAVE-NEXT:    [[SUM2_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-32WAVE-NEXT:    [[IN_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-32WAVE-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8, addrspace(5)
// SEGMENTED-32WAVE-NEXT:    [[SUM2_ADDR2:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-32WAVE-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-32WAVE-NEXT:    [[DOTADDR3:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-32WAVE-NEXT:    [[DOTADDR4:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-32WAVE-NEXT:    [[DOTADDR5:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-32WAVE-NEXT:    [[I:%.*]] = alloca i32, align 4, addrspace(5)
// SEGMENTED-32WAVE-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4, addrspace(5)
// SEGMENTED-32WAVE-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4, addrspace(5)
// SEGMENTED-32WAVE-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4, addrspace(5)
// SEGMENTED-32WAVE-NEXT:    [[SUM28:%.*]] = alloca i32, align 4, addrspace(5)
// SEGMENTED-32WAVE-NEXT:    [[DYN_PTR_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DYN_PTR_ADDR]] to ptr
// SEGMENTED-32WAVE-NEXT:    [[OUT2_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[OUT2_ADDR]] to ptr
// SEGMENTED-32WAVE-NEXT:    [[SUM2_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM2_ADDR]] to ptr
// SEGMENTED-32WAVE-NEXT:    [[IN_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[IN_ADDR]] to ptr
// SEGMENTED-32WAVE-NEXT:    [[VLA_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[VLA_ADDR]] to ptr
// SEGMENTED-32WAVE-NEXT:    [[SUM2_ADDR2_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM2_ADDR2]] to ptr
// SEGMENTED-32WAVE-NEXT:    [[DOTADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR]] to ptr
// SEGMENTED-32WAVE-NEXT:    [[DOTADDR3_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR3]] to ptr
// SEGMENTED-32WAVE-NEXT:    [[DOTADDR4_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR4]] to ptr
// SEGMENTED-32WAVE-NEXT:    [[DOTADDR5_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR5]] to ptr
// SEGMENTED-32WAVE-NEXT:    [[I_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[I]] to ptr
// SEGMENTED-32WAVE-NEXT:    [[DOTOMP_LB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_LB]] to ptr
// SEGMENTED-32WAVE-NEXT:    [[DOTOMP_UB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_UB]] to ptr
// SEGMENTED-32WAVE-NEXT:    [[DOTOMP_IV_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_IV]] to ptr
// SEGMENTED-32WAVE-NEXT:    [[SUM28_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM28]] to ptr
// SEGMENTED-32WAVE-NEXT:    store ptr [[DYN_PTR]], ptr [[DYN_PTR_ADDR_ASCAST]], align 8
// SEGMENTED-32WAVE-NEXT:    store ptr [[OUT2]], ptr [[OUT2_ADDR_ASCAST]], align 8
// SEGMENTED-32WAVE-NEXT:    store ptr [[SUM2]], ptr [[SUM2_ADDR_ASCAST]], align 8
// SEGMENTED-32WAVE-NEXT:    store ptr [[IN]], ptr [[IN_ADDR_ASCAST]], align 8
// SEGMENTED-32WAVE-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR_ASCAST]], align 8
// SEGMENTED-32WAVE-NEXT:    store ptr [[SUM21]], ptr [[SUM2_ADDR2_ASCAST]], align 8
// SEGMENTED-32WAVE-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR_ASCAST]], align 8
// SEGMENTED-32WAVE-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR3_ASCAST]], align 8
// SEGMENTED-32WAVE-NEXT:    store ptr [[TMP2]], ptr [[DOTADDR4_ASCAST]], align 8
// SEGMENTED-32WAVE-NEXT:    store ptr [[TMP3]], ptr [[DOTADDR5_ASCAST]], align 8
// SEGMENTED-32WAVE-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[OUT2_ADDR_ASCAST]], align 8
// SEGMENTED-32WAVE-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[SUM2_ADDR_ASCAST]], align 8
// SEGMENTED-32WAVE-NEXT:    [[TMP6:%.*]] = load ptr, ptr [[IN_ADDR_ASCAST]], align 8
// SEGMENTED-32WAVE-NEXT:    [[TMP7:%.*]] = load i64, ptr [[VLA_ADDR_ASCAST]], align 8
// SEGMENTED-32WAVE-NEXT:    [[TMP8:%.*]] = load ptr, ptr [[SUM2_ADDR2_ASCAST]], align 8
// SEGMENTED-32WAVE-NEXT:    call void @__kmpc_specialized_kernel_init()
// SEGMENTED-32WAVE-NEXT:    [[TMP9:%.*]] = alloca i32, align 4, addrspace(5)
// SEGMENTED-32WAVE-NEXT:    store i32 0, ptr addrspace(5) [[TMP9]], align 4
// SEGMENTED-32WAVE-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// SEGMENTED-32WAVE-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// SEGMENTED-32WAVE-NEXT:    store i32 0, ptr [[DOTOMP_LB_ASCAST]], align 4
// SEGMENTED-32WAVE-NEXT:    store i32 63999, ptr [[DOTOMP_UB_ASCAST]], align 4
// SEGMENTED-32WAVE-NEXT:    [[TMP10:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// SEGMENTED-32WAVE-NEXT:    store i32 [[TMP10]], ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-32WAVE-NEXT:    [[TMP11:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// SEGMENTED-32WAVE-NEXT:    [[NVPTX_NUM_THREADS:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// SEGMENTED-32WAVE-NEXT:    [[GPU_BLOCK_ID:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// SEGMENTED-32WAVE-NEXT:    [[TMP12:%.*]] = mul i32 [[GPU_BLOCK_ID]], [[NVPTX_NUM_THREADS]]
// SEGMENTED-32WAVE-NEXT:    [[TMP13:%.*]] = add i32 [[TMP12]], [[TMP11]]
// SEGMENTED-32WAVE-NEXT:    [[TMP14:%.*]] = mul i32 [[TMP13]], 1
// SEGMENTED-32WAVE-NEXT:    [[TMP15:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-32WAVE-NEXT:    [[TMP16:%.*]] = add i32 [[TMP14]], [[TMP15]]
// SEGMENTED-32WAVE-NEXT:    [[TMP17:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// SEGMENTED-32WAVE-NEXT:    [[TMP18:%.*]] = zext i32 [[TMP16]] to i64
// SEGMENTED-32WAVE-NEXT:    store i32 [[TMP16]], ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-32WAVE-NEXT:    [[GLOBAL_UPPER_BOUND:%.*]] = load i32, ptr [[DOTOMP_UB_ASCAST]], align 4
// SEGMENTED-32WAVE-NEXT:    [[TMP19:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// SEGMENTED-32WAVE-NEXT:    [[TMP20:%.*]] = sub i32 [[GLOBAL_UPPER_BOUND]], [[TMP19]]
// SEGMENTED-32WAVE-NEXT:    [[TMP21:%.*]] = add i32 [[TMP20]], 1
// SEGMENTED-32WAVE-NEXT:    [[TMP22:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// SEGMENTED-32WAVE-NEXT:    [[NVPTX_NUM_THREADS6:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// SEGMENTED-32WAVE-NEXT:    [[GPU_BLOCK_ID7:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// SEGMENTED-32WAVE-NEXT:    [[TMP23:%.*]] = mul i32 [[GPU_BLOCK_ID7]], [[NVPTX_NUM_THREADS6]]
// SEGMENTED-32WAVE-NEXT:    [[TMP24:%.*]] = add i32 [[TMP23]], [[TMP22]]
// SEGMENTED-32WAVE-NEXT:    [[TMP25:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// SEGMENTED-32WAVE-NEXT:    [[TMP26:%.*]] = mul i32 [[NVPTX_NUM_THREADS6]], [[TMP25]]
// SEGMENTED-32WAVE-NEXT:    [[TMP27:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-32WAVE-NEXT:    [[TMP28:%.*]] = icmp ult i32 [[TMP27]], [[TMP26]]
// SEGMENTED-32WAVE-NEXT:    br i1 [[TMP28]], label [[OMP_KERNEL_BODY:%.*]], label [[OMP_KERNEL_DONE:%.*]]
// SEGMENTED-32WAVE:       omp.kernel.body:
// SEGMENTED-32WAVE-NEXT:    [[TMP29:%.*]] = udiv i32 [[TMP21]], [[TMP26]]
// SEGMENTED-32WAVE-NEXT:    [[PADDED_SEGMENT_SIZE:%.*]] = add i32 [[TMP29]], 1
// SEGMENTED-32WAVE-NEXT:    [[TMP30:%.*]] = mul i32 [[PADDED_SEGMENT_SIZE]], [[TMP24]]
// SEGMENTED-32WAVE-NEXT:    store i32 [[TMP30]], ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-32WAVE-NEXT:    [[TMP31:%.*]] = add i32 [[TMP24]], 1
// SEGMENTED-32WAVE-NEXT:    [[TMP32:%.*]] = mul i32 [[PADDED_SEGMENT_SIZE]], [[TMP31]]
// SEGMENTED-32WAVE-NEXT:    [[TMP33:%.*]] = load ptr, ptr [[DOTADDR5_ASCAST]], align 8
// SEGMENTED-32WAVE-NEXT:    br label [[FOR_COND:%.*]]
// SEGMENTED-32WAVE:       for.cond:
// SEGMENTED-32WAVE-NEXT:    [[TMP34:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-32WAVE-NEXT:    [[TMP35:%.*]] = icmp ult i32 [[TMP34]], [[TMP32]]
// SEGMENTED-32WAVE-NEXT:    [[TMP36:%.*]] = icmp ule i32 [[TMP34]], [[GLOBAL_UPPER_BOUND]]
// SEGMENTED-32WAVE-NEXT:    [[TMP37:%.*]] = and i1 [[TMP36]], [[TMP35]]
// SEGMENTED-32WAVE-NEXT:    br i1 [[TMP37]], label [[FOR_BODY:%.*]], label [[FOR_END:%.*]]
// SEGMENTED-32WAVE:       for.body:
// SEGMENTED-32WAVE-NEXT:    [[TMP38:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-32WAVE-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP38]], 1
// SEGMENTED-32WAVE-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// SEGMENTED-32WAVE-NEXT:    store i32 [[ADD]], ptr [[I_ASCAST]], align 4
// SEGMENTED-32WAVE-NEXT:    store i32 0, ptr [[SUM28_ASCAST]], align 4
// SEGMENTED-32WAVE-NEXT:    br label [[OMP_INSCAN_DISPATCH:%.*]]
// SEGMENTED-32WAVE:       omp.before.scan.bb:
// SEGMENTED-32WAVE-NEXT:    [[TMP39:%.*]] = load i32, ptr [[TMP5]], align 4
// SEGMENTED-32WAVE-NEXT:    [[TMP40:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// SEGMENTED-32WAVE-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP40]] to i64
// SEGMENTED-32WAVE-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [64000 x i32], ptr [[TMP4]], i64 0, i64 [[IDXPROM]]
// SEGMENTED-32WAVE-NEXT:    store i32 [[TMP39]], ptr [[ARRAYIDX]], align 4
// SEGMENTED-32WAVE-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// SEGMENTED-32WAVE:       omp.exit.inscan.bb:
// SEGMENTED-32WAVE-NEXT:    [[TMP41:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-32WAVE-NEXT:    [[TMP42:%.*]] = zext i32 [[TMP41]] to i64
// SEGMENTED-32WAVE-NEXT:    br label [[OMP_BODY_CONTINUE]]
// SEGMENTED-32WAVE:       omp.inscan.dispatch:
// SEGMENTED-32WAVE-NEXT:    br label [[OMP_AFTER_SCAN_BB:%.*]]
// SEGMENTED-32WAVE:       omp.after.scan.bb:
// SEGMENTED-32WAVE-NEXT:    [[TMP43:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// SEGMENTED-32WAVE-NEXT:    [[IDXPROM9:%.*]] = sext i32 [[TMP43]] to i64
// SEGMENTED-32WAVE-NEXT:    [[ARRAYIDX10:%.*]] = getelementptr inbounds [64000 x i32], ptr [[TMP6]], i64 0, i64 [[IDXPROM9]]
// SEGMENTED-32WAVE-NEXT:    [[TMP44:%.*]] = load i32, ptr [[ARRAYIDX10]], align 4
// SEGMENTED-32WAVE-NEXT:    [[TMP45:%.*]] = load i32, ptr addrspace(5) [[TMP9]], align 4
// SEGMENTED-32WAVE-NEXT:    [[TMP46:%.*]] = add i32 [[TMP45]], [[TMP44]]
// SEGMENTED-32WAVE-NEXT:    store i32 [[TMP46]], ptr addrspace(5) [[TMP9]], align 4
// SEGMENTED-32WAVE-NEXT:    br label [[OMP_EXIT_INSCAN_BB:%.*]]
// SEGMENTED-32WAVE:       omp.body.continue:
// SEGMENTED-32WAVE-NEXT:    br label [[FOR_INC:%.*]]
// SEGMENTED-32WAVE:       for.inc:
// SEGMENTED-32WAVE-NEXT:    [[TMP47:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-32WAVE-NEXT:    [[TMP48:%.*]] = getelementptr i32, ptr [[TMP33]], i32 [[TMP47]]
// SEGMENTED-32WAVE-NEXT:    [[TMP49:%.*]] = load i32, ptr addrspace(5) [[TMP9]], align 4
// SEGMENTED-32WAVE-NEXT:    store i32 [[TMP49]], ptr [[TMP48]], align 4
// SEGMENTED-32WAVE-NEXT:    [[TMP50:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-32WAVE-NEXT:    [[TMP51:%.*]] = add i32 1, [[TMP50]]
// SEGMENTED-32WAVE-NEXT:    store i32 [[TMP51]], ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-32WAVE-NEXT:    br label [[FOR_COND]], !llvm.loop [[LOOP16:![0-9]+]]
// SEGMENTED-32WAVE:       for.end:
// SEGMENTED-32WAVE-NEXT:    [[TMP52:%.*]] = load ptr, ptr [[DOTADDR_ASCAST]], align 8
// SEGMENTED-32WAVE-NEXT:    [[TMP53:%.*]] = load ptr, ptr [[DOTADDR3_ASCAST]], align 8
// SEGMENTED-32WAVE-NEXT:    [[TMP54:%.*]] = load ptr, ptr [[DOTADDR4_ASCAST]], align 8
// SEGMENTED-32WAVE-NEXT:    [[TMP55:%.*]] = load i32, ptr addrspace(5) [[TMP9]], align 4
// SEGMENTED-32WAVE-NEXT:    call void @__kmpc_xteams_i_8x32(i32 [[TMP55]], ptr [[TMP54]], ptr [[TMP5]], ptr [[TMP52]], ptr [[TMP53]], ptr @__kmpc_rfun_sum_i, ptr @__kmpc_rfun_sum_lds_i, i32 0, i64 [[TMP18]], i32 [[TMP17]])
// SEGMENTED-32WAVE-NEXT:    br label [[OMP_KERNEL_DONE]]
// SEGMENTED-32WAVE:       omp.kernel.done:
// SEGMENTED-32WAVE-NEXT:    ret void
//
//
// SEGMENTED-32WAVE-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l57_1
// SEGMENTED-32WAVE-SAME: (ptr noalias noundef [[DYN_PTR:%.*]], ptr noundef nonnull align 4 dereferenceable(256000) [[OUT2:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM2:%.*]], ptr noundef nonnull align 4 dereferenceable(256000) [[IN:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM21:%.*]], ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]], ptr noundef [[TMP2:%.*]], ptr noundef [[TMP3:%.*]]) #[[ATTR0]] {
// SEGMENTED-32WAVE-NEXT:  entry:
// SEGMENTED-32WAVE-NEXT:    [[DYN_PTR_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-32WAVE-NEXT:    [[OUT2_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-32WAVE-NEXT:    [[SUM2_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-32WAVE-NEXT:    [[IN_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-32WAVE-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8, addrspace(5)
// SEGMENTED-32WAVE-NEXT:    [[SUM2_ADDR2:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-32WAVE-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-32WAVE-NEXT:    [[DOTADDR3:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-32WAVE-NEXT:    [[DOTADDR4:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-32WAVE-NEXT:    [[DOTADDR5:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-32WAVE-NEXT:    [[I:%.*]] = alloca i32, align 4, addrspace(5)
// SEGMENTED-32WAVE-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4, addrspace(5)
// SEGMENTED-32WAVE-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4, addrspace(5)
// SEGMENTED-32WAVE-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4, addrspace(5)
// SEGMENTED-32WAVE-NEXT:    [[SUM28:%.*]] = alloca i32, align 4, addrspace(5)
// SEGMENTED-32WAVE-NEXT:    [[DYN_PTR_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DYN_PTR_ADDR]] to ptr
// SEGMENTED-32WAVE-NEXT:    [[OUT2_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[OUT2_ADDR]] to ptr
// SEGMENTED-32WAVE-NEXT:    [[SUM2_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM2_ADDR]] to ptr
// SEGMENTED-32WAVE-NEXT:    [[IN_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[IN_ADDR]] to ptr
// SEGMENTED-32WAVE-NEXT:    [[VLA_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[VLA_ADDR]] to ptr
// SEGMENTED-32WAVE-NEXT:    [[SUM2_ADDR2_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM2_ADDR2]] to ptr
// SEGMENTED-32WAVE-NEXT:    [[DOTADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR]] to ptr
// SEGMENTED-32WAVE-NEXT:    [[DOTADDR3_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR3]] to ptr
// SEGMENTED-32WAVE-NEXT:    [[DOTADDR4_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR4]] to ptr
// SEGMENTED-32WAVE-NEXT:    [[DOTADDR5_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR5]] to ptr
// SEGMENTED-32WAVE-NEXT:    [[I_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[I]] to ptr
// SEGMENTED-32WAVE-NEXT:    [[DOTOMP_LB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_LB]] to ptr
// SEGMENTED-32WAVE-NEXT:    [[DOTOMP_UB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_UB]] to ptr
// SEGMENTED-32WAVE-NEXT:    [[DOTOMP_IV_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_IV]] to ptr
// SEGMENTED-32WAVE-NEXT:    [[SUM28_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM28]] to ptr
// SEGMENTED-32WAVE-NEXT:    store ptr [[DYN_PTR]], ptr [[DYN_PTR_ADDR_ASCAST]], align 8
// SEGMENTED-32WAVE-NEXT:    store ptr [[OUT2]], ptr [[OUT2_ADDR_ASCAST]], align 8
// SEGMENTED-32WAVE-NEXT:    store ptr [[SUM2]], ptr [[SUM2_ADDR_ASCAST]], align 8
// SEGMENTED-32WAVE-NEXT:    store ptr [[IN]], ptr [[IN_ADDR_ASCAST]], align 8
// SEGMENTED-32WAVE-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR_ASCAST]], align 8
// SEGMENTED-32WAVE-NEXT:    store ptr [[SUM21]], ptr [[SUM2_ADDR2_ASCAST]], align 8
// SEGMENTED-32WAVE-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR_ASCAST]], align 8
// SEGMENTED-32WAVE-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR3_ASCAST]], align 8
// SEGMENTED-32WAVE-NEXT:    store ptr [[TMP2]], ptr [[DOTADDR4_ASCAST]], align 8
// SEGMENTED-32WAVE-NEXT:    store ptr [[TMP3]], ptr [[DOTADDR5_ASCAST]], align 8
// SEGMENTED-32WAVE-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[OUT2_ADDR_ASCAST]], align 8
// SEGMENTED-32WAVE-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[SUM2_ADDR_ASCAST]], align 8
// SEGMENTED-32WAVE-NEXT:    [[TMP6:%.*]] = load ptr, ptr [[IN_ADDR_ASCAST]], align 8
// SEGMENTED-32WAVE-NEXT:    [[TMP7:%.*]] = load i64, ptr [[VLA_ADDR_ASCAST]], align 8
// SEGMENTED-32WAVE-NEXT:    [[TMP8:%.*]] = load ptr, ptr [[SUM2_ADDR2_ASCAST]], align 8
// SEGMENTED-32WAVE-NEXT:    call void @__kmpc_specialized_kernel_init()
// SEGMENTED-32WAVE-NEXT:    [[TMP9:%.*]] = alloca i32, align 4, addrspace(5)
// SEGMENTED-32WAVE-NEXT:    store i32 0, ptr addrspace(5) [[TMP9]], align 4
// SEGMENTED-32WAVE-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// SEGMENTED-32WAVE-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// SEGMENTED-32WAVE-NEXT:    store i32 0, ptr [[DOTOMP_LB_ASCAST]], align 4
// SEGMENTED-32WAVE-NEXT:    store i32 63999, ptr [[DOTOMP_UB_ASCAST]], align 4
// SEGMENTED-32WAVE-NEXT:    [[TMP10:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// SEGMENTED-32WAVE-NEXT:    store i32 [[TMP10]], ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-32WAVE-NEXT:    [[TMP11:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// SEGMENTED-32WAVE-NEXT:    [[NVPTX_NUM_THREADS:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// SEGMENTED-32WAVE-NEXT:    [[GPU_BLOCK_ID:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// SEGMENTED-32WAVE-NEXT:    [[TMP12:%.*]] = mul i32 [[GPU_BLOCK_ID]], [[NVPTX_NUM_THREADS]]
// SEGMENTED-32WAVE-NEXT:    [[TMP13:%.*]] = add i32 [[TMP12]], [[TMP11]]
// SEGMENTED-32WAVE-NEXT:    [[TMP14:%.*]] = mul i32 [[TMP13]], 1
// SEGMENTED-32WAVE-NEXT:    [[TMP15:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-32WAVE-NEXT:    [[TMP16:%.*]] = add i32 [[TMP14]], [[TMP15]]
// SEGMENTED-32WAVE-NEXT:    [[TMP17:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// SEGMENTED-32WAVE-NEXT:    [[TMP18:%.*]] = zext i32 [[TMP16]] to i64
// SEGMENTED-32WAVE-NEXT:    store i32 [[TMP16]], ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-32WAVE-NEXT:    [[GLOBAL_UPPER_BOUND:%.*]] = load i32, ptr [[DOTOMP_UB_ASCAST]], align 4
// SEGMENTED-32WAVE-NEXT:    [[TMP19:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// SEGMENTED-32WAVE-NEXT:    [[TMP20:%.*]] = sub i32 [[GLOBAL_UPPER_BOUND]], [[TMP19]]
// SEGMENTED-32WAVE-NEXT:    [[TMP21:%.*]] = add i32 [[TMP20]], 1
// SEGMENTED-32WAVE-NEXT:    [[TMP22:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// SEGMENTED-32WAVE-NEXT:    [[NVPTX_NUM_THREADS6:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// SEGMENTED-32WAVE-NEXT:    [[GPU_BLOCK_ID7:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// SEGMENTED-32WAVE-NEXT:    [[TMP23:%.*]] = mul i32 [[GPU_BLOCK_ID7]], [[NVPTX_NUM_THREADS6]]
// SEGMENTED-32WAVE-NEXT:    [[TMP24:%.*]] = add i32 [[TMP23]], [[TMP22]]
// SEGMENTED-32WAVE-NEXT:    [[TMP25:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// SEGMENTED-32WAVE-NEXT:    [[TMP26:%.*]] = mul i32 [[NVPTX_NUM_THREADS6]], [[TMP25]]
// SEGMENTED-32WAVE-NEXT:    [[TMP27:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-32WAVE-NEXT:    [[TMP28:%.*]] = icmp ult i32 [[TMP27]], [[TMP26]]
// SEGMENTED-32WAVE-NEXT:    br i1 [[TMP28]], label [[OMP_KERNEL_BODY:%.*]], label [[OMP_KERNEL_DONE:%.*]]
// SEGMENTED-32WAVE:       omp.kernel.body:
// SEGMENTED-32WAVE-NEXT:    [[TMP29:%.*]] = udiv i32 [[TMP21]], [[TMP26]]
// SEGMENTED-32WAVE-NEXT:    [[PADDED_SEGMENT_SIZE:%.*]] = add i32 [[TMP29]], 1
// SEGMENTED-32WAVE-NEXT:    [[TMP30:%.*]] = load ptr, ptr [[DOTADDR_ASCAST]], align 8
// SEGMENTED-32WAVE-NEXT:    [[TMP31:%.*]] = load ptr, ptr [[DOTADDR4_ASCAST]], align 8
// SEGMENTED-32WAVE-NEXT:    [[TMP32:%.*]] = load ptr, ptr [[DOTADDR5_ASCAST]], align 8
// SEGMENTED-32WAVE-NEXT:    [[TMP33:%.*]] = load i32, ptr addrspace(5) [[TMP9]], align 4
// SEGMENTED-32WAVE-NEXT:    call void @__kmpc_xteams_phase2_i_8x32(ptr [[TMP31]], i32 [[PADDED_SEGMENT_SIZE]], ptr [[TMP30]], ptr [[TMP32]], ptr @__kmpc_rfun_sum_i, i32 0, i64 [[TMP18]], i32 0)
// SEGMENTED-32WAVE-NEXT:    [[TMP34:%.*]] = mul i32 [[PADDED_SEGMENT_SIZE]], [[TMP24]]
// SEGMENTED-32WAVE-NEXT:    store i32 [[TMP34]], ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-32WAVE-NEXT:    [[TMP35:%.*]] = add i32 [[TMP24]], 1
// SEGMENTED-32WAVE-NEXT:    [[TMP36:%.*]] = mul i32 [[PADDED_SEGMENT_SIZE]], [[TMP35]]
// SEGMENTED-32WAVE-NEXT:    [[TMP37:%.*]] = load ptr, ptr [[DOTADDR5_ASCAST]], align 8
// SEGMENTED-32WAVE-NEXT:    br label [[FOR_COND:%.*]]
// SEGMENTED-32WAVE:       for.cond:
// SEGMENTED-32WAVE-NEXT:    [[TMP38:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-32WAVE-NEXT:    [[TMP39:%.*]] = icmp ult i32 [[TMP38]], [[TMP36]]
// SEGMENTED-32WAVE-NEXT:    [[TMP40:%.*]] = icmp ule i32 [[TMP38]], [[GLOBAL_UPPER_BOUND]]
// SEGMENTED-32WAVE-NEXT:    [[TMP41:%.*]] = and i1 [[TMP40]], [[TMP39]]
// SEGMENTED-32WAVE-NEXT:    br i1 [[TMP41]], label [[FOR_BODY:%.*]], label [[FOR_END:%.*]]
// SEGMENTED-32WAVE:       for.body:
// SEGMENTED-32WAVE-NEXT:    [[TMP42:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-32WAVE-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP42]], 1
// SEGMENTED-32WAVE-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// SEGMENTED-32WAVE-NEXT:    store i32 [[ADD]], ptr [[I_ASCAST]], align 4
// SEGMENTED-32WAVE-NEXT:    [[TMP43:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-32WAVE-NEXT:    [[TMP44:%.*]] = getelementptr i32, ptr [[TMP37]], i32 [[TMP43]]
// SEGMENTED-32WAVE-NEXT:    [[TMP45:%.*]] = load i32, ptr [[TMP44]], align 4
// SEGMENTED-32WAVE-NEXT:    store i32 [[TMP45]], ptr addrspace(5) [[TMP9]], align 4
// SEGMENTED-32WAVE-NEXT:    store i32 0, ptr [[SUM28_ASCAST]], align 4
// SEGMENTED-32WAVE-NEXT:    br label [[OMP_INSCAN_DISPATCH:%.*]]
// SEGMENTED-32WAVE:       omp.before.scan.bb:
// SEGMENTED-32WAVE-NEXT:    [[TMP46:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// SEGMENTED-32WAVE-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP46]] to i64
// SEGMENTED-32WAVE-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [64000 x i32], ptr [[TMP4]], i64 0, i64 [[IDXPROM]]
// SEGMENTED-32WAVE-NEXT:    [[TMP47:%.*]] = load i32, ptr addrspace(5) [[TMP9]], align 4
// SEGMENTED-32WAVE-NEXT:    store i32 [[TMP47]], ptr [[ARRAYIDX]], align 4
// SEGMENTED-32WAVE-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// SEGMENTED-32WAVE:       omp.exit.inscan.bb:
// SEGMENTED-32WAVE-NEXT:    br label [[OMP_BODY_CONTINUE]]
// SEGMENTED-32WAVE:       omp.inscan.dispatch:
// SEGMENTED-32WAVE-NEXT:    [[TMP48:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-32WAVE-NEXT:    [[TMP49:%.*]] = zext i32 [[TMP48]] to i64
// SEGMENTED-32WAVE-NEXT:    [[TMP50:%.*]] = icmp eq i64 [[TMP49]], 0
// SEGMENTED-32WAVE-NEXT:    br i1 [[TMP50]], label [[OMP_EXCLUSIVE_COPY_EXIT:%.*]], label [[OMP_EXCLUSIVE_DEC:%.*]]
// SEGMENTED-32WAVE:       omp.exclusive.dec:
// SEGMENTED-32WAVE-NEXT:    [[TMP51:%.*]] = sub nuw i64 [[TMP49]], 1
// SEGMENTED-32WAVE-NEXT:    [[ARRAYIDX9:%.*]] = getelementptr inbounds nuw i32, ptr [[TMP8]], i64 [[TMP51]]
// SEGMENTED-32WAVE-NEXT:    [[TMP52:%.*]] = load i32, ptr addrspace(5) [[TMP9]], align 4
// SEGMENTED-32WAVE-NEXT:    store i32 [[TMP52]], ptr [[TMP5]], align 4
// SEGMENTED-32WAVE-NEXT:    br label [[OMP_EXCLUSIVE_COPY_EXIT]]
// SEGMENTED-32WAVE:       omp.exclusive.copy.exit:
// SEGMENTED-32WAVE-NEXT:    br label [[OMP_BEFORE_SCAN_BB:%.*]]
// SEGMENTED-32WAVE:       omp.after.scan.bb:
// SEGMENTED-32WAVE-NEXT:    [[TMP53:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// SEGMENTED-32WAVE-NEXT:    [[IDXPROM10:%.*]] = sext i32 [[TMP53]] to i64
// SEGMENTED-32WAVE-NEXT:    [[ARRAYIDX11:%.*]] = getelementptr inbounds [64000 x i32], ptr [[TMP6]], i64 0, i64 [[IDXPROM10]]
// SEGMENTED-32WAVE-NEXT:    [[TMP54:%.*]] = load i32, ptr [[ARRAYIDX11]], align 4
// SEGMENTED-32WAVE-NEXT:    [[TMP55:%.*]] = load i32, ptr addrspace(5) [[TMP9]], align 4
// SEGMENTED-32WAVE-NEXT:    [[TMP56:%.*]] = add i32 [[TMP55]], [[TMP54]]
// SEGMENTED-32WAVE-NEXT:    store i32 [[TMP56]], ptr addrspace(5) [[TMP9]], align 4
// SEGMENTED-32WAVE-NEXT:    br label [[OMP_EXIT_INSCAN_BB:%.*]]
// SEGMENTED-32WAVE:       omp.body.continue:
// SEGMENTED-32WAVE-NEXT:    br label [[FOR_INC:%.*]]
// SEGMENTED-32WAVE:       for.inc:
// SEGMENTED-32WAVE-NEXT:    [[TMP57:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-32WAVE-NEXT:    [[TMP58:%.*]] = getelementptr i32, ptr [[TMP37]], i32 [[TMP57]]
// SEGMENTED-32WAVE-NEXT:    [[TMP59:%.*]] = load i32, ptr addrspace(5) [[TMP9]], align 4
// SEGMENTED-32WAVE-NEXT:    store i32 [[TMP59]], ptr [[TMP58]], align 4
// SEGMENTED-32WAVE-NEXT:    [[TMP60:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-32WAVE-NEXT:    [[TMP61:%.*]] = add i32 1, [[TMP60]]
// SEGMENTED-32WAVE-NEXT:    store i32 [[TMP61]], ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-32WAVE-NEXT:    br label [[FOR_COND]], !llvm.loop [[LOOP17:![0-9]+]]
// SEGMENTED-32WAVE:       for.end:
// SEGMENTED-32WAVE-NEXT:    br label [[OMP_KERNEL_DONE]]
// SEGMENTED-32WAVE:       omp.kernel.done:
// SEGMENTED-32WAVE-NEXT:    ret void
//
//
// SEGMENTED-32WAVE-512WGSize-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l47
// SEGMENTED-32WAVE-512WGSize-SAME: (ptr noalias noundef [[DYN_PTR:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM1:%.*]], ptr noundef nonnull align 4 dereferenceable(512000) [[IN:%.*]], ptr noundef nonnull align 4 dereferenceable(512000) [[OUT1:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM11:%.*]], ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]], ptr noundef [[TMP2:%.*]], ptr noundef [[TMP3:%.*]]) #[[ATTR0:[0-9]+]] {
// SEGMENTED-32WAVE-512WGSize-NEXT:  entry:
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[DYN_PTR_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[SUM1_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[IN_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[OUT1_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8, addrspace(5)
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[SUM1_ADDR2:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[DOTADDR3:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[DOTADDR4:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[DOTADDR5:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[I:%.*]] = alloca i32, align 4, addrspace(5)
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4, addrspace(5)
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4, addrspace(5)
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4, addrspace(5)
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[SUM18:%.*]] = alloca i32, align 4, addrspace(5)
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[DYN_PTR_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DYN_PTR_ADDR]] to ptr
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[SUM1_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM1_ADDR]] to ptr
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[IN_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[IN_ADDR]] to ptr
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[OUT1_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[OUT1_ADDR]] to ptr
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[VLA_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[VLA_ADDR]] to ptr
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[SUM1_ADDR2_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM1_ADDR2]] to ptr
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[DOTADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR]] to ptr
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[DOTADDR3_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR3]] to ptr
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[DOTADDR4_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR4]] to ptr
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[DOTADDR5_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR5]] to ptr
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[I_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[I]] to ptr
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[DOTOMP_LB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_LB]] to ptr
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[DOTOMP_UB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_UB]] to ptr
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[DOTOMP_IV_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_IV]] to ptr
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[SUM18_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM18]] to ptr
// SEGMENTED-32WAVE-512WGSize-NEXT:    store ptr [[DYN_PTR]], ptr [[DYN_PTR_ADDR_ASCAST]], align 8
// SEGMENTED-32WAVE-512WGSize-NEXT:    store ptr [[SUM1]], ptr [[SUM1_ADDR_ASCAST]], align 8
// SEGMENTED-32WAVE-512WGSize-NEXT:    store ptr [[IN]], ptr [[IN_ADDR_ASCAST]], align 8
// SEGMENTED-32WAVE-512WGSize-NEXT:    store ptr [[OUT1]], ptr [[OUT1_ADDR_ASCAST]], align 8
// SEGMENTED-32WAVE-512WGSize-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR_ASCAST]], align 8
// SEGMENTED-32WAVE-512WGSize-NEXT:    store ptr [[SUM11]], ptr [[SUM1_ADDR2_ASCAST]], align 8
// SEGMENTED-32WAVE-512WGSize-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR_ASCAST]], align 8
// SEGMENTED-32WAVE-512WGSize-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR3_ASCAST]], align 8
// SEGMENTED-32WAVE-512WGSize-NEXT:    store ptr [[TMP2]], ptr [[DOTADDR4_ASCAST]], align 8
// SEGMENTED-32WAVE-512WGSize-NEXT:    store ptr [[TMP3]], ptr [[DOTADDR5_ASCAST]], align 8
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[SUM1_ADDR_ASCAST]], align 8
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[IN_ADDR_ASCAST]], align 8
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP6:%.*]] = load ptr, ptr [[OUT1_ADDR_ASCAST]], align 8
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP7:%.*]] = load i64, ptr [[VLA_ADDR_ASCAST]], align 8
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP8:%.*]] = load ptr, ptr [[SUM1_ADDR2_ASCAST]], align 8
// SEGMENTED-32WAVE-512WGSize-NEXT:    call void @__kmpc_specialized_kernel_init()
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP9:%.*]] = alloca i32, align 4, addrspace(5)
// SEGMENTED-32WAVE-512WGSize-NEXT:    store i32 0, ptr addrspace(5) [[TMP9]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    store i32 0, ptr [[DOTOMP_LB_ASCAST]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    store i32 127999, ptr [[DOTOMP_UB_ASCAST]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP10:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    store i32 [[TMP10]], ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP11:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[NVPTX_NUM_THREADS:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[GPU_BLOCK_ID:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP12:%.*]] = mul i32 [[GPU_BLOCK_ID]], [[NVPTX_NUM_THREADS]]
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP13:%.*]] = add i32 [[TMP12]], [[TMP11]]
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP14:%.*]] = mul i32 [[TMP13]], 1
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP15:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP16:%.*]] = add i32 [[TMP14]], [[TMP15]]
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP17:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP18:%.*]] = zext i32 [[TMP16]] to i64
// SEGMENTED-32WAVE-512WGSize-NEXT:    store i32 [[TMP16]], ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[GLOBAL_UPPER_BOUND:%.*]] = load i32, ptr [[DOTOMP_UB_ASCAST]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP19:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP20:%.*]] = sub i32 [[GLOBAL_UPPER_BOUND]], [[TMP19]]
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP21:%.*]] = add i32 [[TMP20]], 1
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP22:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[NVPTX_NUM_THREADS6:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[GPU_BLOCK_ID7:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP23:%.*]] = mul i32 [[GPU_BLOCK_ID7]], [[NVPTX_NUM_THREADS6]]
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP24:%.*]] = add i32 [[TMP23]], [[TMP22]]
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP25:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP26:%.*]] = mul i32 [[NVPTX_NUM_THREADS6]], [[TMP25]]
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP27:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP28:%.*]] = icmp ult i32 [[TMP27]], [[TMP26]]
// SEGMENTED-32WAVE-512WGSize-NEXT:    br i1 [[TMP28]], label [[OMP_KERNEL_BODY:%.*]], label [[OMP_KERNEL_DONE:%.*]]
// SEGMENTED-32WAVE-512WGSize:       omp.kernel.body:
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP29:%.*]] = udiv i32 [[TMP21]], [[TMP26]]
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[PADDED_SEGMENT_SIZE:%.*]] = add i32 [[TMP29]], 1
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP30:%.*]] = mul i32 [[PADDED_SEGMENT_SIZE]], [[TMP24]]
// SEGMENTED-32WAVE-512WGSize-NEXT:    store i32 [[TMP30]], ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP31:%.*]] = add i32 [[TMP24]], 1
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP32:%.*]] = mul i32 [[PADDED_SEGMENT_SIZE]], [[TMP31]]
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP33:%.*]] = load ptr, ptr [[DOTADDR5_ASCAST]], align 8
// SEGMENTED-32WAVE-512WGSize-NEXT:    br label [[FOR_COND:%.*]]
// SEGMENTED-32WAVE-512WGSize:       for.cond:
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP34:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP35:%.*]] = icmp ult i32 [[TMP34]], [[TMP32]]
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP36:%.*]] = icmp ule i32 [[TMP34]], [[GLOBAL_UPPER_BOUND]]
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP37:%.*]] = and i1 [[TMP36]], [[TMP35]]
// SEGMENTED-32WAVE-512WGSize-NEXT:    br i1 [[TMP37]], label [[FOR_BODY:%.*]], label [[FOR_END:%.*]]
// SEGMENTED-32WAVE-512WGSize:       for.body:
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP38:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP38]], 1
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// SEGMENTED-32WAVE-512WGSize-NEXT:    store i32 [[ADD]], ptr [[I_ASCAST]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    store i32 0, ptr [[SUM18_ASCAST]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    br label [[OMP_INSCAN_DISPATCH:%.*]]
// SEGMENTED-32WAVE-512WGSize:       omp.before.scan.bb:
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP39:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP39]] to i64
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [128000 x i32], ptr [[TMP5]], i64 0, i64 [[IDXPROM]]
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP40:%.*]] = load i32, ptr [[ARRAYIDX]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP41:%.*]] = load i32, ptr addrspace(5) [[TMP9]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP42:%.*]] = add i32 [[TMP41]], [[TMP40]]
// SEGMENTED-32WAVE-512WGSize-NEXT:    store i32 [[TMP42]], ptr addrspace(5) [[TMP9]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP43:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP44:%.*]] = zext i32 [[TMP43]] to i64
// SEGMENTED-32WAVE-512WGSize-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// SEGMENTED-32WAVE-512WGSize:       omp.exit.inscan.bb:
// SEGMENTED-32WAVE-512WGSize-NEXT:    br label [[OMP_BODY_CONTINUE]]
// SEGMENTED-32WAVE-512WGSize:       omp.inscan.dispatch:
// SEGMENTED-32WAVE-512WGSize-NEXT:    br label [[OMP_BEFORE_SCAN_BB:%.*]]
// SEGMENTED-32WAVE-512WGSize:       omp.after.scan.bb:
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP45:%.*]] = load i32, ptr [[TMP4]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP46:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[IDXPROM9:%.*]] = sext i32 [[TMP46]] to i64
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[ARRAYIDX10:%.*]] = getelementptr inbounds [128000 x i32], ptr [[TMP6]], i64 0, i64 [[IDXPROM9]]
// SEGMENTED-32WAVE-512WGSize-NEXT:    store i32 [[TMP45]], ptr [[ARRAYIDX10]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    br label [[OMP_EXIT_INSCAN_BB:%.*]]
// SEGMENTED-32WAVE-512WGSize:       omp.body.continue:
// SEGMENTED-32WAVE-512WGSize-NEXT:    br label [[FOR_INC:%.*]]
// SEGMENTED-32WAVE-512WGSize:       for.inc:
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP47:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP48:%.*]] = getelementptr i32, ptr [[TMP33]], i32 [[TMP47]]
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP49:%.*]] = load i32, ptr addrspace(5) [[TMP9]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    store i32 [[TMP49]], ptr [[TMP48]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP50:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP51:%.*]] = add i32 1, [[TMP50]]
// SEGMENTED-32WAVE-512WGSize-NEXT:    store i32 [[TMP51]], ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    br label [[FOR_COND]], !llvm.loop [[LOOP13:![0-9]+]]
// SEGMENTED-32WAVE-512WGSize:       for.end:
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP52:%.*]] = load ptr, ptr [[DOTADDR_ASCAST]], align 8
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP53:%.*]] = load ptr, ptr [[DOTADDR3_ASCAST]], align 8
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP54:%.*]] = load ptr, ptr [[DOTADDR4_ASCAST]], align 8
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP55:%.*]] = load i32, ptr addrspace(5) [[TMP9]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    call void @__kmpc_xteams_i_16x32(i32 [[TMP55]], ptr [[TMP54]], ptr [[TMP4]], ptr [[TMP52]], ptr [[TMP53]], ptr @__kmpc_rfun_sum_i, ptr @__kmpc_rfun_sum_lds_i, i32 0, i64 [[TMP18]], i32 [[TMP17]])
// SEGMENTED-32WAVE-512WGSize-NEXT:    br label [[OMP_KERNEL_DONE]]
// SEGMENTED-32WAVE-512WGSize:       omp.kernel.done:
// SEGMENTED-32WAVE-512WGSize-NEXT:    ret void
//
//
// SEGMENTED-32WAVE-512WGSize-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l47_1
// SEGMENTED-32WAVE-512WGSize-SAME: (ptr noalias noundef [[DYN_PTR:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM1:%.*]], ptr noundef nonnull align 4 dereferenceable(512000) [[IN:%.*]], ptr noundef nonnull align 4 dereferenceable(512000) [[OUT1:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM11:%.*]], ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]], ptr noundef [[TMP2:%.*]], ptr noundef [[TMP3:%.*]]) #[[ATTR0]] {
// SEGMENTED-32WAVE-512WGSize-NEXT:  entry:
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[DYN_PTR_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[SUM1_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[IN_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[OUT1_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8, addrspace(5)
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[SUM1_ADDR2:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[DOTADDR3:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[DOTADDR4:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[DOTADDR5:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[I:%.*]] = alloca i32, align 4, addrspace(5)
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4, addrspace(5)
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4, addrspace(5)
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4, addrspace(5)
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[SUM18:%.*]] = alloca i32, align 4, addrspace(5)
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[DYN_PTR_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DYN_PTR_ADDR]] to ptr
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[SUM1_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM1_ADDR]] to ptr
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[IN_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[IN_ADDR]] to ptr
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[OUT1_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[OUT1_ADDR]] to ptr
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[VLA_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[VLA_ADDR]] to ptr
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[SUM1_ADDR2_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM1_ADDR2]] to ptr
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[DOTADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR]] to ptr
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[DOTADDR3_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR3]] to ptr
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[DOTADDR4_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR4]] to ptr
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[DOTADDR5_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR5]] to ptr
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[I_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[I]] to ptr
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[DOTOMP_LB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_LB]] to ptr
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[DOTOMP_UB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_UB]] to ptr
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[DOTOMP_IV_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_IV]] to ptr
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[SUM18_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM18]] to ptr
// SEGMENTED-32WAVE-512WGSize-NEXT:    store ptr [[DYN_PTR]], ptr [[DYN_PTR_ADDR_ASCAST]], align 8
// SEGMENTED-32WAVE-512WGSize-NEXT:    store ptr [[SUM1]], ptr [[SUM1_ADDR_ASCAST]], align 8
// SEGMENTED-32WAVE-512WGSize-NEXT:    store ptr [[IN]], ptr [[IN_ADDR_ASCAST]], align 8
// SEGMENTED-32WAVE-512WGSize-NEXT:    store ptr [[OUT1]], ptr [[OUT1_ADDR_ASCAST]], align 8
// SEGMENTED-32WAVE-512WGSize-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR_ASCAST]], align 8
// SEGMENTED-32WAVE-512WGSize-NEXT:    store ptr [[SUM11]], ptr [[SUM1_ADDR2_ASCAST]], align 8
// SEGMENTED-32WAVE-512WGSize-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR_ASCAST]], align 8
// SEGMENTED-32WAVE-512WGSize-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR3_ASCAST]], align 8
// SEGMENTED-32WAVE-512WGSize-NEXT:    store ptr [[TMP2]], ptr [[DOTADDR4_ASCAST]], align 8
// SEGMENTED-32WAVE-512WGSize-NEXT:    store ptr [[TMP3]], ptr [[DOTADDR5_ASCAST]], align 8
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[SUM1_ADDR_ASCAST]], align 8
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[IN_ADDR_ASCAST]], align 8
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP6:%.*]] = load ptr, ptr [[OUT1_ADDR_ASCAST]], align 8
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP7:%.*]] = load i64, ptr [[VLA_ADDR_ASCAST]], align 8
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP8:%.*]] = load ptr, ptr [[SUM1_ADDR2_ASCAST]], align 8
// SEGMENTED-32WAVE-512WGSize-NEXT:    call void @__kmpc_specialized_kernel_init()
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP9:%.*]] = alloca i32, align 4, addrspace(5)
// SEGMENTED-32WAVE-512WGSize-NEXT:    store i32 0, ptr addrspace(5) [[TMP9]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    store i32 0, ptr [[DOTOMP_LB_ASCAST]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    store i32 127999, ptr [[DOTOMP_UB_ASCAST]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP10:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    store i32 [[TMP10]], ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP11:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[NVPTX_NUM_THREADS:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[GPU_BLOCK_ID:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP12:%.*]] = mul i32 [[GPU_BLOCK_ID]], [[NVPTX_NUM_THREADS]]
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP13:%.*]] = add i32 [[TMP12]], [[TMP11]]
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP14:%.*]] = mul i32 [[TMP13]], 1
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP15:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP16:%.*]] = add i32 [[TMP14]], [[TMP15]]
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP17:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP18:%.*]] = zext i32 [[TMP16]] to i64
// SEGMENTED-32WAVE-512WGSize-NEXT:    store i32 [[TMP16]], ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[GLOBAL_UPPER_BOUND:%.*]] = load i32, ptr [[DOTOMP_UB_ASCAST]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP19:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP20:%.*]] = sub i32 [[GLOBAL_UPPER_BOUND]], [[TMP19]]
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP21:%.*]] = add i32 [[TMP20]], 1
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP22:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[NVPTX_NUM_THREADS6:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[GPU_BLOCK_ID7:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP23:%.*]] = mul i32 [[GPU_BLOCK_ID7]], [[NVPTX_NUM_THREADS6]]
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP24:%.*]] = add i32 [[TMP23]], [[TMP22]]
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP25:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP26:%.*]] = mul i32 [[NVPTX_NUM_THREADS6]], [[TMP25]]
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP27:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP28:%.*]] = icmp ult i32 [[TMP27]], [[TMP26]]
// SEGMENTED-32WAVE-512WGSize-NEXT:    br i1 [[TMP28]], label [[OMP_KERNEL_BODY:%.*]], label [[OMP_KERNEL_DONE:%.*]]
// SEGMENTED-32WAVE-512WGSize:       omp.kernel.body:
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP29:%.*]] = udiv i32 [[TMP21]], [[TMP26]]
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[PADDED_SEGMENT_SIZE:%.*]] = add i32 [[TMP29]], 1
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP30:%.*]] = load ptr, ptr [[DOTADDR_ASCAST]], align 8
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP31:%.*]] = load ptr, ptr [[DOTADDR4_ASCAST]], align 8
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP32:%.*]] = load ptr, ptr [[DOTADDR5_ASCAST]], align 8
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP33:%.*]] = load i32, ptr addrspace(5) [[TMP9]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    call void @__kmpc_xteams_phase2_i_16x32(ptr [[TMP31]], i32 [[PADDED_SEGMENT_SIZE]], ptr [[TMP30]], ptr [[TMP32]], ptr @__kmpc_rfun_sum_i, i32 0, i64 [[TMP18]], i32 1)
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP34:%.*]] = mul i32 [[PADDED_SEGMENT_SIZE]], [[TMP24]]
// SEGMENTED-32WAVE-512WGSize-NEXT:    store i32 [[TMP34]], ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP35:%.*]] = add i32 [[TMP24]], 1
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP36:%.*]] = mul i32 [[PADDED_SEGMENT_SIZE]], [[TMP35]]
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP37:%.*]] = load ptr, ptr [[DOTADDR5_ASCAST]], align 8
// SEGMENTED-32WAVE-512WGSize-NEXT:    br label [[FOR_COND:%.*]]
// SEGMENTED-32WAVE-512WGSize:       for.cond:
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP38:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP39:%.*]] = icmp ult i32 [[TMP38]], [[TMP36]]
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP40:%.*]] = icmp ule i32 [[TMP38]], [[GLOBAL_UPPER_BOUND]]
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP41:%.*]] = and i1 [[TMP40]], [[TMP39]]
// SEGMENTED-32WAVE-512WGSize-NEXT:    br i1 [[TMP41]], label [[FOR_BODY:%.*]], label [[FOR_END:%.*]]
// SEGMENTED-32WAVE-512WGSize:       for.body:
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP42:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP42]], 1
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// SEGMENTED-32WAVE-512WGSize-NEXT:    store i32 [[ADD]], ptr [[I_ASCAST]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP43:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP44:%.*]] = getelementptr i32, ptr [[TMP37]], i32 [[TMP43]]
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP45:%.*]] = load i32, ptr [[TMP44]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    store i32 [[TMP45]], ptr addrspace(5) [[TMP9]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    store i32 0, ptr [[SUM18_ASCAST]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    br label [[OMP_INSCAN_DISPATCH:%.*]]
// SEGMENTED-32WAVE-512WGSize:       omp.before.scan.bb:
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP46:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP46]] to i64
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [128000 x i32], ptr [[TMP5]], i64 0, i64 [[IDXPROM]]
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP47:%.*]] = load i32, ptr [[ARRAYIDX]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP48:%.*]] = load i32, ptr addrspace(5) [[TMP9]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP49:%.*]] = add i32 [[TMP48]], [[TMP47]]
// SEGMENTED-32WAVE-512WGSize-NEXT:    store i32 [[TMP49]], ptr addrspace(5) [[TMP9]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// SEGMENTED-32WAVE-512WGSize:       omp.exit.inscan.bb:
// SEGMENTED-32WAVE-512WGSize-NEXT:    br label [[OMP_BODY_CONTINUE]]
// SEGMENTED-32WAVE-512WGSize:       omp.inscan.dispatch:
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP50:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP51:%.*]] = zext i32 [[TMP50]] to i64
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[ARRAYIDX9:%.*]] = getelementptr inbounds nuw i32, ptr [[TMP8]], i64 [[TMP51]]
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP52:%.*]] = load i32, ptr addrspace(5) [[TMP9]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    store i32 [[TMP52]], ptr [[TMP4]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    br label [[OMP_AFTER_SCAN_BB:%.*]]
// SEGMENTED-32WAVE-512WGSize:       omp.after.scan.bb:
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP53:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[IDXPROM10:%.*]] = sext i32 [[TMP53]] to i64
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[ARRAYIDX11:%.*]] = getelementptr inbounds [128000 x i32], ptr [[TMP6]], i64 0, i64 [[IDXPROM10]]
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP54:%.*]] = load i32, ptr addrspace(5) [[TMP9]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    store i32 [[TMP54]], ptr [[ARRAYIDX11]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    br label [[OMP_EXIT_INSCAN_BB:%.*]]
// SEGMENTED-32WAVE-512WGSize:       omp.body.continue:
// SEGMENTED-32WAVE-512WGSize-NEXT:    br label [[FOR_INC:%.*]]
// SEGMENTED-32WAVE-512WGSize:       for.inc:
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP55:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP56:%.*]] = getelementptr i32, ptr [[TMP37]], i32 [[TMP55]]
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP57:%.*]] = load i32, ptr addrspace(5) [[TMP9]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    store i32 [[TMP57]], ptr [[TMP56]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP58:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP59:%.*]] = add i32 1, [[TMP58]]
// SEGMENTED-32WAVE-512WGSize-NEXT:    store i32 [[TMP59]], ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    br label [[FOR_COND]], !llvm.loop [[LOOP15:![0-9]+]]
// SEGMENTED-32WAVE-512WGSize:       for.end:
// SEGMENTED-32WAVE-512WGSize-NEXT:    br label [[OMP_KERNEL_DONE]]
// SEGMENTED-32WAVE-512WGSize:       omp.kernel.done:
// SEGMENTED-32WAVE-512WGSize-NEXT:    ret void
//
//
// SEGMENTED-32WAVE-512WGSize-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l57
// SEGMENTED-32WAVE-512WGSize-SAME: (ptr noalias noundef [[DYN_PTR:%.*]], ptr noundef nonnull align 4 dereferenceable(512000) [[OUT2:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM2:%.*]], ptr noundef nonnull align 4 dereferenceable(512000) [[IN:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM21:%.*]], ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]], ptr noundef [[TMP2:%.*]], ptr noundef [[TMP3:%.*]]) #[[ATTR0]] {
// SEGMENTED-32WAVE-512WGSize-NEXT:  entry:
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[DYN_PTR_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[OUT2_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[SUM2_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[IN_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8, addrspace(5)
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[SUM2_ADDR2:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[DOTADDR3:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[DOTADDR4:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[DOTADDR5:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[I:%.*]] = alloca i32, align 4, addrspace(5)
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4, addrspace(5)
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4, addrspace(5)
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4, addrspace(5)
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[SUM28:%.*]] = alloca i32, align 4, addrspace(5)
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[DYN_PTR_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DYN_PTR_ADDR]] to ptr
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[OUT2_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[OUT2_ADDR]] to ptr
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[SUM2_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM2_ADDR]] to ptr
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[IN_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[IN_ADDR]] to ptr
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[VLA_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[VLA_ADDR]] to ptr
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[SUM2_ADDR2_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM2_ADDR2]] to ptr
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[DOTADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR]] to ptr
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[DOTADDR3_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR3]] to ptr
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[DOTADDR4_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR4]] to ptr
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[DOTADDR5_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR5]] to ptr
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[I_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[I]] to ptr
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[DOTOMP_LB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_LB]] to ptr
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[DOTOMP_UB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_UB]] to ptr
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[DOTOMP_IV_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_IV]] to ptr
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[SUM28_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM28]] to ptr
// SEGMENTED-32WAVE-512WGSize-NEXT:    store ptr [[DYN_PTR]], ptr [[DYN_PTR_ADDR_ASCAST]], align 8
// SEGMENTED-32WAVE-512WGSize-NEXT:    store ptr [[OUT2]], ptr [[OUT2_ADDR_ASCAST]], align 8
// SEGMENTED-32WAVE-512WGSize-NEXT:    store ptr [[SUM2]], ptr [[SUM2_ADDR_ASCAST]], align 8
// SEGMENTED-32WAVE-512WGSize-NEXT:    store ptr [[IN]], ptr [[IN_ADDR_ASCAST]], align 8
// SEGMENTED-32WAVE-512WGSize-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR_ASCAST]], align 8
// SEGMENTED-32WAVE-512WGSize-NEXT:    store ptr [[SUM21]], ptr [[SUM2_ADDR2_ASCAST]], align 8
// SEGMENTED-32WAVE-512WGSize-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR_ASCAST]], align 8
// SEGMENTED-32WAVE-512WGSize-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR3_ASCAST]], align 8
// SEGMENTED-32WAVE-512WGSize-NEXT:    store ptr [[TMP2]], ptr [[DOTADDR4_ASCAST]], align 8
// SEGMENTED-32WAVE-512WGSize-NEXT:    store ptr [[TMP3]], ptr [[DOTADDR5_ASCAST]], align 8
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[OUT2_ADDR_ASCAST]], align 8
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[SUM2_ADDR_ASCAST]], align 8
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP6:%.*]] = load ptr, ptr [[IN_ADDR_ASCAST]], align 8
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP7:%.*]] = load i64, ptr [[VLA_ADDR_ASCAST]], align 8
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP8:%.*]] = load ptr, ptr [[SUM2_ADDR2_ASCAST]], align 8
// SEGMENTED-32WAVE-512WGSize-NEXT:    call void @__kmpc_specialized_kernel_init()
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP9:%.*]] = alloca i32, align 4, addrspace(5)
// SEGMENTED-32WAVE-512WGSize-NEXT:    store i32 0, ptr addrspace(5) [[TMP9]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    store i32 0, ptr [[DOTOMP_LB_ASCAST]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    store i32 127999, ptr [[DOTOMP_UB_ASCAST]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP10:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    store i32 [[TMP10]], ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP11:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[NVPTX_NUM_THREADS:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[GPU_BLOCK_ID:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP12:%.*]] = mul i32 [[GPU_BLOCK_ID]], [[NVPTX_NUM_THREADS]]
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP13:%.*]] = add i32 [[TMP12]], [[TMP11]]
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP14:%.*]] = mul i32 [[TMP13]], 1
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP15:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP16:%.*]] = add i32 [[TMP14]], [[TMP15]]
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP17:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP18:%.*]] = zext i32 [[TMP16]] to i64
// SEGMENTED-32WAVE-512WGSize-NEXT:    store i32 [[TMP16]], ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[GLOBAL_UPPER_BOUND:%.*]] = load i32, ptr [[DOTOMP_UB_ASCAST]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP19:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP20:%.*]] = sub i32 [[GLOBAL_UPPER_BOUND]], [[TMP19]]
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP21:%.*]] = add i32 [[TMP20]], 1
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP22:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[NVPTX_NUM_THREADS6:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[GPU_BLOCK_ID7:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP23:%.*]] = mul i32 [[GPU_BLOCK_ID7]], [[NVPTX_NUM_THREADS6]]
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP24:%.*]] = add i32 [[TMP23]], [[TMP22]]
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP25:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP26:%.*]] = mul i32 [[NVPTX_NUM_THREADS6]], [[TMP25]]
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP27:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP28:%.*]] = icmp ult i32 [[TMP27]], [[TMP26]]
// SEGMENTED-32WAVE-512WGSize-NEXT:    br i1 [[TMP28]], label [[OMP_KERNEL_BODY:%.*]], label [[OMP_KERNEL_DONE:%.*]]
// SEGMENTED-32WAVE-512WGSize:       omp.kernel.body:
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP29:%.*]] = udiv i32 [[TMP21]], [[TMP26]]
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[PADDED_SEGMENT_SIZE:%.*]] = add i32 [[TMP29]], 1
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP30:%.*]] = mul i32 [[PADDED_SEGMENT_SIZE]], [[TMP24]]
// SEGMENTED-32WAVE-512WGSize-NEXT:    store i32 [[TMP30]], ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP31:%.*]] = add i32 [[TMP24]], 1
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP32:%.*]] = mul i32 [[PADDED_SEGMENT_SIZE]], [[TMP31]]
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP33:%.*]] = load ptr, ptr [[DOTADDR5_ASCAST]], align 8
// SEGMENTED-32WAVE-512WGSize-NEXT:    br label [[FOR_COND:%.*]]
// SEGMENTED-32WAVE-512WGSize:       for.cond:
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP34:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP35:%.*]] = icmp ult i32 [[TMP34]], [[TMP32]]
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP36:%.*]] = icmp ule i32 [[TMP34]], [[GLOBAL_UPPER_BOUND]]
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP37:%.*]] = and i1 [[TMP36]], [[TMP35]]
// SEGMENTED-32WAVE-512WGSize-NEXT:    br i1 [[TMP37]], label [[FOR_BODY:%.*]], label [[FOR_END:%.*]]
// SEGMENTED-32WAVE-512WGSize:       for.body:
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP38:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP38]], 1
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// SEGMENTED-32WAVE-512WGSize-NEXT:    store i32 [[ADD]], ptr [[I_ASCAST]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    store i32 0, ptr [[SUM28_ASCAST]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    br label [[OMP_INSCAN_DISPATCH:%.*]]
// SEGMENTED-32WAVE-512WGSize:       omp.before.scan.bb:
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP39:%.*]] = load i32, ptr [[TMP5]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP40:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP40]] to i64
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [128000 x i32], ptr [[TMP4]], i64 0, i64 [[IDXPROM]]
// SEGMENTED-32WAVE-512WGSize-NEXT:    store i32 [[TMP39]], ptr [[ARRAYIDX]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// SEGMENTED-32WAVE-512WGSize:       omp.exit.inscan.bb:
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP41:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP42:%.*]] = zext i32 [[TMP41]] to i64
// SEGMENTED-32WAVE-512WGSize-NEXT:    br label [[OMP_BODY_CONTINUE]]
// SEGMENTED-32WAVE-512WGSize:       omp.inscan.dispatch:
// SEGMENTED-32WAVE-512WGSize-NEXT:    br label [[OMP_AFTER_SCAN_BB:%.*]]
// SEGMENTED-32WAVE-512WGSize:       omp.after.scan.bb:
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP43:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[IDXPROM9:%.*]] = sext i32 [[TMP43]] to i64
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[ARRAYIDX10:%.*]] = getelementptr inbounds [128000 x i32], ptr [[TMP6]], i64 0, i64 [[IDXPROM9]]
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP44:%.*]] = load i32, ptr [[ARRAYIDX10]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP45:%.*]] = load i32, ptr addrspace(5) [[TMP9]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP46:%.*]] = add i32 [[TMP45]], [[TMP44]]
// SEGMENTED-32WAVE-512WGSize-NEXT:    store i32 [[TMP46]], ptr addrspace(5) [[TMP9]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    br label [[OMP_EXIT_INSCAN_BB:%.*]]
// SEGMENTED-32WAVE-512WGSize:       omp.body.continue:
// SEGMENTED-32WAVE-512WGSize-NEXT:    br label [[FOR_INC:%.*]]
// SEGMENTED-32WAVE-512WGSize:       for.inc:
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP47:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP48:%.*]] = getelementptr i32, ptr [[TMP33]], i32 [[TMP47]]
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP49:%.*]] = load i32, ptr addrspace(5) [[TMP9]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    store i32 [[TMP49]], ptr [[TMP48]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP50:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP51:%.*]] = add i32 1, [[TMP50]]
// SEGMENTED-32WAVE-512WGSize-NEXT:    store i32 [[TMP51]], ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    br label [[FOR_COND]], !llvm.loop [[LOOP16:![0-9]+]]
// SEGMENTED-32WAVE-512WGSize:       for.end:
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP52:%.*]] = load ptr, ptr [[DOTADDR_ASCAST]], align 8
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP53:%.*]] = load ptr, ptr [[DOTADDR3_ASCAST]], align 8
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP54:%.*]] = load ptr, ptr [[DOTADDR4_ASCAST]], align 8
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP55:%.*]] = load i32, ptr addrspace(5) [[TMP9]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    call void @__kmpc_xteams_i_16x32(i32 [[TMP55]], ptr [[TMP54]], ptr [[TMP5]], ptr [[TMP52]], ptr [[TMP53]], ptr @__kmpc_rfun_sum_i, ptr @__kmpc_rfun_sum_lds_i, i32 0, i64 [[TMP18]], i32 [[TMP17]])
// SEGMENTED-32WAVE-512WGSize-NEXT:    br label [[OMP_KERNEL_DONE]]
// SEGMENTED-32WAVE-512WGSize:       omp.kernel.done:
// SEGMENTED-32WAVE-512WGSize-NEXT:    ret void
//
//
// SEGMENTED-32WAVE-512WGSize-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}_main_l57_1
// SEGMENTED-32WAVE-512WGSize-SAME: (ptr noalias noundef [[DYN_PTR:%.*]], ptr noundef nonnull align 4 dereferenceable(512000) [[OUT2:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM2:%.*]], ptr noundef nonnull align 4 dereferenceable(512000) [[IN:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM21:%.*]], ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]], ptr noundef [[TMP2:%.*]], ptr noundef [[TMP3:%.*]]) #[[ATTR0]] {
// SEGMENTED-32WAVE-512WGSize-NEXT:  entry:
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[DYN_PTR_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[OUT2_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[SUM2_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[IN_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8, addrspace(5)
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[SUM2_ADDR2:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[DOTADDR3:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[DOTADDR4:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[DOTADDR5:%.*]] = alloca ptr, align 8, addrspace(5)
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[I:%.*]] = alloca i32, align 4, addrspace(5)
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4, addrspace(5)
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4, addrspace(5)
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4, addrspace(5)
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[SUM28:%.*]] = alloca i32, align 4, addrspace(5)
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[DYN_PTR_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DYN_PTR_ADDR]] to ptr
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[OUT2_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[OUT2_ADDR]] to ptr
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[SUM2_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM2_ADDR]] to ptr
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[IN_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[IN_ADDR]] to ptr
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[VLA_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[VLA_ADDR]] to ptr
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[SUM2_ADDR2_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM2_ADDR2]] to ptr
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[DOTADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR]] to ptr
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[DOTADDR3_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR3]] to ptr
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[DOTADDR4_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR4]] to ptr
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[DOTADDR5_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR5]] to ptr
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[I_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[I]] to ptr
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[DOTOMP_LB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_LB]] to ptr
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[DOTOMP_UB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_UB]] to ptr
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[DOTOMP_IV_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_IV]] to ptr
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[SUM28_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM28]] to ptr
// SEGMENTED-32WAVE-512WGSize-NEXT:    store ptr [[DYN_PTR]], ptr [[DYN_PTR_ADDR_ASCAST]], align 8
// SEGMENTED-32WAVE-512WGSize-NEXT:    store ptr [[OUT2]], ptr [[OUT2_ADDR_ASCAST]], align 8
// SEGMENTED-32WAVE-512WGSize-NEXT:    store ptr [[SUM2]], ptr [[SUM2_ADDR_ASCAST]], align 8
// SEGMENTED-32WAVE-512WGSize-NEXT:    store ptr [[IN]], ptr [[IN_ADDR_ASCAST]], align 8
// SEGMENTED-32WAVE-512WGSize-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR_ASCAST]], align 8
// SEGMENTED-32WAVE-512WGSize-NEXT:    store ptr [[SUM21]], ptr [[SUM2_ADDR2_ASCAST]], align 8
// SEGMENTED-32WAVE-512WGSize-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR_ASCAST]], align 8
// SEGMENTED-32WAVE-512WGSize-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR3_ASCAST]], align 8
// SEGMENTED-32WAVE-512WGSize-NEXT:    store ptr [[TMP2]], ptr [[DOTADDR4_ASCAST]], align 8
// SEGMENTED-32WAVE-512WGSize-NEXT:    store ptr [[TMP3]], ptr [[DOTADDR5_ASCAST]], align 8
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[OUT2_ADDR_ASCAST]], align 8
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[SUM2_ADDR_ASCAST]], align 8
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP6:%.*]] = load ptr, ptr [[IN_ADDR_ASCAST]], align 8
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP7:%.*]] = load i64, ptr [[VLA_ADDR_ASCAST]], align 8
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP8:%.*]] = load ptr, ptr [[SUM2_ADDR2_ASCAST]], align 8
// SEGMENTED-32WAVE-512WGSize-NEXT:    call void @__kmpc_specialized_kernel_init()
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP9:%.*]] = alloca i32, align 4, addrspace(5)
// SEGMENTED-32WAVE-512WGSize-NEXT:    store i32 0, ptr addrspace(5) [[TMP9]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    store i32 0, ptr [[DOTOMP_LB_ASCAST]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    store i32 127999, ptr [[DOTOMP_UB_ASCAST]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP10:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    store i32 [[TMP10]], ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP11:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[NVPTX_NUM_THREADS:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[GPU_BLOCK_ID:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP12:%.*]] = mul i32 [[GPU_BLOCK_ID]], [[NVPTX_NUM_THREADS]]
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP13:%.*]] = add i32 [[TMP12]], [[TMP11]]
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP14:%.*]] = mul i32 [[TMP13]], 1
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP15:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP16:%.*]] = add i32 [[TMP14]], [[TMP15]]
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP17:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP18:%.*]] = zext i32 [[TMP16]] to i64
// SEGMENTED-32WAVE-512WGSize-NEXT:    store i32 [[TMP16]], ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[GLOBAL_UPPER_BOUND:%.*]] = load i32, ptr [[DOTOMP_UB_ASCAST]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP19:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP20:%.*]] = sub i32 [[GLOBAL_UPPER_BOUND]], [[TMP19]]
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP21:%.*]] = add i32 [[TMP20]], 1
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP22:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[NVPTX_NUM_THREADS6:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[GPU_BLOCK_ID7:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP23:%.*]] = mul i32 [[GPU_BLOCK_ID7]], [[NVPTX_NUM_THREADS6]]
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP24:%.*]] = add i32 [[TMP23]], [[TMP22]]
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP25:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP26:%.*]] = mul i32 [[NVPTX_NUM_THREADS6]], [[TMP25]]
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP27:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP28:%.*]] = icmp ult i32 [[TMP27]], [[TMP26]]
// SEGMENTED-32WAVE-512WGSize-NEXT:    br i1 [[TMP28]], label [[OMP_KERNEL_BODY:%.*]], label [[OMP_KERNEL_DONE:%.*]]
// SEGMENTED-32WAVE-512WGSize:       omp.kernel.body:
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP29:%.*]] = udiv i32 [[TMP21]], [[TMP26]]
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[PADDED_SEGMENT_SIZE:%.*]] = add i32 [[TMP29]], 1
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP30:%.*]] = load ptr, ptr [[DOTADDR_ASCAST]], align 8
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP31:%.*]] = load ptr, ptr [[DOTADDR4_ASCAST]], align 8
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP32:%.*]] = load ptr, ptr [[DOTADDR5_ASCAST]], align 8
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP33:%.*]] = load i32, ptr addrspace(5) [[TMP9]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    call void @__kmpc_xteams_phase2_i_16x32(ptr [[TMP31]], i32 [[PADDED_SEGMENT_SIZE]], ptr [[TMP30]], ptr [[TMP32]], ptr @__kmpc_rfun_sum_i, i32 0, i64 [[TMP18]], i32 0)
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP34:%.*]] = mul i32 [[PADDED_SEGMENT_SIZE]], [[TMP24]]
// SEGMENTED-32WAVE-512WGSize-NEXT:    store i32 [[TMP34]], ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP35:%.*]] = add i32 [[TMP24]], 1
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP36:%.*]] = mul i32 [[PADDED_SEGMENT_SIZE]], [[TMP35]]
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP37:%.*]] = load ptr, ptr [[DOTADDR5_ASCAST]], align 8
// SEGMENTED-32WAVE-512WGSize-NEXT:    br label [[FOR_COND:%.*]]
// SEGMENTED-32WAVE-512WGSize:       for.cond:
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP38:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP39:%.*]] = icmp ult i32 [[TMP38]], [[TMP36]]
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP40:%.*]] = icmp ule i32 [[TMP38]], [[GLOBAL_UPPER_BOUND]]
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP41:%.*]] = and i1 [[TMP40]], [[TMP39]]
// SEGMENTED-32WAVE-512WGSize-NEXT:    br i1 [[TMP41]], label [[FOR_BODY:%.*]], label [[FOR_END:%.*]]
// SEGMENTED-32WAVE-512WGSize:       for.body:
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP42:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP42]], 1
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// SEGMENTED-32WAVE-512WGSize-NEXT:    store i32 [[ADD]], ptr [[I_ASCAST]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP43:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP44:%.*]] = getelementptr i32, ptr [[TMP37]], i32 [[TMP43]]
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP45:%.*]] = load i32, ptr [[TMP44]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    store i32 [[TMP45]], ptr addrspace(5) [[TMP9]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    store i32 0, ptr [[SUM28_ASCAST]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    br label [[OMP_INSCAN_DISPATCH:%.*]]
// SEGMENTED-32WAVE-512WGSize:       omp.before.scan.bb:
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP46:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP46]] to i64
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [128000 x i32], ptr [[TMP4]], i64 0, i64 [[IDXPROM]]
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP47:%.*]] = load i32, ptr addrspace(5) [[TMP9]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    store i32 [[TMP47]], ptr [[ARRAYIDX]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// SEGMENTED-32WAVE-512WGSize:       omp.exit.inscan.bb:
// SEGMENTED-32WAVE-512WGSize-NEXT:    br label [[OMP_BODY_CONTINUE]]
// SEGMENTED-32WAVE-512WGSize:       omp.inscan.dispatch:
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP48:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP49:%.*]] = zext i32 [[TMP48]] to i64
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP50:%.*]] = icmp eq i64 [[TMP49]], 0
// SEGMENTED-32WAVE-512WGSize-NEXT:    br i1 [[TMP50]], label [[OMP_EXCLUSIVE_COPY_EXIT:%.*]], label [[OMP_EXCLUSIVE_DEC:%.*]]
// SEGMENTED-32WAVE-512WGSize:       omp.exclusive.dec:
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP51:%.*]] = sub nuw i64 [[TMP49]], 1
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[ARRAYIDX9:%.*]] = getelementptr inbounds nuw i32, ptr [[TMP8]], i64 [[TMP51]]
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP52:%.*]] = load i32, ptr addrspace(5) [[TMP9]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    store i32 [[TMP52]], ptr [[TMP5]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    br label [[OMP_EXCLUSIVE_COPY_EXIT]]
// SEGMENTED-32WAVE-512WGSize:       omp.exclusive.copy.exit:
// SEGMENTED-32WAVE-512WGSize-NEXT:    br label [[OMP_BEFORE_SCAN_BB:%.*]]
// SEGMENTED-32WAVE-512WGSize:       omp.after.scan.bb:
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP53:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[IDXPROM10:%.*]] = sext i32 [[TMP53]] to i64
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[ARRAYIDX11:%.*]] = getelementptr inbounds [128000 x i32], ptr [[TMP6]], i64 0, i64 [[IDXPROM10]]
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP54:%.*]] = load i32, ptr [[ARRAYIDX11]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP55:%.*]] = load i32, ptr addrspace(5) [[TMP9]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP56:%.*]] = add i32 [[TMP55]], [[TMP54]]
// SEGMENTED-32WAVE-512WGSize-NEXT:    store i32 [[TMP56]], ptr addrspace(5) [[TMP9]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    br label [[OMP_EXIT_INSCAN_BB:%.*]]
// SEGMENTED-32WAVE-512WGSize:       omp.body.continue:
// SEGMENTED-32WAVE-512WGSize-NEXT:    br label [[FOR_INC:%.*]]
// SEGMENTED-32WAVE-512WGSize:       for.inc:
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP57:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP58:%.*]] = getelementptr i32, ptr [[TMP37]], i32 [[TMP57]]
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP59:%.*]] = load i32, ptr addrspace(5) [[TMP9]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    store i32 [[TMP59]], ptr [[TMP58]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP60:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    [[TMP61:%.*]] = add i32 1, [[TMP60]]
// SEGMENTED-32WAVE-512WGSize-NEXT:    store i32 [[TMP61]], ptr [[DOTOMP_IV_ASCAST]], align 4
// SEGMENTED-32WAVE-512WGSize-NEXT:    br label [[FOR_COND]], !llvm.loop [[LOOP17:![0-9]+]]
// SEGMENTED-32WAVE-512WGSize:       for.end:
// SEGMENTED-32WAVE-512WGSize-NEXT:    br label [[OMP_KERNEL_DONE]]
// SEGMENTED-32WAVE-512WGSize:       omp.kernel.done:
// SEGMENTED-32WAVE-512WGSize-NEXT:    ret void
//
