// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py UTC_ARGS: --function-signature --include-generated-funcs --replace-value-regex "__omp_offloading_[0-9a-z]+_[0-9a-z]+" "reduction_size[.].+[.]" "pl_cond[.].+[.|,]" --prefix-filecheck-ir-name _

/*---------------------------------------- Test Xteam Segmented Scan ---------------------------------------*/

// RUN: %clang_cc1 -fopenmp -x c++ -std=c++11 -triple x86_64-unknown-unknown -fopenmp-targets=amdgcn-amd-amdhsa -fopenmp-target-ignore-env-vars -fopenmp-assume-no-nested-parallelism -fopenmp-assume-no-thread-state -fopenmp-target-xteam-scan -emit-llvm-bc %s -o %t-ppc-host1.bc
// RUN: %clang_cc1 -target-cpu gfx90a -fopenmp -x c++ -std=c++11 -triple amdgcn-amd-amdhsa -fopenmp-targets=amdgcn-amd-amdhsa -fopenmp-target-ignore-env-vars -fopenmp-assume-no-nested-parallelism -fopenmp-assume-no-thread-state -fopenmp-target-xteam-scan -emit-llvm %s -fopenmp-is-device -fopenmp-host-ir-file-path %t-ppc-host1.bc -o - | FileCheck %s

/*---------------------------------------- Test Xteam No-Loop Scan ---------------------------------------*/

// RUN: %clang_cc1 -fopenmp -x c++ -std=c++11 -triple x86_64-unknown-unknown -fopenmp-targets=amdgcn-amd-amdhsa -fopenmp-target-ignore-env-vars -fopenmp-assume-no-nested-parallelism -fopenmp-assume-no-thread-state -fopenmp-target-xteam-no-loop-scan -emit-llvm-bc %s -o %t-ppc-host1.bc -DNOLOOP
// RUN: %clang_cc1 -target-cpu gfx90a -fopenmp -x c++ -std=c++11 -triple amdgcn-amd-amdhsa -fopenmp-targets=amdgcn-amd-amdhsa -fopenmp-target-ignore-env-vars -fopenmp-assume-no-nested-parallelism -fopenmp-assume-no-thread-state -fopenmp-target-xteam-no-loop-scan -emit-llvm %s -fopenmp-is-device -fopenmp-host-ir-file-path %t-ppc-host1.bc -DNOLOOP -o - | FileCheck %s --check-prefix=NO-LOOP

// expected-no-diagnostics

#include <stdint.h>

#ifdef NOLOOP
#define NUM_TEAMS 100
#define NUM_THREADS 256
#define N NUM_TEAMS * NUM_THREADS
#else
#define N 1000000
#endif

template <typename T>
void run_test()
{
  T sum = T(0);
  T *a = new T[N];
  T *b = new T[N];

#ifdef NOLOOP
  #pragma omp target teams distribute parallel for reduction(inscan, +:sum) map(to: a[0:N]) map(tofrom: b[0:N]) num_teams(NUM_TEAMS) num_threads(NUM_THREADS)
#else
  #pragma omp target teams distribute parallel for reduction(inscan, +:sum) map(to: a[0:N]) map(tofrom: b[0:N])
#endif
  for(int i = 0; i < N; i++) {
    sum += a[i];
    #pragma omp scan inclusive(sum)
    b[i] = sum;
  }

  sum = T(0);
#ifdef NOLOOP
  #pragma omp target teams distribute parallel for reduction(inscan, +:sum) map(to: a[0:N]) map(tofrom: b[0:N]) num_teams(NUM_TEAMS) num_threads(NUM_THREADS)
#else
  #pragma omp target teams distribute parallel for reduction(inscan, +:sum) map(to: a[0:N]) map(tofrom: b[0:N])
#endif
  for(int i = 0; i < N; i++) {
    b[i] = sum;
    #pragma omp scan exclusive(sum)
    sum += a[i];
  }

  delete[] a;
	delete[] b;
}

int main() {
	run_test<int>();
	run_test<uint32_t>();
	run_test<uint64_t>();
	run_test<long>();
	run_test<double>();
	run_test<float>();
  return 0;
}
// CHECK-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z8run_testIiEvv_l35
// CHECK-SAME: (ptr noalias noundef [[DYN_PTR:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM:%.*]], ptr noundef [[A:%.*]], ptr noundef [[B:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM1:%.*]], ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]], ptr noundef [[TMP2:%.*]], ptr noundef [[TMP3:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[DYN_PTR_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[SUM_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[A_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[B_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8, addrspace(5)
// CHECK-NEXT:    [[SUM_ADDR2:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[DOTADDR3:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[DOTADDR4:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[DOTADDR5:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[I:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[SUM8:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[DYN_PTR_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DYN_PTR_ADDR]] to ptr
// CHECK-NEXT:    [[SUM_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM_ADDR]] to ptr
// CHECK-NEXT:    [[A_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[A_ADDR]] to ptr
// CHECK-NEXT:    [[B_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[B_ADDR]] to ptr
// CHECK-NEXT:    [[VLA_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[VLA_ADDR]] to ptr
// CHECK-NEXT:    [[SUM_ADDR2_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM_ADDR2]] to ptr
// CHECK-NEXT:    [[DOTADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR]] to ptr
// CHECK-NEXT:    [[DOTADDR3_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR3]] to ptr
// CHECK-NEXT:    [[DOTADDR4_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR4]] to ptr
// CHECK-NEXT:    [[DOTADDR5_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR5]] to ptr
// CHECK-NEXT:    [[I_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[I]] to ptr
// CHECK-NEXT:    [[DOTOMP_LB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_LB]] to ptr
// CHECK-NEXT:    [[DOTOMP_UB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_UB]] to ptr
// CHECK-NEXT:    [[DOTOMP_IV_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_IV]] to ptr
// CHECK-NEXT:    [[SUM8_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM8]] to ptr
// CHECK-NEXT:    store ptr [[DYN_PTR]], ptr [[DYN_PTR_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[SUM]], ptr [[SUM_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[A]], ptr [[A_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[B]], ptr [[B_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[SUM1]], ptr [[SUM_ADDR2_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR3_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[TMP2]], ptr [[DOTADDR4_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[TMP3]], ptr [[DOTADDR5_ASCAST]], align 8
// CHECK-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[SUM_ADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP5:%.*]] = load i64, ptr [[VLA_ADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP6:%.*]] = load ptr, ptr [[SUM_ADDR2_ASCAST]], align 8
// CHECK-NEXT:    call void @__kmpc_specialized_kernel_init()
// CHECK-NEXT:    [[TMP7:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    store i32 0, ptr addrspace(5) [[TMP7]], align 4
// CHECK-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// CHECK-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// CHECK-NEXT:    store i32 0, ptr [[DOTOMP_LB_ASCAST]], align 4
// CHECK-NEXT:    store i32 999999, ptr [[DOTOMP_UB_ASCAST]], align 4
// CHECK-NEXT:    [[TMP8:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// CHECK-NEXT:    store i32 [[TMP8]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP9:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// CHECK-NEXT:    [[NVPTX_NUM_THREADS:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// CHECK-NEXT:    [[GPU_BLOCK_ID:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// CHECK-NEXT:    [[TMP10:%.*]] = mul i32 [[GPU_BLOCK_ID]], [[NVPTX_NUM_THREADS]]
// CHECK-NEXT:    [[TMP11:%.*]] = add i32 [[TMP10]], [[TMP9]]
// CHECK-NEXT:    [[TMP12:%.*]] = mul i32 [[TMP11]], 1
// CHECK-NEXT:    [[TMP13:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP14:%.*]] = add i32 [[TMP12]], [[TMP13]]
// CHECK-NEXT:    [[TMP15:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// CHECK-NEXT:    [[TMP16:%.*]] = zext i32 [[TMP14]] to i64
// CHECK-NEXT:    store i32 [[TMP14]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[GLOBAL_UPPER_BOUND:%.*]] = load i32, ptr [[DOTOMP_UB_ASCAST]], align 4
// CHECK-NEXT:    [[TMP17:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// CHECK-NEXT:    [[TMP18:%.*]] = sub i32 [[GLOBAL_UPPER_BOUND]], [[TMP17]]
// CHECK-NEXT:    [[TMP19:%.*]] = add i32 [[TMP18]], 1
// CHECK-NEXT:    [[TMP20:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// CHECK-NEXT:    [[NVPTX_NUM_THREADS6:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// CHECK-NEXT:    [[GPU_BLOCK_ID7:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// CHECK-NEXT:    [[TMP21:%.*]] = mul i32 [[GPU_BLOCK_ID7]], [[NVPTX_NUM_THREADS6]]
// CHECK-NEXT:    [[TMP22:%.*]] = add i32 [[TMP21]], [[TMP20]]
// CHECK-NEXT:    [[TMP23:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// CHECK-NEXT:    [[TMP24:%.*]] = mul i32 [[NVPTX_NUM_THREADS6]], [[TMP23]]
// CHECK-NEXT:    [[TMP25:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP26:%.*]] = icmp ult i32 [[TMP25]], [[TMP24]]
// CHECK-NEXT:    br i1 [[TMP26]], label [[OMP_KERNEL_BODY:%.*]], label [[OMP_KERNEL_DONE:%.*]]
// CHECK:       omp.kernel.body:
// CHECK-NEXT:    [[TMP27:%.*]] = udiv i32 [[TMP19]], [[TMP24]]
// CHECK-NEXT:    [[PADDED_SEGMENT_SIZE:%.*]] = add i32 [[TMP27]], 1
// CHECK-NEXT:    [[TMP28:%.*]] = mul i32 [[PADDED_SEGMENT_SIZE]], [[TMP22]]
// CHECK-NEXT:    store i32 [[TMP28]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP29:%.*]] = add i32 [[TMP22]], 1
// CHECK-NEXT:    [[TMP30:%.*]] = mul i32 [[PADDED_SEGMENT_SIZE]], [[TMP29]]
// CHECK-NEXT:    [[TMP31:%.*]] = load ptr, ptr [[DOTADDR5_ASCAST]], align 8
// CHECK-NEXT:    br label [[FOR_COND:%.*]]
// CHECK:       for.cond:
// CHECK-NEXT:    [[TMP32:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP33:%.*]] = icmp ult i32 [[TMP32]], [[TMP30]]
// CHECK-NEXT:    [[TMP34:%.*]] = icmp ule i32 [[TMP32]], [[GLOBAL_UPPER_BOUND]]
// CHECK-NEXT:    [[TMP35:%.*]] = and i1 [[TMP34]], [[TMP33]]
// CHECK-NEXT:    br i1 [[TMP35]], label [[FOR_BODY:%.*]], label [[FOR_END:%.*]]
// CHECK:       for.body:
// CHECK-NEXT:    [[TMP36:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP36]], 1
// CHECK-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK-NEXT:    store i32 [[ADD]], ptr [[I_ASCAST]], align 4
// CHECK-NEXT:    store i32 0, ptr [[SUM8_ASCAST]], align 4
// CHECK-NEXT:    br label [[OMP_INSCAN_DISPATCH:%.*]]
// CHECK:       omp.before.scan.bb:
// CHECK-NEXT:    [[TMP37:%.*]] = load ptr, ptr [[A_ADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP38:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// CHECK-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP38]] to i64
// CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, ptr [[TMP37]], i64 [[IDXPROM]]
// CHECK-NEXT:    [[TMP39:%.*]] = load i32, ptr [[ARRAYIDX]], align 4
// CHECK-NEXT:    [[TMP40:%.*]] = load i32, ptr addrspace(5) [[TMP7]], align 4
// CHECK-NEXT:    [[TMP41:%.*]] = add i32 [[TMP40]], [[TMP39]]
// CHECK-NEXT:    store i32 [[TMP41]], ptr addrspace(5) [[TMP7]], align 4
// CHECK-NEXT:    [[TMP42:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP43:%.*]] = zext i32 [[TMP42]] to i64
// CHECK-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK:       omp.exit.inscan.bb:
// CHECK-NEXT:    br label [[OMP_BODY_CONTINUE]]
// CHECK:       omp.inscan.dispatch:
// CHECK-NEXT:    br label [[OMP_BEFORE_SCAN_BB:%.*]]
// CHECK:       omp.after.scan.bb:
// CHECK-NEXT:    [[TMP44:%.*]] = load i32, ptr [[TMP4]], align 4
// CHECK-NEXT:    [[TMP45:%.*]] = load ptr, ptr [[B_ADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP46:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// CHECK-NEXT:    [[IDXPROM9:%.*]] = sext i32 [[TMP46]] to i64
// CHECK-NEXT:    [[ARRAYIDX10:%.*]] = getelementptr inbounds i32, ptr [[TMP45]], i64 [[IDXPROM9]]
// CHECK-NEXT:    store i32 [[TMP44]], ptr [[ARRAYIDX10]], align 4
// CHECK-NEXT:    br label [[OMP_EXIT_INSCAN_BB:%.*]]
// CHECK:       omp.body.continue:
// CHECK-NEXT:    br label [[FOR_INC:%.*]]
// CHECK:       for.inc:
// CHECK-NEXT:    [[TMP47:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP48:%.*]] = getelementptr i32, ptr [[TMP31]], i32 [[TMP47]]
// CHECK-NEXT:    [[TMP49:%.*]] = load i32, ptr addrspace(5) [[TMP7]], align 4
// CHECK-NEXT:    store i32 [[TMP49]], ptr [[TMP48]], align 4
// CHECK-NEXT:    [[TMP50:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP51:%.*]] = add i32 1, [[TMP50]]
// CHECK-NEXT:    store i32 [[TMP51]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    br label [[FOR_COND]], !llvm.loop [[LOOP49:![0-9]+]]
// CHECK:       for.end:
// CHECK-NEXT:    [[TMP52:%.*]] = load ptr, ptr [[DOTADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP53:%.*]] = load ptr, ptr [[DOTADDR3_ASCAST]], align 8
// CHECK-NEXT:    [[TMP54:%.*]] = load ptr, ptr [[DOTADDR4_ASCAST]], align 8
// CHECK-NEXT:    [[TMP55:%.*]] = load i32, ptr addrspace(5) [[TMP7]], align 4
// CHECK-NEXT:    call void @__kmpc_xteams_i_16x64(i32 [[TMP55]], ptr [[TMP54]], ptr [[TMP4]], ptr [[TMP52]], ptr [[TMP53]], ptr @__kmpc_rfun_sum_i, ptr @__kmpc_rfun_sum_lds_i, i32 0, i64 [[TMP16]], i32 [[TMP15]])
// CHECK-NEXT:    br label [[OMP_KERNEL_DONE]]
// CHECK:       omp.kernel.done:
// CHECK-NEXT:    ret void
//
//
// CHECK-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z8run_testIiEvv_l35_1
// CHECK-SAME: (ptr noalias noundef [[DYN_PTR:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM:%.*]], ptr noundef [[A:%.*]], ptr noundef [[B:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM1:%.*]], ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]], ptr noundef [[TMP2:%.*]], ptr noundef [[TMP3:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[DYN_PTR_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[SUM_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[A_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[B_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8, addrspace(5)
// CHECK-NEXT:    [[SUM_ADDR2:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[DOTADDR3:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[DOTADDR4:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[DOTADDR5:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[I:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[SUM8:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[DYN_PTR_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DYN_PTR_ADDR]] to ptr
// CHECK-NEXT:    [[SUM_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM_ADDR]] to ptr
// CHECK-NEXT:    [[A_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[A_ADDR]] to ptr
// CHECK-NEXT:    [[B_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[B_ADDR]] to ptr
// CHECK-NEXT:    [[VLA_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[VLA_ADDR]] to ptr
// CHECK-NEXT:    [[SUM_ADDR2_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM_ADDR2]] to ptr
// CHECK-NEXT:    [[DOTADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR]] to ptr
// CHECK-NEXT:    [[DOTADDR3_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR3]] to ptr
// CHECK-NEXT:    [[DOTADDR4_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR4]] to ptr
// CHECK-NEXT:    [[DOTADDR5_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR5]] to ptr
// CHECK-NEXT:    [[I_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[I]] to ptr
// CHECK-NEXT:    [[DOTOMP_LB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_LB]] to ptr
// CHECK-NEXT:    [[DOTOMP_UB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_UB]] to ptr
// CHECK-NEXT:    [[DOTOMP_IV_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_IV]] to ptr
// CHECK-NEXT:    [[SUM8_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM8]] to ptr
// CHECK-NEXT:    store ptr [[DYN_PTR]], ptr [[DYN_PTR_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[SUM]], ptr [[SUM_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[A]], ptr [[A_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[B]], ptr [[B_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[SUM1]], ptr [[SUM_ADDR2_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR3_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[TMP2]], ptr [[DOTADDR4_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[TMP3]], ptr [[DOTADDR5_ASCAST]], align 8
// CHECK-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[SUM_ADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP5:%.*]] = load i64, ptr [[VLA_ADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP6:%.*]] = load ptr, ptr [[SUM_ADDR2_ASCAST]], align 8
// CHECK-NEXT:    call void @__kmpc_specialized_kernel_init()
// CHECK-NEXT:    [[TMP7:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    store i32 0, ptr addrspace(5) [[TMP7]], align 4
// CHECK-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// CHECK-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// CHECK-NEXT:    store i32 0, ptr [[DOTOMP_LB_ASCAST]], align 4
// CHECK-NEXT:    store i32 999999, ptr [[DOTOMP_UB_ASCAST]], align 4
// CHECK-NEXT:    [[TMP8:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// CHECK-NEXT:    store i32 [[TMP8]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP9:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// CHECK-NEXT:    [[NVPTX_NUM_THREADS:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// CHECK-NEXT:    [[GPU_BLOCK_ID:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// CHECK-NEXT:    [[TMP10:%.*]] = mul i32 [[GPU_BLOCK_ID]], [[NVPTX_NUM_THREADS]]
// CHECK-NEXT:    [[TMP11:%.*]] = add i32 [[TMP10]], [[TMP9]]
// CHECK-NEXT:    [[TMP12:%.*]] = mul i32 [[TMP11]], 1
// CHECK-NEXT:    [[TMP13:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP14:%.*]] = add i32 [[TMP12]], [[TMP13]]
// CHECK-NEXT:    [[TMP15:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// CHECK-NEXT:    [[TMP16:%.*]] = zext i32 [[TMP14]] to i64
// CHECK-NEXT:    store i32 [[TMP14]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[GLOBAL_UPPER_BOUND:%.*]] = load i32, ptr [[DOTOMP_UB_ASCAST]], align 4
// CHECK-NEXT:    [[TMP17:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// CHECK-NEXT:    [[TMP18:%.*]] = sub i32 [[GLOBAL_UPPER_BOUND]], [[TMP17]]
// CHECK-NEXT:    [[TMP19:%.*]] = add i32 [[TMP18]], 1
// CHECK-NEXT:    [[TMP20:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// CHECK-NEXT:    [[NVPTX_NUM_THREADS6:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// CHECK-NEXT:    [[GPU_BLOCK_ID7:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// CHECK-NEXT:    [[TMP21:%.*]] = mul i32 [[GPU_BLOCK_ID7]], [[NVPTX_NUM_THREADS6]]
// CHECK-NEXT:    [[TMP22:%.*]] = add i32 [[TMP21]], [[TMP20]]
// CHECK-NEXT:    [[TMP23:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// CHECK-NEXT:    [[TMP24:%.*]] = mul i32 [[NVPTX_NUM_THREADS6]], [[TMP23]]
// CHECK-NEXT:    [[TMP25:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP26:%.*]] = icmp ult i32 [[TMP25]], [[TMP24]]
// CHECK-NEXT:    br i1 [[TMP26]], label [[OMP_KERNEL_BODY:%.*]], label [[OMP_KERNEL_DONE:%.*]]
// CHECK:       omp.kernel.body:
// CHECK-NEXT:    [[TMP27:%.*]] = udiv i32 [[TMP19]], [[TMP24]]
// CHECK-NEXT:    [[PADDED_SEGMENT_SIZE:%.*]] = add i32 [[TMP27]], 1
// CHECK-NEXT:    [[TMP28:%.*]] = load ptr, ptr [[DOTADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP29:%.*]] = load ptr, ptr [[DOTADDR4_ASCAST]], align 8
// CHECK-NEXT:    [[TMP30:%.*]] = load ptr, ptr [[DOTADDR5_ASCAST]], align 8
// CHECK-NEXT:    [[TMP31:%.*]] = load i32, ptr addrspace(5) [[TMP7]], align 4
// CHECK-NEXT:    call void @__kmpc_xteams_phase2_i_16x64(ptr [[TMP29]], i32 [[PADDED_SEGMENT_SIZE]], ptr [[TMP28]], ptr [[TMP30]], ptr @__kmpc_rfun_sum_i, i32 0, i64 [[TMP16]], i32 1)
// CHECK-NEXT:    [[TMP32:%.*]] = mul i32 [[PADDED_SEGMENT_SIZE]], [[TMP22]]
// CHECK-NEXT:    store i32 [[TMP32]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP33:%.*]] = add i32 [[TMP22]], 1
// CHECK-NEXT:    [[TMP34:%.*]] = mul i32 [[PADDED_SEGMENT_SIZE]], [[TMP33]]
// CHECK-NEXT:    [[TMP35:%.*]] = load ptr, ptr [[DOTADDR5_ASCAST]], align 8
// CHECK-NEXT:    br label [[FOR_COND:%.*]]
// CHECK:       for.cond:
// CHECK-NEXT:    [[TMP36:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP37:%.*]] = icmp ult i32 [[TMP36]], [[TMP34]]
// CHECK-NEXT:    [[TMP38:%.*]] = icmp ule i32 [[TMP36]], [[GLOBAL_UPPER_BOUND]]
// CHECK-NEXT:    [[TMP39:%.*]] = and i1 [[TMP38]], [[TMP37]]
// CHECK-NEXT:    br i1 [[TMP39]], label [[FOR_BODY:%.*]], label [[FOR_END:%.*]]
// CHECK:       for.body:
// CHECK-NEXT:    [[TMP40:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP40]], 1
// CHECK-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK-NEXT:    store i32 [[ADD]], ptr [[I_ASCAST]], align 4
// CHECK-NEXT:    [[TMP41:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP42:%.*]] = getelementptr i32, ptr [[TMP35]], i32 [[TMP41]]
// CHECK-NEXT:    [[TMP43:%.*]] = load i32, ptr [[TMP42]], align 4
// CHECK-NEXT:    store i32 [[TMP43]], ptr addrspace(5) [[TMP7]], align 4
// CHECK-NEXT:    store i32 0, ptr [[SUM8_ASCAST]], align 4
// CHECK-NEXT:    br label [[OMP_INSCAN_DISPATCH:%.*]]
// CHECK:       omp.before.scan.bb:
// CHECK-NEXT:    [[TMP44:%.*]] = load ptr, ptr [[A_ADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP45:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// CHECK-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP45]] to i64
// CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, ptr [[TMP44]], i64 [[IDXPROM]]
// CHECK-NEXT:    [[TMP46:%.*]] = load i32, ptr [[ARRAYIDX]], align 4
// CHECK-NEXT:    [[TMP47:%.*]] = load i32, ptr addrspace(5) [[TMP7]], align 4
// CHECK-NEXT:    [[TMP48:%.*]] = add i32 [[TMP47]], [[TMP46]]
// CHECK-NEXT:    store i32 [[TMP48]], ptr addrspace(5) [[TMP7]], align 4
// CHECK-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK:       omp.exit.inscan.bb:
// CHECK-NEXT:    br label [[OMP_BODY_CONTINUE]]
// CHECK:       omp.inscan.dispatch:
// CHECK-NEXT:    [[TMP49:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP50:%.*]] = zext i32 [[TMP49]] to i64
// CHECK-NEXT:    [[ARRAYIDX9:%.*]] = getelementptr inbounds nuw i32, ptr [[TMP6]], i64 [[TMP50]]
// CHECK-NEXT:    [[TMP51:%.*]] = load i32, ptr addrspace(5) [[TMP7]], align 4
// CHECK-NEXT:    store i32 [[TMP51]], ptr [[TMP4]], align 4
// CHECK-NEXT:    br label [[OMP_AFTER_SCAN_BB:%.*]]
// CHECK:       omp.after.scan.bb:
// CHECK-NEXT:    [[TMP52:%.*]] = load ptr, ptr [[B_ADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP53:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// CHECK-NEXT:    [[IDXPROM10:%.*]] = sext i32 [[TMP53]] to i64
// CHECK-NEXT:    [[ARRAYIDX11:%.*]] = getelementptr inbounds i32, ptr [[TMP52]], i64 [[IDXPROM10]]
// CHECK-NEXT:    [[TMP54:%.*]] = load i32, ptr addrspace(5) [[TMP7]], align 4
// CHECK-NEXT:    store i32 [[TMP54]], ptr [[ARRAYIDX11]], align 4
// CHECK-NEXT:    br label [[OMP_EXIT_INSCAN_BB:%.*]]
// CHECK:       omp.body.continue:
// CHECK-NEXT:    br label [[FOR_INC:%.*]]
// CHECK:       for.inc:
// CHECK-NEXT:    [[TMP55:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP56:%.*]] = getelementptr i32, ptr [[TMP35]], i32 [[TMP55]]
// CHECK-NEXT:    [[TMP57:%.*]] = load i32, ptr addrspace(5) [[TMP7]], align 4
// CHECK-NEXT:    store i32 [[TMP57]], ptr [[TMP56]], align 4
// CHECK-NEXT:    [[TMP58:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP59:%.*]] = add i32 1, [[TMP58]]
// CHECK-NEXT:    store i32 [[TMP59]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    br label [[FOR_COND]], !llvm.loop [[LOOP51:![0-9]+]]
// CHECK:       for.end:
// CHECK-NEXT:    br label [[OMP_KERNEL_DONE]]
// CHECK:       omp.kernel.done:
// CHECK-NEXT:    ret void
//
//
// CHECK-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z8run_testIiEvv_l47
// CHECK-SAME: (ptr noalias noundef [[DYN_PTR:%.*]], ptr noundef [[B:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM:%.*]], ptr noundef [[A:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM1:%.*]], ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]], ptr noundef [[TMP2:%.*]], ptr noundef [[TMP3:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[DYN_PTR_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[B_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[SUM_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[A_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8, addrspace(5)
// CHECK-NEXT:    [[SUM_ADDR2:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[DOTADDR3:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[DOTADDR4:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[DOTADDR5:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[I:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[SUM8:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[DYN_PTR_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DYN_PTR_ADDR]] to ptr
// CHECK-NEXT:    [[B_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[B_ADDR]] to ptr
// CHECK-NEXT:    [[SUM_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM_ADDR]] to ptr
// CHECK-NEXT:    [[A_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[A_ADDR]] to ptr
// CHECK-NEXT:    [[VLA_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[VLA_ADDR]] to ptr
// CHECK-NEXT:    [[SUM_ADDR2_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM_ADDR2]] to ptr
// CHECK-NEXT:    [[DOTADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR]] to ptr
// CHECK-NEXT:    [[DOTADDR3_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR3]] to ptr
// CHECK-NEXT:    [[DOTADDR4_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR4]] to ptr
// CHECK-NEXT:    [[DOTADDR5_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR5]] to ptr
// CHECK-NEXT:    [[I_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[I]] to ptr
// CHECK-NEXT:    [[DOTOMP_LB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_LB]] to ptr
// CHECK-NEXT:    [[DOTOMP_UB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_UB]] to ptr
// CHECK-NEXT:    [[DOTOMP_IV_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_IV]] to ptr
// CHECK-NEXT:    [[SUM8_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM8]] to ptr
// CHECK-NEXT:    store ptr [[DYN_PTR]], ptr [[DYN_PTR_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[B]], ptr [[B_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[SUM]], ptr [[SUM_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[A]], ptr [[A_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[SUM1]], ptr [[SUM_ADDR2_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR3_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[TMP2]], ptr [[DOTADDR4_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[TMP3]], ptr [[DOTADDR5_ASCAST]], align 8
// CHECK-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[SUM_ADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP5:%.*]] = load i64, ptr [[VLA_ADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP6:%.*]] = load ptr, ptr [[SUM_ADDR2_ASCAST]], align 8
// CHECK-NEXT:    call void @__kmpc_specialized_kernel_init()
// CHECK-NEXT:    [[TMP7:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    store i32 0, ptr addrspace(5) [[TMP7]], align 4
// CHECK-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// CHECK-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// CHECK-NEXT:    store i32 0, ptr [[DOTOMP_LB_ASCAST]], align 4
// CHECK-NEXT:    store i32 999999, ptr [[DOTOMP_UB_ASCAST]], align 4
// CHECK-NEXT:    [[TMP8:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// CHECK-NEXT:    store i32 [[TMP8]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP9:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// CHECK-NEXT:    [[NVPTX_NUM_THREADS:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// CHECK-NEXT:    [[GPU_BLOCK_ID:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// CHECK-NEXT:    [[TMP10:%.*]] = mul i32 [[GPU_BLOCK_ID]], [[NVPTX_NUM_THREADS]]
// CHECK-NEXT:    [[TMP11:%.*]] = add i32 [[TMP10]], [[TMP9]]
// CHECK-NEXT:    [[TMP12:%.*]] = mul i32 [[TMP11]], 1
// CHECK-NEXT:    [[TMP13:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP14:%.*]] = add i32 [[TMP12]], [[TMP13]]
// CHECK-NEXT:    [[TMP15:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// CHECK-NEXT:    [[TMP16:%.*]] = zext i32 [[TMP14]] to i64
// CHECK-NEXT:    store i32 [[TMP14]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[GLOBAL_UPPER_BOUND:%.*]] = load i32, ptr [[DOTOMP_UB_ASCAST]], align 4
// CHECK-NEXT:    [[TMP17:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// CHECK-NEXT:    [[TMP18:%.*]] = sub i32 [[GLOBAL_UPPER_BOUND]], [[TMP17]]
// CHECK-NEXT:    [[TMP19:%.*]] = add i32 [[TMP18]], 1
// CHECK-NEXT:    [[TMP20:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// CHECK-NEXT:    [[NVPTX_NUM_THREADS6:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// CHECK-NEXT:    [[GPU_BLOCK_ID7:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// CHECK-NEXT:    [[TMP21:%.*]] = mul i32 [[GPU_BLOCK_ID7]], [[NVPTX_NUM_THREADS6]]
// CHECK-NEXT:    [[TMP22:%.*]] = add i32 [[TMP21]], [[TMP20]]
// CHECK-NEXT:    [[TMP23:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// CHECK-NEXT:    [[TMP24:%.*]] = mul i32 [[NVPTX_NUM_THREADS6]], [[TMP23]]
// CHECK-NEXT:    [[TMP25:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP26:%.*]] = icmp ult i32 [[TMP25]], [[TMP24]]
// CHECK-NEXT:    br i1 [[TMP26]], label [[OMP_KERNEL_BODY:%.*]], label [[OMP_KERNEL_DONE:%.*]]
// CHECK:       omp.kernel.body:
// CHECK-NEXT:    [[TMP27:%.*]] = udiv i32 [[TMP19]], [[TMP24]]
// CHECK-NEXT:    [[PADDED_SEGMENT_SIZE:%.*]] = add i32 [[TMP27]], 1
// CHECK-NEXT:    [[TMP28:%.*]] = mul i32 [[PADDED_SEGMENT_SIZE]], [[TMP22]]
// CHECK-NEXT:    store i32 [[TMP28]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP29:%.*]] = add i32 [[TMP22]], 1
// CHECK-NEXT:    [[TMP30:%.*]] = mul i32 [[PADDED_SEGMENT_SIZE]], [[TMP29]]
// CHECK-NEXT:    [[TMP31:%.*]] = load ptr, ptr [[DOTADDR5_ASCAST]], align 8
// CHECK-NEXT:    br label [[FOR_COND:%.*]]
// CHECK:       for.cond:
// CHECK-NEXT:    [[TMP32:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP33:%.*]] = icmp ult i32 [[TMP32]], [[TMP30]]
// CHECK-NEXT:    [[TMP34:%.*]] = icmp ule i32 [[TMP32]], [[GLOBAL_UPPER_BOUND]]
// CHECK-NEXT:    [[TMP35:%.*]] = and i1 [[TMP34]], [[TMP33]]
// CHECK-NEXT:    br i1 [[TMP35]], label [[FOR_BODY:%.*]], label [[FOR_END:%.*]]
// CHECK:       for.body:
// CHECK-NEXT:    [[TMP36:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP36]], 1
// CHECK-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK-NEXT:    store i32 [[ADD]], ptr [[I_ASCAST]], align 4
// CHECK-NEXT:    store i32 0, ptr [[SUM8_ASCAST]], align 4
// CHECK-NEXT:    br label [[OMP_INSCAN_DISPATCH:%.*]]
// CHECK:       omp.before.scan.bb:
// CHECK-NEXT:    [[TMP37:%.*]] = load i32, ptr [[TMP4]], align 4
// CHECK-NEXT:    [[TMP38:%.*]] = load ptr, ptr [[B_ADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP39:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// CHECK-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP39]] to i64
// CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, ptr [[TMP38]], i64 [[IDXPROM]]
// CHECK-NEXT:    store i32 [[TMP37]], ptr [[ARRAYIDX]], align 4
// CHECK-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK:       omp.exit.inscan.bb:
// CHECK-NEXT:    [[TMP40:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP41:%.*]] = zext i32 [[TMP40]] to i64
// CHECK-NEXT:    br label [[OMP_BODY_CONTINUE]]
// CHECK:       omp.inscan.dispatch:
// CHECK-NEXT:    br label [[OMP_AFTER_SCAN_BB:%.*]]
// CHECK:       omp.after.scan.bb:
// CHECK-NEXT:    [[TMP42:%.*]] = load ptr, ptr [[A_ADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP43:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// CHECK-NEXT:    [[IDXPROM9:%.*]] = sext i32 [[TMP43]] to i64
// CHECK-NEXT:    [[ARRAYIDX10:%.*]] = getelementptr inbounds i32, ptr [[TMP42]], i64 [[IDXPROM9]]
// CHECK-NEXT:    [[TMP44:%.*]] = load i32, ptr [[ARRAYIDX10]], align 4
// CHECK-NEXT:    [[TMP45:%.*]] = load i32, ptr addrspace(5) [[TMP7]], align 4
// CHECK-NEXT:    [[TMP46:%.*]] = add i32 [[TMP45]], [[TMP44]]
// CHECK-NEXT:    store i32 [[TMP46]], ptr addrspace(5) [[TMP7]], align 4
// CHECK-NEXT:    br label [[OMP_EXIT_INSCAN_BB:%.*]]
// CHECK:       omp.body.continue:
// CHECK-NEXT:    br label [[FOR_INC:%.*]]
// CHECK:       for.inc:
// CHECK-NEXT:    [[TMP47:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP48:%.*]] = getelementptr i32, ptr [[TMP31]], i32 [[TMP47]]
// CHECK-NEXT:    [[TMP49:%.*]] = load i32, ptr addrspace(5) [[TMP7]], align 4
// CHECK-NEXT:    store i32 [[TMP49]], ptr [[TMP48]], align 4
// CHECK-NEXT:    [[TMP50:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP51:%.*]] = add i32 1, [[TMP50]]
// CHECK-NEXT:    store i32 [[TMP51]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    br label [[FOR_COND]], !llvm.loop [[LOOP52:![0-9]+]]
// CHECK:       for.end:
// CHECK-NEXT:    [[TMP52:%.*]] = load ptr, ptr [[DOTADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP53:%.*]] = load ptr, ptr [[DOTADDR3_ASCAST]], align 8
// CHECK-NEXT:    [[TMP54:%.*]] = load ptr, ptr [[DOTADDR4_ASCAST]], align 8
// CHECK-NEXT:    [[TMP55:%.*]] = load i32, ptr addrspace(5) [[TMP7]], align 4
// CHECK-NEXT:    call void @__kmpc_xteams_i_16x64(i32 [[TMP55]], ptr [[TMP54]], ptr [[TMP4]], ptr [[TMP52]], ptr [[TMP53]], ptr @__kmpc_rfun_sum_i, ptr @__kmpc_rfun_sum_lds_i, i32 0, i64 [[TMP16]], i32 [[TMP15]])
// CHECK-NEXT:    br label [[OMP_KERNEL_DONE]]
// CHECK:       omp.kernel.done:
// CHECK-NEXT:    ret void
//
//
// CHECK-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z8run_testIiEvv_l47_1
// CHECK-SAME: (ptr noalias noundef [[DYN_PTR:%.*]], ptr noundef [[B:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM:%.*]], ptr noundef [[A:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM1:%.*]], ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]], ptr noundef [[TMP2:%.*]], ptr noundef [[TMP3:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[DYN_PTR_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[B_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[SUM_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[A_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8, addrspace(5)
// CHECK-NEXT:    [[SUM_ADDR2:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[DOTADDR3:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[DOTADDR4:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[DOTADDR5:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[I:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[SUM8:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[DYN_PTR_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DYN_PTR_ADDR]] to ptr
// CHECK-NEXT:    [[B_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[B_ADDR]] to ptr
// CHECK-NEXT:    [[SUM_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM_ADDR]] to ptr
// CHECK-NEXT:    [[A_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[A_ADDR]] to ptr
// CHECK-NEXT:    [[VLA_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[VLA_ADDR]] to ptr
// CHECK-NEXT:    [[SUM_ADDR2_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM_ADDR2]] to ptr
// CHECK-NEXT:    [[DOTADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR]] to ptr
// CHECK-NEXT:    [[DOTADDR3_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR3]] to ptr
// CHECK-NEXT:    [[DOTADDR4_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR4]] to ptr
// CHECK-NEXT:    [[DOTADDR5_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR5]] to ptr
// CHECK-NEXT:    [[I_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[I]] to ptr
// CHECK-NEXT:    [[DOTOMP_LB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_LB]] to ptr
// CHECK-NEXT:    [[DOTOMP_UB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_UB]] to ptr
// CHECK-NEXT:    [[DOTOMP_IV_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_IV]] to ptr
// CHECK-NEXT:    [[SUM8_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM8]] to ptr
// CHECK-NEXT:    store ptr [[DYN_PTR]], ptr [[DYN_PTR_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[B]], ptr [[B_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[SUM]], ptr [[SUM_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[A]], ptr [[A_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[SUM1]], ptr [[SUM_ADDR2_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR3_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[TMP2]], ptr [[DOTADDR4_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[TMP3]], ptr [[DOTADDR5_ASCAST]], align 8
// CHECK-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[SUM_ADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP5:%.*]] = load i64, ptr [[VLA_ADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP6:%.*]] = load ptr, ptr [[SUM_ADDR2_ASCAST]], align 8
// CHECK-NEXT:    call void @__kmpc_specialized_kernel_init()
// CHECK-NEXT:    [[TMP7:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    store i32 0, ptr addrspace(5) [[TMP7]], align 4
// CHECK-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// CHECK-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// CHECK-NEXT:    store i32 0, ptr [[DOTOMP_LB_ASCAST]], align 4
// CHECK-NEXT:    store i32 999999, ptr [[DOTOMP_UB_ASCAST]], align 4
// CHECK-NEXT:    [[TMP8:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// CHECK-NEXT:    store i32 [[TMP8]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP9:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// CHECK-NEXT:    [[NVPTX_NUM_THREADS:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// CHECK-NEXT:    [[GPU_BLOCK_ID:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// CHECK-NEXT:    [[TMP10:%.*]] = mul i32 [[GPU_BLOCK_ID]], [[NVPTX_NUM_THREADS]]
// CHECK-NEXT:    [[TMP11:%.*]] = add i32 [[TMP10]], [[TMP9]]
// CHECK-NEXT:    [[TMP12:%.*]] = mul i32 [[TMP11]], 1
// CHECK-NEXT:    [[TMP13:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP14:%.*]] = add i32 [[TMP12]], [[TMP13]]
// CHECK-NEXT:    [[TMP15:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// CHECK-NEXT:    [[TMP16:%.*]] = zext i32 [[TMP14]] to i64
// CHECK-NEXT:    store i32 [[TMP14]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[GLOBAL_UPPER_BOUND:%.*]] = load i32, ptr [[DOTOMP_UB_ASCAST]], align 4
// CHECK-NEXT:    [[TMP17:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// CHECK-NEXT:    [[TMP18:%.*]] = sub i32 [[GLOBAL_UPPER_BOUND]], [[TMP17]]
// CHECK-NEXT:    [[TMP19:%.*]] = add i32 [[TMP18]], 1
// CHECK-NEXT:    [[TMP20:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// CHECK-NEXT:    [[NVPTX_NUM_THREADS6:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// CHECK-NEXT:    [[GPU_BLOCK_ID7:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// CHECK-NEXT:    [[TMP21:%.*]] = mul i32 [[GPU_BLOCK_ID7]], [[NVPTX_NUM_THREADS6]]
// CHECK-NEXT:    [[TMP22:%.*]] = add i32 [[TMP21]], [[TMP20]]
// CHECK-NEXT:    [[TMP23:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// CHECK-NEXT:    [[TMP24:%.*]] = mul i32 [[NVPTX_NUM_THREADS6]], [[TMP23]]
// CHECK-NEXT:    [[TMP25:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP26:%.*]] = icmp ult i32 [[TMP25]], [[TMP24]]
// CHECK-NEXT:    br i1 [[TMP26]], label [[OMP_KERNEL_BODY:%.*]], label [[OMP_KERNEL_DONE:%.*]]
// CHECK:       omp.kernel.body:
// CHECK-NEXT:    [[TMP27:%.*]] = udiv i32 [[TMP19]], [[TMP24]]
// CHECK-NEXT:    [[PADDED_SEGMENT_SIZE:%.*]] = add i32 [[TMP27]], 1
// CHECK-NEXT:    [[TMP28:%.*]] = load ptr, ptr [[DOTADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP29:%.*]] = load ptr, ptr [[DOTADDR4_ASCAST]], align 8
// CHECK-NEXT:    [[TMP30:%.*]] = load ptr, ptr [[DOTADDR5_ASCAST]], align 8
// CHECK-NEXT:    [[TMP31:%.*]] = load i32, ptr addrspace(5) [[TMP7]], align 4
// CHECK-NEXT:    call void @__kmpc_xteams_phase2_i_16x64(ptr [[TMP29]], i32 [[PADDED_SEGMENT_SIZE]], ptr [[TMP28]], ptr [[TMP30]], ptr @__kmpc_rfun_sum_i, i32 0, i64 [[TMP16]], i32 0)
// CHECK-NEXT:    [[TMP32:%.*]] = mul i32 [[PADDED_SEGMENT_SIZE]], [[TMP22]]
// CHECK-NEXT:    store i32 [[TMP32]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP33:%.*]] = add i32 [[TMP22]], 1
// CHECK-NEXT:    [[TMP34:%.*]] = mul i32 [[PADDED_SEGMENT_SIZE]], [[TMP33]]
// CHECK-NEXT:    [[TMP35:%.*]] = load ptr, ptr [[DOTADDR5_ASCAST]], align 8
// CHECK-NEXT:    br label [[FOR_COND:%.*]]
// CHECK:       for.cond:
// CHECK-NEXT:    [[TMP36:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP37:%.*]] = icmp ult i32 [[TMP36]], [[TMP34]]
// CHECK-NEXT:    [[TMP38:%.*]] = icmp ule i32 [[TMP36]], [[GLOBAL_UPPER_BOUND]]
// CHECK-NEXT:    [[TMP39:%.*]] = and i1 [[TMP38]], [[TMP37]]
// CHECK-NEXT:    br i1 [[TMP39]], label [[FOR_BODY:%.*]], label [[FOR_END:%.*]]
// CHECK:       for.body:
// CHECK-NEXT:    [[TMP40:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP40]], 1
// CHECK-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK-NEXT:    store i32 [[ADD]], ptr [[I_ASCAST]], align 4
// CHECK-NEXT:    [[TMP41:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP42:%.*]] = getelementptr i32, ptr [[TMP35]], i32 [[TMP41]]
// CHECK-NEXT:    [[TMP43:%.*]] = load i32, ptr [[TMP42]], align 4
// CHECK-NEXT:    store i32 [[TMP43]], ptr addrspace(5) [[TMP7]], align 4
// CHECK-NEXT:    store i32 0, ptr [[SUM8_ASCAST]], align 4
// CHECK-NEXT:    br label [[OMP_INSCAN_DISPATCH:%.*]]
// CHECK:       omp.before.scan.bb:
// CHECK-NEXT:    [[TMP44:%.*]] = load ptr, ptr [[B_ADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP45:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// CHECK-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP45]] to i64
// CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, ptr [[TMP44]], i64 [[IDXPROM]]
// CHECK-NEXT:    [[TMP46:%.*]] = load i32, ptr addrspace(5) [[TMP7]], align 4
// CHECK-NEXT:    store i32 [[TMP46]], ptr [[ARRAYIDX]], align 4
// CHECK-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK:       omp.exit.inscan.bb:
// CHECK-NEXT:    br label [[OMP_BODY_CONTINUE]]
// CHECK:       omp.inscan.dispatch:
// CHECK-NEXT:    [[TMP47:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP48:%.*]] = zext i32 [[TMP47]] to i64
// CHECK-NEXT:    [[TMP49:%.*]] = icmp eq i64 [[TMP48]], 0
// CHECK-NEXT:    br i1 [[TMP49]], label [[OMP_EXCLUSIVE_COPY_EXIT:%.*]], label [[OMP_EXCLUSIVE_DEC:%.*]]
// CHECK:       omp.exclusive.dec:
// CHECK-NEXT:    [[TMP50:%.*]] = sub nuw i64 [[TMP48]], 1
// CHECK-NEXT:    [[ARRAYIDX9:%.*]] = getelementptr inbounds nuw i32, ptr [[TMP6]], i64 [[TMP50]]
// CHECK-NEXT:    [[TMP51:%.*]] = load i32, ptr addrspace(5) [[TMP7]], align 4
// CHECK-NEXT:    store i32 [[TMP51]], ptr [[TMP4]], align 4
// CHECK-NEXT:    br label [[OMP_EXCLUSIVE_COPY_EXIT]]
// CHECK:       omp.exclusive.copy.exit:
// CHECK-NEXT:    br label [[OMP_BEFORE_SCAN_BB:%.*]]
// CHECK:       omp.after.scan.bb:
// CHECK-NEXT:    [[TMP52:%.*]] = load ptr, ptr [[A_ADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP53:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// CHECK-NEXT:    [[IDXPROM10:%.*]] = sext i32 [[TMP53]] to i64
// CHECK-NEXT:    [[ARRAYIDX11:%.*]] = getelementptr inbounds i32, ptr [[TMP52]], i64 [[IDXPROM10]]
// CHECK-NEXT:    [[TMP54:%.*]] = load i32, ptr [[ARRAYIDX11]], align 4
// CHECK-NEXT:    [[TMP55:%.*]] = load i32, ptr addrspace(5) [[TMP7]], align 4
// CHECK-NEXT:    [[TMP56:%.*]] = add i32 [[TMP55]], [[TMP54]]
// CHECK-NEXT:    store i32 [[TMP56]], ptr addrspace(5) [[TMP7]], align 4
// CHECK-NEXT:    br label [[OMP_EXIT_INSCAN_BB:%.*]]
// CHECK:       omp.body.continue:
// CHECK-NEXT:    br label [[FOR_INC:%.*]]
// CHECK:       for.inc:
// CHECK-NEXT:    [[TMP57:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP58:%.*]] = getelementptr i32, ptr [[TMP35]], i32 [[TMP57]]
// CHECK-NEXT:    [[TMP59:%.*]] = load i32, ptr addrspace(5) [[TMP7]], align 4
// CHECK-NEXT:    store i32 [[TMP59]], ptr [[TMP58]], align 4
// CHECK-NEXT:    [[TMP60:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP61:%.*]] = add i32 1, [[TMP60]]
// CHECK-NEXT:    store i32 [[TMP61]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    br label [[FOR_COND]], !llvm.loop [[LOOP53:![0-9]+]]
// CHECK:       for.end:
// CHECK-NEXT:    br label [[OMP_KERNEL_DONE]]
// CHECK:       omp.kernel.done:
// CHECK-NEXT:    ret void
//
//
// CHECK-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z8run_testIjEvv_l35
// CHECK-SAME: (ptr noalias noundef [[DYN_PTR:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM:%.*]], ptr noundef [[A:%.*]], ptr noundef [[B:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM1:%.*]], ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]], ptr noundef [[TMP2:%.*]], ptr noundef [[TMP3:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[DYN_PTR_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[SUM_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[A_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[B_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8, addrspace(5)
// CHECK-NEXT:    [[SUM_ADDR2:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[DOTADDR3:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[DOTADDR4:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[DOTADDR5:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[I:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[SUM8:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[DYN_PTR_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DYN_PTR_ADDR]] to ptr
// CHECK-NEXT:    [[SUM_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM_ADDR]] to ptr
// CHECK-NEXT:    [[A_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[A_ADDR]] to ptr
// CHECK-NEXT:    [[B_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[B_ADDR]] to ptr
// CHECK-NEXT:    [[VLA_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[VLA_ADDR]] to ptr
// CHECK-NEXT:    [[SUM_ADDR2_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM_ADDR2]] to ptr
// CHECK-NEXT:    [[DOTADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR]] to ptr
// CHECK-NEXT:    [[DOTADDR3_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR3]] to ptr
// CHECK-NEXT:    [[DOTADDR4_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR4]] to ptr
// CHECK-NEXT:    [[DOTADDR5_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR5]] to ptr
// CHECK-NEXT:    [[I_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[I]] to ptr
// CHECK-NEXT:    [[DOTOMP_LB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_LB]] to ptr
// CHECK-NEXT:    [[DOTOMP_UB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_UB]] to ptr
// CHECK-NEXT:    [[DOTOMP_IV_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_IV]] to ptr
// CHECK-NEXT:    [[SUM8_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM8]] to ptr
// CHECK-NEXT:    store ptr [[DYN_PTR]], ptr [[DYN_PTR_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[SUM]], ptr [[SUM_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[A]], ptr [[A_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[B]], ptr [[B_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[SUM1]], ptr [[SUM_ADDR2_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR3_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[TMP2]], ptr [[DOTADDR4_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[TMP3]], ptr [[DOTADDR5_ASCAST]], align 8
// CHECK-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[SUM_ADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP5:%.*]] = load i64, ptr [[VLA_ADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP6:%.*]] = load ptr, ptr [[SUM_ADDR2_ASCAST]], align 8
// CHECK-NEXT:    call void @__kmpc_specialized_kernel_init()
// CHECK-NEXT:    [[TMP7:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    store i32 0, ptr addrspace(5) [[TMP7]], align 4
// CHECK-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// CHECK-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// CHECK-NEXT:    store i32 0, ptr [[DOTOMP_LB_ASCAST]], align 4
// CHECK-NEXT:    store i32 999999, ptr [[DOTOMP_UB_ASCAST]], align 4
// CHECK-NEXT:    [[TMP8:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// CHECK-NEXT:    store i32 [[TMP8]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP9:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// CHECK-NEXT:    [[NVPTX_NUM_THREADS:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// CHECK-NEXT:    [[GPU_BLOCK_ID:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// CHECK-NEXT:    [[TMP10:%.*]] = mul i32 [[GPU_BLOCK_ID]], [[NVPTX_NUM_THREADS]]
// CHECK-NEXT:    [[TMP11:%.*]] = add i32 [[TMP10]], [[TMP9]]
// CHECK-NEXT:    [[TMP12:%.*]] = mul i32 [[TMP11]], 1
// CHECK-NEXT:    [[TMP13:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP14:%.*]] = add i32 [[TMP12]], [[TMP13]]
// CHECK-NEXT:    [[TMP15:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// CHECK-NEXT:    [[TMP16:%.*]] = zext i32 [[TMP14]] to i64
// CHECK-NEXT:    store i32 [[TMP14]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[GLOBAL_UPPER_BOUND:%.*]] = load i32, ptr [[DOTOMP_UB_ASCAST]], align 4
// CHECK-NEXT:    [[TMP17:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// CHECK-NEXT:    [[TMP18:%.*]] = sub i32 [[GLOBAL_UPPER_BOUND]], [[TMP17]]
// CHECK-NEXT:    [[TMP19:%.*]] = add i32 [[TMP18]], 1
// CHECK-NEXT:    [[TMP20:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// CHECK-NEXT:    [[NVPTX_NUM_THREADS6:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// CHECK-NEXT:    [[GPU_BLOCK_ID7:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// CHECK-NEXT:    [[TMP21:%.*]] = mul i32 [[GPU_BLOCK_ID7]], [[NVPTX_NUM_THREADS6]]
// CHECK-NEXT:    [[TMP22:%.*]] = add i32 [[TMP21]], [[TMP20]]
// CHECK-NEXT:    [[TMP23:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// CHECK-NEXT:    [[TMP24:%.*]] = mul i32 [[NVPTX_NUM_THREADS6]], [[TMP23]]
// CHECK-NEXT:    [[TMP25:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP26:%.*]] = icmp ult i32 [[TMP25]], [[TMP24]]
// CHECK-NEXT:    br i1 [[TMP26]], label [[OMP_KERNEL_BODY:%.*]], label [[OMP_KERNEL_DONE:%.*]]
// CHECK:       omp.kernel.body:
// CHECK-NEXT:    [[TMP27:%.*]] = udiv i32 [[TMP19]], [[TMP24]]
// CHECK-NEXT:    [[PADDED_SEGMENT_SIZE:%.*]] = add i32 [[TMP27]], 1
// CHECK-NEXT:    [[TMP28:%.*]] = mul i32 [[PADDED_SEGMENT_SIZE]], [[TMP22]]
// CHECK-NEXT:    store i32 [[TMP28]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP29:%.*]] = add i32 [[TMP22]], 1
// CHECK-NEXT:    [[TMP30:%.*]] = mul i32 [[PADDED_SEGMENT_SIZE]], [[TMP29]]
// CHECK-NEXT:    [[TMP31:%.*]] = load ptr, ptr [[DOTADDR5_ASCAST]], align 8
// CHECK-NEXT:    br label [[FOR_COND:%.*]]
// CHECK:       for.cond:
// CHECK-NEXT:    [[TMP32:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP33:%.*]] = icmp ult i32 [[TMP32]], [[TMP30]]
// CHECK-NEXT:    [[TMP34:%.*]] = icmp ule i32 [[TMP32]], [[GLOBAL_UPPER_BOUND]]
// CHECK-NEXT:    [[TMP35:%.*]] = and i1 [[TMP34]], [[TMP33]]
// CHECK-NEXT:    br i1 [[TMP35]], label [[FOR_BODY:%.*]], label [[FOR_END:%.*]]
// CHECK:       for.body:
// CHECK-NEXT:    [[TMP36:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP36]], 1
// CHECK-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK-NEXT:    store i32 [[ADD]], ptr [[I_ASCAST]], align 4
// CHECK-NEXT:    store i32 0, ptr [[SUM8_ASCAST]], align 4
// CHECK-NEXT:    br label [[OMP_INSCAN_DISPATCH:%.*]]
// CHECK:       omp.before.scan.bb:
// CHECK-NEXT:    [[TMP37:%.*]] = load ptr, ptr [[A_ADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP38:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// CHECK-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP38]] to i64
// CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, ptr [[TMP37]], i64 [[IDXPROM]]
// CHECK-NEXT:    [[TMP39:%.*]] = load i32, ptr [[ARRAYIDX]], align 4
// CHECK-NEXT:    [[TMP40:%.*]] = load i32, ptr addrspace(5) [[TMP7]], align 4
// CHECK-NEXT:    [[TMP41:%.*]] = add i32 [[TMP40]], [[TMP39]]
// CHECK-NEXT:    store i32 [[TMP41]], ptr addrspace(5) [[TMP7]], align 4
// CHECK-NEXT:    [[TMP42:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP43:%.*]] = zext i32 [[TMP42]] to i64
// CHECK-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK:       omp.exit.inscan.bb:
// CHECK-NEXT:    br label [[OMP_BODY_CONTINUE]]
// CHECK:       omp.inscan.dispatch:
// CHECK-NEXT:    br label [[OMP_BEFORE_SCAN_BB:%.*]]
// CHECK:       omp.after.scan.bb:
// CHECK-NEXT:    [[TMP44:%.*]] = load i32, ptr [[TMP4]], align 4
// CHECK-NEXT:    [[TMP45:%.*]] = load ptr, ptr [[B_ADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP46:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// CHECK-NEXT:    [[IDXPROM9:%.*]] = sext i32 [[TMP46]] to i64
// CHECK-NEXT:    [[ARRAYIDX10:%.*]] = getelementptr inbounds i32, ptr [[TMP45]], i64 [[IDXPROM9]]
// CHECK-NEXT:    store i32 [[TMP44]], ptr [[ARRAYIDX10]], align 4
// CHECK-NEXT:    br label [[OMP_EXIT_INSCAN_BB:%.*]]
// CHECK:       omp.body.continue:
// CHECK-NEXT:    br label [[FOR_INC:%.*]]
// CHECK:       for.inc:
// CHECK-NEXT:    [[TMP47:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP48:%.*]] = getelementptr i32, ptr [[TMP31]], i32 [[TMP47]]
// CHECK-NEXT:    [[TMP49:%.*]] = load i32, ptr addrspace(5) [[TMP7]], align 4
// CHECK-NEXT:    store i32 [[TMP49]], ptr [[TMP48]], align 4
// CHECK-NEXT:    [[TMP50:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP51:%.*]] = add i32 1, [[TMP50]]
// CHECK-NEXT:    store i32 [[TMP51]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    br label [[FOR_COND]], !llvm.loop [[LOOP54:![0-9]+]]
// CHECK:       for.end:
// CHECK-NEXT:    [[TMP52:%.*]] = load ptr, ptr [[DOTADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP53:%.*]] = load ptr, ptr [[DOTADDR3_ASCAST]], align 8
// CHECK-NEXT:    [[TMP54:%.*]] = load ptr, ptr [[DOTADDR4_ASCAST]], align 8
// CHECK-NEXT:    [[TMP55:%.*]] = load i32, ptr addrspace(5) [[TMP7]], align 4
// CHECK-NEXT:    call void @__kmpc_xteams_i_16x64(i32 [[TMP55]], ptr [[TMP54]], ptr [[TMP4]], ptr [[TMP52]], ptr [[TMP53]], ptr @__kmpc_rfun_sum_i, ptr @__kmpc_rfun_sum_lds_i, i32 0, i64 [[TMP16]], i32 [[TMP15]])
// CHECK-NEXT:    br label [[OMP_KERNEL_DONE]]
// CHECK:       omp.kernel.done:
// CHECK-NEXT:    ret void
//
//
// CHECK-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z8run_testIjEvv_l35_1
// CHECK-SAME: (ptr noalias noundef [[DYN_PTR:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM:%.*]], ptr noundef [[A:%.*]], ptr noundef [[B:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM1:%.*]], ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]], ptr noundef [[TMP2:%.*]], ptr noundef [[TMP3:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[DYN_PTR_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[SUM_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[A_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[B_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8, addrspace(5)
// CHECK-NEXT:    [[SUM_ADDR2:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[DOTADDR3:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[DOTADDR4:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[DOTADDR5:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[I:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[SUM8:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[DYN_PTR_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DYN_PTR_ADDR]] to ptr
// CHECK-NEXT:    [[SUM_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM_ADDR]] to ptr
// CHECK-NEXT:    [[A_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[A_ADDR]] to ptr
// CHECK-NEXT:    [[B_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[B_ADDR]] to ptr
// CHECK-NEXT:    [[VLA_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[VLA_ADDR]] to ptr
// CHECK-NEXT:    [[SUM_ADDR2_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM_ADDR2]] to ptr
// CHECK-NEXT:    [[DOTADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR]] to ptr
// CHECK-NEXT:    [[DOTADDR3_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR3]] to ptr
// CHECK-NEXT:    [[DOTADDR4_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR4]] to ptr
// CHECK-NEXT:    [[DOTADDR5_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR5]] to ptr
// CHECK-NEXT:    [[I_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[I]] to ptr
// CHECK-NEXT:    [[DOTOMP_LB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_LB]] to ptr
// CHECK-NEXT:    [[DOTOMP_UB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_UB]] to ptr
// CHECK-NEXT:    [[DOTOMP_IV_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_IV]] to ptr
// CHECK-NEXT:    [[SUM8_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM8]] to ptr
// CHECK-NEXT:    store ptr [[DYN_PTR]], ptr [[DYN_PTR_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[SUM]], ptr [[SUM_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[A]], ptr [[A_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[B]], ptr [[B_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[SUM1]], ptr [[SUM_ADDR2_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR3_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[TMP2]], ptr [[DOTADDR4_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[TMP3]], ptr [[DOTADDR5_ASCAST]], align 8
// CHECK-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[SUM_ADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP5:%.*]] = load i64, ptr [[VLA_ADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP6:%.*]] = load ptr, ptr [[SUM_ADDR2_ASCAST]], align 8
// CHECK-NEXT:    call void @__kmpc_specialized_kernel_init()
// CHECK-NEXT:    [[TMP7:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    store i32 0, ptr addrspace(5) [[TMP7]], align 4
// CHECK-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// CHECK-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// CHECK-NEXT:    store i32 0, ptr [[DOTOMP_LB_ASCAST]], align 4
// CHECK-NEXT:    store i32 999999, ptr [[DOTOMP_UB_ASCAST]], align 4
// CHECK-NEXT:    [[TMP8:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// CHECK-NEXT:    store i32 [[TMP8]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP9:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// CHECK-NEXT:    [[NVPTX_NUM_THREADS:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// CHECK-NEXT:    [[GPU_BLOCK_ID:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// CHECK-NEXT:    [[TMP10:%.*]] = mul i32 [[GPU_BLOCK_ID]], [[NVPTX_NUM_THREADS]]
// CHECK-NEXT:    [[TMP11:%.*]] = add i32 [[TMP10]], [[TMP9]]
// CHECK-NEXT:    [[TMP12:%.*]] = mul i32 [[TMP11]], 1
// CHECK-NEXT:    [[TMP13:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP14:%.*]] = add i32 [[TMP12]], [[TMP13]]
// CHECK-NEXT:    [[TMP15:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// CHECK-NEXT:    [[TMP16:%.*]] = zext i32 [[TMP14]] to i64
// CHECK-NEXT:    store i32 [[TMP14]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[GLOBAL_UPPER_BOUND:%.*]] = load i32, ptr [[DOTOMP_UB_ASCAST]], align 4
// CHECK-NEXT:    [[TMP17:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// CHECK-NEXT:    [[TMP18:%.*]] = sub i32 [[GLOBAL_UPPER_BOUND]], [[TMP17]]
// CHECK-NEXT:    [[TMP19:%.*]] = add i32 [[TMP18]], 1
// CHECK-NEXT:    [[TMP20:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// CHECK-NEXT:    [[NVPTX_NUM_THREADS6:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// CHECK-NEXT:    [[GPU_BLOCK_ID7:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// CHECK-NEXT:    [[TMP21:%.*]] = mul i32 [[GPU_BLOCK_ID7]], [[NVPTX_NUM_THREADS6]]
// CHECK-NEXT:    [[TMP22:%.*]] = add i32 [[TMP21]], [[TMP20]]
// CHECK-NEXT:    [[TMP23:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// CHECK-NEXT:    [[TMP24:%.*]] = mul i32 [[NVPTX_NUM_THREADS6]], [[TMP23]]
// CHECK-NEXT:    [[TMP25:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP26:%.*]] = icmp ult i32 [[TMP25]], [[TMP24]]
// CHECK-NEXT:    br i1 [[TMP26]], label [[OMP_KERNEL_BODY:%.*]], label [[OMP_KERNEL_DONE:%.*]]
// CHECK:       omp.kernel.body:
// CHECK-NEXT:    [[TMP27:%.*]] = udiv i32 [[TMP19]], [[TMP24]]
// CHECK-NEXT:    [[PADDED_SEGMENT_SIZE:%.*]] = add i32 [[TMP27]], 1
// CHECK-NEXT:    [[TMP28:%.*]] = load ptr, ptr [[DOTADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP29:%.*]] = load ptr, ptr [[DOTADDR4_ASCAST]], align 8
// CHECK-NEXT:    [[TMP30:%.*]] = load ptr, ptr [[DOTADDR5_ASCAST]], align 8
// CHECK-NEXT:    [[TMP31:%.*]] = load i32, ptr addrspace(5) [[TMP7]], align 4
// CHECK-NEXT:    call void @__kmpc_xteams_phase2_i_16x64(ptr [[TMP29]], i32 [[PADDED_SEGMENT_SIZE]], ptr [[TMP28]], ptr [[TMP30]], ptr @__kmpc_rfun_sum_i, i32 0, i64 [[TMP16]], i32 1)
// CHECK-NEXT:    [[TMP32:%.*]] = mul i32 [[PADDED_SEGMENT_SIZE]], [[TMP22]]
// CHECK-NEXT:    store i32 [[TMP32]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP33:%.*]] = add i32 [[TMP22]], 1
// CHECK-NEXT:    [[TMP34:%.*]] = mul i32 [[PADDED_SEGMENT_SIZE]], [[TMP33]]
// CHECK-NEXT:    [[TMP35:%.*]] = load ptr, ptr [[DOTADDR5_ASCAST]], align 8
// CHECK-NEXT:    br label [[FOR_COND:%.*]]
// CHECK:       for.cond:
// CHECK-NEXT:    [[TMP36:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP37:%.*]] = icmp ult i32 [[TMP36]], [[TMP34]]
// CHECK-NEXT:    [[TMP38:%.*]] = icmp ule i32 [[TMP36]], [[GLOBAL_UPPER_BOUND]]
// CHECK-NEXT:    [[TMP39:%.*]] = and i1 [[TMP38]], [[TMP37]]
// CHECK-NEXT:    br i1 [[TMP39]], label [[FOR_BODY:%.*]], label [[FOR_END:%.*]]
// CHECK:       for.body:
// CHECK-NEXT:    [[TMP40:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP40]], 1
// CHECK-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK-NEXT:    store i32 [[ADD]], ptr [[I_ASCAST]], align 4
// CHECK-NEXT:    [[TMP41:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP42:%.*]] = getelementptr i32, ptr [[TMP35]], i32 [[TMP41]]
// CHECK-NEXT:    [[TMP43:%.*]] = load i32, ptr [[TMP42]], align 4
// CHECK-NEXT:    store i32 [[TMP43]], ptr addrspace(5) [[TMP7]], align 4
// CHECK-NEXT:    store i32 0, ptr [[SUM8_ASCAST]], align 4
// CHECK-NEXT:    br label [[OMP_INSCAN_DISPATCH:%.*]]
// CHECK:       omp.before.scan.bb:
// CHECK-NEXT:    [[TMP44:%.*]] = load ptr, ptr [[A_ADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP45:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// CHECK-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP45]] to i64
// CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, ptr [[TMP44]], i64 [[IDXPROM]]
// CHECK-NEXT:    [[TMP46:%.*]] = load i32, ptr [[ARRAYIDX]], align 4
// CHECK-NEXT:    [[TMP47:%.*]] = load i32, ptr addrspace(5) [[TMP7]], align 4
// CHECK-NEXT:    [[TMP48:%.*]] = add i32 [[TMP47]], [[TMP46]]
// CHECK-NEXT:    store i32 [[TMP48]], ptr addrspace(5) [[TMP7]], align 4
// CHECK-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK:       omp.exit.inscan.bb:
// CHECK-NEXT:    br label [[OMP_BODY_CONTINUE]]
// CHECK:       omp.inscan.dispatch:
// CHECK-NEXT:    [[TMP49:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP50:%.*]] = zext i32 [[TMP49]] to i64
// CHECK-NEXT:    [[ARRAYIDX9:%.*]] = getelementptr inbounds nuw i32, ptr [[TMP6]], i64 [[TMP50]]
// CHECK-NEXT:    [[TMP51:%.*]] = load i32, ptr addrspace(5) [[TMP7]], align 4
// CHECK-NEXT:    store i32 [[TMP51]], ptr [[TMP4]], align 4
// CHECK-NEXT:    br label [[OMP_AFTER_SCAN_BB:%.*]]
// CHECK:       omp.after.scan.bb:
// CHECK-NEXT:    [[TMP52:%.*]] = load ptr, ptr [[B_ADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP53:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// CHECK-NEXT:    [[IDXPROM10:%.*]] = sext i32 [[TMP53]] to i64
// CHECK-NEXT:    [[ARRAYIDX11:%.*]] = getelementptr inbounds i32, ptr [[TMP52]], i64 [[IDXPROM10]]
// CHECK-NEXT:    [[TMP54:%.*]] = load i32, ptr addrspace(5) [[TMP7]], align 4
// CHECK-NEXT:    store i32 [[TMP54]], ptr [[ARRAYIDX11]], align 4
// CHECK-NEXT:    br label [[OMP_EXIT_INSCAN_BB:%.*]]
// CHECK:       omp.body.continue:
// CHECK-NEXT:    br label [[FOR_INC:%.*]]
// CHECK:       for.inc:
// CHECK-NEXT:    [[TMP55:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP56:%.*]] = getelementptr i32, ptr [[TMP35]], i32 [[TMP55]]
// CHECK-NEXT:    [[TMP57:%.*]] = load i32, ptr addrspace(5) [[TMP7]], align 4
// CHECK-NEXT:    store i32 [[TMP57]], ptr [[TMP56]], align 4
// CHECK-NEXT:    [[TMP58:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP59:%.*]] = add i32 1, [[TMP58]]
// CHECK-NEXT:    store i32 [[TMP59]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    br label [[FOR_COND]], !llvm.loop [[LOOP55:![0-9]+]]
// CHECK:       for.end:
// CHECK-NEXT:    br label [[OMP_KERNEL_DONE]]
// CHECK:       omp.kernel.done:
// CHECK-NEXT:    ret void
//
//
// CHECK-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z8run_testIjEvv_l47
// CHECK-SAME: (ptr noalias noundef [[DYN_PTR:%.*]], ptr noundef [[B:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM:%.*]], ptr noundef [[A:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM1:%.*]], ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]], ptr noundef [[TMP2:%.*]], ptr noundef [[TMP3:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[DYN_PTR_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[B_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[SUM_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[A_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8, addrspace(5)
// CHECK-NEXT:    [[SUM_ADDR2:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[DOTADDR3:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[DOTADDR4:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[DOTADDR5:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[I:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[SUM8:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[DYN_PTR_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DYN_PTR_ADDR]] to ptr
// CHECK-NEXT:    [[B_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[B_ADDR]] to ptr
// CHECK-NEXT:    [[SUM_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM_ADDR]] to ptr
// CHECK-NEXT:    [[A_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[A_ADDR]] to ptr
// CHECK-NEXT:    [[VLA_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[VLA_ADDR]] to ptr
// CHECK-NEXT:    [[SUM_ADDR2_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM_ADDR2]] to ptr
// CHECK-NEXT:    [[DOTADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR]] to ptr
// CHECK-NEXT:    [[DOTADDR3_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR3]] to ptr
// CHECK-NEXT:    [[DOTADDR4_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR4]] to ptr
// CHECK-NEXT:    [[DOTADDR5_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR5]] to ptr
// CHECK-NEXT:    [[I_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[I]] to ptr
// CHECK-NEXT:    [[DOTOMP_LB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_LB]] to ptr
// CHECK-NEXT:    [[DOTOMP_UB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_UB]] to ptr
// CHECK-NEXT:    [[DOTOMP_IV_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_IV]] to ptr
// CHECK-NEXT:    [[SUM8_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM8]] to ptr
// CHECK-NEXT:    store ptr [[DYN_PTR]], ptr [[DYN_PTR_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[B]], ptr [[B_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[SUM]], ptr [[SUM_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[A]], ptr [[A_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[SUM1]], ptr [[SUM_ADDR2_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR3_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[TMP2]], ptr [[DOTADDR4_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[TMP3]], ptr [[DOTADDR5_ASCAST]], align 8
// CHECK-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[SUM_ADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP5:%.*]] = load i64, ptr [[VLA_ADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP6:%.*]] = load ptr, ptr [[SUM_ADDR2_ASCAST]], align 8
// CHECK-NEXT:    call void @__kmpc_specialized_kernel_init()
// CHECK-NEXT:    [[TMP7:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    store i32 0, ptr addrspace(5) [[TMP7]], align 4
// CHECK-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// CHECK-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// CHECK-NEXT:    store i32 0, ptr [[DOTOMP_LB_ASCAST]], align 4
// CHECK-NEXT:    store i32 999999, ptr [[DOTOMP_UB_ASCAST]], align 4
// CHECK-NEXT:    [[TMP8:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// CHECK-NEXT:    store i32 [[TMP8]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP9:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// CHECK-NEXT:    [[NVPTX_NUM_THREADS:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// CHECK-NEXT:    [[GPU_BLOCK_ID:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// CHECK-NEXT:    [[TMP10:%.*]] = mul i32 [[GPU_BLOCK_ID]], [[NVPTX_NUM_THREADS]]
// CHECK-NEXT:    [[TMP11:%.*]] = add i32 [[TMP10]], [[TMP9]]
// CHECK-NEXT:    [[TMP12:%.*]] = mul i32 [[TMP11]], 1
// CHECK-NEXT:    [[TMP13:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP14:%.*]] = add i32 [[TMP12]], [[TMP13]]
// CHECK-NEXT:    [[TMP15:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// CHECK-NEXT:    [[TMP16:%.*]] = zext i32 [[TMP14]] to i64
// CHECK-NEXT:    store i32 [[TMP14]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[GLOBAL_UPPER_BOUND:%.*]] = load i32, ptr [[DOTOMP_UB_ASCAST]], align 4
// CHECK-NEXT:    [[TMP17:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// CHECK-NEXT:    [[TMP18:%.*]] = sub i32 [[GLOBAL_UPPER_BOUND]], [[TMP17]]
// CHECK-NEXT:    [[TMP19:%.*]] = add i32 [[TMP18]], 1
// CHECK-NEXT:    [[TMP20:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// CHECK-NEXT:    [[NVPTX_NUM_THREADS6:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// CHECK-NEXT:    [[GPU_BLOCK_ID7:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// CHECK-NEXT:    [[TMP21:%.*]] = mul i32 [[GPU_BLOCK_ID7]], [[NVPTX_NUM_THREADS6]]
// CHECK-NEXT:    [[TMP22:%.*]] = add i32 [[TMP21]], [[TMP20]]
// CHECK-NEXT:    [[TMP23:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// CHECK-NEXT:    [[TMP24:%.*]] = mul i32 [[NVPTX_NUM_THREADS6]], [[TMP23]]
// CHECK-NEXT:    [[TMP25:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP26:%.*]] = icmp ult i32 [[TMP25]], [[TMP24]]
// CHECK-NEXT:    br i1 [[TMP26]], label [[OMP_KERNEL_BODY:%.*]], label [[OMP_KERNEL_DONE:%.*]]
// CHECK:       omp.kernel.body:
// CHECK-NEXT:    [[TMP27:%.*]] = udiv i32 [[TMP19]], [[TMP24]]
// CHECK-NEXT:    [[PADDED_SEGMENT_SIZE:%.*]] = add i32 [[TMP27]], 1
// CHECK-NEXT:    [[TMP28:%.*]] = mul i32 [[PADDED_SEGMENT_SIZE]], [[TMP22]]
// CHECK-NEXT:    store i32 [[TMP28]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP29:%.*]] = add i32 [[TMP22]], 1
// CHECK-NEXT:    [[TMP30:%.*]] = mul i32 [[PADDED_SEGMENT_SIZE]], [[TMP29]]
// CHECK-NEXT:    [[TMP31:%.*]] = load ptr, ptr [[DOTADDR5_ASCAST]], align 8
// CHECK-NEXT:    br label [[FOR_COND:%.*]]
// CHECK:       for.cond:
// CHECK-NEXT:    [[TMP32:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP33:%.*]] = icmp ult i32 [[TMP32]], [[TMP30]]
// CHECK-NEXT:    [[TMP34:%.*]] = icmp ule i32 [[TMP32]], [[GLOBAL_UPPER_BOUND]]
// CHECK-NEXT:    [[TMP35:%.*]] = and i1 [[TMP34]], [[TMP33]]
// CHECK-NEXT:    br i1 [[TMP35]], label [[FOR_BODY:%.*]], label [[FOR_END:%.*]]
// CHECK:       for.body:
// CHECK-NEXT:    [[TMP36:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP36]], 1
// CHECK-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK-NEXT:    store i32 [[ADD]], ptr [[I_ASCAST]], align 4
// CHECK-NEXT:    store i32 0, ptr [[SUM8_ASCAST]], align 4
// CHECK-NEXT:    br label [[OMP_INSCAN_DISPATCH:%.*]]
// CHECK:       omp.before.scan.bb:
// CHECK-NEXT:    [[TMP37:%.*]] = load i32, ptr [[TMP4]], align 4
// CHECK-NEXT:    [[TMP38:%.*]] = load ptr, ptr [[B_ADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP39:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// CHECK-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP39]] to i64
// CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, ptr [[TMP38]], i64 [[IDXPROM]]
// CHECK-NEXT:    store i32 [[TMP37]], ptr [[ARRAYIDX]], align 4
// CHECK-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK:       omp.exit.inscan.bb:
// CHECK-NEXT:    [[TMP40:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP41:%.*]] = zext i32 [[TMP40]] to i64
// CHECK-NEXT:    br label [[OMP_BODY_CONTINUE]]
// CHECK:       omp.inscan.dispatch:
// CHECK-NEXT:    br label [[OMP_AFTER_SCAN_BB:%.*]]
// CHECK:       omp.after.scan.bb:
// CHECK-NEXT:    [[TMP42:%.*]] = load ptr, ptr [[A_ADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP43:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// CHECK-NEXT:    [[IDXPROM9:%.*]] = sext i32 [[TMP43]] to i64
// CHECK-NEXT:    [[ARRAYIDX10:%.*]] = getelementptr inbounds i32, ptr [[TMP42]], i64 [[IDXPROM9]]
// CHECK-NEXT:    [[TMP44:%.*]] = load i32, ptr [[ARRAYIDX10]], align 4
// CHECK-NEXT:    [[TMP45:%.*]] = load i32, ptr addrspace(5) [[TMP7]], align 4
// CHECK-NEXT:    [[TMP46:%.*]] = add i32 [[TMP45]], [[TMP44]]
// CHECK-NEXT:    store i32 [[TMP46]], ptr addrspace(5) [[TMP7]], align 4
// CHECK-NEXT:    br label [[OMP_EXIT_INSCAN_BB:%.*]]
// CHECK:       omp.body.continue:
// CHECK-NEXT:    br label [[FOR_INC:%.*]]
// CHECK:       for.inc:
// CHECK-NEXT:    [[TMP47:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP48:%.*]] = getelementptr i32, ptr [[TMP31]], i32 [[TMP47]]
// CHECK-NEXT:    [[TMP49:%.*]] = load i32, ptr addrspace(5) [[TMP7]], align 4
// CHECK-NEXT:    store i32 [[TMP49]], ptr [[TMP48]], align 4
// CHECK-NEXT:    [[TMP50:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP51:%.*]] = add i32 1, [[TMP50]]
// CHECK-NEXT:    store i32 [[TMP51]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    br label [[FOR_COND]], !llvm.loop [[LOOP56:![0-9]+]]
// CHECK:       for.end:
// CHECK-NEXT:    [[TMP52:%.*]] = load ptr, ptr [[DOTADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP53:%.*]] = load ptr, ptr [[DOTADDR3_ASCAST]], align 8
// CHECK-NEXT:    [[TMP54:%.*]] = load ptr, ptr [[DOTADDR4_ASCAST]], align 8
// CHECK-NEXT:    [[TMP55:%.*]] = load i32, ptr addrspace(5) [[TMP7]], align 4
// CHECK-NEXT:    call void @__kmpc_xteams_i_16x64(i32 [[TMP55]], ptr [[TMP54]], ptr [[TMP4]], ptr [[TMP52]], ptr [[TMP53]], ptr @__kmpc_rfun_sum_i, ptr @__kmpc_rfun_sum_lds_i, i32 0, i64 [[TMP16]], i32 [[TMP15]])
// CHECK-NEXT:    br label [[OMP_KERNEL_DONE]]
// CHECK:       omp.kernel.done:
// CHECK-NEXT:    ret void
//
//
// CHECK-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z8run_testIjEvv_l47_1
// CHECK-SAME: (ptr noalias noundef [[DYN_PTR:%.*]], ptr noundef [[B:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM:%.*]], ptr noundef [[A:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM1:%.*]], ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]], ptr noundef [[TMP2:%.*]], ptr noundef [[TMP3:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[DYN_PTR_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[B_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[SUM_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[A_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8, addrspace(5)
// CHECK-NEXT:    [[SUM_ADDR2:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[DOTADDR3:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[DOTADDR4:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[DOTADDR5:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[I:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[SUM8:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[DYN_PTR_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DYN_PTR_ADDR]] to ptr
// CHECK-NEXT:    [[B_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[B_ADDR]] to ptr
// CHECK-NEXT:    [[SUM_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM_ADDR]] to ptr
// CHECK-NEXT:    [[A_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[A_ADDR]] to ptr
// CHECK-NEXT:    [[VLA_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[VLA_ADDR]] to ptr
// CHECK-NEXT:    [[SUM_ADDR2_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM_ADDR2]] to ptr
// CHECK-NEXT:    [[DOTADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR]] to ptr
// CHECK-NEXT:    [[DOTADDR3_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR3]] to ptr
// CHECK-NEXT:    [[DOTADDR4_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR4]] to ptr
// CHECK-NEXT:    [[DOTADDR5_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR5]] to ptr
// CHECK-NEXT:    [[I_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[I]] to ptr
// CHECK-NEXT:    [[DOTOMP_LB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_LB]] to ptr
// CHECK-NEXT:    [[DOTOMP_UB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_UB]] to ptr
// CHECK-NEXT:    [[DOTOMP_IV_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_IV]] to ptr
// CHECK-NEXT:    [[SUM8_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM8]] to ptr
// CHECK-NEXT:    store ptr [[DYN_PTR]], ptr [[DYN_PTR_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[B]], ptr [[B_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[SUM]], ptr [[SUM_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[A]], ptr [[A_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[SUM1]], ptr [[SUM_ADDR2_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR3_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[TMP2]], ptr [[DOTADDR4_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[TMP3]], ptr [[DOTADDR5_ASCAST]], align 8
// CHECK-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[SUM_ADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP5:%.*]] = load i64, ptr [[VLA_ADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP6:%.*]] = load ptr, ptr [[SUM_ADDR2_ASCAST]], align 8
// CHECK-NEXT:    call void @__kmpc_specialized_kernel_init()
// CHECK-NEXT:    [[TMP7:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    store i32 0, ptr addrspace(5) [[TMP7]], align 4
// CHECK-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// CHECK-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// CHECK-NEXT:    store i32 0, ptr [[DOTOMP_LB_ASCAST]], align 4
// CHECK-NEXT:    store i32 999999, ptr [[DOTOMP_UB_ASCAST]], align 4
// CHECK-NEXT:    [[TMP8:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// CHECK-NEXT:    store i32 [[TMP8]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP9:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// CHECK-NEXT:    [[NVPTX_NUM_THREADS:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// CHECK-NEXT:    [[GPU_BLOCK_ID:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// CHECK-NEXT:    [[TMP10:%.*]] = mul i32 [[GPU_BLOCK_ID]], [[NVPTX_NUM_THREADS]]
// CHECK-NEXT:    [[TMP11:%.*]] = add i32 [[TMP10]], [[TMP9]]
// CHECK-NEXT:    [[TMP12:%.*]] = mul i32 [[TMP11]], 1
// CHECK-NEXT:    [[TMP13:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP14:%.*]] = add i32 [[TMP12]], [[TMP13]]
// CHECK-NEXT:    [[TMP15:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// CHECK-NEXT:    [[TMP16:%.*]] = zext i32 [[TMP14]] to i64
// CHECK-NEXT:    store i32 [[TMP14]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[GLOBAL_UPPER_BOUND:%.*]] = load i32, ptr [[DOTOMP_UB_ASCAST]], align 4
// CHECK-NEXT:    [[TMP17:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// CHECK-NEXT:    [[TMP18:%.*]] = sub i32 [[GLOBAL_UPPER_BOUND]], [[TMP17]]
// CHECK-NEXT:    [[TMP19:%.*]] = add i32 [[TMP18]], 1
// CHECK-NEXT:    [[TMP20:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// CHECK-NEXT:    [[NVPTX_NUM_THREADS6:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// CHECK-NEXT:    [[GPU_BLOCK_ID7:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// CHECK-NEXT:    [[TMP21:%.*]] = mul i32 [[GPU_BLOCK_ID7]], [[NVPTX_NUM_THREADS6]]
// CHECK-NEXT:    [[TMP22:%.*]] = add i32 [[TMP21]], [[TMP20]]
// CHECK-NEXT:    [[TMP23:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// CHECK-NEXT:    [[TMP24:%.*]] = mul i32 [[NVPTX_NUM_THREADS6]], [[TMP23]]
// CHECK-NEXT:    [[TMP25:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP26:%.*]] = icmp ult i32 [[TMP25]], [[TMP24]]
// CHECK-NEXT:    br i1 [[TMP26]], label [[OMP_KERNEL_BODY:%.*]], label [[OMP_KERNEL_DONE:%.*]]
// CHECK:       omp.kernel.body:
// CHECK-NEXT:    [[TMP27:%.*]] = udiv i32 [[TMP19]], [[TMP24]]
// CHECK-NEXT:    [[PADDED_SEGMENT_SIZE:%.*]] = add i32 [[TMP27]], 1
// CHECK-NEXT:    [[TMP28:%.*]] = load ptr, ptr [[DOTADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP29:%.*]] = load ptr, ptr [[DOTADDR4_ASCAST]], align 8
// CHECK-NEXT:    [[TMP30:%.*]] = load ptr, ptr [[DOTADDR5_ASCAST]], align 8
// CHECK-NEXT:    [[TMP31:%.*]] = load i32, ptr addrspace(5) [[TMP7]], align 4
// CHECK-NEXT:    call void @__kmpc_xteams_phase2_i_16x64(ptr [[TMP29]], i32 [[PADDED_SEGMENT_SIZE]], ptr [[TMP28]], ptr [[TMP30]], ptr @__kmpc_rfun_sum_i, i32 0, i64 [[TMP16]], i32 0)
// CHECK-NEXT:    [[TMP32:%.*]] = mul i32 [[PADDED_SEGMENT_SIZE]], [[TMP22]]
// CHECK-NEXT:    store i32 [[TMP32]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP33:%.*]] = add i32 [[TMP22]], 1
// CHECK-NEXT:    [[TMP34:%.*]] = mul i32 [[PADDED_SEGMENT_SIZE]], [[TMP33]]
// CHECK-NEXT:    [[TMP35:%.*]] = load ptr, ptr [[DOTADDR5_ASCAST]], align 8
// CHECK-NEXT:    br label [[FOR_COND:%.*]]
// CHECK:       for.cond:
// CHECK-NEXT:    [[TMP36:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP37:%.*]] = icmp ult i32 [[TMP36]], [[TMP34]]
// CHECK-NEXT:    [[TMP38:%.*]] = icmp ule i32 [[TMP36]], [[GLOBAL_UPPER_BOUND]]
// CHECK-NEXT:    [[TMP39:%.*]] = and i1 [[TMP38]], [[TMP37]]
// CHECK-NEXT:    br i1 [[TMP39]], label [[FOR_BODY:%.*]], label [[FOR_END:%.*]]
// CHECK:       for.body:
// CHECK-NEXT:    [[TMP40:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP40]], 1
// CHECK-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK-NEXT:    store i32 [[ADD]], ptr [[I_ASCAST]], align 4
// CHECK-NEXT:    [[TMP41:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP42:%.*]] = getelementptr i32, ptr [[TMP35]], i32 [[TMP41]]
// CHECK-NEXT:    [[TMP43:%.*]] = load i32, ptr [[TMP42]], align 4
// CHECK-NEXT:    store i32 [[TMP43]], ptr addrspace(5) [[TMP7]], align 4
// CHECK-NEXT:    store i32 0, ptr [[SUM8_ASCAST]], align 4
// CHECK-NEXT:    br label [[OMP_INSCAN_DISPATCH:%.*]]
// CHECK:       omp.before.scan.bb:
// CHECK-NEXT:    [[TMP44:%.*]] = load ptr, ptr [[B_ADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP45:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// CHECK-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP45]] to i64
// CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, ptr [[TMP44]], i64 [[IDXPROM]]
// CHECK-NEXT:    [[TMP46:%.*]] = load i32, ptr addrspace(5) [[TMP7]], align 4
// CHECK-NEXT:    store i32 [[TMP46]], ptr [[ARRAYIDX]], align 4
// CHECK-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK:       omp.exit.inscan.bb:
// CHECK-NEXT:    br label [[OMP_BODY_CONTINUE]]
// CHECK:       omp.inscan.dispatch:
// CHECK-NEXT:    [[TMP47:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP48:%.*]] = zext i32 [[TMP47]] to i64
// CHECK-NEXT:    [[TMP49:%.*]] = icmp eq i64 [[TMP48]], 0
// CHECK-NEXT:    br i1 [[TMP49]], label [[OMP_EXCLUSIVE_COPY_EXIT:%.*]], label [[OMP_EXCLUSIVE_DEC:%.*]]
// CHECK:       omp.exclusive.dec:
// CHECK-NEXT:    [[TMP50:%.*]] = sub nuw i64 [[TMP48]], 1
// CHECK-NEXT:    [[ARRAYIDX9:%.*]] = getelementptr inbounds nuw i32, ptr [[TMP6]], i64 [[TMP50]]
// CHECK-NEXT:    [[TMP51:%.*]] = load i32, ptr addrspace(5) [[TMP7]], align 4
// CHECK-NEXT:    store i32 [[TMP51]], ptr [[TMP4]], align 4
// CHECK-NEXT:    br label [[OMP_EXCLUSIVE_COPY_EXIT]]
// CHECK:       omp.exclusive.copy.exit:
// CHECK-NEXT:    br label [[OMP_BEFORE_SCAN_BB:%.*]]
// CHECK:       omp.after.scan.bb:
// CHECK-NEXT:    [[TMP52:%.*]] = load ptr, ptr [[A_ADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP53:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// CHECK-NEXT:    [[IDXPROM10:%.*]] = sext i32 [[TMP53]] to i64
// CHECK-NEXT:    [[ARRAYIDX11:%.*]] = getelementptr inbounds i32, ptr [[TMP52]], i64 [[IDXPROM10]]
// CHECK-NEXT:    [[TMP54:%.*]] = load i32, ptr [[ARRAYIDX11]], align 4
// CHECK-NEXT:    [[TMP55:%.*]] = load i32, ptr addrspace(5) [[TMP7]], align 4
// CHECK-NEXT:    [[TMP56:%.*]] = add i32 [[TMP55]], [[TMP54]]
// CHECK-NEXT:    store i32 [[TMP56]], ptr addrspace(5) [[TMP7]], align 4
// CHECK-NEXT:    br label [[OMP_EXIT_INSCAN_BB:%.*]]
// CHECK:       omp.body.continue:
// CHECK-NEXT:    br label [[FOR_INC:%.*]]
// CHECK:       for.inc:
// CHECK-NEXT:    [[TMP57:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP58:%.*]] = getelementptr i32, ptr [[TMP35]], i32 [[TMP57]]
// CHECK-NEXT:    [[TMP59:%.*]] = load i32, ptr addrspace(5) [[TMP7]], align 4
// CHECK-NEXT:    store i32 [[TMP59]], ptr [[TMP58]], align 4
// CHECK-NEXT:    [[TMP60:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP61:%.*]] = add i32 1, [[TMP60]]
// CHECK-NEXT:    store i32 [[TMP61]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    br label [[FOR_COND]], !llvm.loop [[LOOP57:![0-9]+]]
// CHECK:       for.end:
// CHECK-NEXT:    br label [[OMP_KERNEL_DONE]]
// CHECK:       omp.kernel.done:
// CHECK-NEXT:    ret void
//
//
// CHECK-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z8run_testIlEvv_l35
// CHECK-SAME: (ptr noalias noundef [[DYN_PTR:%.*]], ptr noundef nonnull align 8 dereferenceable(8) [[SUM:%.*]], ptr noundef [[A:%.*]], ptr noundef [[B:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 8 dereferenceable(8) [[SUM1:%.*]], ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]], ptr noundef [[TMP2:%.*]], ptr noundef [[TMP3:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[DYN_PTR_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[SUM_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[A_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[B_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8, addrspace(5)
// CHECK-NEXT:    [[SUM_ADDR2:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[DOTADDR3:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[DOTADDR4:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[DOTADDR5:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[I:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[SUM8:%.*]] = alloca i64, align 8, addrspace(5)
// CHECK-NEXT:    [[DYN_PTR_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DYN_PTR_ADDR]] to ptr
// CHECK-NEXT:    [[SUM_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM_ADDR]] to ptr
// CHECK-NEXT:    [[A_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[A_ADDR]] to ptr
// CHECK-NEXT:    [[B_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[B_ADDR]] to ptr
// CHECK-NEXT:    [[VLA_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[VLA_ADDR]] to ptr
// CHECK-NEXT:    [[SUM_ADDR2_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM_ADDR2]] to ptr
// CHECK-NEXT:    [[DOTADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR]] to ptr
// CHECK-NEXT:    [[DOTADDR3_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR3]] to ptr
// CHECK-NEXT:    [[DOTADDR4_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR4]] to ptr
// CHECK-NEXT:    [[DOTADDR5_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR5]] to ptr
// CHECK-NEXT:    [[I_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[I]] to ptr
// CHECK-NEXT:    [[DOTOMP_LB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_LB]] to ptr
// CHECK-NEXT:    [[DOTOMP_UB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_UB]] to ptr
// CHECK-NEXT:    [[DOTOMP_IV_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_IV]] to ptr
// CHECK-NEXT:    [[SUM8_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM8]] to ptr
// CHECK-NEXT:    store ptr [[DYN_PTR]], ptr [[DYN_PTR_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[SUM]], ptr [[SUM_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[A]], ptr [[A_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[B]], ptr [[B_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[SUM1]], ptr [[SUM_ADDR2_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR3_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[TMP2]], ptr [[DOTADDR4_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[TMP3]], ptr [[DOTADDR5_ASCAST]], align 8
// CHECK-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[SUM_ADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP5:%.*]] = load i64, ptr [[VLA_ADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP6:%.*]] = load ptr, ptr [[SUM_ADDR2_ASCAST]], align 8
// CHECK-NEXT:    call void @__kmpc_specialized_kernel_init()
// CHECK-NEXT:    [[TMP7:%.*]] = alloca i64, align 8, addrspace(5)
// CHECK-NEXT:    store i64 0, ptr addrspace(5) [[TMP7]], align 8
// CHECK-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// CHECK-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// CHECK-NEXT:    store i32 0, ptr [[DOTOMP_LB_ASCAST]], align 4
// CHECK-NEXT:    store i32 999999, ptr [[DOTOMP_UB_ASCAST]], align 4
// CHECK-NEXT:    [[TMP8:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// CHECK-NEXT:    store i32 [[TMP8]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP9:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// CHECK-NEXT:    [[NVPTX_NUM_THREADS:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// CHECK-NEXT:    [[GPU_BLOCK_ID:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// CHECK-NEXT:    [[TMP10:%.*]] = mul i32 [[GPU_BLOCK_ID]], [[NVPTX_NUM_THREADS]]
// CHECK-NEXT:    [[TMP11:%.*]] = add i32 [[TMP10]], [[TMP9]]
// CHECK-NEXT:    [[TMP12:%.*]] = mul i32 [[TMP11]], 1
// CHECK-NEXT:    [[TMP13:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP14:%.*]] = add i32 [[TMP12]], [[TMP13]]
// CHECK-NEXT:    [[TMP15:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// CHECK-NEXT:    [[TMP16:%.*]] = zext i32 [[TMP14]] to i64
// CHECK-NEXT:    store i32 [[TMP14]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[GLOBAL_UPPER_BOUND:%.*]] = load i32, ptr [[DOTOMP_UB_ASCAST]], align 4
// CHECK-NEXT:    [[TMP17:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// CHECK-NEXT:    [[TMP18:%.*]] = sub i32 [[GLOBAL_UPPER_BOUND]], [[TMP17]]
// CHECK-NEXT:    [[TMP19:%.*]] = add i32 [[TMP18]], 1
// CHECK-NEXT:    [[TMP20:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// CHECK-NEXT:    [[NVPTX_NUM_THREADS6:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// CHECK-NEXT:    [[GPU_BLOCK_ID7:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// CHECK-NEXT:    [[TMP21:%.*]] = mul i32 [[GPU_BLOCK_ID7]], [[NVPTX_NUM_THREADS6]]
// CHECK-NEXT:    [[TMP22:%.*]] = add i32 [[TMP21]], [[TMP20]]
// CHECK-NEXT:    [[TMP23:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// CHECK-NEXT:    [[TMP24:%.*]] = mul i32 [[NVPTX_NUM_THREADS6]], [[TMP23]]
// CHECK-NEXT:    [[TMP25:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP26:%.*]] = icmp ult i32 [[TMP25]], [[TMP24]]
// CHECK-NEXT:    br i1 [[TMP26]], label [[OMP_KERNEL_BODY:%.*]], label [[OMP_KERNEL_DONE:%.*]]
// CHECK:       omp.kernel.body:
// CHECK-NEXT:    [[TMP27:%.*]] = udiv i32 [[TMP19]], [[TMP24]]
// CHECK-NEXT:    [[PADDED_SEGMENT_SIZE:%.*]] = add i32 [[TMP27]], 1
// CHECK-NEXT:    [[TMP28:%.*]] = mul i32 [[PADDED_SEGMENT_SIZE]], [[TMP22]]
// CHECK-NEXT:    store i32 [[TMP28]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP29:%.*]] = add i32 [[TMP22]], 1
// CHECK-NEXT:    [[TMP30:%.*]] = mul i32 [[PADDED_SEGMENT_SIZE]], [[TMP29]]
// CHECK-NEXT:    [[TMP31:%.*]] = load ptr, ptr [[DOTADDR5_ASCAST]], align 8
// CHECK-NEXT:    br label [[FOR_COND:%.*]]
// CHECK:       for.cond:
// CHECK-NEXT:    [[TMP32:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP33:%.*]] = icmp ult i32 [[TMP32]], [[TMP30]]
// CHECK-NEXT:    [[TMP34:%.*]] = icmp ule i32 [[TMP32]], [[GLOBAL_UPPER_BOUND]]
// CHECK-NEXT:    [[TMP35:%.*]] = and i1 [[TMP34]], [[TMP33]]
// CHECK-NEXT:    br i1 [[TMP35]], label [[FOR_BODY:%.*]], label [[FOR_END:%.*]]
// CHECK:       for.body:
// CHECK-NEXT:    [[TMP36:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP36]], 1
// CHECK-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK-NEXT:    store i32 [[ADD]], ptr [[I_ASCAST]], align 4
// CHECK-NEXT:    store i64 0, ptr [[SUM8_ASCAST]], align 8
// CHECK-NEXT:    br label [[OMP_INSCAN_DISPATCH:%.*]]
// CHECK:       omp.before.scan.bb:
// CHECK-NEXT:    [[TMP37:%.*]] = load ptr, ptr [[A_ADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP38:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// CHECK-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP38]] to i64
// CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i64, ptr [[TMP37]], i64 [[IDXPROM]]
// CHECK-NEXT:    [[TMP39:%.*]] = load i64, ptr [[ARRAYIDX]], align 8
// CHECK-NEXT:    [[TMP40:%.*]] = load i64, ptr addrspace(5) [[TMP7]], align 8
// CHECK-NEXT:    [[TMP41:%.*]] = add i64 [[TMP40]], [[TMP39]]
// CHECK-NEXT:    store i64 [[TMP41]], ptr addrspace(5) [[TMP7]], align 8
// CHECK-NEXT:    [[TMP42:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP43:%.*]] = zext i32 [[TMP42]] to i64
// CHECK-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK:       omp.exit.inscan.bb:
// CHECK-NEXT:    br label [[OMP_BODY_CONTINUE]]
// CHECK:       omp.inscan.dispatch:
// CHECK-NEXT:    br label [[OMP_BEFORE_SCAN_BB:%.*]]
// CHECK:       omp.after.scan.bb:
// CHECK-NEXT:    [[TMP44:%.*]] = load i64, ptr [[TMP4]], align 8
// CHECK-NEXT:    [[TMP45:%.*]] = load ptr, ptr [[B_ADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP46:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// CHECK-NEXT:    [[IDXPROM9:%.*]] = sext i32 [[TMP46]] to i64
// CHECK-NEXT:    [[ARRAYIDX10:%.*]] = getelementptr inbounds i64, ptr [[TMP45]], i64 [[IDXPROM9]]
// CHECK-NEXT:    store i64 [[TMP44]], ptr [[ARRAYIDX10]], align 8
// CHECK-NEXT:    br label [[OMP_EXIT_INSCAN_BB:%.*]]
// CHECK:       omp.body.continue:
// CHECK-NEXT:    br label [[FOR_INC:%.*]]
// CHECK:       for.inc:
// CHECK-NEXT:    [[TMP47:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP48:%.*]] = getelementptr i64, ptr [[TMP31]], i32 [[TMP47]]
// CHECK-NEXT:    [[TMP49:%.*]] = load i64, ptr addrspace(5) [[TMP7]], align 8
// CHECK-NEXT:    store i64 [[TMP49]], ptr [[TMP48]], align 8
// CHECK-NEXT:    [[TMP50:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP51:%.*]] = add i32 1, [[TMP50]]
// CHECK-NEXT:    store i32 [[TMP51]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    br label [[FOR_COND]], !llvm.loop [[LOOP58:![0-9]+]]
// CHECK:       for.end:
// CHECK-NEXT:    [[TMP52:%.*]] = load ptr, ptr [[DOTADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP53:%.*]] = load ptr, ptr [[DOTADDR3_ASCAST]], align 8
// CHECK-NEXT:    [[TMP54:%.*]] = load ptr, ptr [[DOTADDR4_ASCAST]], align 8
// CHECK-NEXT:    [[TMP55:%.*]] = load i64, ptr addrspace(5) [[TMP7]], align 8
// CHECK-NEXT:    call void @__kmpc_xteams_l_16x64(i64 [[TMP55]], ptr [[TMP54]], ptr [[TMP4]], ptr [[TMP52]], ptr [[TMP53]], ptr @__kmpc_rfun_sum_l, ptr @__kmpc_rfun_sum_lds_l, i64 0, i64 [[TMP16]], i32 [[TMP15]])
// CHECK-NEXT:    br label [[OMP_KERNEL_DONE]]
// CHECK:       omp.kernel.done:
// CHECK-NEXT:    ret void
//
//
// CHECK-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z8run_testIlEvv_l35_1
// CHECK-SAME: (ptr noalias noundef [[DYN_PTR:%.*]], ptr noundef nonnull align 8 dereferenceable(8) [[SUM:%.*]], ptr noundef [[A:%.*]], ptr noundef [[B:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 8 dereferenceable(8) [[SUM1:%.*]], ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]], ptr noundef [[TMP2:%.*]], ptr noundef [[TMP3:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[DYN_PTR_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[SUM_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[A_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[B_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8, addrspace(5)
// CHECK-NEXT:    [[SUM_ADDR2:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[DOTADDR3:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[DOTADDR4:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[DOTADDR5:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[I:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[SUM8:%.*]] = alloca i64, align 8, addrspace(5)
// CHECK-NEXT:    [[DYN_PTR_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DYN_PTR_ADDR]] to ptr
// CHECK-NEXT:    [[SUM_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM_ADDR]] to ptr
// CHECK-NEXT:    [[A_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[A_ADDR]] to ptr
// CHECK-NEXT:    [[B_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[B_ADDR]] to ptr
// CHECK-NEXT:    [[VLA_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[VLA_ADDR]] to ptr
// CHECK-NEXT:    [[SUM_ADDR2_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM_ADDR2]] to ptr
// CHECK-NEXT:    [[DOTADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR]] to ptr
// CHECK-NEXT:    [[DOTADDR3_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR3]] to ptr
// CHECK-NEXT:    [[DOTADDR4_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR4]] to ptr
// CHECK-NEXT:    [[DOTADDR5_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR5]] to ptr
// CHECK-NEXT:    [[I_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[I]] to ptr
// CHECK-NEXT:    [[DOTOMP_LB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_LB]] to ptr
// CHECK-NEXT:    [[DOTOMP_UB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_UB]] to ptr
// CHECK-NEXT:    [[DOTOMP_IV_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_IV]] to ptr
// CHECK-NEXT:    [[SUM8_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM8]] to ptr
// CHECK-NEXT:    store ptr [[DYN_PTR]], ptr [[DYN_PTR_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[SUM]], ptr [[SUM_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[A]], ptr [[A_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[B]], ptr [[B_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[SUM1]], ptr [[SUM_ADDR2_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR3_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[TMP2]], ptr [[DOTADDR4_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[TMP3]], ptr [[DOTADDR5_ASCAST]], align 8
// CHECK-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[SUM_ADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP5:%.*]] = load i64, ptr [[VLA_ADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP6:%.*]] = load ptr, ptr [[SUM_ADDR2_ASCAST]], align 8
// CHECK-NEXT:    call void @__kmpc_specialized_kernel_init()
// CHECK-NEXT:    [[TMP7:%.*]] = alloca i64, align 8, addrspace(5)
// CHECK-NEXT:    store i64 0, ptr addrspace(5) [[TMP7]], align 8
// CHECK-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// CHECK-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// CHECK-NEXT:    store i32 0, ptr [[DOTOMP_LB_ASCAST]], align 4
// CHECK-NEXT:    store i32 999999, ptr [[DOTOMP_UB_ASCAST]], align 4
// CHECK-NEXT:    [[TMP8:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// CHECK-NEXT:    store i32 [[TMP8]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP9:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// CHECK-NEXT:    [[NVPTX_NUM_THREADS:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// CHECK-NEXT:    [[GPU_BLOCK_ID:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// CHECK-NEXT:    [[TMP10:%.*]] = mul i32 [[GPU_BLOCK_ID]], [[NVPTX_NUM_THREADS]]
// CHECK-NEXT:    [[TMP11:%.*]] = add i32 [[TMP10]], [[TMP9]]
// CHECK-NEXT:    [[TMP12:%.*]] = mul i32 [[TMP11]], 1
// CHECK-NEXT:    [[TMP13:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP14:%.*]] = add i32 [[TMP12]], [[TMP13]]
// CHECK-NEXT:    [[TMP15:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// CHECK-NEXT:    [[TMP16:%.*]] = zext i32 [[TMP14]] to i64
// CHECK-NEXT:    store i32 [[TMP14]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[GLOBAL_UPPER_BOUND:%.*]] = load i32, ptr [[DOTOMP_UB_ASCAST]], align 4
// CHECK-NEXT:    [[TMP17:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// CHECK-NEXT:    [[TMP18:%.*]] = sub i32 [[GLOBAL_UPPER_BOUND]], [[TMP17]]
// CHECK-NEXT:    [[TMP19:%.*]] = add i32 [[TMP18]], 1
// CHECK-NEXT:    [[TMP20:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// CHECK-NEXT:    [[NVPTX_NUM_THREADS6:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// CHECK-NEXT:    [[GPU_BLOCK_ID7:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// CHECK-NEXT:    [[TMP21:%.*]] = mul i32 [[GPU_BLOCK_ID7]], [[NVPTX_NUM_THREADS6]]
// CHECK-NEXT:    [[TMP22:%.*]] = add i32 [[TMP21]], [[TMP20]]
// CHECK-NEXT:    [[TMP23:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// CHECK-NEXT:    [[TMP24:%.*]] = mul i32 [[NVPTX_NUM_THREADS6]], [[TMP23]]
// CHECK-NEXT:    [[TMP25:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP26:%.*]] = icmp ult i32 [[TMP25]], [[TMP24]]
// CHECK-NEXT:    br i1 [[TMP26]], label [[OMP_KERNEL_BODY:%.*]], label [[OMP_KERNEL_DONE:%.*]]
// CHECK:       omp.kernel.body:
// CHECK-NEXT:    [[TMP27:%.*]] = udiv i32 [[TMP19]], [[TMP24]]
// CHECK-NEXT:    [[PADDED_SEGMENT_SIZE:%.*]] = add i32 [[TMP27]], 1
// CHECK-NEXT:    [[TMP28:%.*]] = load ptr, ptr [[DOTADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP29:%.*]] = load ptr, ptr [[DOTADDR4_ASCAST]], align 8
// CHECK-NEXT:    [[TMP30:%.*]] = load ptr, ptr [[DOTADDR5_ASCAST]], align 8
// CHECK-NEXT:    [[TMP31:%.*]] = load i64, ptr addrspace(5) [[TMP7]], align 8
// CHECK-NEXT:    call void @__kmpc_xteams_phase2_l_16x64(ptr [[TMP29]], i32 [[PADDED_SEGMENT_SIZE]], ptr [[TMP28]], ptr [[TMP30]], ptr @__kmpc_rfun_sum_l, i64 0, i64 [[TMP16]], i32 1)
// CHECK-NEXT:    [[TMP32:%.*]] = mul i32 [[PADDED_SEGMENT_SIZE]], [[TMP22]]
// CHECK-NEXT:    store i32 [[TMP32]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP33:%.*]] = add i32 [[TMP22]], 1
// CHECK-NEXT:    [[TMP34:%.*]] = mul i32 [[PADDED_SEGMENT_SIZE]], [[TMP33]]
// CHECK-NEXT:    [[TMP35:%.*]] = load ptr, ptr [[DOTADDR5_ASCAST]], align 8
// CHECK-NEXT:    br label [[FOR_COND:%.*]]
// CHECK:       for.cond:
// CHECK-NEXT:    [[TMP36:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP37:%.*]] = icmp ult i32 [[TMP36]], [[TMP34]]
// CHECK-NEXT:    [[TMP38:%.*]] = icmp ule i32 [[TMP36]], [[GLOBAL_UPPER_BOUND]]
// CHECK-NEXT:    [[TMP39:%.*]] = and i1 [[TMP38]], [[TMP37]]
// CHECK-NEXT:    br i1 [[TMP39]], label [[FOR_BODY:%.*]], label [[FOR_END:%.*]]
// CHECK:       for.body:
// CHECK-NEXT:    [[TMP40:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP40]], 1
// CHECK-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK-NEXT:    store i32 [[ADD]], ptr [[I_ASCAST]], align 4
// CHECK-NEXT:    [[TMP41:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP42:%.*]] = getelementptr i64, ptr [[TMP35]], i32 [[TMP41]]
// CHECK-NEXT:    [[TMP43:%.*]] = load i64, ptr [[TMP42]], align 8
// CHECK-NEXT:    store i64 [[TMP43]], ptr addrspace(5) [[TMP7]], align 8
// CHECK-NEXT:    store i64 0, ptr [[SUM8_ASCAST]], align 8
// CHECK-NEXT:    br label [[OMP_INSCAN_DISPATCH:%.*]]
// CHECK:       omp.before.scan.bb:
// CHECK-NEXT:    [[TMP44:%.*]] = load ptr, ptr [[A_ADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP45:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// CHECK-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP45]] to i64
// CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i64, ptr [[TMP44]], i64 [[IDXPROM]]
// CHECK-NEXT:    [[TMP46:%.*]] = load i64, ptr [[ARRAYIDX]], align 8
// CHECK-NEXT:    [[TMP47:%.*]] = load i64, ptr addrspace(5) [[TMP7]], align 8
// CHECK-NEXT:    [[TMP48:%.*]] = add i64 [[TMP47]], [[TMP46]]
// CHECK-NEXT:    store i64 [[TMP48]], ptr addrspace(5) [[TMP7]], align 8
// CHECK-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK:       omp.exit.inscan.bb:
// CHECK-NEXT:    br label [[OMP_BODY_CONTINUE]]
// CHECK:       omp.inscan.dispatch:
// CHECK-NEXT:    [[TMP49:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP50:%.*]] = zext i32 [[TMP49]] to i64
// CHECK-NEXT:    [[ARRAYIDX9:%.*]] = getelementptr inbounds nuw i64, ptr [[TMP6]], i64 [[TMP50]]
// CHECK-NEXT:    [[TMP51:%.*]] = load i64, ptr addrspace(5) [[TMP7]], align 8
// CHECK-NEXT:    store i64 [[TMP51]], ptr [[TMP4]], align 8
// CHECK-NEXT:    br label [[OMP_AFTER_SCAN_BB:%.*]]
// CHECK:       omp.after.scan.bb:
// CHECK-NEXT:    [[TMP52:%.*]] = load ptr, ptr [[B_ADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP53:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// CHECK-NEXT:    [[IDXPROM10:%.*]] = sext i32 [[TMP53]] to i64
// CHECK-NEXT:    [[ARRAYIDX11:%.*]] = getelementptr inbounds i64, ptr [[TMP52]], i64 [[IDXPROM10]]
// CHECK-NEXT:    [[TMP54:%.*]] = load i64, ptr addrspace(5) [[TMP7]], align 8
// CHECK-NEXT:    store i64 [[TMP54]], ptr [[ARRAYIDX11]], align 8
// CHECK-NEXT:    br label [[OMP_EXIT_INSCAN_BB:%.*]]
// CHECK:       omp.body.continue:
// CHECK-NEXT:    br label [[FOR_INC:%.*]]
// CHECK:       for.inc:
// CHECK-NEXT:    [[TMP55:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP56:%.*]] = getelementptr i64, ptr [[TMP35]], i32 [[TMP55]]
// CHECK-NEXT:    [[TMP57:%.*]] = load i64, ptr addrspace(5) [[TMP7]], align 8
// CHECK-NEXT:    store i64 [[TMP57]], ptr [[TMP56]], align 8
// CHECK-NEXT:    [[TMP58:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP59:%.*]] = add i32 1, [[TMP58]]
// CHECK-NEXT:    store i32 [[TMP59]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    br label [[FOR_COND]], !llvm.loop [[LOOP59:![0-9]+]]
// CHECK:       for.end:
// CHECK-NEXT:    br label [[OMP_KERNEL_DONE]]
// CHECK:       omp.kernel.done:
// CHECK-NEXT:    ret void
//
//
// CHECK-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z8run_testIlEvv_l47
// CHECK-SAME: (ptr noalias noundef [[DYN_PTR:%.*]], ptr noundef [[B:%.*]], ptr noundef nonnull align 8 dereferenceable(8) [[SUM:%.*]], ptr noundef [[A:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 8 dereferenceable(8) [[SUM1:%.*]], ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]], ptr noundef [[TMP2:%.*]], ptr noundef [[TMP3:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[DYN_PTR_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[B_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[SUM_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[A_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8, addrspace(5)
// CHECK-NEXT:    [[SUM_ADDR2:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[DOTADDR3:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[DOTADDR4:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[DOTADDR5:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[I:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[SUM8:%.*]] = alloca i64, align 8, addrspace(5)
// CHECK-NEXT:    [[DYN_PTR_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DYN_PTR_ADDR]] to ptr
// CHECK-NEXT:    [[B_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[B_ADDR]] to ptr
// CHECK-NEXT:    [[SUM_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM_ADDR]] to ptr
// CHECK-NEXT:    [[A_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[A_ADDR]] to ptr
// CHECK-NEXT:    [[VLA_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[VLA_ADDR]] to ptr
// CHECK-NEXT:    [[SUM_ADDR2_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM_ADDR2]] to ptr
// CHECK-NEXT:    [[DOTADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR]] to ptr
// CHECK-NEXT:    [[DOTADDR3_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR3]] to ptr
// CHECK-NEXT:    [[DOTADDR4_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR4]] to ptr
// CHECK-NEXT:    [[DOTADDR5_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR5]] to ptr
// CHECK-NEXT:    [[I_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[I]] to ptr
// CHECK-NEXT:    [[DOTOMP_LB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_LB]] to ptr
// CHECK-NEXT:    [[DOTOMP_UB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_UB]] to ptr
// CHECK-NEXT:    [[DOTOMP_IV_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_IV]] to ptr
// CHECK-NEXT:    [[SUM8_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM8]] to ptr
// CHECK-NEXT:    store ptr [[DYN_PTR]], ptr [[DYN_PTR_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[B]], ptr [[B_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[SUM]], ptr [[SUM_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[A]], ptr [[A_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[SUM1]], ptr [[SUM_ADDR2_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR3_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[TMP2]], ptr [[DOTADDR4_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[TMP3]], ptr [[DOTADDR5_ASCAST]], align 8
// CHECK-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[SUM_ADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP5:%.*]] = load i64, ptr [[VLA_ADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP6:%.*]] = load ptr, ptr [[SUM_ADDR2_ASCAST]], align 8
// CHECK-NEXT:    call void @__kmpc_specialized_kernel_init()
// CHECK-NEXT:    [[TMP7:%.*]] = alloca i64, align 8, addrspace(5)
// CHECK-NEXT:    store i64 0, ptr addrspace(5) [[TMP7]], align 8
// CHECK-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// CHECK-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// CHECK-NEXT:    store i32 0, ptr [[DOTOMP_LB_ASCAST]], align 4
// CHECK-NEXT:    store i32 999999, ptr [[DOTOMP_UB_ASCAST]], align 4
// CHECK-NEXT:    [[TMP8:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// CHECK-NEXT:    store i32 [[TMP8]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP9:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// CHECK-NEXT:    [[NVPTX_NUM_THREADS:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// CHECK-NEXT:    [[GPU_BLOCK_ID:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// CHECK-NEXT:    [[TMP10:%.*]] = mul i32 [[GPU_BLOCK_ID]], [[NVPTX_NUM_THREADS]]
// CHECK-NEXT:    [[TMP11:%.*]] = add i32 [[TMP10]], [[TMP9]]
// CHECK-NEXT:    [[TMP12:%.*]] = mul i32 [[TMP11]], 1
// CHECK-NEXT:    [[TMP13:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP14:%.*]] = add i32 [[TMP12]], [[TMP13]]
// CHECK-NEXT:    [[TMP15:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// CHECK-NEXT:    [[TMP16:%.*]] = zext i32 [[TMP14]] to i64
// CHECK-NEXT:    store i32 [[TMP14]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[GLOBAL_UPPER_BOUND:%.*]] = load i32, ptr [[DOTOMP_UB_ASCAST]], align 4
// CHECK-NEXT:    [[TMP17:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// CHECK-NEXT:    [[TMP18:%.*]] = sub i32 [[GLOBAL_UPPER_BOUND]], [[TMP17]]
// CHECK-NEXT:    [[TMP19:%.*]] = add i32 [[TMP18]], 1
// CHECK-NEXT:    [[TMP20:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// CHECK-NEXT:    [[NVPTX_NUM_THREADS6:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// CHECK-NEXT:    [[GPU_BLOCK_ID7:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// CHECK-NEXT:    [[TMP21:%.*]] = mul i32 [[GPU_BLOCK_ID7]], [[NVPTX_NUM_THREADS6]]
// CHECK-NEXT:    [[TMP22:%.*]] = add i32 [[TMP21]], [[TMP20]]
// CHECK-NEXT:    [[TMP23:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// CHECK-NEXT:    [[TMP24:%.*]] = mul i32 [[NVPTX_NUM_THREADS6]], [[TMP23]]
// CHECK-NEXT:    [[TMP25:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP26:%.*]] = icmp ult i32 [[TMP25]], [[TMP24]]
// CHECK-NEXT:    br i1 [[TMP26]], label [[OMP_KERNEL_BODY:%.*]], label [[OMP_KERNEL_DONE:%.*]]
// CHECK:       omp.kernel.body:
// CHECK-NEXT:    [[TMP27:%.*]] = udiv i32 [[TMP19]], [[TMP24]]
// CHECK-NEXT:    [[PADDED_SEGMENT_SIZE:%.*]] = add i32 [[TMP27]], 1
// CHECK-NEXT:    [[TMP28:%.*]] = mul i32 [[PADDED_SEGMENT_SIZE]], [[TMP22]]
// CHECK-NEXT:    store i32 [[TMP28]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP29:%.*]] = add i32 [[TMP22]], 1
// CHECK-NEXT:    [[TMP30:%.*]] = mul i32 [[PADDED_SEGMENT_SIZE]], [[TMP29]]
// CHECK-NEXT:    [[TMP31:%.*]] = load ptr, ptr [[DOTADDR5_ASCAST]], align 8
// CHECK-NEXT:    br label [[FOR_COND:%.*]]
// CHECK:       for.cond:
// CHECK-NEXT:    [[TMP32:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP33:%.*]] = icmp ult i32 [[TMP32]], [[TMP30]]
// CHECK-NEXT:    [[TMP34:%.*]] = icmp ule i32 [[TMP32]], [[GLOBAL_UPPER_BOUND]]
// CHECK-NEXT:    [[TMP35:%.*]] = and i1 [[TMP34]], [[TMP33]]
// CHECK-NEXT:    br i1 [[TMP35]], label [[FOR_BODY:%.*]], label [[FOR_END:%.*]]
// CHECK:       for.body:
// CHECK-NEXT:    [[TMP36:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP36]], 1
// CHECK-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK-NEXT:    store i32 [[ADD]], ptr [[I_ASCAST]], align 4
// CHECK-NEXT:    store i64 0, ptr [[SUM8_ASCAST]], align 8
// CHECK-NEXT:    br label [[OMP_INSCAN_DISPATCH:%.*]]
// CHECK:       omp.before.scan.bb:
// CHECK-NEXT:    [[TMP37:%.*]] = load i64, ptr [[TMP4]], align 8
// CHECK-NEXT:    [[TMP38:%.*]] = load ptr, ptr [[B_ADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP39:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// CHECK-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP39]] to i64
// CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i64, ptr [[TMP38]], i64 [[IDXPROM]]
// CHECK-NEXT:    store i64 [[TMP37]], ptr [[ARRAYIDX]], align 8
// CHECK-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK:       omp.exit.inscan.bb:
// CHECK-NEXT:    [[TMP40:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP41:%.*]] = zext i32 [[TMP40]] to i64
// CHECK-NEXT:    br label [[OMP_BODY_CONTINUE]]
// CHECK:       omp.inscan.dispatch:
// CHECK-NEXT:    br label [[OMP_AFTER_SCAN_BB:%.*]]
// CHECK:       omp.after.scan.bb:
// CHECK-NEXT:    [[TMP42:%.*]] = load ptr, ptr [[A_ADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP43:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// CHECK-NEXT:    [[IDXPROM9:%.*]] = sext i32 [[TMP43]] to i64
// CHECK-NEXT:    [[ARRAYIDX10:%.*]] = getelementptr inbounds i64, ptr [[TMP42]], i64 [[IDXPROM9]]
// CHECK-NEXT:    [[TMP44:%.*]] = load i64, ptr [[ARRAYIDX10]], align 8
// CHECK-NEXT:    [[TMP45:%.*]] = load i64, ptr addrspace(5) [[TMP7]], align 8
// CHECK-NEXT:    [[TMP46:%.*]] = add i64 [[TMP45]], [[TMP44]]
// CHECK-NEXT:    store i64 [[TMP46]], ptr addrspace(5) [[TMP7]], align 8
// CHECK-NEXT:    br label [[OMP_EXIT_INSCAN_BB:%.*]]
// CHECK:       omp.body.continue:
// CHECK-NEXT:    br label [[FOR_INC:%.*]]
// CHECK:       for.inc:
// CHECK-NEXT:    [[TMP47:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP48:%.*]] = getelementptr i64, ptr [[TMP31]], i32 [[TMP47]]
// CHECK-NEXT:    [[TMP49:%.*]] = load i64, ptr addrspace(5) [[TMP7]], align 8
// CHECK-NEXT:    store i64 [[TMP49]], ptr [[TMP48]], align 8
// CHECK-NEXT:    [[TMP50:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP51:%.*]] = add i32 1, [[TMP50]]
// CHECK-NEXT:    store i32 [[TMP51]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    br label [[FOR_COND]], !llvm.loop [[LOOP60:![0-9]+]]
// CHECK:       for.end:
// CHECK-NEXT:    [[TMP52:%.*]] = load ptr, ptr [[DOTADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP53:%.*]] = load ptr, ptr [[DOTADDR3_ASCAST]], align 8
// CHECK-NEXT:    [[TMP54:%.*]] = load ptr, ptr [[DOTADDR4_ASCAST]], align 8
// CHECK-NEXT:    [[TMP55:%.*]] = load i64, ptr addrspace(5) [[TMP7]], align 8
// CHECK-NEXT:    call void @__kmpc_xteams_l_16x64(i64 [[TMP55]], ptr [[TMP54]], ptr [[TMP4]], ptr [[TMP52]], ptr [[TMP53]], ptr @__kmpc_rfun_sum_l, ptr @__kmpc_rfun_sum_lds_l, i64 0, i64 [[TMP16]], i32 [[TMP15]])
// CHECK-NEXT:    br label [[OMP_KERNEL_DONE]]
// CHECK:       omp.kernel.done:
// CHECK-NEXT:    ret void
//
//
// CHECK-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z8run_testIlEvv_l47_1
// CHECK-SAME: (ptr noalias noundef [[DYN_PTR:%.*]], ptr noundef [[B:%.*]], ptr noundef nonnull align 8 dereferenceable(8) [[SUM:%.*]], ptr noundef [[A:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 8 dereferenceable(8) [[SUM1:%.*]], ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]], ptr noundef [[TMP2:%.*]], ptr noundef [[TMP3:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[DYN_PTR_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[B_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[SUM_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[A_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8, addrspace(5)
// CHECK-NEXT:    [[SUM_ADDR2:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[DOTADDR3:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[DOTADDR4:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[DOTADDR5:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[I:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[SUM8:%.*]] = alloca i64, align 8, addrspace(5)
// CHECK-NEXT:    [[DYN_PTR_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DYN_PTR_ADDR]] to ptr
// CHECK-NEXT:    [[B_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[B_ADDR]] to ptr
// CHECK-NEXT:    [[SUM_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM_ADDR]] to ptr
// CHECK-NEXT:    [[A_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[A_ADDR]] to ptr
// CHECK-NEXT:    [[VLA_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[VLA_ADDR]] to ptr
// CHECK-NEXT:    [[SUM_ADDR2_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM_ADDR2]] to ptr
// CHECK-NEXT:    [[DOTADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR]] to ptr
// CHECK-NEXT:    [[DOTADDR3_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR3]] to ptr
// CHECK-NEXT:    [[DOTADDR4_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR4]] to ptr
// CHECK-NEXT:    [[DOTADDR5_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR5]] to ptr
// CHECK-NEXT:    [[I_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[I]] to ptr
// CHECK-NEXT:    [[DOTOMP_LB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_LB]] to ptr
// CHECK-NEXT:    [[DOTOMP_UB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_UB]] to ptr
// CHECK-NEXT:    [[DOTOMP_IV_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_IV]] to ptr
// CHECK-NEXT:    [[SUM8_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM8]] to ptr
// CHECK-NEXT:    store ptr [[DYN_PTR]], ptr [[DYN_PTR_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[B]], ptr [[B_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[SUM]], ptr [[SUM_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[A]], ptr [[A_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[SUM1]], ptr [[SUM_ADDR2_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR3_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[TMP2]], ptr [[DOTADDR4_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[TMP3]], ptr [[DOTADDR5_ASCAST]], align 8
// CHECK-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[SUM_ADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP5:%.*]] = load i64, ptr [[VLA_ADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP6:%.*]] = load ptr, ptr [[SUM_ADDR2_ASCAST]], align 8
// CHECK-NEXT:    call void @__kmpc_specialized_kernel_init()
// CHECK-NEXT:    [[TMP7:%.*]] = alloca i64, align 8, addrspace(5)
// CHECK-NEXT:    store i64 0, ptr addrspace(5) [[TMP7]], align 8
// CHECK-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// CHECK-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// CHECK-NEXT:    store i32 0, ptr [[DOTOMP_LB_ASCAST]], align 4
// CHECK-NEXT:    store i32 999999, ptr [[DOTOMP_UB_ASCAST]], align 4
// CHECK-NEXT:    [[TMP8:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// CHECK-NEXT:    store i32 [[TMP8]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP9:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// CHECK-NEXT:    [[NVPTX_NUM_THREADS:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// CHECK-NEXT:    [[GPU_BLOCK_ID:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// CHECK-NEXT:    [[TMP10:%.*]] = mul i32 [[GPU_BLOCK_ID]], [[NVPTX_NUM_THREADS]]
// CHECK-NEXT:    [[TMP11:%.*]] = add i32 [[TMP10]], [[TMP9]]
// CHECK-NEXT:    [[TMP12:%.*]] = mul i32 [[TMP11]], 1
// CHECK-NEXT:    [[TMP13:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP14:%.*]] = add i32 [[TMP12]], [[TMP13]]
// CHECK-NEXT:    [[TMP15:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// CHECK-NEXT:    [[TMP16:%.*]] = zext i32 [[TMP14]] to i64
// CHECK-NEXT:    store i32 [[TMP14]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[GLOBAL_UPPER_BOUND:%.*]] = load i32, ptr [[DOTOMP_UB_ASCAST]], align 4
// CHECK-NEXT:    [[TMP17:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// CHECK-NEXT:    [[TMP18:%.*]] = sub i32 [[GLOBAL_UPPER_BOUND]], [[TMP17]]
// CHECK-NEXT:    [[TMP19:%.*]] = add i32 [[TMP18]], 1
// CHECK-NEXT:    [[TMP20:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// CHECK-NEXT:    [[NVPTX_NUM_THREADS6:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// CHECK-NEXT:    [[GPU_BLOCK_ID7:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// CHECK-NEXT:    [[TMP21:%.*]] = mul i32 [[GPU_BLOCK_ID7]], [[NVPTX_NUM_THREADS6]]
// CHECK-NEXT:    [[TMP22:%.*]] = add i32 [[TMP21]], [[TMP20]]
// CHECK-NEXT:    [[TMP23:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// CHECK-NEXT:    [[TMP24:%.*]] = mul i32 [[NVPTX_NUM_THREADS6]], [[TMP23]]
// CHECK-NEXT:    [[TMP25:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP26:%.*]] = icmp ult i32 [[TMP25]], [[TMP24]]
// CHECK-NEXT:    br i1 [[TMP26]], label [[OMP_KERNEL_BODY:%.*]], label [[OMP_KERNEL_DONE:%.*]]
// CHECK:       omp.kernel.body:
// CHECK-NEXT:    [[TMP27:%.*]] = udiv i32 [[TMP19]], [[TMP24]]
// CHECK-NEXT:    [[PADDED_SEGMENT_SIZE:%.*]] = add i32 [[TMP27]], 1
// CHECK-NEXT:    [[TMP28:%.*]] = load ptr, ptr [[DOTADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP29:%.*]] = load ptr, ptr [[DOTADDR4_ASCAST]], align 8
// CHECK-NEXT:    [[TMP30:%.*]] = load ptr, ptr [[DOTADDR5_ASCAST]], align 8
// CHECK-NEXT:    [[TMP31:%.*]] = load i64, ptr addrspace(5) [[TMP7]], align 8
// CHECK-NEXT:    call void @__kmpc_xteams_phase2_l_16x64(ptr [[TMP29]], i32 [[PADDED_SEGMENT_SIZE]], ptr [[TMP28]], ptr [[TMP30]], ptr @__kmpc_rfun_sum_l, i64 0, i64 [[TMP16]], i32 0)
// CHECK-NEXT:    [[TMP32:%.*]] = mul i32 [[PADDED_SEGMENT_SIZE]], [[TMP22]]
// CHECK-NEXT:    store i32 [[TMP32]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP33:%.*]] = add i32 [[TMP22]], 1
// CHECK-NEXT:    [[TMP34:%.*]] = mul i32 [[PADDED_SEGMENT_SIZE]], [[TMP33]]
// CHECK-NEXT:    [[TMP35:%.*]] = load ptr, ptr [[DOTADDR5_ASCAST]], align 8
// CHECK-NEXT:    br label [[FOR_COND:%.*]]
// CHECK:       for.cond:
// CHECK-NEXT:    [[TMP36:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP37:%.*]] = icmp ult i32 [[TMP36]], [[TMP34]]
// CHECK-NEXT:    [[TMP38:%.*]] = icmp ule i32 [[TMP36]], [[GLOBAL_UPPER_BOUND]]
// CHECK-NEXT:    [[TMP39:%.*]] = and i1 [[TMP38]], [[TMP37]]
// CHECK-NEXT:    br i1 [[TMP39]], label [[FOR_BODY:%.*]], label [[FOR_END:%.*]]
// CHECK:       for.body:
// CHECK-NEXT:    [[TMP40:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP40]], 1
// CHECK-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK-NEXT:    store i32 [[ADD]], ptr [[I_ASCAST]], align 4
// CHECK-NEXT:    [[TMP41:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP42:%.*]] = getelementptr i64, ptr [[TMP35]], i32 [[TMP41]]
// CHECK-NEXT:    [[TMP43:%.*]] = load i64, ptr [[TMP42]], align 8
// CHECK-NEXT:    store i64 [[TMP43]], ptr addrspace(5) [[TMP7]], align 8
// CHECK-NEXT:    store i64 0, ptr [[SUM8_ASCAST]], align 8
// CHECK-NEXT:    br label [[OMP_INSCAN_DISPATCH:%.*]]
// CHECK:       omp.before.scan.bb:
// CHECK-NEXT:    [[TMP44:%.*]] = load ptr, ptr [[B_ADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP45:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// CHECK-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP45]] to i64
// CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i64, ptr [[TMP44]], i64 [[IDXPROM]]
// CHECK-NEXT:    [[TMP46:%.*]] = load i64, ptr addrspace(5) [[TMP7]], align 8
// CHECK-NEXT:    store i64 [[TMP46]], ptr [[ARRAYIDX]], align 8
// CHECK-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK:       omp.exit.inscan.bb:
// CHECK-NEXT:    br label [[OMP_BODY_CONTINUE]]
// CHECK:       omp.inscan.dispatch:
// CHECK-NEXT:    [[TMP47:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP48:%.*]] = zext i32 [[TMP47]] to i64
// CHECK-NEXT:    [[TMP49:%.*]] = icmp eq i64 [[TMP48]], 0
// CHECK-NEXT:    br i1 [[TMP49]], label [[OMP_EXCLUSIVE_COPY_EXIT:%.*]], label [[OMP_EXCLUSIVE_DEC:%.*]]
// CHECK:       omp.exclusive.dec:
// CHECK-NEXT:    [[TMP50:%.*]] = sub nuw i64 [[TMP48]], 1
// CHECK-NEXT:    [[ARRAYIDX9:%.*]] = getelementptr inbounds nuw i64, ptr [[TMP6]], i64 [[TMP50]]
// CHECK-NEXT:    [[TMP51:%.*]] = load i64, ptr addrspace(5) [[TMP7]], align 8
// CHECK-NEXT:    store i64 [[TMP51]], ptr [[TMP4]], align 8
// CHECK-NEXT:    br label [[OMP_EXCLUSIVE_COPY_EXIT]]
// CHECK:       omp.exclusive.copy.exit:
// CHECK-NEXT:    br label [[OMP_BEFORE_SCAN_BB:%.*]]
// CHECK:       omp.after.scan.bb:
// CHECK-NEXT:    [[TMP52:%.*]] = load ptr, ptr [[A_ADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP53:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// CHECK-NEXT:    [[IDXPROM10:%.*]] = sext i32 [[TMP53]] to i64
// CHECK-NEXT:    [[ARRAYIDX11:%.*]] = getelementptr inbounds i64, ptr [[TMP52]], i64 [[IDXPROM10]]
// CHECK-NEXT:    [[TMP54:%.*]] = load i64, ptr [[ARRAYIDX11]], align 8
// CHECK-NEXT:    [[TMP55:%.*]] = load i64, ptr addrspace(5) [[TMP7]], align 8
// CHECK-NEXT:    [[TMP56:%.*]] = add i64 [[TMP55]], [[TMP54]]
// CHECK-NEXT:    store i64 [[TMP56]], ptr addrspace(5) [[TMP7]], align 8
// CHECK-NEXT:    br label [[OMP_EXIT_INSCAN_BB:%.*]]
// CHECK:       omp.body.continue:
// CHECK-NEXT:    br label [[FOR_INC:%.*]]
// CHECK:       for.inc:
// CHECK-NEXT:    [[TMP57:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP58:%.*]] = getelementptr i64, ptr [[TMP35]], i32 [[TMP57]]
// CHECK-NEXT:    [[TMP59:%.*]] = load i64, ptr addrspace(5) [[TMP7]], align 8
// CHECK-NEXT:    store i64 [[TMP59]], ptr [[TMP58]], align 8
// CHECK-NEXT:    [[TMP60:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP61:%.*]] = add i32 1, [[TMP60]]
// CHECK-NEXT:    store i32 [[TMP61]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    br label [[FOR_COND]], !llvm.loop [[LOOP61:![0-9]+]]
// CHECK:       for.end:
// CHECK-NEXT:    br label [[OMP_KERNEL_DONE]]
// CHECK:       omp.kernel.done:
// CHECK-NEXT:    ret void
//
//
// CHECK-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z8run_testIdEvv_l35
// CHECK-SAME: (ptr noalias noundef [[DYN_PTR:%.*]], ptr noundef nonnull align 8 dereferenceable(8) [[SUM:%.*]], ptr noundef [[A:%.*]], ptr noundef [[B:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 8 dereferenceable(8) [[SUM1:%.*]], ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]], ptr noundef [[TMP2:%.*]], ptr noundef [[TMP3:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[DYN_PTR_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[SUM_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[A_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[B_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8, addrspace(5)
// CHECK-NEXT:    [[SUM_ADDR2:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[DOTADDR3:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[DOTADDR4:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[DOTADDR5:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[I:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[SUM8:%.*]] = alloca double, align 8, addrspace(5)
// CHECK-NEXT:    [[DYN_PTR_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DYN_PTR_ADDR]] to ptr
// CHECK-NEXT:    [[SUM_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM_ADDR]] to ptr
// CHECK-NEXT:    [[A_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[A_ADDR]] to ptr
// CHECK-NEXT:    [[B_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[B_ADDR]] to ptr
// CHECK-NEXT:    [[VLA_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[VLA_ADDR]] to ptr
// CHECK-NEXT:    [[SUM_ADDR2_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM_ADDR2]] to ptr
// CHECK-NEXT:    [[DOTADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR]] to ptr
// CHECK-NEXT:    [[DOTADDR3_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR3]] to ptr
// CHECK-NEXT:    [[DOTADDR4_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR4]] to ptr
// CHECK-NEXT:    [[DOTADDR5_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR5]] to ptr
// CHECK-NEXT:    [[I_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[I]] to ptr
// CHECK-NEXT:    [[DOTOMP_LB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_LB]] to ptr
// CHECK-NEXT:    [[DOTOMP_UB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_UB]] to ptr
// CHECK-NEXT:    [[DOTOMP_IV_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_IV]] to ptr
// CHECK-NEXT:    [[SUM8_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM8]] to ptr
// CHECK-NEXT:    store ptr [[DYN_PTR]], ptr [[DYN_PTR_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[SUM]], ptr [[SUM_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[A]], ptr [[A_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[B]], ptr [[B_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[SUM1]], ptr [[SUM_ADDR2_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR3_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[TMP2]], ptr [[DOTADDR4_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[TMP3]], ptr [[DOTADDR5_ASCAST]], align 8
// CHECK-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[SUM_ADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP5:%.*]] = load i64, ptr [[VLA_ADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP6:%.*]] = load ptr, ptr [[SUM_ADDR2_ASCAST]], align 8
// CHECK-NEXT:    call void @__kmpc_specialized_kernel_init()
// CHECK-NEXT:    [[TMP7:%.*]] = alloca double, align 8, addrspace(5)
// CHECK-NEXT:    store double 0.000000e+00, ptr addrspace(5) [[TMP7]], align 8
// CHECK-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// CHECK-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// CHECK-NEXT:    store i32 0, ptr [[DOTOMP_LB_ASCAST]], align 4
// CHECK-NEXT:    store i32 999999, ptr [[DOTOMP_UB_ASCAST]], align 4
// CHECK-NEXT:    [[TMP8:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// CHECK-NEXT:    store i32 [[TMP8]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP9:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// CHECK-NEXT:    [[NVPTX_NUM_THREADS:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// CHECK-NEXT:    [[GPU_BLOCK_ID:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// CHECK-NEXT:    [[TMP10:%.*]] = mul i32 [[GPU_BLOCK_ID]], [[NVPTX_NUM_THREADS]]
// CHECK-NEXT:    [[TMP11:%.*]] = add i32 [[TMP10]], [[TMP9]]
// CHECK-NEXT:    [[TMP12:%.*]] = mul i32 [[TMP11]], 1
// CHECK-NEXT:    [[TMP13:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP14:%.*]] = add i32 [[TMP12]], [[TMP13]]
// CHECK-NEXT:    [[TMP15:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// CHECK-NEXT:    [[TMP16:%.*]] = zext i32 [[TMP14]] to i64
// CHECK-NEXT:    store i32 [[TMP14]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[GLOBAL_UPPER_BOUND:%.*]] = load i32, ptr [[DOTOMP_UB_ASCAST]], align 4
// CHECK-NEXT:    [[TMP17:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// CHECK-NEXT:    [[TMP18:%.*]] = sub i32 [[GLOBAL_UPPER_BOUND]], [[TMP17]]
// CHECK-NEXT:    [[TMP19:%.*]] = add i32 [[TMP18]], 1
// CHECK-NEXT:    [[TMP20:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// CHECK-NEXT:    [[NVPTX_NUM_THREADS6:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// CHECK-NEXT:    [[GPU_BLOCK_ID7:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// CHECK-NEXT:    [[TMP21:%.*]] = mul i32 [[GPU_BLOCK_ID7]], [[NVPTX_NUM_THREADS6]]
// CHECK-NEXT:    [[TMP22:%.*]] = add i32 [[TMP21]], [[TMP20]]
// CHECK-NEXT:    [[TMP23:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// CHECK-NEXT:    [[TMP24:%.*]] = mul i32 [[NVPTX_NUM_THREADS6]], [[TMP23]]
// CHECK-NEXT:    [[TMP25:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP26:%.*]] = icmp ult i32 [[TMP25]], [[TMP24]]
// CHECK-NEXT:    br i1 [[TMP26]], label [[OMP_KERNEL_BODY:%.*]], label [[OMP_KERNEL_DONE:%.*]]
// CHECK:       omp.kernel.body:
// CHECK-NEXT:    [[TMP27:%.*]] = udiv i32 [[TMP19]], [[TMP24]]
// CHECK-NEXT:    [[PADDED_SEGMENT_SIZE:%.*]] = add i32 [[TMP27]], 1
// CHECK-NEXT:    [[TMP28:%.*]] = mul i32 [[PADDED_SEGMENT_SIZE]], [[TMP22]]
// CHECK-NEXT:    store i32 [[TMP28]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP29:%.*]] = add i32 [[TMP22]], 1
// CHECK-NEXT:    [[TMP30:%.*]] = mul i32 [[PADDED_SEGMENT_SIZE]], [[TMP29]]
// CHECK-NEXT:    [[TMP31:%.*]] = load ptr, ptr [[DOTADDR5_ASCAST]], align 8
// CHECK-NEXT:    br label [[FOR_COND:%.*]]
// CHECK:       for.cond:
// CHECK-NEXT:    [[TMP32:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP33:%.*]] = icmp ult i32 [[TMP32]], [[TMP30]]
// CHECK-NEXT:    [[TMP34:%.*]] = icmp ule i32 [[TMP32]], [[GLOBAL_UPPER_BOUND]]
// CHECK-NEXT:    [[TMP35:%.*]] = and i1 [[TMP34]], [[TMP33]]
// CHECK-NEXT:    br i1 [[TMP35]], label [[FOR_BODY:%.*]], label [[FOR_END:%.*]]
// CHECK:       for.body:
// CHECK-NEXT:    [[TMP36:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP36]], 1
// CHECK-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK-NEXT:    store i32 [[ADD]], ptr [[I_ASCAST]], align 4
// CHECK-NEXT:    store double 0.000000e+00, ptr [[SUM8_ASCAST]], align 8
// CHECK-NEXT:    br label [[OMP_INSCAN_DISPATCH:%.*]]
// CHECK:       omp.before.scan.bb:
// CHECK-NEXT:    [[TMP37:%.*]] = load ptr, ptr [[A_ADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP38:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// CHECK-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP38]] to i64
// CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds double, ptr [[TMP37]], i64 [[IDXPROM]]
// CHECK-NEXT:    [[TMP39:%.*]] = load double, ptr [[ARRAYIDX]], align 8
// CHECK-NEXT:    [[TMP40:%.*]] = load double, ptr addrspace(5) [[TMP7]], align 8
// CHECK-NEXT:    [[TMP41:%.*]] = fadd double [[TMP40]], [[TMP39]]
// CHECK-NEXT:    store double [[TMP41]], ptr addrspace(5) [[TMP7]], align 8
// CHECK-NEXT:    [[TMP42:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP43:%.*]] = zext i32 [[TMP42]] to i64
// CHECK-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK:       omp.exit.inscan.bb:
// CHECK-NEXT:    br label [[OMP_BODY_CONTINUE]]
// CHECK:       omp.inscan.dispatch:
// CHECK-NEXT:    br label [[OMP_BEFORE_SCAN_BB:%.*]]
// CHECK:       omp.after.scan.bb:
// CHECK-NEXT:    [[TMP44:%.*]] = load double, ptr [[TMP4]], align 8
// CHECK-NEXT:    [[TMP45:%.*]] = load ptr, ptr [[B_ADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP46:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// CHECK-NEXT:    [[IDXPROM9:%.*]] = sext i32 [[TMP46]] to i64
// CHECK-NEXT:    [[ARRAYIDX10:%.*]] = getelementptr inbounds double, ptr [[TMP45]], i64 [[IDXPROM9]]
// CHECK-NEXT:    store double [[TMP44]], ptr [[ARRAYIDX10]], align 8
// CHECK-NEXT:    br label [[OMP_EXIT_INSCAN_BB:%.*]]
// CHECK:       omp.body.continue:
// CHECK-NEXT:    br label [[FOR_INC:%.*]]
// CHECK:       for.inc:
// CHECK-NEXT:    [[TMP47:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP48:%.*]] = getelementptr double, ptr [[TMP31]], i32 [[TMP47]]
// CHECK-NEXT:    [[TMP49:%.*]] = load double, ptr addrspace(5) [[TMP7]], align 8
// CHECK-NEXT:    store double [[TMP49]], ptr [[TMP48]], align 8
// CHECK-NEXT:    [[TMP50:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP51:%.*]] = add i32 1, [[TMP50]]
// CHECK-NEXT:    store i32 [[TMP51]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    br label [[FOR_COND]], !llvm.loop [[LOOP62:![0-9]+]]
// CHECK:       for.end:
// CHECK-NEXT:    [[TMP52:%.*]] = load ptr, ptr [[DOTADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP53:%.*]] = load ptr, ptr [[DOTADDR3_ASCAST]], align 8
// CHECK-NEXT:    [[TMP54:%.*]] = load ptr, ptr [[DOTADDR4_ASCAST]], align 8
// CHECK-NEXT:    [[TMP55:%.*]] = load double, ptr addrspace(5) [[TMP7]], align 8
// CHECK-NEXT:    call void @__kmpc_xteams_d_16x64(double [[TMP55]], ptr [[TMP54]], ptr [[TMP4]], ptr [[TMP52]], ptr [[TMP53]], ptr @__kmpc_rfun_sum_d, ptr @__kmpc_rfun_sum_lds_d, double 0.000000e+00, i64 [[TMP16]], i32 [[TMP15]])
// CHECK-NEXT:    br label [[OMP_KERNEL_DONE]]
// CHECK:       omp.kernel.done:
// CHECK-NEXT:    ret void
//
//
// CHECK-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z8run_testIdEvv_l35_1
// CHECK-SAME: (ptr noalias noundef [[DYN_PTR:%.*]], ptr noundef nonnull align 8 dereferenceable(8) [[SUM:%.*]], ptr noundef [[A:%.*]], ptr noundef [[B:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 8 dereferenceable(8) [[SUM1:%.*]], ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]], ptr noundef [[TMP2:%.*]], ptr noundef [[TMP3:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[DYN_PTR_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[SUM_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[A_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[B_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8, addrspace(5)
// CHECK-NEXT:    [[SUM_ADDR2:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[DOTADDR3:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[DOTADDR4:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[DOTADDR5:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[I:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[SUM8:%.*]] = alloca double, align 8, addrspace(5)
// CHECK-NEXT:    [[DYN_PTR_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DYN_PTR_ADDR]] to ptr
// CHECK-NEXT:    [[SUM_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM_ADDR]] to ptr
// CHECK-NEXT:    [[A_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[A_ADDR]] to ptr
// CHECK-NEXT:    [[B_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[B_ADDR]] to ptr
// CHECK-NEXT:    [[VLA_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[VLA_ADDR]] to ptr
// CHECK-NEXT:    [[SUM_ADDR2_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM_ADDR2]] to ptr
// CHECK-NEXT:    [[DOTADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR]] to ptr
// CHECK-NEXT:    [[DOTADDR3_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR3]] to ptr
// CHECK-NEXT:    [[DOTADDR4_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR4]] to ptr
// CHECK-NEXT:    [[DOTADDR5_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR5]] to ptr
// CHECK-NEXT:    [[I_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[I]] to ptr
// CHECK-NEXT:    [[DOTOMP_LB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_LB]] to ptr
// CHECK-NEXT:    [[DOTOMP_UB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_UB]] to ptr
// CHECK-NEXT:    [[DOTOMP_IV_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_IV]] to ptr
// CHECK-NEXT:    [[SUM8_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM8]] to ptr
// CHECK-NEXT:    store ptr [[DYN_PTR]], ptr [[DYN_PTR_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[SUM]], ptr [[SUM_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[A]], ptr [[A_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[B]], ptr [[B_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[SUM1]], ptr [[SUM_ADDR2_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR3_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[TMP2]], ptr [[DOTADDR4_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[TMP3]], ptr [[DOTADDR5_ASCAST]], align 8
// CHECK-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[SUM_ADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP5:%.*]] = load i64, ptr [[VLA_ADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP6:%.*]] = load ptr, ptr [[SUM_ADDR2_ASCAST]], align 8
// CHECK-NEXT:    call void @__kmpc_specialized_kernel_init()
// CHECK-NEXT:    [[TMP7:%.*]] = alloca double, align 8, addrspace(5)
// CHECK-NEXT:    store double 0.000000e+00, ptr addrspace(5) [[TMP7]], align 8
// CHECK-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// CHECK-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// CHECK-NEXT:    store i32 0, ptr [[DOTOMP_LB_ASCAST]], align 4
// CHECK-NEXT:    store i32 999999, ptr [[DOTOMP_UB_ASCAST]], align 4
// CHECK-NEXT:    [[TMP8:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// CHECK-NEXT:    store i32 [[TMP8]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP9:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// CHECK-NEXT:    [[NVPTX_NUM_THREADS:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// CHECK-NEXT:    [[GPU_BLOCK_ID:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// CHECK-NEXT:    [[TMP10:%.*]] = mul i32 [[GPU_BLOCK_ID]], [[NVPTX_NUM_THREADS]]
// CHECK-NEXT:    [[TMP11:%.*]] = add i32 [[TMP10]], [[TMP9]]
// CHECK-NEXT:    [[TMP12:%.*]] = mul i32 [[TMP11]], 1
// CHECK-NEXT:    [[TMP13:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP14:%.*]] = add i32 [[TMP12]], [[TMP13]]
// CHECK-NEXT:    [[TMP15:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// CHECK-NEXT:    [[TMP16:%.*]] = zext i32 [[TMP14]] to i64
// CHECK-NEXT:    store i32 [[TMP14]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[GLOBAL_UPPER_BOUND:%.*]] = load i32, ptr [[DOTOMP_UB_ASCAST]], align 4
// CHECK-NEXT:    [[TMP17:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// CHECK-NEXT:    [[TMP18:%.*]] = sub i32 [[GLOBAL_UPPER_BOUND]], [[TMP17]]
// CHECK-NEXT:    [[TMP19:%.*]] = add i32 [[TMP18]], 1
// CHECK-NEXT:    [[TMP20:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// CHECK-NEXT:    [[NVPTX_NUM_THREADS6:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// CHECK-NEXT:    [[GPU_BLOCK_ID7:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// CHECK-NEXT:    [[TMP21:%.*]] = mul i32 [[GPU_BLOCK_ID7]], [[NVPTX_NUM_THREADS6]]
// CHECK-NEXT:    [[TMP22:%.*]] = add i32 [[TMP21]], [[TMP20]]
// CHECK-NEXT:    [[TMP23:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// CHECK-NEXT:    [[TMP24:%.*]] = mul i32 [[NVPTX_NUM_THREADS6]], [[TMP23]]
// CHECK-NEXT:    [[TMP25:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP26:%.*]] = icmp ult i32 [[TMP25]], [[TMP24]]
// CHECK-NEXT:    br i1 [[TMP26]], label [[OMP_KERNEL_BODY:%.*]], label [[OMP_KERNEL_DONE:%.*]]
// CHECK:       omp.kernel.body:
// CHECK-NEXT:    [[TMP27:%.*]] = udiv i32 [[TMP19]], [[TMP24]]
// CHECK-NEXT:    [[PADDED_SEGMENT_SIZE:%.*]] = add i32 [[TMP27]], 1
// CHECK-NEXT:    [[TMP28:%.*]] = load ptr, ptr [[DOTADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP29:%.*]] = load ptr, ptr [[DOTADDR4_ASCAST]], align 8
// CHECK-NEXT:    [[TMP30:%.*]] = load ptr, ptr [[DOTADDR5_ASCAST]], align 8
// CHECK-NEXT:    [[TMP31:%.*]] = load double, ptr addrspace(5) [[TMP7]], align 8
// CHECK-NEXT:    call void @__kmpc_xteams_phase2_d_16x64(ptr [[TMP29]], i32 [[PADDED_SEGMENT_SIZE]], ptr [[TMP28]], ptr [[TMP30]], ptr @__kmpc_rfun_sum_d, double 0.000000e+00, i64 [[TMP16]], i32 1)
// CHECK-NEXT:    [[TMP32:%.*]] = mul i32 [[PADDED_SEGMENT_SIZE]], [[TMP22]]
// CHECK-NEXT:    store i32 [[TMP32]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP33:%.*]] = add i32 [[TMP22]], 1
// CHECK-NEXT:    [[TMP34:%.*]] = mul i32 [[PADDED_SEGMENT_SIZE]], [[TMP33]]
// CHECK-NEXT:    [[TMP35:%.*]] = load ptr, ptr [[DOTADDR5_ASCAST]], align 8
// CHECK-NEXT:    br label [[FOR_COND:%.*]]
// CHECK:       for.cond:
// CHECK-NEXT:    [[TMP36:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP37:%.*]] = icmp ult i32 [[TMP36]], [[TMP34]]
// CHECK-NEXT:    [[TMP38:%.*]] = icmp ule i32 [[TMP36]], [[GLOBAL_UPPER_BOUND]]
// CHECK-NEXT:    [[TMP39:%.*]] = and i1 [[TMP38]], [[TMP37]]
// CHECK-NEXT:    br i1 [[TMP39]], label [[FOR_BODY:%.*]], label [[FOR_END:%.*]]
// CHECK:       for.body:
// CHECK-NEXT:    [[TMP40:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP40]], 1
// CHECK-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK-NEXT:    store i32 [[ADD]], ptr [[I_ASCAST]], align 4
// CHECK-NEXT:    [[TMP41:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP42:%.*]] = getelementptr double, ptr [[TMP35]], i32 [[TMP41]]
// CHECK-NEXT:    [[TMP43:%.*]] = load double, ptr [[TMP42]], align 8
// CHECK-NEXT:    store double [[TMP43]], ptr addrspace(5) [[TMP7]], align 8
// CHECK-NEXT:    store double 0.000000e+00, ptr [[SUM8_ASCAST]], align 8
// CHECK-NEXT:    br label [[OMP_INSCAN_DISPATCH:%.*]]
// CHECK:       omp.before.scan.bb:
// CHECK-NEXT:    [[TMP44:%.*]] = load ptr, ptr [[A_ADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP45:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// CHECK-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP45]] to i64
// CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds double, ptr [[TMP44]], i64 [[IDXPROM]]
// CHECK-NEXT:    [[TMP46:%.*]] = load double, ptr [[ARRAYIDX]], align 8
// CHECK-NEXT:    [[TMP47:%.*]] = load double, ptr addrspace(5) [[TMP7]], align 8
// CHECK-NEXT:    [[TMP48:%.*]] = fadd double [[TMP47]], [[TMP46]]
// CHECK-NEXT:    store double [[TMP48]], ptr addrspace(5) [[TMP7]], align 8
// CHECK-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK:       omp.exit.inscan.bb:
// CHECK-NEXT:    br label [[OMP_BODY_CONTINUE]]
// CHECK:       omp.inscan.dispatch:
// CHECK-NEXT:    [[TMP49:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP50:%.*]] = zext i32 [[TMP49]] to i64
// CHECK-NEXT:    [[ARRAYIDX9:%.*]] = getelementptr inbounds nuw double, ptr [[TMP6]], i64 [[TMP50]]
// CHECK-NEXT:    [[TMP51:%.*]] = load double, ptr addrspace(5) [[TMP7]], align 8
// CHECK-NEXT:    store double [[TMP51]], ptr [[TMP4]], align 8
// CHECK-NEXT:    br label [[OMP_AFTER_SCAN_BB:%.*]]
// CHECK:       omp.after.scan.bb:
// CHECK-NEXT:    [[TMP52:%.*]] = load ptr, ptr [[B_ADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP53:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// CHECK-NEXT:    [[IDXPROM10:%.*]] = sext i32 [[TMP53]] to i64
// CHECK-NEXT:    [[ARRAYIDX11:%.*]] = getelementptr inbounds double, ptr [[TMP52]], i64 [[IDXPROM10]]
// CHECK-NEXT:    [[TMP54:%.*]] = load double, ptr addrspace(5) [[TMP7]], align 8
// CHECK-NEXT:    store double [[TMP54]], ptr [[ARRAYIDX11]], align 8
// CHECK-NEXT:    br label [[OMP_EXIT_INSCAN_BB:%.*]]
// CHECK:       omp.body.continue:
// CHECK-NEXT:    br label [[FOR_INC:%.*]]
// CHECK:       for.inc:
// CHECK-NEXT:    [[TMP55:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP56:%.*]] = getelementptr double, ptr [[TMP35]], i32 [[TMP55]]
// CHECK-NEXT:    [[TMP57:%.*]] = load double, ptr addrspace(5) [[TMP7]], align 8
// CHECK-NEXT:    store double [[TMP57]], ptr [[TMP56]], align 8
// CHECK-NEXT:    [[TMP58:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP59:%.*]] = add i32 1, [[TMP58]]
// CHECK-NEXT:    store i32 [[TMP59]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    br label [[FOR_COND]], !llvm.loop [[LOOP63:![0-9]+]]
// CHECK:       for.end:
// CHECK-NEXT:    br label [[OMP_KERNEL_DONE]]
// CHECK:       omp.kernel.done:
// CHECK-NEXT:    ret void
//
//
// CHECK-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z8run_testIdEvv_l47
// CHECK-SAME: (ptr noalias noundef [[DYN_PTR:%.*]], ptr noundef [[B:%.*]], ptr noundef nonnull align 8 dereferenceable(8) [[SUM:%.*]], ptr noundef [[A:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 8 dereferenceable(8) [[SUM1:%.*]], ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]], ptr noundef [[TMP2:%.*]], ptr noundef [[TMP3:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[DYN_PTR_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[B_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[SUM_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[A_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8, addrspace(5)
// CHECK-NEXT:    [[SUM_ADDR2:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[DOTADDR3:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[DOTADDR4:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[DOTADDR5:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[I:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[SUM8:%.*]] = alloca double, align 8, addrspace(5)
// CHECK-NEXT:    [[DYN_PTR_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DYN_PTR_ADDR]] to ptr
// CHECK-NEXT:    [[B_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[B_ADDR]] to ptr
// CHECK-NEXT:    [[SUM_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM_ADDR]] to ptr
// CHECK-NEXT:    [[A_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[A_ADDR]] to ptr
// CHECK-NEXT:    [[VLA_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[VLA_ADDR]] to ptr
// CHECK-NEXT:    [[SUM_ADDR2_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM_ADDR2]] to ptr
// CHECK-NEXT:    [[DOTADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR]] to ptr
// CHECK-NEXT:    [[DOTADDR3_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR3]] to ptr
// CHECK-NEXT:    [[DOTADDR4_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR4]] to ptr
// CHECK-NEXT:    [[DOTADDR5_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR5]] to ptr
// CHECK-NEXT:    [[I_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[I]] to ptr
// CHECK-NEXT:    [[DOTOMP_LB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_LB]] to ptr
// CHECK-NEXT:    [[DOTOMP_UB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_UB]] to ptr
// CHECK-NEXT:    [[DOTOMP_IV_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_IV]] to ptr
// CHECK-NEXT:    [[SUM8_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM8]] to ptr
// CHECK-NEXT:    store ptr [[DYN_PTR]], ptr [[DYN_PTR_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[B]], ptr [[B_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[SUM]], ptr [[SUM_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[A]], ptr [[A_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[SUM1]], ptr [[SUM_ADDR2_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR3_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[TMP2]], ptr [[DOTADDR4_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[TMP3]], ptr [[DOTADDR5_ASCAST]], align 8
// CHECK-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[SUM_ADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP5:%.*]] = load i64, ptr [[VLA_ADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP6:%.*]] = load ptr, ptr [[SUM_ADDR2_ASCAST]], align 8
// CHECK-NEXT:    call void @__kmpc_specialized_kernel_init()
// CHECK-NEXT:    [[TMP7:%.*]] = alloca double, align 8, addrspace(5)
// CHECK-NEXT:    store double 0.000000e+00, ptr addrspace(5) [[TMP7]], align 8
// CHECK-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// CHECK-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// CHECK-NEXT:    store i32 0, ptr [[DOTOMP_LB_ASCAST]], align 4
// CHECK-NEXT:    store i32 999999, ptr [[DOTOMP_UB_ASCAST]], align 4
// CHECK-NEXT:    [[TMP8:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// CHECK-NEXT:    store i32 [[TMP8]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP9:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// CHECK-NEXT:    [[NVPTX_NUM_THREADS:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// CHECK-NEXT:    [[GPU_BLOCK_ID:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// CHECK-NEXT:    [[TMP10:%.*]] = mul i32 [[GPU_BLOCK_ID]], [[NVPTX_NUM_THREADS]]
// CHECK-NEXT:    [[TMP11:%.*]] = add i32 [[TMP10]], [[TMP9]]
// CHECK-NEXT:    [[TMP12:%.*]] = mul i32 [[TMP11]], 1
// CHECK-NEXT:    [[TMP13:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP14:%.*]] = add i32 [[TMP12]], [[TMP13]]
// CHECK-NEXT:    [[TMP15:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// CHECK-NEXT:    [[TMP16:%.*]] = zext i32 [[TMP14]] to i64
// CHECK-NEXT:    store i32 [[TMP14]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[GLOBAL_UPPER_BOUND:%.*]] = load i32, ptr [[DOTOMP_UB_ASCAST]], align 4
// CHECK-NEXT:    [[TMP17:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// CHECK-NEXT:    [[TMP18:%.*]] = sub i32 [[GLOBAL_UPPER_BOUND]], [[TMP17]]
// CHECK-NEXT:    [[TMP19:%.*]] = add i32 [[TMP18]], 1
// CHECK-NEXT:    [[TMP20:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// CHECK-NEXT:    [[NVPTX_NUM_THREADS6:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// CHECK-NEXT:    [[GPU_BLOCK_ID7:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// CHECK-NEXT:    [[TMP21:%.*]] = mul i32 [[GPU_BLOCK_ID7]], [[NVPTX_NUM_THREADS6]]
// CHECK-NEXT:    [[TMP22:%.*]] = add i32 [[TMP21]], [[TMP20]]
// CHECK-NEXT:    [[TMP23:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// CHECK-NEXT:    [[TMP24:%.*]] = mul i32 [[NVPTX_NUM_THREADS6]], [[TMP23]]
// CHECK-NEXT:    [[TMP25:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP26:%.*]] = icmp ult i32 [[TMP25]], [[TMP24]]
// CHECK-NEXT:    br i1 [[TMP26]], label [[OMP_KERNEL_BODY:%.*]], label [[OMP_KERNEL_DONE:%.*]]
// CHECK:       omp.kernel.body:
// CHECK-NEXT:    [[TMP27:%.*]] = udiv i32 [[TMP19]], [[TMP24]]
// CHECK-NEXT:    [[PADDED_SEGMENT_SIZE:%.*]] = add i32 [[TMP27]], 1
// CHECK-NEXT:    [[TMP28:%.*]] = mul i32 [[PADDED_SEGMENT_SIZE]], [[TMP22]]
// CHECK-NEXT:    store i32 [[TMP28]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP29:%.*]] = add i32 [[TMP22]], 1
// CHECK-NEXT:    [[TMP30:%.*]] = mul i32 [[PADDED_SEGMENT_SIZE]], [[TMP29]]
// CHECK-NEXT:    [[TMP31:%.*]] = load ptr, ptr [[DOTADDR5_ASCAST]], align 8
// CHECK-NEXT:    br label [[FOR_COND:%.*]]
// CHECK:       for.cond:
// CHECK-NEXT:    [[TMP32:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP33:%.*]] = icmp ult i32 [[TMP32]], [[TMP30]]
// CHECK-NEXT:    [[TMP34:%.*]] = icmp ule i32 [[TMP32]], [[GLOBAL_UPPER_BOUND]]
// CHECK-NEXT:    [[TMP35:%.*]] = and i1 [[TMP34]], [[TMP33]]
// CHECK-NEXT:    br i1 [[TMP35]], label [[FOR_BODY:%.*]], label [[FOR_END:%.*]]
// CHECK:       for.body:
// CHECK-NEXT:    [[TMP36:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP36]], 1
// CHECK-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK-NEXT:    store i32 [[ADD]], ptr [[I_ASCAST]], align 4
// CHECK-NEXT:    store double 0.000000e+00, ptr [[SUM8_ASCAST]], align 8
// CHECK-NEXT:    br label [[OMP_INSCAN_DISPATCH:%.*]]
// CHECK:       omp.before.scan.bb:
// CHECK-NEXT:    [[TMP37:%.*]] = load double, ptr [[TMP4]], align 8
// CHECK-NEXT:    [[TMP38:%.*]] = load ptr, ptr [[B_ADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP39:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// CHECK-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP39]] to i64
// CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds double, ptr [[TMP38]], i64 [[IDXPROM]]
// CHECK-NEXT:    store double [[TMP37]], ptr [[ARRAYIDX]], align 8
// CHECK-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK:       omp.exit.inscan.bb:
// CHECK-NEXT:    [[TMP40:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP41:%.*]] = zext i32 [[TMP40]] to i64
// CHECK-NEXT:    br label [[OMP_BODY_CONTINUE]]
// CHECK:       omp.inscan.dispatch:
// CHECK-NEXT:    br label [[OMP_AFTER_SCAN_BB:%.*]]
// CHECK:       omp.after.scan.bb:
// CHECK-NEXT:    [[TMP42:%.*]] = load ptr, ptr [[A_ADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP43:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// CHECK-NEXT:    [[IDXPROM9:%.*]] = sext i32 [[TMP43]] to i64
// CHECK-NEXT:    [[ARRAYIDX10:%.*]] = getelementptr inbounds double, ptr [[TMP42]], i64 [[IDXPROM9]]
// CHECK-NEXT:    [[TMP44:%.*]] = load double, ptr [[ARRAYIDX10]], align 8
// CHECK-NEXT:    [[TMP45:%.*]] = load double, ptr addrspace(5) [[TMP7]], align 8
// CHECK-NEXT:    [[TMP46:%.*]] = fadd double [[TMP45]], [[TMP44]]
// CHECK-NEXT:    store double [[TMP46]], ptr addrspace(5) [[TMP7]], align 8
// CHECK-NEXT:    br label [[OMP_EXIT_INSCAN_BB:%.*]]
// CHECK:       omp.body.continue:
// CHECK-NEXT:    br label [[FOR_INC:%.*]]
// CHECK:       for.inc:
// CHECK-NEXT:    [[TMP47:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP48:%.*]] = getelementptr double, ptr [[TMP31]], i32 [[TMP47]]
// CHECK-NEXT:    [[TMP49:%.*]] = load double, ptr addrspace(5) [[TMP7]], align 8
// CHECK-NEXT:    store double [[TMP49]], ptr [[TMP48]], align 8
// CHECK-NEXT:    [[TMP50:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP51:%.*]] = add i32 1, [[TMP50]]
// CHECK-NEXT:    store i32 [[TMP51]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    br label [[FOR_COND]], !llvm.loop [[LOOP64:![0-9]+]]
// CHECK:       for.end:
// CHECK-NEXT:    [[TMP52:%.*]] = load ptr, ptr [[DOTADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP53:%.*]] = load ptr, ptr [[DOTADDR3_ASCAST]], align 8
// CHECK-NEXT:    [[TMP54:%.*]] = load ptr, ptr [[DOTADDR4_ASCAST]], align 8
// CHECK-NEXT:    [[TMP55:%.*]] = load double, ptr addrspace(5) [[TMP7]], align 8
// CHECK-NEXT:    call void @__kmpc_xteams_d_16x64(double [[TMP55]], ptr [[TMP54]], ptr [[TMP4]], ptr [[TMP52]], ptr [[TMP53]], ptr @__kmpc_rfun_sum_d, ptr @__kmpc_rfun_sum_lds_d, double 0.000000e+00, i64 [[TMP16]], i32 [[TMP15]])
// CHECK-NEXT:    br label [[OMP_KERNEL_DONE]]
// CHECK:       omp.kernel.done:
// CHECK-NEXT:    ret void
//
//
// CHECK-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z8run_testIdEvv_l47_1
// CHECK-SAME: (ptr noalias noundef [[DYN_PTR:%.*]], ptr noundef [[B:%.*]], ptr noundef nonnull align 8 dereferenceable(8) [[SUM:%.*]], ptr noundef [[A:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 8 dereferenceable(8) [[SUM1:%.*]], ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]], ptr noundef [[TMP2:%.*]], ptr noundef [[TMP3:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[DYN_PTR_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[B_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[SUM_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[A_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8, addrspace(5)
// CHECK-NEXT:    [[SUM_ADDR2:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[DOTADDR3:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[DOTADDR4:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[DOTADDR5:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[I:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[SUM8:%.*]] = alloca double, align 8, addrspace(5)
// CHECK-NEXT:    [[DYN_PTR_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DYN_PTR_ADDR]] to ptr
// CHECK-NEXT:    [[B_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[B_ADDR]] to ptr
// CHECK-NEXT:    [[SUM_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM_ADDR]] to ptr
// CHECK-NEXT:    [[A_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[A_ADDR]] to ptr
// CHECK-NEXT:    [[VLA_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[VLA_ADDR]] to ptr
// CHECK-NEXT:    [[SUM_ADDR2_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM_ADDR2]] to ptr
// CHECK-NEXT:    [[DOTADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR]] to ptr
// CHECK-NEXT:    [[DOTADDR3_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR3]] to ptr
// CHECK-NEXT:    [[DOTADDR4_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR4]] to ptr
// CHECK-NEXT:    [[DOTADDR5_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR5]] to ptr
// CHECK-NEXT:    [[I_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[I]] to ptr
// CHECK-NEXT:    [[DOTOMP_LB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_LB]] to ptr
// CHECK-NEXT:    [[DOTOMP_UB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_UB]] to ptr
// CHECK-NEXT:    [[DOTOMP_IV_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_IV]] to ptr
// CHECK-NEXT:    [[SUM8_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM8]] to ptr
// CHECK-NEXT:    store ptr [[DYN_PTR]], ptr [[DYN_PTR_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[B]], ptr [[B_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[SUM]], ptr [[SUM_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[A]], ptr [[A_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[SUM1]], ptr [[SUM_ADDR2_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR3_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[TMP2]], ptr [[DOTADDR4_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[TMP3]], ptr [[DOTADDR5_ASCAST]], align 8
// CHECK-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[SUM_ADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP5:%.*]] = load i64, ptr [[VLA_ADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP6:%.*]] = load ptr, ptr [[SUM_ADDR2_ASCAST]], align 8
// CHECK-NEXT:    call void @__kmpc_specialized_kernel_init()
// CHECK-NEXT:    [[TMP7:%.*]] = alloca double, align 8, addrspace(5)
// CHECK-NEXT:    store double 0.000000e+00, ptr addrspace(5) [[TMP7]], align 8
// CHECK-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// CHECK-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// CHECK-NEXT:    store i32 0, ptr [[DOTOMP_LB_ASCAST]], align 4
// CHECK-NEXT:    store i32 999999, ptr [[DOTOMP_UB_ASCAST]], align 4
// CHECK-NEXT:    [[TMP8:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// CHECK-NEXT:    store i32 [[TMP8]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP9:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// CHECK-NEXT:    [[NVPTX_NUM_THREADS:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// CHECK-NEXT:    [[GPU_BLOCK_ID:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// CHECK-NEXT:    [[TMP10:%.*]] = mul i32 [[GPU_BLOCK_ID]], [[NVPTX_NUM_THREADS]]
// CHECK-NEXT:    [[TMP11:%.*]] = add i32 [[TMP10]], [[TMP9]]
// CHECK-NEXT:    [[TMP12:%.*]] = mul i32 [[TMP11]], 1
// CHECK-NEXT:    [[TMP13:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP14:%.*]] = add i32 [[TMP12]], [[TMP13]]
// CHECK-NEXT:    [[TMP15:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// CHECK-NEXT:    [[TMP16:%.*]] = zext i32 [[TMP14]] to i64
// CHECK-NEXT:    store i32 [[TMP14]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[GLOBAL_UPPER_BOUND:%.*]] = load i32, ptr [[DOTOMP_UB_ASCAST]], align 4
// CHECK-NEXT:    [[TMP17:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// CHECK-NEXT:    [[TMP18:%.*]] = sub i32 [[GLOBAL_UPPER_BOUND]], [[TMP17]]
// CHECK-NEXT:    [[TMP19:%.*]] = add i32 [[TMP18]], 1
// CHECK-NEXT:    [[TMP20:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// CHECK-NEXT:    [[NVPTX_NUM_THREADS6:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// CHECK-NEXT:    [[GPU_BLOCK_ID7:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// CHECK-NEXT:    [[TMP21:%.*]] = mul i32 [[GPU_BLOCK_ID7]], [[NVPTX_NUM_THREADS6]]
// CHECK-NEXT:    [[TMP22:%.*]] = add i32 [[TMP21]], [[TMP20]]
// CHECK-NEXT:    [[TMP23:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// CHECK-NEXT:    [[TMP24:%.*]] = mul i32 [[NVPTX_NUM_THREADS6]], [[TMP23]]
// CHECK-NEXT:    [[TMP25:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP26:%.*]] = icmp ult i32 [[TMP25]], [[TMP24]]
// CHECK-NEXT:    br i1 [[TMP26]], label [[OMP_KERNEL_BODY:%.*]], label [[OMP_KERNEL_DONE:%.*]]
// CHECK:       omp.kernel.body:
// CHECK-NEXT:    [[TMP27:%.*]] = udiv i32 [[TMP19]], [[TMP24]]
// CHECK-NEXT:    [[PADDED_SEGMENT_SIZE:%.*]] = add i32 [[TMP27]], 1
// CHECK-NEXT:    [[TMP28:%.*]] = load ptr, ptr [[DOTADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP29:%.*]] = load ptr, ptr [[DOTADDR4_ASCAST]], align 8
// CHECK-NEXT:    [[TMP30:%.*]] = load ptr, ptr [[DOTADDR5_ASCAST]], align 8
// CHECK-NEXT:    [[TMP31:%.*]] = load double, ptr addrspace(5) [[TMP7]], align 8
// CHECK-NEXT:    call void @__kmpc_xteams_phase2_d_16x64(ptr [[TMP29]], i32 [[PADDED_SEGMENT_SIZE]], ptr [[TMP28]], ptr [[TMP30]], ptr @__kmpc_rfun_sum_d, double 0.000000e+00, i64 [[TMP16]], i32 0)
// CHECK-NEXT:    [[TMP32:%.*]] = mul i32 [[PADDED_SEGMENT_SIZE]], [[TMP22]]
// CHECK-NEXT:    store i32 [[TMP32]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP33:%.*]] = add i32 [[TMP22]], 1
// CHECK-NEXT:    [[TMP34:%.*]] = mul i32 [[PADDED_SEGMENT_SIZE]], [[TMP33]]
// CHECK-NEXT:    [[TMP35:%.*]] = load ptr, ptr [[DOTADDR5_ASCAST]], align 8
// CHECK-NEXT:    br label [[FOR_COND:%.*]]
// CHECK:       for.cond:
// CHECK-NEXT:    [[TMP36:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP37:%.*]] = icmp ult i32 [[TMP36]], [[TMP34]]
// CHECK-NEXT:    [[TMP38:%.*]] = icmp ule i32 [[TMP36]], [[GLOBAL_UPPER_BOUND]]
// CHECK-NEXT:    [[TMP39:%.*]] = and i1 [[TMP38]], [[TMP37]]
// CHECK-NEXT:    br i1 [[TMP39]], label [[FOR_BODY:%.*]], label [[FOR_END:%.*]]
// CHECK:       for.body:
// CHECK-NEXT:    [[TMP40:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP40]], 1
// CHECK-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK-NEXT:    store i32 [[ADD]], ptr [[I_ASCAST]], align 4
// CHECK-NEXT:    [[TMP41:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP42:%.*]] = getelementptr double, ptr [[TMP35]], i32 [[TMP41]]
// CHECK-NEXT:    [[TMP43:%.*]] = load double, ptr [[TMP42]], align 8
// CHECK-NEXT:    store double [[TMP43]], ptr addrspace(5) [[TMP7]], align 8
// CHECK-NEXT:    store double 0.000000e+00, ptr [[SUM8_ASCAST]], align 8
// CHECK-NEXT:    br label [[OMP_INSCAN_DISPATCH:%.*]]
// CHECK:       omp.before.scan.bb:
// CHECK-NEXT:    [[TMP44:%.*]] = load ptr, ptr [[B_ADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP45:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// CHECK-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP45]] to i64
// CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds double, ptr [[TMP44]], i64 [[IDXPROM]]
// CHECK-NEXT:    [[TMP46:%.*]] = load double, ptr addrspace(5) [[TMP7]], align 8
// CHECK-NEXT:    store double [[TMP46]], ptr [[ARRAYIDX]], align 8
// CHECK-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK:       omp.exit.inscan.bb:
// CHECK-NEXT:    br label [[OMP_BODY_CONTINUE]]
// CHECK:       omp.inscan.dispatch:
// CHECK-NEXT:    [[TMP47:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP48:%.*]] = zext i32 [[TMP47]] to i64
// CHECK-NEXT:    [[TMP49:%.*]] = icmp eq i64 [[TMP48]], 0
// CHECK-NEXT:    br i1 [[TMP49]], label [[OMP_EXCLUSIVE_COPY_EXIT:%.*]], label [[OMP_EXCLUSIVE_DEC:%.*]]
// CHECK:       omp.exclusive.dec:
// CHECK-NEXT:    [[TMP50:%.*]] = sub nuw i64 [[TMP48]], 1
// CHECK-NEXT:    [[ARRAYIDX9:%.*]] = getelementptr inbounds nuw double, ptr [[TMP6]], i64 [[TMP50]]
// CHECK-NEXT:    [[TMP51:%.*]] = load double, ptr addrspace(5) [[TMP7]], align 8
// CHECK-NEXT:    store double [[TMP51]], ptr [[TMP4]], align 8
// CHECK-NEXT:    br label [[OMP_EXCLUSIVE_COPY_EXIT]]
// CHECK:       omp.exclusive.copy.exit:
// CHECK-NEXT:    br label [[OMP_BEFORE_SCAN_BB:%.*]]
// CHECK:       omp.after.scan.bb:
// CHECK-NEXT:    [[TMP52:%.*]] = load ptr, ptr [[A_ADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP53:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// CHECK-NEXT:    [[IDXPROM10:%.*]] = sext i32 [[TMP53]] to i64
// CHECK-NEXT:    [[ARRAYIDX11:%.*]] = getelementptr inbounds double, ptr [[TMP52]], i64 [[IDXPROM10]]
// CHECK-NEXT:    [[TMP54:%.*]] = load double, ptr [[ARRAYIDX11]], align 8
// CHECK-NEXT:    [[TMP55:%.*]] = load double, ptr addrspace(5) [[TMP7]], align 8
// CHECK-NEXT:    [[TMP56:%.*]] = fadd double [[TMP55]], [[TMP54]]
// CHECK-NEXT:    store double [[TMP56]], ptr addrspace(5) [[TMP7]], align 8
// CHECK-NEXT:    br label [[OMP_EXIT_INSCAN_BB:%.*]]
// CHECK:       omp.body.continue:
// CHECK-NEXT:    br label [[FOR_INC:%.*]]
// CHECK:       for.inc:
// CHECK-NEXT:    [[TMP57:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP58:%.*]] = getelementptr double, ptr [[TMP35]], i32 [[TMP57]]
// CHECK-NEXT:    [[TMP59:%.*]] = load double, ptr addrspace(5) [[TMP7]], align 8
// CHECK-NEXT:    store double [[TMP59]], ptr [[TMP58]], align 8
// CHECK-NEXT:    [[TMP60:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP61:%.*]] = add i32 1, [[TMP60]]
// CHECK-NEXT:    store i32 [[TMP61]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    br label [[FOR_COND]], !llvm.loop [[LOOP65:![0-9]+]]
// CHECK:       for.end:
// CHECK-NEXT:    br label [[OMP_KERNEL_DONE]]
// CHECK:       omp.kernel.done:
// CHECK-NEXT:    ret void
//
//
// CHECK-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z8run_testIfEvv_l35
// CHECK-SAME: (ptr noalias noundef [[DYN_PTR:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM:%.*]], ptr noundef [[A:%.*]], ptr noundef [[B:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM1:%.*]], ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]], ptr noundef [[TMP2:%.*]], ptr noundef [[TMP3:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[DYN_PTR_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[SUM_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[A_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[B_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8, addrspace(5)
// CHECK-NEXT:    [[SUM_ADDR2:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[DOTADDR3:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[DOTADDR4:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[DOTADDR5:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[I:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[SUM8:%.*]] = alloca float, align 4, addrspace(5)
// CHECK-NEXT:    [[DYN_PTR_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DYN_PTR_ADDR]] to ptr
// CHECK-NEXT:    [[SUM_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM_ADDR]] to ptr
// CHECK-NEXT:    [[A_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[A_ADDR]] to ptr
// CHECK-NEXT:    [[B_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[B_ADDR]] to ptr
// CHECK-NEXT:    [[VLA_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[VLA_ADDR]] to ptr
// CHECK-NEXT:    [[SUM_ADDR2_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM_ADDR2]] to ptr
// CHECK-NEXT:    [[DOTADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR]] to ptr
// CHECK-NEXT:    [[DOTADDR3_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR3]] to ptr
// CHECK-NEXT:    [[DOTADDR4_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR4]] to ptr
// CHECK-NEXT:    [[DOTADDR5_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR5]] to ptr
// CHECK-NEXT:    [[I_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[I]] to ptr
// CHECK-NEXT:    [[DOTOMP_LB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_LB]] to ptr
// CHECK-NEXT:    [[DOTOMP_UB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_UB]] to ptr
// CHECK-NEXT:    [[DOTOMP_IV_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_IV]] to ptr
// CHECK-NEXT:    [[SUM8_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM8]] to ptr
// CHECK-NEXT:    store ptr [[DYN_PTR]], ptr [[DYN_PTR_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[SUM]], ptr [[SUM_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[A]], ptr [[A_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[B]], ptr [[B_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[SUM1]], ptr [[SUM_ADDR2_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR3_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[TMP2]], ptr [[DOTADDR4_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[TMP3]], ptr [[DOTADDR5_ASCAST]], align 8
// CHECK-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[SUM_ADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP5:%.*]] = load i64, ptr [[VLA_ADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP6:%.*]] = load ptr, ptr [[SUM_ADDR2_ASCAST]], align 8
// CHECK-NEXT:    call void @__kmpc_specialized_kernel_init()
// CHECK-NEXT:    [[TMP7:%.*]] = alloca float, align 4, addrspace(5)
// CHECK-NEXT:    store float 0.000000e+00, ptr addrspace(5) [[TMP7]], align 4
// CHECK-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// CHECK-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// CHECK-NEXT:    store i32 0, ptr [[DOTOMP_LB_ASCAST]], align 4
// CHECK-NEXT:    store i32 999999, ptr [[DOTOMP_UB_ASCAST]], align 4
// CHECK-NEXT:    [[TMP8:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// CHECK-NEXT:    store i32 [[TMP8]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP9:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// CHECK-NEXT:    [[NVPTX_NUM_THREADS:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// CHECK-NEXT:    [[GPU_BLOCK_ID:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// CHECK-NEXT:    [[TMP10:%.*]] = mul i32 [[GPU_BLOCK_ID]], [[NVPTX_NUM_THREADS]]
// CHECK-NEXT:    [[TMP11:%.*]] = add i32 [[TMP10]], [[TMP9]]
// CHECK-NEXT:    [[TMP12:%.*]] = mul i32 [[TMP11]], 1
// CHECK-NEXT:    [[TMP13:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP14:%.*]] = add i32 [[TMP12]], [[TMP13]]
// CHECK-NEXT:    [[TMP15:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// CHECK-NEXT:    [[TMP16:%.*]] = zext i32 [[TMP14]] to i64
// CHECK-NEXT:    store i32 [[TMP14]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[GLOBAL_UPPER_BOUND:%.*]] = load i32, ptr [[DOTOMP_UB_ASCAST]], align 4
// CHECK-NEXT:    [[TMP17:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// CHECK-NEXT:    [[TMP18:%.*]] = sub i32 [[GLOBAL_UPPER_BOUND]], [[TMP17]]
// CHECK-NEXT:    [[TMP19:%.*]] = add i32 [[TMP18]], 1
// CHECK-NEXT:    [[TMP20:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// CHECK-NEXT:    [[NVPTX_NUM_THREADS6:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// CHECK-NEXT:    [[GPU_BLOCK_ID7:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// CHECK-NEXT:    [[TMP21:%.*]] = mul i32 [[GPU_BLOCK_ID7]], [[NVPTX_NUM_THREADS6]]
// CHECK-NEXT:    [[TMP22:%.*]] = add i32 [[TMP21]], [[TMP20]]
// CHECK-NEXT:    [[TMP23:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// CHECK-NEXT:    [[TMP24:%.*]] = mul i32 [[NVPTX_NUM_THREADS6]], [[TMP23]]
// CHECK-NEXT:    [[TMP25:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP26:%.*]] = icmp ult i32 [[TMP25]], [[TMP24]]
// CHECK-NEXT:    br i1 [[TMP26]], label [[OMP_KERNEL_BODY:%.*]], label [[OMP_KERNEL_DONE:%.*]]
// CHECK:       omp.kernel.body:
// CHECK-NEXT:    [[TMP27:%.*]] = udiv i32 [[TMP19]], [[TMP24]]
// CHECK-NEXT:    [[PADDED_SEGMENT_SIZE:%.*]] = add i32 [[TMP27]], 1
// CHECK-NEXT:    [[TMP28:%.*]] = mul i32 [[PADDED_SEGMENT_SIZE]], [[TMP22]]
// CHECK-NEXT:    store i32 [[TMP28]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP29:%.*]] = add i32 [[TMP22]], 1
// CHECK-NEXT:    [[TMP30:%.*]] = mul i32 [[PADDED_SEGMENT_SIZE]], [[TMP29]]
// CHECK-NEXT:    [[TMP31:%.*]] = load ptr, ptr [[DOTADDR5_ASCAST]], align 8
// CHECK-NEXT:    br label [[FOR_COND:%.*]]
// CHECK:       for.cond:
// CHECK-NEXT:    [[TMP32:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP33:%.*]] = icmp ult i32 [[TMP32]], [[TMP30]]
// CHECK-NEXT:    [[TMP34:%.*]] = icmp ule i32 [[TMP32]], [[GLOBAL_UPPER_BOUND]]
// CHECK-NEXT:    [[TMP35:%.*]] = and i1 [[TMP34]], [[TMP33]]
// CHECK-NEXT:    br i1 [[TMP35]], label [[FOR_BODY:%.*]], label [[FOR_END:%.*]]
// CHECK:       for.body:
// CHECK-NEXT:    [[TMP36:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP36]], 1
// CHECK-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK-NEXT:    store i32 [[ADD]], ptr [[I_ASCAST]], align 4
// CHECK-NEXT:    store float 0.000000e+00, ptr [[SUM8_ASCAST]], align 4
// CHECK-NEXT:    br label [[OMP_INSCAN_DISPATCH:%.*]]
// CHECK:       omp.before.scan.bb:
// CHECK-NEXT:    [[TMP37:%.*]] = load ptr, ptr [[A_ADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP38:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// CHECK-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP38]] to i64
// CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds float, ptr [[TMP37]], i64 [[IDXPROM]]
// CHECK-NEXT:    [[TMP39:%.*]] = load float, ptr [[ARRAYIDX]], align 4
// CHECK-NEXT:    [[TMP40:%.*]] = load float, ptr addrspace(5) [[TMP7]], align 4
// CHECK-NEXT:    [[TMP41:%.*]] = fadd float [[TMP40]], [[TMP39]]
// CHECK-NEXT:    store float [[TMP41]], ptr addrspace(5) [[TMP7]], align 4
// CHECK-NEXT:    [[TMP42:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP43:%.*]] = zext i32 [[TMP42]] to i64
// CHECK-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK:       omp.exit.inscan.bb:
// CHECK-NEXT:    br label [[OMP_BODY_CONTINUE]]
// CHECK:       omp.inscan.dispatch:
// CHECK-NEXT:    br label [[OMP_BEFORE_SCAN_BB:%.*]]
// CHECK:       omp.after.scan.bb:
// CHECK-NEXT:    [[TMP44:%.*]] = load float, ptr [[TMP4]], align 4
// CHECK-NEXT:    [[TMP45:%.*]] = load ptr, ptr [[B_ADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP46:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// CHECK-NEXT:    [[IDXPROM9:%.*]] = sext i32 [[TMP46]] to i64
// CHECK-NEXT:    [[ARRAYIDX10:%.*]] = getelementptr inbounds float, ptr [[TMP45]], i64 [[IDXPROM9]]
// CHECK-NEXT:    store float [[TMP44]], ptr [[ARRAYIDX10]], align 4
// CHECK-NEXT:    br label [[OMP_EXIT_INSCAN_BB:%.*]]
// CHECK:       omp.body.continue:
// CHECK-NEXT:    br label [[FOR_INC:%.*]]
// CHECK:       for.inc:
// CHECK-NEXT:    [[TMP47:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP48:%.*]] = getelementptr float, ptr [[TMP31]], i32 [[TMP47]]
// CHECK-NEXT:    [[TMP49:%.*]] = load float, ptr addrspace(5) [[TMP7]], align 4
// CHECK-NEXT:    store float [[TMP49]], ptr [[TMP48]], align 4
// CHECK-NEXT:    [[TMP50:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP51:%.*]] = add i32 1, [[TMP50]]
// CHECK-NEXT:    store i32 [[TMP51]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    br label [[FOR_COND]], !llvm.loop [[LOOP66:![0-9]+]]
// CHECK:       for.end:
// CHECK-NEXT:    [[TMP52:%.*]] = load ptr, ptr [[DOTADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP53:%.*]] = load ptr, ptr [[DOTADDR3_ASCAST]], align 8
// CHECK-NEXT:    [[TMP54:%.*]] = load ptr, ptr [[DOTADDR4_ASCAST]], align 8
// CHECK-NEXT:    [[TMP55:%.*]] = load float, ptr addrspace(5) [[TMP7]], align 4
// CHECK-NEXT:    call void @__kmpc_xteams_f_16x64(float [[TMP55]], ptr [[TMP54]], ptr [[TMP4]], ptr [[TMP52]], ptr [[TMP53]], ptr @__kmpc_rfun_sum_f, ptr @__kmpc_rfun_sum_lds_f, float 0.000000e+00, i64 [[TMP16]], i32 [[TMP15]])
// CHECK-NEXT:    br label [[OMP_KERNEL_DONE]]
// CHECK:       omp.kernel.done:
// CHECK-NEXT:    ret void
//
//
// CHECK-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z8run_testIfEvv_l35_1
// CHECK-SAME: (ptr noalias noundef [[DYN_PTR:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM:%.*]], ptr noundef [[A:%.*]], ptr noundef [[B:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM1:%.*]], ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]], ptr noundef [[TMP2:%.*]], ptr noundef [[TMP3:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[DYN_PTR_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[SUM_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[A_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[B_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8, addrspace(5)
// CHECK-NEXT:    [[SUM_ADDR2:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[DOTADDR3:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[DOTADDR4:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[DOTADDR5:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[I:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[SUM8:%.*]] = alloca float, align 4, addrspace(5)
// CHECK-NEXT:    [[DYN_PTR_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DYN_PTR_ADDR]] to ptr
// CHECK-NEXT:    [[SUM_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM_ADDR]] to ptr
// CHECK-NEXT:    [[A_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[A_ADDR]] to ptr
// CHECK-NEXT:    [[B_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[B_ADDR]] to ptr
// CHECK-NEXT:    [[VLA_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[VLA_ADDR]] to ptr
// CHECK-NEXT:    [[SUM_ADDR2_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM_ADDR2]] to ptr
// CHECK-NEXT:    [[DOTADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR]] to ptr
// CHECK-NEXT:    [[DOTADDR3_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR3]] to ptr
// CHECK-NEXT:    [[DOTADDR4_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR4]] to ptr
// CHECK-NEXT:    [[DOTADDR5_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR5]] to ptr
// CHECK-NEXT:    [[I_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[I]] to ptr
// CHECK-NEXT:    [[DOTOMP_LB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_LB]] to ptr
// CHECK-NEXT:    [[DOTOMP_UB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_UB]] to ptr
// CHECK-NEXT:    [[DOTOMP_IV_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_IV]] to ptr
// CHECK-NEXT:    [[SUM8_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM8]] to ptr
// CHECK-NEXT:    store ptr [[DYN_PTR]], ptr [[DYN_PTR_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[SUM]], ptr [[SUM_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[A]], ptr [[A_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[B]], ptr [[B_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[SUM1]], ptr [[SUM_ADDR2_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR3_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[TMP2]], ptr [[DOTADDR4_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[TMP3]], ptr [[DOTADDR5_ASCAST]], align 8
// CHECK-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[SUM_ADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP5:%.*]] = load i64, ptr [[VLA_ADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP6:%.*]] = load ptr, ptr [[SUM_ADDR2_ASCAST]], align 8
// CHECK-NEXT:    call void @__kmpc_specialized_kernel_init()
// CHECK-NEXT:    [[TMP7:%.*]] = alloca float, align 4, addrspace(5)
// CHECK-NEXT:    store float 0.000000e+00, ptr addrspace(5) [[TMP7]], align 4
// CHECK-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// CHECK-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// CHECK-NEXT:    store i32 0, ptr [[DOTOMP_LB_ASCAST]], align 4
// CHECK-NEXT:    store i32 999999, ptr [[DOTOMP_UB_ASCAST]], align 4
// CHECK-NEXT:    [[TMP8:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// CHECK-NEXT:    store i32 [[TMP8]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP9:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// CHECK-NEXT:    [[NVPTX_NUM_THREADS:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// CHECK-NEXT:    [[GPU_BLOCK_ID:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// CHECK-NEXT:    [[TMP10:%.*]] = mul i32 [[GPU_BLOCK_ID]], [[NVPTX_NUM_THREADS]]
// CHECK-NEXT:    [[TMP11:%.*]] = add i32 [[TMP10]], [[TMP9]]
// CHECK-NEXT:    [[TMP12:%.*]] = mul i32 [[TMP11]], 1
// CHECK-NEXT:    [[TMP13:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP14:%.*]] = add i32 [[TMP12]], [[TMP13]]
// CHECK-NEXT:    [[TMP15:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// CHECK-NEXT:    [[TMP16:%.*]] = zext i32 [[TMP14]] to i64
// CHECK-NEXT:    store i32 [[TMP14]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[GLOBAL_UPPER_BOUND:%.*]] = load i32, ptr [[DOTOMP_UB_ASCAST]], align 4
// CHECK-NEXT:    [[TMP17:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// CHECK-NEXT:    [[TMP18:%.*]] = sub i32 [[GLOBAL_UPPER_BOUND]], [[TMP17]]
// CHECK-NEXT:    [[TMP19:%.*]] = add i32 [[TMP18]], 1
// CHECK-NEXT:    [[TMP20:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// CHECK-NEXT:    [[NVPTX_NUM_THREADS6:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// CHECK-NEXT:    [[GPU_BLOCK_ID7:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// CHECK-NEXT:    [[TMP21:%.*]] = mul i32 [[GPU_BLOCK_ID7]], [[NVPTX_NUM_THREADS6]]
// CHECK-NEXT:    [[TMP22:%.*]] = add i32 [[TMP21]], [[TMP20]]
// CHECK-NEXT:    [[TMP23:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// CHECK-NEXT:    [[TMP24:%.*]] = mul i32 [[NVPTX_NUM_THREADS6]], [[TMP23]]
// CHECK-NEXT:    [[TMP25:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP26:%.*]] = icmp ult i32 [[TMP25]], [[TMP24]]
// CHECK-NEXT:    br i1 [[TMP26]], label [[OMP_KERNEL_BODY:%.*]], label [[OMP_KERNEL_DONE:%.*]]
// CHECK:       omp.kernel.body:
// CHECK-NEXT:    [[TMP27:%.*]] = udiv i32 [[TMP19]], [[TMP24]]
// CHECK-NEXT:    [[PADDED_SEGMENT_SIZE:%.*]] = add i32 [[TMP27]], 1
// CHECK-NEXT:    [[TMP28:%.*]] = load ptr, ptr [[DOTADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP29:%.*]] = load ptr, ptr [[DOTADDR4_ASCAST]], align 8
// CHECK-NEXT:    [[TMP30:%.*]] = load ptr, ptr [[DOTADDR5_ASCAST]], align 8
// CHECK-NEXT:    [[TMP31:%.*]] = load float, ptr addrspace(5) [[TMP7]], align 4
// CHECK-NEXT:    call void @__kmpc_xteams_phase2_f_16x64(ptr [[TMP29]], i32 [[PADDED_SEGMENT_SIZE]], ptr [[TMP28]], ptr [[TMP30]], ptr @__kmpc_rfun_sum_f, float 0.000000e+00, i64 [[TMP16]], i32 1)
// CHECK-NEXT:    [[TMP32:%.*]] = mul i32 [[PADDED_SEGMENT_SIZE]], [[TMP22]]
// CHECK-NEXT:    store i32 [[TMP32]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP33:%.*]] = add i32 [[TMP22]], 1
// CHECK-NEXT:    [[TMP34:%.*]] = mul i32 [[PADDED_SEGMENT_SIZE]], [[TMP33]]
// CHECK-NEXT:    [[TMP35:%.*]] = load ptr, ptr [[DOTADDR5_ASCAST]], align 8
// CHECK-NEXT:    br label [[FOR_COND:%.*]]
// CHECK:       for.cond:
// CHECK-NEXT:    [[TMP36:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP37:%.*]] = icmp ult i32 [[TMP36]], [[TMP34]]
// CHECK-NEXT:    [[TMP38:%.*]] = icmp ule i32 [[TMP36]], [[GLOBAL_UPPER_BOUND]]
// CHECK-NEXT:    [[TMP39:%.*]] = and i1 [[TMP38]], [[TMP37]]
// CHECK-NEXT:    br i1 [[TMP39]], label [[FOR_BODY:%.*]], label [[FOR_END:%.*]]
// CHECK:       for.body:
// CHECK-NEXT:    [[TMP40:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP40]], 1
// CHECK-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK-NEXT:    store i32 [[ADD]], ptr [[I_ASCAST]], align 4
// CHECK-NEXT:    [[TMP41:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP42:%.*]] = getelementptr float, ptr [[TMP35]], i32 [[TMP41]]
// CHECK-NEXT:    [[TMP43:%.*]] = load float, ptr [[TMP42]], align 4
// CHECK-NEXT:    store float [[TMP43]], ptr addrspace(5) [[TMP7]], align 4
// CHECK-NEXT:    store float 0.000000e+00, ptr [[SUM8_ASCAST]], align 4
// CHECK-NEXT:    br label [[OMP_INSCAN_DISPATCH:%.*]]
// CHECK:       omp.before.scan.bb:
// CHECK-NEXT:    [[TMP44:%.*]] = load ptr, ptr [[A_ADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP45:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// CHECK-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP45]] to i64
// CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds float, ptr [[TMP44]], i64 [[IDXPROM]]
// CHECK-NEXT:    [[TMP46:%.*]] = load float, ptr [[ARRAYIDX]], align 4
// CHECK-NEXT:    [[TMP47:%.*]] = load float, ptr addrspace(5) [[TMP7]], align 4
// CHECK-NEXT:    [[TMP48:%.*]] = fadd float [[TMP47]], [[TMP46]]
// CHECK-NEXT:    store float [[TMP48]], ptr addrspace(5) [[TMP7]], align 4
// CHECK-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK:       omp.exit.inscan.bb:
// CHECK-NEXT:    br label [[OMP_BODY_CONTINUE]]
// CHECK:       omp.inscan.dispatch:
// CHECK-NEXT:    [[TMP49:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP50:%.*]] = zext i32 [[TMP49]] to i64
// CHECK-NEXT:    [[ARRAYIDX9:%.*]] = getelementptr inbounds nuw float, ptr [[TMP6]], i64 [[TMP50]]
// CHECK-NEXT:    [[TMP51:%.*]] = load float, ptr addrspace(5) [[TMP7]], align 4
// CHECK-NEXT:    store float [[TMP51]], ptr [[TMP4]], align 4
// CHECK-NEXT:    br label [[OMP_AFTER_SCAN_BB:%.*]]
// CHECK:       omp.after.scan.bb:
// CHECK-NEXT:    [[TMP52:%.*]] = load ptr, ptr [[B_ADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP53:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// CHECK-NEXT:    [[IDXPROM10:%.*]] = sext i32 [[TMP53]] to i64
// CHECK-NEXT:    [[ARRAYIDX11:%.*]] = getelementptr inbounds float, ptr [[TMP52]], i64 [[IDXPROM10]]
// CHECK-NEXT:    [[TMP54:%.*]] = load float, ptr addrspace(5) [[TMP7]], align 4
// CHECK-NEXT:    store float [[TMP54]], ptr [[ARRAYIDX11]], align 4
// CHECK-NEXT:    br label [[OMP_EXIT_INSCAN_BB:%.*]]
// CHECK:       omp.body.continue:
// CHECK-NEXT:    br label [[FOR_INC:%.*]]
// CHECK:       for.inc:
// CHECK-NEXT:    [[TMP55:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP56:%.*]] = getelementptr float, ptr [[TMP35]], i32 [[TMP55]]
// CHECK-NEXT:    [[TMP57:%.*]] = load float, ptr addrspace(5) [[TMP7]], align 4
// CHECK-NEXT:    store float [[TMP57]], ptr [[TMP56]], align 4
// CHECK-NEXT:    [[TMP58:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP59:%.*]] = add i32 1, [[TMP58]]
// CHECK-NEXT:    store i32 [[TMP59]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    br label [[FOR_COND]], !llvm.loop [[LOOP67:![0-9]+]]
// CHECK:       for.end:
// CHECK-NEXT:    br label [[OMP_KERNEL_DONE]]
// CHECK:       omp.kernel.done:
// CHECK-NEXT:    ret void
//
//
// CHECK-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z8run_testIfEvv_l47
// CHECK-SAME: (ptr noalias noundef [[DYN_PTR:%.*]], ptr noundef [[B:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM:%.*]], ptr noundef [[A:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM1:%.*]], ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]], ptr noundef [[TMP2:%.*]], ptr noundef [[TMP3:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[DYN_PTR_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[B_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[SUM_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[A_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8, addrspace(5)
// CHECK-NEXT:    [[SUM_ADDR2:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[DOTADDR3:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[DOTADDR4:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[DOTADDR5:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[I:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[SUM8:%.*]] = alloca float, align 4, addrspace(5)
// CHECK-NEXT:    [[DYN_PTR_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DYN_PTR_ADDR]] to ptr
// CHECK-NEXT:    [[B_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[B_ADDR]] to ptr
// CHECK-NEXT:    [[SUM_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM_ADDR]] to ptr
// CHECK-NEXT:    [[A_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[A_ADDR]] to ptr
// CHECK-NEXT:    [[VLA_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[VLA_ADDR]] to ptr
// CHECK-NEXT:    [[SUM_ADDR2_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM_ADDR2]] to ptr
// CHECK-NEXT:    [[DOTADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR]] to ptr
// CHECK-NEXT:    [[DOTADDR3_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR3]] to ptr
// CHECK-NEXT:    [[DOTADDR4_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR4]] to ptr
// CHECK-NEXT:    [[DOTADDR5_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR5]] to ptr
// CHECK-NEXT:    [[I_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[I]] to ptr
// CHECK-NEXT:    [[DOTOMP_LB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_LB]] to ptr
// CHECK-NEXT:    [[DOTOMP_UB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_UB]] to ptr
// CHECK-NEXT:    [[DOTOMP_IV_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_IV]] to ptr
// CHECK-NEXT:    [[SUM8_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM8]] to ptr
// CHECK-NEXT:    store ptr [[DYN_PTR]], ptr [[DYN_PTR_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[B]], ptr [[B_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[SUM]], ptr [[SUM_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[A]], ptr [[A_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[SUM1]], ptr [[SUM_ADDR2_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR3_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[TMP2]], ptr [[DOTADDR4_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[TMP3]], ptr [[DOTADDR5_ASCAST]], align 8
// CHECK-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[SUM_ADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP5:%.*]] = load i64, ptr [[VLA_ADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP6:%.*]] = load ptr, ptr [[SUM_ADDR2_ASCAST]], align 8
// CHECK-NEXT:    call void @__kmpc_specialized_kernel_init()
// CHECK-NEXT:    [[TMP7:%.*]] = alloca float, align 4, addrspace(5)
// CHECK-NEXT:    store float 0.000000e+00, ptr addrspace(5) [[TMP7]], align 4
// CHECK-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// CHECK-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// CHECK-NEXT:    store i32 0, ptr [[DOTOMP_LB_ASCAST]], align 4
// CHECK-NEXT:    store i32 999999, ptr [[DOTOMP_UB_ASCAST]], align 4
// CHECK-NEXT:    [[TMP8:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// CHECK-NEXT:    store i32 [[TMP8]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP9:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// CHECK-NEXT:    [[NVPTX_NUM_THREADS:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// CHECK-NEXT:    [[GPU_BLOCK_ID:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// CHECK-NEXT:    [[TMP10:%.*]] = mul i32 [[GPU_BLOCK_ID]], [[NVPTX_NUM_THREADS]]
// CHECK-NEXT:    [[TMP11:%.*]] = add i32 [[TMP10]], [[TMP9]]
// CHECK-NEXT:    [[TMP12:%.*]] = mul i32 [[TMP11]], 1
// CHECK-NEXT:    [[TMP13:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP14:%.*]] = add i32 [[TMP12]], [[TMP13]]
// CHECK-NEXT:    [[TMP15:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// CHECK-NEXT:    [[TMP16:%.*]] = zext i32 [[TMP14]] to i64
// CHECK-NEXT:    store i32 [[TMP14]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[GLOBAL_UPPER_BOUND:%.*]] = load i32, ptr [[DOTOMP_UB_ASCAST]], align 4
// CHECK-NEXT:    [[TMP17:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// CHECK-NEXT:    [[TMP18:%.*]] = sub i32 [[GLOBAL_UPPER_BOUND]], [[TMP17]]
// CHECK-NEXT:    [[TMP19:%.*]] = add i32 [[TMP18]], 1
// CHECK-NEXT:    [[TMP20:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// CHECK-NEXT:    [[NVPTX_NUM_THREADS6:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// CHECK-NEXT:    [[GPU_BLOCK_ID7:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// CHECK-NEXT:    [[TMP21:%.*]] = mul i32 [[GPU_BLOCK_ID7]], [[NVPTX_NUM_THREADS6]]
// CHECK-NEXT:    [[TMP22:%.*]] = add i32 [[TMP21]], [[TMP20]]
// CHECK-NEXT:    [[TMP23:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// CHECK-NEXT:    [[TMP24:%.*]] = mul i32 [[NVPTX_NUM_THREADS6]], [[TMP23]]
// CHECK-NEXT:    [[TMP25:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP26:%.*]] = icmp ult i32 [[TMP25]], [[TMP24]]
// CHECK-NEXT:    br i1 [[TMP26]], label [[OMP_KERNEL_BODY:%.*]], label [[OMP_KERNEL_DONE:%.*]]
// CHECK:       omp.kernel.body:
// CHECK-NEXT:    [[TMP27:%.*]] = udiv i32 [[TMP19]], [[TMP24]]
// CHECK-NEXT:    [[PADDED_SEGMENT_SIZE:%.*]] = add i32 [[TMP27]], 1
// CHECK-NEXT:    [[TMP28:%.*]] = mul i32 [[PADDED_SEGMENT_SIZE]], [[TMP22]]
// CHECK-NEXT:    store i32 [[TMP28]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP29:%.*]] = add i32 [[TMP22]], 1
// CHECK-NEXT:    [[TMP30:%.*]] = mul i32 [[PADDED_SEGMENT_SIZE]], [[TMP29]]
// CHECK-NEXT:    [[TMP31:%.*]] = load ptr, ptr [[DOTADDR5_ASCAST]], align 8
// CHECK-NEXT:    br label [[FOR_COND:%.*]]
// CHECK:       for.cond:
// CHECK-NEXT:    [[TMP32:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP33:%.*]] = icmp ult i32 [[TMP32]], [[TMP30]]
// CHECK-NEXT:    [[TMP34:%.*]] = icmp ule i32 [[TMP32]], [[GLOBAL_UPPER_BOUND]]
// CHECK-NEXT:    [[TMP35:%.*]] = and i1 [[TMP34]], [[TMP33]]
// CHECK-NEXT:    br i1 [[TMP35]], label [[FOR_BODY:%.*]], label [[FOR_END:%.*]]
// CHECK:       for.body:
// CHECK-NEXT:    [[TMP36:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP36]], 1
// CHECK-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK-NEXT:    store i32 [[ADD]], ptr [[I_ASCAST]], align 4
// CHECK-NEXT:    store float 0.000000e+00, ptr [[SUM8_ASCAST]], align 4
// CHECK-NEXT:    br label [[OMP_INSCAN_DISPATCH:%.*]]
// CHECK:       omp.before.scan.bb:
// CHECK-NEXT:    [[TMP37:%.*]] = load float, ptr [[TMP4]], align 4
// CHECK-NEXT:    [[TMP38:%.*]] = load ptr, ptr [[B_ADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP39:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// CHECK-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP39]] to i64
// CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds float, ptr [[TMP38]], i64 [[IDXPROM]]
// CHECK-NEXT:    store float [[TMP37]], ptr [[ARRAYIDX]], align 4
// CHECK-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK:       omp.exit.inscan.bb:
// CHECK-NEXT:    [[TMP40:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP41:%.*]] = zext i32 [[TMP40]] to i64
// CHECK-NEXT:    br label [[OMP_BODY_CONTINUE]]
// CHECK:       omp.inscan.dispatch:
// CHECK-NEXT:    br label [[OMP_AFTER_SCAN_BB:%.*]]
// CHECK:       omp.after.scan.bb:
// CHECK-NEXT:    [[TMP42:%.*]] = load ptr, ptr [[A_ADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP43:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// CHECK-NEXT:    [[IDXPROM9:%.*]] = sext i32 [[TMP43]] to i64
// CHECK-NEXT:    [[ARRAYIDX10:%.*]] = getelementptr inbounds float, ptr [[TMP42]], i64 [[IDXPROM9]]
// CHECK-NEXT:    [[TMP44:%.*]] = load float, ptr [[ARRAYIDX10]], align 4
// CHECK-NEXT:    [[TMP45:%.*]] = load float, ptr addrspace(5) [[TMP7]], align 4
// CHECK-NEXT:    [[TMP46:%.*]] = fadd float [[TMP45]], [[TMP44]]
// CHECK-NEXT:    store float [[TMP46]], ptr addrspace(5) [[TMP7]], align 4
// CHECK-NEXT:    br label [[OMP_EXIT_INSCAN_BB:%.*]]
// CHECK:       omp.body.continue:
// CHECK-NEXT:    br label [[FOR_INC:%.*]]
// CHECK:       for.inc:
// CHECK-NEXT:    [[TMP47:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP48:%.*]] = getelementptr float, ptr [[TMP31]], i32 [[TMP47]]
// CHECK-NEXT:    [[TMP49:%.*]] = load float, ptr addrspace(5) [[TMP7]], align 4
// CHECK-NEXT:    store float [[TMP49]], ptr [[TMP48]], align 4
// CHECK-NEXT:    [[TMP50:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP51:%.*]] = add i32 1, [[TMP50]]
// CHECK-NEXT:    store i32 [[TMP51]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    br label [[FOR_COND]], !llvm.loop [[LOOP68:![0-9]+]]
// CHECK:       for.end:
// CHECK-NEXT:    [[TMP52:%.*]] = load ptr, ptr [[DOTADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP53:%.*]] = load ptr, ptr [[DOTADDR3_ASCAST]], align 8
// CHECK-NEXT:    [[TMP54:%.*]] = load ptr, ptr [[DOTADDR4_ASCAST]], align 8
// CHECK-NEXT:    [[TMP55:%.*]] = load float, ptr addrspace(5) [[TMP7]], align 4
// CHECK-NEXT:    call void @__kmpc_xteams_f_16x64(float [[TMP55]], ptr [[TMP54]], ptr [[TMP4]], ptr [[TMP52]], ptr [[TMP53]], ptr @__kmpc_rfun_sum_f, ptr @__kmpc_rfun_sum_lds_f, float 0.000000e+00, i64 [[TMP16]], i32 [[TMP15]])
// CHECK-NEXT:    br label [[OMP_KERNEL_DONE]]
// CHECK:       omp.kernel.done:
// CHECK-NEXT:    ret void
//
//
// CHECK-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z8run_testIfEvv_l47_1
// CHECK-SAME: (ptr noalias noundef [[DYN_PTR:%.*]], ptr noundef [[B:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM:%.*]], ptr noundef [[A:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM1:%.*]], ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]], ptr noundef [[TMP2:%.*]], ptr noundef [[TMP3:%.*]]) #[[ATTR0]] {
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[DYN_PTR_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[B_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[SUM_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[A_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8, addrspace(5)
// CHECK-NEXT:    [[SUM_ADDR2:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[DOTADDR3:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[DOTADDR4:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[DOTADDR5:%.*]] = alloca ptr, align 8, addrspace(5)
// CHECK-NEXT:    [[I:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4, addrspace(5)
// CHECK-NEXT:    [[SUM8:%.*]] = alloca float, align 4, addrspace(5)
// CHECK-NEXT:    [[DYN_PTR_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DYN_PTR_ADDR]] to ptr
// CHECK-NEXT:    [[B_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[B_ADDR]] to ptr
// CHECK-NEXT:    [[SUM_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM_ADDR]] to ptr
// CHECK-NEXT:    [[A_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[A_ADDR]] to ptr
// CHECK-NEXT:    [[VLA_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[VLA_ADDR]] to ptr
// CHECK-NEXT:    [[SUM_ADDR2_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM_ADDR2]] to ptr
// CHECK-NEXT:    [[DOTADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR]] to ptr
// CHECK-NEXT:    [[DOTADDR3_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR3]] to ptr
// CHECK-NEXT:    [[DOTADDR4_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR4]] to ptr
// CHECK-NEXT:    [[DOTADDR5_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR5]] to ptr
// CHECK-NEXT:    [[I_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[I]] to ptr
// CHECK-NEXT:    [[DOTOMP_LB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_LB]] to ptr
// CHECK-NEXT:    [[DOTOMP_UB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_UB]] to ptr
// CHECK-NEXT:    [[DOTOMP_IV_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_IV]] to ptr
// CHECK-NEXT:    [[SUM8_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM8]] to ptr
// CHECK-NEXT:    store ptr [[DYN_PTR]], ptr [[DYN_PTR_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[B]], ptr [[B_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[SUM]], ptr [[SUM_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[A]], ptr [[A_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[SUM1]], ptr [[SUM_ADDR2_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR3_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[TMP2]], ptr [[DOTADDR4_ASCAST]], align 8
// CHECK-NEXT:    store ptr [[TMP3]], ptr [[DOTADDR5_ASCAST]], align 8
// CHECK-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[SUM_ADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP5:%.*]] = load i64, ptr [[VLA_ADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP6:%.*]] = load ptr, ptr [[SUM_ADDR2_ASCAST]], align 8
// CHECK-NEXT:    call void @__kmpc_specialized_kernel_init()
// CHECK-NEXT:    [[TMP7:%.*]] = alloca float, align 4, addrspace(5)
// CHECK-NEXT:    store float 0.000000e+00, ptr addrspace(5) [[TMP7]], align 4
// CHECK-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// CHECK-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// CHECK-NEXT:    store i32 0, ptr [[DOTOMP_LB_ASCAST]], align 4
// CHECK-NEXT:    store i32 999999, ptr [[DOTOMP_UB_ASCAST]], align 4
// CHECK-NEXT:    [[TMP8:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// CHECK-NEXT:    store i32 [[TMP8]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP9:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// CHECK-NEXT:    [[NVPTX_NUM_THREADS:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// CHECK-NEXT:    [[GPU_BLOCK_ID:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// CHECK-NEXT:    [[TMP10:%.*]] = mul i32 [[GPU_BLOCK_ID]], [[NVPTX_NUM_THREADS]]
// CHECK-NEXT:    [[TMP11:%.*]] = add i32 [[TMP10]], [[TMP9]]
// CHECK-NEXT:    [[TMP12:%.*]] = mul i32 [[TMP11]], 1
// CHECK-NEXT:    [[TMP13:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP14:%.*]] = add i32 [[TMP12]], [[TMP13]]
// CHECK-NEXT:    [[TMP15:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// CHECK-NEXT:    [[TMP16:%.*]] = zext i32 [[TMP14]] to i64
// CHECK-NEXT:    store i32 [[TMP14]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[GLOBAL_UPPER_BOUND:%.*]] = load i32, ptr [[DOTOMP_UB_ASCAST]], align 4
// CHECK-NEXT:    [[TMP17:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// CHECK-NEXT:    [[TMP18:%.*]] = sub i32 [[GLOBAL_UPPER_BOUND]], [[TMP17]]
// CHECK-NEXT:    [[TMP19:%.*]] = add i32 [[TMP18]], 1
// CHECK-NEXT:    [[TMP20:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// CHECK-NEXT:    [[NVPTX_NUM_THREADS6:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// CHECK-NEXT:    [[GPU_BLOCK_ID7:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// CHECK-NEXT:    [[TMP21:%.*]] = mul i32 [[GPU_BLOCK_ID7]], [[NVPTX_NUM_THREADS6]]
// CHECK-NEXT:    [[TMP22:%.*]] = add i32 [[TMP21]], [[TMP20]]
// CHECK-NEXT:    [[TMP23:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// CHECK-NEXT:    [[TMP24:%.*]] = mul i32 [[NVPTX_NUM_THREADS6]], [[TMP23]]
// CHECK-NEXT:    [[TMP25:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP26:%.*]] = icmp ult i32 [[TMP25]], [[TMP24]]
// CHECK-NEXT:    br i1 [[TMP26]], label [[OMP_KERNEL_BODY:%.*]], label [[OMP_KERNEL_DONE:%.*]]
// CHECK:       omp.kernel.body:
// CHECK-NEXT:    [[TMP27:%.*]] = udiv i32 [[TMP19]], [[TMP24]]
// CHECK-NEXT:    [[PADDED_SEGMENT_SIZE:%.*]] = add i32 [[TMP27]], 1
// CHECK-NEXT:    [[TMP28:%.*]] = load ptr, ptr [[DOTADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP29:%.*]] = load ptr, ptr [[DOTADDR4_ASCAST]], align 8
// CHECK-NEXT:    [[TMP30:%.*]] = load ptr, ptr [[DOTADDR5_ASCAST]], align 8
// CHECK-NEXT:    [[TMP31:%.*]] = load float, ptr addrspace(5) [[TMP7]], align 4
// CHECK-NEXT:    call void @__kmpc_xteams_phase2_f_16x64(ptr [[TMP29]], i32 [[PADDED_SEGMENT_SIZE]], ptr [[TMP28]], ptr [[TMP30]], ptr @__kmpc_rfun_sum_f, float 0.000000e+00, i64 [[TMP16]], i32 0)
// CHECK-NEXT:    [[TMP32:%.*]] = mul i32 [[PADDED_SEGMENT_SIZE]], [[TMP22]]
// CHECK-NEXT:    store i32 [[TMP32]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP33:%.*]] = add i32 [[TMP22]], 1
// CHECK-NEXT:    [[TMP34:%.*]] = mul i32 [[PADDED_SEGMENT_SIZE]], [[TMP33]]
// CHECK-NEXT:    [[TMP35:%.*]] = load ptr, ptr [[DOTADDR5_ASCAST]], align 8
// CHECK-NEXT:    br label [[FOR_COND:%.*]]
// CHECK:       for.cond:
// CHECK-NEXT:    [[TMP36:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP37:%.*]] = icmp ult i32 [[TMP36]], [[TMP34]]
// CHECK-NEXT:    [[TMP38:%.*]] = icmp ule i32 [[TMP36]], [[GLOBAL_UPPER_BOUND]]
// CHECK-NEXT:    [[TMP39:%.*]] = and i1 [[TMP38]], [[TMP37]]
// CHECK-NEXT:    br i1 [[TMP39]], label [[FOR_BODY:%.*]], label [[FOR_END:%.*]]
// CHECK:       for.body:
// CHECK-NEXT:    [[TMP40:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP40]], 1
// CHECK-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// CHECK-NEXT:    store i32 [[ADD]], ptr [[I_ASCAST]], align 4
// CHECK-NEXT:    [[TMP41:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP42:%.*]] = getelementptr float, ptr [[TMP35]], i32 [[TMP41]]
// CHECK-NEXT:    [[TMP43:%.*]] = load float, ptr [[TMP42]], align 4
// CHECK-NEXT:    store float [[TMP43]], ptr addrspace(5) [[TMP7]], align 4
// CHECK-NEXT:    store float 0.000000e+00, ptr [[SUM8_ASCAST]], align 4
// CHECK-NEXT:    br label [[OMP_INSCAN_DISPATCH:%.*]]
// CHECK:       omp.before.scan.bb:
// CHECK-NEXT:    [[TMP44:%.*]] = load ptr, ptr [[B_ADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP45:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// CHECK-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP45]] to i64
// CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds float, ptr [[TMP44]], i64 [[IDXPROM]]
// CHECK-NEXT:    [[TMP46:%.*]] = load float, ptr addrspace(5) [[TMP7]], align 4
// CHECK-NEXT:    store float [[TMP46]], ptr [[ARRAYIDX]], align 4
// CHECK-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// CHECK:       omp.exit.inscan.bb:
// CHECK-NEXT:    br label [[OMP_BODY_CONTINUE]]
// CHECK:       omp.inscan.dispatch:
// CHECK-NEXT:    [[TMP47:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP48:%.*]] = zext i32 [[TMP47]] to i64
// CHECK-NEXT:    [[TMP49:%.*]] = icmp eq i64 [[TMP48]], 0
// CHECK-NEXT:    br i1 [[TMP49]], label [[OMP_EXCLUSIVE_COPY_EXIT:%.*]], label [[OMP_EXCLUSIVE_DEC:%.*]]
// CHECK:       omp.exclusive.dec:
// CHECK-NEXT:    [[TMP50:%.*]] = sub nuw i64 [[TMP48]], 1
// CHECK-NEXT:    [[ARRAYIDX9:%.*]] = getelementptr inbounds nuw float, ptr [[TMP6]], i64 [[TMP50]]
// CHECK-NEXT:    [[TMP51:%.*]] = load float, ptr addrspace(5) [[TMP7]], align 4
// CHECK-NEXT:    store float [[TMP51]], ptr [[TMP4]], align 4
// CHECK-NEXT:    br label [[OMP_EXCLUSIVE_COPY_EXIT]]
// CHECK:       omp.exclusive.copy.exit:
// CHECK-NEXT:    br label [[OMP_BEFORE_SCAN_BB:%.*]]
// CHECK:       omp.after.scan.bb:
// CHECK-NEXT:    [[TMP52:%.*]] = load ptr, ptr [[A_ADDR_ASCAST]], align 8
// CHECK-NEXT:    [[TMP53:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// CHECK-NEXT:    [[IDXPROM10:%.*]] = sext i32 [[TMP53]] to i64
// CHECK-NEXT:    [[ARRAYIDX11:%.*]] = getelementptr inbounds float, ptr [[TMP52]], i64 [[IDXPROM10]]
// CHECK-NEXT:    [[TMP54:%.*]] = load float, ptr [[ARRAYIDX11]], align 4
// CHECK-NEXT:    [[TMP55:%.*]] = load float, ptr addrspace(5) [[TMP7]], align 4
// CHECK-NEXT:    [[TMP56:%.*]] = fadd float [[TMP55]], [[TMP54]]
// CHECK-NEXT:    store float [[TMP56]], ptr addrspace(5) [[TMP7]], align 4
// CHECK-NEXT:    br label [[OMP_EXIT_INSCAN_BB:%.*]]
// CHECK:       omp.body.continue:
// CHECK-NEXT:    br label [[FOR_INC:%.*]]
// CHECK:       for.inc:
// CHECK-NEXT:    [[TMP57:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP58:%.*]] = getelementptr float, ptr [[TMP35]], i32 [[TMP57]]
// CHECK-NEXT:    [[TMP59:%.*]] = load float, ptr addrspace(5) [[TMP7]], align 4
// CHECK-NEXT:    store float [[TMP59]], ptr [[TMP58]], align 4
// CHECK-NEXT:    [[TMP60:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    [[TMP61:%.*]] = add i32 1, [[TMP60]]
// CHECK-NEXT:    store i32 [[TMP61]], ptr [[DOTOMP_IV_ASCAST]], align 4
// CHECK-NEXT:    br label [[FOR_COND]], !llvm.loop [[LOOP69:![0-9]+]]
// CHECK:       for.end:
// CHECK-NEXT:    br label [[OMP_KERNEL_DONE]]
// CHECK:       omp.kernel.done:
// CHECK-NEXT:    ret void
//
//
// NO-LOOP-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z8run_testIiEvv_l33
// NO-LOOP-SAME: (ptr noalias noundef [[DYN_PTR:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM:%.*]], ptr noundef [[A:%.*]], ptr noundef [[B:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM1:%.*]], ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]], ptr noundef [[TMP2:%.*]]) #[[ATTR0:[0-9]+]] {
// NO-LOOP-NEXT:  entry:
// NO-LOOP-NEXT:    [[DYN_PTR_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[SUM_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[A_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[B_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[SUM_ADDR2:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[DOTADDR3:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[DOTADDR4:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[I:%.*]] = alloca i32, align 4, addrspace(5)
// NO-LOOP-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4, addrspace(5)
// NO-LOOP-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4, addrspace(5)
// NO-LOOP-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4, addrspace(5)
// NO-LOOP-NEXT:    [[SUM5:%.*]] = alloca i32, align 4, addrspace(5)
// NO-LOOP-NEXT:    [[DYN_PTR_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DYN_PTR_ADDR]] to ptr
// NO-LOOP-NEXT:    [[SUM_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM_ADDR]] to ptr
// NO-LOOP-NEXT:    [[A_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[A_ADDR]] to ptr
// NO-LOOP-NEXT:    [[B_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[B_ADDR]] to ptr
// NO-LOOP-NEXT:    [[VLA_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[VLA_ADDR]] to ptr
// NO-LOOP-NEXT:    [[SUM_ADDR2_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM_ADDR2]] to ptr
// NO-LOOP-NEXT:    [[DOTADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR]] to ptr
// NO-LOOP-NEXT:    [[DOTADDR3_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR3]] to ptr
// NO-LOOP-NEXT:    [[DOTADDR4_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR4]] to ptr
// NO-LOOP-NEXT:    [[I_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[I]] to ptr
// NO-LOOP-NEXT:    [[DOTOMP_LB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_LB]] to ptr
// NO-LOOP-NEXT:    [[DOTOMP_UB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_UB]] to ptr
// NO-LOOP-NEXT:    [[DOTOMP_IV_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_IV]] to ptr
// NO-LOOP-NEXT:    [[SUM5_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM5]] to ptr
// NO-LOOP-NEXT:    store ptr [[DYN_PTR]], ptr [[DYN_PTR_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[SUM]], ptr [[SUM_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[A]], ptr [[A_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[B]], ptr [[B_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[SUM1]], ptr [[SUM_ADDR2_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR3_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[TMP2]], ptr [[DOTADDR4_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[SUM_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP4:%.*]] = load i64, ptr [[VLA_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[SUM_ADDR2_ASCAST]], align 8
// NO-LOOP-NEXT:    call void @__kmpc_specialized_kernel_init()
// NO-LOOP-NEXT:    [[TMP6:%.*]] = alloca i32, align 4, addrspace(5)
// NO-LOOP-NEXT:    store i32 0, ptr addrspace(5) [[TMP6]], align 4
// NO-LOOP-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// NO-LOOP-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// NO-LOOP-NEXT:    store i32 0, ptr [[DOTOMP_LB_ASCAST]], align 4
// NO-LOOP-NEXT:    store i32 25599, ptr [[DOTOMP_UB_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP7:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// NO-LOOP-NEXT:    store i32 [[TMP7]], ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP8:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// NO-LOOP-NEXT:    [[NVPTX_NUM_THREADS:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// NO-LOOP-NEXT:    [[GPU_BLOCK_ID:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// NO-LOOP-NEXT:    [[TMP9:%.*]] = mul i32 [[GPU_BLOCK_ID]], [[NVPTX_NUM_THREADS]]
// NO-LOOP-NEXT:    [[TMP10:%.*]] = add i32 [[TMP9]], [[TMP8]]
// NO-LOOP-NEXT:    [[TMP11:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP12:%.*]] = add i32 [[TMP10]], [[TMP11]]
// NO-LOOP-NEXT:    [[TMP13:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// NO-LOOP-NEXT:    [[TMP14:%.*]] = zext i32 [[TMP12]] to i64
// NO-LOOP-NEXT:    [[TOTAL_NUM_THREADS:%.*]] = mul i32 [[TMP13]], [[NVPTX_NUM_THREADS]]
// NO-LOOP-NEXT:    store i32 [[TMP12]], ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP15:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP15]], 1
// NO-LOOP-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// NO-LOOP-NEXT:    store i32 [[ADD]], ptr [[I_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP16:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP17:%.*]] = load i32, ptr [[DOTOMP_UB_ASCAST]], align 4
// NO-LOOP-NEXT:    [[CMP:%.*]] = icmp sle i32 [[TMP16]], [[TMP17]]
// NO-LOOP-NEXT:    br i1 [[CMP]], label [[OMP_KERNEL_BODY:%.*]], label [[OMP_KERNEL_DONE:%.*]]
// NO-LOOP:       omp.kernel.body:
// NO-LOOP-NEXT:    store i32 0, ptr [[SUM5_ASCAST]], align 4
// NO-LOOP-NEXT:    br label [[OMP_INSCAN_DISPATCH:%.*]]
// NO-LOOP:       omp.before.scan.bb:
// NO-LOOP-NEXT:    [[TMP18:%.*]] = load ptr, ptr [[A_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP19:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// NO-LOOP-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP19]] to i64
// NO-LOOP-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, ptr [[TMP18]], i64 [[IDXPROM]]
// NO-LOOP-NEXT:    [[TMP20:%.*]] = load i32, ptr [[ARRAYIDX]], align 4
// NO-LOOP-NEXT:    [[TMP21:%.*]] = load i32, ptr addrspace(5) [[TMP6]], align 4
// NO-LOOP-NEXT:    [[TMP22:%.*]] = add i32 [[TMP21]], [[TMP20]]
// NO-LOOP-NEXT:    store i32 [[TMP22]], ptr addrspace(5) [[TMP6]], align 4
// NO-LOOP-NEXT:    [[TMP23:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP24:%.*]] = zext i32 [[TMP23]] to i64
// NO-LOOP-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// NO-LOOP:       omp.exit.inscan.bb:
// NO-LOOP-NEXT:    br label [[OMP_BODY_CONTINUE]]
// NO-LOOP:       omp.inscan.dispatch:
// NO-LOOP-NEXT:    br label [[OMP_BEFORE_SCAN_BB:%.*]]
// NO-LOOP:       omp.after.scan.bb:
// NO-LOOP-NEXT:    [[TMP25:%.*]] = load i32, ptr [[TMP3]], align 4
// NO-LOOP-NEXT:    [[TMP26:%.*]] = load ptr, ptr [[B_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP27:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// NO-LOOP-NEXT:    [[IDXPROM6:%.*]] = sext i32 [[TMP27]] to i64
// NO-LOOP-NEXT:    [[ARRAYIDX7:%.*]] = getelementptr inbounds i32, ptr [[TMP26]], i64 [[IDXPROM6]]
// NO-LOOP-NEXT:    store i32 [[TMP25]], ptr [[ARRAYIDX7]], align 4
// NO-LOOP-NEXT:    br label [[OMP_EXIT_INSCAN_BB:%.*]]
// NO-LOOP:       omp.body.continue:
// NO-LOOP-NEXT:    [[TMP28:%.*]] = load ptr, ptr [[DOTADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP29:%.*]] = load ptr, ptr [[DOTADDR3_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP30:%.*]] = load ptr, ptr [[DOTADDR4_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP31:%.*]] = load i32, ptr addrspace(5) [[TMP6]], align 4
// NO-LOOP-NEXT:    call void @__kmpc_xteams_i_4x64(i32 [[TMP31]], ptr [[TMP30]], ptr [[TMP3]], ptr [[TMP28]], ptr [[TMP29]], ptr @__kmpc_rfun_sum_i, ptr @__kmpc_rfun_sum_lds_i, i32 0, i64 [[TMP14]], i32 [[TMP13]])
// NO-LOOP-NEXT:    br label [[OMP_KERNEL_DONE]]
// NO-LOOP:       omp.kernel.done:
// NO-LOOP-NEXT:    ret void
//
//
// NO-LOOP-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z8run_testIiEvv_l33_1
// NO-LOOP-SAME: (ptr noalias noundef [[DYN_PTR:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM:%.*]], ptr noundef [[A:%.*]], ptr noundef [[B:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM1:%.*]], ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]], ptr noundef [[TMP2:%.*]]) #[[ATTR0]] {
// NO-LOOP-NEXT:  entry:
// NO-LOOP-NEXT:    [[DYN_PTR_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[SUM_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[A_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[B_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[SUM_ADDR2:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[DOTADDR3:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[DOTADDR4:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[I:%.*]] = alloca i32, align 4, addrspace(5)
// NO-LOOP-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4, addrspace(5)
// NO-LOOP-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4, addrspace(5)
// NO-LOOP-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4, addrspace(5)
// NO-LOOP-NEXT:    [[SUM5:%.*]] = alloca i32, align 4, addrspace(5)
// NO-LOOP-NEXT:    [[DYN_PTR_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DYN_PTR_ADDR]] to ptr
// NO-LOOP-NEXT:    [[SUM_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM_ADDR]] to ptr
// NO-LOOP-NEXT:    [[A_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[A_ADDR]] to ptr
// NO-LOOP-NEXT:    [[B_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[B_ADDR]] to ptr
// NO-LOOP-NEXT:    [[VLA_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[VLA_ADDR]] to ptr
// NO-LOOP-NEXT:    [[SUM_ADDR2_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM_ADDR2]] to ptr
// NO-LOOP-NEXT:    [[DOTADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR]] to ptr
// NO-LOOP-NEXT:    [[DOTADDR3_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR3]] to ptr
// NO-LOOP-NEXT:    [[DOTADDR4_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR4]] to ptr
// NO-LOOP-NEXT:    [[I_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[I]] to ptr
// NO-LOOP-NEXT:    [[DOTOMP_LB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_LB]] to ptr
// NO-LOOP-NEXT:    [[DOTOMP_UB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_UB]] to ptr
// NO-LOOP-NEXT:    [[DOTOMP_IV_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_IV]] to ptr
// NO-LOOP-NEXT:    [[SUM5_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM5]] to ptr
// NO-LOOP-NEXT:    store ptr [[DYN_PTR]], ptr [[DYN_PTR_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[SUM]], ptr [[SUM_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[A]], ptr [[A_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[B]], ptr [[B_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[SUM1]], ptr [[SUM_ADDR2_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR3_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[TMP2]], ptr [[DOTADDR4_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[SUM_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP4:%.*]] = load i64, ptr [[VLA_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[SUM_ADDR2_ASCAST]], align 8
// NO-LOOP-NEXT:    call void @__kmpc_specialized_kernel_init()
// NO-LOOP-NEXT:    [[TMP6:%.*]] = alloca i32, align 4, addrspace(5)
// NO-LOOP-NEXT:    store i32 0, ptr addrspace(5) [[TMP6]], align 4
// NO-LOOP-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// NO-LOOP-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// NO-LOOP-NEXT:    store i32 0, ptr [[DOTOMP_LB_ASCAST]], align 4
// NO-LOOP-NEXT:    store i32 25599, ptr [[DOTOMP_UB_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP7:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// NO-LOOP-NEXT:    store i32 [[TMP7]], ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP8:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// NO-LOOP-NEXT:    [[NVPTX_NUM_THREADS:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// NO-LOOP-NEXT:    [[GPU_BLOCK_ID:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// NO-LOOP-NEXT:    [[TMP9:%.*]] = mul i32 [[GPU_BLOCK_ID]], [[NVPTX_NUM_THREADS]]
// NO-LOOP-NEXT:    [[TMP10:%.*]] = add i32 [[TMP9]], [[TMP8]]
// NO-LOOP-NEXT:    [[TMP11:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP12:%.*]] = add i32 [[TMP10]], [[TMP11]]
// NO-LOOP-NEXT:    [[TMP13:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// NO-LOOP-NEXT:    [[TMP14:%.*]] = zext i32 [[TMP12]] to i64
// NO-LOOP-NEXT:    [[TOTAL_NUM_THREADS:%.*]] = mul i32 [[TMP13]], [[NVPTX_NUM_THREADS]]
// NO-LOOP-NEXT:    store i32 [[TMP12]], ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP15:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP15]], 1
// NO-LOOP-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// NO-LOOP-NEXT:    store i32 [[ADD]], ptr [[I_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP16:%.*]] = load ptr, ptr [[DOTADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP17:%.*]] = load ptr, ptr [[DOTADDR4_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP18:%.*]] = load ptr, ptr [[DOTADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP19:%.*]] = load ptr, ptr [[DOTADDR4_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP20:%.*]] = load i32, ptr addrspace(5) [[TMP6]], align 4
// NO-LOOP-NEXT:    call void @__kmpc_xteams_phase2_i_4x64(ptr [[TMP19]], i32 1, ptr [[TMP18]], ptr [[TMP19]], ptr @__kmpc_rfun_sum_i, i32 0, i64 [[TMP14]], i32 1)
// NO-LOOP-NEXT:    [[TMP21:%.*]] = add i32 [[TMP10]], [[TOTAL_NUM_THREADS]]
// NO-LOOP-NEXT:    [[TMP22:%.*]] = getelementptr i32, ptr [[TMP17]], i32 [[TMP21]]
// NO-LOOP-NEXT:    [[TMP23:%.*]] = load i32, ptr [[TMP22]], align 4
// NO-LOOP-NEXT:    store i32 [[TMP23]], ptr addrspace(5) [[TMP6]], align 4
// NO-LOOP-NEXT:    store i32 0, ptr [[SUM5_ASCAST]], align 4
// NO-LOOP-NEXT:    br label [[OMP_INSCAN_DISPATCH:%.*]]
// NO-LOOP:       omp.before.scan.bb:
// NO-LOOP-NEXT:    [[TMP24:%.*]] = load ptr, ptr [[A_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP25:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// NO-LOOP-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP25]] to i64
// NO-LOOP-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, ptr [[TMP24]], i64 [[IDXPROM]]
// NO-LOOP-NEXT:    [[TMP26:%.*]] = load i32, ptr [[ARRAYIDX]], align 4
// NO-LOOP-NEXT:    [[TMP27:%.*]] = load i32, ptr addrspace(5) [[TMP6]], align 4
// NO-LOOP-NEXT:    [[TMP28:%.*]] = add i32 [[TMP27]], [[TMP26]]
// NO-LOOP-NEXT:    store i32 [[TMP28]], ptr addrspace(5) [[TMP6]], align 4
// NO-LOOP-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// NO-LOOP:       omp.exit.inscan.bb:
// NO-LOOP-NEXT:    br label [[OMP_BODY_CONTINUE]]
// NO-LOOP:       omp.inscan.dispatch:
// NO-LOOP-NEXT:    [[TMP29:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP30:%.*]] = zext i32 [[TMP29]] to i64
// NO-LOOP-NEXT:    [[ARRAYIDX6:%.*]] = getelementptr inbounds nuw i32, ptr [[TMP5]], i64 [[TMP30]]
// NO-LOOP-NEXT:    [[TMP31:%.*]] = load i32, ptr addrspace(5) [[TMP6]], align 4
// NO-LOOP-NEXT:    store i32 [[TMP31]], ptr [[TMP3]], align 4
// NO-LOOP-NEXT:    br label [[OMP_AFTER_SCAN_BB:%.*]]
// NO-LOOP:       omp.after.scan.bb:
// NO-LOOP-NEXT:    [[TMP32:%.*]] = load ptr, ptr [[B_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP33:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// NO-LOOP-NEXT:    [[IDXPROM7:%.*]] = sext i32 [[TMP33]] to i64
// NO-LOOP-NEXT:    [[ARRAYIDX8:%.*]] = getelementptr inbounds i32, ptr [[TMP32]], i64 [[IDXPROM7]]
// NO-LOOP-NEXT:    [[TMP34:%.*]] = load i32, ptr addrspace(5) [[TMP6]], align 4
// NO-LOOP-NEXT:    store i32 [[TMP34]], ptr [[ARRAYIDX8]], align 4
// NO-LOOP-NEXT:    br label [[OMP_EXIT_INSCAN_BB:%.*]]
// NO-LOOP:       omp.body.continue:
// NO-LOOP-NEXT:    ret void
//
//
// NO-LOOP-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z8run_testIiEvv_l45
// NO-LOOP-SAME: (ptr noalias noundef [[DYN_PTR:%.*]], ptr noundef [[B:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM:%.*]], ptr noundef [[A:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM1:%.*]], ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]], ptr noundef [[TMP2:%.*]]) #[[ATTR0]] {
// NO-LOOP-NEXT:  entry:
// NO-LOOP-NEXT:    [[DYN_PTR_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[B_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[SUM_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[A_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[SUM_ADDR2:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[DOTADDR3:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[DOTADDR4:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[I:%.*]] = alloca i32, align 4, addrspace(5)
// NO-LOOP-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4, addrspace(5)
// NO-LOOP-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4, addrspace(5)
// NO-LOOP-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4, addrspace(5)
// NO-LOOP-NEXT:    [[SUM5:%.*]] = alloca i32, align 4, addrspace(5)
// NO-LOOP-NEXT:    [[DYN_PTR_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DYN_PTR_ADDR]] to ptr
// NO-LOOP-NEXT:    [[B_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[B_ADDR]] to ptr
// NO-LOOP-NEXT:    [[SUM_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM_ADDR]] to ptr
// NO-LOOP-NEXT:    [[A_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[A_ADDR]] to ptr
// NO-LOOP-NEXT:    [[VLA_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[VLA_ADDR]] to ptr
// NO-LOOP-NEXT:    [[SUM_ADDR2_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM_ADDR2]] to ptr
// NO-LOOP-NEXT:    [[DOTADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR]] to ptr
// NO-LOOP-NEXT:    [[DOTADDR3_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR3]] to ptr
// NO-LOOP-NEXT:    [[DOTADDR4_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR4]] to ptr
// NO-LOOP-NEXT:    [[I_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[I]] to ptr
// NO-LOOP-NEXT:    [[DOTOMP_LB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_LB]] to ptr
// NO-LOOP-NEXT:    [[DOTOMP_UB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_UB]] to ptr
// NO-LOOP-NEXT:    [[DOTOMP_IV_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_IV]] to ptr
// NO-LOOP-NEXT:    [[SUM5_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM5]] to ptr
// NO-LOOP-NEXT:    store ptr [[DYN_PTR]], ptr [[DYN_PTR_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[B]], ptr [[B_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[SUM]], ptr [[SUM_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[A]], ptr [[A_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[SUM1]], ptr [[SUM_ADDR2_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR3_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[TMP2]], ptr [[DOTADDR4_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[SUM_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP4:%.*]] = load i64, ptr [[VLA_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[SUM_ADDR2_ASCAST]], align 8
// NO-LOOP-NEXT:    call void @__kmpc_specialized_kernel_init()
// NO-LOOP-NEXT:    [[TMP6:%.*]] = alloca i32, align 4, addrspace(5)
// NO-LOOP-NEXT:    store i32 0, ptr addrspace(5) [[TMP6]], align 4
// NO-LOOP-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// NO-LOOP-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// NO-LOOP-NEXT:    store i32 0, ptr [[DOTOMP_LB_ASCAST]], align 4
// NO-LOOP-NEXT:    store i32 25599, ptr [[DOTOMP_UB_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP7:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// NO-LOOP-NEXT:    store i32 [[TMP7]], ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP8:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// NO-LOOP-NEXT:    [[NVPTX_NUM_THREADS:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// NO-LOOP-NEXT:    [[GPU_BLOCK_ID:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// NO-LOOP-NEXT:    [[TMP9:%.*]] = mul i32 [[GPU_BLOCK_ID]], [[NVPTX_NUM_THREADS]]
// NO-LOOP-NEXT:    [[TMP10:%.*]] = add i32 [[TMP9]], [[TMP8]]
// NO-LOOP-NEXT:    [[TMP11:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP12:%.*]] = add i32 [[TMP10]], [[TMP11]]
// NO-LOOP-NEXT:    [[TMP13:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// NO-LOOP-NEXT:    [[TMP14:%.*]] = zext i32 [[TMP12]] to i64
// NO-LOOP-NEXT:    [[TOTAL_NUM_THREADS:%.*]] = mul i32 [[TMP13]], [[NVPTX_NUM_THREADS]]
// NO-LOOP-NEXT:    store i32 [[TMP12]], ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP15:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP15]], 1
// NO-LOOP-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// NO-LOOP-NEXT:    store i32 [[ADD]], ptr [[I_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP16:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP17:%.*]] = load i32, ptr [[DOTOMP_UB_ASCAST]], align 4
// NO-LOOP-NEXT:    [[CMP:%.*]] = icmp sle i32 [[TMP16]], [[TMP17]]
// NO-LOOP-NEXT:    br i1 [[CMP]], label [[OMP_KERNEL_BODY:%.*]], label [[OMP_KERNEL_DONE:%.*]]
// NO-LOOP:       omp.kernel.body:
// NO-LOOP-NEXT:    store i32 0, ptr [[SUM5_ASCAST]], align 4
// NO-LOOP-NEXT:    br label [[OMP_INSCAN_DISPATCH:%.*]]
// NO-LOOP:       omp.before.scan.bb:
// NO-LOOP-NEXT:    [[TMP18:%.*]] = load i32, ptr [[TMP3]], align 4
// NO-LOOP-NEXT:    [[TMP19:%.*]] = load ptr, ptr [[B_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP20:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// NO-LOOP-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP20]] to i64
// NO-LOOP-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, ptr [[TMP19]], i64 [[IDXPROM]]
// NO-LOOP-NEXT:    store i32 [[TMP18]], ptr [[ARRAYIDX]], align 4
// NO-LOOP-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// NO-LOOP:       omp.exit.inscan.bb:
// NO-LOOP-NEXT:    [[TMP21:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP22:%.*]] = zext i32 [[TMP21]] to i64
// NO-LOOP-NEXT:    br label [[OMP_BODY_CONTINUE]]
// NO-LOOP:       omp.inscan.dispatch:
// NO-LOOP-NEXT:    br label [[OMP_AFTER_SCAN_BB:%.*]]
// NO-LOOP:       omp.after.scan.bb:
// NO-LOOP-NEXT:    [[TMP23:%.*]] = load ptr, ptr [[A_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP24:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// NO-LOOP-NEXT:    [[IDXPROM6:%.*]] = sext i32 [[TMP24]] to i64
// NO-LOOP-NEXT:    [[ARRAYIDX7:%.*]] = getelementptr inbounds i32, ptr [[TMP23]], i64 [[IDXPROM6]]
// NO-LOOP-NEXT:    [[TMP25:%.*]] = load i32, ptr [[ARRAYIDX7]], align 4
// NO-LOOP-NEXT:    [[TMP26:%.*]] = load i32, ptr addrspace(5) [[TMP6]], align 4
// NO-LOOP-NEXT:    [[TMP27:%.*]] = add i32 [[TMP26]], [[TMP25]]
// NO-LOOP-NEXT:    store i32 [[TMP27]], ptr addrspace(5) [[TMP6]], align 4
// NO-LOOP-NEXT:    br label [[OMP_EXIT_INSCAN_BB:%.*]]
// NO-LOOP:       omp.body.continue:
// NO-LOOP-NEXT:    [[TMP28:%.*]] = load ptr, ptr [[DOTADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP29:%.*]] = load ptr, ptr [[DOTADDR3_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP30:%.*]] = load ptr, ptr [[DOTADDR4_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP31:%.*]] = load i32, ptr addrspace(5) [[TMP6]], align 4
// NO-LOOP-NEXT:    call void @__kmpc_xteams_i_4x64(i32 [[TMP31]], ptr [[TMP30]], ptr [[TMP3]], ptr [[TMP28]], ptr [[TMP29]], ptr @__kmpc_rfun_sum_i, ptr @__kmpc_rfun_sum_lds_i, i32 0, i64 [[TMP14]], i32 [[TMP13]])
// NO-LOOP-NEXT:    br label [[OMP_KERNEL_DONE]]
// NO-LOOP:       omp.kernel.done:
// NO-LOOP-NEXT:    ret void
//
//
// NO-LOOP-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z8run_testIiEvv_l45_1
// NO-LOOP-SAME: (ptr noalias noundef [[DYN_PTR:%.*]], ptr noundef [[B:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM:%.*]], ptr noundef [[A:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM1:%.*]], ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]], ptr noundef [[TMP2:%.*]]) #[[ATTR0]] {
// NO-LOOP-NEXT:  entry:
// NO-LOOP-NEXT:    [[DYN_PTR_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[B_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[SUM_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[A_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[SUM_ADDR2:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[DOTADDR3:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[DOTADDR4:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[I:%.*]] = alloca i32, align 4, addrspace(5)
// NO-LOOP-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4, addrspace(5)
// NO-LOOP-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4, addrspace(5)
// NO-LOOP-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4, addrspace(5)
// NO-LOOP-NEXT:    [[SUM5:%.*]] = alloca i32, align 4, addrspace(5)
// NO-LOOP-NEXT:    [[DYN_PTR_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DYN_PTR_ADDR]] to ptr
// NO-LOOP-NEXT:    [[B_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[B_ADDR]] to ptr
// NO-LOOP-NEXT:    [[SUM_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM_ADDR]] to ptr
// NO-LOOP-NEXT:    [[A_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[A_ADDR]] to ptr
// NO-LOOP-NEXT:    [[VLA_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[VLA_ADDR]] to ptr
// NO-LOOP-NEXT:    [[SUM_ADDR2_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM_ADDR2]] to ptr
// NO-LOOP-NEXT:    [[DOTADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR]] to ptr
// NO-LOOP-NEXT:    [[DOTADDR3_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR3]] to ptr
// NO-LOOP-NEXT:    [[DOTADDR4_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR4]] to ptr
// NO-LOOP-NEXT:    [[I_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[I]] to ptr
// NO-LOOP-NEXT:    [[DOTOMP_LB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_LB]] to ptr
// NO-LOOP-NEXT:    [[DOTOMP_UB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_UB]] to ptr
// NO-LOOP-NEXT:    [[DOTOMP_IV_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_IV]] to ptr
// NO-LOOP-NEXT:    [[SUM5_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM5]] to ptr
// NO-LOOP-NEXT:    store ptr [[DYN_PTR]], ptr [[DYN_PTR_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[B]], ptr [[B_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[SUM]], ptr [[SUM_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[A]], ptr [[A_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[SUM1]], ptr [[SUM_ADDR2_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR3_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[TMP2]], ptr [[DOTADDR4_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[SUM_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP4:%.*]] = load i64, ptr [[VLA_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[SUM_ADDR2_ASCAST]], align 8
// NO-LOOP-NEXT:    call void @__kmpc_specialized_kernel_init()
// NO-LOOP-NEXT:    [[TMP6:%.*]] = alloca i32, align 4, addrspace(5)
// NO-LOOP-NEXT:    store i32 0, ptr addrspace(5) [[TMP6]], align 4
// NO-LOOP-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// NO-LOOP-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// NO-LOOP-NEXT:    store i32 0, ptr [[DOTOMP_LB_ASCAST]], align 4
// NO-LOOP-NEXT:    store i32 25599, ptr [[DOTOMP_UB_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP7:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// NO-LOOP-NEXT:    store i32 [[TMP7]], ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP8:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// NO-LOOP-NEXT:    [[NVPTX_NUM_THREADS:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// NO-LOOP-NEXT:    [[GPU_BLOCK_ID:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// NO-LOOP-NEXT:    [[TMP9:%.*]] = mul i32 [[GPU_BLOCK_ID]], [[NVPTX_NUM_THREADS]]
// NO-LOOP-NEXT:    [[TMP10:%.*]] = add i32 [[TMP9]], [[TMP8]]
// NO-LOOP-NEXT:    [[TMP11:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP12:%.*]] = add i32 [[TMP10]], [[TMP11]]
// NO-LOOP-NEXT:    [[TMP13:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// NO-LOOP-NEXT:    [[TMP14:%.*]] = zext i32 [[TMP12]] to i64
// NO-LOOP-NEXT:    [[TOTAL_NUM_THREADS:%.*]] = mul i32 [[TMP13]], [[NVPTX_NUM_THREADS]]
// NO-LOOP-NEXT:    store i32 [[TMP12]], ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP15:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP15]], 1
// NO-LOOP-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// NO-LOOP-NEXT:    store i32 [[ADD]], ptr [[I_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP16:%.*]] = load ptr, ptr [[DOTADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP17:%.*]] = load ptr, ptr [[DOTADDR4_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP18:%.*]] = load ptr, ptr [[DOTADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP19:%.*]] = load ptr, ptr [[DOTADDR4_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP20:%.*]] = load i32, ptr addrspace(5) [[TMP6]], align 4
// NO-LOOP-NEXT:    call void @__kmpc_xteams_phase2_i_4x64(ptr [[TMP19]], i32 1, ptr [[TMP18]], ptr [[TMP19]], ptr @__kmpc_rfun_sum_i, i32 0, i64 [[TMP14]], i32 0)
// NO-LOOP-NEXT:    [[TMP21:%.*]] = add i32 [[TMP10]], [[TOTAL_NUM_THREADS]]
// NO-LOOP-NEXT:    [[TMP22:%.*]] = getelementptr i32, ptr [[TMP17]], i32 [[TMP21]]
// NO-LOOP-NEXT:    [[TMP23:%.*]] = load i32, ptr [[TMP22]], align 4
// NO-LOOP-NEXT:    store i32 [[TMP23]], ptr addrspace(5) [[TMP6]], align 4
// NO-LOOP-NEXT:    store i32 0, ptr [[SUM5_ASCAST]], align 4
// NO-LOOP-NEXT:    br label [[OMP_INSCAN_DISPATCH:%.*]]
// NO-LOOP:       omp.before.scan.bb:
// NO-LOOP-NEXT:    [[TMP24:%.*]] = load ptr, ptr [[B_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP25:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// NO-LOOP-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP25]] to i64
// NO-LOOP-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, ptr [[TMP24]], i64 [[IDXPROM]]
// NO-LOOP-NEXT:    [[TMP26:%.*]] = load i32, ptr addrspace(5) [[TMP6]], align 4
// NO-LOOP-NEXT:    store i32 [[TMP26]], ptr [[ARRAYIDX]], align 4
// NO-LOOP-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// NO-LOOP:       omp.exit.inscan.bb:
// NO-LOOP-NEXT:    br label [[OMP_BODY_CONTINUE]]
// NO-LOOP:       omp.inscan.dispatch:
// NO-LOOP-NEXT:    [[TMP27:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP28:%.*]] = zext i32 [[TMP27]] to i64
// NO-LOOP-NEXT:    [[TMP29:%.*]] = icmp eq i64 [[TMP28]], 0
// NO-LOOP-NEXT:    br i1 [[TMP29]], label [[OMP_EXCLUSIVE_COPY_EXIT:%.*]], label [[OMP_EXCLUSIVE_DEC:%.*]]
// NO-LOOP:       omp.exclusive.dec:
// NO-LOOP-NEXT:    [[TMP30:%.*]] = sub nuw i64 [[TMP28]], 1
// NO-LOOP-NEXT:    [[ARRAYIDX6:%.*]] = getelementptr inbounds nuw i32, ptr [[TMP5]], i64 [[TMP30]]
// NO-LOOP-NEXT:    [[TMP31:%.*]] = load i32, ptr addrspace(5) [[TMP6]], align 4
// NO-LOOP-NEXT:    store i32 [[TMP31]], ptr [[TMP3]], align 4
// NO-LOOP-NEXT:    br label [[OMP_EXCLUSIVE_COPY_EXIT]]
// NO-LOOP:       omp.exclusive.copy.exit:
// NO-LOOP-NEXT:    br label [[OMP_BEFORE_SCAN_BB:%.*]]
// NO-LOOP:       omp.after.scan.bb:
// NO-LOOP-NEXT:    [[TMP32:%.*]] = load ptr, ptr [[A_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP33:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// NO-LOOP-NEXT:    [[IDXPROM7:%.*]] = sext i32 [[TMP33]] to i64
// NO-LOOP-NEXT:    [[ARRAYIDX8:%.*]] = getelementptr inbounds i32, ptr [[TMP32]], i64 [[IDXPROM7]]
// NO-LOOP-NEXT:    [[TMP34:%.*]] = load i32, ptr [[ARRAYIDX8]], align 4
// NO-LOOP-NEXT:    [[TMP35:%.*]] = load i32, ptr addrspace(5) [[TMP6]], align 4
// NO-LOOP-NEXT:    [[TMP36:%.*]] = add i32 [[TMP35]], [[TMP34]]
// NO-LOOP-NEXT:    store i32 [[TMP36]], ptr addrspace(5) [[TMP6]], align 4
// NO-LOOP-NEXT:    br label [[OMP_EXIT_INSCAN_BB:%.*]]
// NO-LOOP:       omp.body.continue:
// NO-LOOP-NEXT:    ret void
//
//
// NO-LOOP-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z8run_testIjEvv_l33
// NO-LOOP-SAME: (ptr noalias noundef [[DYN_PTR:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM:%.*]], ptr noundef [[A:%.*]], ptr noundef [[B:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM1:%.*]], ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]], ptr noundef [[TMP2:%.*]]) #[[ATTR0]] {
// NO-LOOP-NEXT:  entry:
// NO-LOOP-NEXT:    [[DYN_PTR_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[SUM_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[A_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[B_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[SUM_ADDR2:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[DOTADDR3:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[DOTADDR4:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[I:%.*]] = alloca i32, align 4, addrspace(5)
// NO-LOOP-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4, addrspace(5)
// NO-LOOP-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4, addrspace(5)
// NO-LOOP-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4, addrspace(5)
// NO-LOOP-NEXT:    [[SUM5:%.*]] = alloca i32, align 4, addrspace(5)
// NO-LOOP-NEXT:    [[DYN_PTR_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DYN_PTR_ADDR]] to ptr
// NO-LOOP-NEXT:    [[SUM_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM_ADDR]] to ptr
// NO-LOOP-NEXT:    [[A_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[A_ADDR]] to ptr
// NO-LOOP-NEXT:    [[B_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[B_ADDR]] to ptr
// NO-LOOP-NEXT:    [[VLA_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[VLA_ADDR]] to ptr
// NO-LOOP-NEXT:    [[SUM_ADDR2_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM_ADDR2]] to ptr
// NO-LOOP-NEXT:    [[DOTADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR]] to ptr
// NO-LOOP-NEXT:    [[DOTADDR3_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR3]] to ptr
// NO-LOOP-NEXT:    [[DOTADDR4_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR4]] to ptr
// NO-LOOP-NEXT:    [[I_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[I]] to ptr
// NO-LOOP-NEXT:    [[DOTOMP_LB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_LB]] to ptr
// NO-LOOP-NEXT:    [[DOTOMP_UB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_UB]] to ptr
// NO-LOOP-NEXT:    [[DOTOMP_IV_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_IV]] to ptr
// NO-LOOP-NEXT:    [[SUM5_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM5]] to ptr
// NO-LOOP-NEXT:    store ptr [[DYN_PTR]], ptr [[DYN_PTR_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[SUM]], ptr [[SUM_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[A]], ptr [[A_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[B]], ptr [[B_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[SUM1]], ptr [[SUM_ADDR2_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR3_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[TMP2]], ptr [[DOTADDR4_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[SUM_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP4:%.*]] = load i64, ptr [[VLA_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[SUM_ADDR2_ASCAST]], align 8
// NO-LOOP-NEXT:    call void @__kmpc_specialized_kernel_init()
// NO-LOOP-NEXT:    [[TMP6:%.*]] = alloca i32, align 4, addrspace(5)
// NO-LOOP-NEXT:    store i32 0, ptr addrspace(5) [[TMP6]], align 4
// NO-LOOP-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// NO-LOOP-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// NO-LOOP-NEXT:    store i32 0, ptr [[DOTOMP_LB_ASCAST]], align 4
// NO-LOOP-NEXT:    store i32 25599, ptr [[DOTOMP_UB_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP7:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// NO-LOOP-NEXT:    store i32 [[TMP7]], ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP8:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// NO-LOOP-NEXT:    [[NVPTX_NUM_THREADS:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// NO-LOOP-NEXT:    [[GPU_BLOCK_ID:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// NO-LOOP-NEXT:    [[TMP9:%.*]] = mul i32 [[GPU_BLOCK_ID]], [[NVPTX_NUM_THREADS]]
// NO-LOOP-NEXT:    [[TMP10:%.*]] = add i32 [[TMP9]], [[TMP8]]
// NO-LOOP-NEXT:    [[TMP11:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP12:%.*]] = add i32 [[TMP10]], [[TMP11]]
// NO-LOOP-NEXT:    [[TMP13:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// NO-LOOP-NEXT:    [[TMP14:%.*]] = zext i32 [[TMP12]] to i64
// NO-LOOP-NEXT:    [[TOTAL_NUM_THREADS:%.*]] = mul i32 [[TMP13]], [[NVPTX_NUM_THREADS]]
// NO-LOOP-NEXT:    store i32 [[TMP12]], ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP15:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP15]], 1
// NO-LOOP-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// NO-LOOP-NEXT:    store i32 [[ADD]], ptr [[I_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP16:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP17:%.*]] = load i32, ptr [[DOTOMP_UB_ASCAST]], align 4
// NO-LOOP-NEXT:    [[CMP:%.*]] = icmp sle i32 [[TMP16]], [[TMP17]]
// NO-LOOP-NEXT:    br i1 [[CMP]], label [[OMP_KERNEL_BODY:%.*]], label [[OMP_KERNEL_DONE:%.*]]
// NO-LOOP:       omp.kernel.body:
// NO-LOOP-NEXT:    store i32 0, ptr [[SUM5_ASCAST]], align 4
// NO-LOOP-NEXT:    br label [[OMP_INSCAN_DISPATCH:%.*]]
// NO-LOOP:       omp.before.scan.bb:
// NO-LOOP-NEXT:    [[TMP18:%.*]] = load ptr, ptr [[A_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP19:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// NO-LOOP-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP19]] to i64
// NO-LOOP-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, ptr [[TMP18]], i64 [[IDXPROM]]
// NO-LOOP-NEXT:    [[TMP20:%.*]] = load i32, ptr [[ARRAYIDX]], align 4
// NO-LOOP-NEXT:    [[TMP21:%.*]] = load i32, ptr addrspace(5) [[TMP6]], align 4
// NO-LOOP-NEXT:    [[TMP22:%.*]] = add i32 [[TMP21]], [[TMP20]]
// NO-LOOP-NEXT:    store i32 [[TMP22]], ptr addrspace(5) [[TMP6]], align 4
// NO-LOOP-NEXT:    [[TMP23:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP24:%.*]] = zext i32 [[TMP23]] to i64
// NO-LOOP-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// NO-LOOP:       omp.exit.inscan.bb:
// NO-LOOP-NEXT:    br label [[OMP_BODY_CONTINUE]]
// NO-LOOP:       omp.inscan.dispatch:
// NO-LOOP-NEXT:    br label [[OMP_BEFORE_SCAN_BB:%.*]]
// NO-LOOP:       omp.after.scan.bb:
// NO-LOOP-NEXT:    [[TMP25:%.*]] = load i32, ptr [[TMP3]], align 4
// NO-LOOP-NEXT:    [[TMP26:%.*]] = load ptr, ptr [[B_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP27:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// NO-LOOP-NEXT:    [[IDXPROM6:%.*]] = sext i32 [[TMP27]] to i64
// NO-LOOP-NEXT:    [[ARRAYIDX7:%.*]] = getelementptr inbounds i32, ptr [[TMP26]], i64 [[IDXPROM6]]
// NO-LOOP-NEXT:    store i32 [[TMP25]], ptr [[ARRAYIDX7]], align 4
// NO-LOOP-NEXT:    br label [[OMP_EXIT_INSCAN_BB:%.*]]
// NO-LOOP:       omp.body.continue:
// NO-LOOP-NEXT:    [[TMP28:%.*]] = load ptr, ptr [[DOTADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP29:%.*]] = load ptr, ptr [[DOTADDR3_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP30:%.*]] = load ptr, ptr [[DOTADDR4_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP31:%.*]] = load i32, ptr addrspace(5) [[TMP6]], align 4
// NO-LOOP-NEXT:    call void @__kmpc_xteams_i_4x64(i32 [[TMP31]], ptr [[TMP30]], ptr [[TMP3]], ptr [[TMP28]], ptr [[TMP29]], ptr @__kmpc_rfun_sum_i, ptr @__kmpc_rfun_sum_lds_i, i32 0, i64 [[TMP14]], i32 [[TMP13]])
// NO-LOOP-NEXT:    br label [[OMP_KERNEL_DONE]]
// NO-LOOP:       omp.kernel.done:
// NO-LOOP-NEXT:    ret void
//
//
// NO-LOOP-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z8run_testIjEvv_l33_1
// NO-LOOP-SAME: (ptr noalias noundef [[DYN_PTR:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM:%.*]], ptr noundef [[A:%.*]], ptr noundef [[B:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM1:%.*]], ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]], ptr noundef [[TMP2:%.*]]) #[[ATTR0]] {
// NO-LOOP-NEXT:  entry:
// NO-LOOP-NEXT:    [[DYN_PTR_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[SUM_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[A_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[B_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[SUM_ADDR2:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[DOTADDR3:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[DOTADDR4:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[I:%.*]] = alloca i32, align 4, addrspace(5)
// NO-LOOP-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4, addrspace(5)
// NO-LOOP-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4, addrspace(5)
// NO-LOOP-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4, addrspace(5)
// NO-LOOP-NEXT:    [[SUM5:%.*]] = alloca i32, align 4, addrspace(5)
// NO-LOOP-NEXT:    [[DYN_PTR_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DYN_PTR_ADDR]] to ptr
// NO-LOOP-NEXT:    [[SUM_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM_ADDR]] to ptr
// NO-LOOP-NEXT:    [[A_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[A_ADDR]] to ptr
// NO-LOOP-NEXT:    [[B_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[B_ADDR]] to ptr
// NO-LOOP-NEXT:    [[VLA_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[VLA_ADDR]] to ptr
// NO-LOOP-NEXT:    [[SUM_ADDR2_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM_ADDR2]] to ptr
// NO-LOOP-NEXT:    [[DOTADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR]] to ptr
// NO-LOOP-NEXT:    [[DOTADDR3_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR3]] to ptr
// NO-LOOP-NEXT:    [[DOTADDR4_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR4]] to ptr
// NO-LOOP-NEXT:    [[I_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[I]] to ptr
// NO-LOOP-NEXT:    [[DOTOMP_LB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_LB]] to ptr
// NO-LOOP-NEXT:    [[DOTOMP_UB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_UB]] to ptr
// NO-LOOP-NEXT:    [[DOTOMP_IV_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_IV]] to ptr
// NO-LOOP-NEXT:    [[SUM5_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM5]] to ptr
// NO-LOOP-NEXT:    store ptr [[DYN_PTR]], ptr [[DYN_PTR_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[SUM]], ptr [[SUM_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[A]], ptr [[A_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[B]], ptr [[B_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[SUM1]], ptr [[SUM_ADDR2_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR3_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[TMP2]], ptr [[DOTADDR4_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[SUM_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP4:%.*]] = load i64, ptr [[VLA_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[SUM_ADDR2_ASCAST]], align 8
// NO-LOOP-NEXT:    call void @__kmpc_specialized_kernel_init()
// NO-LOOP-NEXT:    [[TMP6:%.*]] = alloca i32, align 4, addrspace(5)
// NO-LOOP-NEXT:    store i32 0, ptr addrspace(5) [[TMP6]], align 4
// NO-LOOP-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// NO-LOOP-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// NO-LOOP-NEXT:    store i32 0, ptr [[DOTOMP_LB_ASCAST]], align 4
// NO-LOOP-NEXT:    store i32 25599, ptr [[DOTOMP_UB_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP7:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// NO-LOOP-NEXT:    store i32 [[TMP7]], ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP8:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// NO-LOOP-NEXT:    [[NVPTX_NUM_THREADS:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// NO-LOOP-NEXT:    [[GPU_BLOCK_ID:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// NO-LOOP-NEXT:    [[TMP9:%.*]] = mul i32 [[GPU_BLOCK_ID]], [[NVPTX_NUM_THREADS]]
// NO-LOOP-NEXT:    [[TMP10:%.*]] = add i32 [[TMP9]], [[TMP8]]
// NO-LOOP-NEXT:    [[TMP11:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP12:%.*]] = add i32 [[TMP10]], [[TMP11]]
// NO-LOOP-NEXT:    [[TMP13:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// NO-LOOP-NEXT:    [[TMP14:%.*]] = zext i32 [[TMP12]] to i64
// NO-LOOP-NEXT:    [[TOTAL_NUM_THREADS:%.*]] = mul i32 [[TMP13]], [[NVPTX_NUM_THREADS]]
// NO-LOOP-NEXT:    store i32 [[TMP12]], ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP15:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP15]], 1
// NO-LOOP-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// NO-LOOP-NEXT:    store i32 [[ADD]], ptr [[I_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP16:%.*]] = load ptr, ptr [[DOTADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP17:%.*]] = load ptr, ptr [[DOTADDR4_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP18:%.*]] = load ptr, ptr [[DOTADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP19:%.*]] = load ptr, ptr [[DOTADDR4_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP20:%.*]] = load i32, ptr addrspace(5) [[TMP6]], align 4
// NO-LOOP-NEXT:    call void @__kmpc_xteams_phase2_i_4x64(ptr [[TMP19]], i32 1, ptr [[TMP18]], ptr [[TMP19]], ptr @__kmpc_rfun_sum_i, i32 0, i64 [[TMP14]], i32 1)
// NO-LOOP-NEXT:    [[TMP21:%.*]] = add i32 [[TMP10]], [[TOTAL_NUM_THREADS]]
// NO-LOOP-NEXT:    [[TMP22:%.*]] = getelementptr i32, ptr [[TMP17]], i32 [[TMP21]]
// NO-LOOP-NEXT:    [[TMP23:%.*]] = load i32, ptr [[TMP22]], align 4
// NO-LOOP-NEXT:    store i32 [[TMP23]], ptr addrspace(5) [[TMP6]], align 4
// NO-LOOP-NEXT:    store i32 0, ptr [[SUM5_ASCAST]], align 4
// NO-LOOP-NEXT:    br label [[OMP_INSCAN_DISPATCH:%.*]]
// NO-LOOP:       omp.before.scan.bb:
// NO-LOOP-NEXT:    [[TMP24:%.*]] = load ptr, ptr [[A_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP25:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// NO-LOOP-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP25]] to i64
// NO-LOOP-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, ptr [[TMP24]], i64 [[IDXPROM]]
// NO-LOOP-NEXT:    [[TMP26:%.*]] = load i32, ptr [[ARRAYIDX]], align 4
// NO-LOOP-NEXT:    [[TMP27:%.*]] = load i32, ptr addrspace(5) [[TMP6]], align 4
// NO-LOOP-NEXT:    [[TMP28:%.*]] = add i32 [[TMP27]], [[TMP26]]
// NO-LOOP-NEXT:    store i32 [[TMP28]], ptr addrspace(5) [[TMP6]], align 4
// NO-LOOP-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// NO-LOOP:       omp.exit.inscan.bb:
// NO-LOOP-NEXT:    br label [[OMP_BODY_CONTINUE]]
// NO-LOOP:       omp.inscan.dispatch:
// NO-LOOP-NEXT:    [[TMP29:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP30:%.*]] = zext i32 [[TMP29]] to i64
// NO-LOOP-NEXT:    [[ARRAYIDX6:%.*]] = getelementptr inbounds nuw i32, ptr [[TMP5]], i64 [[TMP30]]
// NO-LOOP-NEXT:    [[TMP31:%.*]] = load i32, ptr addrspace(5) [[TMP6]], align 4
// NO-LOOP-NEXT:    store i32 [[TMP31]], ptr [[TMP3]], align 4
// NO-LOOP-NEXT:    br label [[OMP_AFTER_SCAN_BB:%.*]]
// NO-LOOP:       omp.after.scan.bb:
// NO-LOOP-NEXT:    [[TMP32:%.*]] = load ptr, ptr [[B_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP33:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// NO-LOOP-NEXT:    [[IDXPROM7:%.*]] = sext i32 [[TMP33]] to i64
// NO-LOOP-NEXT:    [[ARRAYIDX8:%.*]] = getelementptr inbounds i32, ptr [[TMP32]], i64 [[IDXPROM7]]
// NO-LOOP-NEXT:    [[TMP34:%.*]] = load i32, ptr addrspace(5) [[TMP6]], align 4
// NO-LOOP-NEXT:    store i32 [[TMP34]], ptr [[ARRAYIDX8]], align 4
// NO-LOOP-NEXT:    br label [[OMP_EXIT_INSCAN_BB:%.*]]
// NO-LOOP:       omp.body.continue:
// NO-LOOP-NEXT:    ret void
//
//
// NO-LOOP-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z8run_testIjEvv_l45
// NO-LOOP-SAME: (ptr noalias noundef [[DYN_PTR:%.*]], ptr noundef [[B:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM:%.*]], ptr noundef [[A:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM1:%.*]], ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]], ptr noundef [[TMP2:%.*]]) #[[ATTR0]] {
// NO-LOOP-NEXT:  entry:
// NO-LOOP-NEXT:    [[DYN_PTR_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[B_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[SUM_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[A_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[SUM_ADDR2:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[DOTADDR3:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[DOTADDR4:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[I:%.*]] = alloca i32, align 4, addrspace(5)
// NO-LOOP-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4, addrspace(5)
// NO-LOOP-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4, addrspace(5)
// NO-LOOP-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4, addrspace(5)
// NO-LOOP-NEXT:    [[SUM5:%.*]] = alloca i32, align 4, addrspace(5)
// NO-LOOP-NEXT:    [[DYN_PTR_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DYN_PTR_ADDR]] to ptr
// NO-LOOP-NEXT:    [[B_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[B_ADDR]] to ptr
// NO-LOOP-NEXT:    [[SUM_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM_ADDR]] to ptr
// NO-LOOP-NEXT:    [[A_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[A_ADDR]] to ptr
// NO-LOOP-NEXT:    [[VLA_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[VLA_ADDR]] to ptr
// NO-LOOP-NEXT:    [[SUM_ADDR2_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM_ADDR2]] to ptr
// NO-LOOP-NEXT:    [[DOTADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR]] to ptr
// NO-LOOP-NEXT:    [[DOTADDR3_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR3]] to ptr
// NO-LOOP-NEXT:    [[DOTADDR4_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR4]] to ptr
// NO-LOOP-NEXT:    [[I_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[I]] to ptr
// NO-LOOP-NEXT:    [[DOTOMP_LB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_LB]] to ptr
// NO-LOOP-NEXT:    [[DOTOMP_UB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_UB]] to ptr
// NO-LOOP-NEXT:    [[DOTOMP_IV_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_IV]] to ptr
// NO-LOOP-NEXT:    [[SUM5_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM5]] to ptr
// NO-LOOP-NEXT:    store ptr [[DYN_PTR]], ptr [[DYN_PTR_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[B]], ptr [[B_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[SUM]], ptr [[SUM_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[A]], ptr [[A_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[SUM1]], ptr [[SUM_ADDR2_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR3_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[TMP2]], ptr [[DOTADDR4_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[SUM_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP4:%.*]] = load i64, ptr [[VLA_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[SUM_ADDR2_ASCAST]], align 8
// NO-LOOP-NEXT:    call void @__kmpc_specialized_kernel_init()
// NO-LOOP-NEXT:    [[TMP6:%.*]] = alloca i32, align 4, addrspace(5)
// NO-LOOP-NEXT:    store i32 0, ptr addrspace(5) [[TMP6]], align 4
// NO-LOOP-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// NO-LOOP-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// NO-LOOP-NEXT:    store i32 0, ptr [[DOTOMP_LB_ASCAST]], align 4
// NO-LOOP-NEXT:    store i32 25599, ptr [[DOTOMP_UB_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP7:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// NO-LOOP-NEXT:    store i32 [[TMP7]], ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP8:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// NO-LOOP-NEXT:    [[NVPTX_NUM_THREADS:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// NO-LOOP-NEXT:    [[GPU_BLOCK_ID:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// NO-LOOP-NEXT:    [[TMP9:%.*]] = mul i32 [[GPU_BLOCK_ID]], [[NVPTX_NUM_THREADS]]
// NO-LOOP-NEXT:    [[TMP10:%.*]] = add i32 [[TMP9]], [[TMP8]]
// NO-LOOP-NEXT:    [[TMP11:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP12:%.*]] = add i32 [[TMP10]], [[TMP11]]
// NO-LOOP-NEXT:    [[TMP13:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// NO-LOOP-NEXT:    [[TMP14:%.*]] = zext i32 [[TMP12]] to i64
// NO-LOOP-NEXT:    [[TOTAL_NUM_THREADS:%.*]] = mul i32 [[TMP13]], [[NVPTX_NUM_THREADS]]
// NO-LOOP-NEXT:    store i32 [[TMP12]], ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP15:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP15]], 1
// NO-LOOP-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// NO-LOOP-NEXT:    store i32 [[ADD]], ptr [[I_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP16:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP17:%.*]] = load i32, ptr [[DOTOMP_UB_ASCAST]], align 4
// NO-LOOP-NEXT:    [[CMP:%.*]] = icmp sle i32 [[TMP16]], [[TMP17]]
// NO-LOOP-NEXT:    br i1 [[CMP]], label [[OMP_KERNEL_BODY:%.*]], label [[OMP_KERNEL_DONE:%.*]]
// NO-LOOP:       omp.kernel.body:
// NO-LOOP-NEXT:    store i32 0, ptr [[SUM5_ASCAST]], align 4
// NO-LOOP-NEXT:    br label [[OMP_INSCAN_DISPATCH:%.*]]
// NO-LOOP:       omp.before.scan.bb:
// NO-LOOP-NEXT:    [[TMP18:%.*]] = load i32, ptr [[TMP3]], align 4
// NO-LOOP-NEXT:    [[TMP19:%.*]] = load ptr, ptr [[B_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP20:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// NO-LOOP-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP20]] to i64
// NO-LOOP-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, ptr [[TMP19]], i64 [[IDXPROM]]
// NO-LOOP-NEXT:    store i32 [[TMP18]], ptr [[ARRAYIDX]], align 4
// NO-LOOP-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// NO-LOOP:       omp.exit.inscan.bb:
// NO-LOOP-NEXT:    [[TMP21:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP22:%.*]] = zext i32 [[TMP21]] to i64
// NO-LOOP-NEXT:    br label [[OMP_BODY_CONTINUE]]
// NO-LOOP:       omp.inscan.dispatch:
// NO-LOOP-NEXT:    br label [[OMP_AFTER_SCAN_BB:%.*]]
// NO-LOOP:       omp.after.scan.bb:
// NO-LOOP-NEXT:    [[TMP23:%.*]] = load ptr, ptr [[A_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP24:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// NO-LOOP-NEXT:    [[IDXPROM6:%.*]] = sext i32 [[TMP24]] to i64
// NO-LOOP-NEXT:    [[ARRAYIDX7:%.*]] = getelementptr inbounds i32, ptr [[TMP23]], i64 [[IDXPROM6]]
// NO-LOOP-NEXT:    [[TMP25:%.*]] = load i32, ptr [[ARRAYIDX7]], align 4
// NO-LOOP-NEXT:    [[TMP26:%.*]] = load i32, ptr addrspace(5) [[TMP6]], align 4
// NO-LOOP-NEXT:    [[TMP27:%.*]] = add i32 [[TMP26]], [[TMP25]]
// NO-LOOP-NEXT:    store i32 [[TMP27]], ptr addrspace(5) [[TMP6]], align 4
// NO-LOOP-NEXT:    br label [[OMP_EXIT_INSCAN_BB:%.*]]
// NO-LOOP:       omp.body.continue:
// NO-LOOP-NEXT:    [[TMP28:%.*]] = load ptr, ptr [[DOTADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP29:%.*]] = load ptr, ptr [[DOTADDR3_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP30:%.*]] = load ptr, ptr [[DOTADDR4_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP31:%.*]] = load i32, ptr addrspace(5) [[TMP6]], align 4
// NO-LOOP-NEXT:    call void @__kmpc_xteams_i_4x64(i32 [[TMP31]], ptr [[TMP30]], ptr [[TMP3]], ptr [[TMP28]], ptr [[TMP29]], ptr @__kmpc_rfun_sum_i, ptr @__kmpc_rfun_sum_lds_i, i32 0, i64 [[TMP14]], i32 [[TMP13]])
// NO-LOOP-NEXT:    br label [[OMP_KERNEL_DONE]]
// NO-LOOP:       omp.kernel.done:
// NO-LOOP-NEXT:    ret void
//
//
// NO-LOOP-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z8run_testIjEvv_l45_1
// NO-LOOP-SAME: (ptr noalias noundef [[DYN_PTR:%.*]], ptr noundef [[B:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM:%.*]], ptr noundef [[A:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM1:%.*]], ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]], ptr noundef [[TMP2:%.*]]) #[[ATTR0]] {
// NO-LOOP-NEXT:  entry:
// NO-LOOP-NEXT:    [[DYN_PTR_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[B_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[SUM_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[A_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[SUM_ADDR2:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[DOTADDR3:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[DOTADDR4:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[I:%.*]] = alloca i32, align 4, addrspace(5)
// NO-LOOP-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4, addrspace(5)
// NO-LOOP-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4, addrspace(5)
// NO-LOOP-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4, addrspace(5)
// NO-LOOP-NEXT:    [[SUM5:%.*]] = alloca i32, align 4, addrspace(5)
// NO-LOOP-NEXT:    [[DYN_PTR_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DYN_PTR_ADDR]] to ptr
// NO-LOOP-NEXT:    [[B_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[B_ADDR]] to ptr
// NO-LOOP-NEXT:    [[SUM_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM_ADDR]] to ptr
// NO-LOOP-NEXT:    [[A_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[A_ADDR]] to ptr
// NO-LOOP-NEXT:    [[VLA_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[VLA_ADDR]] to ptr
// NO-LOOP-NEXT:    [[SUM_ADDR2_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM_ADDR2]] to ptr
// NO-LOOP-NEXT:    [[DOTADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR]] to ptr
// NO-LOOP-NEXT:    [[DOTADDR3_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR3]] to ptr
// NO-LOOP-NEXT:    [[DOTADDR4_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR4]] to ptr
// NO-LOOP-NEXT:    [[I_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[I]] to ptr
// NO-LOOP-NEXT:    [[DOTOMP_LB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_LB]] to ptr
// NO-LOOP-NEXT:    [[DOTOMP_UB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_UB]] to ptr
// NO-LOOP-NEXT:    [[DOTOMP_IV_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_IV]] to ptr
// NO-LOOP-NEXT:    [[SUM5_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM5]] to ptr
// NO-LOOP-NEXT:    store ptr [[DYN_PTR]], ptr [[DYN_PTR_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[B]], ptr [[B_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[SUM]], ptr [[SUM_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[A]], ptr [[A_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[SUM1]], ptr [[SUM_ADDR2_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR3_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[TMP2]], ptr [[DOTADDR4_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[SUM_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP4:%.*]] = load i64, ptr [[VLA_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[SUM_ADDR2_ASCAST]], align 8
// NO-LOOP-NEXT:    call void @__kmpc_specialized_kernel_init()
// NO-LOOP-NEXT:    [[TMP6:%.*]] = alloca i32, align 4, addrspace(5)
// NO-LOOP-NEXT:    store i32 0, ptr addrspace(5) [[TMP6]], align 4
// NO-LOOP-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// NO-LOOP-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// NO-LOOP-NEXT:    store i32 0, ptr [[DOTOMP_LB_ASCAST]], align 4
// NO-LOOP-NEXT:    store i32 25599, ptr [[DOTOMP_UB_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP7:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// NO-LOOP-NEXT:    store i32 [[TMP7]], ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP8:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// NO-LOOP-NEXT:    [[NVPTX_NUM_THREADS:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// NO-LOOP-NEXT:    [[GPU_BLOCK_ID:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// NO-LOOP-NEXT:    [[TMP9:%.*]] = mul i32 [[GPU_BLOCK_ID]], [[NVPTX_NUM_THREADS]]
// NO-LOOP-NEXT:    [[TMP10:%.*]] = add i32 [[TMP9]], [[TMP8]]
// NO-LOOP-NEXT:    [[TMP11:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP12:%.*]] = add i32 [[TMP10]], [[TMP11]]
// NO-LOOP-NEXT:    [[TMP13:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// NO-LOOP-NEXT:    [[TMP14:%.*]] = zext i32 [[TMP12]] to i64
// NO-LOOP-NEXT:    [[TOTAL_NUM_THREADS:%.*]] = mul i32 [[TMP13]], [[NVPTX_NUM_THREADS]]
// NO-LOOP-NEXT:    store i32 [[TMP12]], ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP15:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP15]], 1
// NO-LOOP-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// NO-LOOP-NEXT:    store i32 [[ADD]], ptr [[I_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP16:%.*]] = load ptr, ptr [[DOTADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP17:%.*]] = load ptr, ptr [[DOTADDR4_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP18:%.*]] = load ptr, ptr [[DOTADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP19:%.*]] = load ptr, ptr [[DOTADDR4_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP20:%.*]] = load i32, ptr addrspace(5) [[TMP6]], align 4
// NO-LOOP-NEXT:    call void @__kmpc_xteams_phase2_i_4x64(ptr [[TMP19]], i32 1, ptr [[TMP18]], ptr [[TMP19]], ptr @__kmpc_rfun_sum_i, i32 0, i64 [[TMP14]], i32 0)
// NO-LOOP-NEXT:    [[TMP21:%.*]] = add i32 [[TMP10]], [[TOTAL_NUM_THREADS]]
// NO-LOOP-NEXT:    [[TMP22:%.*]] = getelementptr i32, ptr [[TMP17]], i32 [[TMP21]]
// NO-LOOP-NEXT:    [[TMP23:%.*]] = load i32, ptr [[TMP22]], align 4
// NO-LOOP-NEXT:    store i32 [[TMP23]], ptr addrspace(5) [[TMP6]], align 4
// NO-LOOP-NEXT:    store i32 0, ptr [[SUM5_ASCAST]], align 4
// NO-LOOP-NEXT:    br label [[OMP_INSCAN_DISPATCH:%.*]]
// NO-LOOP:       omp.before.scan.bb:
// NO-LOOP-NEXT:    [[TMP24:%.*]] = load ptr, ptr [[B_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP25:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// NO-LOOP-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP25]] to i64
// NO-LOOP-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, ptr [[TMP24]], i64 [[IDXPROM]]
// NO-LOOP-NEXT:    [[TMP26:%.*]] = load i32, ptr addrspace(5) [[TMP6]], align 4
// NO-LOOP-NEXT:    store i32 [[TMP26]], ptr [[ARRAYIDX]], align 4
// NO-LOOP-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// NO-LOOP:       omp.exit.inscan.bb:
// NO-LOOP-NEXT:    br label [[OMP_BODY_CONTINUE]]
// NO-LOOP:       omp.inscan.dispatch:
// NO-LOOP-NEXT:    [[TMP27:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP28:%.*]] = zext i32 [[TMP27]] to i64
// NO-LOOP-NEXT:    [[TMP29:%.*]] = icmp eq i64 [[TMP28]], 0
// NO-LOOP-NEXT:    br i1 [[TMP29]], label [[OMP_EXCLUSIVE_COPY_EXIT:%.*]], label [[OMP_EXCLUSIVE_DEC:%.*]]
// NO-LOOP:       omp.exclusive.dec:
// NO-LOOP-NEXT:    [[TMP30:%.*]] = sub nuw i64 [[TMP28]], 1
// NO-LOOP-NEXT:    [[ARRAYIDX6:%.*]] = getelementptr inbounds nuw i32, ptr [[TMP5]], i64 [[TMP30]]
// NO-LOOP-NEXT:    [[TMP31:%.*]] = load i32, ptr addrspace(5) [[TMP6]], align 4
// NO-LOOP-NEXT:    store i32 [[TMP31]], ptr [[TMP3]], align 4
// NO-LOOP-NEXT:    br label [[OMP_EXCLUSIVE_COPY_EXIT]]
// NO-LOOP:       omp.exclusive.copy.exit:
// NO-LOOP-NEXT:    br label [[OMP_BEFORE_SCAN_BB:%.*]]
// NO-LOOP:       omp.after.scan.bb:
// NO-LOOP-NEXT:    [[TMP32:%.*]] = load ptr, ptr [[A_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP33:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// NO-LOOP-NEXT:    [[IDXPROM7:%.*]] = sext i32 [[TMP33]] to i64
// NO-LOOP-NEXT:    [[ARRAYIDX8:%.*]] = getelementptr inbounds i32, ptr [[TMP32]], i64 [[IDXPROM7]]
// NO-LOOP-NEXT:    [[TMP34:%.*]] = load i32, ptr [[ARRAYIDX8]], align 4
// NO-LOOP-NEXT:    [[TMP35:%.*]] = load i32, ptr addrspace(5) [[TMP6]], align 4
// NO-LOOP-NEXT:    [[TMP36:%.*]] = add i32 [[TMP35]], [[TMP34]]
// NO-LOOP-NEXT:    store i32 [[TMP36]], ptr addrspace(5) [[TMP6]], align 4
// NO-LOOP-NEXT:    br label [[OMP_EXIT_INSCAN_BB:%.*]]
// NO-LOOP:       omp.body.continue:
// NO-LOOP-NEXT:    ret void
//
//
// NO-LOOP-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z8run_testIlEvv_l33
// NO-LOOP-SAME: (ptr noalias noundef [[DYN_PTR:%.*]], ptr noundef nonnull align 8 dereferenceable(8) [[SUM:%.*]], ptr noundef [[A:%.*]], ptr noundef [[B:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 8 dereferenceable(8) [[SUM1:%.*]], ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]], ptr noundef [[TMP2:%.*]]) #[[ATTR0]] {
// NO-LOOP-NEXT:  entry:
// NO-LOOP-NEXT:    [[DYN_PTR_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[SUM_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[A_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[B_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[SUM_ADDR2:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[DOTADDR3:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[DOTADDR4:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[I:%.*]] = alloca i32, align 4, addrspace(5)
// NO-LOOP-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4, addrspace(5)
// NO-LOOP-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4, addrspace(5)
// NO-LOOP-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4, addrspace(5)
// NO-LOOP-NEXT:    [[SUM5:%.*]] = alloca i64, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[DYN_PTR_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DYN_PTR_ADDR]] to ptr
// NO-LOOP-NEXT:    [[SUM_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM_ADDR]] to ptr
// NO-LOOP-NEXT:    [[A_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[A_ADDR]] to ptr
// NO-LOOP-NEXT:    [[B_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[B_ADDR]] to ptr
// NO-LOOP-NEXT:    [[VLA_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[VLA_ADDR]] to ptr
// NO-LOOP-NEXT:    [[SUM_ADDR2_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM_ADDR2]] to ptr
// NO-LOOP-NEXT:    [[DOTADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR]] to ptr
// NO-LOOP-NEXT:    [[DOTADDR3_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR3]] to ptr
// NO-LOOP-NEXT:    [[DOTADDR4_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR4]] to ptr
// NO-LOOP-NEXT:    [[I_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[I]] to ptr
// NO-LOOP-NEXT:    [[DOTOMP_LB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_LB]] to ptr
// NO-LOOP-NEXT:    [[DOTOMP_UB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_UB]] to ptr
// NO-LOOP-NEXT:    [[DOTOMP_IV_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_IV]] to ptr
// NO-LOOP-NEXT:    [[SUM5_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM5]] to ptr
// NO-LOOP-NEXT:    store ptr [[DYN_PTR]], ptr [[DYN_PTR_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[SUM]], ptr [[SUM_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[A]], ptr [[A_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[B]], ptr [[B_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[SUM1]], ptr [[SUM_ADDR2_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR3_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[TMP2]], ptr [[DOTADDR4_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[SUM_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP4:%.*]] = load i64, ptr [[VLA_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[SUM_ADDR2_ASCAST]], align 8
// NO-LOOP-NEXT:    call void @__kmpc_specialized_kernel_init()
// NO-LOOP-NEXT:    [[TMP6:%.*]] = alloca i64, align 8, addrspace(5)
// NO-LOOP-NEXT:    store i64 0, ptr addrspace(5) [[TMP6]], align 8
// NO-LOOP-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// NO-LOOP-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// NO-LOOP-NEXT:    store i32 0, ptr [[DOTOMP_LB_ASCAST]], align 4
// NO-LOOP-NEXT:    store i32 25599, ptr [[DOTOMP_UB_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP7:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// NO-LOOP-NEXT:    store i32 [[TMP7]], ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP8:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// NO-LOOP-NEXT:    [[NVPTX_NUM_THREADS:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// NO-LOOP-NEXT:    [[GPU_BLOCK_ID:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// NO-LOOP-NEXT:    [[TMP9:%.*]] = mul i32 [[GPU_BLOCK_ID]], [[NVPTX_NUM_THREADS]]
// NO-LOOP-NEXT:    [[TMP10:%.*]] = add i32 [[TMP9]], [[TMP8]]
// NO-LOOP-NEXT:    [[TMP11:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP12:%.*]] = add i32 [[TMP10]], [[TMP11]]
// NO-LOOP-NEXT:    [[TMP13:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// NO-LOOP-NEXT:    [[TMP14:%.*]] = zext i32 [[TMP12]] to i64
// NO-LOOP-NEXT:    [[TOTAL_NUM_THREADS:%.*]] = mul i32 [[TMP13]], [[NVPTX_NUM_THREADS]]
// NO-LOOP-NEXT:    store i32 [[TMP12]], ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP15:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP15]], 1
// NO-LOOP-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// NO-LOOP-NEXT:    store i32 [[ADD]], ptr [[I_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP16:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP17:%.*]] = load i32, ptr [[DOTOMP_UB_ASCAST]], align 4
// NO-LOOP-NEXT:    [[CMP:%.*]] = icmp sle i32 [[TMP16]], [[TMP17]]
// NO-LOOP-NEXT:    br i1 [[CMP]], label [[OMP_KERNEL_BODY:%.*]], label [[OMP_KERNEL_DONE:%.*]]
// NO-LOOP:       omp.kernel.body:
// NO-LOOP-NEXT:    store i64 0, ptr [[SUM5_ASCAST]], align 8
// NO-LOOP-NEXT:    br label [[OMP_INSCAN_DISPATCH:%.*]]
// NO-LOOP:       omp.before.scan.bb:
// NO-LOOP-NEXT:    [[TMP18:%.*]] = load ptr, ptr [[A_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP19:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// NO-LOOP-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP19]] to i64
// NO-LOOP-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i64, ptr [[TMP18]], i64 [[IDXPROM]]
// NO-LOOP-NEXT:    [[TMP20:%.*]] = load i64, ptr [[ARRAYIDX]], align 8
// NO-LOOP-NEXT:    [[TMP21:%.*]] = load i64, ptr addrspace(5) [[TMP6]], align 8
// NO-LOOP-NEXT:    [[TMP22:%.*]] = add i64 [[TMP21]], [[TMP20]]
// NO-LOOP-NEXT:    store i64 [[TMP22]], ptr addrspace(5) [[TMP6]], align 8
// NO-LOOP-NEXT:    [[TMP23:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP24:%.*]] = zext i32 [[TMP23]] to i64
// NO-LOOP-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// NO-LOOP:       omp.exit.inscan.bb:
// NO-LOOP-NEXT:    br label [[OMP_BODY_CONTINUE]]
// NO-LOOP:       omp.inscan.dispatch:
// NO-LOOP-NEXT:    br label [[OMP_BEFORE_SCAN_BB:%.*]]
// NO-LOOP:       omp.after.scan.bb:
// NO-LOOP-NEXT:    [[TMP25:%.*]] = load i64, ptr [[TMP3]], align 8
// NO-LOOP-NEXT:    [[TMP26:%.*]] = load ptr, ptr [[B_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP27:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// NO-LOOP-NEXT:    [[IDXPROM6:%.*]] = sext i32 [[TMP27]] to i64
// NO-LOOP-NEXT:    [[ARRAYIDX7:%.*]] = getelementptr inbounds i64, ptr [[TMP26]], i64 [[IDXPROM6]]
// NO-LOOP-NEXT:    store i64 [[TMP25]], ptr [[ARRAYIDX7]], align 8
// NO-LOOP-NEXT:    br label [[OMP_EXIT_INSCAN_BB:%.*]]
// NO-LOOP:       omp.body.continue:
// NO-LOOP-NEXT:    [[TMP28:%.*]] = load ptr, ptr [[DOTADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP29:%.*]] = load ptr, ptr [[DOTADDR3_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP30:%.*]] = load ptr, ptr [[DOTADDR4_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP31:%.*]] = load i64, ptr addrspace(5) [[TMP6]], align 8
// NO-LOOP-NEXT:    call void @__kmpc_xteams_l_4x64(i64 [[TMP31]], ptr [[TMP30]], ptr [[TMP3]], ptr [[TMP28]], ptr [[TMP29]], ptr @__kmpc_rfun_sum_l, ptr @__kmpc_rfun_sum_lds_l, i64 0, i64 [[TMP14]], i32 [[TMP13]])
// NO-LOOP-NEXT:    br label [[OMP_KERNEL_DONE]]
// NO-LOOP:       omp.kernel.done:
// NO-LOOP-NEXT:    ret void
//
//
// NO-LOOP-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z8run_testIlEvv_l33_1
// NO-LOOP-SAME: (ptr noalias noundef [[DYN_PTR:%.*]], ptr noundef nonnull align 8 dereferenceable(8) [[SUM:%.*]], ptr noundef [[A:%.*]], ptr noundef [[B:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 8 dereferenceable(8) [[SUM1:%.*]], ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]], ptr noundef [[TMP2:%.*]]) #[[ATTR0]] {
// NO-LOOP-NEXT:  entry:
// NO-LOOP-NEXT:    [[DYN_PTR_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[SUM_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[A_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[B_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[SUM_ADDR2:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[DOTADDR3:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[DOTADDR4:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[I:%.*]] = alloca i32, align 4, addrspace(5)
// NO-LOOP-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4, addrspace(5)
// NO-LOOP-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4, addrspace(5)
// NO-LOOP-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4, addrspace(5)
// NO-LOOP-NEXT:    [[SUM5:%.*]] = alloca i64, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[DYN_PTR_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DYN_PTR_ADDR]] to ptr
// NO-LOOP-NEXT:    [[SUM_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM_ADDR]] to ptr
// NO-LOOP-NEXT:    [[A_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[A_ADDR]] to ptr
// NO-LOOP-NEXT:    [[B_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[B_ADDR]] to ptr
// NO-LOOP-NEXT:    [[VLA_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[VLA_ADDR]] to ptr
// NO-LOOP-NEXT:    [[SUM_ADDR2_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM_ADDR2]] to ptr
// NO-LOOP-NEXT:    [[DOTADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR]] to ptr
// NO-LOOP-NEXT:    [[DOTADDR3_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR3]] to ptr
// NO-LOOP-NEXT:    [[DOTADDR4_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR4]] to ptr
// NO-LOOP-NEXT:    [[I_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[I]] to ptr
// NO-LOOP-NEXT:    [[DOTOMP_LB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_LB]] to ptr
// NO-LOOP-NEXT:    [[DOTOMP_UB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_UB]] to ptr
// NO-LOOP-NEXT:    [[DOTOMP_IV_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_IV]] to ptr
// NO-LOOP-NEXT:    [[SUM5_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM5]] to ptr
// NO-LOOP-NEXT:    store ptr [[DYN_PTR]], ptr [[DYN_PTR_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[SUM]], ptr [[SUM_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[A]], ptr [[A_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[B]], ptr [[B_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[SUM1]], ptr [[SUM_ADDR2_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR3_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[TMP2]], ptr [[DOTADDR4_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[SUM_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP4:%.*]] = load i64, ptr [[VLA_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[SUM_ADDR2_ASCAST]], align 8
// NO-LOOP-NEXT:    call void @__kmpc_specialized_kernel_init()
// NO-LOOP-NEXT:    [[TMP6:%.*]] = alloca i64, align 8, addrspace(5)
// NO-LOOP-NEXT:    store i64 0, ptr addrspace(5) [[TMP6]], align 8
// NO-LOOP-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// NO-LOOP-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// NO-LOOP-NEXT:    store i32 0, ptr [[DOTOMP_LB_ASCAST]], align 4
// NO-LOOP-NEXT:    store i32 25599, ptr [[DOTOMP_UB_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP7:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// NO-LOOP-NEXT:    store i32 [[TMP7]], ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP8:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// NO-LOOP-NEXT:    [[NVPTX_NUM_THREADS:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// NO-LOOP-NEXT:    [[GPU_BLOCK_ID:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// NO-LOOP-NEXT:    [[TMP9:%.*]] = mul i32 [[GPU_BLOCK_ID]], [[NVPTX_NUM_THREADS]]
// NO-LOOP-NEXT:    [[TMP10:%.*]] = add i32 [[TMP9]], [[TMP8]]
// NO-LOOP-NEXT:    [[TMP11:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP12:%.*]] = add i32 [[TMP10]], [[TMP11]]
// NO-LOOP-NEXT:    [[TMP13:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// NO-LOOP-NEXT:    [[TMP14:%.*]] = zext i32 [[TMP12]] to i64
// NO-LOOP-NEXT:    [[TOTAL_NUM_THREADS:%.*]] = mul i32 [[TMP13]], [[NVPTX_NUM_THREADS]]
// NO-LOOP-NEXT:    store i32 [[TMP12]], ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP15:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP15]], 1
// NO-LOOP-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// NO-LOOP-NEXT:    store i32 [[ADD]], ptr [[I_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP16:%.*]] = load ptr, ptr [[DOTADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP17:%.*]] = load ptr, ptr [[DOTADDR4_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP18:%.*]] = load ptr, ptr [[DOTADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP19:%.*]] = load ptr, ptr [[DOTADDR4_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP20:%.*]] = load i64, ptr addrspace(5) [[TMP6]], align 8
// NO-LOOP-NEXT:    call void @__kmpc_xteams_phase2_l_4x64(ptr [[TMP19]], i32 1, ptr [[TMP18]], ptr [[TMP19]], ptr @__kmpc_rfun_sum_l, i64 0, i64 [[TMP14]], i32 1)
// NO-LOOP-NEXT:    [[TMP21:%.*]] = add i32 [[TMP10]], [[TOTAL_NUM_THREADS]]
// NO-LOOP-NEXT:    [[TMP22:%.*]] = getelementptr i64, ptr [[TMP17]], i32 [[TMP21]]
// NO-LOOP-NEXT:    [[TMP23:%.*]] = load i64, ptr [[TMP22]], align 8
// NO-LOOP-NEXT:    store i64 [[TMP23]], ptr addrspace(5) [[TMP6]], align 8
// NO-LOOP-NEXT:    store i64 0, ptr [[SUM5_ASCAST]], align 8
// NO-LOOP-NEXT:    br label [[OMP_INSCAN_DISPATCH:%.*]]
// NO-LOOP:       omp.before.scan.bb:
// NO-LOOP-NEXT:    [[TMP24:%.*]] = load ptr, ptr [[A_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP25:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// NO-LOOP-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP25]] to i64
// NO-LOOP-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i64, ptr [[TMP24]], i64 [[IDXPROM]]
// NO-LOOP-NEXT:    [[TMP26:%.*]] = load i64, ptr [[ARRAYIDX]], align 8
// NO-LOOP-NEXT:    [[TMP27:%.*]] = load i64, ptr addrspace(5) [[TMP6]], align 8
// NO-LOOP-NEXT:    [[TMP28:%.*]] = add i64 [[TMP27]], [[TMP26]]
// NO-LOOP-NEXT:    store i64 [[TMP28]], ptr addrspace(5) [[TMP6]], align 8
// NO-LOOP-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// NO-LOOP:       omp.exit.inscan.bb:
// NO-LOOP-NEXT:    br label [[OMP_BODY_CONTINUE]]
// NO-LOOP:       omp.inscan.dispatch:
// NO-LOOP-NEXT:    [[TMP29:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP30:%.*]] = zext i32 [[TMP29]] to i64
// NO-LOOP-NEXT:    [[ARRAYIDX6:%.*]] = getelementptr inbounds nuw i64, ptr [[TMP5]], i64 [[TMP30]]
// NO-LOOP-NEXT:    [[TMP31:%.*]] = load i64, ptr addrspace(5) [[TMP6]], align 8
// NO-LOOP-NEXT:    store i64 [[TMP31]], ptr [[TMP3]], align 8
// NO-LOOP-NEXT:    br label [[OMP_AFTER_SCAN_BB:%.*]]
// NO-LOOP:       omp.after.scan.bb:
// NO-LOOP-NEXT:    [[TMP32:%.*]] = load ptr, ptr [[B_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP33:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// NO-LOOP-NEXT:    [[IDXPROM7:%.*]] = sext i32 [[TMP33]] to i64
// NO-LOOP-NEXT:    [[ARRAYIDX8:%.*]] = getelementptr inbounds i64, ptr [[TMP32]], i64 [[IDXPROM7]]
// NO-LOOP-NEXT:    [[TMP34:%.*]] = load i64, ptr addrspace(5) [[TMP6]], align 8
// NO-LOOP-NEXT:    store i64 [[TMP34]], ptr [[ARRAYIDX8]], align 8
// NO-LOOP-NEXT:    br label [[OMP_EXIT_INSCAN_BB:%.*]]
// NO-LOOP:       omp.body.continue:
// NO-LOOP-NEXT:    ret void
//
//
// NO-LOOP-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z8run_testIlEvv_l45
// NO-LOOP-SAME: (ptr noalias noundef [[DYN_PTR:%.*]], ptr noundef [[B:%.*]], ptr noundef nonnull align 8 dereferenceable(8) [[SUM:%.*]], ptr noundef [[A:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 8 dereferenceable(8) [[SUM1:%.*]], ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]], ptr noundef [[TMP2:%.*]]) #[[ATTR0]] {
// NO-LOOP-NEXT:  entry:
// NO-LOOP-NEXT:    [[DYN_PTR_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[B_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[SUM_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[A_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[SUM_ADDR2:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[DOTADDR3:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[DOTADDR4:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[I:%.*]] = alloca i32, align 4, addrspace(5)
// NO-LOOP-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4, addrspace(5)
// NO-LOOP-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4, addrspace(5)
// NO-LOOP-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4, addrspace(5)
// NO-LOOP-NEXT:    [[SUM5:%.*]] = alloca i64, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[DYN_PTR_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DYN_PTR_ADDR]] to ptr
// NO-LOOP-NEXT:    [[B_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[B_ADDR]] to ptr
// NO-LOOP-NEXT:    [[SUM_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM_ADDR]] to ptr
// NO-LOOP-NEXT:    [[A_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[A_ADDR]] to ptr
// NO-LOOP-NEXT:    [[VLA_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[VLA_ADDR]] to ptr
// NO-LOOP-NEXT:    [[SUM_ADDR2_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM_ADDR2]] to ptr
// NO-LOOP-NEXT:    [[DOTADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR]] to ptr
// NO-LOOP-NEXT:    [[DOTADDR3_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR3]] to ptr
// NO-LOOP-NEXT:    [[DOTADDR4_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR4]] to ptr
// NO-LOOP-NEXT:    [[I_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[I]] to ptr
// NO-LOOP-NEXT:    [[DOTOMP_LB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_LB]] to ptr
// NO-LOOP-NEXT:    [[DOTOMP_UB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_UB]] to ptr
// NO-LOOP-NEXT:    [[DOTOMP_IV_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_IV]] to ptr
// NO-LOOP-NEXT:    [[SUM5_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM5]] to ptr
// NO-LOOP-NEXT:    store ptr [[DYN_PTR]], ptr [[DYN_PTR_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[B]], ptr [[B_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[SUM]], ptr [[SUM_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[A]], ptr [[A_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[SUM1]], ptr [[SUM_ADDR2_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR3_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[TMP2]], ptr [[DOTADDR4_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[SUM_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP4:%.*]] = load i64, ptr [[VLA_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[SUM_ADDR2_ASCAST]], align 8
// NO-LOOP-NEXT:    call void @__kmpc_specialized_kernel_init()
// NO-LOOP-NEXT:    [[TMP6:%.*]] = alloca i64, align 8, addrspace(5)
// NO-LOOP-NEXT:    store i64 0, ptr addrspace(5) [[TMP6]], align 8
// NO-LOOP-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// NO-LOOP-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// NO-LOOP-NEXT:    store i32 0, ptr [[DOTOMP_LB_ASCAST]], align 4
// NO-LOOP-NEXT:    store i32 25599, ptr [[DOTOMP_UB_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP7:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// NO-LOOP-NEXT:    store i32 [[TMP7]], ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP8:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// NO-LOOP-NEXT:    [[NVPTX_NUM_THREADS:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// NO-LOOP-NEXT:    [[GPU_BLOCK_ID:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// NO-LOOP-NEXT:    [[TMP9:%.*]] = mul i32 [[GPU_BLOCK_ID]], [[NVPTX_NUM_THREADS]]
// NO-LOOP-NEXT:    [[TMP10:%.*]] = add i32 [[TMP9]], [[TMP8]]
// NO-LOOP-NEXT:    [[TMP11:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP12:%.*]] = add i32 [[TMP10]], [[TMP11]]
// NO-LOOP-NEXT:    [[TMP13:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// NO-LOOP-NEXT:    [[TMP14:%.*]] = zext i32 [[TMP12]] to i64
// NO-LOOP-NEXT:    [[TOTAL_NUM_THREADS:%.*]] = mul i32 [[TMP13]], [[NVPTX_NUM_THREADS]]
// NO-LOOP-NEXT:    store i32 [[TMP12]], ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP15:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP15]], 1
// NO-LOOP-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// NO-LOOP-NEXT:    store i32 [[ADD]], ptr [[I_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP16:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP17:%.*]] = load i32, ptr [[DOTOMP_UB_ASCAST]], align 4
// NO-LOOP-NEXT:    [[CMP:%.*]] = icmp sle i32 [[TMP16]], [[TMP17]]
// NO-LOOP-NEXT:    br i1 [[CMP]], label [[OMP_KERNEL_BODY:%.*]], label [[OMP_KERNEL_DONE:%.*]]
// NO-LOOP:       omp.kernel.body:
// NO-LOOP-NEXT:    store i64 0, ptr [[SUM5_ASCAST]], align 8
// NO-LOOP-NEXT:    br label [[OMP_INSCAN_DISPATCH:%.*]]
// NO-LOOP:       omp.before.scan.bb:
// NO-LOOP-NEXT:    [[TMP18:%.*]] = load i64, ptr [[TMP3]], align 8
// NO-LOOP-NEXT:    [[TMP19:%.*]] = load ptr, ptr [[B_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP20:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// NO-LOOP-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP20]] to i64
// NO-LOOP-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i64, ptr [[TMP19]], i64 [[IDXPROM]]
// NO-LOOP-NEXT:    store i64 [[TMP18]], ptr [[ARRAYIDX]], align 8
// NO-LOOP-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// NO-LOOP:       omp.exit.inscan.bb:
// NO-LOOP-NEXT:    [[TMP21:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP22:%.*]] = zext i32 [[TMP21]] to i64
// NO-LOOP-NEXT:    br label [[OMP_BODY_CONTINUE]]
// NO-LOOP:       omp.inscan.dispatch:
// NO-LOOP-NEXT:    br label [[OMP_AFTER_SCAN_BB:%.*]]
// NO-LOOP:       omp.after.scan.bb:
// NO-LOOP-NEXT:    [[TMP23:%.*]] = load ptr, ptr [[A_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP24:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// NO-LOOP-NEXT:    [[IDXPROM6:%.*]] = sext i32 [[TMP24]] to i64
// NO-LOOP-NEXT:    [[ARRAYIDX7:%.*]] = getelementptr inbounds i64, ptr [[TMP23]], i64 [[IDXPROM6]]
// NO-LOOP-NEXT:    [[TMP25:%.*]] = load i64, ptr [[ARRAYIDX7]], align 8
// NO-LOOP-NEXT:    [[TMP26:%.*]] = load i64, ptr addrspace(5) [[TMP6]], align 8
// NO-LOOP-NEXT:    [[TMP27:%.*]] = add i64 [[TMP26]], [[TMP25]]
// NO-LOOP-NEXT:    store i64 [[TMP27]], ptr addrspace(5) [[TMP6]], align 8
// NO-LOOP-NEXT:    br label [[OMP_EXIT_INSCAN_BB:%.*]]
// NO-LOOP:       omp.body.continue:
// NO-LOOP-NEXT:    [[TMP28:%.*]] = load ptr, ptr [[DOTADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP29:%.*]] = load ptr, ptr [[DOTADDR3_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP30:%.*]] = load ptr, ptr [[DOTADDR4_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP31:%.*]] = load i64, ptr addrspace(5) [[TMP6]], align 8
// NO-LOOP-NEXT:    call void @__kmpc_xteams_l_4x64(i64 [[TMP31]], ptr [[TMP30]], ptr [[TMP3]], ptr [[TMP28]], ptr [[TMP29]], ptr @__kmpc_rfun_sum_l, ptr @__kmpc_rfun_sum_lds_l, i64 0, i64 [[TMP14]], i32 [[TMP13]])
// NO-LOOP-NEXT:    br label [[OMP_KERNEL_DONE]]
// NO-LOOP:       omp.kernel.done:
// NO-LOOP-NEXT:    ret void
//
//
// NO-LOOP-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z8run_testIlEvv_l45_1
// NO-LOOP-SAME: (ptr noalias noundef [[DYN_PTR:%.*]], ptr noundef [[B:%.*]], ptr noundef nonnull align 8 dereferenceable(8) [[SUM:%.*]], ptr noundef [[A:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 8 dereferenceable(8) [[SUM1:%.*]], ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]], ptr noundef [[TMP2:%.*]]) #[[ATTR0]] {
// NO-LOOP-NEXT:  entry:
// NO-LOOP-NEXT:    [[DYN_PTR_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[B_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[SUM_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[A_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[SUM_ADDR2:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[DOTADDR3:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[DOTADDR4:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[I:%.*]] = alloca i32, align 4, addrspace(5)
// NO-LOOP-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4, addrspace(5)
// NO-LOOP-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4, addrspace(5)
// NO-LOOP-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4, addrspace(5)
// NO-LOOP-NEXT:    [[SUM5:%.*]] = alloca i64, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[DYN_PTR_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DYN_PTR_ADDR]] to ptr
// NO-LOOP-NEXT:    [[B_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[B_ADDR]] to ptr
// NO-LOOP-NEXT:    [[SUM_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM_ADDR]] to ptr
// NO-LOOP-NEXT:    [[A_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[A_ADDR]] to ptr
// NO-LOOP-NEXT:    [[VLA_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[VLA_ADDR]] to ptr
// NO-LOOP-NEXT:    [[SUM_ADDR2_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM_ADDR2]] to ptr
// NO-LOOP-NEXT:    [[DOTADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR]] to ptr
// NO-LOOP-NEXT:    [[DOTADDR3_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR3]] to ptr
// NO-LOOP-NEXT:    [[DOTADDR4_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR4]] to ptr
// NO-LOOP-NEXT:    [[I_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[I]] to ptr
// NO-LOOP-NEXT:    [[DOTOMP_LB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_LB]] to ptr
// NO-LOOP-NEXT:    [[DOTOMP_UB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_UB]] to ptr
// NO-LOOP-NEXT:    [[DOTOMP_IV_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_IV]] to ptr
// NO-LOOP-NEXT:    [[SUM5_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM5]] to ptr
// NO-LOOP-NEXT:    store ptr [[DYN_PTR]], ptr [[DYN_PTR_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[B]], ptr [[B_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[SUM]], ptr [[SUM_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[A]], ptr [[A_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[SUM1]], ptr [[SUM_ADDR2_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR3_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[TMP2]], ptr [[DOTADDR4_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[SUM_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP4:%.*]] = load i64, ptr [[VLA_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[SUM_ADDR2_ASCAST]], align 8
// NO-LOOP-NEXT:    call void @__kmpc_specialized_kernel_init()
// NO-LOOP-NEXT:    [[TMP6:%.*]] = alloca i64, align 8, addrspace(5)
// NO-LOOP-NEXT:    store i64 0, ptr addrspace(5) [[TMP6]], align 8
// NO-LOOP-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// NO-LOOP-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// NO-LOOP-NEXT:    store i32 0, ptr [[DOTOMP_LB_ASCAST]], align 4
// NO-LOOP-NEXT:    store i32 25599, ptr [[DOTOMP_UB_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP7:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// NO-LOOP-NEXT:    store i32 [[TMP7]], ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP8:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// NO-LOOP-NEXT:    [[NVPTX_NUM_THREADS:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// NO-LOOP-NEXT:    [[GPU_BLOCK_ID:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// NO-LOOP-NEXT:    [[TMP9:%.*]] = mul i32 [[GPU_BLOCK_ID]], [[NVPTX_NUM_THREADS]]
// NO-LOOP-NEXT:    [[TMP10:%.*]] = add i32 [[TMP9]], [[TMP8]]
// NO-LOOP-NEXT:    [[TMP11:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP12:%.*]] = add i32 [[TMP10]], [[TMP11]]
// NO-LOOP-NEXT:    [[TMP13:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// NO-LOOP-NEXT:    [[TMP14:%.*]] = zext i32 [[TMP12]] to i64
// NO-LOOP-NEXT:    [[TOTAL_NUM_THREADS:%.*]] = mul i32 [[TMP13]], [[NVPTX_NUM_THREADS]]
// NO-LOOP-NEXT:    store i32 [[TMP12]], ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP15:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP15]], 1
// NO-LOOP-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// NO-LOOP-NEXT:    store i32 [[ADD]], ptr [[I_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP16:%.*]] = load ptr, ptr [[DOTADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP17:%.*]] = load ptr, ptr [[DOTADDR4_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP18:%.*]] = load ptr, ptr [[DOTADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP19:%.*]] = load ptr, ptr [[DOTADDR4_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP20:%.*]] = load i64, ptr addrspace(5) [[TMP6]], align 8
// NO-LOOP-NEXT:    call void @__kmpc_xteams_phase2_l_4x64(ptr [[TMP19]], i32 1, ptr [[TMP18]], ptr [[TMP19]], ptr @__kmpc_rfun_sum_l, i64 0, i64 [[TMP14]], i32 0)
// NO-LOOP-NEXT:    [[TMP21:%.*]] = add i32 [[TMP10]], [[TOTAL_NUM_THREADS]]
// NO-LOOP-NEXT:    [[TMP22:%.*]] = getelementptr i64, ptr [[TMP17]], i32 [[TMP21]]
// NO-LOOP-NEXT:    [[TMP23:%.*]] = load i64, ptr [[TMP22]], align 8
// NO-LOOP-NEXT:    store i64 [[TMP23]], ptr addrspace(5) [[TMP6]], align 8
// NO-LOOP-NEXT:    store i64 0, ptr [[SUM5_ASCAST]], align 8
// NO-LOOP-NEXT:    br label [[OMP_INSCAN_DISPATCH:%.*]]
// NO-LOOP:       omp.before.scan.bb:
// NO-LOOP-NEXT:    [[TMP24:%.*]] = load ptr, ptr [[B_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP25:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// NO-LOOP-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP25]] to i64
// NO-LOOP-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i64, ptr [[TMP24]], i64 [[IDXPROM]]
// NO-LOOP-NEXT:    [[TMP26:%.*]] = load i64, ptr addrspace(5) [[TMP6]], align 8
// NO-LOOP-NEXT:    store i64 [[TMP26]], ptr [[ARRAYIDX]], align 8
// NO-LOOP-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// NO-LOOP:       omp.exit.inscan.bb:
// NO-LOOP-NEXT:    br label [[OMP_BODY_CONTINUE]]
// NO-LOOP:       omp.inscan.dispatch:
// NO-LOOP-NEXT:    [[TMP27:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP28:%.*]] = zext i32 [[TMP27]] to i64
// NO-LOOP-NEXT:    [[TMP29:%.*]] = icmp eq i64 [[TMP28]], 0
// NO-LOOP-NEXT:    br i1 [[TMP29]], label [[OMP_EXCLUSIVE_COPY_EXIT:%.*]], label [[OMP_EXCLUSIVE_DEC:%.*]]
// NO-LOOP:       omp.exclusive.dec:
// NO-LOOP-NEXT:    [[TMP30:%.*]] = sub nuw i64 [[TMP28]], 1
// NO-LOOP-NEXT:    [[ARRAYIDX6:%.*]] = getelementptr inbounds nuw i64, ptr [[TMP5]], i64 [[TMP30]]
// NO-LOOP-NEXT:    [[TMP31:%.*]] = load i64, ptr addrspace(5) [[TMP6]], align 8
// NO-LOOP-NEXT:    store i64 [[TMP31]], ptr [[TMP3]], align 8
// NO-LOOP-NEXT:    br label [[OMP_EXCLUSIVE_COPY_EXIT]]
// NO-LOOP:       omp.exclusive.copy.exit:
// NO-LOOP-NEXT:    br label [[OMP_BEFORE_SCAN_BB:%.*]]
// NO-LOOP:       omp.after.scan.bb:
// NO-LOOP-NEXT:    [[TMP32:%.*]] = load ptr, ptr [[A_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP33:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// NO-LOOP-NEXT:    [[IDXPROM7:%.*]] = sext i32 [[TMP33]] to i64
// NO-LOOP-NEXT:    [[ARRAYIDX8:%.*]] = getelementptr inbounds i64, ptr [[TMP32]], i64 [[IDXPROM7]]
// NO-LOOP-NEXT:    [[TMP34:%.*]] = load i64, ptr [[ARRAYIDX8]], align 8
// NO-LOOP-NEXT:    [[TMP35:%.*]] = load i64, ptr addrspace(5) [[TMP6]], align 8
// NO-LOOP-NEXT:    [[TMP36:%.*]] = add i64 [[TMP35]], [[TMP34]]
// NO-LOOP-NEXT:    store i64 [[TMP36]], ptr addrspace(5) [[TMP6]], align 8
// NO-LOOP-NEXT:    br label [[OMP_EXIT_INSCAN_BB:%.*]]
// NO-LOOP:       omp.body.continue:
// NO-LOOP-NEXT:    ret void
//
//
// NO-LOOP-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z8run_testIdEvv_l33
// NO-LOOP-SAME: (ptr noalias noundef [[DYN_PTR:%.*]], ptr noundef nonnull align 8 dereferenceable(8) [[SUM:%.*]], ptr noundef [[A:%.*]], ptr noundef [[B:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 8 dereferenceable(8) [[SUM1:%.*]], ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]], ptr noundef [[TMP2:%.*]]) #[[ATTR0]] {
// NO-LOOP-NEXT:  entry:
// NO-LOOP-NEXT:    [[DYN_PTR_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[SUM_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[A_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[B_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[SUM_ADDR2:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[DOTADDR3:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[DOTADDR4:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[I:%.*]] = alloca i32, align 4, addrspace(5)
// NO-LOOP-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4, addrspace(5)
// NO-LOOP-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4, addrspace(5)
// NO-LOOP-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4, addrspace(5)
// NO-LOOP-NEXT:    [[SUM5:%.*]] = alloca double, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[DYN_PTR_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DYN_PTR_ADDR]] to ptr
// NO-LOOP-NEXT:    [[SUM_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM_ADDR]] to ptr
// NO-LOOP-NEXT:    [[A_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[A_ADDR]] to ptr
// NO-LOOP-NEXT:    [[B_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[B_ADDR]] to ptr
// NO-LOOP-NEXT:    [[VLA_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[VLA_ADDR]] to ptr
// NO-LOOP-NEXT:    [[SUM_ADDR2_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM_ADDR2]] to ptr
// NO-LOOP-NEXT:    [[DOTADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR]] to ptr
// NO-LOOP-NEXT:    [[DOTADDR3_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR3]] to ptr
// NO-LOOP-NEXT:    [[DOTADDR4_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR4]] to ptr
// NO-LOOP-NEXT:    [[I_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[I]] to ptr
// NO-LOOP-NEXT:    [[DOTOMP_LB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_LB]] to ptr
// NO-LOOP-NEXT:    [[DOTOMP_UB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_UB]] to ptr
// NO-LOOP-NEXT:    [[DOTOMP_IV_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_IV]] to ptr
// NO-LOOP-NEXT:    [[SUM5_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM5]] to ptr
// NO-LOOP-NEXT:    store ptr [[DYN_PTR]], ptr [[DYN_PTR_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[SUM]], ptr [[SUM_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[A]], ptr [[A_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[B]], ptr [[B_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[SUM1]], ptr [[SUM_ADDR2_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR3_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[TMP2]], ptr [[DOTADDR4_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[SUM_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP4:%.*]] = load i64, ptr [[VLA_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[SUM_ADDR2_ASCAST]], align 8
// NO-LOOP-NEXT:    call void @__kmpc_specialized_kernel_init()
// NO-LOOP-NEXT:    [[TMP6:%.*]] = alloca double, align 8, addrspace(5)
// NO-LOOP-NEXT:    store double 0.000000e+00, ptr addrspace(5) [[TMP6]], align 8
// NO-LOOP-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// NO-LOOP-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// NO-LOOP-NEXT:    store i32 0, ptr [[DOTOMP_LB_ASCAST]], align 4
// NO-LOOP-NEXT:    store i32 25599, ptr [[DOTOMP_UB_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP7:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// NO-LOOP-NEXT:    store i32 [[TMP7]], ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP8:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// NO-LOOP-NEXT:    [[NVPTX_NUM_THREADS:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// NO-LOOP-NEXT:    [[GPU_BLOCK_ID:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// NO-LOOP-NEXT:    [[TMP9:%.*]] = mul i32 [[GPU_BLOCK_ID]], [[NVPTX_NUM_THREADS]]
// NO-LOOP-NEXT:    [[TMP10:%.*]] = add i32 [[TMP9]], [[TMP8]]
// NO-LOOP-NEXT:    [[TMP11:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP12:%.*]] = add i32 [[TMP10]], [[TMP11]]
// NO-LOOP-NEXT:    [[TMP13:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// NO-LOOP-NEXT:    [[TMP14:%.*]] = zext i32 [[TMP12]] to i64
// NO-LOOP-NEXT:    [[TOTAL_NUM_THREADS:%.*]] = mul i32 [[TMP13]], [[NVPTX_NUM_THREADS]]
// NO-LOOP-NEXT:    store i32 [[TMP12]], ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP15:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP15]], 1
// NO-LOOP-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// NO-LOOP-NEXT:    store i32 [[ADD]], ptr [[I_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP16:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP17:%.*]] = load i32, ptr [[DOTOMP_UB_ASCAST]], align 4
// NO-LOOP-NEXT:    [[CMP:%.*]] = icmp sle i32 [[TMP16]], [[TMP17]]
// NO-LOOP-NEXT:    br i1 [[CMP]], label [[OMP_KERNEL_BODY:%.*]], label [[OMP_KERNEL_DONE:%.*]]
// NO-LOOP:       omp.kernel.body:
// NO-LOOP-NEXT:    store double 0.000000e+00, ptr [[SUM5_ASCAST]], align 8
// NO-LOOP-NEXT:    br label [[OMP_INSCAN_DISPATCH:%.*]]
// NO-LOOP:       omp.before.scan.bb:
// NO-LOOP-NEXT:    [[TMP18:%.*]] = load ptr, ptr [[A_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP19:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// NO-LOOP-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP19]] to i64
// NO-LOOP-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds double, ptr [[TMP18]], i64 [[IDXPROM]]
// NO-LOOP-NEXT:    [[TMP20:%.*]] = load double, ptr [[ARRAYIDX]], align 8
// NO-LOOP-NEXT:    [[TMP21:%.*]] = load double, ptr addrspace(5) [[TMP6]], align 8
// NO-LOOP-NEXT:    [[TMP22:%.*]] = fadd double [[TMP21]], [[TMP20]]
// NO-LOOP-NEXT:    store double [[TMP22]], ptr addrspace(5) [[TMP6]], align 8
// NO-LOOP-NEXT:    [[TMP23:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP24:%.*]] = zext i32 [[TMP23]] to i64
// NO-LOOP-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// NO-LOOP:       omp.exit.inscan.bb:
// NO-LOOP-NEXT:    br label [[OMP_BODY_CONTINUE]]
// NO-LOOP:       omp.inscan.dispatch:
// NO-LOOP-NEXT:    br label [[OMP_BEFORE_SCAN_BB:%.*]]
// NO-LOOP:       omp.after.scan.bb:
// NO-LOOP-NEXT:    [[TMP25:%.*]] = load double, ptr [[TMP3]], align 8
// NO-LOOP-NEXT:    [[TMP26:%.*]] = load ptr, ptr [[B_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP27:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// NO-LOOP-NEXT:    [[IDXPROM6:%.*]] = sext i32 [[TMP27]] to i64
// NO-LOOP-NEXT:    [[ARRAYIDX7:%.*]] = getelementptr inbounds double, ptr [[TMP26]], i64 [[IDXPROM6]]
// NO-LOOP-NEXT:    store double [[TMP25]], ptr [[ARRAYIDX7]], align 8
// NO-LOOP-NEXT:    br label [[OMP_EXIT_INSCAN_BB:%.*]]
// NO-LOOP:       omp.body.continue:
// NO-LOOP-NEXT:    [[TMP28:%.*]] = load ptr, ptr [[DOTADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP29:%.*]] = load ptr, ptr [[DOTADDR3_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP30:%.*]] = load ptr, ptr [[DOTADDR4_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP31:%.*]] = load double, ptr addrspace(5) [[TMP6]], align 8
// NO-LOOP-NEXT:    call void @__kmpc_xteams_d_4x64(double [[TMP31]], ptr [[TMP30]], ptr [[TMP3]], ptr [[TMP28]], ptr [[TMP29]], ptr @__kmpc_rfun_sum_d, ptr @__kmpc_rfun_sum_lds_d, double 0.000000e+00, i64 [[TMP14]], i32 [[TMP13]])
// NO-LOOP-NEXT:    br label [[OMP_KERNEL_DONE]]
// NO-LOOP:       omp.kernel.done:
// NO-LOOP-NEXT:    ret void
//
//
// NO-LOOP-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z8run_testIdEvv_l33_1
// NO-LOOP-SAME: (ptr noalias noundef [[DYN_PTR:%.*]], ptr noundef nonnull align 8 dereferenceable(8) [[SUM:%.*]], ptr noundef [[A:%.*]], ptr noundef [[B:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 8 dereferenceable(8) [[SUM1:%.*]], ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]], ptr noundef [[TMP2:%.*]]) #[[ATTR0]] {
// NO-LOOP-NEXT:  entry:
// NO-LOOP-NEXT:    [[DYN_PTR_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[SUM_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[A_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[B_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[SUM_ADDR2:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[DOTADDR3:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[DOTADDR4:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[I:%.*]] = alloca i32, align 4, addrspace(5)
// NO-LOOP-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4, addrspace(5)
// NO-LOOP-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4, addrspace(5)
// NO-LOOP-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4, addrspace(5)
// NO-LOOP-NEXT:    [[SUM5:%.*]] = alloca double, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[DYN_PTR_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DYN_PTR_ADDR]] to ptr
// NO-LOOP-NEXT:    [[SUM_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM_ADDR]] to ptr
// NO-LOOP-NEXT:    [[A_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[A_ADDR]] to ptr
// NO-LOOP-NEXT:    [[B_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[B_ADDR]] to ptr
// NO-LOOP-NEXT:    [[VLA_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[VLA_ADDR]] to ptr
// NO-LOOP-NEXT:    [[SUM_ADDR2_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM_ADDR2]] to ptr
// NO-LOOP-NEXT:    [[DOTADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR]] to ptr
// NO-LOOP-NEXT:    [[DOTADDR3_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR3]] to ptr
// NO-LOOP-NEXT:    [[DOTADDR4_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR4]] to ptr
// NO-LOOP-NEXT:    [[I_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[I]] to ptr
// NO-LOOP-NEXT:    [[DOTOMP_LB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_LB]] to ptr
// NO-LOOP-NEXT:    [[DOTOMP_UB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_UB]] to ptr
// NO-LOOP-NEXT:    [[DOTOMP_IV_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_IV]] to ptr
// NO-LOOP-NEXT:    [[SUM5_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM5]] to ptr
// NO-LOOP-NEXT:    store ptr [[DYN_PTR]], ptr [[DYN_PTR_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[SUM]], ptr [[SUM_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[A]], ptr [[A_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[B]], ptr [[B_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[SUM1]], ptr [[SUM_ADDR2_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR3_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[TMP2]], ptr [[DOTADDR4_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[SUM_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP4:%.*]] = load i64, ptr [[VLA_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[SUM_ADDR2_ASCAST]], align 8
// NO-LOOP-NEXT:    call void @__kmpc_specialized_kernel_init()
// NO-LOOP-NEXT:    [[TMP6:%.*]] = alloca double, align 8, addrspace(5)
// NO-LOOP-NEXT:    store double 0.000000e+00, ptr addrspace(5) [[TMP6]], align 8
// NO-LOOP-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// NO-LOOP-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// NO-LOOP-NEXT:    store i32 0, ptr [[DOTOMP_LB_ASCAST]], align 4
// NO-LOOP-NEXT:    store i32 25599, ptr [[DOTOMP_UB_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP7:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// NO-LOOP-NEXT:    store i32 [[TMP7]], ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP8:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// NO-LOOP-NEXT:    [[NVPTX_NUM_THREADS:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// NO-LOOP-NEXT:    [[GPU_BLOCK_ID:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// NO-LOOP-NEXT:    [[TMP9:%.*]] = mul i32 [[GPU_BLOCK_ID]], [[NVPTX_NUM_THREADS]]
// NO-LOOP-NEXT:    [[TMP10:%.*]] = add i32 [[TMP9]], [[TMP8]]
// NO-LOOP-NEXT:    [[TMP11:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP12:%.*]] = add i32 [[TMP10]], [[TMP11]]
// NO-LOOP-NEXT:    [[TMP13:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// NO-LOOP-NEXT:    [[TMP14:%.*]] = zext i32 [[TMP12]] to i64
// NO-LOOP-NEXT:    [[TOTAL_NUM_THREADS:%.*]] = mul i32 [[TMP13]], [[NVPTX_NUM_THREADS]]
// NO-LOOP-NEXT:    store i32 [[TMP12]], ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP15:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP15]], 1
// NO-LOOP-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// NO-LOOP-NEXT:    store i32 [[ADD]], ptr [[I_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP16:%.*]] = load ptr, ptr [[DOTADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP17:%.*]] = load ptr, ptr [[DOTADDR4_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP18:%.*]] = load ptr, ptr [[DOTADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP19:%.*]] = load ptr, ptr [[DOTADDR4_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP20:%.*]] = load double, ptr addrspace(5) [[TMP6]], align 8
// NO-LOOP-NEXT:    call void @__kmpc_xteams_phase2_d_4x64(ptr [[TMP19]], i32 1, ptr [[TMP18]], ptr [[TMP19]], ptr @__kmpc_rfun_sum_d, double 0.000000e+00, i64 [[TMP14]], i32 1)
// NO-LOOP-NEXT:    [[TMP21:%.*]] = add i32 [[TMP10]], [[TOTAL_NUM_THREADS]]
// NO-LOOP-NEXT:    [[TMP22:%.*]] = getelementptr double, ptr [[TMP17]], i32 [[TMP21]]
// NO-LOOP-NEXT:    [[TMP23:%.*]] = load double, ptr [[TMP22]], align 8
// NO-LOOP-NEXT:    store double [[TMP23]], ptr addrspace(5) [[TMP6]], align 8
// NO-LOOP-NEXT:    store double 0.000000e+00, ptr [[SUM5_ASCAST]], align 8
// NO-LOOP-NEXT:    br label [[OMP_INSCAN_DISPATCH:%.*]]
// NO-LOOP:       omp.before.scan.bb:
// NO-LOOP-NEXT:    [[TMP24:%.*]] = load ptr, ptr [[A_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP25:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// NO-LOOP-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP25]] to i64
// NO-LOOP-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds double, ptr [[TMP24]], i64 [[IDXPROM]]
// NO-LOOP-NEXT:    [[TMP26:%.*]] = load double, ptr [[ARRAYIDX]], align 8
// NO-LOOP-NEXT:    [[TMP27:%.*]] = load double, ptr addrspace(5) [[TMP6]], align 8
// NO-LOOP-NEXT:    [[TMP28:%.*]] = fadd double [[TMP27]], [[TMP26]]
// NO-LOOP-NEXT:    store double [[TMP28]], ptr addrspace(5) [[TMP6]], align 8
// NO-LOOP-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// NO-LOOP:       omp.exit.inscan.bb:
// NO-LOOP-NEXT:    br label [[OMP_BODY_CONTINUE]]
// NO-LOOP:       omp.inscan.dispatch:
// NO-LOOP-NEXT:    [[TMP29:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP30:%.*]] = zext i32 [[TMP29]] to i64
// NO-LOOP-NEXT:    [[ARRAYIDX6:%.*]] = getelementptr inbounds nuw double, ptr [[TMP5]], i64 [[TMP30]]
// NO-LOOP-NEXT:    [[TMP31:%.*]] = load double, ptr addrspace(5) [[TMP6]], align 8
// NO-LOOP-NEXT:    store double [[TMP31]], ptr [[TMP3]], align 8
// NO-LOOP-NEXT:    br label [[OMP_AFTER_SCAN_BB:%.*]]
// NO-LOOP:       omp.after.scan.bb:
// NO-LOOP-NEXT:    [[TMP32:%.*]] = load ptr, ptr [[B_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP33:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// NO-LOOP-NEXT:    [[IDXPROM7:%.*]] = sext i32 [[TMP33]] to i64
// NO-LOOP-NEXT:    [[ARRAYIDX8:%.*]] = getelementptr inbounds double, ptr [[TMP32]], i64 [[IDXPROM7]]
// NO-LOOP-NEXT:    [[TMP34:%.*]] = load double, ptr addrspace(5) [[TMP6]], align 8
// NO-LOOP-NEXT:    store double [[TMP34]], ptr [[ARRAYIDX8]], align 8
// NO-LOOP-NEXT:    br label [[OMP_EXIT_INSCAN_BB:%.*]]
// NO-LOOP:       omp.body.continue:
// NO-LOOP-NEXT:    ret void
//
//
// NO-LOOP-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z8run_testIdEvv_l45
// NO-LOOP-SAME: (ptr noalias noundef [[DYN_PTR:%.*]], ptr noundef [[B:%.*]], ptr noundef nonnull align 8 dereferenceable(8) [[SUM:%.*]], ptr noundef [[A:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 8 dereferenceable(8) [[SUM1:%.*]], ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]], ptr noundef [[TMP2:%.*]]) #[[ATTR0]] {
// NO-LOOP-NEXT:  entry:
// NO-LOOP-NEXT:    [[DYN_PTR_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[B_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[SUM_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[A_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[SUM_ADDR2:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[DOTADDR3:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[DOTADDR4:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[I:%.*]] = alloca i32, align 4, addrspace(5)
// NO-LOOP-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4, addrspace(5)
// NO-LOOP-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4, addrspace(5)
// NO-LOOP-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4, addrspace(5)
// NO-LOOP-NEXT:    [[SUM5:%.*]] = alloca double, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[DYN_PTR_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DYN_PTR_ADDR]] to ptr
// NO-LOOP-NEXT:    [[B_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[B_ADDR]] to ptr
// NO-LOOP-NEXT:    [[SUM_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM_ADDR]] to ptr
// NO-LOOP-NEXT:    [[A_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[A_ADDR]] to ptr
// NO-LOOP-NEXT:    [[VLA_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[VLA_ADDR]] to ptr
// NO-LOOP-NEXT:    [[SUM_ADDR2_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM_ADDR2]] to ptr
// NO-LOOP-NEXT:    [[DOTADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR]] to ptr
// NO-LOOP-NEXT:    [[DOTADDR3_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR3]] to ptr
// NO-LOOP-NEXT:    [[DOTADDR4_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR4]] to ptr
// NO-LOOP-NEXT:    [[I_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[I]] to ptr
// NO-LOOP-NEXT:    [[DOTOMP_LB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_LB]] to ptr
// NO-LOOP-NEXT:    [[DOTOMP_UB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_UB]] to ptr
// NO-LOOP-NEXT:    [[DOTOMP_IV_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_IV]] to ptr
// NO-LOOP-NEXT:    [[SUM5_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM5]] to ptr
// NO-LOOP-NEXT:    store ptr [[DYN_PTR]], ptr [[DYN_PTR_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[B]], ptr [[B_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[SUM]], ptr [[SUM_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[A]], ptr [[A_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[SUM1]], ptr [[SUM_ADDR2_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR3_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[TMP2]], ptr [[DOTADDR4_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[SUM_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP4:%.*]] = load i64, ptr [[VLA_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[SUM_ADDR2_ASCAST]], align 8
// NO-LOOP-NEXT:    call void @__kmpc_specialized_kernel_init()
// NO-LOOP-NEXT:    [[TMP6:%.*]] = alloca double, align 8, addrspace(5)
// NO-LOOP-NEXT:    store double 0.000000e+00, ptr addrspace(5) [[TMP6]], align 8
// NO-LOOP-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// NO-LOOP-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// NO-LOOP-NEXT:    store i32 0, ptr [[DOTOMP_LB_ASCAST]], align 4
// NO-LOOP-NEXT:    store i32 25599, ptr [[DOTOMP_UB_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP7:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// NO-LOOP-NEXT:    store i32 [[TMP7]], ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP8:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// NO-LOOP-NEXT:    [[NVPTX_NUM_THREADS:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// NO-LOOP-NEXT:    [[GPU_BLOCK_ID:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// NO-LOOP-NEXT:    [[TMP9:%.*]] = mul i32 [[GPU_BLOCK_ID]], [[NVPTX_NUM_THREADS]]
// NO-LOOP-NEXT:    [[TMP10:%.*]] = add i32 [[TMP9]], [[TMP8]]
// NO-LOOP-NEXT:    [[TMP11:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP12:%.*]] = add i32 [[TMP10]], [[TMP11]]
// NO-LOOP-NEXT:    [[TMP13:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// NO-LOOP-NEXT:    [[TMP14:%.*]] = zext i32 [[TMP12]] to i64
// NO-LOOP-NEXT:    [[TOTAL_NUM_THREADS:%.*]] = mul i32 [[TMP13]], [[NVPTX_NUM_THREADS]]
// NO-LOOP-NEXT:    store i32 [[TMP12]], ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP15:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP15]], 1
// NO-LOOP-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// NO-LOOP-NEXT:    store i32 [[ADD]], ptr [[I_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP16:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP17:%.*]] = load i32, ptr [[DOTOMP_UB_ASCAST]], align 4
// NO-LOOP-NEXT:    [[CMP:%.*]] = icmp sle i32 [[TMP16]], [[TMP17]]
// NO-LOOP-NEXT:    br i1 [[CMP]], label [[OMP_KERNEL_BODY:%.*]], label [[OMP_KERNEL_DONE:%.*]]
// NO-LOOP:       omp.kernel.body:
// NO-LOOP-NEXT:    store double 0.000000e+00, ptr [[SUM5_ASCAST]], align 8
// NO-LOOP-NEXT:    br label [[OMP_INSCAN_DISPATCH:%.*]]
// NO-LOOP:       omp.before.scan.bb:
// NO-LOOP-NEXT:    [[TMP18:%.*]] = load double, ptr [[TMP3]], align 8
// NO-LOOP-NEXT:    [[TMP19:%.*]] = load ptr, ptr [[B_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP20:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// NO-LOOP-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP20]] to i64
// NO-LOOP-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds double, ptr [[TMP19]], i64 [[IDXPROM]]
// NO-LOOP-NEXT:    store double [[TMP18]], ptr [[ARRAYIDX]], align 8
// NO-LOOP-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// NO-LOOP:       omp.exit.inscan.bb:
// NO-LOOP-NEXT:    [[TMP21:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP22:%.*]] = zext i32 [[TMP21]] to i64
// NO-LOOP-NEXT:    br label [[OMP_BODY_CONTINUE]]
// NO-LOOP:       omp.inscan.dispatch:
// NO-LOOP-NEXT:    br label [[OMP_AFTER_SCAN_BB:%.*]]
// NO-LOOP:       omp.after.scan.bb:
// NO-LOOP-NEXT:    [[TMP23:%.*]] = load ptr, ptr [[A_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP24:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// NO-LOOP-NEXT:    [[IDXPROM6:%.*]] = sext i32 [[TMP24]] to i64
// NO-LOOP-NEXT:    [[ARRAYIDX7:%.*]] = getelementptr inbounds double, ptr [[TMP23]], i64 [[IDXPROM6]]
// NO-LOOP-NEXT:    [[TMP25:%.*]] = load double, ptr [[ARRAYIDX7]], align 8
// NO-LOOP-NEXT:    [[TMP26:%.*]] = load double, ptr addrspace(5) [[TMP6]], align 8
// NO-LOOP-NEXT:    [[TMP27:%.*]] = fadd double [[TMP26]], [[TMP25]]
// NO-LOOP-NEXT:    store double [[TMP27]], ptr addrspace(5) [[TMP6]], align 8
// NO-LOOP-NEXT:    br label [[OMP_EXIT_INSCAN_BB:%.*]]
// NO-LOOP:       omp.body.continue:
// NO-LOOP-NEXT:    [[TMP28:%.*]] = load ptr, ptr [[DOTADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP29:%.*]] = load ptr, ptr [[DOTADDR3_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP30:%.*]] = load ptr, ptr [[DOTADDR4_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP31:%.*]] = load double, ptr addrspace(5) [[TMP6]], align 8
// NO-LOOP-NEXT:    call void @__kmpc_xteams_d_4x64(double [[TMP31]], ptr [[TMP30]], ptr [[TMP3]], ptr [[TMP28]], ptr [[TMP29]], ptr @__kmpc_rfun_sum_d, ptr @__kmpc_rfun_sum_lds_d, double 0.000000e+00, i64 [[TMP14]], i32 [[TMP13]])
// NO-LOOP-NEXT:    br label [[OMP_KERNEL_DONE]]
// NO-LOOP:       omp.kernel.done:
// NO-LOOP-NEXT:    ret void
//
//
// NO-LOOP-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z8run_testIdEvv_l45_1
// NO-LOOP-SAME: (ptr noalias noundef [[DYN_PTR:%.*]], ptr noundef [[B:%.*]], ptr noundef nonnull align 8 dereferenceable(8) [[SUM:%.*]], ptr noundef [[A:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 8 dereferenceable(8) [[SUM1:%.*]], ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]], ptr noundef [[TMP2:%.*]]) #[[ATTR0]] {
// NO-LOOP-NEXT:  entry:
// NO-LOOP-NEXT:    [[DYN_PTR_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[B_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[SUM_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[A_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[SUM_ADDR2:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[DOTADDR3:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[DOTADDR4:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[I:%.*]] = alloca i32, align 4, addrspace(5)
// NO-LOOP-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4, addrspace(5)
// NO-LOOP-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4, addrspace(5)
// NO-LOOP-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4, addrspace(5)
// NO-LOOP-NEXT:    [[SUM5:%.*]] = alloca double, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[DYN_PTR_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DYN_PTR_ADDR]] to ptr
// NO-LOOP-NEXT:    [[B_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[B_ADDR]] to ptr
// NO-LOOP-NEXT:    [[SUM_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM_ADDR]] to ptr
// NO-LOOP-NEXT:    [[A_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[A_ADDR]] to ptr
// NO-LOOP-NEXT:    [[VLA_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[VLA_ADDR]] to ptr
// NO-LOOP-NEXT:    [[SUM_ADDR2_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM_ADDR2]] to ptr
// NO-LOOP-NEXT:    [[DOTADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR]] to ptr
// NO-LOOP-NEXT:    [[DOTADDR3_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR3]] to ptr
// NO-LOOP-NEXT:    [[DOTADDR4_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR4]] to ptr
// NO-LOOP-NEXT:    [[I_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[I]] to ptr
// NO-LOOP-NEXT:    [[DOTOMP_LB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_LB]] to ptr
// NO-LOOP-NEXT:    [[DOTOMP_UB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_UB]] to ptr
// NO-LOOP-NEXT:    [[DOTOMP_IV_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_IV]] to ptr
// NO-LOOP-NEXT:    [[SUM5_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM5]] to ptr
// NO-LOOP-NEXT:    store ptr [[DYN_PTR]], ptr [[DYN_PTR_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[B]], ptr [[B_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[SUM]], ptr [[SUM_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[A]], ptr [[A_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[SUM1]], ptr [[SUM_ADDR2_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR3_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[TMP2]], ptr [[DOTADDR4_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[SUM_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP4:%.*]] = load i64, ptr [[VLA_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[SUM_ADDR2_ASCAST]], align 8
// NO-LOOP-NEXT:    call void @__kmpc_specialized_kernel_init()
// NO-LOOP-NEXT:    [[TMP6:%.*]] = alloca double, align 8, addrspace(5)
// NO-LOOP-NEXT:    store double 0.000000e+00, ptr addrspace(5) [[TMP6]], align 8
// NO-LOOP-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// NO-LOOP-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// NO-LOOP-NEXT:    store i32 0, ptr [[DOTOMP_LB_ASCAST]], align 4
// NO-LOOP-NEXT:    store i32 25599, ptr [[DOTOMP_UB_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP7:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// NO-LOOP-NEXT:    store i32 [[TMP7]], ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP8:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// NO-LOOP-NEXT:    [[NVPTX_NUM_THREADS:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// NO-LOOP-NEXT:    [[GPU_BLOCK_ID:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// NO-LOOP-NEXT:    [[TMP9:%.*]] = mul i32 [[GPU_BLOCK_ID]], [[NVPTX_NUM_THREADS]]
// NO-LOOP-NEXT:    [[TMP10:%.*]] = add i32 [[TMP9]], [[TMP8]]
// NO-LOOP-NEXT:    [[TMP11:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP12:%.*]] = add i32 [[TMP10]], [[TMP11]]
// NO-LOOP-NEXT:    [[TMP13:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// NO-LOOP-NEXT:    [[TMP14:%.*]] = zext i32 [[TMP12]] to i64
// NO-LOOP-NEXT:    [[TOTAL_NUM_THREADS:%.*]] = mul i32 [[TMP13]], [[NVPTX_NUM_THREADS]]
// NO-LOOP-NEXT:    store i32 [[TMP12]], ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP15:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP15]], 1
// NO-LOOP-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// NO-LOOP-NEXT:    store i32 [[ADD]], ptr [[I_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP16:%.*]] = load ptr, ptr [[DOTADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP17:%.*]] = load ptr, ptr [[DOTADDR4_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP18:%.*]] = load ptr, ptr [[DOTADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP19:%.*]] = load ptr, ptr [[DOTADDR4_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP20:%.*]] = load double, ptr addrspace(5) [[TMP6]], align 8
// NO-LOOP-NEXT:    call void @__kmpc_xteams_phase2_d_4x64(ptr [[TMP19]], i32 1, ptr [[TMP18]], ptr [[TMP19]], ptr @__kmpc_rfun_sum_d, double 0.000000e+00, i64 [[TMP14]], i32 0)
// NO-LOOP-NEXT:    [[TMP21:%.*]] = add i32 [[TMP10]], [[TOTAL_NUM_THREADS]]
// NO-LOOP-NEXT:    [[TMP22:%.*]] = getelementptr double, ptr [[TMP17]], i32 [[TMP21]]
// NO-LOOP-NEXT:    [[TMP23:%.*]] = load double, ptr [[TMP22]], align 8
// NO-LOOP-NEXT:    store double [[TMP23]], ptr addrspace(5) [[TMP6]], align 8
// NO-LOOP-NEXT:    store double 0.000000e+00, ptr [[SUM5_ASCAST]], align 8
// NO-LOOP-NEXT:    br label [[OMP_INSCAN_DISPATCH:%.*]]
// NO-LOOP:       omp.before.scan.bb:
// NO-LOOP-NEXT:    [[TMP24:%.*]] = load ptr, ptr [[B_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP25:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// NO-LOOP-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP25]] to i64
// NO-LOOP-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds double, ptr [[TMP24]], i64 [[IDXPROM]]
// NO-LOOP-NEXT:    [[TMP26:%.*]] = load double, ptr addrspace(5) [[TMP6]], align 8
// NO-LOOP-NEXT:    store double [[TMP26]], ptr [[ARRAYIDX]], align 8
// NO-LOOP-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// NO-LOOP:       omp.exit.inscan.bb:
// NO-LOOP-NEXT:    br label [[OMP_BODY_CONTINUE]]
// NO-LOOP:       omp.inscan.dispatch:
// NO-LOOP-NEXT:    [[TMP27:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP28:%.*]] = zext i32 [[TMP27]] to i64
// NO-LOOP-NEXT:    [[TMP29:%.*]] = icmp eq i64 [[TMP28]], 0
// NO-LOOP-NEXT:    br i1 [[TMP29]], label [[OMP_EXCLUSIVE_COPY_EXIT:%.*]], label [[OMP_EXCLUSIVE_DEC:%.*]]
// NO-LOOP:       omp.exclusive.dec:
// NO-LOOP-NEXT:    [[TMP30:%.*]] = sub nuw i64 [[TMP28]], 1
// NO-LOOP-NEXT:    [[ARRAYIDX6:%.*]] = getelementptr inbounds nuw double, ptr [[TMP5]], i64 [[TMP30]]
// NO-LOOP-NEXT:    [[TMP31:%.*]] = load double, ptr addrspace(5) [[TMP6]], align 8
// NO-LOOP-NEXT:    store double [[TMP31]], ptr [[TMP3]], align 8
// NO-LOOP-NEXT:    br label [[OMP_EXCLUSIVE_COPY_EXIT]]
// NO-LOOP:       omp.exclusive.copy.exit:
// NO-LOOP-NEXT:    br label [[OMP_BEFORE_SCAN_BB:%.*]]
// NO-LOOP:       omp.after.scan.bb:
// NO-LOOP-NEXT:    [[TMP32:%.*]] = load ptr, ptr [[A_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP33:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// NO-LOOP-NEXT:    [[IDXPROM7:%.*]] = sext i32 [[TMP33]] to i64
// NO-LOOP-NEXT:    [[ARRAYIDX8:%.*]] = getelementptr inbounds double, ptr [[TMP32]], i64 [[IDXPROM7]]
// NO-LOOP-NEXT:    [[TMP34:%.*]] = load double, ptr [[ARRAYIDX8]], align 8
// NO-LOOP-NEXT:    [[TMP35:%.*]] = load double, ptr addrspace(5) [[TMP6]], align 8
// NO-LOOP-NEXT:    [[TMP36:%.*]] = fadd double [[TMP35]], [[TMP34]]
// NO-LOOP-NEXT:    store double [[TMP36]], ptr addrspace(5) [[TMP6]], align 8
// NO-LOOP-NEXT:    br label [[OMP_EXIT_INSCAN_BB:%.*]]
// NO-LOOP:       omp.body.continue:
// NO-LOOP-NEXT:    ret void
//
//
// NO-LOOP-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z8run_testIfEvv_l33
// NO-LOOP-SAME: (ptr noalias noundef [[DYN_PTR:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM:%.*]], ptr noundef [[A:%.*]], ptr noundef [[B:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM1:%.*]], ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]], ptr noundef [[TMP2:%.*]]) #[[ATTR0]] {
// NO-LOOP-NEXT:  entry:
// NO-LOOP-NEXT:    [[DYN_PTR_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[SUM_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[A_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[B_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[SUM_ADDR2:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[DOTADDR3:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[DOTADDR4:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[I:%.*]] = alloca i32, align 4, addrspace(5)
// NO-LOOP-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4, addrspace(5)
// NO-LOOP-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4, addrspace(5)
// NO-LOOP-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4, addrspace(5)
// NO-LOOP-NEXT:    [[SUM5:%.*]] = alloca float, align 4, addrspace(5)
// NO-LOOP-NEXT:    [[DYN_PTR_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DYN_PTR_ADDR]] to ptr
// NO-LOOP-NEXT:    [[SUM_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM_ADDR]] to ptr
// NO-LOOP-NEXT:    [[A_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[A_ADDR]] to ptr
// NO-LOOP-NEXT:    [[B_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[B_ADDR]] to ptr
// NO-LOOP-NEXT:    [[VLA_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[VLA_ADDR]] to ptr
// NO-LOOP-NEXT:    [[SUM_ADDR2_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM_ADDR2]] to ptr
// NO-LOOP-NEXT:    [[DOTADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR]] to ptr
// NO-LOOP-NEXT:    [[DOTADDR3_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR3]] to ptr
// NO-LOOP-NEXT:    [[DOTADDR4_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR4]] to ptr
// NO-LOOP-NEXT:    [[I_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[I]] to ptr
// NO-LOOP-NEXT:    [[DOTOMP_LB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_LB]] to ptr
// NO-LOOP-NEXT:    [[DOTOMP_UB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_UB]] to ptr
// NO-LOOP-NEXT:    [[DOTOMP_IV_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_IV]] to ptr
// NO-LOOP-NEXT:    [[SUM5_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM5]] to ptr
// NO-LOOP-NEXT:    store ptr [[DYN_PTR]], ptr [[DYN_PTR_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[SUM]], ptr [[SUM_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[A]], ptr [[A_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[B]], ptr [[B_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[SUM1]], ptr [[SUM_ADDR2_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR3_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[TMP2]], ptr [[DOTADDR4_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[SUM_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP4:%.*]] = load i64, ptr [[VLA_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[SUM_ADDR2_ASCAST]], align 8
// NO-LOOP-NEXT:    call void @__kmpc_specialized_kernel_init()
// NO-LOOP-NEXT:    [[TMP6:%.*]] = alloca float, align 4, addrspace(5)
// NO-LOOP-NEXT:    store float 0.000000e+00, ptr addrspace(5) [[TMP6]], align 4
// NO-LOOP-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// NO-LOOP-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// NO-LOOP-NEXT:    store i32 0, ptr [[DOTOMP_LB_ASCAST]], align 4
// NO-LOOP-NEXT:    store i32 25599, ptr [[DOTOMP_UB_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP7:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// NO-LOOP-NEXT:    store i32 [[TMP7]], ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP8:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// NO-LOOP-NEXT:    [[NVPTX_NUM_THREADS:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// NO-LOOP-NEXT:    [[GPU_BLOCK_ID:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// NO-LOOP-NEXT:    [[TMP9:%.*]] = mul i32 [[GPU_BLOCK_ID]], [[NVPTX_NUM_THREADS]]
// NO-LOOP-NEXT:    [[TMP10:%.*]] = add i32 [[TMP9]], [[TMP8]]
// NO-LOOP-NEXT:    [[TMP11:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP12:%.*]] = add i32 [[TMP10]], [[TMP11]]
// NO-LOOP-NEXT:    [[TMP13:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// NO-LOOP-NEXT:    [[TMP14:%.*]] = zext i32 [[TMP12]] to i64
// NO-LOOP-NEXT:    [[TOTAL_NUM_THREADS:%.*]] = mul i32 [[TMP13]], [[NVPTX_NUM_THREADS]]
// NO-LOOP-NEXT:    store i32 [[TMP12]], ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP15:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP15]], 1
// NO-LOOP-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// NO-LOOP-NEXT:    store i32 [[ADD]], ptr [[I_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP16:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP17:%.*]] = load i32, ptr [[DOTOMP_UB_ASCAST]], align 4
// NO-LOOP-NEXT:    [[CMP:%.*]] = icmp sle i32 [[TMP16]], [[TMP17]]
// NO-LOOP-NEXT:    br i1 [[CMP]], label [[OMP_KERNEL_BODY:%.*]], label [[OMP_KERNEL_DONE:%.*]]
// NO-LOOP:       omp.kernel.body:
// NO-LOOP-NEXT:    store float 0.000000e+00, ptr [[SUM5_ASCAST]], align 4
// NO-LOOP-NEXT:    br label [[OMP_INSCAN_DISPATCH:%.*]]
// NO-LOOP:       omp.before.scan.bb:
// NO-LOOP-NEXT:    [[TMP18:%.*]] = load ptr, ptr [[A_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP19:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// NO-LOOP-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP19]] to i64
// NO-LOOP-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds float, ptr [[TMP18]], i64 [[IDXPROM]]
// NO-LOOP-NEXT:    [[TMP20:%.*]] = load float, ptr [[ARRAYIDX]], align 4
// NO-LOOP-NEXT:    [[TMP21:%.*]] = load float, ptr addrspace(5) [[TMP6]], align 4
// NO-LOOP-NEXT:    [[TMP22:%.*]] = fadd float [[TMP21]], [[TMP20]]
// NO-LOOP-NEXT:    store float [[TMP22]], ptr addrspace(5) [[TMP6]], align 4
// NO-LOOP-NEXT:    [[TMP23:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP24:%.*]] = zext i32 [[TMP23]] to i64
// NO-LOOP-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// NO-LOOP:       omp.exit.inscan.bb:
// NO-LOOP-NEXT:    br label [[OMP_BODY_CONTINUE]]
// NO-LOOP:       omp.inscan.dispatch:
// NO-LOOP-NEXT:    br label [[OMP_BEFORE_SCAN_BB:%.*]]
// NO-LOOP:       omp.after.scan.bb:
// NO-LOOP-NEXT:    [[TMP25:%.*]] = load float, ptr [[TMP3]], align 4
// NO-LOOP-NEXT:    [[TMP26:%.*]] = load ptr, ptr [[B_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP27:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// NO-LOOP-NEXT:    [[IDXPROM6:%.*]] = sext i32 [[TMP27]] to i64
// NO-LOOP-NEXT:    [[ARRAYIDX7:%.*]] = getelementptr inbounds float, ptr [[TMP26]], i64 [[IDXPROM6]]
// NO-LOOP-NEXT:    store float [[TMP25]], ptr [[ARRAYIDX7]], align 4
// NO-LOOP-NEXT:    br label [[OMP_EXIT_INSCAN_BB:%.*]]
// NO-LOOP:       omp.body.continue:
// NO-LOOP-NEXT:    [[TMP28:%.*]] = load ptr, ptr [[DOTADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP29:%.*]] = load ptr, ptr [[DOTADDR3_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP30:%.*]] = load ptr, ptr [[DOTADDR4_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP31:%.*]] = load float, ptr addrspace(5) [[TMP6]], align 4
// NO-LOOP-NEXT:    call void @__kmpc_xteams_f_4x64(float [[TMP31]], ptr [[TMP30]], ptr [[TMP3]], ptr [[TMP28]], ptr [[TMP29]], ptr @__kmpc_rfun_sum_f, ptr @__kmpc_rfun_sum_lds_f, float 0.000000e+00, i64 [[TMP14]], i32 [[TMP13]])
// NO-LOOP-NEXT:    br label [[OMP_KERNEL_DONE]]
// NO-LOOP:       omp.kernel.done:
// NO-LOOP-NEXT:    ret void
//
//
// NO-LOOP-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z8run_testIfEvv_l33_1
// NO-LOOP-SAME: (ptr noalias noundef [[DYN_PTR:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM:%.*]], ptr noundef [[A:%.*]], ptr noundef [[B:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM1:%.*]], ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]], ptr noundef [[TMP2:%.*]]) #[[ATTR0]] {
// NO-LOOP-NEXT:  entry:
// NO-LOOP-NEXT:    [[DYN_PTR_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[SUM_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[A_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[B_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[SUM_ADDR2:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[DOTADDR3:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[DOTADDR4:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[I:%.*]] = alloca i32, align 4, addrspace(5)
// NO-LOOP-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4, addrspace(5)
// NO-LOOP-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4, addrspace(5)
// NO-LOOP-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4, addrspace(5)
// NO-LOOP-NEXT:    [[SUM5:%.*]] = alloca float, align 4, addrspace(5)
// NO-LOOP-NEXT:    [[DYN_PTR_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DYN_PTR_ADDR]] to ptr
// NO-LOOP-NEXT:    [[SUM_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM_ADDR]] to ptr
// NO-LOOP-NEXT:    [[A_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[A_ADDR]] to ptr
// NO-LOOP-NEXT:    [[B_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[B_ADDR]] to ptr
// NO-LOOP-NEXT:    [[VLA_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[VLA_ADDR]] to ptr
// NO-LOOP-NEXT:    [[SUM_ADDR2_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM_ADDR2]] to ptr
// NO-LOOP-NEXT:    [[DOTADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR]] to ptr
// NO-LOOP-NEXT:    [[DOTADDR3_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR3]] to ptr
// NO-LOOP-NEXT:    [[DOTADDR4_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR4]] to ptr
// NO-LOOP-NEXT:    [[I_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[I]] to ptr
// NO-LOOP-NEXT:    [[DOTOMP_LB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_LB]] to ptr
// NO-LOOP-NEXT:    [[DOTOMP_UB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_UB]] to ptr
// NO-LOOP-NEXT:    [[DOTOMP_IV_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_IV]] to ptr
// NO-LOOP-NEXT:    [[SUM5_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM5]] to ptr
// NO-LOOP-NEXT:    store ptr [[DYN_PTR]], ptr [[DYN_PTR_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[SUM]], ptr [[SUM_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[A]], ptr [[A_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[B]], ptr [[B_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[SUM1]], ptr [[SUM_ADDR2_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR3_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[TMP2]], ptr [[DOTADDR4_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[SUM_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP4:%.*]] = load i64, ptr [[VLA_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[SUM_ADDR2_ASCAST]], align 8
// NO-LOOP-NEXT:    call void @__kmpc_specialized_kernel_init()
// NO-LOOP-NEXT:    [[TMP6:%.*]] = alloca float, align 4, addrspace(5)
// NO-LOOP-NEXT:    store float 0.000000e+00, ptr addrspace(5) [[TMP6]], align 4
// NO-LOOP-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// NO-LOOP-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// NO-LOOP-NEXT:    store i32 0, ptr [[DOTOMP_LB_ASCAST]], align 4
// NO-LOOP-NEXT:    store i32 25599, ptr [[DOTOMP_UB_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP7:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// NO-LOOP-NEXT:    store i32 [[TMP7]], ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP8:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// NO-LOOP-NEXT:    [[NVPTX_NUM_THREADS:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// NO-LOOP-NEXT:    [[GPU_BLOCK_ID:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// NO-LOOP-NEXT:    [[TMP9:%.*]] = mul i32 [[GPU_BLOCK_ID]], [[NVPTX_NUM_THREADS]]
// NO-LOOP-NEXT:    [[TMP10:%.*]] = add i32 [[TMP9]], [[TMP8]]
// NO-LOOP-NEXT:    [[TMP11:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP12:%.*]] = add i32 [[TMP10]], [[TMP11]]
// NO-LOOP-NEXT:    [[TMP13:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// NO-LOOP-NEXT:    [[TMP14:%.*]] = zext i32 [[TMP12]] to i64
// NO-LOOP-NEXT:    [[TOTAL_NUM_THREADS:%.*]] = mul i32 [[TMP13]], [[NVPTX_NUM_THREADS]]
// NO-LOOP-NEXT:    store i32 [[TMP12]], ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP15:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP15]], 1
// NO-LOOP-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// NO-LOOP-NEXT:    store i32 [[ADD]], ptr [[I_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP16:%.*]] = load ptr, ptr [[DOTADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP17:%.*]] = load ptr, ptr [[DOTADDR4_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP18:%.*]] = load ptr, ptr [[DOTADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP19:%.*]] = load ptr, ptr [[DOTADDR4_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP20:%.*]] = load float, ptr addrspace(5) [[TMP6]], align 4
// NO-LOOP-NEXT:    call void @__kmpc_xteams_phase2_f_4x64(ptr [[TMP19]], i32 1, ptr [[TMP18]], ptr [[TMP19]], ptr @__kmpc_rfun_sum_f, float 0.000000e+00, i64 [[TMP14]], i32 1)
// NO-LOOP-NEXT:    [[TMP21:%.*]] = add i32 [[TMP10]], [[TOTAL_NUM_THREADS]]
// NO-LOOP-NEXT:    [[TMP22:%.*]] = getelementptr float, ptr [[TMP17]], i32 [[TMP21]]
// NO-LOOP-NEXT:    [[TMP23:%.*]] = load float, ptr [[TMP22]], align 4
// NO-LOOP-NEXT:    store float [[TMP23]], ptr addrspace(5) [[TMP6]], align 4
// NO-LOOP-NEXT:    store float 0.000000e+00, ptr [[SUM5_ASCAST]], align 4
// NO-LOOP-NEXT:    br label [[OMP_INSCAN_DISPATCH:%.*]]
// NO-LOOP:       omp.before.scan.bb:
// NO-LOOP-NEXT:    [[TMP24:%.*]] = load ptr, ptr [[A_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP25:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// NO-LOOP-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP25]] to i64
// NO-LOOP-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds float, ptr [[TMP24]], i64 [[IDXPROM]]
// NO-LOOP-NEXT:    [[TMP26:%.*]] = load float, ptr [[ARRAYIDX]], align 4
// NO-LOOP-NEXT:    [[TMP27:%.*]] = load float, ptr addrspace(5) [[TMP6]], align 4
// NO-LOOP-NEXT:    [[TMP28:%.*]] = fadd float [[TMP27]], [[TMP26]]
// NO-LOOP-NEXT:    store float [[TMP28]], ptr addrspace(5) [[TMP6]], align 4
// NO-LOOP-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// NO-LOOP:       omp.exit.inscan.bb:
// NO-LOOP-NEXT:    br label [[OMP_BODY_CONTINUE]]
// NO-LOOP:       omp.inscan.dispatch:
// NO-LOOP-NEXT:    [[TMP29:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP30:%.*]] = zext i32 [[TMP29]] to i64
// NO-LOOP-NEXT:    [[ARRAYIDX6:%.*]] = getelementptr inbounds nuw float, ptr [[TMP5]], i64 [[TMP30]]
// NO-LOOP-NEXT:    [[TMP31:%.*]] = load float, ptr addrspace(5) [[TMP6]], align 4
// NO-LOOP-NEXT:    store float [[TMP31]], ptr [[TMP3]], align 4
// NO-LOOP-NEXT:    br label [[OMP_AFTER_SCAN_BB:%.*]]
// NO-LOOP:       omp.after.scan.bb:
// NO-LOOP-NEXT:    [[TMP32:%.*]] = load ptr, ptr [[B_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP33:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// NO-LOOP-NEXT:    [[IDXPROM7:%.*]] = sext i32 [[TMP33]] to i64
// NO-LOOP-NEXT:    [[ARRAYIDX8:%.*]] = getelementptr inbounds float, ptr [[TMP32]], i64 [[IDXPROM7]]
// NO-LOOP-NEXT:    [[TMP34:%.*]] = load float, ptr addrspace(5) [[TMP6]], align 4
// NO-LOOP-NEXT:    store float [[TMP34]], ptr [[ARRAYIDX8]], align 4
// NO-LOOP-NEXT:    br label [[OMP_EXIT_INSCAN_BB:%.*]]
// NO-LOOP:       omp.body.continue:
// NO-LOOP-NEXT:    ret void
//
//
// NO-LOOP-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z8run_testIfEvv_l45
// NO-LOOP-SAME: (ptr noalias noundef [[DYN_PTR:%.*]], ptr noundef [[B:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM:%.*]], ptr noundef [[A:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM1:%.*]], ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]], ptr noundef [[TMP2:%.*]]) #[[ATTR0]] {
// NO-LOOP-NEXT:  entry:
// NO-LOOP-NEXT:    [[DYN_PTR_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[B_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[SUM_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[A_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[SUM_ADDR2:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[DOTADDR3:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[DOTADDR4:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[I:%.*]] = alloca i32, align 4, addrspace(5)
// NO-LOOP-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4, addrspace(5)
// NO-LOOP-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4, addrspace(5)
// NO-LOOP-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4, addrspace(5)
// NO-LOOP-NEXT:    [[SUM5:%.*]] = alloca float, align 4, addrspace(5)
// NO-LOOP-NEXT:    [[DYN_PTR_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DYN_PTR_ADDR]] to ptr
// NO-LOOP-NEXT:    [[B_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[B_ADDR]] to ptr
// NO-LOOP-NEXT:    [[SUM_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM_ADDR]] to ptr
// NO-LOOP-NEXT:    [[A_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[A_ADDR]] to ptr
// NO-LOOP-NEXT:    [[VLA_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[VLA_ADDR]] to ptr
// NO-LOOP-NEXT:    [[SUM_ADDR2_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM_ADDR2]] to ptr
// NO-LOOP-NEXT:    [[DOTADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR]] to ptr
// NO-LOOP-NEXT:    [[DOTADDR3_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR3]] to ptr
// NO-LOOP-NEXT:    [[DOTADDR4_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR4]] to ptr
// NO-LOOP-NEXT:    [[I_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[I]] to ptr
// NO-LOOP-NEXT:    [[DOTOMP_LB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_LB]] to ptr
// NO-LOOP-NEXT:    [[DOTOMP_UB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_UB]] to ptr
// NO-LOOP-NEXT:    [[DOTOMP_IV_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_IV]] to ptr
// NO-LOOP-NEXT:    [[SUM5_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM5]] to ptr
// NO-LOOP-NEXT:    store ptr [[DYN_PTR]], ptr [[DYN_PTR_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[B]], ptr [[B_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[SUM]], ptr [[SUM_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[A]], ptr [[A_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[SUM1]], ptr [[SUM_ADDR2_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR3_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[TMP2]], ptr [[DOTADDR4_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[SUM_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP4:%.*]] = load i64, ptr [[VLA_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[SUM_ADDR2_ASCAST]], align 8
// NO-LOOP-NEXT:    call void @__kmpc_specialized_kernel_init()
// NO-LOOP-NEXT:    [[TMP6:%.*]] = alloca float, align 4, addrspace(5)
// NO-LOOP-NEXT:    store float 0.000000e+00, ptr addrspace(5) [[TMP6]], align 4
// NO-LOOP-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// NO-LOOP-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// NO-LOOP-NEXT:    store i32 0, ptr [[DOTOMP_LB_ASCAST]], align 4
// NO-LOOP-NEXT:    store i32 25599, ptr [[DOTOMP_UB_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP7:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// NO-LOOP-NEXT:    store i32 [[TMP7]], ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP8:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// NO-LOOP-NEXT:    [[NVPTX_NUM_THREADS:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// NO-LOOP-NEXT:    [[GPU_BLOCK_ID:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// NO-LOOP-NEXT:    [[TMP9:%.*]] = mul i32 [[GPU_BLOCK_ID]], [[NVPTX_NUM_THREADS]]
// NO-LOOP-NEXT:    [[TMP10:%.*]] = add i32 [[TMP9]], [[TMP8]]
// NO-LOOP-NEXT:    [[TMP11:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP12:%.*]] = add i32 [[TMP10]], [[TMP11]]
// NO-LOOP-NEXT:    [[TMP13:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// NO-LOOP-NEXT:    [[TMP14:%.*]] = zext i32 [[TMP12]] to i64
// NO-LOOP-NEXT:    [[TOTAL_NUM_THREADS:%.*]] = mul i32 [[TMP13]], [[NVPTX_NUM_THREADS]]
// NO-LOOP-NEXT:    store i32 [[TMP12]], ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP15:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP15]], 1
// NO-LOOP-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// NO-LOOP-NEXT:    store i32 [[ADD]], ptr [[I_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP16:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP17:%.*]] = load i32, ptr [[DOTOMP_UB_ASCAST]], align 4
// NO-LOOP-NEXT:    [[CMP:%.*]] = icmp sle i32 [[TMP16]], [[TMP17]]
// NO-LOOP-NEXT:    br i1 [[CMP]], label [[OMP_KERNEL_BODY:%.*]], label [[OMP_KERNEL_DONE:%.*]]
// NO-LOOP:       omp.kernel.body:
// NO-LOOP-NEXT:    store float 0.000000e+00, ptr [[SUM5_ASCAST]], align 4
// NO-LOOP-NEXT:    br label [[OMP_INSCAN_DISPATCH:%.*]]
// NO-LOOP:       omp.before.scan.bb:
// NO-LOOP-NEXT:    [[TMP18:%.*]] = load float, ptr [[TMP3]], align 4
// NO-LOOP-NEXT:    [[TMP19:%.*]] = load ptr, ptr [[B_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP20:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// NO-LOOP-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP20]] to i64
// NO-LOOP-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds float, ptr [[TMP19]], i64 [[IDXPROM]]
// NO-LOOP-NEXT:    store float [[TMP18]], ptr [[ARRAYIDX]], align 4
// NO-LOOP-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// NO-LOOP:       omp.exit.inscan.bb:
// NO-LOOP-NEXT:    [[TMP21:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP22:%.*]] = zext i32 [[TMP21]] to i64
// NO-LOOP-NEXT:    br label [[OMP_BODY_CONTINUE]]
// NO-LOOP:       omp.inscan.dispatch:
// NO-LOOP-NEXT:    br label [[OMP_AFTER_SCAN_BB:%.*]]
// NO-LOOP:       omp.after.scan.bb:
// NO-LOOP-NEXT:    [[TMP23:%.*]] = load ptr, ptr [[A_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP24:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// NO-LOOP-NEXT:    [[IDXPROM6:%.*]] = sext i32 [[TMP24]] to i64
// NO-LOOP-NEXT:    [[ARRAYIDX7:%.*]] = getelementptr inbounds float, ptr [[TMP23]], i64 [[IDXPROM6]]
// NO-LOOP-NEXT:    [[TMP25:%.*]] = load float, ptr [[ARRAYIDX7]], align 4
// NO-LOOP-NEXT:    [[TMP26:%.*]] = load float, ptr addrspace(5) [[TMP6]], align 4
// NO-LOOP-NEXT:    [[TMP27:%.*]] = fadd float [[TMP26]], [[TMP25]]
// NO-LOOP-NEXT:    store float [[TMP27]], ptr addrspace(5) [[TMP6]], align 4
// NO-LOOP-NEXT:    br label [[OMP_EXIT_INSCAN_BB:%.*]]
// NO-LOOP:       omp.body.continue:
// NO-LOOP-NEXT:    [[TMP28:%.*]] = load ptr, ptr [[DOTADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP29:%.*]] = load ptr, ptr [[DOTADDR3_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP30:%.*]] = load ptr, ptr [[DOTADDR4_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP31:%.*]] = load float, ptr addrspace(5) [[TMP6]], align 4
// NO-LOOP-NEXT:    call void @__kmpc_xteams_f_4x64(float [[TMP31]], ptr [[TMP30]], ptr [[TMP3]], ptr [[TMP28]], ptr [[TMP29]], ptr @__kmpc_rfun_sum_f, ptr @__kmpc_rfun_sum_lds_f, float 0.000000e+00, i64 [[TMP14]], i32 [[TMP13]])
// NO-LOOP-NEXT:    br label [[OMP_KERNEL_DONE]]
// NO-LOOP:       omp.kernel.done:
// NO-LOOP-NEXT:    ret void
//
//
// NO-LOOP-LABEL: define {{[^@]+}}@{{__omp_offloading_[0-9a-z]+_[0-9a-z]+}}__Z8run_testIfEvv_l45_1
// NO-LOOP-SAME: (ptr noalias noundef [[DYN_PTR:%.*]], ptr noundef [[B:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM:%.*]], ptr noundef [[A:%.*]], i64 noundef [[VLA:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[SUM1:%.*]], ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]], ptr noundef [[TMP2:%.*]]) #[[ATTR0]] {
// NO-LOOP-NEXT:  entry:
// NO-LOOP-NEXT:    [[DYN_PTR_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[B_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[SUM_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[A_ADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[VLA_ADDR:%.*]] = alloca i64, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[SUM_ADDR2:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[DOTADDR3:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[DOTADDR4:%.*]] = alloca ptr, align 8, addrspace(5)
// NO-LOOP-NEXT:    [[I:%.*]] = alloca i32, align 4, addrspace(5)
// NO-LOOP-NEXT:    [[DOTOMP_LB:%.*]] = alloca i32, align 4, addrspace(5)
// NO-LOOP-NEXT:    [[DOTOMP_UB:%.*]] = alloca i32, align 4, addrspace(5)
// NO-LOOP-NEXT:    [[DOTOMP_IV:%.*]] = alloca i32, align 4, addrspace(5)
// NO-LOOP-NEXT:    [[SUM5:%.*]] = alloca float, align 4, addrspace(5)
// NO-LOOP-NEXT:    [[DYN_PTR_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DYN_PTR_ADDR]] to ptr
// NO-LOOP-NEXT:    [[B_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[B_ADDR]] to ptr
// NO-LOOP-NEXT:    [[SUM_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM_ADDR]] to ptr
// NO-LOOP-NEXT:    [[A_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[A_ADDR]] to ptr
// NO-LOOP-NEXT:    [[VLA_ADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[VLA_ADDR]] to ptr
// NO-LOOP-NEXT:    [[SUM_ADDR2_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM_ADDR2]] to ptr
// NO-LOOP-NEXT:    [[DOTADDR_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR]] to ptr
// NO-LOOP-NEXT:    [[DOTADDR3_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR3]] to ptr
// NO-LOOP-NEXT:    [[DOTADDR4_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTADDR4]] to ptr
// NO-LOOP-NEXT:    [[I_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[I]] to ptr
// NO-LOOP-NEXT:    [[DOTOMP_LB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_LB]] to ptr
// NO-LOOP-NEXT:    [[DOTOMP_UB_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_UB]] to ptr
// NO-LOOP-NEXT:    [[DOTOMP_IV_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[DOTOMP_IV]] to ptr
// NO-LOOP-NEXT:    [[SUM5_ASCAST:%.*]] = addrspacecast ptr addrspace(5) [[SUM5]] to ptr
// NO-LOOP-NEXT:    store ptr [[DYN_PTR]], ptr [[DYN_PTR_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[B]], ptr [[B_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[SUM]], ptr [[SUM_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[A]], ptr [[A_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store i64 [[VLA]], ptr [[VLA_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[SUM1]], ptr [[SUM_ADDR2_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR3_ASCAST]], align 8
// NO-LOOP-NEXT:    store ptr [[TMP2]], ptr [[DOTADDR4_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[SUM_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP4:%.*]] = load i64, ptr [[VLA_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[SUM_ADDR2_ASCAST]], align 8
// NO-LOOP-NEXT:    call void @__kmpc_specialized_kernel_init()
// NO-LOOP-NEXT:    [[TMP6:%.*]] = alloca float, align 4, addrspace(5)
// NO-LOOP-NEXT:    store float 0.000000e+00, ptr addrspace(5) [[TMP6]], align 4
// NO-LOOP-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// NO-LOOP-NEXT:    store i32 0, ptr [[I_ASCAST]], align 4
// NO-LOOP-NEXT:    store i32 0, ptr [[DOTOMP_LB_ASCAST]], align 4
// NO-LOOP-NEXT:    store i32 25599, ptr [[DOTOMP_UB_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP7:%.*]] = load i32, ptr [[DOTOMP_LB_ASCAST]], align 4
// NO-LOOP-NEXT:    store i32 [[TMP7]], ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP8:%.*]] = call i32 @__kmpc_get_hardware_thread_id_in_block()
// NO-LOOP-NEXT:    [[NVPTX_NUM_THREADS:%.*]] = call i32 @__kmpc_get_hardware_num_threads_in_block()
// NO-LOOP-NEXT:    [[GPU_BLOCK_ID:%.*]] = call i32 @llvm.amdgcn.workgroup.id.x()
// NO-LOOP-NEXT:    [[TMP9:%.*]] = mul i32 [[GPU_BLOCK_ID]], [[NVPTX_NUM_THREADS]]
// NO-LOOP-NEXT:    [[TMP10:%.*]] = add i32 [[TMP9]], [[TMP8]]
// NO-LOOP-NEXT:    [[TMP11:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP12:%.*]] = add i32 [[TMP10]], [[TMP11]]
// NO-LOOP-NEXT:    [[TMP13:%.*]] = call i32 @__kmpc_get_hardware_num_blocks()
// NO-LOOP-NEXT:    [[TMP14:%.*]] = zext i32 [[TMP12]] to i64
// NO-LOOP-NEXT:    [[TOTAL_NUM_THREADS:%.*]] = mul i32 [[TMP13]], [[NVPTX_NUM_THREADS]]
// NO-LOOP-NEXT:    store i32 [[TMP12]], ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP15:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP15]], 1
// NO-LOOP-NEXT:    [[ADD:%.*]] = add nsw i32 0, [[MUL]]
// NO-LOOP-NEXT:    store i32 [[ADD]], ptr [[I_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP16:%.*]] = load ptr, ptr [[DOTADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP17:%.*]] = load ptr, ptr [[DOTADDR4_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP18:%.*]] = load ptr, ptr [[DOTADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP19:%.*]] = load ptr, ptr [[DOTADDR4_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP20:%.*]] = load float, ptr addrspace(5) [[TMP6]], align 4
// NO-LOOP-NEXT:    call void @__kmpc_xteams_phase2_f_4x64(ptr [[TMP19]], i32 1, ptr [[TMP18]], ptr [[TMP19]], ptr @__kmpc_rfun_sum_f, float 0.000000e+00, i64 [[TMP14]], i32 0)
// NO-LOOP-NEXT:    [[TMP21:%.*]] = add i32 [[TMP10]], [[TOTAL_NUM_THREADS]]
// NO-LOOP-NEXT:    [[TMP22:%.*]] = getelementptr float, ptr [[TMP17]], i32 [[TMP21]]
// NO-LOOP-NEXT:    [[TMP23:%.*]] = load float, ptr [[TMP22]], align 4
// NO-LOOP-NEXT:    store float [[TMP23]], ptr addrspace(5) [[TMP6]], align 4
// NO-LOOP-NEXT:    store float 0.000000e+00, ptr [[SUM5_ASCAST]], align 4
// NO-LOOP-NEXT:    br label [[OMP_INSCAN_DISPATCH:%.*]]
// NO-LOOP:       omp.before.scan.bb:
// NO-LOOP-NEXT:    [[TMP24:%.*]] = load ptr, ptr [[B_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP25:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// NO-LOOP-NEXT:    [[IDXPROM:%.*]] = sext i32 [[TMP25]] to i64
// NO-LOOP-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds float, ptr [[TMP24]], i64 [[IDXPROM]]
// NO-LOOP-NEXT:    [[TMP26:%.*]] = load float, ptr addrspace(5) [[TMP6]], align 4
// NO-LOOP-NEXT:    store float [[TMP26]], ptr [[ARRAYIDX]], align 4
// NO-LOOP-NEXT:    br label [[OMP_BODY_CONTINUE:%.*]]
// NO-LOOP:       omp.exit.inscan.bb:
// NO-LOOP-NEXT:    br label [[OMP_BODY_CONTINUE]]
// NO-LOOP:       omp.inscan.dispatch:
// NO-LOOP-NEXT:    [[TMP27:%.*]] = load i32, ptr [[DOTOMP_IV_ASCAST]], align 4
// NO-LOOP-NEXT:    [[TMP28:%.*]] = zext i32 [[TMP27]] to i64
// NO-LOOP-NEXT:    [[TMP29:%.*]] = icmp eq i64 [[TMP28]], 0
// NO-LOOP-NEXT:    br i1 [[TMP29]], label [[OMP_EXCLUSIVE_COPY_EXIT:%.*]], label [[OMP_EXCLUSIVE_DEC:%.*]]
// NO-LOOP:       omp.exclusive.dec:
// NO-LOOP-NEXT:    [[TMP30:%.*]] = sub nuw i64 [[TMP28]], 1
// NO-LOOP-NEXT:    [[ARRAYIDX6:%.*]] = getelementptr inbounds nuw float, ptr [[TMP5]], i64 [[TMP30]]
// NO-LOOP-NEXT:    [[TMP31:%.*]] = load float, ptr addrspace(5) [[TMP6]], align 4
// NO-LOOP-NEXT:    store float [[TMP31]], ptr [[TMP3]], align 4
// NO-LOOP-NEXT:    br label [[OMP_EXCLUSIVE_COPY_EXIT]]
// NO-LOOP:       omp.exclusive.copy.exit:
// NO-LOOP-NEXT:    br label [[OMP_BEFORE_SCAN_BB:%.*]]
// NO-LOOP:       omp.after.scan.bb:
// NO-LOOP-NEXT:    [[TMP32:%.*]] = load ptr, ptr [[A_ADDR_ASCAST]], align 8
// NO-LOOP-NEXT:    [[TMP33:%.*]] = load i32, ptr [[I_ASCAST]], align 4
// NO-LOOP-NEXT:    [[IDXPROM7:%.*]] = sext i32 [[TMP33]] to i64
// NO-LOOP-NEXT:    [[ARRAYIDX8:%.*]] = getelementptr inbounds float, ptr [[TMP32]], i64 [[IDXPROM7]]
// NO-LOOP-NEXT:    [[TMP34:%.*]] = load float, ptr [[ARRAYIDX8]], align 4
// NO-LOOP-NEXT:    [[TMP35:%.*]] = load float, ptr addrspace(5) [[TMP6]], align 4
// NO-LOOP-NEXT:    [[TMP36:%.*]] = fadd float [[TMP35]], [[TMP34]]
// NO-LOOP-NEXT:    store float [[TMP36]], ptr addrspace(5) [[TMP6]], align 4
// NO-LOOP-NEXT:    br label [[OMP_EXIT_INSCAN_BB:%.*]]
// NO-LOOP:       omp.body.continue:
// NO-LOOP-NEXT:    ret void
//
