#include "tree_sitter/parser.h"

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 171
#define LARGE_STATE_COUNT 2
#define SYMBOL_COUNT 54
#define ALIAS_COUNT 0
#define TOKEN_COUNT 23
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 1
#define MAX_ALIAS_SEQUENCE_LENGTH 6
#define PRODUCTION_ID_COUNT 2

enum ts_symbol_identifiers {
  sym_raw_string_literal = 1,
  anon_sym_DQUOTE = 2,
  aux_sym_interpreted_string_literal_token1 = 3,
  sym_escape_sequence = 4,
  sym__identifier = 5,
  anon_sym_module = 6,
  anon_sym_LPAREN = 7,
  anon_sym_LF = 8,
  anon_sym_RPAREN = 9,
  anon_sym_go = 10,
  anon_sym_toolchain = 11,
  anon_sym_require = 12,
  anon_sym_exclude = 13,
  anon_sym_replace = 14,
  anon_sym_EQ_GT = 15,
  anon_sym_tool = 16,
  anon_sym_retract = 17,
  anon_sym_LBRACK = 18,
  anon_sym_COMMA = 19,
  anon_sym_RBRACK = 20,
  anon_sym_SLASH_SLASH = 21,
  aux_sym_comment_token1 = 22,
  sym_source_file = 23,
  sym__directive = 24,
  sym__string_literal = 25,
  sym_interpreted_string_literal = 26,
  sym__string_or_ident = 27,
  sym_module_path = 28,
  sym_go_version = 29,
  sym_version = 30,
  sym_tool = 31,
  sym_module_directive = 32,
  sym_go_directive = 33,
  sym_toolchain_directive = 34,
  sym_toolchain_name = 35,
  sym_require_directive = 36,
  sym_require_spec = 37,
  sym_exclude_directive = 38,
  sym_exclude_spec = 39,
  sym_replace_directive = 40,
  sym_replace_spec = 41,
  sym_tool_directive = 42,
  sym_file_path = 43,
  sym_retract_directive = 44,
  sym_retract_spec = 45,
  sym_comment = 46,
  aux_sym_source_file_repeat1 = 47,
  aux_sym_interpreted_string_literal_repeat1 = 48,
  aux_sym_require_directive_repeat1 = 49,
  aux_sym_exclude_directive_repeat1 = 50,
  aux_sym_replace_directive_repeat1 = 51,
  aux_sym_tool_directive_repeat1 = 52,
  aux_sym_retract_directive_repeat1 = 53,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_raw_string_literal] = "raw_string_literal",
  [anon_sym_DQUOTE] = "\"",
  [aux_sym_interpreted_string_literal_token1] = "interpreted_string_literal_token1",
  [sym_escape_sequence] = "escape_sequence",
  [sym__identifier] = "_identifier",
  [anon_sym_module] = "module",
  [anon_sym_LPAREN] = "(",
  [anon_sym_LF] = "\n",
  [anon_sym_RPAREN] = ")",
  [anon_sym_go] = "go",
  [anon_sym_toolchain] = "toolchain",
  [anon_sym_require] = "require",
  [anon_sym_exclude] = "exclude",
  [anon_sym_replace] = "replace",
  [anon_sym_EQ_GT] = "=>",
  [anon_sym_tool] = "tool",
  [anon_sym_retract] = "retract",
  [anon_sym_LBRACK] = "[",
  [anon_sym_COMMA] = ",",
  [anon_sym_RBRACK] = "]",
  [anon_sym_SLASH_SLASH] = "//",
  [aux_sym_comment_token1] = "comment_token1",
  [sym_source_file] = "source_file",
  [sym__directive] = "_directive",
  [sym__string_literal] = "_string_literal",
  [sym_interpreted_string_literal] = "interpreted_string_literal",
  [sym__string_or_ident] = "_string_or_ident",
  [sym_module_path] = "module_path",
  [sym_go_version] = "go_version",
  [sym_version] = "version",
  [sym_tool] = "tool",
  [sym_module_directive] = "module_directive",
  [sym_go_directive] = "go_directive",
  [sym_toolchain_directive] = "toolchain_directive",
  [sym_toolchain_name] = "toolchain_name",
  [sym_require_directive] = "require_directive",
  [sym_require_spec] = "require_spec",
  [sym_exclude_directive] = "exclude_directive",
  [sym_exclude_spec] = "exclude_spec",
  [sym_replace_directive] = "replace_directive",
  [sym_replace_spec] = "replace_spec",
  [sym_tool_directive] = "tool_directive",
  [sym_file_path] = "file_path",
  [sym_retract_directive] = "retract_directive",
  [sym_retract_spec] = "retract_spec",
  [sym_comment] = "comment",
  [aux_sym_source_file_repeat1] = "source_file_repeat1",
  [aux_sym_interpreted_string_literal_repeat1] = "interpreted_string_literal_repeat1",
  [aux_sym_require_directive_repeat1] = "require_directive_repeat1",
  [aux_sym_exclude_directive_repeat1] = "exclude_directive_repeat1",
  [aux_sym_replace_directive_repeat1] = "replace_directive_repeat1",
  [aux_sym_tool_directive_repeat1] = "tool_directive_repeat1",
  [aux_sym_retract_directive_repeat1] = "retract_directive_repeat1",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_raw_string_literal] = sym_raw_string_literal,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [aux_sym_interpreted_string_literal_token1] = aux_sym_interpreted_string_literal_token1,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym__identifier] = sym__identifier,
  [anon_sym_module] = anon_sym_module,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_LF] = anon_sym_LF,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_go] = anon_sym_go,
  [anon_sym_toolchain] = anon_sym_toolchain,
  [anon_sym_require] = anon_sym_require,
  [anon_sym_exclude] = anon_sym_exclude,
  [anon_sym_replace] = anon_sym_replace,
  [anon_sym_EQ_GT] = anon_sym_EQ_GT,
  [anon_sym_tool] = anon_sym_tool,
  [anon_sym_retract] = anon_sym_retract,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_SLASH_SLASH] = anon_sym_SLASH_SLASH,
  [aux_sym_comment_token1] = aux_sym_comment_token1,
  [sym_source_file] = sym_source_file,
  [sym__directive] = sym__directive,
  [sym__string_literal] = sym__string_literal,
  [sym_interpreted_string_literal] = sym_interpreted_string_literal,
  [sym__string_or_ident] = sym__string_or_ident,
  [sym_module_path] = sym_module_path,
  [sym_go_version] = sym_go_version,
  [sym_version] = sym_version,
  [sym_tool] = sym_tool,
  [sym_module_directive] = sym_module_directive,
  [sym_go_directive] = sym_go_directive,
  [sym_toolchain_directive] = sym_toolchain_directive,
  [sym_toolchain_name] = sym_toolchain_name,
  [sym_require_directive] = sym_require_directive,
  [sym_require_spec] = sym_require_spec,
  [sym_exclude_directive] = sym_exclude_directive,
  [sym_exclude_spec] = sym_exclude_spec,
  [sym_replace_directive] = sym_replace_directive,
  [sym_replace_spec] = sym_replace_spec,
  [sym_tool_directive] = sym_tool_directive,
  [sym_file_path] = sym_file_path,
  [sym_retract_directive] = sym_retract_directive,
  [sym_retract_spec] = sym_retract_spec,
  [sym_comment] = sym_comment,
  [aux_sym_source_file_repeat1] = aux_sym_source_file_repeat1,
  [aux_sym_interpreted_string_literal_repeat1] = aux_sym_interpreted_string_literal_repeat1,
  [aux_sym_require_directive_repeat1] = aux_sym_require_directive_repeat1,
  [aux_sym_exclude_directive_repeat1] = aux_sym_exclude_directive_repeat1,
  [aux_sym_replace_directive_repeat1] = aux_sym_replace_directive_repeat1,
  [aux_sym_tool_directive_repeat1] = aux_sym_tool_directive_repeat1,
  [aux_sym_retract_directive_repeat1] = aux_sym_retract_directive_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_raw_string_literal] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_interpreted_string_literal_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym__identifier] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_module] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LF] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_go] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_toolchain] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_require] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_exclude] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_replace] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_tool] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_retract] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_SLASH] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_comment_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_source_file] = {
    .visible = true,
    .named = true,
  },
  [sym__directive] = {
    .visible = false,
    .named = true,
  },
  [sym__string_literal] = {
    .visible = false,
    .named = true,
  },
  [sym_interpreted_string_literal] = {
    .visible = true,
    .named = true,
  },
  [sym__string_or_ident] = {
    .visible = false,
    .named = true,
  },
  [sym_module_path] = {
    .visible = true,
    .named = true,
  },
  [sym_go_version] = {
    .visible = true,
    .named = true,
  },
  [sym_version] = {
    .visible = true,
    .named = true,
  },
  [sym_tool] = {
    .visible = true,
    .named = true,
  },
  [sym_module_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_go_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_toolchain_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_toolchain_name] = {
    .visible = true,
    .named = true,
  },
  [sym_require_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_require_spec] = {
    .visible = true,
    .named = true,
  },
  [sym_exclude_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_exclude_spec] = {
    .visible = true,
    .named = true,
  },
  [sym_replace_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_replace_spec] = {
    .visible = true,
    .named = true,
  },
  [sym_tool_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_file_path] = {
    .visible = true,
    .named = true,
  },
  [sym_retract_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_retract_spec] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_source_file_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_interpreted_string_literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_require_directive_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_exclude_directive_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_replace_directive_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_tool_directive_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_retract_directive_repeat1] = {
    .visible = false,
    .named = false,
  },
};

enum ts_field_identifiers {
  field_name = 1,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_name] = "name",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_name, 1},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 4,
  [5] = 5,
  [6] = 6,
  [7] = 7,
  [8] = 8,
  [9] = 9,
  [10] = 10,
  [11] = 11,
  [12] = 12,
  [13] = 13,
  [14] = 14,
  [15] = 15,
  [16] = 16,
  [17] = 17,
  [18] = 18,
  [19] = 19,
  [20] = 20,
  [21] = 21,
  [22] = 22,
  [23] = 23,
  [24] = 24,
  [25] = 25,
  [26] = 26,
  [27] = 27,
  [28] = 28,
  [29] = 29,
  [30] = 30,
  [31] = 31,
  [32] = 32,
  [33] = 33,
  [34] = 34,
  [35] = 35,
  [36] = 36,
  [37] = 37,
  [38] = 38,
  [39] = 39,
  [40] = 40,
  [41] = 41,
  [42] = 42,
  [43] = 43,
  [44] = 44,
  [45] = 45,
  [46] = 46,
  [47] = 47,
  [48] = 48,
  [49] = 49,
  [50] = 50,
  [51] = 51,
  [52] = 52,
  [53] = 53,
  [54] = 54,
  [55] = 55,
  [56] = 56,
  [57] = 57,
  [58] = 58,
  [59] = 59,
  [60] = 59,
  [61] = 61,
  [62] = 62,
  [63] = 63,
  [64] = 58,
  [65] = 63,
  [66] = 66,
  [67] = 67,
  [68] = 68,
  [69] = 69,
  [70] = 70,
  [71] = 71,
  [72] = 72,
  [73] = 73,
  [74] = 67,
  [75] = 75,
  [76] = 70,
  [77] = 66,
  [78] = 68,
  [79] = 75,
  [80] = 72,
  [81] = 81,
  [82] = 35,
  [83] = 56,
  [84] = 27,
  [85] = 85,
  [86] = 86,
  [87] = 87,
  [88] = 88,
  [89] = 89,
  [90] = 90,
  [91] = 57,
  [92] = 38,
  [93] = 43,
  [94] = 52,
  [95] = 55,
  [96] = 96,
  [97] = 42,
  [98] = 5,
  [99] = 6,
  [100] = 4,
  [101] = 7,
  [102] = 5,
  [103] = 6,
  [104] = 4,
  [105] = 7,
  [106] = 86,
  [107] = 88,
  [108] = 86,
  [109] = 88,
  [110] = 86,
  [111] = 88,
  [112] = 86,
  [113] = 88,
  [114] = 114,
  [115] = 115,
  [116] = 7,
  [117] = 42,
  [118] = 118,
  [119] = 5,
  [120] = 6,
  [121] = 4,
  [122] = 122,
  [123] = 123,
  [124] = 124,
  [125] = 125,
  [126] = 126,
  [127] = 127,
  [128] = 128,
  [129] = 129,
  [130] = 4,
  [131] = 131,
  [132] = 132,
  [133] = 7,
  [134] = 134,
  [135] = 135,
  [136] = 42,
  [137] = 137,
  [138] = 138,
  [139] = 139,
  [140] = 140,
  [141] = 141,
  [142] = 142,
  [143] = 143,
  [144] = 144,
  [145] = 118,
  [146] = 6,
  [147] = 131,
  [148] = 128,
  [149] = 126,
  [150] = 150,
  [151] = 151,
  [152] = 144,
  [153] = 150,
  [154] = 154,
  [155] = 155,
  [156] = 151,
  [157] = 157,
  [158] = 158,
  [159] = 159,
  [160] = 160,
  [161] = 161,
  [162] = 162,
  [163] = 5,
  [164] = 140,
  [165] = 165,
  [166] = 122,
  [167] = 143,
  [168] = 168,
  [169] = 125,
  [170] = 170,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(55);
      ADVANCE_MAP(
        '"', 58,
        '(', 71,
        ')', 74,
        ',', 86,
        '/', 9,
        '=', 10,
        '[', 85,
        '\\', 11,
        ']', 87,
        '`', 12,
        'e', 45,
        'g', 34,
        'm', 35,
        'r', 21,
        't', 37,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(54);
      END_STATE();
    case 1:
      if (lookahead == '\n') SKIP(4);
      if (lookahead == '"') ADVANCE(58);
      if (lookahead == '/') ADVANCE(61);
      if (lookahead == '\\') ADVANCE(11);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(60);
      if (lookahead != 0) ADVANCE(62);
      END_STATE();
    case 2:
      if (lookahead == '\n') ADVANCE(73);
      if (lookahead == '"') ADVANCE(59);
      if (lookahead == '/') ADVANCE(66);
      if (lookahead == '`') ADVANCE(68);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(2);
      if (lookahead != 0 &&
          lookahead != ',' &&
          lookahead != '[' &&
          lookahead != ']') ADVANCE(69);
      END_STATE();
    case 3:
      if (lookahead == '\n') ADVANCE(73);
      if (lookahead == '/') ADVANCE(9);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(3);
      END_STATE();
    case 4:
      if (lookahead == '"') ADVANCE(58);
      if (lookahead == '/') ADVANCE(9);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(4);
      END_STATE();
    case 5:
      if (lookahead == '"') ADVANCE(59);
      if (lookahead == '(') ADVANCE(72);
      if (lookahead == '/') ADVANCE(66);
      if (lookahead == '[') ADVANCE(85);
      if (lookahead == '`') ADVANCE(68);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(5);
      if (lookahead != 0 &&
          lookahead != ',' &&
          lookahead != ']') ADVANCE(69);
      END_STATE();
    case 6:
      if (lookahead == '"') ADVANCE(59);
      if (lookahead == ')') ADVANCE(75);
      if (lookahead == '/') ADVANCE(66);
      if (lookahead == '[') ADVANCE(85);
      if (lookahead == '`') ADVANCE(68);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(6);
      if (lookahead != 0 &&
          lookahead != ',' &&
          lookahead != ']') ADVANCE(69);
      END_STATE();
    case 7:
      if (lookahead == '"') ADVANCE(59);
      if (lookahead == '/') ADVANCE(66);
      if (lookahead == '=') ADVANCE(67);
      if (lookahead == '`') ADVANCE(68);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(7);
      if (lookahead != 0 &&
          lookahead != ',' &&
          lookahead != '[' &&
          lookahead != ']') ADVANCE(69);
      END_STATE();
    case 8:
      if (lookahead == '"') ADVANCE(59);
      if (lookahead == '/') ADVANCE(66);
      if (lookahead == '`') ADVANCE(68);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(8);
      if (lookahead != 0 &&
          lookahead != ',' &&
          lookahead != '[' &&
          lookahead != ']') ADVANCE(69);
      END_STATE();
    case 9:
      if (lookahead == '/') ADVANCE(88);
      END_STATE();
    case 10:
      if (lookahead == '>') ADVANCE(81);
      END_STATE();
    case 11:
      if (lookahead == 'U') ADVANCE(53);
      if (lookahead == 'u') ADVANCE(49);
      if (lookahead == 'x') ADVANCE(47);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(65);
      if (lookahead != 0) ADVANCE(63);
      END_STATE();
    case 12:
      if (lookahead == '`') ADVANCE(56);
      if (lookahead != 0) ADVANCE(12);
      END_STATE();
    case 13:
      if (lookahead == 'a') ADVANCE(18);
      END_STATE();
    case 14:
      if (lookahead == 'a') ADVANCE(27);
      END_STATE();
    case 15:
      if (lookahead == 'a') ADVANCE(17);
      END_STATE();
    case 16:
      if (lookahead == 'c') ADVANCE(32);
      END_STATE();
    case 17:
      if (lookahead == 'c') ADVANCE(41);
      END_STATE();
    case 18:
      if (lookahead == 'c') ADVANCE(24);
      END_STATE();
    case 19:
      if (lookahead == 'd') ADVANCE(44);
      END_STATE();
    case 20:
      if (lookahead == 'd') ADVANCE(23);
      END_STATE();
    case 21:
      if (lookahead == 'e') ADVANCE(38);
      END_STATE();
    case 22:
      if (lookahead == 'e') ADVANCE(70);
      END_STATE();
    case 23:
      if (lookahead == 'e') ADVANCE(79);
      END_STATE();
    case 24:
      if (lookahead == 'e') ADVANCE(80);
      END_STATE();
    case 25:
      if (lookahead == 'e') ADVANCE(78);
      END_STATE();
    case 26:
      if (lookahead == 'h') ADVANCE(14);
      END_STATE();
    case 27:
      if (lookahead == 'i') ADVANCE(33);
      END_STATE();
    case 28:
      if (lookahead == 'i') ADVANCE(39);
      END_STATE();
    case 29:
      if (lookahead == 'l') ADVANCE(13);
      END_STATE();
    case 30:
      if (lookahead == 'l') ADVANCE(83);
      END_STATE();
    case 31:
      if (lookahead == 'l') ADVANCE(22);
      END_STATE();
    case 32:
      if (lookahead == 'l') ADVANCE(43);
      END_STATE();
    case 33:
      if (lookahead == 'n') ADVANCE(77);
      END_STATE();
    case 34:
      if (lookahead == 'o') ADVANCE(76);
      END_STATE();
    case 35:
      if (lookahead == 'o') ADVANCE(19);
      END_STATE();
    case 36:
      if (lookahead == 'o') ADVANCE(30);
      END_STATE();
    case 37:
      if (lookahead == 'o') ADVANCE(36);
      END_STATE();
    case 38:
      if (lookahead == 'p') ADVANCE(29);
      if (lookahead == 'q') ADVANCE(42);
      if (lookahead == 't') ADVANCE(40);
      END_STATE();
    case 39:
      if (lookahead == 'r') ADVANCE(25);
      END_STATE();
    case 40:
      if (lookahead == 'r') ADVANCE(15);
      END_STATE();
    case 41:
      if (lookahead == 't') ADVANCE(84);
      END_STATE();
    case 42:
      if (lookahead == 'u') ADVANCE(28);
      END_STATE();
    case 43:
      if (lookahead == 'u') ADVANCE(20);
      END_STATE();
    case 44:
      if (lookahead == 'u') ADVANCE(31);
      END_STATE();
    case 45:
      if (lookahead == 'x') ADVANCE(16);
      END_STATE();
    case 46:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(63);
      END_STATE();
    case 47:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(46);
      END_STATE();
    case 48:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(47);
      END_STATE();
    case 49:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(48);
      END_STATE();
    case 50:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(49);
      END_STATE();
    case 51:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(50);
      END_STATE();
    case 52:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(51);
      END_STATE();
    case 53:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(52);
      END_STATE();
    case 54:
      if (eof) ADVANCE(55);
      ADVANCE_MAP(
        '"', 58,
        '(', 71,
        ')', 74,
        ',', 86,
        '/', 9,
        '=', 10,
        '[', 85,
        ']', 87,
        '`', 12,
        'e', 45,
        'g', 34,
        'm', 35,
        'r', 21,
        't', 37,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(54);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(sym_raw_string_literal);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(sym_raw_string_literal);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ' &&
          lookahead != ',' &&
          lookahead != '[' &&
          lookahead != ']') ADVANCE(69);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ' &&
          lookahead != ',' &&
          lookahead != '[' &&
          lookahead != ']') ADVANCE(69);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(aux_sym_interpreted_string_literal_token1);
      if (lookahead == '/') ADVANCE(61);
      if (lookahead == '\t' ||
          (0x0b <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(60);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(62);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(aux_sym_interpreted_string_literal_token1);
      if (lookahead == '/') ADVANCE(62);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(62);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(aux_sym_interpreted_string_literal_token1);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(62);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(63);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(64);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == '/') ADVANCE(89);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ' &&
          lookahead != ',' &&
          lookahead != '[' &&
          lookahead != ']') ADVANCE(69);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == '>') ADVANCE(82);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ' &&
          lookahead != ',' &&
          lookahead != '[' &&
          lookahead != ']') ADVANCE(69);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == '`') ADVANCE(57);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == ',' ||
          lookahead == '[' ||
          lookahead == ']') ADVANCE(12);
      if (lookahead != 0) ADVANCE(68);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ' &&
          lookahead != ',' &&
          lookahead != '[' &&
          lookahead != ']') ADVANCE(69);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(anon_sym_module);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ' &&
          lookahead != ',' &&
          lookahead != '[' &&
          lookahead != ']') ADVANCE(69);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(73);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ' &&
          lookahead != ',' &&
          lookahead != '[' &&
          lookahead != ']') ADVANCE(69);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(anon_sym_go);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(anon_sym_toolchain);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(anon_sym_require);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_exclude);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(anon_sym_replace);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_EQ_GT);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(anon_sym_EQ_GT);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ' &&
          lookahead != ',' &&
          lookahead != '[' &&
          lookahead != ']') ADVANCE(69);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(anon_sym_tool);
      if (lookahead == 'c') ADVANCE(26);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(anon_sym_retract);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(anon_sym_SLASH_SLASH);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(anon_sym_SLASH_SLASH);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ' &&
          lookahead != ',' &&
          lookahead != '[' &&
          lookahead != ']') ADVANCE(69);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(anon_sym_SLASH_SLASH);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(93);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(aux_sym_comment_token1);
      if (lookahead == '/') ADVANCE(92);
      if (lookahead == '\t' ||
          (0x0b <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(91);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(93);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(aux_sym_comment_token1);
      if (lookahead == '/') ADVANCE(90);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(93);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(aux_sym_comment_token1);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(93);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 0},
  [2] = {.lex_state = 0},
  [3] = {.lex_state = 0},
  [4] = {.lex_state = 0},
  [5] = {.lex_state = 0},
  [6] = {.lex_state = 0},
  [7] = {.lex_state = 0},
  [8] = {.lex_state = 6},
  [9] = {.lex_state = 6},
  [10] = {.lex_state = 6},
  [11] = {.lex_state = 5},
  [12] = {.lex_state = 6},
  [13] = {.lex_state = 6},
  [14] = {.lex_state = 6},
  [15] = {.lex_state = 6},
  [16] = {.lex_state = 6},
  [17] = {.lex_state = 6},
  [18] = {.lex_state = 6},
  [19] = {.lex_state = 6},
  [20] = {.lex_state = 6},
  [21] = {.lex_state = 0},
  [22] = {.lex_state = 0},
  [23] = {.lex_state = 0},
  [24] = {.lex_state = 0},
  [25] = {.lex_state = 0},
  [26] = {.lex_state = 0},
  [27] = {.lex_state = 0},
  [28] = {.lex_state = 0},
  [29] = {.lex_state = 0},
  [30] = {.lex_state = 5},
  [31] = {.lex_state = 5},
  [32] = {.lex_state = 0},
  [33] = {.lex_state = 5},
  [34] = {.lex_state = 6},
  [35] = {.lex_state = 0},
  [36] = {.lex_state = 0},
  [37] = {.lex_state = 0},
  [38] = {.lex_state = 0},
  [39] = {.lex_state = 6},
  [40] = {.lex_state = 0},
  [41] = {.lex_state = 0},
  [42] = {.lex_state = 0},
  [43] = {.lex_state = 0},
  [44] = {.lex_state = 0},
  [45] = {.lex_state = 6},
  [46] = {.lex_state = 0},
  [47] = {.lex_state = 0},
  [48] = {.lex_state = 0},
  [49] = {.lex_state = 0},
  [50] = {.lex_state = 0},
  [51] = {.lex_state = 0},
  [52] = {.lex_state = 0},
  [53] = {.lex_state = 0},
  [54] = {.lex_state = 0},
  [55] = {.lex_state = 0},
  [56] = {.lex_state = 0},
  [57] = {.lex_state = 0},
  [58] = {.lex_state = 8},
  [59] = {.lex_state = 7},
  [60] = {.lex_state = 7},
  [61] = {.lex_state = 5},
  [62] = {.lex_state = 5},
  [63] = {.lex_state = 8},
  [64] = {.lex_state = 8},
  [65] = {.lex_state = 8},
  [66] = {.lex_state = 8},
  [67] = {.lex_state = 8},
  [68] = {.lex_state = 8},
  [69] = {.lex_state = 8},
  [70] = {.lex_state = 8},
  [71] = {.lex_state = 8},
  [72] = {.lex_state = 8},
  [73] = {.lex_state = 8},
  [74] = {.lex_state = 8},
  [75] = {.lex_state = 8},
  [76] = {.lex_state = 8},
  [77] = {.lex_state = 8},
  [78] = {.lex_state = 8},
  [79] = {.lex_state = 8},
  [80] = {.lex_state = 8},
  [81] = {.lex_state = 6},
  [82] = {.lex_state = 6},
  [83] = {.lex_state = 6},
  [84] = {.lex_state = 6},
  [85] = {.lex_state = 6},
  [86] = {.lex_state = 1},
  [87] = {.lex_state = 2},
  [88] = {.lex_state = 1},
  [89] = {.lex_state = 1},
  [90] = {.lex_state = 6},
  [91] = {.lex_state = 6},
  [92] = {.lex_state = 6},
  [93] = {.lex_state = 6},
  [94] = {.lex_state = 6},
  [95] = {.lex_state = 6},
  [96] = {.lex_state = 6},
  [97] = {.lex_state = 7},
  [98] = {.lex_state = 7},
  [99] = {.lex_state = 7},
  [100] = {.lex_state = 7},
  [101] = {.lex_state = 7},
  [102] = {.lex_state = 6},
  [103] = {.lex_state = 6},
  [104] = {.lex_state = 6},
  [105] = {.lex_state = 6},
  [106] = {.lex_state = 1},
  [107] = {.lex_state = 1},
  [108] = {.lex_state = 1},
  [109] = {.lex_state = 1},
  [110] = {.lex_state = 1},
  [111] = {.lex_state = 1},
  [112] = {.lex_state = 1},
  [113] = {.lex_state = 1},
  [114] = {.lex_state = 6},
  [115] = {.lex_state = 1},
  [116] = {.lex_state = 8},
  [117] = {.lex_state = 8},
  [118] = {.lex_state = 0},
  [119] = {.lex_state = 8},
  [120] = {.lex_state = 8},
  [121] = {.lex_state = 8},
  [122] = {.lex_state = 0},
  [123] = {.lex_state = 3},
  [124] = {.lex_state = 3},
  [125] = {.lex_state = 3},
  [126] = {.lex_state = 3},
  [127] = {.lex_state = 3},
  [128] = {.lex_state = 3},
  [129] = {.lex_state = 3},
  [130] = {.lex_state = 3},
  [131] = {.lex_state = 3},
  [132] = {.lex_state = 3},
  [133] = {.lex_state = 3},
  [134] = {.lex_state = 3},
  [135] = {.lex_state = 91},
  [136] = {.lex_state = 3},
  [137] = {.lex_state = 3},
  [138] = {.lex_state = 3},
  [139] = {.lex_state = 3},
  [140] = {.lex_state = 0},
  [141] = {.lex_state = 3},
  [142] = {.lex_state = 0},
  [143] = {.lex_state = 0},
  [144] = {.lex_state = 3},
  [145] = {.lex_state = 3},
  [146] = {.lex_state = 3},
  [147] = {.lex_state = 3},
  [148] = {.lex_state = 3},
  [149] = {.lex_state = 3},
  [150] = {.lex_state = 3},
  [151] = {.lex_state = 3},
  [152] = {.lex_state = 3},
  [153] = {.lex_state = 3},
  [154] = {.lex_state = 3},
  [155] = {.lex_state = 3},
  [156] = {.lex_state = 3},
  [157] = {.lex_state = 3},
  [158] = {.lex_state = 3},
  [159] = {.lex_state = 3},
  [160] = {.lex_state = 3},
  [161] = {.lex_state = 3},
  [162] = {.lex_state = 3},
  [163] = {.lex_state = 3},
  [164] = {.lex_state = 0},
  [165] = {.lex_state = 3},
  [166] = {.lex_state = 0},
  [167] = {.lex_state = 0},
  [168] = {.lex_state = 0},
  [169] = {.lex_state = 3},
  [170] = {(TSStateId)(-1)},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [sym_comment] = STATE(0),
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_raw_string_literal] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [sym_escape_sequence] = ACTIONS(1),
    [anon_sym_module] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_go] = ACTIONS(1),
    [anon_sym_toolchain] = ACTIONS(1),
    [anon_sym_require] = ACTIONS(1),
    [anon_sym_exclude] = ACTIONS(1),
    [anon_sym_replace] = ACTIONS(1),
    [anon_sym_EQ_GT] = ACTIONS(1),
    [anon_sym_tool] = ACTIONS(1),
    [anon_sym_retract] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
  },
  [1] = {
    [sym_source_file] = STATE(142),
    [sym__directive] = STATE(36),
    [sym_module_directive] = STATE(37),
    [sym_go_directive] = STATE(37),
    [sym_toolchain_directive] = STATE(37),
    [sym_require_directive] = STATE(37),
    [sym_exclude_directive] = STATE(37),
    [sym_replace_directive] = STATE(37),
    [sym_tool_directive] = STATE(37),
    [sym_retract_directive] = STATE(37),
    [sym_comment] = STATE(1),
    [aux_sym_source_file_repeat1] = STATE(3),
    [ts_builtin_sym_end] = ACTIONS(5),
    [anon_sym_module] = ACTIONS(7),
    [anon_sym_go] = ACTIONS(9),
    [anon_sym_toolchain] = ACTIONS(11),
    [anon_sym_require] = ACTIONS(13),
    [anon_sym_exclude] = ACTIONS(15),
    [anon_sym_replace] = ACTIONS(17),
    [anon_sym_tool] = ACTIONS(19),
    [anon_sym_retract] = ACTIONS(21),
    [anon_sym_SLASH_SLASH] = ACTIONS(3),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 13,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(23), 1,
      ts_builtin_sym_end,
    ACTIONS(25), 1,
      anon_sym_module,
    ACTIONS(28), 1,
      anon_sym_go,
    ACTIONS(31), 1,
      anon_sym_toolchain,
    ACTIONS(34), 1,
      anon_sym_require,
    ACTIONS(37), 1,
      anon_sym_exclude,
    ACTIONS(40), 1,
      anon_sym_replace,
    ACTIONS(43), 1,
      anon_sym_tool,
    ACTIONS(46), 1,
      anon_sym_retract,
    STATE(36), 1,
      sym__directive,
    STATE(2), 2,
      sym_comment,
      aux_sym_source_file_repeat1,
    STATE(37), 8,
      sym_module_directive,
      sym_go_directive,
      sym_toolchain_directive,
      sym_require_directive,
      sym_exclude_directive,
      sym_replace_directive,
      sym_tool_directive,
      sym_retract_directive,
  [48] = 14,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(7), 1,
      anon_sym_module,
    ACTIONS(9), 1,
      anon_sym_go,
    ACTIONS(11), 1,
      anon_sym_toolchain,
    ACTIONS(13), 1,
      anon_sym_require,
    ACTIONS(15), 1,
      anon_sym_exclude,
    ACTIONS(17), 1,
      anon_sym_replace,
    ACTIONS(19), 1,
      anon_sym_tool,
    ACTIONS(21), 1,
      anon_sym_retract,
    ACTIONS(49), 1,
      ts_builtin_sym_end,
    STATE(2), 1,
      aux_sym_source_file_repeat1,
    STATE(3), 1,
      sym_comment,
    STATE(36), 1,
      sym__directive,
    STATE(37), 8,
      sym_module_directive,
      sym_go_directive,
      sym_toolchain_directive,
      sym_require_directive,
      sym_exclude_directive,
      sym_replace_directive,
      sym_tool_directive,
      sym_retract_directive,
  [98] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(53), 1,
      anon_sym_tool,
    STATE(4), 1,
      sym_comment,
    ACTIONS(51), 11,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_go,
      anon_sym_toolchain,
      anon_sym_require,
      anon_sym_exclude,
      anon_sym_replace,
      anon_sym_EQ_GT,
      anon_sym_retract,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [121] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(57), 1,
      anon_sym_tool,
    STATE(5), 1,
      sym_comment,
    ACTIONS(55), 11,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_go,
      anon_sym_toolchain,
      anon_sym_require,
      anon_sym_exclude,
      anon_sym_replace,
      anon_sym_EQ_GT,
      anon_sym_retract,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [144] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(61), 1,
      anon_sym_tool,
    STATE(6), 1,
      sym_comment,
    ACTIONS(59), 11,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_go,
      anon_sym_toolchain,
      anon_sym_require,
      anon_sym_exclude,
      anon_sym_replace,
      anon_sym_EQ_GT,
      anon_sym_retract,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [167] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(65), 1,
      anon_sym_tool,
    STATE(7), 1,
      sym_comment,
    ACTIONS(63), 11,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_go,
      anon_sym_toolchain,
      anon_sym_require,
      anon_sym_exclude,
      anon_sym_replace,
      anon_sym_EQ_GT,
      anon_sym_retract,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [190] = 13,
    ACTIONS(67), 1,
      sym_raw_string_literal,
    ACTIONS(69), 1,
      anon_sym_DQUOTE,
    ACTIONS(71), 1,
      sym__identifier,
    ACTIONS(73), 1,
      anon_sym_RPAREN,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    STATE(8), 1,
      sym_comment,
    STATE(9), 1,
      aux_sym_retract_directive_repeat1,
    STATE(81), 1,
      sym_retract_spec,
    STATE(144), 1,
      sym_version,
    STATE(145), 1,
      sym__string_or_ident,
    STATE(146), 1,
      sym__string_literal,
    STATE(163), 1,
      sym_interpreted_string_literal,
  [230] = 13,
    ACTIONS(67), 1,
      sym_raw_string_literal,
    ACTIONS(69), 1,
      anon_sym_DQUOTE,
    ACTIONS(71), 1,
      sym__identifier,
    ACTIONS(75), 1,
      anon_sym_LBRACK,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(79), 1,
      anon_sym_RPAREN,
    STATE(9), 1,
      sym_comment,
    STATE(10), 1,
      aux_sym_retract_directive_repeat1,
    STATE(81), 1,
      sym_retract_spec,
    STATE(144), 1,
      sym_version,
    STATE(145), 1,
      sym__string_or_ident,
    STATE(146), 1,
      sym__string_literal,
    STATE(163), 1,
      sym_interpreted_string_literal,
  [270] = 12,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(81), 1,
      sym_raw_string_literal,
    ACTIONS(84), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      sym__identifier,
    ACTIONS(90), 1,
      anon_sym_RPAREN,
    ACTIONS(92), 1,
      anon_sym_LBRACK,
    STATE(81), 1,
      sym_retract_spec,
    STATE(144), 1,
      sym_version,
    STATE(145), 1,
      sym__string_or_ident,
    STATE(146), 1,
      sym__string_literal,
    STATE(163), 1,
      sym_interpreted_string_literal,
    STATE(10), 2,
      sym_comment,
      aux_sym_retract_directive_repeat1,
  [308] = 12,
    ACTIONS(67), 1,
      sym_raw_string_literal,
    ACTIONS(69), 1,
      anon_sym_DQUOTE,
    ACTIONS(71), 1,
      sym__identifier,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(95), 1,
      anon_sym_LPAREN,
    ACTIONS(97), 1,
      anon_sym_LBRACK,
    STATE(11), 1,
      sym_comment,
    STATE(29), 1,
      sym_retract_spec,
    STATE(145), 1,
      sym__string_or_ident,
    STATE(146), 1,
      sym__string_literal,
    STATE(152), 1,
      sym_version,
    STATE(163), 1,
      sym_interpreted_string_literal,
  [345] = 12,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(99), 1,
      sym_raw_string_literal,
    ACTIONS(101), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      sym__identifier,
    ACTIONS(105), 1,
      anon_sym_RPAREN,
    STATE(12), 1,
      sym_comment,
    STATE(16), 1,
      aux_sym_require_directive_repeat1,
    STATE(76), 1,
      sym_module_path,
    STATE(90), 1,
      sym_require_spec,
    STATE(117), 1,
      sym__string_or_ident,
    STATE(119), 1,
      sym_interpreted_string_literal,
    STATE(120), 1,
      sym__string_literal,
  [382] = 12,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(99), 1,
      sym_raw_string_literal,
    ACTIONS(101), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      sym__identifier,
    ACTIONS(107), 1,
      anon_sym_RPAREN,
    STATE(13), 1,
      sym_comment,
    STATE(15), 1,
      aux_sym_exclude_directive_repeat1,
    STATE(77), 1,
      sym_module_path,
    STATE(114), 1,
      sym_exclude_spec,
    STATE(117), 1,
      sym__string_or_ident,
    STATE(119), 1,
      sym_interpreted_string_literal,
    STATE(120), 1,
      sym__string_literal,
  [419] = 12,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(109), 1,
      sym_raw_string_literal,
    ACTIONS(111), 1,
      anon_sym_DQUOTE,
    ACTIONS(113), 1,
      sym__identifier,
    ACTIONS(115), 1,
      anon_sym_RPAREN,
    STATE(14), 1,
      sym_comment,
    STATE(19), 1,
      aux_sym_replace_directive_repeat1,
    STATE(60), 1,
      sym_module_path,
    STATE(85), 1,
      sym_replace_spec,
    STATE(97), 1,
      sym__string_or_ident,
    STATE(98), 1,
      sym_interpreted_string_literal,
    STATE(99), 1,
      sym__string_literal,
  [456] = 12,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(99), 1,
      sym_raw_string_literal,
    ACTIONS(101), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      sym__identifier,
    ACTIONS(117), 1,
      anon_sym_RPAREN,
    STATE(15), 1,
      sym_comment,
    STATE(18), 1,
      aux_sym_exclude_directive_repeat1,
    STATE(77), 1,
      sym_module_path,
    STATE(114), 1,
      sym_exclude_spec,
    STATE(117), 1,
      sym__string_or_ident,
    STATE(119), 1,
      sym_interpreted_string_literal,
    STATE(120), 1,
      sym__string_literal,
  [493] = 12,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(99), 1,
      sym_raw_string_literal,
    ACTIONS(101), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      sym__identifier,
    ACTIONS(119), 1,
      anon_sym_RPAREN,
    STATE(16), 1,
      sym_comment,
    STATE(17), 1,
      aux_sym_require_directive_repeat1,
    STATE(76), 1,
      sym_module_path,
    STATE(90), 1,
      sym_require_spec,
    STATE(117), 1,
      sym__string_or_ident,
    STATE(119), 1,
      sym_interpreted_string_literal,
    STATE(120), 1,
      sym__string_literal,
  [530] = 11,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(121), 1,
      sym_raw_string_literal,
    ACTIONS(124), 1,
      anon_sym_DQUOTE,
    ACTIONS(127), 1,
      sym__identifier,
    ACTIONS(130), 1,
      anon_sym_RPAREN,
    STATE(76), 1,
      sym_module_path,
    STATE(90), 1,
      sym_require_spec,
    STATE(117), 1,
      sym__string_or_ident,
    STATE(119), 1,
      sym_interpreted_string_literal,
    STATE(120), 1,
      sym__string_literal,
    STATE(17), 2,
      sym_comment,
      aux_sym_require_directive_repeat1,
  [565] = 11,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(132), 1,
      sym_raw_string_literal,
    ACTIONS(135), 1,
      anon_sym_DQUOTE,
    ACTIONS(138), 1,
      sym__identifier,
    ACTIONS(141), 1,
      anon_sym_RPAREN,
    STATE(77), 1,
      sym_module_path,
    STATE(114), 1,
      sym_exclude_spec,
    STATE(117), 1,
      sym__string_or_ident,
    STATE(119), 1,
      sym_interpreted_string_literal,
    STATE(120), 1,
      sym__string_literal,
    STATE(18), 2,
      sym_comment,
      aux_sym_exclude_directive_repeat1,
  [600] = 12,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(109), 1,
      sym_raw_string_literal,
    ACTIONS(111), 1,
      anon_sym_DQUOTE,
    ACTIONS(113), 1,
      sym__identifier,
    ACTIONS(143), 1,
      anon_sym_RPAREN,
    STATE(19), 1,
      sym_comment,
    STATE(20), 1,
      aux_sym_replace_directive_repeat1,
    STATE(60), 1,
      sym_module_path,
    STATE(85), 1,
      sym_replace_spec,
    STATE(97), 1,
      sym__string_or_ident,
    STATE(98), 1,
      sym_interpreted_string_literal,
    STATE(99), 1,
      sym__string_literal,
  [637] = 11,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(145), 1,
      sym_raw_string_literal,
    ACTIONS(148), 1,
      anon_sym_DQUOTE,
    ACTIONS(151), 1,
      sym__identifier,
    ACTIONS(154), 1,
      anon_sym_RPAREN,
    STATE(60), 1,
      sym_module_path,
    STATE(85), 1,
      sym_replace_spec,
    STATE(97), 1,
      sym__string_or_ident,
    STATE(98), 1,
      sym_interpreted_string_literal,
    STATE(99), 1,
      sym__string_literal,
    STATE(20), 2,
      sym_comment,
      aux_sym_replace_directive_repeat1,
  [672] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(158), 1,
      anon_sym_tool,
    STATE(21), 1,
      sym_comment,
    ACTIONS(156), 8,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_go,
      anon_sym_toolchain,
      anon_sym_require,
      anon_sym_exclude,
      anon_sym_replace,
      anon_sym_retract,
  [692] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(162), 1,
      anon_sym_tool,
    STATE(22), 1,
      sym_comment,
    ACTIONS(160), 8,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_go,
      anon_sym_toolchain,
      anon_sym_require,
      anon_sym_exclude,
      anon_sym_replace,
      anon_sym_retract,
  [712] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(166), 1,
      anon_sym_tool,
    STATE(23), 1,
      sym_comment,
    ACTIONS(164), 8,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_go,
      anon_sym_toolchain,
      anon_sym_require,
      anon_sym_exclude,
      anon_sym_replace,
      anon_sym_retract,
  [732] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(170), 1,
      anon_sym_tool,
    STATE(24), 1,
      sym_comment,
    ACTIONS(168), 8,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_go,
      anon_sym_toolchain,
      anon_sym_require,
      anon_sym_exclude,
      anon_sym_replace,
      anon_sym_retract,
  [752] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(174), 1,
      anon_sym_tool,
    STATE(25), 1,
      sym_comment,
    ACTIONS(172), 8,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_go,
      anon_sym_toolchain,
      anon_sym_require,
      anon_sym_exclude,
      anon_sym_replace,
      anon_sym_retract,
  [772] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(178), 1,
      anon_sym_tool,
    STATE(26), 1,
      sym_comment,
    ACTIONS(176), 8,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_go,
      anon_sym_toolchain,
      anon_sym_require,
      anon_sym_exclude,
      anon_sym_replace,
      anon_sym_retract,
  [792] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(182), 1,
      anon_sym_tool,
    STATE(27), 1,
      sym_comment,
    ACTIONS(180), 8,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_go,
      anon_sym_toolchain,
      anon_sym_require,
      anon_sym_exclude,
      anon_sym_replace,
      anon_sym_retract,
  [812] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(186), 1,
      anon_sym_tool,
    STATE(28), 1,
      sym_comment,
    ACTIONS(184), 8,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_go,
      anon_sym_toolchain,
      anon_sym_require,
      anon_sym_exclude,
      anon_sym_replace,
      anon_sym_retract,
  [832] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(190), 1,
      anon_sym_tool,
    STATE(29), 1,
      sym_comment,
    ACTIONS(188), 8,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_go,
      anon_sym_toolchain,
      anon_sym_require,
      anon_sym_exclude,
      anon_sym_replace,
      anon_sym_retract,
  [852] = 11,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(99), 1,
      sym_raw_string_literal,
    ACTIONS(101), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      sym__identifier,
    ACTIONS(192), 1,
      anon_sym_LPAREN,
    STATE(24), 1,
      sym_require_spec,
    STATE(30), 1,
      sym_comment,
    STATE(70), 1,
      sym_module_path,
    STATE(117), 1,
      sym__string_or_ident,
    STATE(119), 1,
      sym_interpreted_string_literal,
    STATE(120), 1,
      sym__string_literal,
  [886] = 11,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(99), 1,
      sym_raw_string_literal,
    ACTIONS(101), 1,
      anon_sym_DQUOTE,
    ACTIONS(103), 1,
      sym__identifier,
    ACTIONS(194), 1,
      anon_sym_LPAREN,
    STATE(25), 1,
      sym_exclude_spec,
    STATE(31), 1,
      sym_comment,
    STATE(66), 1,
      sym_module_path,
    STATE(117), 1,
      sym__string_or_ident,
    STATE(119), 1,
      sym_interpreted_string_literal,
    STATE(120), 1,
      sym__string_literal,
  [920] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(198), 1,
      anon_sym_tool,
    STATE(32), 1,
      sym_comment,
    ACTIONS(196), 8,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_go,
      anon_sym_toolchain,
      anon_sym_require,
      anon_sym_exclude,
      anon_sym_replace,
      anon_sym_retract,
  [940] = 11,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(109), 1,
      sym_raw_string_literal,
    ACTIONS(111), 1,
      anon_sym_DQUOTE,
    ACTIONS(113), 1,
      sym__identifier,
    ACTIONS(200), 1,
      anon_sym_LPAREN,
    STATE(26), 1,
      sym_replace_spec,
    STATE(33), 1,
      sym_comment,
    STATE(59), 1,
      sym_module_path,
    STATE(97), 1,
      sym__string_or_ident,
    STATE(98), 1,
      sym_interpreted_string_literal,
    STATE(99), 1,
      sym__string_literal,
  [974] = 11,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(202), 1,
      sym_raw_string_literal,
    ACTIONS(204), 1,
      anon_sym_DQUOTE,
    ACTIONS(206), 1,
      sym__identifier,
    ACTIONS(208), 1,
      anon_sym_RPAREN,
    STATE(34), 1,
      sym_comment,
    STATE(39), 1,
      aux_sym_tool_directive_repeat1,
    STATE(84), 1,
      sym__string_or_ident,
    STATE(96), 1,
      sym_tool,
    STATE(102), 1,
      sym_interpreted_string_literal,
    STATE(103), 1,
      sym__string_literal,
  [1008] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(212), 1,
      anon_sym_tool,
    STATE(35), 1,
      sym_comment,
    ACTIONS(210), 8,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_go,
      anon_sym_toolchain,
      anon_sym_require,
      anon_sym_exclude,
      anon_sym_replace,
      anon_sym_retract,
  [1028] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(216), 1,
      anon_sym_tool,
    STATE(36), 1,
      sym_comment,
    ACTIONS(214), 8,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_go,
      anon_sym_toolchain,
      anon_sym_require,
      anon_sym_exclude,
      anon_sym_replace,
      anon_sym_retract,
  [1048] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(220), 1,
      anon_sym_tool,
    STATE(37), 1,
      sym_comment,
    ACTIONS(218), 8,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_go,
      anon_sym_toolchain,
      anon_sym_require,
      anon_sym_exclude,
      anon_sym_replace,
      anon_sym_retract,
  [1068] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(224), 1,
      anon_sym_tool,
    STATE(38), 1,
      sym_comment,
    ACTIONS(222), 8,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_go,
      anon_sym_toolchain,
      anon_sym_require,
      anon_sym_exclude,
      anon_sym_replace,
      anon_sym_retract,
  [1088] = 11,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(202), 1,
      sym_raw_string_literal,
    ACTIONS(204), 1,
      anon_sym_DQUOTE,
    ACTIONS(206), 1,
      sym__identifier,
    ACTIONS(226), 1,
      anon_sym_RPAREN,
    STATE(39), 1,
      sym_comment,
    STATE(45), 1,
      aux_sym_tool_directive_repeat1,
    STATE(84), 1,
      sym__string_or_ident,
    STATE(96), 1,
      sym_tool,
    STATE(102), 1,
      sym_interpreted_string_literal,
    STATE(103), 1,
      sym__string_literal,
  [1122] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(230), 1,
      anon_sym_tool,
    STATE(40), 1,
      sym_comment,
    ACTIONS(228), 8,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_go,
      anon_sym_toolchain,
      anon_sym_require,
      anon_sym_exclude,
      anon_sym_replace,
      anon_sym_retract,
  [1142] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(234), 1,
      anon_sym_tool,
    STATE(41), 1,
      sym_comment,
    ACTIONS(232), 8,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_go,
      anon_sym_toolchain,
      anon_sym_require,
      anon_sym_exclude,
      anon_sym_replace,
      anon_sym_retract,
  [1162] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(238), 1,
      anon_sym_tool,
    STATE(42), 1,
      sym_comment,
    ACTIONS(236), 8,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_go,
      anon_sym_toolchain,
      anon_sym_require,
      anon_sym_exclude,
      anon_sym_replace,
      anon_sym_retract,
  [1182] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(242), 1,
      anon_sym_tool,
    STATE(43), 1,
      sym_comment,
    ACTIONS(240), 8,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_go,
      anon_sym_toolchain,
      anon_sym_require,
      anon_sym_exclude,
      anon_sym_replace,
      anon_sym_retract,
  [1202] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(246), 1,
      anon_sym_tool,
    STATE(44), 1,
      sym_comment,
    ACTIONS(244), 8,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_go,
      anon_sym_toolchain,
      anon_sym_require,
      anon_sym_exclude,
      anon_sym_replace,
      anon_sym_retract,
  [1222] = 10,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(248), 1,
      sym_raw_string_literal,
    ACTIONS(251), 1,
      anon_sym_DQUOTE,
    ACTIONS(254), 1,
      sym__identifier,
    ACTIONS(257), 1,
      anon_sym_RPAREN,
    STATE(84), 1,
      sym__string_or_ident,
    STATE(96), 1,
      sym_tool,
    STATE(102), 1,
      sym_interpreted_string_literal,
    STATE(103), 1,
      sym__string_literal,
    STATE(45), 2,
      sym_comment,
      aux_sym_tool_directive_repeat1,
  [1254] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(261), 1,
      anon_sym_tool,
    STATE(46), 1,
      sym_comment,
    ACTIONS(259), 8,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_go,
      anon_sym_toolchain,
      anon_sym_require,
      anon_sym_exclude,
      anon_sym_replace,
      anon_sym_retract,
  [1274] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(265), 1,
      anon_sym_tool,
    STATE(47), 1,
      sym_comment,
    ACTIONS(263), 8,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_go,
      anon_sym_toolchain,
      anon_sym_require,
      anon_sym_exclude,
      anon_sym_replace,
      anon_sym_retract,
  [1294] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(269), 1,
      anon_sym_tool,
    STATE(48), 1,
      sym_comment,
    ACTIONS(267), 8,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_go,
      anon_sym_toolchain,
      anon_sym_require,
      anon_sym_exclude,
      anon_sym_replace,
      anon_sym_retract,
  [1314] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(273), 1,
      anon_sym_tool,
    STATE(49), 1,
      sym_comment,
    ACTIONS(271), 8,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_go,
      anon_sym_toolchain,
      anon_sym_require,
      anon_sym_exclude,
      anon_sym_replace,
      anon_sym_retract,
  [1334] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(277), 1,
      anon_sym_tool,
    STATE(50), 1,
      sym_comment,
    ACTIONS(275), 8,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_go,
      anon_sym_toolchain,
      anon_sym_require,
      anon_sym_exclude,
      anon_sym_replace,
      anon_sym_retract,
  [1354] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(281), 1,
      anon_sym_tool,
    STATE(51), 1,
      sym_comment,
    ACTIONS(279), 8,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_go,
      anon_sym_toolchain,
      anon_sym_require,
      anon_sym_exclude,
      anon_sym_replace,
      anon_sym_retract,
  [1374] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(285), 1,
      anon_sym_tool,
    STATE(52), 1,
      sym_comment,
    ACTIONS(283), 8,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_go,
      anon_sym_toolchain,
      anon_sym_require,
      anon_sym_exclude,
      anon_sym_replace,
      anon_sym_retract,
  [1394] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(289), 1,
      anon_sym_tool,
    STATE(53), 1,
      sym_comment,
    ACTIONS(287), 8,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_go,
      anon_sym_toolchain,
      anon_sym_require,
      anon_sym_exclude,
      anon_sym_replace,
      anon_sym_retract,
  [1414] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(293), 1,
      anon_sym_tool,
    STATE(54), 1,
      sym_comment,
    ACTIONS(291), 8,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_go,
      anon_sym_toolchain,
      anon_sym_require,
      anon_sym_exclude,
      anon_sym_replace,
      anon_sym_retract,
  [1434] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(297), 1,
      anon_sym_tool,
    STATE(55), 1,
      sym_comment,
    ACTIONS(295), 8,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_go,
      anon_sym_toolchain,
      anon_sym_require,
      anon_sym_exclude,
      anon_sym_replace,
      anon_sym_retract,
  [1454] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(301), 1,
      anon_sym_tool,
    STATE(56), 1,
      sym_comment,
    ACTIONS(299), 8,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_go,
      anon_sym_toolchain,
      anon_sym_require,
      anon_sym_exclude,
      anon_sym_replace,
      anon_sym_retract,
  [1474] = 4,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(305), 1,
      anon_sym_tool,
    STATE(57), 1,
      sym_comment,
    ACTIONS(303), 8,
      ts_builtin_sym_end,
      anon_sym_module,
      anon_sym_go,
      anon_sym_toolchain,
      anon_sym_require,
      anon_sym_exclude,
      anon_sym_replace,
      anon_sym_retract,
  [1494] = 10,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(99), 1,
      sym_raw_string_literal,
    ACTIONS(101), 1,
      anon_sym_DQUOTE,
    ACTIONS(307), 1,
      sym__identifier,
    STATE(58), 1,
      sym_comment,
    STATE(68), 1,
      sym_module_path,
    STATE(117), 1,
      sym__string_or_ident,
    STATE(119), 1,
      sym_interpreted_string_literal,
    STATE(120), 1,
      sym__string_literal,
    STATE(128), 1,
      sym_file_path,
  [1525] = 10,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(309), 1,
      sym_raw_string_literal,
    ACTIONS(311), 1,
      anon_sym_DQUOTE,
    ACTIONS(313), 1,
      sym__identifier,
    ACTIONS(315), 1,
      anon_sym_EQ_GT,
    STATE(5), 1,
      sym_interpreted_string_literal,
    STATE(6), 1,
      sym__string_literal,
    STATE(59), 1,
      sym_comment,
    STATE(118), 1,
      sym__string_or_ident,
    STATE(122), 1,
      sym_version,
  [1556] = 10,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(309), 1,
      sym_raw_string_literal,
    ACTIONS(311), 1,
      anon_sym_DQUOTE,
    ACTIONS(313), 1,
      sym__identifier,
    ACTIONS(317), 1,
      anon_sym_EQ_GT,
    STATE(5), 1,
      sym_interpreted_string_literal,
    STATE(6), 1,
      sym__string_literal,
    STATE(60), 1,
      sym_comment,
    STATE(118), 1,
      sym__string_or_ident,
    STATE(166), 1,
      sym_version,
  [1587] = 10,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(309), 1,
      sym_raw_string_literal,
    ACTIONS(311), 1,
      anon_sym_DQUOTE,
    ACTIONS(313), 1,
      sym__identifier,
    ACTIONS(319), 1,
      anon_sym_LPAREN,
    STATE(5), 1,
      sym_interpreted_string_literal,
    STATE(6), 1,
      sym__string_literal,
    STATE(42), 1,
      sym__string_or_ident,
    STATE(47), 1,
      sym_module_path,
    STATE(61), 1,
      sym_comment,
  [1618] = 10,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(309), 1,
      sym_raw_string_literal,
    ACTIONS(311), 1,
      anon_sym_DQUOTE,
    ACTIONS(313), 1,
      sym__identifier,
    ACTIONS(321), 1,
      anon_sym_LPAREN,
    STATE(5), 1,
      sym_interpreted_string_literal,
    STATE(6), 1,
      sym__string_literal,
    STATE(27), 1,
      sym__string_or_ident,
    STATE(28), 1,
      sym_tool,
    STATE(62), 1,
      sym_comment,
  [1649] = 10,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(99), 1,
      sym_raw_string_literal,
    ACTIONS(101), 1,
      anon_sym_DQUOTE,
    ACTIONS(307), 1,
      sym__identifier,
    STATE(63), 1,
      sym_comment,
    STATE(75), 1,
      sym_module_path,
    STATE(117), 1,
      sym__string_or_ident,
    STATE(119), 1,
      sym_interpreted_string_literal,
    STATE(120), 1,
      sym__string_literal,
    STATE(126), 1,
      sym_file_path,
  [1680] = 10,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(99), 1,
      sym_raw_string_literal,
    ACTIONS(101), 1,
      anon_sym_DQUOTE,
    ACTIONS(307), 1,
      sym__identifier,
    STATE(64), 1,
      sym_comment,
    STATE(78), 1,
      sym_module_path,
    STATE(117), 1,
      sym__string_or_ident,
    STATE(119), 1,
      sym_interpreted_string_literal,
    STATE(120), 1,
      sym__string_literal,
    STATE(148), 1,
      sym_file_path,
  [1711] = 10,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(99), 1,
      sym_raw_string_literal,
    ACTIONS(101), 1,
      anon_sym_DQUOTE,
    ACTIONS(307), 1,
      sym__identifier,
    STATE(65), 1,
      sym_comment,
    STATE(79), 1,
      sym_module_path,
    STATE(117), 1,
      sym__string_or_ident,
    STATE(119), 1,
      sym_interpreted_string_literal,
    STATE(120), 1,
      sym__string_literal,
    STATE(149), 1,
      sym_file_path,
  [1742] = 9,
    ACTIONS(67), 1,
      sym_raw_string_literal,
    ACTIONS(69), 1,
      anon_sym_DQUOTE,
    ACTIONS(71), 1,
      sym__identifier,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    STATE(66), 1,
      sym_comment,
    STATE(131), 1,
      sym_version,
    STATE(145), 1,
      sym__string_or_ident,
    STATE(146), 1,
      sym__string_literal,
    STATE(163), 1,
      sym_interpreted_string_literal,
  [1770] = 9,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(309), 1,
      sym_raw_string_literal,
    ACTIONS(311), 1,
      anon_sym_DQUOTE,
    ACTIONS(313), 1,
      sym__identifier,
    STATE(5), 1,
      sym_interpreted_string_literal,
    STATE(6), 1,
      sym__string_literal,
    STATE(67), 1,
      sym_comment,
    STATE(118), 1,
      sym__string_or_ident,
    STATE(167), 1,
      sym_version,
  [1798] = 9,
    ACTIONS(67), 1,
      sym_raw_string_literal,
    ACTIONS(69), 1,
      anon_sym_DQUOTE,
    ACTIONS(71), 1,
      sym__identifier,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    STATE(68), 1,
      sym_comment,
    STATE(126), 1,
      sym_version,
    STATE(145), 1,
      sym__string_or_ident,
    STATE(146), 1,
      sym__string_literal,
    STATE(163), 1,
      sym_interpreted_string_literal,
  [1826] = 9,
    ACTIONS(67), 1,
      sym_raw_string_literal,
    ACTIONS(69), 1,
      anon_sym_DQUOTE,
    ACTIONS(71), 1,
      sym__identifier,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    STATE(69), 1,
      sym_comment,
    STATE(136), 1,
      sym__string_or_ident,
    STATE(146), 1,
      sym__string_literal,
    STATE(155), 1,
      sym_module_path,
    STATE(163), 1,
      sym_interpreted_string_literal,
  [1854] = 9,
    ACTIONS(67), 1,
      sym_raw_string_literal,
    ACTIONS(69), 1,
      anon_sym_DQUOTE,
    ACTIONS(71), 1,
      sym__identifier,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    STATE(70), 1,
      sym_comment,
    STATE(125), 1,
      sym_version,
    STATE(145), 1,
      sym__string_or_ident,
    STATE(146), 1,
      sym__string_literal,
    STATE(163), 1,
      sym_interpreted_string_literal,
  [1882] = 9,
    ACTIONS(67), 1,
      sym_raw_string_literal,
    ACTIONS(69), 1,
      anon_sym_DQUOTE,
    ACTIONS(71), 1,
      sym__identifier,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    STATE(71), 1,
      sym_comment,
    STATE(129), 1,
      sym_go_version,
    STATE(141), 1,
      sym__string_or_ident,
    STATE(146), 1,
      sym__string_literal,
    STATE(163), 1,
      sym_interpreted_string_literal,
  [1910] = 9,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(309), 1,
      sym_raw_string_literal,
    ACTIONS(311), 1,
      anon_sym_DQUOTE,
    ACTIONS(313), 1,
      sym__identifier,
    STATE(5), 1,
      sym_interpreted_string_literal,
    STATE(6), 1,
      sym__string_literal,
    STATE(72), 1,
      sym_comment,
    STATE(118), 1,
      sym__string_or_ident,
    STATE(140), 1,
      sym_version,
  [1938] = 9,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(309), 1,
      sym_raw_string_literal,
    ACTIONS(311), 1,
      anon_sym_DQUOTE,
    ACTIONS(313), 1,
      sym__identifier,
    STATE(5), 1,
      sym_interpreted_string_literal,
    STATE(6), 1,
      sym__string_literal,
    STATE(22), 1,
      sym__string_or_ident,
    STATE(23), 1,
      sym_toolchain_name,
    STATE(73), 1,
      sym_comment,
  [1966] = 9,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(309), 1,
      sym_raw_string_literal,
    ACTIONS(311), 1,
      anon_sym_DQUOTE,
    ACTIONS(313), 1,
      sym__identifier,
    STATE(5), 1,
      sym_interpreted_string_literal,
    STATE(6), 1,
      sym__string_literal,
    STATE(74), 1,
      sym_comment,
    STATE(118), 1,
      sym__string_or_ident,
    STATE(143), 1,
      sym_version,
  [1994] = 9,
    ACTIONS(67), 1,
      sym_raw_string_literal,
    ACTIONS(69), 1,
      anon_sym_DQUOTE,
    ACTIONS(71), 1,
      sym__identifier,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    STATE(75), 1,
      sym_comment,
    STATE(145), 1,
      sym__string_or_ident,
    STATE(146), 1,
      sym__string_literal,
    STATE(153), 1,
      sym_version,
    STATE(163), 1,
      sym_interpreted_string_literal,
  [2022] = 9,
    ACTIONS(67), 1,
      sym_raw_string_literal,
    ACTIONS(69), 1,
      anon_sym_DQUOTE,
    ACTIONS(71), 1,
      sym__identifier,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    STATE(76), 1,
      sym_comment,
    STATE(145), 1,
      sym__string_or_ident,
    STATE(146), 1,
      sym__string_literal,
    STATE(163), 1,
      sym_interpreted_string_literal,
    STATE(169), 1,
      sym_version,
  [2050] = 9,
    ACTIONS(67), 1,
      sym_raw_string_literal,
    ACTIONS(69), 1,
      anon_sym_DQUOTE,
    ACTIONS(71), 1,
      sym__identifier,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    STATE(77), 1,
      sym_comment,
    STATE(145), 1,
      sym__string_or_ident,
    STATE(146), 1,
      sym__string_literal,
    STATE(147), 1,
      sym_version,
    STATE(163), 1,
      sym_interpreted_string_literal,
  [2078] = 9,
    ACTIONS(67), 1,
      sym_raw_string_literal,
    ACTIONS(69), 1,
      anon_sym_DQUOTE,
    ACTIONS(71), 1,
      sym__identifier,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    STATE(78), 1,
      sym_comment,
    STATE(145), 1,
      sym__string_or_ident,
    STATE(146), 1,
      sym__string_literal,
    STATE(149), 1,
      sym_version,
    STATE(163), 1,
      sym_interpreted_string_literal,
  [2106] = 9,
    ACTIONS(67), 1,
      sym_raw_string_literal,
    ACTIONS(69), 1,
      anon_sym_DQUOTE,
    ACTIONS(71), 1,
      sym__identifier,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    STATE(79), 1,
      sym_comment,
    STATE(145), 1,
      sym__string_or_ident,
    STATE(146), 1,
      sym__string_literal,
    STATE(150), 1,
      sym_version,
    STATE(163), 1,
      sym_interpreted_string_literal,
  [2134] = 9,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(309), 1,
      sym_raw_string_literal,
    ACTIONS(311), 1,
      anon_sym_DQUOTE,
    ACTIONS(313), 1,
      sym__identifier,
    STATE(5), 1,
      sym_interpreted_string_literal,
    STATE(6), 1,
      sym__string_literal,
    STATE(80), 1,
      sym_comment,
    STATE(118), 1,
      sym__string_or_ident,
    STATE(164), 1,
      sym_version,
  [2162] = 4,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(325), 1,
      anon_sym_LBRACK,
    STATE(81), 1,
      sym_comment,
    ACTIONS(323), 4,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym__identifier,
      anon_sym_RPAREN,
  [2178] = 4,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(210), 1,
      anon_sym_LBRACK,
    STATE(82), 1,
      sym_comment,
    ACTIONS(212), 4,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym__identifier,
      anon_sym_RPAREN,
  [2194] = 4,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(299), 1,
      anon_sym_LBRACK,
    STATE(83), 1,
      sym_comment,
    ACTIONS(301), 4,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym__identifier,
      anon_sym_RPAREN,
  [2210] = 3,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    STATE(84), 1,
      sym_comment,
    ACTIONS(182), 4,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym__identifier,
      anon_sym_RPAREN,
  [2223] = 3,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    STATE(85), 1,
      sym_comment,
    ACTIONS(327), 4,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym__identifier,
      anon_sym_RPAREN,
  [2236] = 5,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(329), 1,
      anon_sym_DQUOTE,
    STATE(86), 1,
      sym_comment,
    STATE(88), 1,
      aux_sym_interpreted_string_literal_repeat1,
    ACTIONS(331), 2,
      aux_sym_interpreted_string_literal_token1,
      sym_escape_sequence,
  [2253] = 4,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(333), 1,
      anon_sym_LF,
    STATE(87), 1,
      sym_comment,
    ACTIONS(61), 3,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym__identifier,
  [2268] = 5,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(335), 1,
      anon_sym_DQUOTE,
    STATE(88), 1,
      sym_comment,
    STATE(89), 1,
      aux_sym_interpreted_string_literal_repeat1,
    ACTIONS(331), 2,
      aux_sym_interpreted_string_literal_token1,
      sym_escape_sequence,
  [2285] = 4,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(337), 1,
      anon_sym_DQUOTE,
    ACTIONS(339), 2,
      aux_sym_interpreted_string_literal_token1,
      sym_escape_sequence,
    STATE(89), 2,
      sym_comment,
      aux_sym_interpreted_string_literal_repeat1,
  [2300] = 3,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    STATE(90), 1,
      sym_comment,
    ACTIONS(342), 4,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym__identifier,
      anon_sym_RPAREN,
  [2313] = 3,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    STATE(91), 1,
      sym_comment,
    ACTIONS(305), 4,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym__identifier,
      anon_sym_RPAREN,
  [2326] = 3,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    STATE(92), 1,
      sym_comment,
    ACTIONS(224), 4,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym__identifier,
      anon_sym_RPAREN,
  [2339] = 3,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    STATE(93), 1,
      sym_comment,
    ACTIONS(242), 4,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym__identifier,
      anon_sym_RPAREN,
  [2352] = 3,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    STATE(94), 1,
      sym_comment,
    ACTIONS(285), 4,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym__identifier,
      anon_sym_RPAREN,
  [2365] = 3,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    STATE(95), 1,
      sym_comment,
    ACTIONS(297), 4,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym__identifier,
      anon_sym_RPAREN,
  [2378] = 3,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    STATE(96), 1,
      sym_comment,
    ACTIONS(344), 4,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym__identifier,
      anon_sym_RPAREN,
  [2391] = 3,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    STATE(97), 1,
      sym_comment,
    ACTIONS(238), 4,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym__identifier,
      anon_sym_EQ_GT,
  [2404] = 3,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    STATE(98), 1,
      sym_comment,
    ACTIONS(57), 4,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym__identifier,
      anon_sym_EQ_GT,
  [2417] = 3,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    STATE(99), 1,
      sym_comment,
    ACTIONS(61), 4,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym__identifier,
      anon_sym_EQ_GT,
  [2430] = 3,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    STATE(100), 1,
      sym_comment,
    ACTIONS(53), 4,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym__identifier,
      anon_sym_EQ_GT,
  [2443] = 3,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    STATE(101), 1,
      sym_comment,
    ACTIONS(65), 4,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym__identifier,
      anon_sym_EQ_GT,
  [2456] = 3,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    STATE(102), 1,
      sym_comment,
    ACTIONS(57), 4,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym__identifier,
      anon_sym_RPAREN,
  [2469] = 3,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    STATE(103), 1,
      sym_comment,
    ACTIONS(61), 4,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym__identifier,
      anon_sym_RPAREN,
  [2482] = 3,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    STATE(104), 1,
      sym_comment,
    ACTIONS(53), 4,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym__identifier,
      anon_sym_RPAREN,
  [2495] = 3,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    STATE(105), 1,
      sym_comment,
    ACTIONS(65), 4,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym__identifier,
      anon_sym_RPAREN,
  [2508] = 5,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(346), 1,
      anon_sym_DQUOTE,
    STATE(106), 1,
      sym_comment,
    STATE(107), 1,
      aux_sym_interpreted_string_literal_repeat1,
    ACTIONS(331), 2,
      aux_sym_interpreted_string_literal_token1,
      sym_escape_sequence,
  [2525] = 5,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(348), 1,
      anon_sym_DQUOTE,
    STATE(89), 1,
      aux_sym_interpreted_string_literal_repeat1,
    STATE(107), 1,
      sym_comment,
    ACTIONS(331), 2,
      aux_sym_interpreted_string_literal_token1,
      sym_escape_sequence,
  [2542] = 5,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(350), 1,
      anon_sym_DQUOTE,
    STATE(108), 1,
      sym_comment,
    STATE(109), 1,
      aux_sym_interpreted_string_literal_repeat1,
    ACTIONS(331), 2,
      aux_sym_interpreted_string_literal_token1,
      sym_escape_sequence,
  [2559] = 5,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(352), 1,
      anon_sym_DQUOTE,
    STATE(89), 1,
      aux_sym_interpreted_string_literal_repeat1,
    STATE(109), 1,
      sym_comment,
    ACTIONS(331), 2,
      aux_sym_interpreted_string_literal_token1,
      sym_escape_sequence,
  [2576] = 5,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(354), 1,
      anon_sym_DQUOTE,
    STATE(110), 1,
      sym_comment,
    STATE(111), 1,
      aux_sym_interpreted_string_literal_repeat1,
    ACTIONS(331), 2,
      aux_sym_interpreted_string_literal_token1,
      sym_escape_sequence,
  [2593] = 5,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(356), 1,
      anon_sym_DQUOTE,
    STATE(89), 1,
      aux_sym_interpreted_string_literal_repeat1,
    STATE(111), 1,
      sym_comment,
    ACTIONS(331), 2,
      aux_sym_interpreted_string_literal_token1,
      sym_escape_sequence,
  [2610] = 5,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(358), 1,
      anon_sym_DQUOTE,
    STATE(112), 1,
      sym_comment,
    STATE(113), 1,
      aux_sym_interpreted_string_literal_repeat1,
    ACTIONS(331), 2,
      aux_sym_interpreted_string_literal_token1,
      sym_escape_sequence,
  [2627] = 5,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(360), 1,
      anon_sym_DQUOTE,
    STATE(89), 1,
      aux_sym_interpreted_string_literal_repeat1,
    STATE(113), 1,
      sym_comment,
    ACTIONS(331), 2,
      aux_sym_interpreted_string_literal_token1,
      sym_escape_sequence,
  [2644] = 3,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    STATE(114), 1,
      sym_comment,
    ACTIONS(362), 4,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym__identifier,
      anon_sym_RPAREN,
  [2657] = 4,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(364), 1,
      anon_sym_DQUOTE,
    STATE(115), 1,
      sym_comment,
    ACTIONS(366), 2,
      aux_sym_interpreted_string_literal_token1,
      sym_escape_sequence,
  [2671] = 3,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    STATE(116), 1,
      sym_comment,
    ACTIONS(65), 3,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym__identifier,
  [2683] = 3,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    STATE(117), 1,
      sym_comment,
    ACTIONS(238), 3,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym__identifier,
  [2695] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    STATE(118), 1,
      sym_comment,
    ACTIONS(368), 3,
      anon_sym_EQ_GT,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [2707] = 3,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    STATE(119), 1,
      sym_comment,
    ACTIONS(57), 3,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym__identifier,
  [2719] = 3,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    STATE(120), 1,
      sym_comment,
    ACTIONS(61), 3,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym__identifier,
  [2731] = 3,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    STATE(121), 1,
      sym_comment,
    ACTIONS(53), 3,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym__identifier,
  [2743] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(370), 1,
      anon_sym_EQ_GT,
    STATE(122), 1,
      sym_comment,
  [2753] = 3,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(372), 1,
      anon_sym_LF,
    STATE(123), 1,
      sym_comment,
  [2763] = 3,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(374), 1,
      anon_sym_LF,
    STATE(124), 1,
      sym_comment,
  [2773] = 3,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(376), 1,
      anon_sym_LF,
    STATE(125), 1,
      sym_comment,
  [2783] = 3,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(378), 1,
      anon_sym_LF,
    STATE(126), 1,
      sym_comment,
  [2793] = 3,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(380), 1,
      anon_sym_LF,
    STATE(127), 1,
      sym_comment,
  [2803] = 3,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(382), 1,
      anon_sym_LF,
    STATE(128), 1,
      sym_comment,
  [2813] = 3,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(384), 1,
      anon_sym_LF,
    STATE(129), 1,
      sym_comment,
  [2823] = 3,
    ACTIONS(51), 1,
      anon_sym_LF,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    STATE(130), 1,
      sym_comment,
  [2833] = 3,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(386), 1,
      anon_sym_LF,
    STATE(131), 1,
      sym_comment,
  [2843] = 3,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(388), 1,
      anon_sym_LF,
    STATE(132), 1,
      sym_comment,
  [2853] = 3,
    ACTIONS(63), 1,
      anon_sym_LF,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    STATE(133), 1,
      sym_comment,
  [2863] = 3,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(390), 1,
      anon_sym_LF,
    STATE(134), 1,
      sym_comment,
  [2873] = 3,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(392), 1,
      aux_sym_comment_token1,
    STATE(135), 1,
      sym_comment,
  [2883] = 3,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(236), 1,
      anon_sym_LF,
    STATE(136), 1,
      sym_comment,
  [2893] = 3,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(394), 1,
      anon_sym_LF,
    STATE(137), 1,
      sym_comment,
  [2903] = 3,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(396), 1,
      anon_sym_LF,
    STATE(138), 1,
      sym_comment,
  [2913] = 3,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(398), 1,
      anon_sym_LF,
    STATE(139), 1,
      sym_comment,
  [2923] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(400), 1,
      anon_sym_RBRACK,
    STATE(140), 1,
      sym_comment,
  [2933] = 3,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(402), 1,
      anon_sym_LF,
    STATE(141), 1,
      sym_comment,
  [2943] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(404), 1,
      ts_builtin_sym_end,
    STATE(142), 1,
      sym_comment,
  [2953] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(406), 1,
      anon_sym_COMMA,
    STATE(143), 1,
      sym_comment,
  [2963] = 3,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(408), 1,
      anon_sym_LF,
    STATE(144), 1,
      sym_comment,
  [2973] = 3,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(368), 1,
      anon_sym_LF,
    STATE(145), 1,
      sym_comment,
  [2983] = 3,
    ACTIONS(59), 1,
      anon_sym_LF,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    STATE(146), 1,
      sym_comment,
  [2993] = 3,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(410), 1,
      anon_sym_LF,
    STATE(147), 1,
      sym_comment,
  [3003] = 3,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(412), 1,
      anon_sym_LF,
    STATE(148), 1,
      sym_comment,
  [3013] = 3,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(414), 1,
      anon_sym_LF,
    STATE(149), 1,
      sym_comment,
  [3023] = 3,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(416), 1,
      anon_sym_LF,
    STATE(150), 1,
      sym_comment,
  [3033] = 3,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(418), 1,
      anon_sym_LF,
    STATE(151), 1,
      sym_comment,
  [3043] = 3,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(420), 1,
      anon_sym_LF,
    STATE(152), 1,
      sym_comment,
  [3053] = 3,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(422), 1,
      anon_sym_LF,
    STATE(153), 1,
      sym_comment,
  [3063] = 3,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(424), 1,
      anon_sym_LF,
    STATE(154), 1,
      sym_comment,
  [3073] = 3,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(426), 1,
      anon_sym_LF,
    STATE(155), 1,
      sym_comment,
  [3083] = 3,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(428), 1,
      anon_sym_LF,
    STATE(156), 1,
      sym_comment,
  [3093] = 3,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(430), 1,
      anon_sym_LF,
    STATE(157), 1,
      sym_comment,
  [3103] = 3,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(432), 1,
      anon_sym_LF,
    STATE(158), 1,
      sym_comment,
  [3113] = 3,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(434), 1,
      anon_sym_LF,
    STATE(159), 1,
      sym_comment,
  [3123] = 3,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(436), 1,
      anon_sym_LF,
    STATE(160), 1,
      sym_comment,
  [3133] = 3,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(438), 1,
      anon_sym_LF,
    STATE(161), 1,
      sym_comment,
  [3143] = 3,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(440), 1,
      anon_sym_LF,
    STATE(162), 1,
      sym_comment,
  [3153] = 3,
    ACTIONS(55), 1,
      anon_sym_LF,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    STATE(163), 1,
      sym_comment,
  [3163] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(442), 1,
      anon_sym_RBRACK,
    STATE(164), 1,
      sym_comment,
  [3173] = 3,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(444), 1,
      anon_sym_LF,
    STATE(165), 1,
      sym_comment,
  [3183] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(446), 1,
      anon_sym_EQ_GT,
    STATE(166), 1,
      sym_comment,
  [3193] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(448), 1,
      anon_sym_COMMA,
    STATE(167), 1,
      sym_comment,
  [3203] = 3,
    ACTIONS(3), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(450), 1,
      anon_sym_RPAREN,
    STATE(168), 1,
      sym_comment,
  [3213] = 3,
    ACTIONS(77), 1,
      anon_sym_SLASH_SLASH,
    ACTIONS(452), 1,
      anon_sym_LF,
    STATE(169), 1,
      sym_comment,
  [3223] = 1,
    ACTIONS(454), 1,
      ts_builtin_sym_end,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(2)] = 0,
  [SMALL_STATE(3)] = 48,
  [SMALL_STATE(4)] = 98,
  [SMALL_STATE(5)] = 121,
  [SMALL_STATE(6)] = 144,
  [SMALL_STATE(7)] = 167,
  [SMALL_STATE(8)] = 190,
  [SMALL_STATE(9)] = 230,
  [SMALL_STATE(10)] = 270,
  [SMALL_STATE(11)] = 308,
  [SMALL_STATE(12)] = 345,
  [SMALL_STATE(13)] = 382,
  [SMALL_STATE(14)] = 419,
  [SMALL_STATE(15)] = 456,
  [SMALL_STATE(16)] = 493,
  [SMALL_STATE(17)] = 530,
  [SMALL_STATE(18)] = 565,
  [SMALL_STATE(19)] = 600,
  [SMALL_STATE(20)] = 637,
  [SMALL_STATE(21)] = 672,
  [SMALL_STATE(22)] = 692,
  [SMALL_STATE(23)] = 712,
  [SMALL_STATE(24)] = 732,
  [SMALL_STATE(25)] = 752,
  [SMALL_STATE(26)] = 772,
  [SMALL_STATE(27)] = 792,
  [SMALL_STATE(28)] = 812,
  [SMALL_STATE(29)] = 832,
  [SMALL_STATE(30)] = 852,
  [SMALL_STATE(31)] = 886,
  [SMALL_STATE(32)] = 920,
  [SMALL_STATE(33)] = 940,
  [SMALL_STATE(34)] = 974,
  [SMALL_STATE(35)] = 1008,
  [SMALL_STATE(36)] = 1028,
  [SMALL_STATE(37)] = 1048,
  [SMALL_STATE(38)] = 1068,
  [SMALL_STATE(39)] = 1088,
  [SMALL_STATE(40)] = 1122,
  [SMALL_STATE(41)] = 1142,
  [SMALL_STATE(42)] = 1162,
  [SMALL_STATE(43)] = 1182,
  [SMALL_STATE(44)] = 1202,
  [SMALL_STATE(45)] = 1222,
  [SMALL_STATE(46)] = 1254,
  [SMALL_STATE(47)] = 1274,
  [SMALL_STATE(48)] = 1294,
  [SMALL_STATE(49)] = 1314,
  [SMALL_STATE(50)] = 1334,
  [SMALL_STATE(51)] = 1354,
  [SMALL_STATE(52)] = 1374,
  [SMALL_STATE(53)] = 1394,
  [SMALL_STATE(54)] = 1414,
  [SMALL_STATE(55)] = 1434,
  [SMALL_STATE(56)] = 1454,
  [SMALL_STATE(57)] = 1474,
  [SMALL_STATE(58)] = 1494,
  [SMALL_STATE(59)] = 1525,
  [SMALL_STATE(60)] = 1556,
  [SMALL_STATE(61)] = 1587,
  [SMALL_STATE(62)] = 1618,
  [SMALL_STATE(63)] = 1649,
  [SMALL_STATE(64)] = 1680,
  [SMALL_STATE(65)] = 1711,
  [SMALL_STATE(66)] = 1742,
  [SMALL_STATE(67)] = 1770,
  [SMALL_STATE(68)] = 1798,
  [SMALL_STATE(69)] = 1826,
  [SMALL_STATE(70)] = 1854,
  [SMALL_STATE(71)] = 1882,
  [SMALL_STATE(72)] = 1910,
  [SMALL_STATE(73)] = 1938,
  [SMALL_STATE(74)] = 1966,
  [SMALL_STATE(75)] = 1994,
  [SMALL_STATE(76)] = 2022,
  [SMALL_STATE(77)] = 2050,
  [SMALL_STATE(78)] = 2078,
  [SMALL_STATE(79)] = 2106,
  [SMALL_STATE(80)] = 2134,
  [SMALL_STATE(81)] = 2162,
  [SMALL_STATE(82)] = 2178,
  [SMALL_STATE(83)] = 2194,
  [SMALL_STATE(84)] = 2210,
  [SMALL_STATE(85)] = 2223,
  [SMALL_STATE(86)] = 2236,
  [SMALL_STATE(87)] = 2253,
  [SMALL_STATE(88)] = 2268,
  [SMALL_STATE(89)] = 2285,
  [SMALL_STATE(90)] = 2300,
  [SMALL_STATE(91)] = 2313,
  [SMALL_STATE(92)] = 2326,
  [SMALL_STATE(93)] = 2339,
  [SMALL_STATE(94)] = 2352,
  [SMALL_STATE(95)] = 2365,
  [SMALL_STATE(96)] = 2378,
  [SMALL_STATE(97)] = 2391,
  [SMALL_STATE(98)] = 2404,
  [SMALL_STATE(99)] = 2417,
  [SMALL_STATE(100)] = 2430,
  [SMALL_STATE(101)] = 2443,
  [SMALL_STATE(102)] = 2456,
  [SMALL_STATE(103)] = 2469,
  [SMALL_STATE(104)] = 2482,
  [SMALL_STATE(105)] = 2495,
  [SMALL_STATE(106)] = 2508,
  [SMALL_STATE(107)] = 2525,
  [SMALL_STATE(108)] = 2542,
  [SMALL_STATE(109)] = 2559,
  [SMALL_STATE(110)] = 2576,
  [SMALL_STATE(111)] = 2593,
  [SMALL_STATE(112)] = 2610,
  [SMALL_STATE(113)] = 2627,
  [SMALL_STATE(114)] = 2644,
  [SMALL_STATE(115)] = 2657,
  [SMALL_STATE(116)] = 2671,
  [SMALL_STATE(117)] = 2683,
  [SMALL_STATE(118)] = 2695,
  [SMALL_STATE(119)] = 2707,
  [SMALL_STATE(120)] = 2719,
  [SMALL_STATE(121)] = 2731,
  [SMALL_STATE(122)] = 2743,
  [SMALL_STATE(123)] = 2753,
  [SMALL_STATE(124)] = 2763,
  [SMALL_STATE(125)] = 2773,
  [SMALL_STATE(126)] = 2783,
  [SMALL_STATE(127)] = 2793,
  [SMALL_STATE(128)] = 2803,
  [SMALL_STATE(129)] = 2813,
  [SMALL_STATE(130)] = 2823,
  [SMALL_STATE(131)] = 2833,
  [SMALL_STATE(132)] = 2843,
  [SMALL_STATE(133)] = 2853,
  [SMALL_STATE(134)] = 2863,
  [SMALL_STATE(135)] = 2873,
  [SMALL_STATE(136)] = 2883,
  [SMALL_STATE(137)] = 2893,
  [SMALL_STATE(138)] = 2903,
  [SMALL_STATE(139)] = 2913,
  [SMALL_STATE(140)] = 2923,
  [SMALL_STATE(141)] = 2933,
  [SMALL_STATE(142)] = 2943,
  [SMALL_STATE(143)] = 2953,
  [SMALL_STATE(144)] = 2963,
  [SMALL_STATE(145)] = 2973,
  [SMALL_STATE(146)] = 2983,
  [SMALL_STATE(147)] = 2993,
  [SMALL_STATE(148)] = 3003,
  [SMALL_STATE(149)] = 3013,
  [SMALL_STATE(150)] = 3023,
  [SMALL_STATE(151)] = 3033,
  [SMALL_STATE(152)] = 3043,
  [SMALL_STATE(153)] = 3053,
  [SMALL_STATE(154)] = 3063,
  [SMALL_STATE(155)] = 3073,
  [SMALL_STATE(156)] = 3083,
  [SMALL_STATE(157)] = 3093,
  [SMALL_STATE(158)] = 3103,
  [SMALL_STATE(159)] = 3113,
  [SMALL_STATE(160)] = 3123,
  [SMALL_STATE(161)] = 3133,
  [SMALL_STATE(162)] = 3143,
  [SMALL_STATE(163)] = 3153,
  [SMALL_STATE(164)] = 3163,
  [SMALL_STATE(165)] = 3173,
  [SMALL_STATE(166)] = 3183,
  [SMALL_STATE(167)] = 3193,
  [SMALL_STATE(168)] = 3203,
  [SMALL_STATE(169)] = 3213,
  [SMALL_STATE(170)] = 3223,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, SHIFT(135),
  [5] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 0, 0, 0),
  [7] = {.entry = {.count = 1, .reusable = true}}, SHIFT(61),
  [9] = {.entry = {.count = 1, .reusable = true}}, SHIFT(71),
  [11] = {.entry = {.count = 1, .reusable = true}}, SHIFT(73),
  [13] = {.entry = {.count = 1, .reusable = true}}, SHIFT(30),
  [15] = {.entry = {.count = 1, .reusable = true}}, SHIFT(31),
  [17] = {.entry = {.count = 1, .reusable = true}}, SHIFT(33),
  [19] = {.entry = {.count = 1, .reusable = false}}, SHIFT(62),
  [21] = {.entry = {.count = 1, .reusable = true}}, SHIFT(11),
  [23] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0),
  [25] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(61),
  [28] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(71),
  [31] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(73),
  [34] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(30),
  [37] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(31),
  [40] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(33),
  [43] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(62),
  [46] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(11),
  [49] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 1, 0, 0),
  [51] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_interpreted_string_literal, 2, 0, 0),
  [53] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_interpreted_string_literal, 2, 0, 0),
  [55] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__string_literal, 1, 0, 0),
  [57] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__string_literal, 1, 0, 0),
  [59] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__string_or_ident, 1, 0, 0),
  [61] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__string_or_ident, 1, 0, 0),
  [63] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_interpreted_string_literal, 3, 0, 0),
  [65] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_interpreted_string_literal, 3, 0, 0),
  [67] = {.entry = {.count = 1, .reusable = false}}, SHIFT(163),
  [69] = {.entry = {.count = 1, .reusable = false}}, SHIFT(106),
  [71] = {.entry = {.count = 1, .reusable = false}}, SHIFT(146),
  [73] = {.entry = {.count = 1, .reusable = false}}, SHIFT(159),
  [75] = {.entry = {.count = 1, .reusable = true}}, SHIFT(67),
  [77] = {.entry = {.count = 1, .reusable = false}}, SHIFT(135),
  [79] = {.entry = {.count = 1, .reusable = false}}, SHIFT(138),
  [81] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_retract_directive_repeat1, 2, 0, 0), SHIFT_REPEAT(163),
  [84] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_retract_directive_repeat1, 2, 0, 0), SHIFT_REPEAT(106),
  [87] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_retract_directive_repeat1, 2, 0, 0), SHIFT_REPEAT(146),
  [90] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_retract_directive_repeat1, 2, 0, 0),
  [92] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_retract_directive_repeat1, 2, 0, 0), SHIFT_REPEAT(67),
  [95] = {.entry = {.count = 1, .reusable = false}}, SHIFT(137),
  [97] = {.entry = {.count = 1, .reusable = true}}, SHIFT(74),
  [99] = {.entry = {.count = 1, .reusable = false}}, SHIFT(119),
  [101] = {.entry = {.count = 1, .reusable = false}}, SHIFT(108),
  [103] = {.entry = {.count = 1, .reusable = false}}, SHIFT(120),
  [105] = {.entry = {.count = 1, .reusable = false}}, SHIFT(157),
  [107] = {.entry = {.count = 1, .reusable = false}}, SHIFT(165),
  [109] = {.entry = {.count = 1, .reusable = false}}, SHIFT(98),
  [111] = {.entry = {.count = 1, .reusable = false}}, SHIFT(110),
  [113] = {.entry = {.count = 1, .reusable = false}}, SHIFT(99),
  [115] = {.entry = {.count = 1, .reusable = false}}, SHIFT(161),
  [117] = {.entry = {.count = 1, .reusable = false}}, SHIFT(154),
  [119] = {.entry = {.count = 1, .reusable = false}}, SHIFT(158),
  [121] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_require_directive_repeat1, 2, 0, 0), SHIFT_REPEAT(119),
  [124] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_require_directive_repeat1, 2, 0, 0), SHIFT_REPEAT(108),
  [127] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_require_directive_repeat1, 2, 0, 0), SHIFT_REPEAT(120),
  [130] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_require_directive_repeat1, 2, 0, 0),
  [132] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_exclude_directive_repeat1, 2, 0, 0), SHIFT_REPEAT(119),
  [135] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_exclude_directive_repeat1, 2, 0, 0), SHIFT_REPEAT(108),
  [138] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_exclude_directive_repeat1, 2, 0, 0), SHIFT_REPEAT(120),
  [141] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_exclude_directive_repeat1, 2, 0, 0),
  [143] = {.entry = {.count = 1, .reusable = false}}, SHIFT(124),
  [145] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_replace_directive_repeat1, 2, 0, 0), SHIFT_REPEAT(98),
  [148] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_replace_directive_repeat1, 2, 0, 0), SHIFT_REPEAT(110),
  [151] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_replace_directive_repeat1, 2, 0, 0), SHIFT_REPEAT(99),
  [154] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_replace_directive_repeat1, 2, 0, 0),
  [156] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_replace_directive, 5, 0, 0),
  [158] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_replace_directive, 5, 0, 0),
  [160] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_toolchain_name, 1, 0, 0),
  [162] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_toolchain_name, 1, 0, 0),
  [164] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_toolchain_directive, 2, 0, 1),
  [166] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_toolchain_directive, 2, 0, 1),
  [168] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_require_directive, 2, 0, 0),
  [170] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_require_directive, 2, 0, 0),
  [172] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_exclude_directive, 2, 0, 0),
  [174] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_exclude_directive, 2, 0, 0),
  [176] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_replace_directive, 2, 0, 0),
  [178] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_replace_directive, 2, 0, 0),
  [180] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tool, 1, 0, 0),
  [182] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_tool, 1, 0, 0),
  [184] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tool_directive, 2, 0, 0),
  [186] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_tool_directive, 2, 0, 0),
  [188] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_retract_directive, 2, 0, 0),
  [190] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_retract_directive, 2, 0, 0),
  [192] = {.entry = {.count = 1, .reusable = false}}, SHIFT(162),
  [194] = {.entry = {.count = 1, .reusable = false}}, SHIFT(127),
  [196] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_go_directive, 3, 0, 0),
  [198] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_go_directive, 3, 0, 0),
  [200] = {.entry = {.count = 1, .reusable = false}}, SHIFT(160),
  [202] = {.entry = {.count = 1, .reusable = false}}, SHIFT(102),
  [204] = {.entry = {.count = 1, .reusable = false}}, SHIFT(112),
  [206] = {.entry = {.count = 1, .reusable = false}}, SHIFT(103),
  [208] = {.entry = {.count = 1, .reusable = false}}, SHIFT(132),
  [210] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_retract_spec, 2, 0, 0),
  [212] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_retract_spec, 2, 0, 0),
  [214] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 1, 0, 0),
  [216] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 1, 0, 0),
  [218] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__directive, 1, 0, 0),
  [220] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__directive, 1, 0, 0),
  [222] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_exclude_spec, 3, 0, 0),
  [224] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_exclude_spec, 3, 0, 0),
  [226] = {.entry = {.count = 1, .reusable = false}}, SHIFT(134),
  [228] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_require_directive, 5, 0, 0),
  [230] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_require_directive, 5, 0, 0),
  [232] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_exclude_directive, 5, 0, 0),
  [234] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_exclude_directive, 5, 0, 0),
  [236] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_module_path, 1, 0, 0),
  [238] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_module_path, 1, 0, 0),
  [240] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_replace_spec, 4, 0, 0),
  [242] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_replace_spec, 4, 0, 0),
  [244] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tool_directive, 5, 0, 0),
  [246] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_tool_directive, 5, 0, 0),
  [248] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_tool_directive_repeat1, 2, 0, 0), SHIFT_REPEAT(102),
  [251] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_tool_directive_repeat1, 2, 0, 0), SHIFT_REPEAT(112),
  [254] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_tool_directive_repeat1, 2, 0, 0), SHIFT_REPEAT(103),
  [257] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_tool_directive_repeat1, 2, 0, 0),
  [259] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_retract_directive, 5, 0, 0),
  [261] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_retract_directive, 5, 0, 0),
  [263] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_module_directive, 2, 0, 0),
  [265] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_module_directive, 2, 0, 0),
  [267] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_module_directive, 6, 0, 0),
  [269] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_module_directive, 6, 0, 0),
  [271] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_require_directive, 6, 0, 0),
  [273] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_require_directive, 6, 0, 0),
  [275] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_exclude_directive, 6, 0, 0),
  [277] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_exclude_directive, 6, 0, 0),
  [279] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_replace_directive, 6, 0, 0),
  [281] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_replace_directive, 6, 0, 0),
  [283] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_replace_spec, 5, 0, 0),
  [285] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_replace_spec, 5, 0, 0),
  [287] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tool_directive, 6, 0, 0),
  [289] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_tool_directive, 6, 0, 0),
  [291] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_retract_directive, 6, 0, 0),
  [293] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_retract_directive, 6, 0, 0),
  [295] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_replace_spec, 6, 0, 0),
  [297] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_replace_spec, 6, 0, 0),
  [299] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_retract_spec, 6, 0, 0),
  [301] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_retract_spec, 6, 0, 0),
  [303] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_require_spec, 3, 0, 0),
  [305] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_require_spec, 3, 0, 0),
  [307] = {.entry = {.count = 1, .reusable = false}}, SHIFT(87),
  [309] = {.entry = {.count = 1, .reusable = false}}, SHIFT(5),
  [311] = {.entry = {.count = 1, .reusable = false}}, SHIFT(86),
  [313] = {.entry = {.count = 1, .reusable = false}}, SHIFT(6),
  [315] = {.entry = {.count = 1, .reusable = false}}, SHIFT(58),
  [317] = {.entry = {.count = 1, .reusable = false}}, SHIFT(64),
  [319] = {.entry = {.count = 1, .reusable = false}}, SHIFT(123),
  [321] = {.entry = {.count = 1, .reusable = false}}, SHIFT(139),
  [323] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_retract_directive_repeat1, 1, 0, 0),
  [325] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_retract_directive_repeat1, 1, 0, 0),
  [327] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_replace_directive_repeat1, 1, 0, 0),
  [329] = {.entry = {.count = 1, .reusable = false}}, SHIFT(4),
  [331] = {.entry = {.count = 1, .reusable = true}}, SHIFT(115),
  [333] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_file_path, 1, 0, 0),
  [335] = {.entry = {.count = 1, .reusable = false}}, SHIFT(7),
  [337] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_interpreted_string_literal_repeat1, 2, 0, 0),
  [339] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_interpreted_string_literal_repeat1, 2, 0, 0), SHIFT_REPEAT(115),
  [342] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_require_directive_repeat1, 1, 0, 0),
  [344] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_tool_directive_repeat1, 1, 0, 0),
  [346] = {.entry = {.count = 1, .reusable = false}}, SHIFT(130),
  [348] = {.entry = {.count = 1, .reusable = false}}, SHIFT(133),
  [350] = {.entry = {.count = 1, .reusable = false}}, SHIFT(121),
  [352] = {.entry = {.count = 1, .reusable = false}}, SHIFT(116),
  [354] = {.entry = {.count = 1, .reusable = false}}, SHIFT(100),
  [356] = {.entry = {.count = 1, .reusable = false}}, SHIFT(101),
  [358] = {.entry = {.count = 1, .reusable = false}}, SHIFT(104),
  [360] = {.entry = {.count = 1, .reusable = false}}, SHIFT(105),
  [362] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_exclude_directive_repeat1, 1, 0, 0),
  [364] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_interpreted_string_literal_repeat1, 1, 0, 0),
  [366] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_interpreted_string_literal_repeat1, 1, 0, 0),
  [368] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_version, 1, 0, 0),
  [370] = {.entry = {.count = 1, .reusable = true}}, SHIFT(63),
  [372] = {.entry = {.count = 1, .reusable = true}}, SHIFT(69),
  [374] = {.entry = {.count = 1, .reusable = true}}, SHIFT(51),
  [376] = {.entry = {.count = 1, .reusable = true}}, SHIFT(57),
  [378] = {.entry = {.count = 1, .reusable = true}}, SHIFT(52),
  [380] = {.entry = {.count = 1, .reusable = true}}, SHIFT(13),
  [382] = {.entry = {.count = 1, .reusable = true}}, SHIFT(43),
  [384] = {.entry = {.count = 1, .reusable = true}}, SHIFT(32),
  [386] = {.entry = {.count = 1, .reusable = true}}, SHIFT(38),
  [388] = {.entry = {.count = 1, .reusable = true}}, SHIFT(44),
  [390] = {.entry = {.count = 1, .reusable = true}}, SHIFT(53),
  [392] = {.entry = {.count = 1, .reusable = false}}, SHIFT(170),
  [394] = {.entry = {.count = 1, .reusable = true}}, SHIFT(8),
  [396] = {.entry = {.count = 1, .reusable = true}}, SHIFT(54),
  [398] = {.entry = {.count = 1, .reusable = true}}, SHIFT(34),
  [400] = {.entry = {.count = 1, .reusable = true}}, SHIFT(156),
  [402] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_go_version, 1, 0, 0),
  [404] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [406] = {.entry = {.count = 1, .reusable = true}}, SHIFT(72),
  [408] = {.entry = {.count = 1, .reusable = true}}, SHIFT(82),
  [410] = {.entry = {.count = 1, .reusable = true}}, SHIFT(92),
  [412] = {.entry = {.count = 1, .reusable = true}}, SHIFT(93),
  [414] = {.entry = {.count = 1, .reusable = true}}, SHIFT(94),
  [416] = {.entry = {.count = 1, .reusable = true}}, SHIFT(95),
  [418] = {.entry = {.count = 1, .reusable = true}}, SHIFT(83),
  [420] = {.entry = {.count = 1, .reusable = true}}, SHIFT(35),
  [422] = {.entry = {.count = 1, .reusable = true}}, SHIFT(55),
  [424] = {.entry = {.count = 1, .reusable = true}}, SHIFT(50),
  [426] = {.entry = {.count = 1, .reusable = true}}, SHIFT(168),
  [428] = {.entry = {.count = 1, .reusable = true}}, SHIFT(56),
  [430] = {.entry = {.count = 1, .reusable = true}}, SHIFT(40),
  [432] = {.entry = {.count = 1, .reusable = true}}, SHIFT(49),
  [434] = {.entry = {.count = 1, .reusable = true}}, SHIFT(46),
  [436] = {.entry = {.count = 1, .reusable = true}}, SHIFT(14),
  [438] = {.entry = {.count = 1, .reusable = true}}, SHIFT(21),
  [440] = {.entry = {.count = 1, .reusable = true}}, SHIFT(12),
  [442] = {.entry = {.count = 1, .reusable = true}}, SHIFT(151),
  [444] = {.entry = {.count = 1, .reusable = true}}, SHIFT(41),
  [446] = {.entry = {.count = 1, .reusable = true}}, SHIFT(65),
  [448] = {.entry = {.count = 1, .reusable = true}}, SHIFT(80),
  [450] = {.entry = {.count = 1, .reusable = true}}, SHIFT(48),
  [452] = {.entry = {.count = 1, .reusable = true}}, SHIFT(91),
  [454] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_comment, 2, 0, 0),
};

#ifdef __cplusplus
extern "C" {
#endif
#ifdef TREE_SITTER_HIDE_SYMBOLS
#define TS_PUBLIC
#elif defined(_WIN32)
#define TS_PUBLIC __declspec(dllexport)
#else
#define TS_PUBLIC __attribute__((visibility("default")))
#endif

TS_PUBLIC const TSLanguage *tree_sitter_gomod(void) {
  static const TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = &ts_parse_table[0][0],
    .small_parse_table = ts_small_parse_table,
    .small_parse_table_map = ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .field_names = ts_field_names,
    .field_map_slices = ts_field_map_slices,
    .field_map_entries = ts_field_map_entries,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = &ts_alias_sequences[0][0],
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
    .primary_state_ids = ts_primary_state_ids,
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
