// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py UTC_ARGS: --version 5
// RUN: %clang_cc1 -triple x86_64-apple-darwin -emit-llvm -o - -O1 %s | \
// RUN:     FileCheck -check-prefixes=CHECK,CHECK-OLD %s
// RUN: %clang_cc1 -triple x86_64-apple-darwin -new-struct-path-tbaa \
// RUN:     -emit-llvm -o - -O1 %s | \
// RUN:     FileCheck -check-prefixes=CHECK,CHECK-NEW %s
//
// Check that we generate TBAA metadata for struct copies correctly.

struct A {
  short s;
  int i;
  char c;
  int j;
};

typedef A __attribute__((may_alias)) AA;

void copy(A *a1, A *a2) {
// CHECK-LABEL: _Z4copyP1AS0_
// CHECK: call void @llvm.memcpy.p0.p0.i64(ptr noundef nonnull align 4 dereferenceable(16) %{{.*}}, ptr noundef nonnull align 4 dereferenceable(16) %{{.*}}, i64 16, i1 false)
// CHECK-OLD-SAME: !tbaa.struct [[TBAA_STRUCT6:![0-9]+]]
// CHECK-NEW-SAME: !tbaa [[TBAA6:![0-9]+]]
*a1 = *a2;
}

struct B {
  char c;
  A a;
  int i;
};

void copy2(B *b1, B *b2) {
// CHECK-LABEL: _Z5copy2P1BS0_ 
// CHECK: call void @llvm.memcpy.p0.p0.i64(ptr noundef nonnull align 4 dereferenceable(24) %{{.*}}, ptr noundef nonnull align 4 dereferenceable(24) %{{.*}}, i64 24, i1 false)
// CHECK-OLD-SAME: !tbaa.struct [[TBAA_STRUCT10:![0-9]+]]
// CHECK-NEW-SAME: !tbaa [[TBAA12:![0-9]+]]
  *b1 = *b2;
}

struct S {
  _Complex char cc;
  _Complex int ci;
};

union U {
  _Complex int ci;
  S s;
};

void copy3(U *u1, U *u2) {
// CHECK-LABEL: _Z5copy3P1US0_
// CHECK: call void @llvm.memcpy.p0.p0.i64(ptr noundef nonnull align 4 dereferenceable(12) %{{.*}}, ptr noundef nonnull align 4 dereferenceable(12) %{{.*}}, i64 12, i1 false)
// CHECK-OLD-SAME: !tbaa.struct [[TBAA_STRUCT11:![0-9]+]]
// CHECK-NEW-SAME: !tbaa [[TBAA15:![0-9]+]]
*u1 = *u2;
}

// Make sure that zero-length bitfield works.
struct C {
  char a;
  int : 0;  // Shall not be ignored; see r185018.
  char b;
  char c;
} __attribute__((ms_struct));

void copy4(C *c1, C *c2) {
// CHECK-LABEL: _Z5copy4P1CS0_
// CHECK: call void @llvm.memcpy.p0.p0.i64(ptr noundef nonnull align 1 dereferenceable(3) {{.*}}, ptr noundef nonnull align 1 dereferenceable(3) {{.*}}, i64 3, i1 false)
// CHECK-OLD-SAME: !tbaa.struct [[TBAA_STRUCT12:![0-9]+]]
// CHECK-NEW-SAME: !tbaa [[TBAA17:![0-9]+]]
  *c1 = *c2;
}

struct D {
  char a;
  int : 0;
  char b;
  char c;
};

void copy5(D *d1, D *d2) {
// CHECK-LABEL: _Z5copy5P1DS0_
// CHECK: call void @llvm.memcpy.p0.p0.i64(ptr noundef nonnull align 1 dereferenceable(6) {{.*}}, ptr noundef nonnull align 1 dereferenceable(6) {{.*}}, i64 6, i1 false)
// CHECK-OLD-SAME: !tbaa.struct [[TBAA_STRUCT13:![0-9]+]]
// CHECK-NEW-SAME: !tbaa [[TBAA20:![0-9]+]]
  *d1 = *d2;
}

void copy6(AA *a1, A *a2) {
// CHECK-LABEL: _Z5copy6P1AS0_
// CHECK: call void @llvm.memcpy.p0.p0.i64(ptr noundef nonnull align 4 dereferenceable(16) %{{.*}}, ptr noundef nonnull align 4 dereferenceable(16) %{{.*}}, i64 16, i1 false)
// CHECK-OLD-SAME: !tbaa.struct [[TBAA_STRUCT6]]
// CHECK-NEW-SAME: !tbaa [[TBAA23:![0-9]+]]
  *a1 = *a2;
}

void copy7(A *a1, AA *a2) {
// CHECK-LABEL: _Z5copy7P1AS0_
// CHECK: call void @llvm.memcpy.p0.p0.i64(ptr noundef nonnull align 4 dereferenceable(16) %{{.*}}, ptr noundef nonnull align 4 dereferenceable(16) %{{.*}}, i64 16, i1 false)
// CHECK-OLD-SAME: !tbaa.struct [[TBAA_STRUCT6]]
// CHECK-NEW-SAME: !tbaa [[TBAA23]]
  *a1 = *a2;
}

struct NamedBitfields {
   signed f0 : 9;
   unsigned f1 : 2;
   char f2;
   double f3;
};

void copy8(NamedBitfields *a1, NamedBitfields *a2) {
// CHECK-LABEL: _Z5copy8P14NamedBitfieldsS0_
// CHECK:   tail call void @llvm.memcpy.p0.p0.i64(ptr noundef nonnull align 8 dereferenceable(16) %a1, ptr noundef nonnull align 8 dereferenceable(16) %a2, i64 16, i1 false),
// CHECK-OLD-SAME: !tbaa.struct [[TBAA_STRUCT14:![0-9]+]]
// CHECK-NEW-SAME: !tbaa [[TBAA24:![0-9]+]], !tbaa.struct
  *a1 = *a2;
}

struct NamedBitfields2 {
  char a, b, c;
   signed f0 : 3;
   unsigned f1 : 4;
   char f2 : 7;
   double f3;
   unsigned f4 : 4;
};

void copy9(NamedBitfields2 *a1, NamedBitfields2 *a2) {
// CHECK-LABEL: _Z5copy9P15NamedBitfields2S0_
// CHECK:   tail call void @llvm.memcpy.p0.p0.i64(ptr noundef nonnull align 8 dereferenceable(24) %a1, ptr noundef nonnull align 8 dereferenceable(24) %a2, i64 24, i1 false),
// CHECK-OLD-SAME: !tbaa.struct [[TBAA_STRUCT17:![0-9]+]]
// CHECK-NEW-SAME: !tbaa [[TBAA30:![0-9]+]], !tbaa.struct
  *a1 = *a2;
}

// Test with unnamed bitfield at the start and in between named ones..
struct NamedBitfields3 {
  unsigned : 11;
  signed f0 : 9;
  char : 2;
  int f1 : 2;
  double f2;
};

void copy10(NamedBitfields3 *a1, NamedBitfields3 *a2) {
// CHECK-LABEL: _Z6copy10P15NamedBitfields3S0_
// CHECK:   tail call void @llvm.memcpy.p0.p0.i64(ptr noundef nonnull align 8 dereferenceable(16) %a1, ptr noundef nonnull align 8 dereferenceable(16) %a2, i64 16, i1 false),
// CHECK-OLD-SAME: !tbaa.struct [[TBAA_STRUCT18:![0-9]+]]
// CHECK-NEW-SAME: !tbaa [[TBAA33:![0-9]+]], !tbaa.struct
  *a1 = *a2;
}

union U2 {
  double d;
  float f;
};

struct UnionMember1 {
  U2 u;
  int p;
};

void copy11(UnionMember1 *a1, UnionMember1 *a2) {
// CHECK-LABEL: _Z6copy11P12UnionMember1S0_
// CHECK:   tail call void @llvm.memcpy.p0.p0.i64(ptr noundef nonnull align 8 dereferenceable(16) %a1, ptr noundef nonnull align 8 dereferenceable(16) %a2, i64 16, i1 false),
// CHECK-OLD-SAME: !tbaa.struct [[TBAA_STRUCT19:![0-9]+]]
// CHECK-NEW-SAME: !tbaa [[TBAA37:![0-9]+]], !tbaa.struct
  *a1 = *a2;
}

struct UnionMember2 {
  int p;
  U2 u;
};

void copy12(UnionMember2 *a1, UnionMember2 *a2) {
// CHECK-LABEL: _Z6copy12P12UnionMember2S0_
// CHECK:   tail call void @llvm.memcpy.p0.p0.i64(ptr noundef nonnull align 8 dereferenceable(16) %a1, ptr noundef nonnull align 8 dereferenceable(16) %a2, i64 16, i1 false),
// CHECK-OLD-SAME: !tbaa.struct [[TBAA_STRUCT20:![0-9]+]]
// CHECK-NEW-SAME: !tbaa [[TBAA41:![0-9]+]], !tbaa.struct

  *a1 = *a2;
}

// (offset, size) = (0,1) char; (4,2) short; (8,4) int; (12,1) char; (16,4) int; (20,4) int
// (offset, size) = (0,8) char; (0,2) char; (4,8) char
// CHECK-OLD  [[DOUBLE]] = !{!"double", [[CHAR]], i64 0}

//.
// CHECK-OLD: [[META2:![0-9]+]] = !{[[META3:![0-9]+]], [[META3]], i64 0}
// CHECK-OLD: [[META3]] = !{!"int", [[META4:![0-9]+]], i64 0}
// CHECK-OLD: [[META4]] = !{!"omnipotent char", [[META5:![0-9]+]], i64 0}
// CHECK-OLD: [[META5]] = !{!"Simple C++ TBAA"}
// CHECK-OLD: [[TBAA_STRUCT6]] = !{i64 0, i64 2, [[META7:![0-9]+]], i64 4, i64 4, [[META2]], i64 8, i64 1, [[META9:![0-9]+]], i64 12, i64 4, [[META2]]}
// CHECK-OLD: [[META7]] = !{[[META8:![0-9]+]], [[META8]], i64 0}
// CHECK-OLD: [[META8]] = !{!"short", [[META4]], i64 0}
// CHECK-OLD: [[META9]] = !{[[META4]], [[META4]], i64 0}
// CHECK-OLD: [[TBAA_STRUCT10]] = !{i64 0, i64 1, [[META9]], i64 4, i64 2, [[META7]], i64 8, i64 4, [[META2]], i64 12, i64 1, [[META9]], i64 16, i64 4, [[META2]], i64 20, i64 4, [[META2]]}
// CHECK-OLD: [[TBAA_STRUCT11]] = !{i64 0, i64 12, [[META9]]}
// CHECK-OLD: [[TBAA_STRUCT12]] = !{i64 0, i64 1, [[META9]], i64 1, i64 1, [[META9]], i64 2, i64 1, [[META9]]}
// CHECK-OLD: [[TBAA_STRUCT13]] = !{i64 0, i64 1, [[META9]], i64 4, i64 1, [[META9]], i64 5, i64 1, [[META9]]}
// CHECK-OLD: [[TBAA_STRUCT14]] = !{i64 0, i64 2, [[META9]], i64 2, i64 1, [[META9]], i64 8, i64 8, [[META15:![0-9]+]]}
// CHECK-OLD: [[META15]] = !{[[META16:![0-9]+]], [[META16]], i64 0}
// CHECK-OLD: [[META16]] = !{!"double", [[META4]], i64 0}
// CHECK-OLD: [[TBAA_STRUCT17]] = !{i64 0, i64 1, [[META9]], i64 1, i64 1, [[META9]], i64 2, i64 1, [[META9]], i64 3, i64 2, [[META9]], i64 8, i64 8, [[META15]], i64 16, i64 1, [[META9]]}
// CHECK-OLD: [[TBAA_STRUCT18]] = !{i64 0, i64 4, [[META9]], i64 8, i64 8, [[META15]]}
// CHECK-OLD: [[TBAA_STRUCT19]] = !{i64 0, i64 8, [[META9]], i64 8, i64 4, [[META2]]}
// CHECK-OLD: [[TBAA_STRUCT20]] = !{i64 0, i64 4, [[META2]], i64 8, i64 8, [[META9]]}
//.
// CHECK-NEW: [[META2:![0-9]+]] = !{[[META3:![0-9]+]], [[META3]], i64 0, i64 4}
// CHECK-NEW: [[META3]] = !{[[META4:![0-9]+]], i64 4, !"int"}
// CHECK-NEW: [[META4]] = !{[[META5:![0-9]+]], i64 1, !"omnipotent char"}
// CHECK-NEW: [[META5]] = !{!"Simple C++ TBAA"}
// CHECK-NEW: [[TBAA6]] = !{[[META7:![0-9]+]], [[META7]], i64 0, i64 16}
// CHECK-NEW: [[META7]] = !{[[META4]], i64 16, !"_ZTS1A", [[META8:![0-9]+]], i64 0, i64 2, [[META3]], i64 4, i64 4, [[META4]], i64 8, i64 1, [[META3]], i64 12, i64 4}
// CHECK-NEW: [[META8]] = !{[[META4]], i64 2, !"short"}
// CHECK-NEW: [[TBAA12]] = !{[[META13:![0-9]+]], [[META13]], i64 0, i64 24}
// CHECK-NEW: [[META13]] = !{[[META4]], i64 24, !"_ZTS1B", [[META4]], i64 0, i64 1, [[META7]], i64 4, i64 16, [[META3]], i64 20, i64 4}
// CHECK-NEW: [[TBAA15]] = !{[[META4]], [[META4]], i64 0, i64 12}
// CHECK-NEW: [[TBAA17]] = !{[[META18:![0-9]+]], [[META18]], i64 0, i64 3}
// CHECK-NEW: [[META18]] = !{[[META4]], i64 3, !"_ZTS1C", [[META4]], i64 0, i64 1, [[META4]], i64 1, i64 1, [[META4]], i64 2, i64 1}
// CHECK-NEW: [[TBAA20]] = !{[[META21:![0-9]+]], [[META21]], i64 0, i64 6}
// CHECK-NEW: [[META21]] = !{[[META4]], i64 6, !"_ZTS1D", [[META4]], i64 0, i64 1, [[META4]], i64 4, i64 1, [[META4]], i64 5, i64 1}
// CHECK-NEW: [[TBAA23]] = !{[[META4]], [[META4]], i64 0, i64 0}
// CHECK-NEW: [[TBAA24]] = !{[[META25:![0-9]+]], [[META25]], i64 0, i64 16}
// CHECK-NEW: [[META25]] = !{[[META4]], i64 16, !"_ZTS14NamedBitfields", [[META3]], i64 0, i64 4, [[META3]], i64 1, i64 4, [[META4]], i64 2, i64 1, [[META26:![0-9]+]], i64 8, i64 8}
// CHECK-NEW: [[META26]] = !{[[META4]], i64 8, !"double"}
// CHECK-NEW: [[TBAA30]] = !{[[META31:![0-9]+]], [[META31]], i64 0, i64 24}
// CHECK-NEW: [[META31]] = !{[[META4]], i64 24, !"_ZTS15NamedBitfields2", [[META4]], i64 0, i64 1, [[META4]], i64 1, i64 1, [[META4]], i64 2, i64 1, [[META3]], i64 3, i64 4, [[META3]], i64 3, i64 4, [[META4]], i64 4, i64 1, [[META26]], i64 8, i64 8, [[META3]], i64 16, i64 4}
// CHECK-NEW: [[TBAA33]] = !{[[META34:![0-9]+]], [[META34]], i64 0, i64 16}
// CHECK-NEW: [[META34]] = !{[[META4]], i64 16, !"_ZTS15NamedBitfields3", [[META3]], i64 1, i64 4, [[META3]], i64 2, i64 4, [[META26]], i64 8, i64 8}
// CHECK-NEW: [[TBAA37]] = !{[[META38:![0-9]+]], [[META38]], i64 0, i64 16}
// CHECK-NEW: [[META38]] = !{[[META4]], i64 16, !"_ZTS12UnionMember1", [[META4]], i64 0, i64 8, [[META3]], i64 8, i64 4}
// CHECK-NEW: [[TBAA41]] = !{[[META42:![0-9]+]], [[META42]], i64 0, i64 16}
// CHECK-NEW: [[META42]] = !{[[META4]], i64 16, !"_ZTS12UnionMember2", [[META3]], i64 0, i64 4, [[META4]], i64 8, i64 8}
//.
