/*
 * Decompiled with CFR 0.152.
 */
package org.drools.examples.eventing;

import java.util.ArrayList;
import java.util.List;
import org.drools.examples.eventing.Event;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventRequest {
    private String email;
    private String description;
    private List<Event> events;
    private List<String> errors;
    private Status status = Status.NEW;

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<Event> getEvents() {
        return this.events;
    }

    public void addEvent(Event event) {
        if (this.events == null) {
            this.events = new ArrayList<Event>();
        }
        this.events.add(event);
    }

    public void setEvents(List<Event> events) {
        this.events = events;
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public void addError(String error) {
        if (this.errors == null) {
            this.errors = new ArrayList<String>();
        }
        this.errors.add(error);
    }

    public String getErrorMessage() {
        if (this.errors == null) {
            return "No errors!";
        }
        String errorMsg = "Number of errors: " + this.errors.size() + "\n";
        int i = 0;
        for (String error : this.errors) {
            errorMsg = String.valueOf(errorMsg) + "   [" + ++i + "] " + error;
            if (i >= this.errors.size()) continue;
            errorMsg = String.valueOf(errorMsg) + "\n";
        }
        return errorMsg;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public String toString() {
        return "Event request from " + this.email + ": " + this.description;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        NEW,
        ACTIVE,
        COMPLETED;

    }
}

