/*
 *  SPDX-License-Identifier: GPL-2.0-or-later
 *
 *  Copyright (C) 2021-2021  The DOSBox Staging Team
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
#ifndef DOSBOX_STRING_OPS_H
#define DOSBOX_STRING_OPS_H

// string instructions
enum STRING_OP {
	R_OUTSB = 0,
	R_OUTSW,
	R_OUTSD,
	R_INSB = 4,
	R_INSW,
	R_INSD,
	R_MOVSB = 8,
	R_MOVSW,
	R_MOVSD,
	R_LODSB = 12,
	R_LODSW,
	R_LODSD,
	R_STOSB = 16,
	R_STOSW,
	R_STOSD,
	R_SCASB = 20,
	R_SCASW,
	R_SCASD,
	R_CMPSB = 24,
	R_CMPSW,
	R_CMPSD,
};

#endif
