/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentProvider;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.content.Content;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsLogTabLocation;
import com.intellij.vcs.log.impl.VcsLogTabsManager;
import com.intellij.vcs.log.impl.VcsLogTabsUtil;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcs.log.ui.MainVcsLogUi;
import com.intellij.vcs.log.ui.VcsLogPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 %2\u00020\u0001:\u0003#$%B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000bH\u0016J\u0015\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0001\u00a2\u0006\u0002\b\u0019J\b\u0010\u001a\u001a\u00020\u0014H\u0002J\r\u0010\u001b\u001a\u00020\u0014H\u0001\u00a2\u0006\u0002\b\u001cJ\u0018\u0010\u001d\u001a\u00020\u00142\u000e\u0010\u001e\u001a\n\u0012\u0006\b\u0000\u0012\u00020\r0\u001fH\u0007J\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00020\r0!H\u0007J\b\u0010\"\u001a\u00020\u0014H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u000e\u001a\u0004\u0018\u00010\r2\b\u0010\f\u001a\u0004\u0018\u00010\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/intellij/vcs/log/impl/VcsLogContentProvider;", "Lcom/intellij/openapi/vcs/changes/ui/ChangesViewContentProvider;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "projectLog", "Lcom/intellij/vcs/log/impl/VcsProjectLog;", "container", "Lcom/intellij/ui/components/JBPanel;", "tabContent", "Lcom/intellij/ui/content/Content;", "value", "Lcom/intellij/vcs/log/ui/MainVcsLogUi;", "ui", "getUi", "()Lcom/intellij/vcs/log/ui/MainVcsLogUi;", "logCreationCallback", "Lcom/google/common/util/concurrent/SettableFuture;", "initTabContent", "", "content", "addMainUi", "logManager", "Lcom/intellij/vcs/log/impl/VcsLogManager;", "addMainUi$intellij_platform_vcs_log_impl", "updateDisplayName", "disposeMainUi", "disposeMainUi$intellij_platform_vcs_log_impl", "executeOnMainUiCreated", "consumer", "Lcom/intellij/util/Consumer;", "waitMainUiCreation", "Lcom/google/common/util/concurrent/ListenableFuture;", "disposeContent", "VcsLogVisibilityPredicate", "DisplayNameSupplier", "Companion", "intellij.platform.vcs.log.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nVcsLogContentProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcsLogContentProvider.kt\ncom/intellij/vcs/log/impl/VcsLogContentProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,174:1\n1#2:175\n25#3:176\n25#3:177\n*S KotlinDebug\n*F\n+ 1 VcsLogContentProvider.kt\ncom/intellij/vcs/log/impl/VcsLogContentProvider\n*L\n52#1:176\n74#1:177\n*E\n"})
public final class VcsLogContentProvider
implements ChangesViewContentProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final VcsProjectLog projectLog;
    @NotNull
    private final JBPanel<JBPanel<?>> container;
    @Nullable
    private Content tabContent;
    @Nullable
    private MainVcsLogUi ui;
    @Nullable
    private SettableFuture<MainVcsLogUi> logCreationCallback;
    @NotNull
    public static final String TAB_NAME = "Log";
    @NotNull
    public static final String MAIN_LOG_ID = "MAIN";

    public VcsLogContentProvider(@NotNull Project project) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
            this.projectLog = VcsProjectLog.Companion.getInstance(this.project);
            this.container = new JBPanel((LayoutManager)new BorderLayout());
            VcsLogManager vcsLogManager = this.projectLog.getLogManager();
            if (vcsLogManager == null) break block0;
            VcsLogManager it = vcsLogManager;
            boolean bl = false;
            this.addMainUi$intellij_platform_vcs_log_impl(it);
        }
    }

    @Nullable
    public final MainVcsLogUi getUi() {
        return this.ui;
    }

    public void initTabContent(@NotNull Content content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        if (this.projectLog.isDisposing()) {
            return;
        }
        VcsLogContentProvider $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(VcsLogContentProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.debug("Adding main Log ui container to the content for " + this.project.getName());
        Content content2 = this.tabContent = content;
        Intrinsics.checkNotNull((Object)content2);
        content2.setTabName(TAB_NAME);
        this.updateDisplayName();
        this.projectLog.createLogInBackground(true);
        content.setComponent((JComponent)this.container);
        content.setDisposer(() -> VcsLogContentProvider.initTabContent$lambda$1(this));
    }

    @RequiresEdt
    public final void addMainUi$intellij_platform_vcs_log_impl(@NotNull VcsLogManager logManager2) {
        Intrinsics.checkNotNullParameter((Object)logManager2, (String)"logManager");
        ThreadingAssertions.assertEventDispatchThread();
        if (this.ui == null) {
            VcsLogContentProvider $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(VcsLogContentProvider.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.debug("Creating main Log ui for " + this.project.getName());
            MainVcsLogUi mainVcsLogUi = this.ui = logManager2.createLogUi(MAIN_LOG_ID, VcsLogTabLocation.TOOL_WINDOW, false);
            Intrinsics.checkNotNull((Object)mainVcsLogUi);
            VcsLogPanel panel = new VcsLogPanel(logManager2, mainVcsLogUi);
            this.container.add((Component)((Object)panel), (Object)"Center");
            this.updateDisplayName();
            MainVcsLogUi mainVcsLogUi2 = this.ui;
            Intrinsics.checkNotNull((Object)mainVcsLogUi2);
            VcsLogTabsManager.Companion.onDisplayNameChange(mainVcsLogUi2, (Function0<Unit>)((Function0)() -> VcsLogContentProvider.addMainUi$lambda$2(this)));
            if (this.logCreationCallback != null) {
                SettableFuture<MainVcsLogUi> settableFuture = this.logCreationCallback;
                Intrinsics.checkNotNull(settableFuture);
                settableFuture.set((Object)this.ui);
                this.logCreationCallback = null;
            }
        }
    }

    private final void updateDisplayName() {
        if (this.tabContent != null && this.ui != null) {
            Content content = this.tabContent;
            Intrinsics.checkNotNull((Object)content);
            MainVcsLogUi mainVcsLogUi = this.ui;
            Intrinsics.checkNotNull((Object)mainVcsLogUi);
            content.setDisplayName(VcsLogTabsUtil.generateDisplayName(mainVcsLogUi));
        }
    }

    @RequiresEdt
    public final void disposeMainUi$intellij_platform_vcs_log_impl() {
        block1: {
            ThreadingAssertions.assertEventDispatchThread();
            this.container.removeAll();
            SettableFuture<MainVcsLogUi> settableFuture = this.logCreationCallback;
            if (settableFuture != null) {
                SettableFuture<MainVcsLogUi> callback = settableFuture;
                boolean bl = false;
                this.logCreationCallback = null;
                callback.set(null);
            }
            MainVcsLogUi mainVcsLogUi = this.ui;
            if (mainVcsLogUi == null) break block1;
            MainVcsLogUi oldUi = mainVcsLogUi;
            boolean bl = false;
            this.ui = null;
            Disposer.dispose((Disposable)oldUi);
        }
    }

    @RequiresEdt
    public final void executeOnMainUiCreated(@NotNull Consumer<? super MainVcsLogUi> consumer) {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        ThreadingAssertions.assertEventDispatchThread();
        ListenableFuture<MainVcsLogUi> future = this.waitMainUiCreation();
        future.addListener(() -> VcsLogContentProvider.executeOnMainUiCreated$lambda$5(future, consumer), MoreExecutors.directExecutor());
    }

    @RequiresEdt
    @NotNull
    public final ListenableFuture<MainVcsLogUi> waitMainUiCreation() {
        SettableFuture settableFuture;
        ThreadingAssertions.assertEventDispatchThread();
        if (this.ui != null) {
            ListenableFuture listenableFuture = Futures.immediateFuture((Object)this.ui);
            Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"immediateFuture(...)");
            return listenableFuture;
        }
        if (this.logCreationCallback != null) {
            SettableFuture<MainVcsLogUi> settableFuture2 = this.logCreationCallback;
            Intrinsics.checkNotNull(settableFuture2);
            settableFuture2.set(null);
        }
        this.logCreationCallback = settableFuture = SettableFuture.create();
        Intrinsics.checkNotNull((Object)settableFuture);
        return (ListenableFuture)settableFuture;
    }

    public void disposeContent() {
        this.disposeMainUi$intellij_platform_vcs_log_impl();
    }

    private static final void initTabContent$lambda$1(VcsLogContentProvider this$0) {
        this$0.disposeContent();
        this$0.tabContent = null;
    }

    private static final Unit addMainUi$lambda$2(VcsLogContentProvider this$0) {
        this$0.updateDisplayName();
        return Unit.INSTANCE;
    }

    private static final void executeOnMainUiCreated$lambda$5(ListenableFuture $future, Consumer $consumer) {
        try {
            MainVcsLogUi result = (MainVcsLogUi)$future.get();
            if (result != null) {
                $consumer.consume((Object)result);
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/vcs/log/impl/VcsLogContentProvider$Companion;", "", "<init>", "()V", "TAB_NAME", "", "Lorg/jetbrains/annotations/NonNls;", "MAIN_LOG_ID", "intellij.platform.vcs.log.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0002H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/intellij/vcs/log/impl/VcsLogContentProvider$DisplayNameSupplier;", "Ljava/util/function/Supplier;", "", "<init>", "()V", "get", "intellij.platform.vcs.log.impl"})
    public static final class DisplayNameSupplier
    implements Supplier<String> {
        @Override
        @NotNull
        public String get() {
            String string = VcsLogBundle.message("vcs.log.tab.name", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/vcs/log/impl/VcsLogContentProvider$VcsLogVisibilityPredicate;", "Ljava/util/function/Predicate;", "Lcom/intellij/openapi/project/Project;", "<init>", "()V", "test", "", "project", "intellij.platform.vcs.log.impl"})
    public static final class VcsLogVisibilityPredicate
    implements Predicate<Project> {
        @Override
        public boolean test(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return !VcsProjectLog.Companion.getLogProviders(project).isEmpty();
        }
    }
}

