/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webSymbols.utils;

import com.intellij.model.Pointer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.KotlinUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.Stack;
import com.intellij.webSymbols.WebSymbol;
import com.intellij.webSymbols.WebSymbolQualifiedKind;
import com.intellij.webSymbols.WebSymbolsScope;
import com.intellij.webSymbols.query.WebSymbolsCompoundScope;
import com.intellij.webSymbols.query.WebSymbolsListSymbolsQueryParams;
import com.intellij.webSymbols.query.WebSymbolsQueryExecutor;
import com.intellij.webSymbols.utils.WebSymbolUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00022\u00020\u0004:\u0003./0B\u000f\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0006\u0010\u0007J$\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\u001d0!H\u0014J\n\u0010#\u001a\u0004\u0018\u00010$H\u0004J\n\u0010%\u001a\u0004\u0018\u00010$H\u0004J\u0013\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010)H\u0096\u0002J\b\u0010*\u001a\u00020+H\u0016J\u0012\u0010,\u001a\u0004\u0018\u00010$2\u0006\u0010-\u001a\u00020$H\u0014R\u0016\u0010\u0005\u001a\u00028\u0000X\u0084\u0004\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\tR\u0014\u0010\u000b\u001a\u0004\u0018\u00018\u0001X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\tRD\u0010\r\u001a4\u0012\u0013\u0012\u00118\u0001\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\u0013\u0012\u00110\u0012\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u000eX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0018\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u00061"}, d2={"Lcom/intellij/webSymbols/utils/WebSymbolsStructuredScope;", "T", "Lcom/intellij/psi/PsiElement;", "R", "Lcom/intellij/webSymbols/query/WebSymbolsCompoundScope;", "location", "<init>", "(Lcom/intellij/psi/PsiElement;)V", "getLocation", "()Lcom/intellij/psi/PsiElement;", "Lcom/intellij/psi/PsiElement;", "rootPsiElement", "getRootPsiElement", "scopesBuilderProvider", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "rootPsiScope", "Lcom/intellij/webSymbols/utils/WebSymbolsStructuredScope$WebSymbolsPsiScopesHolder;", "holder", "Lcom/intellij/psi/PsiElementVisitor;", "getScopesBuilderProvider", "()Lkotlin/jvm/functions/Function2;", "providedSymbolKinds", "", "Lcom/intellij/webSymbols/WebSymbolQualifiedKind;", "getProvidedSymbolKinds", "()Ljava/util/Set;", "build", "", "queryExecutor", "Lcom/intellij/webSymbols/query/WebSymbolsQueryExecutor;", "consumer", "Lkotlin/Function1;", "Lcom/intellij/webSymbols/WebSymbolsScope;", "getCurrentScope", "Lcom/intellij/webSymbols/utils/WebSymbolsStructuredScope$WebSymbolsPsiScope;", "getRootScope", "equals", "", "other", "", "hashCode", "", "findBestMatchingScope", "rootScope", "WebSymbolsPsiScopesHolder", "WebSymbolsPsiScope", "WebSymbolsPsiScopeImpl", "intellij.platform.webSymbols"})
@SourceDebugExtension(value={"SMAP\nWebSymbolsStructuredScope.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebSymbolsStructuredScope.kt\ncom/intellij/webSymbols/utils/WebSymbolsStructuredScope\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,215:1\n1#2:216\n*E\n"})
public abstract class WebSymbolsStructuredScope<T extends PsiElement, R extends PsiElement>
extends WebSymbolsCompoundScope {
    @NotNull
    private final T location;

    public WebSymbolsStructuredScope(@NotNull T location) {
        Intrinsics.checkNotNullParameter(location, (String)"location");
        this.location = location;
    }

    @NotNull
    protected final T getLocation() {
        return this.location;
    }

    @Nullable
    protected abstract R getRootPsiElement();

    @NotNull
    protected abstract Function2<R, WebSymbolsPsiScopesHolder, PsiElementVisitor> getScopesBuilderProvider();

    @NotNull
    protected abstract Set<WebSymbolQualifiedKind> getProvidedSymbolKinds();

    @Override
    protected void build(@NotNull WebSymbolsQueryExecutor queryExecutor, @NotNull Function1<? super WebSymbolsScope, Unit> consumer) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)queryExecutor, (String)"queryExecutor");
            Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
            WebSymbolsPsiScope webSymbolsPsiScope = this.getCurrentScope();
            if (webSymbolsPsiScope == null) break block0;
            WebSymbolsPsiScope it = webSymbolsPsiScope;
            boolean bl = false;
            consumer.invoke((Object)it);
        }
    }

    @Nullable
    protected final WebSymbolsPsiScope getCurrentScope() {
        WebSymbolsPsiScope webSymbolsPsiScope;
        WebSymbolsPsiScope webSymbolsPsiScope2 = this.getRootScope();
        if (webSymbolsPsiScope2 != null) {
            WebSymbolsPsiScope it = webSymbolsPsiScope2;
            boolean bl = false;
            webSymbolsPsiScope = this.findBestMatchingScope(it);
        } else {
            webSymbolsPsiScope = null;
        }
        return webSymbolsPsiScope;
    }

    @Nullable
    protected final WebSymbolsPsiScope getRootScope() {
        CachedValuesManager manager = CachedValuesManager.getManager((Project)this.location.getProject());
        R r = this.getRootPsiElement();
        if (r == null) {
            return null;
        }
        R rootPsiElement = r;
        Function2<R, WebSymbolsPsiScopesHolder, PsiElementVisitor> scopeBuilderProvider = this.getScopesBuilderProvider();
        Set<WebSymbolQualifiedKind> providedSymbolKinds = this.getProvidedSymbolKinds();
        return (WebSymbolsPsiScope)manager.getCachedValue((UserDataHolder)rootPsiElement, manager.getKeyForClass(this.getClass()), () -> WebSymbolsStructuredScope.getRootScope$lambda$3(rootPsiElement, providedSymbolKinds, scopeBuilderProvider), false);
    }

    public boolean equals(@Nullable Object other) {
        return other == this || other instanceof WebSymbolsStructuredScope && other.getClass() == this.getClass() && Intrinsics.areEqual(((WebSymbolsStructuredScope)other).location, this.location);
    }

    public int hashCode() {
        return this.location.hashCode();
    }

    @Nullable
    protected WebSymbolsPsiScope findBestMatchingScope(@NotNull WebSymbolsPsiScope rootScope) {
        Intrinsics.checkNotNullParameter((Object)rootScope, (String)"rootScope");
        return ((WebSymbolsPsiScopeImpl)rootScope).findBestMatchingScope(this.location.getTextOffset());
    }

    private static final CachedValueProvider.Result getRootScope$lambda$3(PsiElement $rootPsiElement, Set $providedSymbolKinds, Function2 $scopeBuilderProvider) {
        WebSymbolsPsiScopesHolder holder = new WebSymbolsPsiScopesHolder($rootPsiElement, $providedSymbolKinds);
        PsiElementVisitor psiElementVisitor = (PsiElementVisitor)$scopeBuilderProvider.invoke((Object)$rootPsiElement, (Object)holder);
        if (psiElementVisitor != null) {
            PsiElementVisitor it = psiElementVisitor;
            boolean bl = false;
            $rootPsiElement.accept(it);
        }
        Object[] objectArray = new Object[]{$rootPsiElement, PsiModificationTracker.MODIFICATION_COUNT};
        return CachedValueProvider.Result.create((Object)holder.getTopLevelScope$intellij_platform_webSymbols(), (Object[])objectArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\bd\u0018\u00002\u00020\u0001J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00140\u00102\u0006\u0010\u0017\u001a\u00020\u0018H&R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u0000X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0018\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00000\u0010X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0018\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0010X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0012\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0019\u00c0\u0006\u0001"}, d2={"Lcom/intellij/webSymbols/utils/WebSymbolsStructuredScope$WebSymbolsPsiScope;", "Lcom/intellij/webSymbols/WebSymbolsScope;", "source", "Lcom/intellij/psi/PsiElement;", "getSource", "()Lcom/intellij/psi/PsiElement;", "parent", "getParent", "()Lcom/intellij/webSymbols/utils/WebSymbolsStructuredScope$WebSymbolsPsiScope;", "properties", "", "", "", "getProperties", "()Ljava/util/Map;", "children", "", "getChildren", "()Ljava/util/List;", "localSymbols", "Lcom/intellij/webSymbols/WebSymbol;", "getLocalSymbols", "getAllSymbols", "qualifiedKind", "Lcom/intellij/webSymbols/WebSymbolQualifiedKind;", "intellij.platform.webSymbols"})
    protected static interface WebSymbolsPsiScope
    extends WebSymbolsScope {
        @NotNull
        public PsiElement getSource();

        @Nullable
        public WebSymbolsPsiScope getParent();

        @NotNull
        public Map<String, Object> getProperties();

        @NotNull
        public List<WebSymbolsPsiScope> getChildren();

        @NotNull
        public List<WebSymbol> getLocalSymbols();

        @NotNull
        public List<WebSymbol> getAllSymbols(@NotNull WebSymbolQualifiedKind var1);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\b\u0002\u0018\u00002\u00020\u0001BI\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0000\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010'\u001a\u0004\u0018\u00010\u00012\u0006\u0010(\u001a\u00020)J\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u000bH\u0016J,\u0010-\u001a\b\u0012\u0004\u0012\u00020/0.2\u0006\u0010,\u001a\u00020\u000b2\u0006\u00100\u001a\u0002012\f\u00102\u001a\b\u0012\u0004\u0012\u00020/03H\u0016J\u0016\u00104\u001a\b\u0012\u0004\u0012\u00020\u001c0.2\u0006\u0010,\u001a\u00020\u000bH\u0016J\u000e\u00105\u001a\u0002062\u0006\u00107\u001a\u00020\u001cJ\u0010\u00105\u001a\u0002062\u0006\u00102\u001a\u00020\u0000H\u0002J\u0013\u00108\u001a\u00020+2\b\u00109\u001a\u0004\u0018\u00010\u0007H\u0096\u0002J\b\u0010:\u001a\u00020)H\u0016J\u0010\u0010;\u001a\n\u0012\u0006\b\u0001\u0012\u00020/0<H\u0016J\b\u0010=\u001a\u00020>H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R \u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0016\u0010\b\u001a\u0004\u0018\u00010\u0000X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020\u00000\u0016j\b\u0012\u0004\u0012\u00020\u0000`\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020 8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u001a\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00000$8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&\u00a8\u0006?"}, d2={"Lcom/intellij/webSymbols/utils/WebSymbolsStructuredScope$WebSymbolsPsiScopeImpl;", "Lcom/intellij/webSymbols/utils/WebSymbolsStructuredScope$WebSymbolsPsiScope;", "source", "Lcom/intellij/psi/PsiElement;", "properties", "", "", "", "parent", "providedSymbolKinds", "", "Lcom/intellij/webSymbols/WebSymbolQualifiedKind;", "exclusiveSymbolKinds", "<init>", "(Lcom/intellij/psi/PsiElement;Ljava/util/Map;Lcom/intellij/webSymbols/utils/WebSymbolsStructuredScope$WebSymbolsPsiScopeImpl;Ljava/util/Set;Ljava/util/Set;)V", "getSource", "()Lcom/intellij/psi/PsiElement;", "getProperties", "()Ljava/util/Map;", "getParent", "()Lcom/intellij/webSymbols/utils/WebSymbolsStructuredScope$WebSymbolsPsiScopeImpl;", "children", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "getChildren", "()Ljava/util/ArrayList;", "localSymbols", "Lcom/intellij/util/SmartList;", "Lcom/intellij/webSymbols/WebSymbol;", "getLocalSymbols", "()Lcom/intellij/util/SmartList;", "textRange", "Lcom/intellij/openapi/util/TextRange;", "getTextRange", "()Lcom/intellij/openapi/util/TextRange;", "scopesInHierarchy", "Lkotlin/sequences/Sequence;", "getScopesInHierarchy", "()Lkotlin/sequences/Sequence;", "findBestMatchingScope", "offset", "", "isExclusiveFor", "", "qualifiedKind", "getSymbols", "", "Lcom/intellij/webSymbols/WebSymbolsScope;", "params", "Lcom/intellij/webSymbols/query/WebSymbolsListSymbolsQueryParams;", "scope", "Lcom/intellij/util/containers/Stack;", "getAllSymbols", "add", "", "symbol", "equals", "other", "hashCode", "createPointer", "Lcom/intellij/model/Pointer;", "getModificationCount", "", "intellij.platform.webSymbols"})
    @SourceDebugExtension(value={"SMAP\nWebSymbolsStructuredScope.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebSymbolsStructuredScope.kt\ncom/intellij/webSymbols/utils/WebSymbolsStructuredScope$WebSymbolsPsiScopeImpl\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,215:1\n1251#2,2:216\n*S KotlinDebug\n*F\n+ 1 WebSymbolsStructuredScope.kt\ncom/intellij/webSymbols/utils/WebSymbolsStructuredScope$WebSymbolsPsiScopeImpl\n*L\n172#1:216,2\n*E\n"})
    private static final class WebSymbolsPsiScopeImpl
    implements WebSymbolsPsiScope {
        @NotNull
        private final PsiElement source;
        @NotNull
        private final Map<String, Object> properties;
        @Nullable
        private final WebSymbolsPsiScopeImpl parent;
        @NotNull
        private final Set<WebSymbolQualifiedKind> providedSymbolKinds;
        @NotNull
        private final Set<WebSymbolQualifiedKind> exclusiveSymbolKinds;
        @NotNull
        private final ArrayList<WebSymbolsPsiScopeImpl> children;
        @NotNull
        private final SmartList<WebSymbol> localSymbols;

        public WebSymbolsPsiScopeImpl(@NotNull PsiElement source, @NotNull Map<String, ? extends Object> properties, @Nullable WebSymbolsPsiScopeImpl parent, @NotNull Set<WebSymbolQualifiedKind> providedSymbolKinds, @NotNull Set<WebSymbolQualifiedKind> exclusiveSymbolKinds) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                Intrinsics.checkNotNullParameter(properties, (String)"properties");
                Intrinsics.checkNotNullParameter(providedSymbolKinds, (String)"providedSymbolKinds");
                Intrinsics.checkNotNullParameter(exclusiveSymbolKinds, (String)"exclusiveSymbolKinds");
                this.source = source;
                this.properties = properties;
                this.parent = parent;
                this.providedSymbolKinds = providedSymbolKinds;
                this.exclusiveSymbolKinds = exclusiveSymbolKinds;
                this.children = new ArrayList();
                this.localSymbols = new SmartList();
                WebSymbolsPsiScopeImpl webSymbolsPsiScopeImpl = this.getParent();
                if (webSymbolsPsiScopeImpl == null) break block0;
                webSymbolsPsiScopeImpl.add(this);
            }
        }

        @Override
        @NotNull
        public PsiElement getSource() {
            return this.source;
        }

        @Override
        @NotNull
        public Map<String, Object> getProperties() {
            return this.properties;
        }

        @Override
        @Nullable
        public WebSymbolsPsiScopeImpl getParent() {
            return this.parent;
        }

        @NotNull
        public ArrayList<WebSymbolsPsiScopeImpl> getChildren() {
            return this.children;
        }

        @NotNull
        public SmartList<WebSymbol> getLocalSymbols() {
            return this.localSymbols;
        }

        private final TextRange getTextRange() {
            TextRange textRange = this.getSource().getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
            return textRange;
        }

        private final Sequence<WebSymbolsPsiScopeImpl> getScopesInHierarchy() {
            return SequencesKt.generateSequence((Object)this, WebSymbolsPsiScopeImpl::_get_scopesInHierarchy_$lambda$0);
        }

        @Nullable
        public final WebSymbolsPsiScope findBestMatchingScope(int offset) {
            if (!this.getTextRange().contains(offset)) {
                return null;
            }
            WebSymbolsPsiScopeImpl curScope = null;
            WebSymbolsPsiScopeImpl innerScope = this;
            block0: while (innerScope != null) {
                Iterator iterator;
                curScope = innerScope;
                innerScope = null;
                Intrinsics.checkNotNullExpressionValue(((ArrayList)curScope.getChildren()).iterator(), (String)"iterator(...)");
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                    WebSymbolsPsiScopeImpl child = (WebSymbolsPsiScopeImpl)e;
                    if (!child.getTextRange().contains(offset)) continue;
                    innerScope = child;
                    continue block0;
                }
            }
            return curScope;
        }

        @Override
        public boolean isExclusiveFor(@NotNull WebSymbolQualifiedKind qualifiedKind) {
            boolean bl;
            block1: {
                Intrinsics.checkNotNullParameter((Object)qualifiedKind, (String)"qualifiedKind");
                Sequence<WebSymbolsPsiScopeImpl> $this$any$iv = this.getScopesInHierarchy();
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    WebSymbolsPsiScopeImpl it = (WebSymbolsPsiScopeImpl)element$iv;
                    boolean bl2 = false;
                    if (!it.exclusiveSymbolKinds.contains(qualifiedKind)) continue;
                    bl = true;
                    break block1;
                }
                bl = false;
            }
            return bl;
        }

        @Override
        @NotNull
        public List<WebSymbolsScope> getSymbols(@NotNull WebSymbolQualifiedKind qualifiedKind, @NotNull WebSymbolsListSymbolsQueryParams params, @NotNull Stack<WebSymbolsScope> scope) {
            Intrinsics.checkNotNullParameter((Object)qualifiedKind, (String)"qualifiedKind");
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            Intrinsics.checkNotNullParameter(scope, (String)"scope");
            return this.getAllSymbols(qualifiedKind);
        }

        @Override
        @NotNull
        public List<WebSymbol> getAllSymbols(@NotNull WebSymbolQualifiedKind qualifiedKind) {
            Intrinsics.checkNotNullParameter((Object)qualifiedKind, (String)"qualifiedKind");
            return this.providedSymbolKinds.contains(qualifiedKind) ? SequencesKt.toList((Sequence)SequencesKt.distinctBy((Sequence)SequencesKt.filter((Sequence)SequencesKt.flatMapIterable((Sequence)KotlinUtils.takeWhileInclusive(this.getScopesInHierarchy(), arg_0 -> WebSymbolsPsiScopeImpl.getAllSymbols$lambda$2(qualifiedKind, arg_0)), WebSymbolsPsiScopeImpl::getAllSymbols$lambda$3), arg_0 -> WebSymbolsPsiScopeImpl.getAllSymbols$lambda$4(qualifiedKind, arg_0)), WebSymbolsPsiScopeImpl::getAllSymbols$lambda$5)) : CollectionsKt.emptyList();
        }

        public final void add(@NotNull WebSymbol symbol) {
            Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
            this.getLocalSymbols().add((Object)symbol);
        }

        private final void add(WebSymbolsPsiScopeImpl scope) {
            ((ArrayList)this.getChildren()).add(scope);
        }

        public boolean equals(@Nullable Object other) {
            return other instanceof WebSymbolsPsiScopeImpl && Intrinsics.areEqual((Object)((WebSymbolsPsiScopeImpl)other).getSource(), (Object)this.getSource()) && Intrinsics.areEqual((Object)((WebSymbolsPsiScopeImpl)other).getTextRange(), (Object)this.getTextRange());
        }

        public int hashCode() {
            return this.getSource().hashCode();
        }

        @Override
        @NotNull
        public Pointer<? extends WebSymbolsScope> createPointer() {
            throw new IllegalStateException("WebSymbolsPsiScopeImpl cannot be pointed to.");
        }

        public long getModificationCount() {
            return 0L;
        }

        private static final WebSymbolsPsiScopeImpl _get_scopesInHierarchy_$lambda$0(WebSymbolsPsiScopeImpl it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.getParent();
        }

        private static final boolean getAllSymbols$lambda$2(WebSymbolQualifiedKind $qualifiedKind, WebSymbolsPsiScopeImpl it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return !it.isExclusiveFor($qualifiedKind);
        }

        private static final Iterable getAllSymbols$lambda$3(WebSymbolsPsiScopeImpl it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return (Iterable)it.getLocalSymbols();
        }

        private static final boolean getAllSymbols$lambda$4(WebSymbolQualifiedKind $qualifiedKind, WebSymbol it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Intrinsics.areEqual((Object)WebSymbolUtils.getQualifiedKind(it), (Object)$qualifiedKind);
        }

        private static final String getAllSymbols$lambda$5(WebSymbol it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.getName();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0004\u0018\u00002\u00020\u0001:\u0002!\"B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\u0013\u001a\u00020\u000fJ\u0006\u0010\u0014\u001a\u00020\u000fJ\u0006\u0010\u0015\u001a\u00020\u0016JQ\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00032\u0014\b\u0002\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00010\u001a2\u000e\b\u0002\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u001b\b\u0002\u0010\u001d\u001a\u0015\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u001e\u00a2\u0006\u0002\b J\u001f\u0010\u0013\u001a\u00020\u00162\u0017\u0010\u001d\u001a\u0013\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u00160\u001e\u00a2\u0006\u0002\b J\u001f\u0010\u0014\u001a\u00020\u00162\u0017\u0010\u001d\u001a\u0013\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u00160\u001e\u00a2\u0006\u0002\b R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u000f8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006#"}, d2={"Lcom/intellij/webSymbols/utils/WebSymbolsStructuredScope$WebSymbolsPsiScopesHolder;", "", "rootElement", "Lcom/intellij/psi/PsiElement;", "providedSymbolKinds", "", "Lcom/intellij/webSymbols/WebSymbolQualifiedKind;", "<init>", "(Lcom/intellij/psi/PsiElement;Ljava/util/Set;)V", "getRootElement", "()Lcom/intellij/psi/PsiElement;", "getProvidedSymbolKinds", "()Ljava/util/Set;", "scopes", "Lcom/intellij/util/containers/Stack;", "Lcom/intellij/webSymbols/utils/WebSymbolsStructuredScope$WebSymbolsPsiScope;", "topLevelScope", "getTopLevelScope$intellij_platform_webSymbols", "()Lcom/intellij/webSymbols/utils/WebSymbolsStructuredScope$WebSymbolsPsiScope;", "currentScope", "previousScope", "popScope", "", "pushScope", "scopePsiElement", "properties", "", "", "exclusiveSymbolKinds", "updater", "Lkotlin/Function1;", "Lcom/intellij/webSymbols/utils/WebSymbolsStructuredScope$WebSymbolsPsiScopesHolder$ScopeModifier;", "Lkotlin/ExtensionFunctionType;", "ScopeModifier", "ScopeModifierImpl", "intellij.platform.webSymbols"})
    protected static final class WebSymbolsPsiScopesHolder {
        @NotNull
        private final PsiElement rootElement;
        @NotNull
        private final Set<WebSymbolQualifiedKind> providedSymbolKinds;
        @NotNull
        private final Stack<WebSymbolsPsiScope> scopes;

        public WebSymbolsPsiScopesHolder(@NotNull PsiElement rootElement, @NotNull Set<WebSymbolQualifiedKind> providedSymbolKinds) {
            Intrinsics.checkNotNullParameter((Object)rootElement, (String)"rootElement");
            Intrinsics.checkNotNullParameter(providedSymbolKinds, (String)"providedSymbolKinds");
            this.rootElement = rootElement;
            this.providedSymbolKinds = providedSymbolKinds;
            this.scopes = new Stack();
            this.scopes.add((Object)new WebSymbolsPsiScopeImpl(this.rootElement, MapsKt.emptyMap(), null, this.providedSymbolKinds, SetsKt.emptySet()));
        }

        @NotNull
        public final PsiElement getRootElement() {
            return this.rootElement;
        }

        @NotNull
        public final Set<WebSymbolQualifiedKind> getProvidedSymbolKinds() {
            return this.providedSymbolKinds;
        }

        @NotNull
        public final WebSymbolsPsiScope getTopLevelScope$intellij_platform_webSymbols() {
            boolean bl;
            boolean bl2 = bl = this.scopes.size() == 1;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            Object object = this.scopes.peek();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"peek(...)");
            return (WebSymbolsPsiScope)object;
        }

        @NotNull
        public final WebSymbolsPsiScope currentScope() {
            Object object = this.scopes.peek();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"peek(...)");
            return (WebSymbolsPsiScope)object;
        }

        @NotNull
        public final WebSymbolsPsiScope previousScope() {
            Object object = this.scopes.get(this.scopes.size() - 2);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            return (WebSymbolsPsiScope)object;
        }

        public final void popScope() {
            this.scopes.pop();
        }

        public final void pushScope(@NotNull PsiElement scopePsiElement, @NotNull Map<String, ? extends Object> properties, @NotNull Set<WebSymbolQualifiedKind> exclusiveSymbolKinds, @Nullable Function1<? super ScopeModifier, Unit> updater) {
            Intrinsics.checkNotNullParameter((Object)scopePsiElement, (String)"scopePsiElement");
            Intrinsics.checkNotNullParameter(properties, (String)"properties");
            Intrinsics.checkNotNullParameter(exclusiveSymbolKinds, (String)"exclusiveSymbolKinds");
            WebSymbolsPsiScope webSymbolsPsiScope = this.currentScope();
            Intrinsics.checkNotNull((Object)webSymbolsPsiScope, (String)"null cannot be cast to non-null type com.intellij.webSymbols.utils.WebSymbolsStructuredScope.WebSymbolsPsiScopeImpl");
            WebSymbolsPsiScopeImpl scope = new WebSymbolsPsiScopeImpl(scopePsiElement, properties, (WebSymbolsPsiScopeImpl)webSymbolsPsiScope, this.providedSymbolKinds, exclusiveSymbolKinds);
            this.scopes.push((Object)scope);
            if (updater != null) {
                updater.invoke((Object)new ScopeModifierImpl(scope));
            }
        }

        public static /* synthetic */ void pushScope$default(WebSymbolsPsiScopesHolder webSymbolsPsiScopesHolder, PsiElement psiElement, Map map, Set set, Function1 function1, int n, Object object) {
            if ((n & 2) != 0) {
                map = MapsKt.emptyMap();
            }
            if ((n & 4) != 0) {
                set = SetsKt.emptySet();
            }
            if ((n & 8) != 0) {
                function1 = null;
            }
            webSymbolsPsiScopesHolder.pushScope(psiElement, map, set, (Function1<? super ScopeModifier, Unit>)function1);
        }

        public final void currentScope(@NotNull Function1<? super ScopeModifier, Unit> updater) {
            Intrinsics.checkNotNullParameter(updater, (String)"updater");
            WebSymbolsPsiScope webSymbolsPsiScope = this.currentScope();
            Intrinsics.checkNotNull((Object)webSymbolsPsiScope, (String)"null cannot be cast to non-null type com.intellij.webSymbols.utils.WebSymbolsStructuredScope.WebSymbolsPsiScopeImpl");
            updater.invoke((Object)new ScopeModifierImpl((WebSymbolsPsiScopeImpl)webSymbolsPsiScope));
        }

        public final void previousScope(@NotNull Function1<? super ScopeModifier, Unit> updater) {
            Intrinsics.checkNotNullParameter(updater, (String)"updater");
            WebSymbolsPsiScope webSymbolsPsiScope = this.previousScope();
            Intrinsics.checkNotNull((Object)webSymbolsPsiScope, (String)"null cannot be cast to non-null type com.intellij.webSymbols.utils.WebSymbolsStructuredScope.WebSymbolsPsiScopeImpl");
            updater.invoke((Object)new ScopeModifierImpl((WebSymbolsPsiScopeImpl)webSymbolsPsiScope));
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0016\u0010\u0006\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\b\u00c0\u0006\u0001"}, d2={"Lcom/intellij/webSymbols/utils/WebSymbolsStructuredScope$WebSymbolsPsiScopesHolder$ScopeModifier;", "", "addSymbol", "", "symbol", "Lcom/intellij/webSymbols/WebSymbol;", "addSymbols", "", "intellij.platform.webSymbols"})
        public static interface ScopeModifier {
            public void addSymbol(@NotNull WebSymbol var1);

            public void addSymbols(@NotNull List<? extends WebSymbol> var1);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0016\u0010\n\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/webSymbols/utils/WebSymbolsStructuredScope$WebSymbolsPsiScopesHolder$ScopeModifierImpl;", "Lcom/intellij/webSymbols/utils/WebSymbolsStructuredScope$WebSymbolsPsiScopesHolder$ScopeModifier;", "scope", "Lcom/intellij/webSymbols/utils/WebSymbolsStructuredScope$WebSymbolsPsiScopeImpl;", "<init>", "(Lcom/intellij/webSymbols/utils/WebSymbolsStructuredScope$WebSymbolsPsiScopesHolder;Lcom/intellij/webSymbols/utils/WebSymbolsStructuredScope$WebSymbolsPsiScopeImpl;)V", "addSymbol", "", "symbol", "Lcom/intellij/webSymbols/WebSymbol;", "addSymbols", "", "intellij.platform.webSymbols"})
        @SourceDebugExtension(value={"SMAP\nWebSymbolsStructuredScope.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebSymbolsStructuredScope.kt\ncom/intellij/webSymbols/utils/WebSymbolsStructuredScope$WebSymbolsPsiScopesHolder$ScopeModifierImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,215:1\n1863#2,2:216\n*S KotlinDebug\n*F\n+ 1 WebSymbolsStructuredScope.kt\ncom/intellij/webSymbols/utils/WebSymbolsStructuredScope$WebSymbolsPsiScopesHolder$ScopeModifierImpl\n*L\n119#1:216,2\n*E\n"})
        private final class ScopeModifierImpl
        implements ScopeModifier {
            @NotNull
            private final WebSymbolsPsiScopeImpl scope;

            public ScopeModifierImpl(WebSymbolsPsiScopeImpl scope) {
                Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
                this.scope = scope;
            }

            @Override
            public void addSymbol(@NotNull WebSymbol symbol) {
                Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
                if (!WebSymbolsPsiScopesHolder.this.getProvidedSymbolKinds().contains(WebSymbolUtils.getQualifiedKind(symbol))) {
                    throw new IllegalStateException("WebSymbol of kind " + WebSymbolUtils.getQualifiedKind(symbol) + " should not be provided by " + this.getClass().getName());
                }
                this.scope.add(symbol);
            }

            @Override
            public void addSymbols(@NotNull List<? extends WebSymbol> symbol) {
                Intrinsics.checkNotNullParameter(symbol, (String)"symbol");
                Iterable $this$forEach$iv = symbol;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    WebSymbol it = (WebSymbol)element$iv;
                    boolean bl = false;
                    this.addSymbol(it);
                }
            }
        }
    }
}

