/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.ide.language.properties;

import com.intellij.grazie.text.TextContent;
import com.intellij.grazie.text.TextContentBuilder;
import com.intellij.grazie.text.TextExtractor;
import com.intellij.grazie.utils.HtmlUtilsKt;
import com.intellij.grazie.utils.PsiUtilsKt;
import com.intellij.grazie.utils.Text;
import com.intellij.lang.properties.parsing.PropertiesTokenTypes;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;

final class PropertyTextExtractor
extends TextExtractor {
    private static final Pattern apostrophes = Pattern.compile("'(?=')");
    private static final Pattern continuationIndent = Pattern.compile("(?<=\n)[ \t]+");
    private static final Pattern trailingSlash = Pattern.compile("\\\\\n");

    PropertyTextExtractor() {
    }

    @Override
    @NotNull
    protected List<TextContent> buildTextContents(@NotNull PsiElement root, @NotNull Set<TextContent.TextDomain> allowedDomains) {
        if (root == null) {
            PropertyTextExtractor.$$$reportNull$$$0(0);
        }
        if (allowedDomains == null) {
            PropertyTextExtractor.$$$reportNull$$$0(1);
        }
        if (root instanceof PsiComment) {
            List<PsiElement> roots = PsiUtilsKt.getNotSoDistantSimilarSiblings(root, (Function1<? super PsiElement, Boolean>)((Function1)e -> PropertiesTokenTypes.COMMENTS.contains(PsiUtilCore.getElementType((PsiElement)e))));
            List list = ContainerUtil.createMaybeSingletonList((Object)TextContent.joinWithWhitespace('\n', ContainerUtil.mapNotNull(roots, c -> TextContentBuilder.FromPsi.removingIndents(" \t#!").build((PsiElement)c, TextContent.TextDomain.COMMENTS))));
            if (list == null) {
                PropertyTextExtractor.$$$reportNull$$$0(2);
            }
            return list;
        }
        if (PsiUtilCore.getElementType((PsiElement)root) == PropertiesTokenTypes.VALUE_CHARACTERS) {
            String str;
            int start;
            TextContent content = TextContent.builder().build(root, TextContent.TextDomain.PLAIN_TEXT);
            if (content != null) {
                content = content.excludeRanges(ContainerUtil.map(Text.allOccurrences(apostrophes, content), TextContent.Exclusion::exclude));
                content = content.excludeRanges(ContainerUtil.map(Text.allOccurrences(continuationIndent, content), TextContent.Exclusion::exclude));
                content = content.excludeRanges(ContainerUtil.map(Text.allOccurrences(trailingSlash, content), TextContent.Exclusion::exclude));
            }
            while (content != null && (start = (str = content.toString()).indexOf("{")) >= 0) {
                int end;
                int nesting = 1;
                for (end = start + 1; end < str.length(); ++end) {
                    if (str.charAt(end) == '}' && --nesting == 0) {
                        ++end;
                        break;
                    }
                    if (str.charAt(end) != '{') continue;
                    ++nesting;
                }
                content = content.markUnknown(new TextRange(start, end));
            }
            List<TextContent> list = HtmlUtilsKt.excludeHtml(content);
            if (list == null) {
                PropertyTextExtractor.$$$reportNull$$$0(3);
            }
            return list;
        }
        List<TextContent> list = List.of();
        if (list == null) {
            PropertyTextExtractor.$$$reportNull$$$0(4);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allowedDomains";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/grazie/ide/language/properties/PropertyTextExtractor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/grazie/ide/language/properties/PropertyTextExtractor";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildTextContents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildTextContents";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 3, 4 -> new IllegalStateException(string2);
        };
    }
}

