/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal;

import com.intellij.openapi.diagnostic.Logger;
import com.jediterm.terminal.TtyConnector;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.AbstractTerminalRunner;
import org.jetbrains.plugins.terminal.ShellStartupOptions;
import org.jetbrains.plugins.terminal.TerminalStartupMoment;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0001H\u0000\u001a(\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0000\"\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"initStartupMomentIfNeeded", "Lorg/jetbrains/plugins/terminal/ShellStartupOptions$Builder;", "logCommonStartupInfo", "", "connector", "Lcom/jediterm/terminal/TtyConnector;", "process", "Ljava/lang/Process;", "durationBetweenStartupAndComponentResized", "Ljava/time/Duration;", "durationBetweenStartupAndConnectorCreated", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.terminal"})
@SourceDebugExtension(value={"SMAP\nterminalStartup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 terminalStartup.kt\norg/jetbrains/plugins/terminal/TerminalStartupKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,36:1\n15#2:37\n*S KotlinDebug\n*F\n+ 1 terminalStartup.kt\norg/jetbrains/plugins/terminal/TerminalStartupKt\n*L\n35#1:37\n*E\n"})
public final class TerminalStartupKt {
    @NotNull
    private static final Logger log;

    @NotNull
    public static final ShellStartupOptions.Builder initStartupMomentIfNeeded(@NotNull ShellStartupOptions.Builder $this$initStartupMomentIfNeeded) {
        ShellStartupOptions.Builder builder;
        Intrinsics.checkNotNullParameter((Object)$this$initStartupMomentIfNeeded, (String)"<this>");
        ShellStartupOptions.Builder $this$initStartupMomentIfNeeded_u24lambda_u240 = builder = $this$initStartupMomentIfNeeded;
        boolean bl = false;
        TerminalStartupMoment terminalStartupMoment = $this$initStartupMomentIfNeeded_u24lambda_u240.getStartupMoment$intellij_terminal();
        if (terminalStartupMoment == null) {
            terminalStartupMoment = new TerminalStartupMoment();
        }
        $this$initStartupMomentIfNeeded_u24lambda_u240.startupMoment(terminalStartupMoment);
        return builder;
    }

    public static final void logCommonStartupInfo(@NotNull TtyConnector connector, @NotNull Process process, @NotNull Duration durationBetweenStartupAndComponentResized, @NotNull Duration durationBetweenStartupAndConnectorCreated) {
        Intrinsics.checkNotNullParameter((Object)connector, (String)"connector");
        Intrinsics.checkNotNullParameter((Object)process, (String)"process");
        Intrinsics.checkNotNullParameter((Object)durationBetweenStartupAndComponentResized, (String)"durationBetweenStartupAndComponentResized");
        Intrinsics.checkNotNullParameter((Object)durationBetweenStartupAndConnectorCreated, (String)"durationBetweenStartupAndConnectorCreated");
        log.info("Terminal started with " + connector.getClass().getName() + " (" + process.getClass().getName() + "), time to UI laid out: " + durationBetweenStartupAndComponentResized.toMillis() + " ms, time to process created: " + durationBetweenStartupAndConnectorCreated.toMillis() + " ms");
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(AbstractTerminalRunner.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        log = logger;
    }
}

