/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.scientific.tables.settings.ui;

import com.intellij.database.DataGridBundle;
import com.intellij.database.run.ui.table.statisticsPanel.StatisticsPanelMode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.BoundSearchableConfigurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.scientific.tables.DSTableBundle;
import com.intellij.scientific.tables.settings.DSTablesSettingsChangeListener;
import com.intellij.scientific.tables.settings.DSTablesSettingsState;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.ComboBoxKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.TextFieldKt;
import com.intellij.ui.dsl.builder.TopGap;
import com.intellij.ui.layout.ComponentPredicateKt;
import java.util.Collection;
import javax.swing.AbstractButton;
import javax.swing.ListCellRenderer;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.IntRange;
import kotlin.reflect.KMutableProperty0;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0002J\b\u0010\u000f\u001a\u00020\rH\u0002R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u0011"}, d2={"Lcom/intellij/scientific/tables/settings/ui/DSTablesSettingsConfigurable;", "Lcom/intellij/openapi/options/BoundSearchableConfigurable;", "<init>", "()V", "maxColumnCountToRenderTextField", "Lcom/intellij/ui/components/JBTextField;", "getMaxColumnCountToRenderTextField", "()Lcom/intellij/ui/components/JBTextField;", "setMaxColumnCountToRenderTextField", "(Lcom/intellij/ui/components/JBTextField;)V", "createPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "apply", "", "dsTablesSettingsChanged", "validateInputValue", "Companion", "intellij.scientific.tables"})
public final class DSTablesSettingsConfigurable
extends BoundSearchableConfigurable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public JBTextField maxColumnCountToRenderTextField;
    @NotNull
    private static final String DS_TABLES_SETTINGS_ID = "DSTables";
    @NotNull
    private static final String DS_TABLES_SETTINGS_HELP_TOPIC = "reference.settings.tables";

    public DSTablesSettingsConfigurable() {
        super(DSTableBundle.message("settings.ds.table.main.page", new Object[0]), DS_TABLES_SETTINGS_HELP_TOPIC, DS_TABLES_SETTINGS_ID);
    }

    @NotNull
    public final JBTextField getMaxColumnCountToRenderTextField() {
        JBTextField jBTextField = this.maxColumnCountToRenderTextField;
        if (jBTextField != null) {
            return jBTextField;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"maxColumnCountToRenderTextField");
        return null;
    }

    public final void setMaxColumnCountToRenderTextField(@NotNull JBTextField jBTextField) {
        Intrinsics.checkNotNullParameter((Object)jBTextField, (String)"<set-?>");
        this.maxColumnCountToRenderTextField = jBTextField;
    }

    @NotNull
    public DialogPanel createPanel() {
        DSTablesSettingsState settings = DSTablesSettingsState.Companion.getInstance();
        Ref.ObjectRef toLimitCheckBox = new Ref.ObjectRef();
        return BuilderKt.panel(arg_0 -> DSTablesSettingsConfigurable.createPanel$lambda$10(settings, toLimitCheckBox, this, arg_0));
    }

    public void apply() {
        this.validateInputValue();
        super.apply();
        this.dsTablesSettingsChanged();
    }

    private final void dsTablesSettingsChanged() {
        ((DSTablesSettingsChangeListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(DSTablesSettingsChangeListener.Companion.getDS_TABLES_SETTINGS_TOPIC())).settingsChanged();
    }

    private final void validateInputValue() throws ConfigurationException {
        String string = this.getMaxColumnCountToRenderTextField().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        int maxColumnCountToRender = Integer.parseInt(string);
        if (maxColumnCountToRender <= 0) {
            throw new ConfigurationException(DSTableBundle.message("settings.table.count.number.visible.validation.message", new Object[0]), DSTableBundle.message("settings.table.count.number.visible.validation.title", new Object[0]));
        }
    }

    private static final String createPanel$lambda$10$lambda$3$lambda$0(StatisticsPanelMode mode) {
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        return switch (WhenMappings.$EnumSwitchMapping$0[mode.ordinal()]) {
            case 1 -> DataGridBundle.message((String)"action.StatisticsPanel.Show.Off.text", (Object[])new Object[0]);
            case 2 -> DataGridBundle.message((String)"action.StatisticsPanel.Show.Compact.text", (Object[])new Object[0]);
            case 3 -> DataGridBundle.message((String)"action.StatisticsPanel.Show.Detailed.text", (Object[])new Object[0]);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private static final String createPanel$lambda$10$lambda$3$lambda$1(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final Unit createPanel$lambda$10$lambda$3$lambda$2(DSTablesSettingsState $settings, StatisticsPanelMode it) {
        if (it != null) {
            $settings.setStatisticsPanelsDefaultMode(it);
        }
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$10$lambda$3(DSTablesSettingsState $settings, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        ComboBoxKt.bindItem((Cell)$this$row.comboBox((Collection)StatisticsPanelMode.getEntries(), (ListCellRenderer)SimpleListCellRenderer.create((String)"", arg_0 -> DSTablesSettingsConfigurable.createPanel$lambda$10$lambda$3$lambda$1(DSTablesSettingsConfigurable::createPanel$lambda$10$lambda$3$lambda$0, arg_0))), (Function0)((Function0)new MutablePropertyReference0Impl((Object)$settings){

            public Object get() {
                return ((DSTablesSettingsState)((Object)this.receiver)).getStatisticsPanelsDefaultMode();
            }

            public void set(Object value) {
                ((DSTablesSettingsState)((Object)this.receiver)).setStatisticsPanelsDefaultMode((StatisticsPanelMode)value);
            }
        }), arg_0 -> DSTablesSettingsConfigurable.createPanel$lambda$10$lambda$3$lambda$2($settings, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$10$lambda$4(DSTablesSettingsState $settings, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        ButtonKt.bindSelected((Cell)$this$row.checkBox(DSTableBundle.message("settings.table.numpy.display.checkbox", new Object[0])), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl((Object)$settings){

            public Object get() {
                return ((DSTablesSettingsState)((Object)this.receiver)).getNumpyTorchTensorflowDisplayAsTable();
            }

            public void set(Object value) {
                ((DSTablesSettingsState)((Object)this.receiver)).setNumpyTorchTensorflowDisplayAsTable((Boolean)value);
            }
        }));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$10$lambda$5(Ref.ObjectRef $toLimitCheckBox, DSTablesSettingsState $settings, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $toLimitCheckBox.element = ButtonKt.bindSelected((Cell)$this$row.checkBox(DSTableBundle.message("settings.table.count.number.visible.column.checkbox", new Object[0])), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl((Object)$settings){

            public Object get() {
                return ((DSTablesSettingsState)((Object)this.receiver)).getLimitRenderedColumnsCount();
            }

            public void set(Object value) {
                ((DSTablesSettingsState)((Object)this.receiver)).setLimitRenderedColumnsCount((Boolean)value);
            }
        })).getComponent();
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$10$lambda$7$lambda$6(DSTablesSettingsConfigurable this$0, DSTablesSettingsState $settings, Ref.ObjectRef $toLimitCheckBox, Row $this$row) {
        JBCheckBox jBCheckBox;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Cell cell = TextFieldKt.bindIntText((Cell)Cell.comment$default((Cell)Row.intTextField$default((Row)$this$row, (IntRange)new IntRange(1, Integer.MAX_VALUE), null, (int)2, null), (String)DSTableBundle.message("settings.table.count.number.visible.comment", new Object[0]), (int)-1, null, (int)4, null), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl((Object)$settings){

            public Object get() {
                return ((DSTablesSettingsState)((Object)this.receiver)).getMaxColumnCountToRender();
            }

            public void set(Object value) {
                ((DSTablesSettingsState)((Object)this.receiver)).setMaxColumnCountToRender(((Number)value).intValue());
            }
        }));
        if ($toLimitCheckBox.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"toLimitCheckBox");
            jBCheckBox = null;
        } else {
            jBCheckBox = (JBCheckBox)$toLimitCheckBox.element;
        }
        this$0.setMaxColumnCountToRenderTextField((JBTextField)cell.enabledIf(ComponentPredicateKt.getSelected((AbstractButton)((AbstractButton)jBCheckBox))).getComponent());
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$10$lambda$7(DSTablesSettingsConfigurable this$0, DSTablesSettingsState $settings, Ref.ObjectRef $toLimitCheckBox, Panel $this$indent) {
        Intrinsics.checkNotNullParameter((Object)$this$indent, (String)"$this$indent");
        Panel.row$default((Panel)$this$indent, null, arg_0 -> DSTablesSettingsConfigurable.createPanel$lambda$10$lambda$7$lambda$6(this$0, $settings, $toLimitCheckBox, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$10$lambda$9$lambda$8(DSTablesSettingsState $settings, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Cell.comment$default((Cell)ButtonKt.bindSelected((Cell)$this$row.checkBox(DSTableBundle.message("settings.dataview.dg.local.filters.checkbox", new Object[0])), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl((Object)$settings){

            public Object get() {
                return ((DSTablesSettingsState)((Object)this.receiver)).getShowDGLocalFiltersInDataView();
            }

            public void set(Object value) {
                ((DSTablesSettingsState)((Object)this.receiver)).setShowDGLocalFiltersInDataView((Boolean)value);
            }
        })), (String)DSTableBundle.message("settings.dataview.dg.local.filters.comment", new Object[0]), (int)0, null, (int)6, null);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$10$lambda$9(DSTablesSettingsState $settings, Panel $this$group) {
        Intrinsics.checkNotNullParameter((Object)$this$group, (String)"$this$group");
        Panel.row$default((Panel)$this$group, null, arg_0 -> DSTablesSettingsConfigurable.createPanel$lambda$10$lambda$9$lambda$8($settings, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$10(DSTablesSettingsState $settings, Ref.ObjectRef $toLimitCheckBox, DSTablesSettingsConfigurable this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        $this$panel.row(DSTableBundle.message("settings.ds.table.column.statistics.row", new Object[0]), arg_0 -> DSTablesSettingsConfigurable.createPanel$lambda$10$lambda$3($settings, arg_0)).topGap(TopGap.MEDIUM);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> DSTablesSettingsConfigurable.createPanel$lambda$10$lambda$4($settings, arg_0), (int)1, null).topGap(TopGap.MEDIUM);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> DSTablesSettingsConfigurable.createPanel$lambda$10$lambda$5($toLimitCheckBox, $settings, arg_0), (int)1, null).topGap(TopGap.MEDIUM);
        $this$panel.indent(arg_0 -> DSTablesSettingsConfigurable.createPanel$lambda$10$lambda$7(this$0, $settings, $toLimitCheckBox, arg_0));
        Panel.group$default((Panel)$this$panel, (String)DSTableBundle.message("settings.dataview.group.name", new Object[0]), (boolean)false, arg_0 -> DSTablesSettingsConfigurable.createPanel$lambda$10$lambda$9($settings, arg_0), (int)2, null);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/scientific/tables/settings/ui/DSTablesSettingsConfigurable$Companion;", "", "<init>", "()V", "DS_TABLES_SETTINGS_ID", "", "DS_TABLES_SETTINGS_HELP_TOPIC", "intellij.scientific.tables"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[StatisticsPanelMode.values().length];
            try {
                nArray[StatisticsPanelMode.OFF.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StatisticsPanelMode.COMPACT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StatisticsPanelMode.DETAILED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

