package v1alpha1

// This file contains a collection of methods that can be used from go-restful to
// generate Swagger API documentation for its models. Please read this PR for more
// information on the implementation: https://github.com/emicklei/go-restful/pull/215
//
// TODOs are ignored from the parser (e.g. TODO(andronat):... || TODO:...) if and only if
// they are on one line! For multiple line or blocks that you want to ignore use ---.
// Any context after a --- is ignored.
//
// Those methods can be generated by using hack/update-swagger-docs.sh

// AUTO-GENERATED FUNCTIONS START HERE
var map_DataGather = map[string]string{
	"":       "\n\nDataGather provides data gather configuration options and status for the particular Insights data gathering.\n\nCompatibility level 4: No compatibility is provided, the API can change at any point for any reason. These capabilities should not be used by applications needing long term support.",
	"spec":   "spec holds user settable values for configuration",
	"status": "status holds observed values from the cluster. They may not be overridden.",
}

func (DataGather) SwaggerDoc() map[string]string {
	return map_DataGather
}

var map_DataGatherList = map[string]string{
	"": "DataGatherList is a collection of items\n\nCompatibility level 4: No compatibility is provided, the API can change at any point for any reason. These capabilities should not be used by applications needing long term support.",
}

func (DataGatherList) SwaggerDoc() map[string]string {
	return map_DataGatherList
}

var map_DataGatherSpec = map[string]string{
	"dataPolicy": "dataPolicy allows user to enable additional global obfuscation of the IP addresses and base domain in the Insights archive data. Valid values are \"ClearText\" and \"ObfuscateNetworking\". When set to ClearText the data is not obfuscated. When set to ObfuscateNetworking the IP addresses and the cluster domain name are obfuscated. When omitted, this means no opinion and the platform is left to choose a reasonable default, which is subject to change over time. The current default is ClearText.",
	"gatherers":  "gatherers is a list of gatherers configurations. The particular gatherers IDs can be found at https://github.com/openshift/insights-operator/blob/master/docs/gathered-data.md. Run the following command to get the names of last active gatherers: \"oc get insightsoperators.operator.openshift.io cluster -o json | jq '.status.gatherStatus.gatherers[].name'\"",
}

func (DataGatherSpec) SwaggerDoc() map[string]string {
	return map_DataGatherSpec
}

var map_DataGatherStatus = map[string]string{
	"conditions":        "conditions provide details on the status of the gatherer job.",
	"dataGatherState":   "dataGatherState reflects the current state of the data gathering process.",
	"gatherers":         "gatherers is a list of active gatherers (and their statuses) in the last gathering.",
	"startTime":         "startTime is the time when Insights data gathering started.",
	"finishTime":        "finishTime is the time when Insights data gathering finished.",
	"relatedObjects":    "relatedObjects is a list of resources which are useful when debugging or inspecting the data gathering Pod",
	"insightsRequestID": "insightsRequestID is an Insights request ID to track the status of the Insights analysis (in console.redhat.com processing pipeline) for the corresponding Insights data archive.",
	"insightsReport":    "insightsReport provides general Insights analysis results. When omitted, this means no data gathering has taken place yet or the corresponding Insights analysis (identified by \"insightsRequestID\") is not available.",
}

func (DataGatherStatus) SwaggerDoc() map[string]string {
	return map_DataGatherStatus
}

var map_GathererConfig = map[string]string{
	"":      "gathererConfig allows to configure specific gatherers",
	"name":  "name is the name of specific gatherer",
	"state": "state allows you to configure specific gatherer. Valid values are \"Enabled\", \"Disabled\" and omitted. When omitted, this means no opinion and the platform is left to choose a reasonable default. The current default is Enabled.",
}

func (GathererConfig) SwaggerDoc() map[string]string {
	return map_GathererConfig
}

var map_GathererStatus = map[string]string{
	"":                   "gathererStatus represents information about a particular data gatherer.",
	"conditions":         "conditions provide details on the status of each gatherer.",
	"name":               "name is the name of the gatherer.",
	"lastGatherDuration": "lastGatherDuration represents the time spent gathering.",
}

func (GathererStatus) SwaggerDoc() map[string]string {
	return map_GathererStatus
}

var map_HealthCheck = map[string]string{
	"":            "healthCheck represents an Insights health check attributes.",
	"description": "description provides basic description of the healtcheck.",
	"totalRisk":   "totalRisk of the healthcheck. Indicator of the total risk posed by the detected issue; combination of impact and likelihood. The values can be from 1 to 4, and the higher the number, the more important the issue.",
	"advisorURI":  "advisorURI provides the URL link to the Insights Advisor.",
	"state":       "state determines what the current state of the health check is. Health check is enabled by default and can be disabled by the user in the Insights advisor user interface.",
}

func (HealthCheck) SwaggerDoc() map[string]string {
	return map_HealthCheck
}

var map_InsightsReport = map[string]string{
	"":             "insightsReport provides Insights health check report based on the most recently sent Insights data.",
	"downloadedAt": "downloadedAt is the time when the last Insights report was downloaded. An empty value means that there has not been any Insights report downloaded yet and it usually appears in disconnected clusters (or clusters when the Insights data gathering is disabled).",
	"healthChecks": "healthChecks provides basic information about active Insights health checks in a cluster.",
	"uri":          "uri provides the URL link from which the report was downloaded.",
}

func (InsightsReport) SwaggerDoc() map[string]string {
	return map_InsightsReport
}

var map_ObjectReference = map[string]string{
	"":          "ObjectReference contains enough information to let you inspect or modify the referred object.",
	"group":     "group is the API Group of the Resource. Enter empty string for the core group. This value should consist of only lowercase alphanumeric characters, hyphens and periods. Example: \"\", \"apps\", \"build.openshift.io\", etc.",
	"resource":  "resource is the type that is being referenced. It is normally the plural form of the resource kind in lowercase. This value should consist of only lowercase alphanumeric characters and hyphens. Example: \"deployments\", \"deploymentconfigs\", \"pods\", etc.",
	"name":      "name of the referent.",
	"namespace": "namespace of the referent.",
}

func (ObjectReference) SwaggerDoc() map[string]string {
	return map_ObjectReference
}

// AUTO-GENERATED FUNCTIONS END HERE
