/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.ULogger;
import org.apache.log4j.helpers.QuietWriter;
import org.apache.log4j.spi.ComponentBase;
import org.apache.log4j.spi.ErrorHandler;
import org.apache.log4j.spi.LoggingEvent;

public class WriterAppender
extends AppenderSkeleton {
    protected boolean immediateFlush = true;
    protected String encoding;
    protected QuietWriter qw;

    public WriterAppender() {
        super(false);
    }

    public WriterAppender(Layout layout, OutputStream os) {
        this(layout, new OutputStreamWriter(os));
    }

    public WriterAppender(Layout layout, Writer writer) {
        super(false);
        this.layout = layout;
        this.setWriter(writer);
        this.activateOptions();
    }

    public void setImmediateFlush(boolean value) {
        this.immediateFlush = value;
    }

    public boolean getImmediateFlush() {
        return this.immediateFlush;
    }

    public void activateOptions() {
        int errors = 0;
        if (this.layout == null) {
            this.getLogger().error((Object)"No layout set for the appender named [{}].", this.name);
            ++errors;
        }
        if (this.qw == null) {
            this.getLogger().error((Object)"No writer set for the appender named [{}].", this.name);
            ++errors;
        }
        if (errors == 0) {
            super.activateOptions();
        }
    }

    public void append(LoggingEvent event) {
        if (!this.checkEntryConditions()) {
            return;
        }
        this.subAppend(event);
    }

    protected boolean checkEntryConditions() {
        if (this.closed) {
            this.getNonFloodingLogger().warn("Not allowed to write to a closed appender.");
            return false;
        }
        if (this.qw == null) {
            this.getNonFloodingLogger().error((Object)"No output stream or file set for the appender named [{}].", this.name);
            return false;
        }
        return true;
    }

    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.closeWriter();
    }

    protected void closeWriter() {
        if (this.qw != null) {
            try {
                this.writeFooter();
                this.qw.close();
                this.qw = null;
            }
            catch (IOException e) {
                this.getLogger().error((Object)("Could not close writer for WriterAppener named " + this.name), e);
            }
        }
    }

    protected OutputStreamWriter createWriter(OutputStream os) {
        OutputStreamWriter retval = null;
        String enc = this.getEncoding();
        if (enc != null) {
            try {
                retval = new OutputStreamWriter(os, enc);
            }
            catch (IOException e) {
                this.getLogger().warn("Error initializing output writer.");
                this.getLogger().warn("Unsupported encoding?");
            }
        }
        if (retval == null) {
            retval = new OutputStreamWriter(os);
        }
        return retval;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String value) {
        this.encoding = value;
    }

    public synchronized void setErrorHandler(ErrorHandler eh) {
        if (eh == null) {
            this.getLogger().warn("You have tried to set a null error-handler.");
        } else {
            this.errorHandler = eh;
            if (this.qw != null) {
                this.qw.setErrorHandler(eh);
            }
        }
    }

    protected QuietWriter createQuietWriter(Writer writer) {
        ErrorHandler handler = this.errorHandler;
        if (handler == null) {
            handler = new DefaultErrorHandler(this);
        }
        return new QuietWriter(writer, handler);
    }

    public synchronized void setWriter(Writer writer) {
        this.closeWriter();
        this.qw = this.createQuietWriter(writer);
        this.writeHeader();
    }

    protected void subAppend(LoggingEvent event) {
        String[] s;
        if (!this.isActive()) {
            return;
        }
        this.qw.write(this.layout.format(event));
        if (this.layout.ignoresThrowable() && (s = event.getThrowableStrRep()) != null) {
            int len = s.length;
            int i = 0;
            while (i < len) {
                this.qw.write(s[i]);
                this.qw.write(Layout.LINE_SEP);
                ++i;
            }
        }
        if (this.immediateFlush) {
            this.qw.flush();
        }
    }

    public boolean requiresLayout() {
        return true;
    }

    protected void reset() {
        this.closeWriter();
        this.qw = null;
    }

    protected void writeFooter() {
        String f;
        if (this.layout != null && (f = this.layout.getFooter()) != null && this.qw != null) {
            this.qw.write(f);
            this.qw.flush();
        }
    }

    protected void writeHeader() {
        String h;
        if (this.layout != null && (h = this.layout.getHeader()) != null && this.qw != null) {
            this.qw.write(h);
        }
    }

    static /* synthetic */ ULogger access$001(WriterAppender x0) {
        return x0.getNonFloodingLogger();
    }

    private static final class DefaultErrorHandler
    implements ErrorHandler {
        private final WriterAppender appender;

        public DefaultErrorHandler(WriterAppender appender) {
            this.appender = appender;
        }

        public void setLogger(Logger logger) {
        }

        public void error(String message, Exception ioe, int errorCode) {
            this.appender.active = false;
            ComponentBase.access$001((WriterAppender)this.appender).error((Object)("IO failure for appender named " + this.appender.getName()), ioe);
        }

        public void error(String message) {
        }

        public void error(String message, Exception e, int errorCode, LoggingEvent event) {
        }

        public void setAppender(Appender appender) {
        }

        public void setBackupAppender(Appender appender) {
        }

        public void activateOptions() {
        }
    }
}

