char tcl_gui[] = "\
#\n\
#    This file is part of tk707.\n\
#\n\
#    Copyright (C) 2000, 2001, 2002, 2003, 2004 Chris Willing and Pierre Saramito \n\
#\n\
#    tk707 is free software; you can redistribute it and/or modify\n\
#    it under the terms of the GNU General Public License as published by\n\
#    the Free Software Foundation; either version 2 of the License, or\n\
#    (at your option) any later version.\n\
#\n\
#    Foobar is distributed in the hope that it will be useful,\n\
#    but WITHOUT ANY WARRANTY; without even the implied warranty of\n\
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n\
#    GNU General Public License for more details.\n\
#\n\
#    You should have received a copy of the GNU General Public License\n\
#    along with Foobar; if not, write to the Free Software\n\
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA\n\
#\n\
# =========================================================================\n\
#	File gui.tcl\n\
#	GUI for TK-707\n\
# =========================================================================\n\
eval destroy [winfo child .]\n\
wm title . \"TK-707\"\n\
set font {Helvetica 14}\n\
wm iconify .\n\
# -------------------------------------------------------------------------\n\
# menu bar\n\
# -------------------------------------------------------------------------\n\
frame .mbar -borderwidth 1p -relief raised\n\
pack .mbar -fill x\n\
\n\
menubutton .mbar.file -text \"File\" -menu .mbar.file.m\n\
menubutton .mbar.midi -text \"Midi\" -menu .mbar.midi.m\n\
menubutton .mbar.map  -text \"Map\"  -menu .mbar.map.m\n\
pack .mbar.file -side left\n\
pack .mbar.midi -side left\n\
pack .mbar.map  -side left\n\
\n\
menubutton .mbar.help -text \"Help\"  -menu .mbar.help.m \n\
pack .mbar.help  -side right\n\
\n\
# -----------------------------------------------------------------------------\n\
# file menu\n\
# -----------------------------------------------------------------------------\n\
menu .mbar.file.m -tearoff 0\n\
.mbar.file.m add command -label \"Load Data\" -command {load_data_file \".\"}   	\\\n\
					    -underline 0 		    	\\\n\
        				    -accelerator \"Ctrl-O\"\n\
.mbar.file.m add command -label \"Load Demo\" -command {load_data_file $PKGDATADIR} \\\n\
					    -underline 0\n\
.mbar.file.m add command -label \"Save Data\" -command {save_data_file} 		\\\n\
					    -underline 0 			\\\n\
					    -accelerator \"Ctrl-S\"\n\
.mbar.file.m add command -label \"Ports\"     -command {port_setup} 		\\\n\
					    -underline 0\n\
.mbar.file.m add command -label \"Quit\"      -command \"exit\" 			\\\n\
					    -underline 0 			\\\n\
					    -accelerator \"Ctrl-Q\"\n\
\n\
bind . <Control-q> { exit;}\n\
bind . <Control-o> { load_data_file \".\";}\n\
bind . <Control-s> { save_data_file;}\n\
\n\
# -----------------------------------------------------------------------------\n\
# midi & map menus\n\
# -----------------------------------------------------------------------------\n\
menu .mbar.midi.m -tearoff 0\n\
menu .mbar.map.m  -tearoff 0\n\
\n\
.mbar.midi.m add command -label \"Save Midi Track\"  -command {save_midi_file} -underline 0\n\
.mbar.midi.m add command -label \"Set MIDI Channel\" -command {ac_midi} -underline 0\n\
\n\
\n\
.mbar.map.m add command -label \"Load Standard Sound Map\" -command {load_sound_map $PKGDATADIR} -underline 0\n\
.mbar.map.m add command -label \"Load Local Sound Map\" -command {load_sound_map \".\"} -underline 0\n\
.mbar.map.m add command -label \"Save Sound Map\" -command {save_sound_map} -underline 0\n\
.mbar.map.m add command -label \"Edit Sound Map\" -command {map_edit} -underline 0\n\
.mbar.map.m add command -label \"Edit Fader Map\" -command {fader_edit} -underline 0\n\
\n\
# TODO: next will put names on patterns for automatic score generation...\n\
# menu .mbar.pattern -tearoff 0\n\
# .mbar add cascade -menu .mbar.pattern -label \"Pattern\" -underline 0\n\
# .mbar.pattern add command -label \"Edit Comment\" -command {edit_pattern_comment} -underline 0\n\
\n\
# -----------------------------------------------------------------------------\n\
# help menu\n\
# -----------------------------------------------------------------------------\n\
menu .mbar.help.m -tearoff 0\n\
\n\
.mbar.help.m add command -label \"About\"         -command {about}      -underline 0\n\
.mbar.help.m add command -label \"User's Manual\" -command {UserManual} -underline 0\n\
\n\
\n\
. configure -menu .mbar\n\
\n\
# =========================================================================\n\
# Frame for Grid & Volume controls\n\
# =========================================================================\n\
set grid_vols .gv\n\
eval frame $grid_vols $debug_relief\n\
pack $grid_vols -anchor c\n\
# --------------------------------------------------------------------------\n\
# Grid Display\n\
# --------------------------------------------------------------------------\n\
set display $grid_vols.d\n\
frame $display -relief groove -borderwidth 2p\n\
pack $display -side left\n\
frame $display.g\n\
pack $display.g ;#-side left\n\
set gridlabel $display.g.l		;	# Instrument label\n\
canvas $gridlabel -width 3c -height 9.0c\n\
set grid $display.g.c			;	# Pattern Grid\n\
canvas $grid -width 8.5c -height 9.0c\n\
pack $gridlabel $grid -side left\n\
# --------------------------------------------------------------------------\n\
# Status area\n\
# --------------------------------------------------------------------------\n\
set infosection $display.i		;	# to contain Tempo, Track & Mode widgets\n\
frame $infosection\n\
pack $infosection -side bottom\n\
set tempoinfo $infosection.t\n\
set tminfo $infosection.tm\n\
frame $tminfo\n\
canvas $tempoinfo -width 4c -height 2c -relief groove -borderwidth 2\n\
canvas $tminfo.t -width 7.5c -height 0.75c -relief groove -borderwidth 2\n\
canvas $tminfo.m -width 7.5c -height 1.25c -relief groove -borderwidth 2\n\
pack $tminfo.t $tminfo.m\n\
pack $tempoinfo $tminfo -side left -expand true -fill y\n\
# --------------------------------------------------------------------------\n\
# Volume controls\n\
# --------------------------------------------------------------------------\n\
set vcunit $grid_vols.cu\n\
eval frame $vcunit $debug_relief\n\
pack $vcunit -side left\n\
#\n\
# Controls + Notes Staff\n\
#\n\
set ctrls_notes_staff .cns\n\
frame $ctrls_notes_staff\n\
pack $ctrls_notes_staff -expand true -fill x\n\
# ==========================================================================\n\
# Controls\n\
# ==========================================================================\n\
set ctrl_height  4.0;\n\
set ctrls $ctrls_notes_staff.c\n\
frame $ctrls\n\
pack $ctrls -side top -expand true -fill x\n\
# ---------------------------------------\n\
# Scale lamps + Score + Notes/Instruments\n\
# ---------------------------------------\n\
set notes_staff $ctrls_notes_staff.ns\n\
frame $notes_staff\n\
pack $notes_staff -anchor s\n\
# ---------------------------------------\n\
# Transport control (Start/Cont)\n\
# ---------------------------------------\n\
set    stop_box $ctrls.stop_box\n\
eval canvas $stop_box -width 2.3c -height ${ctrl_height}c $debug_relief;\n\
pack   $stop_box -side left -anchor n ;\n\
set button_stop  $stop_box.stop\n\
label $stop_box.lt  -text STOP/CONT -font *-${boldfont13}-*\n\
radiobutton $button_stop -bitmap nix -width 1.45c -height 2.6c    \\\n\
        -variable ss -value stop -indicatoron false     \\\n\
        -bg $tkxox(but_grey) -activebackground $tkxox(but_grey_active)  \\\n\
        -selectcolor $tkxox(but_grey_active)    \\\n\
        -command \"ac_stopgo $tkxox(CONT)\"\n\
$stop_box  create window 1.25c 0.4c -window $stop_box.lt\n\
$stop_box  create window 1.25c 2.2c -window $button_stop\n\
bind all <space> {\n\
        if {$mode(stopgo) == $tkxox(START)} {\n\
                $button_stop invoke\n\
        } else {\n\
                ac_stopgo $tkxox(START)\n\
                $button_start invoke\n\
        }\n\
}\n\
#\n\
# Transport control (start)\n\
#\n\
set     start_box $notes_staff.start_box\n\
canvas $start_box -width 2.3c -height 4.5c ;#-relief groove -borderwidth 4\n\
pack   $start_box -side left -anchor n ;#-expand true -fill y\n\
set button_start $start_box.start\n\
label $start_box.lb -text START     -font *-${boldfont13}-*\n\
radiobutton $button_start -bitmap nix -width 1.45c -height 2.6c   \\\n\
        -variable ss -value start -indicatoron false    \\\n\
        -bg $tkxox(but_grey) -activebackground $tkxox(but_grey_active)  \\\n\
        -selectcolor $tkxox(but_grey_active)\n\
$start_box create window 1.25c 0.4c -window $start_box.lb\n\
$start_box create window 1.25c 2.1c -window $button_start\n\
bind $button_start <1> {ac_stopgo $tkxox(START)}\n\
# ================================================================\n\
# button controls\n\
# ================================================================\n\
set space_width  2.8;\n\
set misc_width   5.0;\n\
set st_width     4.0;\n\
set trpa_width   3.0;\n\
set grp_width    5.0;\n\
set accent_width 2.6;\n\
#\n\
# Empty Space : adjust vectical alignment with score\n\
#\n\
set empty_case $ctrls.z\n\
eval canvas $empty_case -width ${space_width}c -height ${ctrl_height}c \\\n\
	$debug_relief;\n\
pack   $empty_case -side left -anchor nw ;\n\
#\n\
# Clear/Scale/Last Step/Instrument Guide\n\
#\n\
set misc $ctrls.misc\n\
eval canvas $misc -width ${misc_width}c -height ${ctrl_height}c $debug_relief;\n\
pack $misc -side left -anchor n\n\
#\n\
# Shuffle/Flam Tempo/Measure controls\n\
#\n\
set st $ctrls.st\n\
eval canvas $st -width ${st_width}c -height ${ctrl_height}c $debug_relief;\n\
pack $st -side left -anchor n\n\
#\n\
# Track/Pattern Read/Write Control\n\
#\n\
set trpa $ctrls.trpa\n\
eval canvas $trpa -width 3c -height ${ctrl_height}c $debug_relief;\n\
pack $trpa -side left -anchor n\n\
#\n\
# Pattern Group & Track Number selection\n\
#\n\
set grps $ctrls.grps\n\
eval canvas $grps  -width 5c -height ${ctrl_height}c $debug_relief;\n\
pack $grps -side left -anchor n\n\
#\n\
# Accent/Enter\n\
#\n\
set accenter $ctrls.accenter\n\
eval canvas $accenter -width 2.6c -height ${ctrl_height}c $debug_relief;\n\
pack $accenter -side left -anchor n\n\
#\n\
# Tempo Dial\n\
#\n\
set dial $ctrls.dial\n\
eval frame $dial $debug_relief\n\
pack $dial -side left -expand true;\n\
# ---------------------------\n\
# Score + Notes/Instruments\n\
# ---------------------------\n\
set note_score $notes_staff.sc\n\
eval frame $note_score $debug_relief;\n\
pack $note_score\n\
# ---------------------------\n\
# Notes/Instruments\n\
# ---------------------------\n\
set notes $notes_staff.n;\n\
eval frame $notes $debug_relief;\n\
pack $notes -anchor w -side left\n\
";
