package codeup

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListOrganizationSecurityScores invokes the codeup.ListOrganizationSecurityScores API synchronously
func (client *Client) ListOrganizationSecurityScores(request *ListOrganizationSecurityScoresRequest) (response *ListOrganizationSecurityScoresResponse, err error) {
	response = CreateListOrganizationSecurityScoresResponse()
	err = client.DoAction(request, response)
	return
}

// ListOrganizationSecurityScoresWithChan invokes the codeup.ListOrganizationSecurityScores API asynchronously
func (client *Client) ListOrganizationSecurityScoresWithChan(request *ListOrganizationSecurityScoresRequest) (<-chan *ListOrganizationSecurityScoresResponse, <-chan error) {
	responseChan := make(chan *ListOrganizationSecurityScoresResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListOrganizationSecurityScores(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListOrganizationSecurityScoresWithCallback invokes the codeup.ListOrganizationSecurityScores API asynchronously
func (client *Client) ListOrganizationSecurityScoresWithCallback(request *ListOrganizationSecurityScoresRequest, callback func(response *ListOrganizationSecurityScoresResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListOrganizationSecurityScoresResponse
		var err error
		defer close(result)
		response, err = client.ListOrganizationSecurityScores(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListOrganizationSecurityScoresRequest is the request struct for api ListOrganizationSecurityScores
type ListOrganizationSecurityScoresRequest struct {
	*requests.RoaRequest
	AccessToken string `position:"Query" name:"AccessToken"`
}

// ListOrganizationSecurityScoresResponse is the response struct for api ListOrganizationSecurityScores
type ListOrganizationSecurityScoresResponse struct {
	*responses.BaseResponse
	ErrorCode    string       `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage string       `json:"ErrorMessage" xml:"ErrorMessage"`
	RequestId    string       `json:"RequestId" xml:"RequestId"`
	Success      bool         `json:"Success" xml:"Success"`
	Result       []ResultItem `json:"Result" xml:"Result"`
}

// CreateListOrganizationSecurityScoresRequest creates a request to invoke ListOrganizationSecurityScores API
func CreateListOrganizationSecurityScoresRequest() (request *ListOrganizationSecurityScoresRequest) {
	request = &ListOrganizationSecurityScoresRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("codeup", "2020-04-14", "ListOrganizationSecurityScores", "/api/v4/organization/security/scores", "", "")
	request.Method = requests.GET
	return
}

// CreateListOrganizationSecurityScoresResponse creates a response to parse from ListOrganizationSecurityScores response
func CreateListOrganizationSecurityScoresResponse() (response *ListOrganizationSecurityScoresResponse) {
	response = &ListOrganizationSecurityScoresResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
