package cr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateUserInfo invokes the cr.CreateUserInfo API synchronously
func (client *Client) CreateUserInfo(request *CreateUserInfoRequest) (response *CreateUserInfoResponse, err error) {
	response = CreateCreateUserInfoResponse()
	err = client.DoAction(request, response)
	return
}

// CreateUserInfoWithChan invokes the cr.CreateUserInfo API asynchronously
func (client *Client) CreateUserInfoWithChan(request *CreateUserInfoRequest) (<-chan *CreateUserInfoResponse, <-chan error) {
	responseChan := make(chan *CreateUserInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateUserInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateUserInfoWithCallback invokes the cr.CreateUserInfo API asynchronously
func (client *Client) CreateUserInfoWithCallback(request *CreateUserInfoRequest, callback func(response *CreateUserInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateUserInfoResponse
		var err error
		defer close(result)
		response, err = client.CreateUserInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateUserInfoRequest is the request struct for api CreateUserInfo
type CreateUserInfoRequest struct {
	*requests.RoaRequest
}

// CreateUserInfoResponse is the response struct for api CreateUserInfo
type CreateUserInfoResponse struct {
	*responses.BaseResponse
}

// CreateCreateUserInfoRequest creates a request to invoke CreateUserInfo API
func CreateCreateUserInfoRequest() (request *CreateUserInfoRequest) {
	request = &CreateUserInfoRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("cr", "2016-06-07", "CreateUserInfo", "/users", "acr", "openAPI")
	request.Method = requests.PUT
	return
}

// CreateCreateUserInfoResponse creates a response to parse from CreateUserInfo response
func CreateCreateUserInfoResponse() (response *CreateUserInfoResponse) {
	response = &CreateUserInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
