package cs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UnInstallClusterAddons invokes the cs.UnInstallClusterAddons API synchronously
func (client *Client) UnInstallClusterAddons(request *UnInstallClusterAddonsRequest) (response *UnInstallClusterAddonsResponse, err error) {
	response = CreateUnInstallClusterAddonsResponse()
	err = client.DoAction(request, response)
	return
}

// UnInstallClusterAddonsWithChan invokes the cs.UnInstallClusterAddons API asynchronously
func (client *Client) UnInstallClusterAddonsWithChan(request *UnInstallClusterAddonsRequest) (<-chan *UnInstallClusterAddonsResponse, <-chan error) {
	responseChan := make(chan *UnInstallClusterAddonsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UnInstallClusterAddons(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UnInstallClusterAddonsWithCallback invokes the cs.UnInstallClusterAddons API asynchronously
func (client *Client) UnInstallClusterAddonsWithCallback(request *UnInstallClusterAddonsRequest, callback func(response *UnInstallClusterAddonsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UnInstallClusterAddonsResponse
		var err error
		defer close(result)
		response, err = client.UnInstallClusterAddons(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UnInstallClusterAddonsRequest is the request struct for api UnInstallClusterAddons
type UnInstallClusterAddonsRequest struct {
	*requests.RoaRequest
	ClusterId string `position:"Path" name:"ClusterId"`
}

// UnInstallClusterAddonsResponse is the response struct for api UnInstallClusterAddons
type UnInstallClusterAddonsResponse struct {
	*responses.BaseResponse
}

// CreateUnInstallClusterAddonsRequest creates a request to invoke UnInstallClusterAddons API
func CreateUnInstallClusterAddonsRequest() (request *UnInstallClusterAddonsRequest) {
	request = &UnInstallClusterAddonsRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("CS", "2015-12-15", "UnInstallClusterAddons", "/clusters/[ClusterId]/components/uninstall", "", "")
	request.Method = requests.POST
	return
}

// CreateUnInstallClusterAddonsResponse creates a response to parse from UnInstallClusterAddons response
func CreateUnInstallClusterAddonsResponse() (response *UnInstallClusterAddonsResponse) {
	response = &UnInstallClusterAddonsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
