/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.app.DBPResourceHandler;
import org.jkiss.dbeaver.model.app.DBPResourceHandlerDescriptor;
import org.jkiss.dbeaver.model.app.DBPResourceTypeDescriptor;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;
import org.jkiss.dbeaver.registry.ResourceTypeRegistry;
import org.jkiss.utils.ArrayUtils;

public class ResourceHandlerDescriptor
extends AbstractDescriptor
implements DBPResourceHandlerDescriptor {
    private static final Log log = Log.getLog(ResourceHandlerDescriptor.class);
    public static final String EXTENSION_ID = "org.jkiss.dbeaver.resourceHandler";
    private final String typeId;
    private AbstractDescriptor.ObjectType handlerType;
    private DBPResourceHandler handler;

    public ResourceHandlerDescriptor(IConfigurationElement config) {
        super(config);
        this.typeId = config.getAttribute("type");
        this.handlerType = new AbstractDescriptor.ObjectType((AbstractDescriptor)this, config.getAttribute("class"));
    }

    public void dispose() {
        this.handler = null;
        this.handlerType = null;
    }

    public String getTypeId() {
        return this.typeId;
    }

    @Override
    @NotNull
    public DBPResourceTypeDescriptor getResourceType() {
        return ResourceTypeRegistry.getInstance().getResourceType(this.typeId);
    }

    @Override
    @Nullable
    public synchronized DBPResourceHandler getHandler() {
        if (this.handler == null) {
            Class clazz = this.handlerType.getObjectClass(DBPResourceHandler.class);
            if (clazz == null) {
                return null;
            }
            try {
                this.handler = (DBPResourceHandler)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                log.error((Object)"Can't instantiate resource handler", (Throwable)e);
            }
        }
        return this.handler;
    }

    public boolean isDefault() {
        return "default".equals(this.typeId);
    }

    public boolean canHandle(IResource resource) {
        return this.canHandle(resource, false);
    }

    public boolean canHandle(IResource resource, boolean testContent) {
        if (this.isDefault()) {
            return false;
        }
        DBPResourceTypeDescriptor resourceType = this.getResourceType();
        return resourceType != null && this.isApplicableTo(resourceType, resource, testContent);
    }

    public String toString() {
        return this.typeId;
    }

    public boolean isApplicableTo(DBPResourceTypeDescriptor resourceType, @NotNull IResource resource, boolean testContent) {
        if (!resourceType.getContentTypes().isEmpty() && resource instanceof IFile) {
            if (testContent) {
                try {
                    IContentType fileContentType;
                    IContentDescription contentDescription = ((IFile)resource).getContentDescription();
                    if (contentDescription != null && (fileContentType = contentDescription.getContentType()) != null && resourceType.getContentTypes().contains(fileContentType)) {
                        return true;
                    }
                }
                catch (CoreException e) {
                    log.debug((Object)("Can't obtain content description for '" + resource.getName() + "'"), (Throwable)e);
                }
            }
            String fileExtension = resource.getFileExtension();
            for (IContentType contentType : resourceType.getContentTypes()) {
                Object[] ctExtensions = contentType.getFileSpecs(8);
                if (ArrayUtils.isEmpty((Object[])ctExtensions)) continue;
                Object[] objectArray = ctExtensions;
                int n = ctExtensions.length;
                int n2 = 0;
                while (n2 < n) {
                    Object ext = objectArray[n2];
                    if (((String)ext).equalsIgnoreCase(fileExtension)) {
                        return true;
                    }
                    ++n2;
                }
            }
        }
        if (!resourceType.getResourceTypes().isEmpty()) {
            for (AbstractDescriptor.ObjectType objectType : resourceType.getResourceTypes()) {
                if (!objectType.appliesTo((Object)resource, null)) continue;
                return true;
            }
        }
        return false;
    }
}

