/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.tokenizer;

import com.hankcs.hanlp.HanLP;
import com.hankcs.hanlp.dictionary.stopword.CoreStopWordDictionary;
import com.hankcs.hanlp.dictionary.stopword.Filter;
import com.hankcs.hanlp.seg.Segment;
import com.hankcs.hanlp.seg.common.Term;
import java.util.List;
import java.util.ListIterator;

public class NotionalTokenizer {
    public static Segment SEGMENT = HanLP.newSegment();

    public static List<Term> segment(String text) {
        return NotionalTokenizer.segment(text.toCharArray());
    }

    public static List<Term> segment(char[] text) {
        List<Term> resultList = SEGMENT.seg(text);
        ListIterator<Term> listIterator = resultList.listIterator();
        while (listIterator.hasNext()) {
            if (CoreStopWordDictionary.shouldInclude(listIterator.next())) continue;
            listIterator.remove();
        }
        return resultList;
    }

    public static List<List<Term>> seg2sentence(String text) {
        List<List<Term>> sentenceList = SEGMENT.seg2sentence(text);
        for (List<Term> sentence : sentenceList) {
            ListIterator<Term> listIterator = sentence.listIterator();
            while (listIterator.hasNext()) {
                if (CoreStopWordDictionary.shouldInclude(listIterator.next())) continue;
                listIterator.remove();
            }
        }
        return sentenceList;
    }

    public static List<List<Term>> seg2sentence(String text, boolean shortest) {
        return SEGMENT.seg2sentence(text, shortest);
    }

    public static List<List<Term>> seg2sentence(String text, Filter ... filterArrayChain) {
        List<List<Term>> sentenceList = SEGMENT.seg2sentence(text);
        for (List<Term> sentence : sentenceList) {
            ListIterator<Term> listIterator = sentence.listIterator();
            block1: while (listIterator.hasNext()) {
                if (filterArrayChain == null) continue;
                Term term = listIterator.next();
                for (Filter filter : filterArrayChain) {
                    if (filter.shouldInclude(term)) continue;
                    listIterator.remove();
                    continue block1;
                }
            }
        }
        return sentenceList;
    }
}

