/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.citeproc.csl.internal;

import de.undercouch.citeproc.csl.internal.SBibliography;
import de.undercouch.citeproc.csl.internal.SCitation;
import de.undercouch.citeproc.csl.internal.SMacro;
import de.undercouch.citeproc.csl.internal.locale.LLocale;
import de.undercouch.citeproc.csl.internal.rendering.SNameInheritableAttributes;
import de.undercouch.citeproc.helper.NodeHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SStyle {
    private final String defaultLocale;
    private final List<LLocale> locales;
    private final SCitation citation;
    private final SBibliography bibliography;
    private final Map<String, SMacro> macros = new HashMap<String, SMacro>();
    private final SNameInheritableAttributes inheritableNameAttributes;
    private final String pageRangeFormat;

    public SStyle(Document styleDocument) {
        ArrayList<LLocale> locales = new ArrayList<LLocale>();
        SCitation citation = null;
        SBibliography bibl = null;
        Element styleRoot = styleDocument.getDocumentElement();
        NodeList styleChildren = styleRoot.getChildNodes();
        block12: for (int i = 0; i < styleChildren.getLength(); ++i) {
            String nodeName;
            Node c = styleChildren.item(i);
            switch (nodeName = c.getNodeName()) {
                case "locale": {
                    locales.add(new LLocale(c));
                    continue block12;
                }
                case "citation": {
                    citation = new SCitation(c);
                    continue block12;
                }
                case "bibliography": {
                    bibl = new SBibliography(c);
                    continue block12;
                }
                case "macro": {
                    SMacro m = new SMacro(c);
                    if (m.getName() == null || m.getName().isEmpty()) continue block12;
                    this.macros.put(m.getName(), m);
                }
            }
        }
        this.locales = locales;
        this.citation = citation;
        this.bibliography = bibl;
        this.inheritableNameAttributes = new SNameInheritableAttributes(styleRoot);
        this.pageRangeFormat = NodeHelper.getAttrValue(styleRoot, "page-range-format");
        this.defaultLocale = NodeHelper.getAttrValue(styleRoot, "default-locale");
    }

    public String getDefaultLocale() {
        return this.defaultLocale;
    }

    public List<LLocale> getLocales() {
        return this.locales;
    }

    public SCitation getCitation() {
        return this.citation;
    }

    public SBibliography getBibliography() {
        return this.bibliography;
    }

    public Map<String, SMacro> getMacros() {
        return this.macros;
    }

    public SNameInheritableAttributes getInheritableNameAttributes() {
        return this.inheritableNameAttributes;
    }

    public String getPageRangeFormat() {
        return this.pageRangeFormat;
    }
}

